/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.cff;

import com.kreative.cff.Chunk;
import com.kreative.cff.FieldSpec;
import com.kreative.cff.FieldType;
import com.kreative.cff.Header;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

public class ChunkSpec
extends Vector<FieldSpec> {
    private static final long serialVersionUID = 1L;
    private boolean evenPadded;

    public ChunkSpec() {
        this.evenPadded = false;
    }

    public ChunkSpec(FieldSpec[] a) {
        super(Arrays.asList(a));
        this.evenPadded = false;
    }

    public ChunkSpec(Collection<? extends FieldSpec> c) {
        super(c);
        this.evenPadded = false;
    }

    public ChunkSpec(boolean evenPadded) {
        this.evenPadded = evenPadded;
    }

    public ChunkSpec(FieldSpec[] a, boolean evenPadded) {
        super(Arrays.asList(a));
        this.evenPadded = evenPadded;
    }

    public ChunkSpec(Collection<? extends FieldSpec> c, boolean evenPadded) {
        super(c);
        this.evenPadded = evenPadded;
    }

    public ChunkSpec(String spec) {
        String[] things;
        this.evenPadded = false;
        String[] stringArray = things = spec.trim().split("[ .,-]+");
        int n = things.length;
        int n2 = 0;
        while (n2 < n) {
            String thing = stringArray[n2];
            if ((thing = thing.trim()).equalsIgnoreCase("e") || thing.equalsIgnoreCase("even") || thing.equalsIgnoreCase("evenpadded")) {
                this.evenPadded = true;
            } else if (thing.length() > 0) {
                this.add(new FieldSpec(thing));
            }
            ++n2;
        }
    }

    public ChunkSpec(byte[] spec, int index) {
        this.evenPadded = (spec[index] & 0x80) != 0;
        int n = spec[index] & 0x7F;
        int i = 0;
        while (i < n) {
            this.add(new FieldSpec(spec[++index]));
            ++i;
        }
    }

    public boolean evenPadded() {
        return this.evenPadded;
    }

    public boolean containsType(FieldType ft) {
        for (FieldSpec fs : this) {
            if (fs.type() != ft) continue;
            return true;
        }
        return false;
    }

    public FieldSpec getField(FieldType ft) {
        for (FieldSpec fs : this) {
            if (fs.type() != ft) continue;
            return fs;
        }
        return null;
    }

    public int byteCount() {
        int cnt = 0;
        for (FieldSpec f : this) {
            cnt += f.byteCount();
        }
        return cnt;
    }

    public int bitCount() {
        int cnt = 0;
        for (FieldSpec f : this) {
            cnt += f.bitCount();
        }
        return cnt;
    }

    public String stringRepresentation() {
        String s = "";
        for (FieldSpec fs : this) {
            s = String.valueOf(s) + "." + fs.stringRepresentation();
        }
        if (this.evenPadded) {
            s = String.valueOf(s) + ".e";
        }
        return s.length() >= 1 ? s.substring(1) : s;
    }

    public byte[] bitPatternRepresentation() {
        byte[] bp = new byte[this.size() + 1];
        bp[0] = (byte)(this.size() & 0x7F);
        if (this.evenPadded) {
            bp[0] = (byte)(bp[0] | 0x80);
        }
        int idx = 1;
        for (FieldSpec fs : this) {
            bp[idx++] = fs.bitPatternRepresentation();
        }
        return bp;
    }

    public Header createHeader() {
        Header h = new Header();
        for (FieldSpec fs : this) {
            switch (fs.size()) {
                case LONG: {
                    h.put(fs.type(), 0L);
                    break;
                }
                case MEDIUM: {
                    h.put(fs.type(), 0);
                    break;
                }
                case SHORT: {
                    h.put(fs.type(), (short)0);
                    break;
                }
                case BYTE: {
                    h.put(fs.type(), (byte)0);
                }
            }
        }
        return h;
    }

    public Header readHeader(DataInput in) throws IOException {
        Header h = new Header();
        Number lastSize = 0;
        for (FieldSpec f : this) {
            if (f.nativeType() == null) {
                in.skipBytes((int)lastSize);
                if (!this.evenPadded || ((Number)lastSize).longValue() % 2L != 1L) continue;
                in.readByte();
                continue;
            }
            Number n = f.read(in);
            if (f.type().equals((Object)FieldType.SIZE_WITHOUT_HEADER)) {
                if (n.longValue() < 0L) {
                    throw new IOException("Negative Size");
                }
                lastSize = n;
            } else if (f.type().equals((Object)FieldType.SIZE_WITH_HEADER)) {
                if (n.longValue() < (long)this.byteCount()) {
                    throw new IOException("Negative Size");
                }
                lastSize = n.longValue() - (long)this.byteCount();
            }
            h.put(f.type(), n);
        }
        return h;
    }

    public Chunk readChunk(DataInput in) throws IOException {
        Header h = new Header();
        Number lastSize = 0;
        byte[] d = new byte[]{};
        for (FieldSpec f : this) {
            if (f.nativeType() == null) {
                d = new byte[((Number)lastSize).intValue()];
                in.readFully(d);
                if (!this.evenPadded || ((Number)lastSize).longValue() % 2L != 1L) continue;
                in.readByte();
                continue;
            }
            Number n = f.read(in);
            if (f.type().equals((Object)FieldType.SIZE_WITHOUT_HEADER)) {
                if (n.longValue() < 0L) {
                    throw new IOException("Negative Size");
                }
                lastSize = n;
            } else if (f.type().equals((Object)FieldType.SIZE_WITH_HEADER)) {
                if (n.longValue() < (long)this.byteCount()) {
                    throw new IOException("Negative Size");
                }
                lastSize = n.longValue() - (long)this.byteCount();
            }
            h.put(f.type(), n);
        }
        return new Chunk(h, d);
    }

    public void writeHeader(DataOutput out, Header h) throws IOException {
        Number lastSize = 0;
        for (FieldSpec f : this) {
            if (f.nativeType() == null) {
                out.write(new byte[((Number)lastSize).intValue()]);
                if (!this.evenPadded || ((Number)lastSize).longValue() % 2L != 1L) continue;
                out.writeByte(0);
                continue;
            }
            Number n = (Number)h.get((Object)f.type());
            if (f.type().equals((Object)FieldType.SIZE_WITHOUT_HEADER)) {
                if (n.longValue() < 0L) {
                    throw new IllegalArgumentException("Negative Size");
                }
                lastSize = n;
            } else if (f.type().equals((Object)FieldType.SIZE_WITH_HEADER)) {
                if (n.longValue() < (long)this.byteCount()) {
                    throw new IllegalArgumentException("Negative Size");
                }
                lastSize = n.longValue() - (long)this.byteCount();
            }
            f.write(out, n);
        }
    }

    public void writeChunk(DataOutput out, Chunk ch) throws IOException {
        Header h = ch.getHeader();
        for (FieldSpec f : this) {
            Number n;
            if (f.nativeType() == null) {
                out.write(ch.getData());
                if (!this.evenPadded || ch.getData().length % 2 != 1) continue;
                out.writeByte(0);
                continue;
            }
            if (f.type().equals((Object)FieldType.SIZE_WITHOUT_HEADER)) {
                n = ch.getData().length;
                h.put(f.type(), n);
            } else if (f.type().equals((Object)FieldType.SIZE_WITH_HEADER)) {
                n = ch.getData().length + this.byteCount();
                h.put(f.type(), n);
            } else {
                n = (Number)h.get((Object)f.type());
            }
            f.write(out, n);
        }
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ChunkSpec && super.equals(o) && ((ChunkSpec)o).evenPadded == this.evenPadded;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.evenPadded ? -1 : 0);
    }
}

