/*
 * ref_aligner.cpp
 */

/**
 * Maps an octet representing the XOR of two two-bit-per-base-encoded
 * DNA sequences to the number of bases that mismatch between the two.
 *
 * Generated with this perl:
 *
 * print "const unsigned char u8toMms[] = {\n";
 * for(my $i = 0; $i < 256; $i++) {
 * 	if(($i & 7) == 0) {
 * 		print "\t";
 * 	}
 * 	my $c = $i;
 * 	my $mms = 0;
 * 	for(my $j = 0; $j < 4; $j++) {
 * 		if(($c & 3) != 0) {
 * 			$mms++;
 * 		}
 * 		$c >>= 2;
 * 	}
 * 	print "$mms, ";
 * 	if(($i & 7) == 7) {
 * 		print "\n";
 * 	}
 * }
 * print "};\n";
 *
 */
unsigned char u8toMms[] = {
	0, 1, 1, 1, 1, 2, 2, 2,
	1, 2, 2, 2, 1, 2, 2, 2,
	1, 2, 2, 2, 2, 3, 3, 3,
	2, 3, 3, 3, 2, 3, 3, 3,
	1, 2, 2, 2, 2, 3, 3, 3,
	2, 3, 3, 3, 2, 3, 3, 3,
	1, 2, 2, 2, 2, 3, 3, 3,
	2, 3, 3, 3, 2, 3, 3, 3,
	1, 2, 2, 2, 2, 3, 3, 3,
	2, 3, 3, 3, 2, 3, 3, 3,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	1, 2, 2, 2, 2, 3, 3, 3,
	2, 3, 3, 3, 2, 3, 3, 3,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	1, 2, 2, 2, 2, 3, 3, 3,
	2, 3, 3, 3, 2, 3, 3, 3,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
	2, 3, 3, 3, 3, 4, 4, 4,
	3, 4, 4, 4, 3, 4, 4, 4,
};
