/* This file is part of the Calligra project
 * SPDX-FileCopyrightText: 2008, 2010 Thomas Zander <zander@kde.org>
 *
 * SPDX-License-Identifier: LGPL-2.0-or-later
 */
#ifndef KWPageManagerPrivate_H
#define KWPageManagerPrivate_H

#include "KWPage.h"
#include "KWPageStyle.h"

#include <QHash>
#include <QMap>

using PageId = int;

class KWPageManagerPrivate
{
public:
    struct Page {
        Page()
            : pageSide(KWPage::Right)
            , orientation(KoPageFormat::Portrait)
            , textDirection(KoText::InheritDirection)
            , pageNumber(1)
            , autoGenerated(0)
        {
        }
        KWPageStyle style;
        KWPage::PageSide pageSide;
        KoPageFormat::Orientation orientation;
        KoText::Direction textDirection;
        uint pageNumber : 20; // set by the append-page and overwritten by the text-layout
        uint autoGenerated : 1; // bool to signify words having generated it
        uint padding : 11;
        QRectF contentRect;
    };

    KWPageManagerPrivate();

    void setPageOffset(int pageNum, qreal offset);
    qreal pageOffset(int pageNum) const;

    void setVisiblePageNumber(int pageId, int newPageNumber);

    void insertPage(const Page &page);

    // use a sorted map to find page the identifier for page objects based on the page number.
    QMap<int, PageId> pageNumbers; // page number to pageId

    // use a fast access hash to store the page objects, sorted by their identifier
    QHash<PageId, Page> pages; // pageId to page struct

    QMap<int, int> visiblePageNumbers;

    int lastId; // pageIds are distributed serially,

    QHash<QString, KWPageStyle> pageStyles;
    QHash<QString, QString> pageStyleNames; // map display-name to name
    KoInsets padding;
    KWPageStyle defaultPageStyle;
    QHash<PageId, qreal> pageOffsets;
};

#endif
