/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2021 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef DefaultGUIText_h
#define DefaultGUIText_h

/* ------------------------    Generic    -------------------------------- */
/* ------------------------ Before going further ------------------------- */
static const QString defaultBeforeGoingFurther = "Before going further...";

/* ------------------------ Enhance error -------------------------------- */
static const QString normalStyle = "QLabel { background-color : none; color : black; }";
static const QString enhancedStyle = "QLabel { background-color : red; color : yellow; }";

/* ------------------------ Use only ASCII characters -------------------- */
static const QString defaultAscii = "Please use only ASCII characters: only non accentuated alphanumeric and some other characters [!, \", #, $, %, &, (, ), *, +, -, /...] are supported";


/* ------------------------ CEP Description Widget ----------------------- */
static const QString defaultCepName = "An example of CEP";
static const QString defaultCepDescription = "<html><head></head>\
<body>\
<p>This CEP is an automatically example generated by CamiTK-Wizard.</p>\
<p>It will help you to create Action and Component extensions as well as needed libraries.</p>\
<p>This description <span style='font-weight:600;'>should be replaced</span> \
by a real description of the <span style='font-style:italic;'>actual</span> project.</p>\
</body></html>";
static const QString defaultRealCepName = "Please provide a <i>real</i> <b>name</b> for your CEP,\nA CEP name should gives an idea of what your project is about.\n";
static const QString defaultRealCepDescription = "Please provide a <i>real</i> <b>description</b> for your CEP,\nA CEP description should explain what your project is about.\n";

/* ------------------------ CEP Contact Widget ----------------------- */
static const QString defaultContact = "Firstname.Lastname@univ-grenoble-alpes.fr";
static const QString defaultUserLicence = "/*****************************************************************************<br/>\
 * $USERDEF_LICENCE_BEGIN$<br/>\
 * <br/>\
 * CamiTK - Computer Assisted Medical Intervention ToolKit <br/>\
 * (c) 2001-2021 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France  <br/>\
 * <br/>\
 * Visit http://camitk.imag.fr for more information <br/>\
 * <br/>\
 * This file is part of CamiTK. <br/>\
 * <br/>\
 * @CEP_NAME@ is under the following licence: <br/>\
 *  <br/>\
 *  <br/>\
 *  <br/>\
 * $USERDEF_LICENCE_END$ <br/>\
 ****************************************************************************/ <br/>\
<br/>\
";
static const QString defaultRealContact = "Please provide a <i>real</i> email address for contact\n";


/* -------------------          Dependencies    ----------------------------- */
static const QString defaultDependenciesExplanation = "\
<html>\
    <head/>\
    <body>\
        <p>\
            Please provide here the possible dependencies of your @ELEMENT@: <br/>\
            does it depend on an library from this CEP, from another CamiTK CEP or an external library?\
        </p>\
        <p>\
            <i>Note</span>: if your @ELEMENT@ is standalone<br/>\
             (i.e., it does not need any other library to work), you can skip this page.\
        </p>\
    </body>\
</html>\
";

/* ----------------------  Extension Description Widget --------------------- */
static const QString defaultRealExtensionName = "Please provide a <i>real</i> <b>name</b> for your extension,\nA real name should express what your extension is about.\n";
static const QString defaultRealExtensionDescription = "Please provide a <i>real</i> <b>description</b> for your extension,\nA real description should explain what your extension is about.\n";

/* ------------------- Action Extension Description Widget ------------------ */
static const QString defaultActionExtensionExplanation = "\
<html>\
    <head/>\
    <body>\
        <p>\
            An <i>Action Extension</i> manages one or a set of actions targeting the same objective.<br/> \
                There is one directory for each <i>Action Extension</i>. <br/> \
                Each <i>Action Extension</i> results in one dynamic library (dll, so or dylib).\
        </p>\
        <p>Please fill-in the information requested for creating of an <i>Action Extension</i>.</p>\
        <p>The Actions composing this <i>Action Extension</i> will be added in the next forms.</p>\
    </body>\
</html>\
";

/* ------------------- Action Extension Description Widget ------------------ */
static const QString defaultViewerExtensionExplanation = "\
<html>\
    <head/>\
    <body>\
        <p>\
            An <i>Viewer Extension</i> manages one or a set of actions targeting the same objective.<br/> \
                There is one directory for each <i>Viewer Extension</i>. <br/> \
                Each <i>Viewer Extension</i> results in one dynamic library (dll, so or dylib).\
        </p>\
        <p>Please fill-in the information requested for creating of an <i>Viewer Extension</i>.</p>\
        <p>The Viewer composing this <i>Viewer Extension</i> will be added in the next forms.</p>\
    </body>\
</html>\
";

static const QString defaultActionExtensionName = "Example Of An Action Extension";
static const QString defaultActionExtensionDescription = "This extension description is automatically generated in order to show new users how to easily write an extension with one or several Action(s).";

static const QString defaultViewerExtensionName = "Example Of An Viewer Extension";
static const QString defaultViewerExtensionDescription = "This extension description is automatically generated in order to show new users how to easily write an extension with one or several Viewer(s).";

/* ------------------- Component Extension Description Widget ------------------ */
static const QString defaultComponentExtensionExplanation = "\
<html>\
    <head/>\
        <body>\
            <p>\
                A <i>Component Extension</i> manages one top-level Component.<br/> \
                A top-level component appears at the first level of the component explorer.<br/> \
                It can have sub-components, that can also be managed in the same <i>Component Extension</i>. <br/> \
                There is one directory for each <i>Component Extension</i>.<br/> \
                Each <i>Component Extension</i> results in one dynamic library (dll, so or dylib).\
            </p>\
            <p>Please fill-in the information requested for creating a <i>Component Extension</i>.</p>\
            <p>The Components composing this <i>Component Extension</i> will be added in the next forms.</p>\
</body>\
</html>\
";

static const QString defaultComponentExtensionName = "Example Of A Component Extension";
static const QString defaultComponentExtensionDescription = "This extension description is automatically generated in order to show new users how to easily write an extension with one or several Component(s)";

/* ------------------------ Action Description Widget ----------------------- */

static const QString defaultActionName = "Example Of An Action";
static const QString defaultActionDescription = "This description is automatically generated in order to show new users how to easily write an Action.";

static const QStringList defaultPossibleComponents = QStringList() << "ImageComponent" << "MeshComponent" << "CameraComponent" << "PhysicalModelComponent";

static const QString defaultRealActionName = "Please provide a <i>real</i> <b>name</b> for your action,\nA real action name should express what your action is about.\n";
static const QString defaultRealActionDescription = "Please provide a <i>real</i> <b>description</b> for your action,\nA real description should explain the goal and tell a little bit about the method of your action (for instance, you can reference a/your paper here).\n";
static const QString defaultActionNameAndExtension = "Please provide a name that is different from the name of the Action Extension.\n";

/* ------------------------ Viewer Description Widget ----------------------- */

static const QString defaultViewerName = "Example Of An Viewer";
static const QString defaultViewerDescription = "This description is automatically generated in order to show new users how to easily write an Viewer.";

static const QString defaultRealViewerName = "Please provide a <i>real</i> <b>name</b> for your viewer,\nA real action name should express what your viewer is about.\n";
static const QString defaultRealViewerDescription = "Please provide a <i>real</i> <b>description</b> for your viewer,\nA real description should explain the goal and tell a little bit about the method of your viewer (for instance, you can reference a/your paper here).\n";
static const QString defaultViewerNameAndExtension = "Please provide a name that is different from the name of the Viewer Extension.\n";

/* ------------------------ Component Description Widget ----------------------- */

static const QString defaultComponentName = "Example Of A Component";
static const QString defaultComponentDescription = "This description is automatically generated for this component which handles no kind of data.";
static const QString defaultComponentSuffix = "example";

static const QString defaultRealComponentName = "Please provide a <i>real</i> <b>name</b> for your component,\nA real component name should express what kind of data are handled.\n";
static const QString defaultRealComponentDescription = "Please provide a <i>real</i> <b>description</b> for your component,\nA real description should explain the data files or input/output data that are handled.\n";
static const QString defaultRealFileSuffix = "Please provide a <i>real</i> file suffix. It is the suffix (also called file extension) that is used in the file names your component will open/support. If your component is not designed to open any file, please leave this suffix empty. Note that in this case, you might consider using a initialization action to instantiate your component.";
static const QString defaultComponentNameAndExtension = "Please provide a name different that is different from the name of the Component Extension.\n";

/* ------------------------ Action Classification Widget ----------------------- */
static const QString defaultFamily = "Test Family";
static const QString defaultRealFamily = "Please provide a <i>real</i> family name for your Action. It will allow CamiTK to automatically classify your action: all actions of the same family will be available under the same submenu in the contextual menu/Action menu of the selected component.";

static const QString defaultParamNoName = "Please provide a name for <i>all</i> parameters.\n";
static const QString defaultPropNoName  = "Please provide a name for <i>all</i> properties.\n";

/* ----------------------- Actions Creation Widget --------------------------- */
static const QString defaultCreatedActionsString = "\
<html>\
<head/>\
<body>\
<p align='center'><span style=' font-weight:600; '>Created Action(s):</span></p>\
<ul>\
</ul>\
</body>\
</html>";

/* ----------------------- Actions Creation Widget --------------------------- */
static const QString defaultCreatedViewersString = "\
<html>\
<head/>\
<body>\
<p align='center'><span style=' font-weight:600; '>Created Viewer(s):</span></p>\
<ul>\
</ul>\
</body>\
</html>";

/* ----------------------- Components Creation Widget --------------------------- */
static const QString defaultCreatedComponentsString = "\
<html>\
<head/>\
<body>\
<p align='center'><span style=' font-weight:600; '>Created Component(s):</span></p>\
<ul>\
</ul>\
</body>\
</html>";


/* -----------------------         Action Symmary   --------------------------- */
static const QString defaultActionSummary = "\
<html>\
<head/> \
<body>\
<h1>Summary</h1>\
<p> You are about to add the following <b>Action</b></p>\
<ul>\
<li>Name: @NAME@ </li>\
<li>Description: @DESCRIPTION@ </li>\
<li>Component: @COMPONENT@ </li>\
<li>Parameter(s): \
<ul> \
@PARAMETERS_LIST@ \
</ul> \
</li>\
<li>Family: @FAMILY@ </li>\
<li>Tag(s): \
<ul> \
@TAGS_LIST@ \
</ul> \
</li>\
</ul>\
<br/> \
<p>If you want to modify some elements of your Action, click on <tt>Previous</tt>. </p> \
<p>If you want to cancel the creation of this Action, click on <tt>Cancel</tt>. </p> \
<p>Clicking on <tt>Next</tt> will bring you back to the Action Extension page.</p>\
</body>\
</html>";


/* -----------------------         Viewer Symmary   --------------------------- */
static const QString defaultViewerSummary = "\
<html>\
<head/> \
<body>\
<h1>Summary</h1>\
<p> You are about to add the following <b>Viewer</b></p>\
<ul>\
<li>Name: @NAME@ </li>\
<li>Description: @DESCRIPTION@ </li>\
<li>Type: @TYPE@ </li>\
</ul>\
<br/> \
<p>If you want to modify some elements of your Viewer, click on <tt>Previous</tt>. </p> \
<p>If you want to cancel the creation of this Viewer, click on <tt>Cancel</tt>. </p> \
<p>Clicking on <tt>Next</tt> will bring you back to the Viewer Extension page.</p>\
</body>\
</html>";


/* -----------------------         Component Symmary   --------------------------- */
static const QString defaultComponentSummary = "\
<html>\
<head/> \
<body>\
<h1>Summary</h1>\
<p> You are about to add the following <b>Component</b></p>\
<ul>\
<li>Name: @NAME@ </li>\
<li>Description: @DESCRIPTION@ </li>\
<li>Representation: @REPRESENTATION@ </li>\
<li>Property(ies): \
<ul> \
@PROPERTIES_LIST@ \
</ul> \
</li>\
</ul>\
<br/> \
<p>If you want to modify some elements of your Component, click on <tt>Previous</tt>. </p> \
<p>If you want to cancel the creation of this Component, click on <tt>Cancel</tt>. </p> \
<p>Clicking on <tt>Next</tt> will bring you back to the Component Extension page.</p>\
</body>\
</html>";



/* ----------------------- Action Extension Summary --------------------------- */
static const QString defaultExtensionSummary = "\
<html>\
<head/> \
<body>\
    <h1>Summary</h1>\
    <p> You are about to add the following <b>@ELEMENT@ Extensions</b></p>\
    <ul>\
        <li>Name: @NAME@ </li>\
        <li>Description: @DESCRIPTION@ </li>\
        <li>@ELEMENT@s: \
            <ul> \
            @ELEMENTS_LIST@ \
            </ul> \
        </li>\
        <li>Dependencies: \
            <ul> \
            @DEPENDENCIES_LIST@ \
            </ul> \
        </li>\
    </ul>\
    <br/> \
    <p>If you want to modify some elements of your @ELEMENT@ Extension, click on <tt>Previous</tt>. </p> \
    <p>If you want to cancel the creation of this @ELEMENT@ Extension, click on <tt>Cancel</tt>. </p> \
    <p>Clicking on <tt>Next</tt> will bring you back to the CEP sumarry page.</p>\
</body>\
</html>";


/* ----------------------- Libraries --------------------------- */
static const QString defaultLibraryExplanation = "\
<html>\
    <head/>\
    <body>\
        <p>A CamiTK Component or Action is just a <span style='font-style:italic;'>glue</span>, i.e. an encapsulation of your <br/>\
            data structures/algorithms to fit them within CamiTK. \
        </p>\
        <p>However, you may want to keep the knowledge and know-how of your specialty <br/>\
            independent of CamiTK.\
        </p>\
        <p>This is what Libraries offers you: <span style='font-weight:600;'>the code inside a library is independent of CamiTK</span><br/>\
            (only the CMakeList provided uses camitk cmake macros to ease your work, <br/>\
            but you can totally modify them so that they are CamiTK<br/>\
            independent) and can be used elsewhere.\
        </p>\
    </body>\
</html>\
";

static const QString defaultLibraryName = "My Own Library";

static const QString defaultLibraryDescription = "This library is generated automatically and aims at showing CamiTK new users how to easily write a library independent from CamiTK (except for the CMakeList).";
static const QString defaultRealLibraryName = "Please provide a <i>real</i> <b>name</b> for your library,\nA real library name should express what your library is about.\n";
static const QString defaultRealLibraryDescription = "Please provide a <i>real</i> <b>description</b> for your library,\nA real description should explain the goal and tell a little bit about the method of your library (for instance, you can reference a/your paper here).\n";

static const QString defaultCopyFilesExplanation = "\
<html>\
    <head/>\
    <body>\
        <h1>Copy Files</h1>\
        <p>\
            If you already created files containing the code of your library, you can copy them here.\
        </p>\
        <p>\
            You can of course copy them or create them manually another time. <br/>\
            However,as CMake automatically parses the directory to include existing .h and .cpp files<br/>\
            inside your project, you may want to copy/create them before running CMake<br/>\
            for the first time.\
        </p>\
    </body>\
</html>\
";

static const QString defaultCopiedFiles = "\
<html>\
<head/>\
<body>\
<h1>File(s) to copy:</h1>\
<ul>\
</ul>\
</body>\
</html>";

/* ----------------------- CEP Summary --------------------------- */
static const QString defaultCEPSummary = "\
<html>\
    <head/>\
    <body>\
        <h2>Congratulations !!</h2>\
        <h1>You just created a <i>CamiTK Extension Project</i></h1>\
\
        <h2>To Make It Work</h2>\
        <ol>\
            <li>Create a <tt>build</tt> directory.<br/>\
                <i>Note:</i> It is generally created within @WORKING_DIRECTORY@<br/>\
                   But <b>NOT</b> whitin @WORKING_DIRECTORY@/@CEP_DIRECTORY@.<br/>\
                   However, it can be created anywhere else.\
            </li>\
            <li>Launch CMake-Gui</li>\
            <li>Set <tt><i>Where to build the binaries:</i></tt> to @WORKING_DIRECTORY@/build</li>\
            <li>Set <tt><i>Where is the source code:</i></tt> to @WORKING_DIRECTORY@/@CEP_DIRECTORY@\
            <li>Click on <tt>Configure</tt> and select your favorite IDE (Visual Studio, KDevelop, XCode, etc.)</li>\
            <li>Re-click on <tt>Configure</tt> until no red parameter appears.</li>\
            <li>Click on <tt>Generate</tt>\
            <li>Open the generated project (located within @WORKING_DIRECTORY@/build) with your favorite IDE\
            <li>Compile it</li>\
            <li>Run <tt>camitk-imp</tt> either from your IDE or from command-line <br/>\
            (after relocated within @WORKING_DIRECTORY@/build directory)\
            <li>Enjoy !</li>\
        <ol>\
    </body>\
</html>\
";

#endif
