// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "EventSet.pypp.hpp"

namespace bp = boost::python;

struct EventSet_wrapper : CEGUI::EventSet, bp::wrapper< CEGUI::EventSet > {

    EventSet_wrapper( )
    : CEGUI::EventSet( )
      , bp::wrapper< CEGUI::EventSet >(){
        // null constructor
    
    }

    virtual void fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        if( bp::override func_fireEvent = this->get_override( "fireEvent" ) )
            func_fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        else{
            this->CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
        }
    }
    
    void default_fireEvent( ::CEGUI::String const & name, ::CEGUI::EventArgs & args, ::CEGUI::String const & eventNamespace="" ) {
        CEGUI::EventSet::fireEvent( boost::ref(name), boost::ref(args), boost::ref(eventNamespace) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), boost::ref(subscriber_name) );
    }

    virtual ::CEGUI::RefCounted< CEGUI::BoundSlot > subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        if( bp::override func_subscribeScriptedEvent = this->get_override( "subscribeScriptedEvent" ) )
            return func_subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        else{
            return this->CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
        }
    }
    
    ::CEGUI::RefCounted< CEGUI::BoundSlot > default_subscribeScriptedEvent( ::CEGUI::String const & name, unsigned int group, ::CEGUI::String const & subscriber_name ) {
        return CEGUI::EventSet::subscribeScriptedEvent( boost::ref(name), group, boost::ref(subscriber_name) );
    }

};

class EventCallback
{
public:
    EventCallback() : mSubscriber(0) {}

    EventCallback(PyObject*  subscriber, CEGUI::String const & method)
    {
        mSubscriber = subscriber;
        mMethod = method;
    } 
    
    EventCallback(const EventCallback &other)
    : mSubscriber(0)
    {
        *this = other;
    }
    
    ~EventCallback()
    {
    } 
    
    void setsubscriber( PyObject* subscriber )
    {
        mSubscriber = subscriber;
    }
    
  bool operator() (const CEGUI::EventArgs &args) const
    {
        if (dynamic_cast<CEGUI::MouseCursorEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(), 
                                        static_cast<const CEGUI::MouseCursorEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber, 
                                        static_cast<const CEGUI::MouseCursorEventArgs&>(args) );
            
        else if (dynamic_cast<CEGUI::KeyEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(), 
                                        static_cast<const CEGUI::KeyEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber, 
                                        static_cast<const CEGUI::KeyEventArgs&>(args) );
        
        else if (dynamic_cast<CEGUI::ActivationEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(), 
                                        static_cast<const CEGUI::ActivationEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber,  
                                        static_cast<const CEGUI::ActivationEventArgs&>(args) );
        
        else if (dynamic_cast<CEGUI::DragDropEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(), 
                                        static_cast<const CEGUI::DragDropEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber,  
                                        static_cast<const CEGUI::DragDropEventArgs&>(args) );
        
        else if (dynamic_cast<CEGUI::HeaderSequenceEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(), 
                                        static_cast<const CEGUI::HeaderSequenceEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber,
                                        static_cast<const CEGUI::HeaderSequenceEventArgs&>(args) );
        
        else if (dynamic_cast<CEGUI::MouseEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(), 
                                        static_cast<const CEGUI::MouseEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber, 
                                        static_cast<const CEGUI::MouseEventArgs&>(args) );

        else if (dynamic_cast<CEGUI::DisplayEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(),
                                        static_cast<const CEGUI::DisplayEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber,
                                        static_cast<const CEGUI::DisplayEventArgs&>(args) );

        else if (dynamic_cast<CEGUI::ResourceEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(),
                                        static_cast<const CEGUI::ResourceEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber,
                                        static_cast<const CEGUI::ResourceEventArgs&>(args) );

         else if (dynamic_cast<CEGUI::TreeEventArgs *>((CEGUI::EventArgs *)&args))
           if (mMethod.length() > 0 )
               boost::python::call_method<void>(mSubscriber, mMethod.c_str(),
                                        static_cast<const CEGUI::TreeEventArgs&>(args) );
           else
               boost::python::call<void>(mSubscriber, 
                                        static_cast<const CEGUI::TreeEventArgs&>(args) );

        else if (dynamic_cast<CEGUI::WindowEventArgs *>((CEGUI::EventArgs *)&args))
            if (mMethod.length() > 0 )
                boost::python::call_method<void>(mSubscriber, mMethod.c_str(), 
                                        static_cast<const CEGUI::WindowEventArgs&>(args) );
            else
                boost::python::call<void>(mSubscriber,  
                                        static_cast<const CEGUI::WindowEventArgs&>(args) );

        else 
            boost::python::call_method<void>(mSubscriber, mMethod.c_str(), args );
     return true;
    }

    PyObject*  mSubscriber;
    CEGUI::String  mMethod;
};

class EventConnection
{
public:
    EventConnection() : mConnection(0), mValid(false) {}
    
    EventConnection(const CEGUI::Event::Connection &connection) 
    : mConnection(connection), mValid(true) 
    {
    }
    ~EventConnection()
    {
        if (mCallback) delete mCallback;
    }   
    bool connected()
    {
        return mValid && mConnection->connected();
    }
    
    void disconnect()
    {
        if (mValid)
            mConnection->disconnect();
    } // disconnect()
    
protected:
    CEGUI::Event::Connection mConnection;
    bool mValid;
    EventCallback * mCallback;
};



EventConnection * EventSet_subscribeEventSet(CEGUI::EventSet *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}

EventConnection * EventSet_subscribeEventPB(CEGUI::PushButton *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventTB(CEGUI::Titlebar *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventFW(CEGUI::FrameWindow *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventGUISheet(CEGUI::GUISheet *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventComboBox(CEGUI::Combobox *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventCheckBox(CEGUI::Checkbox *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventSB(CEGUI::Scrollbar *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventLB(CEGUI::Listbox *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventEB(CEGUI::Editbox *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventThumb(CEGUI::Thumb *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventSlider(CEGUI::Slider *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventSpinner(CEGUI::Spinner *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeEventRadioButton(CEGUI::RadioButton *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeDragContainer(CEGUI::DragContainer *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeMultiColumnList(CEGUI::MultiColumnList *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}

// new ones the I missed in RC1
EventConnection * EventSet_subscribeWindow(CEGUI::Window *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeMouseCursor(CEGUI::MouseCursor *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
EventConnection * EventSet_subscribeSystem(CEGUI::System *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}

#if CEGUI_VERSION_MINOR < 7 
EventConnection * EventSet_subscribeRenderer(CEGUI::Renderer *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
#endif

#if CEGUI_VERSION_MINOR > 5 && CEGUI_VERSION_PATCH > 0
EventConnection * EventSet_subscribeTree(CEGUI::Tree *self , CEGUI::String const & name, 
                                                PyObject* subscriber, CEGUI::String const & method="")
{
    EventConnection *connect = new EventConnection(self->subscribeEvent(name, EventCallback(subscriber, method))); 
    return connect; 
}
#endif

void register_EventSet_class(){

    { //::CEGUI::EventSet
        typedef bp::class_< EventSet_wrapper, boost::noncopyable > EventSet_exposer_t;
        EventSet_exposer_t EventSet_exposer = EventSet_exposer_t( "EventSet", "*!\n\
        \n\
           Class that collects together a set of Event objects.\n\
        \n\
            The EventSet is a means for code to attach a handler function to some\n\
            named event, and later, for that event to be fired and the subscribed\n\
            handler(s) called.\n\
            \n\
            As of 0.5, the EventSet no longer needs to be filled with available events.\n\
            Events are now added to the set as they are first used; that is, the first\n\
            time a handler is subscribed to an event for a given EventSet, an Event\n\
            object is created and added to the EventSet.\n\
            \n\
            Instead of throwing an exception when firing an event that does not actually\n\
            exist in the set, we now do nothing (if the Event does not exist, then it\n\
            has no handlers subscribed, and therefore doing nothing is the correct\n\
            course action).\n\
        *\n", bp::init< >("*!\n\
        \n\
           Constructor for EventSet objects\n\
        *\n") );
        bp::scope EventSet_scope( EventSet_exposer );
        { //::CEGUI::EventSet::addEvent
        
            typedef void ( ::CEGUI::EventSet::*addEvent_function_type )( ::CEGUI::String const & ) ;
            
            EventSet_exposer.def( 
                "addEvent"
                , addEvent_function_type( &::CEGUI::EventSet::addEvent )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  Add a new Event to the EventSet with the given name.\n\
            \n\
               @param name\n\
                  String object containing the name to give the new Event.  The name must be unique for the\
                  EventSet.\n\
            \n\
               @return\n\
                  Nothing\n\
            \n\
               @exception AlreadyExistsException   Thrown if an Event already exists named  name.\n\
               *\n" );
        
        }
        { //::CEGUI::EventSet::fireEvent
        
            typedef void ( ::CEGUI::EventSet::*fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            typedef void ( EventSet_wrapper::*default_fireEvent_function_type )( ::CEGUI::String const &,::CEGUI::EventArgs &,::CEGUI::String const & ) ;
            
            EventSet_exposer.def( 
                "fireEvent"
                , fireEvent_function_type(&::CEGUI::EventSet::fireEvent)
                , default_fireEvent_function_type(&EventSet_wrapper::default_fireEvent)
                , ( bp::arg("name"), bp::arg("args"), bp::arg("eventNamespace")="" ) );
        
        }
        { //::CEGUI::EventSet::getIterator
        
            typedef ::CEGUI::ConstBaseIterator< std::map<CEGUI::String, CEGUI::Event*, CEGUI::String::FastLessCompare, std::allocator<std::pair<CEGUI::String const, CEGUI::Event*> > > > ( ::CEGUI::EventSet::*getIterator_function_type )(  ) const;
            
            EventSet_exposer.def( 
                "getIterator"
                , getIterator_function_type( &::CEGUI::EventSet::getIterator )
                , "*!\n\
            \n\
                Return a EventSet.Iterator object to iterate over the events currently\n\
                added to the EventSet.\n\
            *\n" );
        
        }
        { //::CEGUI::EventSet::isEventPresent
        
            typedef bool ( ::CEGUI::EventSet::*isEventPresent_function_type )( ::CEGUI::String const & ) ;
            
            EventSet_exposer.def( 
                "isEventPresent"
                , isEventPresent_function_type( &::CEGUI::EventSet::isEventPresent )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  Checks to see if an Event with the given name is present in the EventSet.\n\
            \n\
               @return\n\
                  true if an Event named  name was found, or false if the Event was not found\n\
               *\n" );
        
        }
        { //::CEGUI::EventSet::isMuted
        
            typedef bool ( ::CEGUI::EventSet::*isMuted_function_type )(  ) const;
            
            EventSet_exposer.def( 
                "isMuted"
                , isMuted_function_type( &::CEGUI::EventSet::isMuted )
                , "*!\n\
               \n\
                  Return whether the EventSet is muted or not.\n\
            \n\
               @return\n\
                  - true if the EventSet is muted.  All requests to fire events will be ignored.\n\
                  - false if the EventSet is not muted.  All requests to fire events are processed as normal.\n\
               *\n" );
        
        }
        { //::CEGUI::EventSet::removeAllEvents
        
            typedef void ( ::CEGUI::EventSet::*removeAllEvents_function_type )(  ) ;
            
            EventSet_exposer.def( 
                "removeAllEvents"
                , removeAllEvents_function_type( &::CEGUI::EventSet::removeAllEvents )
                , "*!\n\
               \n\
                  Remove all Event objects from the EventSet\n\
            \n\
               @return\n\
                  Nothing\n\
               *\n" );
        
        }
        { //::CEGUI::EventSet::removeEvent
        
            typedef void ( ::CEGUI::EventSet::*removeEvent_function_type )( ::CEGUI::String const & ) ;
            
            EventSet_exposer.def( 
                "removeEvent"
                , removeEvent_function_type( &::CEGUI::EventSet::removeEvent )
                , ( bp::arg("name") )
                , "*!\n\
               \n\
                  Removes the Event with the given name.  All connections to the event are disconnected.\n\
            \n\
               @param name\n\
                  String object containing the name of the Event to remove.  If no such Event exists, nothing\
                  happens.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::EventSet::setMutedState
        
            typedef void ( ::CEGUI::EventSet::*setMutedState_function_type )( bool ) ;
            
            EventSet_exposer.def( 
                "setMutedState"
                , setMutedState_function_type( &::CEGUI::EventSet::setMutedState )
                , ( bp::arg("setting") )
                , "*!\n\
               \n\
                  Set the mute state for this EventSet.\n\
            \n\
               @param setting\n\
                  - true if the EventSet is to be muted (no further event firing requests will be honoured until\
                  EventSet is unmuted).\n\
                  - false if the EventSet is not to be muted and all events should fired as requested.\n\
            \n\
               @return\n\
                  Nothing.\n\
               *\n" );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( EventSet_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            EventSet_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&EventSet_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("subscriber_name") ) );
        
        }
        { //::CEGUI::EventSet::subscribeScriptedEvent
        
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( ::CEGUI::EventSet::*subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            typedef ::CEGUI::RefCounted< CEGUI::BoundSlot > ( EventSet_wrapper::*default_subscribeScriptedEvent_function_type )( ::CEGUI::String const &,unsigned int,::CEGUI::String const & ) ;
            
            EventSet_exposer.def( 
                "subscribeScriptedEvent"
                , subscribeScriptedEvent_function_type(&::CEGUI::EventSet::subscribeScriptedEvent)
                , default_subscribeScriptedEvent_function_type(&EventSet_wrapper::default_subscribeScriptedEvent)
                , ( bp::arg("name"), bp::arg("group"), bp::arg("subscriber_name") ) );
        
        }
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventPB, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventTB, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventLB, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventComboBox, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventCheckBox, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventSB, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventGUISheet, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventFW, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventEB, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventThumb, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventSlider, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventSpinner, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventRadioButton, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeDragContainer, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeMultiColumnList, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeWindow, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeMouseCursor, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeSystem, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeEventSet, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
        EventSet_exposer.def( "subscribeEvent", &EventSet_subscribeTree, 
                    bp::return_value_policy< bp::reference_existing_object, bp::default_call_policies >());
                                
        { //EventConnection
                typedef bp::class_< EventConnection > EventConnection_exposer_t;
                EventConnection_exposer_t EventConnection_exposer = EventConnection_exposer_t( "EventConnection" );
                bp::scope EventConnection_scope( EventConnection_exposer );
                EventConnection_exposer.def( bp::init< >() );
                { //::CEGUI::EventConnection::connected
                
                    typedef bool ( EventConnection::*connected_function_type )(  ) ;
                    
                    EventConnection_exposer.def( 
                        "connected"
                        , connected_function_type( &EventConnection::connected ) );
                
                }
                { //::CEGUI::EventConnection::disconnect
                
                    typedef void ( EventConnection::*disconnect_function_type )(  ) ;
                    
                    EventConnection_exposer.def( 
                        "disconnect"
                        , disconnect_function_type( &EventConnection::disconnect ) );
                
                }
            };
    }

}
