#!/bin/bash

# GitLab artifacts are limited to 1GiB each and are part of the 10 GiB project
# storage limit. There is also a CI cache but this is also subject to the
# limit. However, the container registry does not AFAICT have a storage limit.
# Therefore, we use this script to manually save and restore stuff in the
# container registry.

# NOTE: oras(1) is pretty underdocumented but it does work for now.

. "$(dirname "$0")"/base.bash

cd / || exit 1
job=$(echo "$CI_JOB_GROUP_NAME" | sed -E 's|^([^@]+)(@.*)$|\1|')
pack_dir_include=yes
artifact_type=application/vnd.oci.image.config.v1+json  # works, dunno why

for arg in "$@"; do
    case $arg in
    --no-pack)
        pack_dir_include=
        ;;
    save|restore)
        mode=$arg
        ;;
    *)
        job=$arg
        ;;
    esac
    shift
done
echo "job: $job"

declare -a saved_dirs
saved_dirs+=( "${CH_IMAGE_STORAGE#/}/bucache" )
if [[ $pack_dir_include ]]; then
    saved_dirs+=( "${CH_TEST_TARDIR#/}" )
fi
echo "$mode: ${saved_dirs[*]}"

#shellcheck disable=SC2154
img=$(printf 'cic:%s_%s_%s_%s_%s_%s' "$ci_distro" \
                                     "$ci_gc" \
                                     "$ci_arch" \
                                     "$ci_branch" \
                                     "$CI_COMMIT_SHORT_SHA" \
                                     "$job")
echo "img raw: $img"
img=$(  echo "$img" \
      | tr '[:upper:]' '[:lower:]' \
      | sed -E 's/[^a-z0-9_.:-]/./g')
ref=$CI_REGISTRY_IMAGE/$img
echo "ref: $ref"

if [[ $CI_REGISTRY_USER ]]; then
      echo "$CI_REGISTRY_PASSWORD" \
    | oras login -u "$CI_REGISTRY_USER" --password-stdin "$CI_REGISTRY"
fi

case $mode in
save)
    ch-image build-cache --gc               # maybe saves a lot of space
    oras push -v --artifact-type="$artifact_type" "$ref" "${saved_dirs[@]}"
    ;;
restore)
    ch-image list                           # init storage dir
    for d in "${saved_dirs[@]}"; do
        rm -Rf "$d"
    done
    oras pull -v "$ref"
    ;;
*)
    echo "invalid mode: $mode" 1>&2
    ;;
esac