////////////////////////////////////////////////////////////////////////////////
// checkstyle: Checks Java source code for adherence to a set of rules.
// Copyright (C) 2001-2020 the original author or authors.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

package com.puppycrawl.tools.checkstyle.api;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.fail;

import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

/**
 * Test cases for {@link SeverityLevel} enumeration.
 */
public class SeverityLevelTest {

    /* Additional test for jacoco, since valueOf()
     * is generated by javac and jacoco reports that
     * valueOf() is uncovered.
     */
    @Test
    public void testSeverityLevelValueOf() {
        final SeverityLevel level = SeverityLevel.valueOf("INFO");
        assertEquals(SeverityLevel.INFO, level, "Invalid severity level");
    }

    @Test
    public void testMisc() {
        final SeverityLevel severityLevel = SeverityLevel.getInstance("info");
        assertNotNull(severityLevel, "Invalid getInstance result, should not be null");
        assertEquals("info", severityLevel.toString(), "Invalid toString result");
        assertEquals("info", severityLevel.getName(), "Invalid severity level name");

        try {
            SeverityLevel.getInstance("unknown");
            fail("exception expected");
        }
        catch (IllegalArgumentException ex) {
            assertEquals(
                    "No enum constant com.puppycrawl.tools.checkstyle.api.SeverityLevel.UNKNOWN",
                    ex.getMessage(), "Invalid exception message");
        }
    }

    @Test
    public void testMixedCaseSpaces() {
        assertEquals(SeverityLevel.IGNORE, SeverityLevel.getInstance("IgnoRe "),
                "Invalid getInstance result");
        assertEquals(SeverityLevel.INFO, SeverityLevel.getInstance(" iNfo"),
                "Invalid getInstance result");
        assertEquals(SeverityLevel.WARNING, SeverityLevel.getInstance(" WarniNg"),
                "Invalid getInstance result");
        assertEquals(SeverityLevel.ERROR, SeverityLevel.getInstance("    ERROR "),
                "Invalid getInstance result");
    }

    @DefaultLocale(language = "tr", country = "TR")
    @Test
    public void testMixedCaseSpacesWithDifferentLocales() {
        assertEquals(SeverityLevel.IGNORE, SeverityLevel.getInstance("IgnoRe "),
                "Invalid getInstance result");
        assertEquals(SeverityLevel.INFO, SeverityLevel.getInstance(" iNfo"),
                "Invalid getInstance result");
        assertEquals(SeverityLevel.WARNING, SeverityLevel.getInstance(" WarniNg"),
                "Invalid getInstance result");
        assertEquals(SeverityLevel.ERROR, SeverityLevel.getInstance("    ERROR "),
                "Invalid getInstance result");
    }

}
