//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah
// file name            : macrosdlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __macrosdlg__
#define __macrosdlg__

/**
@file
Subclass of MacrosBaseDlg, which is generated by wxFormBuilder.
*/

class IEditor;

#include "macrosbasedlg.h"
#include "project.h"
#include "codelite_exports.h"

/** Implementing MacrosBaseDlg */
class WXDLLIMPEXP_SDK MacrosDlg : public MacrosBaseDlg
{
	long m_item;
	int m_content;
	ProjectPtr m_project;
	IEditor *m_editor;

public:
	enum {
		MacrosProject,
		MacrosCompiler,
		MacrosExternalTools
	};

protected:
	// Handlers for MacrosBaseDlg events.
	void OnItemRightClick( wxListEvent& event );
	void OnCopy(wxCommandEvent &e);
	void Initialize();
	void AddMacro(const wxString &name, const wxString &desc);

	DECLARE_EVENT_TABLE()

public:
	/** Constructor */
	MacrosDlg( wxWindow* parent, int content, ProjectPtr project, IEditor *editor );
	virtual ~MacrosDlg();
};

#endif // __macrosdlg__
