package org.apache.commons.javaflow.bytecode.transformation.data;

/**
 * Regression test case.
 *
 * <p>
 * When the stack size reaches the maximum in a constructor method invocation,
 * there was a bug where we failed to expand the stack size appropriately.
 *
 * This is a regression test for that case.
 *
 *
 * @author Kohsuke Kawaguchi
 */
public final class Stack implements Runnable {
    public void run() {
        final Object o = foo("abc","def");
    }

    private Object foo(String a, String b) {
        return new StrStr(a,b);
    }

    private static final class StrStr {
        private final String value;

        public StrStr(String a, String b) {
            value = a+b;
        }

        public String toString() {
            return value;
        }
    }
}
