#
# Copyright (C) 2005  Robert Collins  <robertc@squid-cache.org>
# 
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import tests
import unittest

# if this fails to import, then the config_manager module is bust
# and this test script will never be reached to be imported
import config_manager
from config_manager.tests import FunctionalTestCase


class TestImport(unittest.TestCase):

    def test_imports(self):
        from config_manager import URLMapper


class TestWithMapper(unittest.TestCase):

    def setUp(self):
        super(TestWithMapper, self).setUp()
        self.mapper = config_manager.URLMapper()
        
    def test_default_map_is_identity(self):
        self.assertEqual("foobar", self.mapper.map("foobar"))

    def test_map_with_rule(self):
        self.mapper.add_map("foobar", "roxor")
        self.assertEqual("roxor", self.mapper.map("foobar"))

    def test_map_with_prefix_rule_ignores_non_dir(self):
        self.mapper.add_map("foo", "roxor")
        self.assertEqual("foobar", self.mapper.map("foobar"))

    def test_map_with_prefix_rule_matches_dirs(self):
        self.mapper.add_map("foo", "roxor")
        self.assertEqual("roxor/bar", self.mapper.map("foo/bar"))

    def test__eq__(self):
        second_mapper = config_manager.URLMapper()
        self.assertEqual(self.mapper, second_mapper)
        self.mapper.add_map("A", "B")
        self.assertNotEqual(self.mapper, second_mapper)
        second_mapper.add_map("A", "B")
        self.assertEqual(self.mapper, second_mapper)
        

def test_suite():
    loader = tests.TestLoader()
    result = loader.loadTestsFromName(__name__)
    return result
