/*
 *
 * Conky, a system monitor, based on torsmo
 *
 * Any original torsmo code is licensed under the BSD license
 *
 * All code written since the fork of torsmo is licensed under the GPL
 *
 * Please see COPYING for details
 *
 * Copyright (c) 2004, Hannu Saransaari and Lauri Hakkarainen
 * Copyright (c) 2005-2021 Brenden Matthews, Philip Kovacs, et. al.
 *	(see AUTHORS)
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef _HSV_GRADIENT_H
#define _HSV_GRADIENT_H

#include <memory>

// needed by hsv_gradient
extern short colour_depth;
extern long redmask, greenmask, bluemask;
extern void set_up_gradient();

std::unique_ptr<unsigned long[]> do_hsv_gradient(int, unsigned long,
                                                 unsigned long);

long to_decimal_scale(long value, long max_value);
long from_decimal_scale(long value, long max_value);
void scaled_rgb_to_scaled_hsv(long *const rgb, long *hsv);
void scaled_hsv_to_scaled_rgb(long *const hsv, long *rgb);

#endif /* _COLOURS_H */
