/*
 *  Copyright 2011 Wolfgang Koller - http://www.gofg.at/
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

window.Cordova = {
    plugins: {},
    constructors: {},
    callbacks: {},
};

Cordova.callback = function() {
    var scId = arguments[0];
    var callbackRef = null;

    var parameters = [];
    for (var i = 1; i < arguments.length; i++) {
        parameters[i-1] = arguments[i];
    }
    callbackRef = Cordova.callbacks[scId];

    // Even IDs are success-, odd are error-callbacks - make sure we remove both
    if ((scId % 2) !== 0) {
        scId = scId - 1;
    }
    // Remove both the success as well as the error callback from the stack
    delete Cordova.callbacks[scId];
    delete Cordova.callbacks[scId + 1];

    if (typeof callbackRef == "function") callbackRef.apply(this, parameters);
};

Cordova.callbackWithoutRemove = function() {
    var scId = arguments[0];
    var callbackRef = null;

    var parameters = [];
    for (var i = 1; i < arguments.length; i++) {
        parameters[i-1] = arguments[i];
    }
    callbackRef = Cordova.callbacks[scId];

    if (typeof(callbackRef) == "function") callbackRef.apply(this, parameters);
};

Cordova.enablePlugin = function (pluginName) {
    Cordova.plugins[pluginName] = true;

    if (typeof Cordova.constructors[pluginName] === "function") Cordova.constructors[pluginName]();
}

Cordova.addConstructor = function(pluginName, constructor) {
    Cordova.constructors[pluginName] = constructor;
}

Cordova.Event = function() {
};

Cordova.Event.CAPTURING_PHASE = 1;
Cordova.Event.AT_TARGET = 2;
Cordova.Event.BUBBLING_PHASE = 3;

Cordova.Event.prototype.type = "unknown";
Cordova.Event.prototype.target = Cordova;
Cordova.Event.prototype.currentTarget = Cordova;
Cordova.Event.prototype.eventPhase = Cordova.Event.AT_TARGET;
Cordova.Event.prototype.bubbles = false;
Cordova.Event.prototype.cancelable = false;
Cordova.Event.prototype.timeStamp = 0;

Cordova.Event.prototype.stopPropagation = function() {};
Cordova.Event.prototype.preventDefault = function() {};
Cordova.Event.prototype.initEvent = function (eventTypeArg, canBubbleArg, cancelableArg) {
    this.type = eventTypeArg;
    this.timeStamp = (new Date()).getMilliseconds();
};

Cordova.EventHandler = function(p_type) {
    this.type = p_type
    this.listeners = []
}

Cordova.EventHandler.prototype.type = "unknown";
Cordova.EventHandler.prototype.listeners = [];
Cordova.EventHandler.prototype.addEventListener = function(p_listener, p_capture) {
    if (p_capture) {
        this.listeners.unshift(p_listener);
    }
    else {
        this.listeners.push(p_listener);
    }
};

Cordova.EventHandler.prototype.removeEventListener = function(p_listener, p_capture) {
    for (var i = 0; i < this.listeners.length; i++) {
        if (this.listeners[i] === p_listener) {
            this.listeners.splice(i, 1);
            break;
        }
    }
};

Cordova.EventHandler.prototype.dispatchEvent = function() {
    var event = new Cordova.Event();
    event.initEvent(this.type, false, false);

    for (var i = 0; i < this.listeners.length; i++) {
        this.listeners[i].apply(Cordova, arguments);
    }
};

Cordova.events = {
    deviceready: new Cordova.EventHandler("deviceready"),
    resume: new Cordova.EventHandler("resume"),
    pause: new Cordova.EventHandler("pause"),
    online: new Cordova.EventHandler("online"),
    offline: new Cordova.EventHandler("offline"),
    backbutton: new Cordova.EventHandler("backbutton"),
    batterycritical: new Cordova.EventHandler("batterycritical"),
    batterylow: new Cordova.EventHandler("batterylow"),
    batterystatus: new Cordova.EventHandler("batterystatus"),
    menubutton: new Cordova.EventHandler("menubutton"),
    searchbutton: new Cordova.EventHandler("searchbutton"),
    startcallbutton: new Cordova.EventHandler("startcallbutton"),
    endcallbutton: new Cordova.EventHandler("endcallbutton"),
    volumedownbutton: new Cordova.EventHandler("volumedownbutton"),
    volumeupbutton: new Cordova.EventHandler("volumeupbutton")
};

//Keep references to the original EventTarget implementations
Cordova.doc_addEventListener = document.addEventListener;
Cordova.doc_removeEventListener = document.removeEventListener;
Cordova.doc_dispatchEvent = document.dispatchEvent;

document.addEventListener = function(type, listener, useCapture) {
    if (typeof Cordova.events[type] !== "undefined") {
        Cordova.events[type].addEventListener(listener, useCapture);
    } else {
        Cordova.doc_addEventListener.call(document, type, listener, useCapture);
    }
};

document.removeEventListener = function(type, listener, useCapture) {
    if (typeof Cordova.events[type] !== "undefined") {
        Cordova.events[type].removeEventListener(listener, useCapture);
    } else {
        Cordova.doc_removeEventListener.call(document, type, listener, useCapture);
    }
};

document.dispatchEvent = function (evt) {
    if (typeof Cordova.events[evt.type] !== "undefined") {
        Cordova.events[evt.type].dispatchEvent();
    } else {
        Cordova.doc_dispatchEvent.call(document, evt);
    }
};

var deviceReadyCounter = 0;
var isDeviceReady = false;
Cordova.deviceready = function() {
    isDeviceReady = true;
    if (!deviceReadyCounter) {
        Cordova.events.deviceready.dispatchEvent();
    }
}
Cordova.deviceready.freeze = function() {
    if (isDeviceReady && !deviceReadyCounter) {
        console.log('WARNING: trying freeze deviceready event after it was emited');
    }
    deviceReadyCounter++;
}
Cordova.deviceready.unfreeze = function() {
    deviceReadyCounter--;
    if (!deviceReadyCounter && isDeviceReady) {
        Cordova.deviceready();
    }
}


Cordova.resumeOccured = function() {
    Cordova.events.resume.dispatchEvent();
}
Cordova.pauseOccured = function() {
    Cordova.events.pause.dispatchEvent();
}
Cordova.onlineOccured = function() {
    Cordova.events.online.dispatchEvent();
}
Cordova.offlineOccured = function() {
    Cordova.events.offline.dispatchEvent();
}

navigator.battery = {
    _level: null,
    _isPlugged: null
};

Cordova.batteryStatusChanged = function(level, isPlugged, forceStatus) {
    if (navigator.battery._level === level && navigator.battery._isPlugged === isPlugged)
        return;

    console.log("Cordova.batteryStatusChanged: " + level + ", " + isPlugged + ", " + forceStatus)
    if (level < 3 && !forceStatus)
        Cordova.events.batterycritical.dispatchEvent({level: level, isPlugged: isPlugged})
    else if (level < 40 && !forceStatus)
        Cordova.events.batterylow.dispatchEvent({level: level, isPlugged: isPlugged})
    Cordova.events.batterystatus.dispatchEvent({level: level, isPlugged: isPlugged})

    navigator.battery._level = level;
    navigator.battery._isPlugged = isPlugged;
}

Cordova.menuKeyPressed = function() {
    Cordova.events.menubutton.dispatchEvent();
}
Cordova.backKeyPressed = function() {
    Cordova.events.backbutton.dispatchEvent();
}
Cordova.searchKeyPressed = function() {
    Cordova.events.searchbutton.dispatchEvent();
}
Cordova.callKeyPressed = function() {
    Cordova.events.startcallbutton.dispatchEvent();
}
Cordova.hangupKeyPressed = function() {
    Cordova.events.endcallbutton.dispatchEvent();
}
Cordova.volumeUpKeyPressed = function() {
    Cordova.events.volumeupbutton.dispatchEvent();
}
Cordova.volumeDownKeyPressed = function() {
    Cordova.events.volumedownbutton.dispatchEvent();
}
