/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXException;

public class IdentityTransformerHandler
extends ReceivingContentHandler
implements TransformerHandler {
    private Result result;
    private String systemId;
    private Controller controller;

    protected IdentityTransformerHandler(Controller controller) {
        this.controller = controller;
        this.setPipelineConfiguration(controller.makePipelineConfiguration());
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void startDocument() throws SAXException {
        if (this.result == null) {
            this.result = new StreamResult(System.out);
        }
        try {
            Properties properties = this.controller.getOutputProperties();
            PipelineConfiguration pipelineConfiguration = this.controller.makePipelineConfiguration();
            SerializerFactory serializerFactory = this.getConfiguration().getSerializerFactory();
            this.setReceiver(serializerFactory.getReceiver(this.result, pipelineConfiguration, properties));
            this.setPipelineConfiguration(pipelineConfiguration);
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException);
        }
        super.startDocument();
    }
}

