/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;

public class IntToIntHashMap
implements Serializable {
    private static final int NBIT = 30;
    private static final int NMAX = 0x40000000;
    private double _factor;
    private int _defaultValue = Integer.MAX_VALUE;
    private int _nmax;
    private int _n;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _key;
    private int[] _value;
    private boolean[] _filled;

    public IntToIntHashMap() {
        this(8, 0.25);
    }

    public IntToIntHashMap(int n) {
        this(n, 0.25);
    }

    public IntToIntHashMap(int n, double d) {
        this._factor = d;
        this.setCapacity(n);
    }

    public void setDefaultValue(int n) {
        this._defaultValue = n;
    }

    public int getDefaultValue() {
        return this._defaultValue;
    }

    public void clear() {
        this._n = 0;
        for (int i = 0; i < this._nmax; ++i) {
            this._filled[i] = false;
        }
    }

    public boolean find(int n) {
        return this._filled[this.indexOf(n)];
    }

    public int get(int n) {
        int n2 = this.indexOf(n);
        return this._filled[n2] ? this._value[n2] : this._defaultValue;
    }

    public int size() {
        return this._n;
    }

    public boolean remove(int n) {
        int n2 = this.indexOf(n);
        if (!this._filled[n2]) {
            return false;
        }
        --this._n;
        while (true) {
            int n3;
            this._filled[n2] = false;
            int n4 = n2;
            do {
                if (this._filled[n2 = n2 - 1 & this._mask]) continue;
                return true;
            } while (n2 <= (n3 = this.hash(this._key[n2])) && n3 < n4 || n3 < n4 && n4 < n2 || n4 < n2 && n2 <= n3);
            this._key[n4] = this._key[n2];
            this._value[n4] = this._value[n2];
            this._filled[n4] = this._filled[n2];
        }
    }

    public void put(int n, int n2) {
        int n3 = this.indexOf(n);
        if (this._filled[n3]) {
            this._value[n3] = n2;
        } else {
            this._key[n3] = n;
            this._value[n3] = n2;
            this._filled[n3] = true;
            this.grow();
        }
    }

    private int hash(int n) {
        return 1327217885 * n >> this._shift & this._mask;
    }

    private int indexOf(int n) {
        int n2 = this.hash(n);
        while (this._filled[n2]) {
            if (this._key[n2] == n) {
                return n2;
            }
            n2 = n2 - 1 & this._mask;
        }
        return n2;
    }

    private void grow() {
        ++this._n;
        if (this._n > 0x40000000) {
            throw new RuntimeException("number of keys mapped exceeds 1073741824");
        }
        if (this._nlo < this._n && this._n <= this._nhi) {
            this.setCapacity(this._n);
        }
    }

    private void setCapacity(int n) {
        int n2;
        if (n < this._n) {
            n = this._n;
        }
        double d = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int n3 = 1;
        for (n2 = 2; (double)n2 * d < (double)n && n2 < 0x40000000; n2 *= 2) {
            ++n3;
        }
        int n4 = this._nmax;
        if (n2 == n4) {
            return;
        }
        this._nmax = n2;
        this._nlo = (int)((double)n2 * d);
        this._nhi = (int)(1.073741824E9 * d);
        this._shift = 31 - n3;
        this._mask = n2 - 1;
        int[] nArray = this._key;
        int[] nArray2 = this._value;
        boolean[] blArray = this._filled;
        this._n = 0;
        this._key = new int[n2];
        this._value = new int[n2];
        this._filled = new boolean[n2];
        if (nArray != null) {
            for (int i = 0; i < n4; ++i) {
                if (!blArray[i]) continue;
                this.put(nArray[i], nArray2[i]);
            }
        }
    }
}

