'\"
'\" Generated from file 'critcl_iassoc\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2011-2015 Andreas Kupries
'\"
.TH "critcl::iassoc" n 1 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl::iassoc \- CriTcl Utilities: Tcl Interp Associations
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBcritcl  ?3\&.1?\fR
.sp
package require \fBcritcl::iassoc  ?1?\fR
.sp
\fB::critcl::iassoc::def\fR \fIname\fR \fIarguments\fR \fIstruct\fR \fIconstructor\fR \fIdestructor\fR
.sp
.BE
.SH DESCRIPTION
.PP
Welcome to the \fIC Runtime In Tcl\fR, \fICriTcl\fR for short, a
system to build C extension packages for Tcl on the fly, from C code
embedded within Tcl scripts, for all who wish to make their code go
faster\&.
.PP
This document is the reference manpage for the \fBcritcl::iassoc\fR
package\&. This package provides convenience commands for advanced
functionality built on top of the critcl core\&.
.PP
With it a user wishing to associate some data with a Tcl
interpreter via Tcl's \fBTcl_(Get|Set)AssocData()\fR APIs can now
concentrate on the data itself, while all the necessary boilerplate
around it is managed by this package\&.
.PP
Its intended audience are mainly developers wishing to write
Tcl packages with embedded C code\&.
.PP
This package resides in the Core Package Layer of CriTcl\&.
.PP
.PS
.nf
+----------------+
|Applications    |
| critcl         |
| critcl::app    |
+----------------+

*================*
|Core Packages   |
| critcl         |
| critcl::util   |
*================*

+----------------+
|Support Packages|
| stubs::*       |
| md5, platform  |
|  \&.\&.\&.           |
+----------------+

.fi
.PE
.PP
.SH API
.TP
\fB::critcl::iassoc::def\fR \fIname\fR \fIarguments\fR \fIstruct\fR \fIconstructor\fR \fIdestructor\fR
This command defines a C function with the given \fIname\fR which
provides access to a structure associated with a Tcl interpreter\&.
.sp
The C code code fragment \fIstruct\fR defines the elements of
said structure, whereas the fragments \fIconstructor\fR and
\fIdestructor\fR are C code blocks executed to initialize and release
any dynamically allocated parts of this structure, when needed\&. Note
that the structure itself is managed by the system\&.
.sp
The new function takes a \fBTcl_Interp*\fR pointer refering
to the interpreter whose structure we wish to obtain as the first
argument, plus the specified \fIarguments\fR and returns a pointer to
the associated structure, of type "\fIname\fR_data" (see below)\&.
.sp
The \fIarguments\fR are a dictionary-like list of C types and
identifiers specifying additional arguments for the accessor function,
and, indirectly, the \fIconstructor\fR C code block\&. This is useful
for the supplication of initialization values, or the return of more
complex error information in case of a construction failure\&.
.sp
The C types associated with the structure are derived from
\fIname\fR, with "\fIname\fR_data__" the type of the structure itself,
and "\fIname\fR_data" representing a pointer to the structure\&.
The C code blocks can rely on the following C environments:
.RS
.TP
\fIconstructor\fR
.RS
.TP
\fBdata\fR
Pointer to the structure (type: \fIname\fR_data) to
initialize\&.
.TP
\fBinterp\fR
Pointer to the Tcl interpreter (type: Tcl_Interp*)
the new structure will be associated with\&.
.TP
error
A C code label the constructor can jump to should it have
to signal a construction failure\&. It is the responsibility of the
constructor to release any fields already initialized before jumping
to this label\&.
.TP
\&.\&.\&.
The names of the constructor arguments specified with
\fIarguments\fR\&.
.RE
.TP
\fIdestructor\fR
.RS
.TP
\fBdata\fR
Pointer to the structure being released\&.
.TP
\fBinterp\fR
Pointer to the Tcl interpreter the structure
belonged to\&.
.RE
.RE
.PP
.SH EXAMPLE
The example shown below is the specification of a simple interpreter-associated
counter\&. The full example, with meta data and other incidentals, can be found
in the directory "\fIexamples/queue\fR" of the critcl source
distribution/repository\&.
.CS


package require Tcl 8\&.4
package require critcl 3\&.1

critcl::buildrequirement {
    package require critcl::iassoc
}

critcl::iassoc::def icounter {} {
    int counter; /* The counter variable */
} {
    data->counter = 0;
} {
    /* Nothing to release */
}

critcl::ccode {
    \&.\&.\&. function (\&.\&.\&.)
    {
         /* Access to the data \&.\&.\&. */
         icounter_data D = icounter (interp /* \&.\&.\&. any declared arguments, here, none */);
	 \&.\&.\&. D->counter \&.\&.\&.
    }
}
# or, of course, 'cproc's, 'ccommand's etc\&.

package provide icounter 1

.CE
.SH AUTHORS
Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such at \fIhttps://github\&.com/andreas-kupries/critcl\fR\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
C code, Embedded C Code, Tcl Interp Association, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, on demand compilation, on-the-fly compilation, singleton
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) 2011-2015 Andreas Kupries

.fi