#include "thread"
#include "sys/sys"

void *Thread::_run (void *data) {
    Thread *t = (Thread*) data;

    debugmsg("Thread: starting run\n");
    Threadlist::enregister();    
    try {
	t->execute();
    } catch (Error const &e) {
	mutex_lock(&cerr);
	if (config.prefixtimestamp()) {
	    Timestamp tm;
	    cerr << tm.desc() << ' ';
	}
	cerr << e.what() << "\n";
	mutex_unlock(&cerr);
    }
    Threadlist::deregister();
    debugmsg("Thread: ending run\n");

    // Cleanups
    delete (t);

    // To satisfy the prototype
    return (0);
}

