/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::cdtBisimilar__option_t::type& Options::operator[](
    options::cdtBisimilar__option_t) const
{
  return d_holder->cdtBisimilar;
}
template <> bool Options::wasSetByUser(options::cdtBisimilar__option_t) const
{
  return d_holder->cdtBisimilar__setByUser__;
}
template <> const options::dtBinarySplit__option_t::type& Options::operator[](
    options::dtBinarySplit__option_t) const
{
  return d_holder->dtBinarySplit;
}
template <> bool Options::wasSetByUser(options::dtBinarySplit__option_t) const
{
  return d_holder->dtBinarySplit__setByUser__;
}
template <> const options::dtBlastSplits__option_t::type& Options::operator[](
    options::dtBlastSplits__option_t) const
{
  return d_holder->dtBlastSplits;
}
template <> bool Options::wasSetByUser(options::dtBlastSplits__option_t) const
{
  return d_holder->dtBlastSplits__setByUser__;
}
template <> const options::dtCyclic__option_t::type& Options::operator[](
    options::dtCyclic__option_t) const
{
  return d_holder->dtCyclic;
}
template <> bool Options::wasSetByUser(options::dtCyclic__option_t) const
{
  return d_holder->dtCyclic__setByUser__;
}
template <> void Options::set(
    options::dtForceAssignment__option_t,
    const options::dtForceAssignment__option_t::type& x)
{
  d_holder->dtForceAssignment = x;
}
template <> const options::dtForceAssignment__option_t::type& Options::operator[](
    options::dtForceAssignment__option_t) const
{
  return d_holder->dtForceAssignment;
}
template <> bool Options::wasSetByUser(options::dtForceAssignment__option_t) const
{
  return d_holder->dtForceAssignment__setByUser__;
}
template <> const options::dtInferAsLemmas__option_t::type& Options::operator[](
    options::dtInferAsLemmas__option_t) const
{
  return d_holder->dtInferAsLemmas;
}
template <> bool Options::wasSetByUser(options::dtInferAsLemmas__option_t) const
{
  return d_holder->dtInferAsLemmas__setByUser__;
}
template <> const options::dtRefIntro__option_t::type& Options::operator[](
    options::dtRefIntro__option_t) const
{
  return d_holder->dtRefIntro;
}
template <> bool Options::wasSetByUser(options::dtRefIntro__option_t) const
{
  return d_holder->dtRefIntro__setByUser__;
}
template <> void Options::set(
    options::dtRewriteErrorSel__option_t,
    const options::dtRewriteErrorSel__option_t::type& x)
{
  d_holder->dtRewriteErrorSel = x;
}
template <> const options::dtRewriteErrorSel__option_t::type& Options::operator[](
    options::dtRewriteErrorSel__option_t) const
{
  return d_holder->dtRewriteErrorSel;
}
template <> bool Options::wasSetByUser(options::dtRewriteErrorSel__option_t) const
{
  return d_holder->dtRewriteErrorSel__setByUser__;
}
template <> const options::dtSharedSelectors__option_t::type& Options::operator[](
    options::dtSharedSelectors__option_t) const
{
  return d_holder->dtSharedSelectors;
}
template <> bool Options::wasSetByUser(options::dtSharedSelectors__option_t) const
{
  return d_holder->dtSharedSelectors__setByUser__;
}
template <> const options::dtUseTesters__option_t::type& Options::operator[](
    options::dtUseTesters__option_t) const
{
  return d_holder->dtUseTesters;
}
template <> bool Options::wasSetByUser(options::dtUseTesters__option_t) const
{
  return d_holder->dtUseTesters__setByUser__;
}
template <> const options::sygusAbortSize__option_t::type& Options::operator[](
    options::sygusAbortSize__option_t) const
{
  return d_holder->sygusAbortSize;
}
template <> bool Options::wasSetByUser(options::sygusAbortSize__option_t) const
{
  return d_holder->sygusAbortSize__setByUser__;
}
template <> const options::sygusEvalBuiltin__option_t::type& Options::operator[](
    options::sygusEvalBuiltin__option_t) const
{
  return d_holder->sygusEvalBuiltin;
}
template <> bool Options::wasSetByUser(options::sygusEvalBuiltin__option_t) const
{
  return d_holder->sygusEvalBuiltin__setByUser__;
}
template <> const options::sygusFairMax__option_t::type& Options::operator[](
    options::sygusFairMax__option_t) const
{
  return d_holder->sygusFairMax;
}
template <> bool Options::wasSetByUser(options::sygusFairMax__option_t) const
{
  return d_holder->sygusFairMax__setByUser__;
}
template <> const options::sygusFair__option_t::type& Options::operator[](
    options::sygusFair__option_t) const
{
  return d_holder->sygusFair;
}
template <> bool Options::wasSetByUser(options::sygusFair__option_t) const
{
  return d_holder->sygusFair__setByUser__;
}
template <> const options::sygusOpt1__option_t::type& Options::operator[](
    options::sygusOpt1__option_t) const
{
  return d_holder->sygusOpt1;
}
template <> bool Options::wasSetByUser(options::sygusOpt1__option_t) const
{
  return d_holder->sygusOpt1__setByUser__;
}
template <> const options::sygusSymBreak__option_t::type& Options::operator[](
    options::sygusSymBreak__option_t) const
{
  return d_holder->sygusSymBreak;
}
template <> bool Options::wasSetByUser(options::sygusSymBreak__option_t) const
{
  return d_holder->sygusSymBreak__setByUser__;
}
template <> const options::sygusSymBreakDynamic__option_t::type& Options::operator[](
    options::sygusSymBreakDynamic__option_t) const
{
  return d_holder->sygusSymBreakDynamic;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakDynamic__option_t) const
{
  return d_holder->sygusSymBreakDynamic__setByUser__;
}
template <> const options::sygusSymBreakLazy__option_t::type& Options::operator[](
    options::sygusSymBreakLazy__option_t) const
{
  return d_holder->sygusSymBreakLazy;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakLazy__option_t) const
{
  return d_holder->sygusSymBreakLazy__setByUser__;
}
template <> void Options::set(
    options::sygusSymBreakPbe__option_t,
    const options::sygusSymBreakPbe__option_t::type& x)
{
  d_holder->sygusSymBreakPbe = x;
}
template <> const options::sygusSymBreakPbe__option_t::type& Options::operator[](
    options::sygusSymBreakPbe__option_t) const
{
  return d_holder->sygusSymBreakPbe;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakPbe__option_t) const
{
  return d_holder->sygusSymBreakPbe__setByUser__;
}
template <> const options::sygusSymBreakRlv__option_t::type& Options::operator[](
    options::sygusSymBreakRlv__option_t) const
{
  return d_holder->sygusSymBreakRlv;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakRlv__option_t) const
{
  return d_holder->sygusSymBreakRlv__setByUser__;
}


namespace options {

struct cdtBisimilar__option_t cdtBisimilar;
struct dtBinarySplit__option_t dtBinarySplit;
struct dtBlastSplits__option_t dtBlastSplits;
struct dtCyclic__option_t dtCyclic;
struct dtForceAssignment__option_t dtForceAssignment;
struct dtInferAsLemmas__option_t dtInferAsLemmas;
struct dtRefIntro__option_t dtRefIntro;
struct dtRewriteErrorSel__option_t dtRewriteErrorSel;
struct dtSharedSelectors__option_t dtSharedSelectors;
struct dtUseTesters__option_t dtUseTesters;
struct sygusAbortSize__option_t sygusAbortSize;
struct sygusEvalBuiltin__option_t sygusEvalBuiltin;
struct sygusFairMax__option_t sygusFairMax;
struct sygusFair__option_t sygusFair;
struct sygusOpt1__option_t sygusOpt1;
struct sygusSymBreak__option_t sygusSymBreak;
struct sygusSymBreakDynamic__option_t sygusSymBreakDynamic;
struct sygusSymBreakLazy__option_t sygusSymBreakLazy;
struct sygusSymBreakPbe__option_t sygusSymBreakPbe;
struct sygusSymBreakRlv__option_t sygusSymBreakRlv;


}  // namespace options
}  // namespace CVC4
