/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::defaultDagThresh__option_t::type& Options::operator[](
    options::defaultDagThresh__option_t) const
{
  return d_holder->defaultDagThresh;
}
template <> bool Options::wasSetByUser(options::defaultDagThresh__option_t) const
{
  return d_holder->defaultDagThresh__setByUser__;
}
template <> const options::defaultExprDepth__option_t::type& Options::operator[](
    options::defaultExprDepth__option_t) const
{
  return d_holder->defaultExprDepth;
}
template <> bool Options::wasSetByUser(options::defaultExprDepth__option_t) const
{
  return d_holder->defaultExprDepth__setByUser__;
}
template <> const options::earlyTypeChecking__option_t::type& Options::operator[](
    options::earlyTypeChecking__option_t) const
{
  return d_holder->earlyTypeChecking;
}
template <> bool Options::wasSetByUser(options::earlyTypeChecking__option_t) const
{
  return d_holder->earlyTypeChecking__setByUser__;
}
template <> const options::printExprTypes__option_t::type& Options::operator[](
    options::printExprTypes__option_t) const
{
  return d_holder->printExprTypes;
}
template <> bool Options::wasSetByUser(options::printExprTypes__option_t) const
{
  return d_holder->printExprTypes__setByUser__;
}
template <> const options::typeChecking__option_t::type& Options::operator[](
    options::typeChecking__option_t) const
{
  return d_holder->typeChecking;
}
template <> bool Options::wasSetByUser(options::typeChecking__option_t) const
{
  return d_holder->typeChecking__setByUser__;
}


namespace options {

struct defaultDagThresh__option_t defaultDagThresh;
struct defaultExprDepth__option_t defaultExprDepth;
struct earlyTypeChecking__option_t earlyTypeChecking;
struct printExprTypes__option_t printExprTypes;
struct typeChecking__option_t typeChecking;


}  // namespace options
}  // namespace CVC4
