/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> const options::continuedExecution__option_t::type& Options::operator[](
    options::continuedExecution__option_t) const
{
  return d_holder->continuedExecution;
}
template <> bool Options::wasSetByUser(options::continuedExecution__option_t) const
{
  return d_holder->continuedExecution__setByUser__;
}
template <> const options::earlyExit__option_t::type& Options::operator[](
    options::earlyExit__option_t) const
{
  return d_holder->earlyExit;
}
template <> bool Options::wasSetByUser(options::earlyExit__option_t) const
{
  return d_holder->earlyExit__setByUser__;
}
template <> const options::fallbackSequential__option_t::type& Options::operator[](
    options::fallbackSequential__option_t) const
{
  return d_holder->fallbackSequential;
}
template <> bool Options::wasSetByUser(options::fallbackSequential__option_t) const
{
  return d_holder->fallbackSequential__setByUser__;
}
template <> void Options::set(
    options::sharingFilterByLength__option_t,
    const options::sharingFilterByLength__option_t::type& x)
{
  d_holder->sharingFilterByLength = x;
}
template <> const options::sharingFilterByLength__option_t::type& Options::operator[](
    options::sharingFilterByLength__option_t) const
{
  return d_holder->sharingFilterByLength;
}
template <> bool Options::wasSetByUser(options::sharingFilterByLength__option_t) const
{
  return d_holder->sharingFilterByLength__setByUser__;
}
template <> const options::help__option_t::type& Options::operator[](
    options::help__option_t) const
{
  return d_holder->help;
}
template <> bool Options::wasSetByUser(options::help__option_t) const
{
  return d_holder->help__setByUser__;
}
template <> const options::incrementalParallel__option_t::type& Options::operator[](
    options::incrementalParallel__option_t) const
{
  return d_holder->incrementalParallel;
}
template <> bool Options::wasSetByUser(options::incrementalParallel__option_t) const
{
  return d_holder->incrementalParallel__setByUser__;
}
template <> void Options::set(
    options::interactive__option_t,
    const options::interactive__option_t::type& x)
{
  d_holder->interactive = x;
}
template <> const options::interactive__option_t::type& Options::operator[](
    options::interactive__option_t) const
{
  return d_holder->interactive;
}
template <> bool Options::wasSetByUser(options::interactive__option_t) const
{
  return d_holder->interactive__setByUser__;
}
template <> const options::interactivePrompt__option_t::type& Options::operator[](
    options::interactivePrompt__option_t) const
{
  return d_holder->interactivePrompt;
}
template <> bool Options::wasSetByUser(options::interactivePrompt__option_t) const
{
  return d_holder->interactivePrompt__setByUser__;
}
template <> const options::seed__option_t::type& Options::operator[](
    options::seed__option_t) const
{
  return d_holder->seed;
}
template <> bool Options::wasSetByUser(options::seed__option_t) const
{
  return d_holder->seed__setByUser__;
}
template <> const options::segvSpin__option_t::type& Options::operator[](
    options::segvSpin__option_t) const
{
  return d_holder->segvSpin;
}
template <> bool Options::wasSetByUser(options::segvSpin__option_t) const
{
  return d_holder->segvSpin__setByUser__;
}
template <> const options::tearDownIncremental__option_t::type& Options::operator[](
    options::tearDownIncremental__option_t) const
{
  return d_holder->tearDownIncremental;
}
template <> bool Options::wasSetByUser(options::tearDownIncremental__option_t) const
{
  return d_holder->tearDownIncremental__setByUser__;
}
template <> const options::threadStackSize__option_t::type& Options::operator[](
    options::threadStackSize__option_t) const
{
  return d_holder->threadStackSize;
}
template <> bool Options::wasSetByUser(options::threadStackSize__option_t) const
{
  return d_holder->threadStackSize__setByUser__;
}
template <> void Options::set(
    options::threadArgv__option_t,
    const options::threadArgv__option_t::type& x)
{
  d_holder->threadArgv = x;
}
template <> const options::threadArgv__option_t::type& Options::operator[](
    options::threadArgv__option_t) const
{
  return d_holder->threadArgv;
}
template <> bool Options::wasSetByUser(options::threadArgv__option_t) const
{
  return d_holder->threadArgv__setByUser__;
}
template <> void Options::set(
    options::thread_id__option_t,
    const options::thread_id__option_t::type& x)
{
  d_holder->thread_id = x;
}
template <> const options::thread_id__option_t::type& Options::operator[](
    options::thread_id__option_t) const
{
  return d_holder->thread_id;
}
template <> bool Options::wasSetByUser(options::thread_id__option_t) const
{
  return d_holder->thread_id__setByUser__;
}
template <> const options::threads__option_t::type& Options::operator[](
    options::threads__option_t) const
{
  return d_holder->threads;
}
template <> bool Options::wasSetByUser(options::threads__option_t) const
{
  return d_holder->threads__setByUser__;
}
template <> const options::version__option_t::type& Options::operator[](
    options::version__option_t) const
{
  return d_holder->version;
}
template <> bool Options::wasSetByUser(options::version__option_t) const
{
  return d_holder->version__setByUser__;
}
template <> const options::waitToJoin__option_t::type& Options::operator[](
    options::waitToJoin__option_t) const
{
  return d_holder->waitToJoin;
}
template <> bool Options::wasSetByUser(options::waitToJoin__option_t) const
{
  return d_holder->waitToJoin__setByUser__;
}


namespace options {

struct continuedExecution__option_t continuedExecution;
struct earlyExit__option_t earlyExit;
struct fallbackSequential__option_t fallbackSequential;
struct sharingFilterByLength__option_t sharingFilterByLength;
struct help__option_t help;
struct incrementalParallel__option_t incrementalParallel;
struct interactive__option_t interactive;
struct interactivePrompt__option_t interactivePrompt;
struct seed__option_t seed;
struct segvSpin__option_t segvSpin;
struct tearDownIncremental__option_t tearDownIncremental;
struct threadStackSize__option_t threadStackSize;
struct threadArgv__option_t threadArgv;
struct thread_id__option_t thread_id;
struct threads__option_t threads;
struct version__option_t version;
struct waitToJoin__option_t waitToJoin;


}  // namespace options
}  // namespace CVC4
