/*
**  Copyright (c) 2005-2008 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef lint
static char t_test04_c_id[] = "@(#)$Id: t-test04.c,v 1.1 2008/03/09 14:54:33 msk Exp $";
#endif /* !lint */

/* system includes */
#include <sys/types.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>

/* libdk includes */
#include "dk.h"
#include "t-testdata.h"

#define SIGHEADER "a=rsa-sha1; c=nofws; d=example.com; s=test; h=from:to:date:subject:message-id; b=cvrt8mI1kxfzoUrryNTJbbfrd+f35lqjrNSUCS2Y54jZu9KxnVMR+Yk/MWJ2wET94koRvBPDhPsAENGk98iuGXyMjGQl2vAEp3EwRrCzvhkwRRiTwqGDuKwZGoCIM/BBqS8U1OsA9OricRhN+0cOoDK4lhQmCrIPWGcStTVwjb8="

/*
**  MAIN -- program mainline
**
**  Parameters:
**  	The usual.
**
**  Return value:
**  	Exit status.
*/

int
main(int argc, char **argv)
{
#ifdef TEST_KEEP_FILES
	u_int flags;
#endif /* TEST_KEEP_FILES */
	DK_STAT status;
	DK *dk;
	DK_LIB *lib;
	dk_query_t qtype = DK_QUERY_FILE;
	unsigned char hdr[MAXHEADER + 1];

	printf("*** nofws rsa-sha1 verifying with h= tag\n");

	/* instantiate the library */
	lib = dk_init(NULL, NULL);
	assert(lib != NULL);

#ifdef TEST_KEEP_FILES
	/* set flags */
	flags = (DK_LIBFLAGS_TMPFILES|DK_LIBFLAGS_KEEPFILES);
	(void) dk_options(lib, DK_OP_SETOPT, DK_OPTS_FLAGS, &flags,
	                    sizeof flags);
#endif /* TEST_KEEP_FILES */

	(void) dk_options(lib, DK_OP_SETOPT, DK_OPTS_QUERYMETHOD,
	                  &qtype, sizeof qtype);
	(void) dk_options(lib, DK_OP_SETOPT, DK_OPTS_QUERYINFO,
	                  KEYFILE, strlen(KEYFILE));

	dk = dk_verify(lib, JOBID, NULL, &status);
	assert(dk != NULL);

	snprintf(hdr, sizeof hdr, "%s: %s", DK_SIGNHEADER, SIGHEADER);
	status = dk_header(dk, hdr, strlen(hdr));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER01, strlen(HEADER01));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER02, strlen(HEADER02));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER03, strlen(HEADER03));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER04, strlen(HEADER04));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER05, strlen(HEADER05));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER06, strlen(HEADER06));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER07, strlen(HEADER07));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER08, strlen(HEADER08));
	assert(status == DK_STAT_OK);

	status = dk_header(dk, HEADER09, strlen(HEADER09));
	assert(status == DK_STAT_OK);

	status = dk_eoh(dk);
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY00, strlen(BODY00));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY01, strlen(BODY01));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY01A, strlen(BODY01A));
	assert(status == DK_STAT_OK);
	status = dk_body(dk, BODY01B, strlen(BODY01B));
	assert(status == DK_STAT_OK);
	status = dk_body(dk, BODY01C, strlen(BODY01C));
	assert(status == DK_STAT_OK);
	status = dk_body(dk, BODY01D, strlen(BODY01D));
	assert(status == DK_STAT_OK);
	status = dk_body(dk, BODY01E, strlen(BODY01E));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY02, strlen(BODY02));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY03, strlen(BODY03));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY04, strlen(BODY04));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY03, strlen(BODY03));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY03, strlen(BODY03));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY05, strlen(BODY05));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY03, strlen(BODY03));
	assert(status == DK_STAT_OK);

	status = dk_body(dk, BODY03, strlen(BODY03));
	assert(status == DK_STAT_OK);

	status = dk_eom(dk, NULL);
	assert(status == DK_STAT_OK);

	status = dk_free(dk);
	assert(status == DK_STAT_OK);

	dk_close(lib);

	return 0;
}
