/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SCAN_H
#define SCAN_H

#include "ipv4.h"
#include "subnets.h"
#include "ticks.h"

#include <sys/poll.h>

struct scan_host_t;
typedef void (*scan_callback_t) (struct scan_host_t *);
/* Called when a descriptor is ready for I/O, or is about to close.
   Should change the state, io_callback and close_callback structure
   fields as necessary.  If io_callback or timeout are null pointers,
   close_callback is called, and the socket is closed.

   The callback should update the timeout field (it is measured in
   milliseconds).  If the timeout passes without further activity,
   close_callback is called and the socket is closed.

   The error field can be set to a non-zero errno value.  In this
   case, the socket is closed (and close_callback is called, but at
   most once).

   close_callback must not close the socket.  The fields poll,
   poll->sockfd and host must not be modified by any callback
   routine. */

typedef struct scan_host_t {
  struct pollfd *poll;
  ticks_t timeout;
  ipv4_t host;
  void *state;
  scan_callback_t io_callback, close_callback;
} scan_host_t;

void scan(subnets&);
/* Starts TCP scanning, using the selected protocol module. */

#endif

/* arch-tag: bfd1ea5c-33a5-436f-8001-e2dc2eb2ca20
 */
