/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.text.regex;

import com.oroinc.text.regex.CharStringPointer;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.OpCode;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternCompiler;
import com.oroinc.text.regex.Perl5Pattern;

public final class Perl5Compiler
implements PatternCompiler {
    private static final int __WORSTCASE = 0;
    private static final int __NONNULL = 1;
    private static final int __SIMPLE = 2;
    private static final int __SPSTART = 4;
    private static final int __TRYAGAIN = 8;
    private static final char __CASE_INSENSITIVE = '\u0001';
    private static final char __GLOBAL = '\u0002';
    private static final char __KEEP = '\u0004';
    private static final char __MULTILINE = '\b';
    private static final char __SINGLELINE = '\u0010';
    private static final char __EXTENDED = ' ';
    private static final char __READ_ONLY = '\u8000';
    private static final String __META_CHARS = "^$.[()|?+*\\";
    private static final String __HEX_DIGIT = "0123456789abcdef0123456789ABCDEFx";
    private CharStringPointer __input;
    private boolean __sawBackreference;
    private char[] __modifierFlags = new char[1];
    private int __numParentheses;
    private int __programSize;
    private int __cost;
    private char[] __program;
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int MULTILINE_MASK = 8;
    public static final int SINGLELINE_MASK = 16;
    public static final int EXTENDED_MASK = 32;
    public static final int READ_ONLY_MASK = 32768;

    public static final String quotemeta(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(2 * cArray.length);
        int n = 0;
        while (n < cArray.length) {
            if (!OpCode._isWordCharacter(cArray[n])) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String quotemeta(String string) {
        return Perl5Compiler.quotemeta(string.toCharArray());
    }

    static boolean _isSimpleRepetitionOp(char c) {
        return c == '*' || c == '+' || c == '?';
    }

    static boolean _isComplexRepetitionOp(char[] cArray, int n) {
        if (n < cArray.length && n >= 0) {
            return cArray[n] == '*' || cArray[n] == '+' || cArray[n] == '?' || cArray[n] == '{' && Perl5Compiler._parseRepetition(cArray, n);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    static boolean _parseRepetition(char[] var0, int var1_1) {
        if (var0[var1_1] != '{') {
            return false;
        }
        if (++var1_1 < var0.length && Character.isDigit(var0[var1_1])) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            ++var1_1;
lbl6:
            // 2 sources

            ** while (var1_1 < var0.length && Character.isDigit((char)var0[var1_1]))
        }
lbl7:
        // 1 sources

        if (var1_1 < var0.length && var0[var1_1] == ',') {
            ++var1_1;
        }
        while (var1_1 < var0.length && Character.isDigit(var0[var1_1])) {
            ++var1_1;
        }
        return var1_1 < var0.length && var0[var1_1] == '}';
    }

    static int _parseHex(char[] cArray, int n, int n2, int[] nArray) {
        int n3;
        int n4 = 0;
        nArray[0] = 0;
        while (n < cArray.length && n2-- > 0 && (n3 = __HEX_DIGIT.indexOf(cArray[n])) != -1) {
            n4 <<= 4;
            n4 |= n3 & 0xF;
            ++n;
            nArray[0] = nArray[0] + 1;
        }
        return n4;
    }

    static int _parseOctal(char[] cArray, int n, int n2, int[] nArray) {
        int n3 = 0;
        nArray[0] = 0;
        while (n < cArray.length && n2 > 0 && cArray[n] >= '0' && cArray[n] <= '7') {
            n3 <<= 3;
            n3 |= cArray[n] - 48;
            --n2;
            ++n;
            nArray[0] = nArray[0] + 1;
        }
        return n3;
    }

    static void _setModifierFlag(char[] cArray, char c) {
        switch (c) {
            case 'i': {
                cArray[0] = (char)(cArray[0] | '\u0001');
                return;
            }
            case 'g': {
                cArray[0] = (char)(cArray[0] | 2);
                return;
            }
            case 'o': {
                cArray[0] = (char)(cArray[0] | 4);
                return;
            }
            case 'm': {
                cArray[0] = (char)(cArray[0] | 8);
                return;
            }
            case 's': {
                cArray[0] = (char)(cArray[0] | 0x10);
                return;
            }
            case 'x': {
                cArray[0] = (char)(cArray[0] | 0x20);
                return;
            }
        }
    }

    void _emitCode(char c) {
        if (this.__program != null) {
            this.__program[this.__programSize] = c;
        }
        ++this.__programSize;
    }

    int _emitNode(char c) {
        int n = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 2;
        } else {
            this.__program[this.__programSize++] = c;
            this.__program[this.__programSize++] = '\u0000';
        }
        return n;
    }

    int _emitArgNode(char c, char c2) {
        int n = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 3;
        } else {
            this.__program[this.__programSize++] = c;
            this.__program[this.__programSize++] = '\u0000';
            this.__program[this.__programSize++] = c2;
        }
        return n;
    }

    void _programInsertOperator(char c, int n) {
        int n2;
        int n3 = n2 = OpCode._opType[c] == '\n' ? 2 : 0;
        if (this.__program == null) {
            this.__programSize += 2 + n2;
            return;
        }
        int n4 = this.__programSize;
        this.__programSize += 2 + n2;
        int n5 = this.__programSize;
        while (n4 > n) {
            this.__program[--n5] = this.__program[--n4];
        }
        this.__program[n++] = c;
        this.__program[n++] = '\u0000';
        while (n2-- > 0) {
            this.__program[n++] = '\u0000';
        }
    }

    void _programAddTail(int n, int n2) {
        int n3;
        if (this.__program == null || n == -1) {
            return;
        }
        int n4 = n;
        while ((n3 = OpCode._getNext(this.__program, n4)) != -1) {
            n4 = n3;
        }
        int n5 = this.__program[n4] == '\r' ? n4 - n2 : n2 - n4;
        this.__program[n4 + 1] = (char)n5;
    }

    void _programAddOperatorTail(int n, int n2) {
        if (this.__program == null || n == -1 || OpCode._opType[this.__program[n]] != '\f') {
            return;
        }
        this._programAddTail(n + 2, n2);
    }

    char _getNextChar() {
        char c = this.__input._postIncrement();
        while (true) {
            char c2;
            CharStringPointer charStringPointer = this.__input;
            int n = charStringPointer._offset;
            char c3 = c2 = n < charStringPointer._array.length && n >= 0 ? charStringPointer._array[n] : (char)'\uffff';
            if (c2 == '(') {
                charStringPointer = this.__input;
                n = charStringPointer._offset + 1;
                if ((n < charStringPointer._array.length && n >= 0 ? charStringPointer._array[n] : 65535) == 63) {
                    charStringPointer = this.__input;
                    n = charStringPointer._offset + 2;
                    if ((n < charStringPointer._array.length && n >= 0 ? charStringPointer._array[n] : 65535) == 35) {
                        while (c2 != '\uffff' && c2 != ')') {
                            charStringPointer = this.__input;
                            c2 = charStringPointer._increment(1);
                        }
                        charStringPointer = this.__input;
                        charStringPointer._increment(1);
                        continue;
                    }
                }
            }
            if ((this.__modifierFlags[0] & 0x20) == 0) break;
            if (Character.isWhitespace(c2)) {
                charStringPointer = this.__input;
                charStringPointer._increment(1);
                continue;
            }
            if (c2 != 35) break;
            while (c2 != '\uffff' && c2 != '\n') {
                charStringPointer = this.__input;
                c2 = charStringPointer._increment(1);
            }
            charStringPointer = this.__input;
            charStringPointer._increment(1);
        }
        return c;
    }

    int _parseAlternation(int[] nArray) throws MalformedPatternException {
        int n = 0;
        nArray[0] = 0;
        int n2 = this._emitNode('\f');
        int n3 = -1;
        CharStringPointer charStringPointer = this.__input;
        if (charStringPointer._offset == 0) {
            charStringPointer = this.__input;
            charStringPointer._offset = -1;
            this._getNextChar();
        } else {
            charStringPointer = this.__input;
            charStringPointer._decrement(1);
            this._getNextChar();
        }
        charStringPointer = this.__input;
        int n4 = charStringPointer._offset;
        int n5 = n4 < charStringPointer._array.length && n4 >= 0 ? charStringPointer._array[n4] : 65535;
        while (n5 != 65535 && n5 != 124 && n5 != 41) {
            n &= 0xFFFFFFF7;
            int n6 = this._parseBranch(nArray);
            if (n6 == -1) {
                if ((n & 8) != 0) {
                    charStringPointer = this.__input;
                    n4 = charStringPointer._offset;
                    n5 = n4 < charStringPointer._array.length && n4 >= 0 ? charStringPointer._array[n4] : 65535;
                    continue;
                }
                return -1;
            }
            nArray[0] = nArray[0] | n & 1;
            if (n3 == -1) {
                nArray[0] = nArray[0] | n & 4;
            } else {
                ++this.__cost;
                this._programAddTail(n3, n6);
            }
            n3 = n6;
            charStringPointer = this.__input;
            n4 = charStringPointer._offset;
            int n7 = n5 = n4 < charStringPointer._array.length && n4 >= 0 ? charStringPointer._array[n4] : 65535;
        }
        if (n3 == -1) {
            this._emitNode('\u000f');
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    int _parseAtom(int[] var1_1) throws MalformedPatternException {
        block82: {
            var5_2 = new int[1];
            var1_1[0] = 0;
            var2_3 = false;
            var4_4 = -1;
            block50: while (true) {
                var6_6 = this.__input;
                var7_10 = var6_6._offset;
                var3_5 = var7_10 < var6_6._array.length && var7_10 >= 0 ? var6_6._array[var7_10] : 65535;
                switch (var3_5) {
                    case 94: {
                        this._getNextChar();
                        if ((this.__modifierFlags[0] & 8) != 0) {
                            var4_4 = this._emitNode('\u0002');
                            break block50;
                        }
                        if ((this.__modifierFlags[0] & 16) != 0) {
                            var4_4 = this._emitNode('\u0003');
                            break block50;
                        }
                        var4_4 = this._emitNode('\u0001');
                        break block50;
                    }
                    case 36: {
                        this._getNextChar();
                        if ((this.__modifierFlags[0] & 8) != 0) {
                            var4_4 = this._emitNode('\u0005');
                            break block50;
                        }
                        if ((this.__modifierFlags[0] & 16) != 0) {
                            var4_4 = this._emitNode('\u0006');
                            break block50;
                        }
                        var4_4 = this._emitNode('\u0004');
                        break block50;
                    }
                    case 46: {
                        this._getNextChar();
                        var4_4 = (this.__modifierFlags[0] & 16) != 0 ? this._emitNode('\b') : this._emitNode('\u0007');
                        ++this.__cost;
                        var1_1[0] = var1_1[0] | 3;
                        break block50;
                    }
                    case 91: {
                        var6_6 = this.__input;
                        var6_6._increment(1);
                        var4_4 = this._parseCharacterClass();
                        var1_1[0] = var1_1[0] | 3;
                        break block50;
                    }
                    case 40: {
                        this._getNextChar();
                        var4_4 = this._parseExpression(true, var5_2);
                        if (var4_4 == -1) {
                            if ((var5_2[0] & 8) != 0) continue block50;
                            return -1;
                        }
                        var1_1[0] = var1_1[0] | var5_2[0] & 5;
                        break block50;
                    }
                    case 41: 
                    case 124: {
                        if ((var5_2[0] & 8) != 0) {
                            var1_1[0] = var1_1[0] | 8;
                            return -1;
                        }
                        var6_6 = this.__input;
                        var7_11 = this.__input;
                        var7_12 = var7_11._offset;
                        throw new MalformedPatternException("Error in expression at " + new String(var6_6._array, var7_12, var6_6._array.length - var7_12));
                    }
                    case 42: 
                    case 43: 
                    case 63: {
                        throw new MalformedPatternException("?+* follows nothing in expression");
                    }
                    case 92: {
                        var6_6 = this.__input;
                        var3_5 = var6_6._increment(1);
                        switch (var3_5) {
                            case 65: {
                                var4_4 = this._emitNode('\u0003');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 71: {
                                var4_4 = this._emitNode('\u001e');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 90: {
                                var4_4 = this._emitNode('\u0006');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 119: {
                                var4_4 = this._emitNode('\u0012');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 87: {
                                var4_4 = this._emitNode('\u0013');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 98: {
                                var4_4 = this._emitNode('\u0014');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 66: {
                                var4_4 = this._emitNode('\u0015');
                                var1_1[0] = var1_1[0] | 2;
                                this._getNextChar();
                                break block50;
                            }
                            case 115: {
                                var4_4 = this._emitNode('\u0016');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 83: {
                                var4_4 = this._emitNode('\u0017');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 100: {
                                var4_4 = this._emitNode('\u0018');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 68: {
                                var4_4 = this._emitNode('\u0019');
                                var1_1[0] = var1_1[0] | 3;
                                this._getNextChar();
                                break block50;
                            }
                            case 48: 
                            case 97: 
                            case 99: 
                            case 101: 
                            case 102: 
                            case 110: 
                            case 114: 
                            case 116: 
                            case 120: {
                                var2_3 = true;
                                break block50;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var7_13 = new StringBuffer(10);
                                var6_7 = 0;
                                var8_15 = this.__input;
                                var9_18 = var8_15._offset + var6_7;
                                var3_5 = var9_18 < var8_15._array.length && var9_18 >= 0 ? var8_15._array[var9_18] : 65535;
                                while (Character.isDigit((char)var3_5)) {
                                    var7_13.append((char)var3_5);
                                    var8_15 = this.__input;
                                    var9_18 = var8_15._offset + ++var6_7;
                                    v0 = var3_5 = var9_18 < var8_15._array.length && var9_18 >= 0 ? var8_15._array[var9_18] : 65535;
                                }
                                try {
                                    var6_7 = Integer.parseInt(var7_13.toString());
                                }
                                catch (NumberFormatException var8_16) {
                                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var8_16.getMessage());
                                }
                                if (var6_7 > 9 && var6_7 >= this.__numParentheses) {
                                    var2_3 = true;
                                    break block50;
                                }
                                if (var6_7 >= this.__numParentheses) {
                                    throw new MalformedPatternException("Invalid backreference: \\" + var6_7);
                                }
                                this.__sawBackreference = true;
                                var4_4 = this._emitArgNode('\u001a', (char)var6_7);
                                var1_1[0] = var1_1[0] | 1;
                                var8_15 = this.__input;
                                var9_18 = var8_15._offset;
                                var3_5 = var9_18 < var8_15._array.length && var9_18 >= 0 ? var8_15._array[var9_18] : 65535;
                                while (Character.isDigit((char)var3_5)) {
                                    var8_15 = this.__input;
                                    var3_5 = var8_15._increment(1);
                                }
                                var8_15 = this.__input;
                                var8_15._decrement(1);
                                this._getNextChar();
                                break block50;
                            }
                            case 0: 
                            case 65535: {
                                var8_15 = this.__input;
                                if (var8_15._offset < var8_15._array.length && !false) break;
                                throw new MalformedPatternException("Trailing \\ in expression.");
                            }
                        }
                        var2_3 = true;
                        break block50;
                    }
                    case 35: {
                        if ((this.__modifierFlags[0] & 32) == 0) ** GOTO lbl197
                        if (true) ** GOTO lbl190
                        do {
                            var6_6 = this.__input;
                            var6_6._increment(1);
lbl190:
                            // 2 sources

                            var6_6 = this.__input;
                            if (var6_6._offset >= var6_6._array.length || false) break;
                            var6_6 = this.__input;
                        } while (((var7_10 = var6_6._offset) < var6_6._array.length && var7_10 >= 0 ? var6_6._array[var7_10] : 65535) != 10);
                        var6_6 = this.__input;
                        if (var6_6._offset >= var6_6._array.length || false) ** break;
                        continue block50;
                    }
lbl197:
                    // 3 sources

                    default: {
                        var6_6 = this.__input;
                        var6_6._increment(1);
                        var2_3 = true;
                    }
                }
                break;
            }
            if (!var2_3) break block82;
            var4_4 = this._emitNode('\u000e');
            if (this.__program != null) {
                this.__program[this.__programSize] = 65535;
            }
            ++this.__programSize;
            var7_14 = 0;
            var12_19 = this.__input;
            var8_17 = var12_19._offset - 1;
            var12_19 = this.__input;
            var9_18 = var12_19._array.length;
            block54: while (var7_14 < 127 && var8_17 < var9_18) {
                var10_23 = var8_17;
                var12_20 = this.__input;
                var3_5 = var8_17 < var12_20._array.length && var8_17 >= 0 ? var12_20._array[var8_17] : 65535;
                switch (var3_5) {
                    case 92: {
                        var12_20 = this.__input;
                        var13_25 = ++var8_17;
                        var3_5 = var13_25 < var12_20._array.length && var13_25 >= 0 ? var12_20._array[var13_25] : 65535;
                        switch (var3_5) {
                            case 65: 
                            case 66: 
                            case 68: 
                            case 71: 
                            case 83: 
                            case 87: 
                            case 90: 
                            case 98: 
                            case 100: 
                            case 115: 
                            case 119: {
                                --var8_17;
                                break block54;
                            }
                            case 110: {
                                var6_9 = '\n';
                                ++var8_17;
                                break;
                            }
                            case 114: {
                                var6_9 = '\r';
                                ++var8_17;
                                break;
                            }
                            case 116: {
                                var6_9 = '\t';
                                ++var8_17;
                                break;
                            }
                            case 102: {
                                var6_9 = '\f';
                                ++var8_17;
                                break;
                            }
                            case 101: {
                                var6_9 = '\u001b';
                                ++var8_17;
                                break;
                            }
                            case 97: {
                                var6_9 = '\u0007';
                                ++var8_17;
                                break;
                            }
                            case 120: {
                                var11_24 = new int[1];
                                var6_9 = (char)Perl5Compiler._parseHex(this.__input._array, ++var8_17, 2, var11_24);
                                var8_17 += var11_24[0];
                                break;
                            }
                            case 99: {
                                var12_20 = this.__input;
                                v1 = ++var8_17;
                                ++var8_17;
                                var13_25 = v1;
                                v2 = var6_9 = var13_25 < var12_20._array.length && var13_25 >= 0 ? var12_20._array[var13_25] : '\uffff';
                                if (Character.isLowerCase(var6_9)) {
                                    var6_9 = Character.toUpperCase(var6_9);
                                }
                                var6_9 = (char)(var6_9 ^ 64);
                                break;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var12_21 = false;
                                var13_26 = this.__input;
                                v3 = var3_5 = var8_17 < var13_26._array.length && var8_17 >= 0 ? var13_26._array[var8_17] : 65535;
                                if (var3_5 == 48) {
                                    var12_21 = true;
                                }
                                var13_26 = this.__input;
                                var14_30 = var8_17 + 1;
                                v4 = var3_5 = var14_30 < var13_26._array.length && var14_30 >= 0 ? var13_26._array[var14_30] : 65535;
                                if (Character.isDigit((char)var3_5)) {
                                    var14_31 = new StringBuffer(10);
                                    var13_27 = var8_17;
                                    var15_32 = this.__input;
                                    var3_5 = var13_27 < var15_32._array.length && var13_27 >= 0 ? var15_32._array[var13_27] : 65535;
                                    while (Character.isDigit((char)var3_5)) {
                                        var14_31.append((char)var3_5);
                                        var15_32 = this.__input;
                                        v5 = var3_5 = ++var13_27 < var15_32._array.length && var13_27 >= 0 ? var15_32._array[var13_27] : 65535;
                                    }
                                    try {
                                        var13_27 = Integer.parseInt(var14_31.toString());
                                    }
                                    catch (NumberFormatException var15_33) {
                                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var15_33.getMessage());
                                    }
                                    if (!var12_21) {
                                        v6 = var12_21 = var13_27 >= this.__numParentheses;
                                    }
                                }
                                if (var12_21) {
                                    var11_24 = new int[1];
                                    var6_9 = (char)Perl5Compiler._parseOctal(this.__input._array, var8_17, 3, var11_24);
                                    var8_17 += var11_24[0];
                                    break;
                                }
                                --var8_17;
                                break block54;
                            }
                            case 0: 
                            case 65535: {
                                if (var8_17 >= var9_18) {
                                    throw new MalformedPatternException("Trailing \\ in expression.");
                                }
                            }
                            default: {
                                var13_28 = this.__input;
                                var14_30 = var8_17++;
                                var6_9 = var14_30 < var13_28._array.length && var14_30 >= 0 ? var13_28._array[var14_30] : '\uffff';
                                break;
                            }
                        }
                        ** GOTO lbl324
                    }
                    case 35: {
                        if ((this.__modifierFlags[0] & 32) == 0) ** GOTO lbl315
                        if (true) ** GOTO lbl312
                        do {
                            ++var8_17;
lbl312:
                            // 2 sources

                            if (var8_17 >= var9_18) break;
                            var12_20 = this.__input;
                        } while ((var8_17 < var12_20._array.length && var8_17 >= 0 ? var12_20._array[var8_17] : 65535) != 10);
                    }
lbl315:
                    // 4 sources

                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 32: {
                        if ((this.__modifierFlags[0] & 32) == 0) ** GOTO lbl320
                        ++var8_17;
                        --var7_14;
                        ** GOTO lbl338
                    }
lbl320:
                    // 2 sources

                    default: {
                        var12_20 = this.__input;
                        var13_29 = var8_17++;
                        v7 = var6_9 = var13_29 < var12_20._array.length && var13_29 >= 0 ? var12_20._array[var13_29] : '\uffff';
lbl324:
                        // 2 sources

                        if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(var6_9)) {
                            var6_9 = Character.toLowerCase(var6_9);
                        }
                        if (var8_17 < var9_18 && Perl5Compiler._isComplexRepetitionOp(this.__input._array, var8_17)) {
                            if (var7_14 > 0) {
                                var8_17 = var10_23;
                                break block54;
                            }
                            ++var7_14;
                            if (this.__program != null) {
                                this.__program[this.__programSize] = var6_9;
                            }
                            ++this.__programSize;
                            break block54;
                        }
                        if (this.__program != null) {
                            this.__program[this.__programSize] = var6_9;
                        }
                        ++this.__programSize;
lbl338:
                        // 2 sources

                        ++var7_14;
                        continue block54;
                    }
                    case 36: 
                    case 40: 
                    case 41: 
                    case 46: 
                    case 91: 
                    case 94: 
                    case 124: {
                        break block54;
                    }
                }
            }
            var12_22 = this.__input;
            var12_22._offset = var13_25 = var8_17 - 1;
            this._getNextChar();
            if (var7_14 < 0) {
                throw new MalformedPatternException("Unexpected compilation failure.  Please report this bug!");
            }
            if (var7_14 > 0) {
                var1_1[0] = var1_1[0] | 1;
            }
            if (var7_14 == 1) {
                var1_1[0] = var1_1[0] | 2;
            }
            if (this.__program != null) {
                this.__program[var4_4 + 2] = (char)var7_14;
            }
            if (this.__program != null) {
                this.__program[this.__programSize] = 65535;
            }
            ++this.__programSize;
        }
        return var4_4;
    }

    void _setCharacterClassBits(char[] cArray, int n, char c, char c2) {
        if (this.__program == null || c2 >= '\u0100') {
            return;
        }
        c2 = (char)(c2 & 0xFFFF);
        if (c == '\u0000') {
            int n2 = n + (c2 >> 4);
            cArray[n2] = (char)(cArray[n2] | 1 << (c2 & 0xF));
            return;
        }
        int n3 = n + (c2 >> 4);
        cArray[n3] = (char)(cArray[n3] & ~(1 << (c2 & 0xF)));
    }

    /*
     * Unable to fully structure code
     */
    int _parseCharacterClass() throws MalformedPatternException {
        block40: {
            var1_1 = false;
            var5_2 = '\uffff';
            var8_3 = new int[1];
            var6_4 = this._emitNode('\t');
            var9_5 = this.__input;
            var10_6 = var9_5._offset;
            if ((var10_6 < var9_5._array.length && var10_6 >= 0 ? var9_5._array[var10_6] : 65535) == 94) {
                ++this.__cost;
                var9_5 = this.__input;
                var9_5._increment(1);
                var4_7 = '\u0000';
            } else {
                var4_7 = '\uffff';
            }
            var7_8 = this.__programSize;
            var3_9 = '\u0000';
            while (var3_9 < '\u0010') {
                if (this.__program != null) {
                    this.__program[this.__programSize] = var4_7;
                }
                ++this.__programSize;
                var3_9 = (char)(var3_9 + 1);
            }
            var9_5 = this.__input;
            var10_6 = var9_5._offset;
            v0 = var3_9 = var10_6 < var9_5._array.length && var10_6 >= 0 ? var9_5._array[var10_6] : '\uffff';
            if (var3_9 != ']' && var3_9 != 45) break block40;
            var2_10 = true;
            ** GOTO lbl162
        }
        var2_10 = false;
        if (true) ** GOTO lbl162
        while (true) {
            var2_10 = false;
            var9_5 = this.__input;
            var9_5._increment(1);
            if (var3_9 != 92) ** GOTO lbl-1000
            var3_9 = this.__input._postIncrement();
            switch (var3_9) {
                case 'w': {
                    var3_9 = '\u0000';
                    while (var3_9 < '\u0100') {
                        if (OpCode._isWordCharacter(var3_9)) {
                            this._setCharacterClassBits(this.__program, var7_8, var4_7, var3_9);
                        }
                        var3_9 = (char)(var3_9 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'W': {
                    var3_9 = '\u0000';
                    while (var3_9 < '\u0100') {
                        if (!OpCode._isWordCharacter(var3_9)) {
                            this._setCharacterClassBits(this.__program, var7_8, var4_7, var3_9);
                        }
                        var3_9 = (char)(var3_9 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 's': {
                    var3_9 = '\u0000';
                    while (var3_9 < '\u0100') {
                        if (Character.isWhitespace(var3_9)) {
                            this._setCharacterClassBits(this.__program, var7_8, var4_7, var3_9);
                        }
                        var3_9 = (char)(var3_9 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'S': {
                    var3_9 = '\u0000';
                    while (var3_9 < '\u0100') {
                        if (!Character.isWhitespace(var3_9)) {
                            this._setCharacterClassBits(this.__program, var7_8, var4_7, var3_9);
                        }
                        var3_9 = (char)(var3_9 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'd': {
                    var3_9 = '0';
                    while (var3_9 <= '9') {
                        this._setCharacterClassBits(this.__program, var7_8, var4_7, var3_9);
                        var3_9 = (char)(var3_9 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'D': {
                    var3_9 = '\u0000';
                    while (var3_9 < '0') {
                        this._setCharacterClassBits(this.__program, var7_8, var4_7, var3_9);
                        var3_9 = (char)(var3_9 + '\u0001');
                    }
                    var3_9 = ':';
                    while (var3_9 < '\u0100') {
                        this._setCharacterClassBits(this.__program, var7_8, var4_7, var3_9);
                        var3_9 = (char)(var3_9 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'n': {
                    var3_9 = '\n';
                    ** GOTO lbl135
                }
                case 'r': {
                    var3_9 = '\r';
                    ** GOTO lbl135
                }
                case 't': {
                    var3_9 = '\t';
                    ** GOTO lbl135
                }
                case 'f': {
                    var3_9 = '\f';
                    ** GOTO lbl135
                }
                case 'b': {
                    var3_9 = '\b';
                    ** GOTO lbl135
                }
                case 'e': {
                    var3_9 = '\u001b';
                    ** GOTO lbl135
                }
                case 'a': {
                    var3_9 = '\u0007';
                    ** GOTO lbl135
                }
                case 'x': {
                    var9_5 = this.__input;
                    var3_9 = (char)Perl5Compiler._parseHex(this.__input._array, var9_5._offset, 2, var8_3);
                    this.__input._increment(var8_3[0]);
                    ** GOTO lbl135
                }
                case 'c': {
                    var3_9 = this.__input._postIncrement();
                    if (Character.isLowerCase(var3_9)) {
                        var3_9 = Character.toUpperCase(var3_9);
                    }
                    var3_9 = (char)(var3_9 ^ 64);
                    ** GOTO lbl135
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    var9_5 = this.__input;
                    var3_9 = (char)Perl5Compiler._parseOctal(this.__input._array, var9_5._offset - 1, 3, var8_3);
                    this.__input._increment(var8_3[0] - 1);
                }
lbl135:
                // 11 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (!var1_1) ** GOTO lbl141
                    if (var5_2 > var3_9) {
                        throw new MalformedPatternException("Invalid [] range in expression.");
                    }
                    var1_1 = false;
                    ** GOTO lbl160
lbl141:
                    // 1 sources

                    var5_2 = var3_9;
                    var9_5 = this.__input;
                    var10_6 = var9_5._offset;
                    if ((var10_6 < var9_5._array.length && var10_6 >= 0 ? var9_5._array[var10_6] : 65535) != 45) ** GOTO lbl160
                    var9_5 = this.__input;
                    var9_5 = this.__input;
                    if (var9_5._offset + 1 >= var9_5._array.length) ** GOTO lbl160
                    var9_5 = this.__input;
                    var10_6 = var9_5._offset + 1;
                    if ((var10_6 < var9_5._array.length && var10_6 >= 0 ? var9_5._array[var10_6] : 65535) == 93) ** GOTO lbl160
                    var9_5 = this.__input;
                    var9_5._increment(1);
                    var1_1 = true;
                    break;
lbl-1000:
                    // 1 sources

                    {
                        this._setCharacterClassBits(this.__program, var7_8, var4_7, var5_2);
                        if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(var5_2)) {
                            this._setCharacterClassBits(this.__program, var7_8, var4_7, Character.toLowerCase(var5_2));
                        }
                        var5_2 = (char)(var5_2 + '\u0001');
lbl160:
                        // 5 sources

                        ** while (var5_2 <= var3_9)
                    }
lbl161:
                    // 1 sources

                    var5_2 = var3_9;
                }
            }
lbl162:
            // 10 sources

            var9_5 = this.__input;
            if (var9_5._offset < var9_5._array.length && !false) {
                var9_5 = this.__input;
                var10_6 = var9_5._offset;
                var3_9 = var10_6 < var9_5._array.length && var10_6 >= 0 ? var9_5._array[var10_6] : '\uffff';
                if (var3_9 != 93) continue;
            }
            if (!var2_10) break;
        }
        var9_5 = this.__input;
        var10_6 = var9_5._offset;
        if ((var10_6 < var9_5._array.length && var10_6 >= 0 ? var9_5._array[var10_6] : 65535) != 93) {
            throw new MalformedPatternException("Unmatched [] in expression.");
        }
        this._getNextChar();
        return var6_4;
    }

    int _parseBranch(int[] nArray) throws MalformedPatternException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = new int[1];
        int n2 = 0;
        int n3 = 65535;
        int n4 = this._parseAtom(nArray2);
        if (n4 == -1) {
            if ((nArray2[0] & 8) != 0) {
                nArray[0] = nArray[0] | 8;
            }
            return -1;
        }
        CharStringPointer charStringPointer = this.__input;
        int n5 = charStringPointer._offset;
        int n6 = n = n5 < charStringPointer._array.length && n5 >= 0 ? charStringPointer._array[n5] : 65535;
        if (n == 40) {
            charStringPointer = this.__input;
            n5 = charStringPointer._offset + 1;
            if ((n5 < charStringPointer._array.length && n5 >= 0 ? charStringPointer._array[n5] : 65535) == 63) {
                charStringPointer = this.__input;
                n5 = charStringPointer._offset + 2;
                if ((n5 < charStringPointer._array.length && n5 >= 0 ? charStringPointer._array[n5] : 65535) == 35) {
                    while (n != 65535 && n != 41) {
                        charStringPointer = this.__input;
                        n = charStringPointer._increment(1);
                    }
                    if (n != 65535) {
                        this._getNextChar();
                        charStringPointer = this.__input;
                        n5 = charStringPointer._offset;
                        int n7 = n = n5 < charStringPointer._array.length && n5 >= 0 ? charStringPointer._array[n5] : 65535;
                    }
                }
            }
        }
        if (n == 123) {
            charStringPointer = this.__input;
            if (Perl5Compiler._parseRepetition(this.__input._array, charStringPointer._offset)) {
                int n8;
                CharStringPointer charStringPointer2 = this.__input;
                int n9 = charStringPointer2._offset + 1;
                charStringPointer2 = this.__input;
                n5 = n8 = charStringPointer2._array.length;
                charStringPointer2 = this.__input;
                int n10 = n9 < charStringPointer2._array.length && n9 >= 0 ? charStringPointer2._array[n9] : 65535;
                while (Character.isDigit((char)n10) || n10 == 44) {
                    if (n10 == 44) {
                        if (n5 != n8) break;
                        n5 = n9;
                    }
                    charStringPointer2 = this.__input;
                    int n11 = n10 = ++n9 < charStringPointer2._array.length && n9 >= 0 ? charStringPointer2._array[n9] : 65535;
                }
                if (n10 == 125) {
                    StringBuffer stringBuffer = new StringBuffer(10);
                    if (n5 == n8) {
                        n5 = n9;
                    }
                    CharStringPointer charStringPointer3 = this.__input;
                    charStringPointer3._increment(1);
                    charStringPointer3 = this.__input;
                    int n12 = charStringPointer3._offset;
                    charStringPointer3 = this.__input;
                    n10 = n12 < charStringPointer3._array.length && n12 >= 0 ? charStringPointer3._array[n12] : 65535;
                    while (Character.isDigit((char)n10)) {
                        stringBuffer.append((char)n10);
                        charStringPointer3 = this.__input;
                        int n13 = n10 = ++n12 < charStringPointer3._array.length && n12 >= 0 ? charStringPointer3._array[n12] : 65535;
                    }
                    try {
                        n2 = Integer.parseInt(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                    }
                    charStringPointer3 = this.__input;
                    int n14 = n10 = n5 < charStringPointer3._array.length && n5 >= 0 ? charStringPointer3._array[n5] : 65535;
                    if (n10 == 44) {
                        ++n5;
                    } else {
                        charStringPointer3 = this.__input;
                        n5 = charStringPointer3._offset;
                    }
                    n12 = n5;
                    stringBuffer = new StringBuffer(10);
                    charStringPointer3 = this.__input;
                    n10 = n12 < charStringPointer3._array.length && n12 >= 0 ? charStringPointer3._array[n12] : 65535;
                    while (Character.isDigit((char)n10)) {
                        stringBuffer.append((char)n10);
                        charStringPointer3 = this.__input;
                        int n15 = n10 = ++n12 < charStringPointer3._array.length && n12 >= 0 ? charStringPointer3._array[n12] : 65535;
                    }
                    try {
                        if (n12 != n5) {
                            n3 = Integer.parseInt(stringBuffer.toString());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                    }
                    if (n3 == 0) {
                        charStringPointer3 = this.__input;
                        if ((n5 < charStringPointer3._array.length && n5 >= 0 ? charStringPointer3._array[n5] : 65535) != 48) {
                            n3 = 65535;
                        }
                    }
                    charStringPointer3 = this.__input;
                    charStringPointer3._offset = n9;
                    this._getNextChar();
                    bl = true;
                    bl2 = true;
                }
            }
        }
        if (!bl) {
            bl2 = false;
            if (n != 42 && n != 43 && n != 63) {
                nArray[0] = nArray2[0];
                return n4;
            }
            this._getNextChar();
            int n16 = nArray[0] = n != 43 ? 4 : 1;
            if (n == 42 && (nArray2[0] & 2) != 0) {
                this._programInsertOperator('\u0010', n4);
                this.__cost += 4;
            } else if (n == 42) {
                n2 = 0;
                bl2 = true;
            } else if (n == 43 && (nArray2[0] & 2) != 0) {
                this._programInsertOperator('\u0011', n4);
                this.__cost += 3;
            } else if (n == 43) {
                n2 = 1;
                bl2 = true;
            } else if (n == 63) {
                n2 = 0;
                n3 = 1;
                bl2 = true;
            }
        }
        if (bl2) {
            if ((nArray2[0] & 2) != 0) {
                this.__cost += (2 + this.__cost) / 2;
                this._programInsertOperator('\n', n4);
            } else {
                this.__cost += 4 + this.__cost;
                this._programAddTail(n4, this._emitNode('\"'));
                this._programInsertOperator('\u000b', n4);
                this._programAddTail(n4, this._emitNode('\u000f'));
            }
            if (n2 > 0) {
                nArray[0] = 1;
            }
            if (n3 != 0 && n3 < n2) {
                throw new MalformedPatternException("Invalid interval {" + n2 + "," + n3 + "}");
            }
            if (this.__program != null) {
                this.__program[n4 + 2] = (char)n2;
                this.__program[n4 + 3] = (char)n3;
            }
        }
        CharStringPointer charStringPointer4 = this.__input;
        n5 = charStringPointer4._offset;
        if ((n5 < charStringPointer4._array.length && n5 >= 0 ? charStringPointer4._array[n5] : 65535) == 63) {
            this._getNextChar();
            this._programInsertOperator('\u001d', n4);
            this._programAddTail(n4, n4 + 2);
        }
        charStringPointer4 = this.__input;
        if (Perl5Compiler._isComplexRepetitionOp(this.__input._array, charStringPointer4._offset)) {
            throw new MalformedPatternException("Nested repetitions *?+ in expression");
        }
        return n4;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    int _parseExpression(boolean var1_1, int[] var2_2) throws MalformedPatternException {
        block30: {
            block31: {
                var5_3 = -1;
                var6_4 = 0;
                var9_5 = new int[1];
                var2_2[0] = 1;
                if (!var1_1) ** GOTO lbl52
                var4_6 = '\u0001';
                var10_7 = this.__input;
                var11_8 = var10_7._offset;
                if ((var11_8 < var10_7._array.length && var11_8 >= 0 ? var10_7._array[var11_8] : 65535) != 63) ** GOTO lbl49
                var10_7 = this.__input;
                var10_7._increment(1);
                var4_6 = var3_9 = this.__input._postIncrement();
                switch (var3_9) {
                    case '#': {
                        var10_7 = this.__input;
                        var11_8 = var10_7._offset;
                        v0 = var3_9 = var11_8 < var10_7._array.length && var11_8 >= 0 ? var10_7._array[var11_8] : '\uffff';
                        while (true) {
                            if (var3_9 == '\uffff' || var3_9 == ')') {
                                if (var3_9 == 41) break;
                                throw new MalformedPatternException("Sequence (?#... not terminated");
                            }
                            var10_7 = this.__input;
                            var3_9 = var10_7._increment(1);
                        }
                        this._getNextChar();
                        var2_2[0] = 8;
                        return -1;
                    }
                    default: {
                        var10_7 = this.__input;
                        var10_7._decrement(1);
                        var10_7 = this.__input;
                        var11_8 = var10_7._offset;
                        v1 = var3_9 = var11_8 < var10_7._array.length && var11_8 >= 0 ? var10_7._array[var11_8] : '\uffff';
                        while (true) {
                            if (var3_9 == '\uffff' || "iogmsx".indexOf(var3_9) == -1) {
                                if (var3_9 == 41) break;
                                throw new MalformedPatternException("Sequence (?" + var3_9 + "...) not recognized");
                            }
                            Perl5Compiler._setModifierFlag(this.__modifierFlags, var3_9);
                            var10_7 = this.__input;
                            var3_9 = var10_7._increment(1);
                        }
                        this._getNextChar();
                        var2_2[0] = 8;
                        return -1;
                    }
lbl49:
                    // 1 sources

                    var6_4 = this.__numParentheses++;
                    var5_3 = this._emitArgNode('\u001b', (char)var6_4);
                    break;
lbl52:
                    // 1 sources

                    var4_6 = '\u0000';
                    break;
                    case '!': 
                    case ':': 
                    case '=': 
                }
                var7_10 = this._parseAlternation(var9_5);
                if (var7_10 == -1) {
                    return -1;
                }
                if (var5_3 != -1) {
                    this._programAddTail(var5_3, var7_10);
                } else {
                    var5_3 = var7_10;
                }
                if ((var9_5[0] & 1) == 0) {
                    var2_2[0] = var2_2[0] & -2;
                }
                var2_2[0] = var2_2[0] | var9_5[0] & 4;
                if (true) ** GOTO lbl76
                do {
                    this._getNextChar();
                    var7_10 = this._parseAlternation(var9_5);
                    if (var7_10 == -1) {
                        return -1;
                    }
                    this._programAddTail(var5_3, var7_10);
                    if ((var9_5[0] & 1) == 0) {
                        var2_2[0] = var2_2[0] & -2;
                    }
                    var2_2[0] = var2_2[0] | var9_5[0] & 4;
lbl76:
                    // 2 sources

                    var10_7 = this.__input;
                } while (((var11_8 = var10_7._offset) < var10_7._array.length && var11_8 >= 0 ? var10_7._array[var11_8] : 65535) == 124);
                switch (var4_6) {
                    case ':': {
                        var8_11 = this._emitNode('\u000f');
                        break;
                    }
                    case '\u0001': {
                        var8_11 = this._emitArgNode('\u001c', (char)var6_4);
                        break;
                    }
                    case '!': 
                    case '=': {
                        var8_11 = this._emitNode('!');
                        var2_2[0] = var2_2[0] & -2;
                        break;
                    }
                    default: {
                        var8_11 = this._emitNode('\u0000');
                    }
                }
                this._programAddTail(var5_3, var8_11);
                var7_10 = var5_3;
                while (var7_10 != -1) {
                    this._programAddOperatorTail(var7_10, var8_11);
                    var7_10 = OpCode._getNext(this.__program, var7_10);
                }
                if (var4_6 == '=') {
                    this._programInsertOperator('\u001f', var5_3);
                    this._programAddTail(var5_3, this._emitNode('\u000f'));
                } else if (var4_6 == '!') {
                    this._programInsertOperator(' ', var5_3);
                    this._programAddTail(var5_3, this._emitNode('\u000f'));
                }
                if (var4_6 == '\u0000') break block30;
                var10_7 = this.__input;
                if (var10_7._offset >= var10_7._array.length) break block31;
                if (this._getNextChar() == ')') break block30;
            }
            throw new MalformedPatternException("Unmatched parentheses.");
        }
        if (var4_6 == '\u0000') {
            var10_7 = this.__input;
            if (var10_7._offset < var10_7._array.length) {
                var10_7 = this.__input;
                var11_8 = var10_7._offset;
                if ((var11_8 < var10_7._array.length && var11_8 >= 0 ? var10_7._array[var11_8] : 65535) == 41) {
                    throw new MalformedPatternException("Unmatched parentheses.");
                }
                throw new MalformedPatternException("Unreached characters at end of expression.  Please report this bug!");
            }
        }
        return var5_3;
    }

    /*
     * Unable to fully structure code
     */
    public Pattern compile(char[] var1_1, int var2_2) throws MalformedPatternException {
        block49: {
            var3_3 = new int[1];
            var10_4 = false;
            var11_5 = false;
            var15_6 = 0;
            this.__input = new CharStringPointer(var1_1);
            var4_7 = var2_2 & 1;
            this.__modifierFlags[0] = (char)var2_2;
            this.__sawBackreference = false;
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__program = null;
            if (this.__program != null) {
                this.__program[this.__programSize] = '\u0000';
            }
            ++this.__programSize;
            if (this._parseExpression(false, var3_3) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            if (this.__programSize >= 65534) {
                throw new MalformedPatternException("Expression is too large.");
            }
            this.__program = new char[this.__programSize];
            var6_8 = new Perl5Pattern();
            var6_8._program = this.__program;
            var6_8._expression = new String(var1_1);
            var19_9 = this.__input;
            var19_9._offset = 0;
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            if (this.__program != null) {
                this.__program[this.__programSize] = '\u0000';
            }
            ++this.__programSize;
            if (this._parseExpression(false, var3_3) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            var4_7 = this.__modifierFlags[0] & '\u0001';
            var6_8._isExpensive = this.__cost >= 10;
            var6_8._startClassOffset = -1;
            var6_8._anchor = 0;
            var6_8._back = -1;
            var6_8._options = var2_2;
            var6_8._startString = null;
            var6_8._mustString = null;
            var7_11 = null;
            var8_12 = null;
            var5_13 = 1;
            if (this.__program[OpCode._getNext(this.__program, var5_13)] != '\u0000') break block49;
            var9_14 = var5_13 += 2;
            var20_15 = this.__program[var9_14];
            if (true) ** GOTO lbl55
            while (true) {
                if (var20_15 == '\u0011') {
                    var11_5 = true;
                } else {
                    var9_14 += OpCode._operandLength[var20_15];
                }
                var20_15 = this.__program[var9_14 += 2];
lbl55:
                // 2 sources

                if (var20_15 == '\u001b') {
                    var10_4 = true;
                    if (true) continue;
                }
                if (!(var20_15 == '\f' && this.__program[OpCode._getNext(this.__program, var9_14)] != '\f' || var20_15 == '\u0011' || var20_15 == '\u001d' || OpCode._opType[var20_15] == '\n' && (var21_16 = this.__program)[var9_14 + 2] > '\u0000')) break;
            }
            var19_10 = true;
            while (var19_10) {
                block44: {
                    var19_10 = false;
                    var20_15 = this.__program[var9_14];
                    if (var20_15 == '\u000e') {
                        var21_17 = var9_14 + 1;
                        var8_12 = new String(this.__program, var21_17 + 2, (int)this.__program[var9_14 + 2]);
                        continue;
                    }
                    var21_16 = OpCode._opLengthOne;
                    var22_23 = 2;
                    while (var22_23 < var21_16.length) {
                        if (var20_15 != var21_16[var22_23++]) continue;
                        v0 = true;
                        break block44;
                    }
                    v0 = false;
                }
                if (v0) {
                    var6_8._startClassOffset = var9_14;
                    continue;
                }
                if (var20_15 == '\u0014' || var20_15 == '\u0015') {
                    var6_8._startClassOffset = var9_14;
                    continue;
                }
                if (OpCode._opType[var20_15] == '\u0001') {
                    var6_8._anchor = 1;
                    var9_14 += 2;
                    var19_10 = true;
                    continue;
                }
                if (var20_15 != '\u0010' || OpCode._opType[this.__program[var9_14 + 2]] != '\u0007' || (var6_8._anchor & 1) == 0) continue;
                var6_8._anchor = 5;
                var9_14 += 2;
                var19_10 = true;
            }
            if (!(!var11_5 || var10_4 && this.__sawBackreference)) {
                var6_8._anchor |= 2;
            }
            var12_28 = new StringBuffer();
            var13_29 = new StringBuffer();
            var14_30 = 0;
            var15_6 = 0;
            var16_31 = 0;
            var17_32 = 0;
            var18_33 = 0;
            while (var5_13 > 0 && (var20_15 = this.__program[var5_13]) != '\u0000') {
                block51: {
                    block48: {
                        block52: {
                            block46: {
                                block45: {
                                    block50: {
                                        if (var20_15 == '\f') {
                                            if (this.__program[OpCode._getNext(this.__program, var5_13)] == '\f') {
                                                var16_31 = -30000;
                                                while (this.__program[var5_13] == '\f') {
                                                    var5_13 = OpCode._getNext(this.__program, var5_13);
                                                }
                                                continue;
                                            }
                                            var5_13 += 2;
                                            continue;
                                        }
                                        if (var20_15 == ' ') {
                                            var16_31 = -30000;
                                            var5_13 = OpCode._getNext(this.__program, var5_13);
                                            continue;
                                        }
                                        if (var20_15 != '\u000e') break block50;
                                        var9_14 = var5_13;
                                        while (this.__program[var21_18 = OpCode._getNext(this.__program, var5_13)] == '\u001c') {
                                            var5_13 = var21_18;
                                        }
                                        var15_6 += this.__program[var9_14 + 2];
                                        var21_18 = this.__program[var9_14 + 2];
                                        if (var16_31 - var17_32 == var14_30) {
                                            var12_28.append(new String(this.__program, var9_14 + 2 + 1, var21_18));
                                            var14_30 += var21_18;
                                            var16_31 += var21_18;
                                            var9_14 = OpCode._getNext(this.__program, var5_13);
                                        } else if (var21_18 >= var14_30 + (var16_31 >= 0 ? 1 : 0)) {
                                            var14_30 = var21_18;
                                            var12_28 = new StringBuffer(new String(this.__program, var9_14 + 2 + 1, var21_18));
                                            var17_32 = var16_31;
                                            var16_31 += var14_30;
                                            var9_14 = OpCode._getNext(this.__program, var5_13);
                                        } else {
                                            var16_31 += var21_18;
                                        }
                                        break block51;
                                    }
                                    var21_19 = OpCode._opLengthVaries;
                                    var22_25 = 0;
                                    while (var22_25 < var21_19.length) {
                                        if (var20_15 != var21_19[var22_25++]) continue;
                                        v1 = true;
                                        break block45;
                                    }
                                    v1 = false;
                                }
                                if (!v1) break block52;
                                var16_31 = -30000;
                                var14_30 = 0;
                                if (var12_28.length() > var13_29.length()) {
                                    var13_29 = var12_28;
                                    var18_33 = var17_32;
                                }
                                var12_28 = new StringBuffer();
                                if (var20_15 != '\u0011') ** GOTO lbl-1000
                                var21_20 = this.__program[var5_13 + 2];
                                var22_26 = OpCode._opLengthOne;
                                var23_34 = 0;
                                while (var23_34 < var22_26.length) {
                                    if (var21_20 != var22_26[var23_34++]) continue;
                                    v2 = true;
                                    break block46;
                                }
                                v2 = false;
                            }
                            if (v2) {
                                ++var15_6;
                            } else if (OpCode._opType[var20_15] == '\n') {
                                block47: {
                                    var21_21 = this.__program[var5_13 + 2 + 2];
                                    var22_27 = OpCode._opLengthOne;
                                    var23_34 = 0;
                                    while (var23_34 < var22_27.length) {
                                        if (var21_21 != var22_27[var23_34++]) continue;
                                        v3 = true;
                                        break block47;
                                    }
                                    v3 = false;
                                }
                                if (v3) {
                                    var21_22 = this.__program;
                                    var15_6 += var21_22[var5_13 + 2];
                                }
                            }
                            break block51;
                        }
                        var21_19 = OpCode._opLengthOne;
                        var22_25 = 0;
                        while (var22_25 < var21_19.length) {
                            if (var20_15 != var21_19[var22_25++]) continue;
                            v4 = true;
                            break block48;
                        }
                        v4 = false;
                    }
                    if (v4) {
                        ++var16_31;
                        ++var15_6;
                        var14_30 = 0;
                        if (var12_28.length() > var13_29.length()) {
                            var13_29 = var12_28;
                            var18_33 = var17_32;
                        }
                        var12_28 = new StringBuffer();
                    }
                }
                var5_13 = OpCode._getNext(this.__program, var5_13);
            }
            if (var12_28.length() + (OpCode._opType[this.__program[var9_14]] == '\u0004' ? 1 : 0) > var13_29.length()) {
                var13_29 = var12_28;
                var18_33 = var17_32;
            } else {
                var12_28 = new StringBuffer();
            }
            if (var13_29.length() > 0 && var8_12 == null) {
                var7_11 = var13_29.toString();
                if (var18_33 < 0) {
                    var18_33 = -1;
                }
                var6_8._back = var18_33;
            } else {
                var13_29 = null;
            }
        }
        var6_8._isCaseInsensitive = (var4_7 & 1) != 0;
        var6_8._numParentheses = this.__numParentheses - 1;
        var6_8._minLength = var15_6;
        if (var7_11 != null) {
            var6_8._mustString = var7_11.toCharArray();
            var6_8._mustUtility = 100;
        }
        if (var8_12 != null) {
            var6_8._startString = var8_12.toCharArray();
        }
        return var6_8;
    }

    public Pattern compile(char[] cArray) throws MalformedPatternException {
        return this.compile(cArray, 0);
    }

    public Pattern compile(String string) throws MalformedPatternException {
        return this.compile(string.toCharArray(), 0);
    }

    public Pattern compile(String string, int n) throws MalformedPatternException {
        return this.compile(string.toCharArray(), n);
    }
}

