! (C) Copyright 2015- ECMWF.
! (C) Copyright 2015- Meteo-France.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
!

MODULE WTS500_MOD
CONTAINS
SUBROUTINE WTS500(PX,PW,KN)

USE EC_PARKIND  ,ONLY : JPIM, JPRD
IMPLICIT NONE

INTEGER(KIND=JPIM), INTENT(IN)  :: KN
REAL(KIND=JPRD),    INTENT(OUT) :: PX(:),PW(:)

! This routine returns a set of Gaussian nodes and weights for
! integrating the functions exp(lambda*x)dx over the range x=0 to x=infinity.
! They work for lambda in the range [1,501].  The accuracy
! of the quadrature for each n is given in the tables below.

! Input arguments:
!	n - number of weights and nodes in the quadrature.  This must
!	  be an integer in the range [2,56].
!
! Output arguments:
!	w - weights
!	x - nodes
!
!
! The following table gives the approximate accuracy of the weights in
! this file, that is to say the experimentally determined maximum
! absolute error for lambda in the range [1,501].
!
!        2     0.76126E-01
!        3     0.26903E-01
!        4     0.88758E-02
!        5     0.28110E-02
!        6     0.86785E-03
!        7     0.26276E-03
!        8     0.78346E-04
!        9     0.23066E-04
!       10     0.67184E-05
!       11     0.19386E-05
!       12     0.55482E-06
!       13     0.15762E-06
!       14     0.44478E-07
!       15     0.12474E-07
!       16     0.34787E-08
!       17     0.96498E-09
!       18     0.26636E-09
!       19     0.73174E-10
!       20     0.20013E-10
!       21     0.54503E-11
!       22     0.14783E-11
!       23     0.39937E-12
!       24     0.10749E-12
!       25     0.28822E-13
!       26     0.77011E-14
!       27     0.20993E-14
!       28     0.59593E-15

!		(The accuracies beyond this point are
!		only available if this routine is converted
!		to extended precision.)
!
!       29     0.16665E-15
!       30     0.45938E-16
!       31     0.12483E-16
!       32     0.33436E-17
!       33     0.88209E-18
!       34     0.22896E-18
!       35     0.58363E-19
!       36     0.15182E-19
!       37     0.45892E-20
!       38     0.13452E-20
!       39     0.38384E-21
!       40     0.10683E-21
!       41     0.29025E-22
!       42     0.76955E-23
!       43     0.19878E-23
!       44     0.49867E-24
!       45     0.12879E-24
!       46     0.38890E-25
!       47     0.11493E-25
!       48     0.32717E-26
!       49     0.89977E-27
!       50     0.23916E-27
!       51     0.66534E-28
!       52     0.20256E-28
!       53     0.60754E-29
!       54     0.17974E-29
!       55     0.52173E-30
!       56     0.14656E-30
!       57     0.39867E-31
!       58     0.17622E-31
!       59     0.11941E-31


if(kn < 1 .or. kn > 59) CALL ABOR1('kn out of bounds in wts500')

if(kn ==  1) then
  px( 1)= 0.30029234138173323099658823269124393D+00
  pw( 1)= 0.10474544159373900054024730385996879D+01
endif
if(kn ==  2) then
  px( 1)= 0.44614645646035084305052271657195780D-01
  px( 2)= 0.69921614559509068409005059560416520D+00
  pw( 1)= 0.15994862626671497398269903651565162D+00
  pw( 2)= 0.15511944041990193294522419186360192D+01
endif
if(kn ==  3) then
  px( 1)= 0.11857389353662594950547350532174902D-01
  px( 2)= 0.16764835416208964726306668598724940D+00
  px( 3)= 0.11277491807394385305149473243132366D+01
  pw( 1)= 0.40534466810113107834140226328650886D-01
  pw( 2)= 0.36261372044374320167772351965467234D+00
  pw( 3)= 0.19347454032003660753035080254268649D+01
endif
if(kn ==  4) then
  px( 1)= 0.57654208655188821571537226422468374D-02
  px( 2)= 0.62523167781181198280172417136126064D-01
  px( 3)= 0.36533207087496350173593536437526512D+00
  px( 4)= 0.16157524591822212021884702173778156D+01
  pw( 1)= 0.17868545000488806425866630797084082D-01
  pw( 2)= 0.12328668633600752343455555544669733D+00
  pw( 3)= 0.58372673164630844216911861958288950D+00
  pw( 4)= 0.22766170591050845697618451516268360D+01
endif
if(kn ==  5) then
  px( 1)= 0.38286655100887720869535305553503767D-02
  px( 2)= 0.32638654131646742439488396483219523D-01
  px( 3)= 0.15979343932440245421190120326583297D+00
  px( 4)= 0.62593598592475461862138219614406608D+00
  px( 5)= 0.21448850159686373839369069493121931D+01
  pw( 1)= 0.11006282598632254556602552524231582D-01
  pw( 2)= 0.57230982733825644334586234468135637D-01
  pw( 3)= 0.23302193704059872350599634911774233D+00
  pw( 4)= 0.80399187922220639155300759119683454D+00
  pw( 5)= 0.25817835060095957471682462945418890D+01
endif
if(kn ==  6) then
  px( 1)= 0.29149725976167556773168063131622477D-02
  px( 2)= 0.21103262424016434877304140537976324D-01
  px( 3)= 0.87672665103786085283260733993906787D-01
  px( 4)= 0.30362191434277672991331660483079722D+00
  px( 5)= 0.93772122523975475283401768866415608D+00
  px( 6)= 0.27034204049910086432949276908848690D+01
  pw( 1)= 0.80264082196721958922253358145693741D-02
  pw( 2)= 0.33206285080799577093824435206894388D-01
  pw( 3)= 0.11527314673621704717905199327206330D+00
  pw( 4)= 0.35781407343251622864391524621893261D+00
  pw( 5)= 0.10155006971456147012687855907386742D+01
  pw( 6)= 0.28564602273790248848620772701419901D+01
endif
if(kn ==  7) then
  px( 1)= 0.23756434216797693908355583003051663D-02
  px( 2)= 0.15535118461800569190547935165674497D-01
  px( 3)= 0.56551273947723240042834250291153011D-01
  px( 4)= 0.17450996559452745580564075650691432D+00
  px( 5)= 0.49112500667928528178358415821262749D+00
  px( 6)= 0.12919504684055881399873474932878924D+01
  px( 7)= 0.32851412356973227675206901468229149D+01
  pw( 1)= 0.63886696350675163666711135442919764D-02
  pw( 2)= 0.22442242541224196499797804610442189D-01
  pw( 3)= 0.67162457789171790971598253749543852D-01
  pw( 4)= 0.18766490984256656291382113580254403D+00
  pw( 5)= 0.48993342911988760795594155472540210D+00
  pw( 6)= 0.12160105557427987424854903052204337D+01
  pw( 7)= 0.31065668529411483170389922159304207D+01
endif
if(kn ==  8) then
  px( 1)= 0.20132180607225834852983700686031058D-02
  px( 2)= 0.12364145427770238507453563351438370D-01
  px( 3)= 0.40779487004322342225816753965428875D-01
  px( 4)= 0.11391148589791378330792648499651137D+00
  px( 5)= 0.29412883145944878287611616309747638D+00
  px( 6)= 0.71837098644914450185415022533227351D+00
  px( 7)= 0.16816853747148161279323645594606599D+01
  px( 8)= 0.38855951611162649511701947653116899D+01
  pw( 1)= 0.53408830450397378295721475271713427D-02
  pw( 2)= 0.16787984180357441921393643943808306D-01
  pw( 3)= 0.44204970292771876400860637563463140D-01
  pw( 4)= 0.11185011190895920238718302559774708D+00
  pw( 5)= 0.27016191944753418682586773667091217D+00
  pw( 6)= 0.62450892495416087531923817566640810D+00
  pw( 7)= 0.14051940584215133597891405916743820D+01
  pw( 8)= 0.33364764999199772405176908767598180D+01
endif
if(kn ==  9) then
  px( 1)= 0.17503557878075214519879036524833375D-02
  px( 2)= 0.10330054871723184754037951908660005D-01
  px( 3)= 0.31732206325445549848937295392421049D-01
  px( 4)= 0.81679121803401719155156637120993002D-01
  px( 5)= 0.19535573613157974971806765507983509D+00
  px( 6)= 0.44595223788074039354969352640100852D+00
  px( 7)= 0.98135220945386835905397405725519927D+00
  px( 8)= 0.21015170770020791654126380210416672D+01
  px( 9)= 0.45016099625796459085057556421321067D+01
  pw( 1)= 0.46046107862322611600702922635137510D-02
  pw( 2)= 0.13429769279555420282230890098322098D-01
  pw( 3)= 0.31849272894061216190385847667286999D-01
  pw( 4)= 0.73619249380405585299506449662883408D-01
  pw( 5)= 0.16535947795274881422091783969932427D+00
  pw( 6)= 0.35934417872243713158616629815331565D+00
  pw( 7)= 0.75859660458155596407004967675485659D+00
  pw( 8)= 0.15835611580085742332645675327785911D+01
  pw( 9)= 0.35495334121390922353050388191171761D+01
endif
if(kn == 10) then
  px( 1)= 0.15499542669794147311761132610985078D-02
  px( 2)= 0.89096688398509678030924958952986541D-02
  px( 3)= 0.26016129693043413683698040760210971D-01
  px( 4)= 0.62749208598031754292711006026615926D-01
  px( 5)= 0.14050353407849426047312501552279980D+00
  px( 6)= 0.30181414123622395598472969521213967D+00
  px( 7)= 0.62857185766887058395879604119303521D+00
  px( 8)= 0.12763299399934852402803633611287669D+01
  px( 9)= 0.25471652578226896546390447678170800D+01
  px(10)= 0.51308067782658204682801321291953140D+01
  pw( 1)= 0.40548253986991389304086648382669812D-02
  pw( 2)= 0.11236188731318700188319947717229244D-01
  pw( 3)= 0.24538592970816425402207400802497825D-01
  pw( 4)= 0.52343517158460444258926972420783323D-01
  pw( 5)= 0.10996558531241373841512937168184451D+00
  pw( 6)= 0.22576984249893556435278829920283551D+00
  pw( 7)= 0.45261772769497660240184928082408646D+00
  pw( 8)= 0.89046194530658792052229355508350808D+00
  pw( 9)= 0.17519181692872931385803490555209237D+01
  pw(10)= 0.37483184442175079452559119390314762D+01
endif
if(kn == 11) then
  px( 1)= 0.13916503869954620980214122938112018D-02
  px( 2)= 0.78558050039620362116422912802704097D-02
  px( 3)= 0.22120351963459063625179184464273817D-01
  px( 4)= 0.50713242013627782652925282235350304D-01
  px( 5)= 0.10742319887758113859279057980251631D+00
  px( 6)= 0.21869117548117680828718663672766937D+00
  px( 7)= 0.43336030838054496927092430378951163D+00
  px( 8)= 0.84018288532692476091948497009100848D+00
  px( 9)= 0.15999462842086233335871841089805130D+01
  px(10)= 0.30151891304900922172275251687511795D+01
  px(11)= 0.57713337136325357659044166408988553D+01
  pw( 1)= 0.36266510989460802397873164288690734D-02
  pw( 2)= 0.96950369134995745371692684658412310D-02
  pw( 3)= 0.19868559916434820960232503677049332D-01
  pw( 4)= 0.39531505533000821496522977944503206D-01
  pw( 5)= 0.78139977968766268496958310477317134D-01
  pw( 6)= 0.15225813478813020210433348166511355D+00
  pw( 7)= 0.29137456345793780649576074277273596D+00
  pw( 8)= 0.54807495314077461646456170049418256D+00
  pw( 9)= 0.10191215020827390969142637205874466D+01
  pw(10)= 0.19111370110068844260874568369820828D+01
  pw(11)= 0.39348541670555911675625708842098543D+01
endif
if(kn == 12) then
  px( 1)= 0.12632156319939695579215561432558385D-02
  px( 2)= 0.70387146180879286642550585568639377D-02
  px( 3)= 0.19302659916972801592515201957656444D-01
  px( 4)= 0.42551194105513329489354627472007290D-01
  px( 5)= 0.86085992365439625679560348707191417D-01
  px( 6)= 0.16725813918676372888922850902058409D+00
  px( 7)= 0.31700589361943171070304767229555238D+00
  px( 8)= 0.58951191619791589683106843254408061D+00
  px( 9)= 0.10788413480839543106858840025589018D+01
  px(10)= 0.19492439011651360999619060490611511D+01
  px(11)= 0.35027911449093405858739078699931569D+01
  px(12)= 0.64217203451802643126959421992550844D+01
  pw( 1)= 0.32827550127604954815335522044868924D-02
  pw( 2)= 0.85507540197432347733759971108613029D-02
  pw( 3)= 0.16691067543209908975186757261638663D-01
  pw( 4)= 0.31305443669027793014029811945580099D-01
  pw( 5)= 0.58567896813505682343320309424861089D-01
  pw( 6)= 0.10877780693120356209434163632243069D+00
  pw( 7)= 0.19948368504455875259042629374456601D+00
  pw( 8)= 0.36073967408442558747147434040847228D+00
  pw( 9)= 0.64434179114194185133722660716595021D+00
  pw(10)= 0.11440591869200469793282529105709381D+01
  pw(11)= 0.20620613323447639907885178297356148D+01
  pw(12)= 0.41107547758236817466309181956604953D+01
endif
if(kn == 13) then
  px( 1)= 0.11568070520917003084172899381406952D-02
  px( 2)= 0.63841031288591798815234066736007959D-02
  px( 3)= 0.17167711063873432612672836118321923D-01
  px( 4)= 0.36716019315047555758945584779212588D-01
  px( 5)= 0.71538434902470635056036514447143755D-01
  px( 6)= 0.13352689214829569833793677431883262D+00
  px( 7)= 0.24327491638178311179091055382048232D+00
  px( 8)= 0.43570388054574854249210127119178039D+00
  px( 9)= 0.76944422789933215499607649746035088D+00
  px(10)= 0.13426076062689412695687622546331410D+01
  px(11)= 0.23216397056754496795639041380757885D+01
  px(12)= 0.40076692644610800412009568941378368D+01
  px(13)= 0.70807767026725092855482684561044825D+01
  pw( 1)= 0.29999461201538405335426373656007144D-02
  pw( 2)= 0.76647148893919466896210631066410433D-02
  pw( 3)= 0.14413099397767107036014918126327008D-01
  pw( 4)= 0.25735254465096214146045248201904623D-01
  pw( 5)= 0.45838911095175772187879197848974379D-01
  pw( 6)= 0.81479609103017647524386799211775902D-01
  pw( 7)= 0.14368582127715272775954689518716653D+00
  pw( 8)= 0.25069362938769053221329919008840415D+00
  pw( 9)= 0.43269827884396605348016529885550754D+00
  pw(10)= 0.74044407474304235266031833325121847D+00
  pw(11)= 0.12650477516195139055095418091901788D+01
  pw(12)= 0.22054684388256755415929800672572855D+01
  pw(13)= 0.42773285665753897495906588616832298D+01
endif
if(kn == 14) then
  px( 1)= 0.10671394835726993643401190254501129D-02
  px( 2)= 0.58463219387999205854721615603871185D-02
  px( 3)= 0.15490001691602291418567227600617406D-01
  px( 4)= 0.32358969391919711170669944447127038D-01
  px( 5)= 0.61149820125492142314645657324953302D-01
  px( 6)= 0.11030358671474348741774495105493271D+00
  px( 7)= 0.19410127886489828338777312891458955D+00
  px( 8)= 0.33608975279087339935499749076365196D+00
  px( 9)= 0.57467416136431217184690034730315880D+00
  px(10)= 0.97213677138209888520957230352753264D+00
  px(11)= 0.16296229550658990298708599801796051D+01
  px(12)= 0.27148835813646440924906285656041458D+01
  px(13)= 0.45279078084008377593720415669623160D+01
  px(14)= 0.77475240501693856896302484250295344D+01
  pw( 1)= 0.27629693325443496023249306681806622D-02
  pw( 2)= 0.69561289060164080762372517703735452D-02
  pw( 3)= 0.12707947219219552524391040926686251D-01
  pw( 4)= 0.21789865957161394780641970526254899D-01
  pw( 5)= 0.37165450147146819315861454426090832D-01
  pw( 6)= 0.63467023298815675308212729382023282D-01
  pw( 7)= 0.10796235746711791223910582849233129D+00
  pw( 8)= 0.18227038265561301471910246064953376D+00
  pw( 9)= 0.30504176678107803021400309104091856D+00
  pw(10)= 0.50632019264974725562617387788020652D+00
  pw(11)= 0.83570187185256971962451509332190849D+00
  pw(12)= 0.13820370228408991881296397708221031D+01
  pw(13)= 0.23420578929692185520173441027903024D+01
  pw(14)= 0.44356505634271121964311698817472400D+01
endif
if(kn == 15) then
  px( 1)= 0.99051088742239546911827900108699496D-03
  px( 2)= 0.53956859621998690434579925957171424D-02
  px( 3)= 0.14133099949775560668841655685250135D-01
  px( 4)= 0.28986898223070841544449976160392634D-01
  px( 5)= 0.53435705913102094881195404152789995D-01
  px( 6)= 0.93645206162765297669714244403422362D-01
  px( 7)= 0.15985934779166946137952895657247365D+00
  px( 8)= 0.26857062154409215737173322640809941D+00
  px( 9)= 0.44599642616020670957476031778753703D+00
  px(10)= 0.73354905454082877060570463263769745D+00
  px(11)= 0.11964718339441153959477756602491571D+01
  px(12)= 0.19381471569679916567453627291281352D+01
  px(13)= 0.31270149297417650854875367303912466D+01
  px(14)= 0.50618963332858424622137075227057629D+01
  px(15)= 0.84211464685237105475663901928632362D+01
  pw( 1)= 0.25613355491269301472247025631698555D-02
  pw( 2)= 0.63749573647622919143443050089843640D-02
  pw( 3)= 0.11385424145275303734569902166128714D-01
  pw( 4)= 0.18885541036270664981042580089520502D-01
  pw( 5)= 0.31017529676997219516938356388920347D-01
  pw( 6)= 0.51073868255802230619626900228351940D-01
  pw( 7)= 0.84046732560351404937544837831163072D-01
  pw( 8)= 0.13765675735555740692176543168654955D+00
  pw( 9)= 0.22395807420699105358370420342497012D+00
  pw(10)= 0.36179555862328041144887460703035761D+00
  pw(11)= 0.58087464283264030346041192108355511D+00
  pw(12)= 0.92964960101952292137644303560667260D+00
  pw(13)= 0.14950837580230651438254975578030658D+01
  pw(14)= 0.24724522131384988410164432454754806D+01
  pw(15)= 0.45866150536692880851084073088444439D+01
endif
if(kn == 16) then
  px( 1)= 0.92424556053971804395203579030996377D-03
  px( 2)= 0.50119857035276309167085959684639920D-02
  px( 3)= 0.13010148344461010136325444162584406D-01
  px( 4)= 0.26298847872231801244580127340702382D-01
  px( 5)= 0.47514597563807100058998705367026609D-01
  px( 6)= 0.81270265524596050675960333331275375D-01
  px( 7)= 0.13512212854897371400148043770796492D+00
  px( 8)= 0.22099831669763609789452208029307415D+00
  px( 9)= 0.35743533198723356545740999174337465D+00
  px(10)= 0.57303934564748771037392604303226621D+00
  px(11)= 0.91178803183594107838418321994075593D+00
  px(12)= 0.14412990877209031034459072051939979D+01
  px(13)= 0.22665732295803028877227882175486339D+01
  px(14)= 0.35563219327028564804732957321586739D+01
  px(15)= 0.56082683107347449605789692452752341D+01
  px(16)= 0.91009557053769985645449386780285663D+01
  pw( 1)= 0.23875730074587121522484947794868875D-02
  pw( 2)= 0.58885836354644078094393546205524519D-02
  pw( 3)= 0.10329316404953667658388475423521547D-01
  pw( 4)= 0.16675469828365142363971545189694061D-01
  pw( 5)= 0.26509288186703737427234519675535818D-01
  pw( 6)= 0.42238486164148838677474311842225533D-01
  pw( 7)= 0.67416914217096425505948847545251978D-01
  pw( 8)= 0.10736855475828194921843388490206803D+00
  pw( 9)= 0.17018723045468088538746817095795499D+00
  pw(10)= 0.26821766647062034548841613907117539D+00
  pw(11)= 0.42033354906191972945041277677914052D+00
  pw(12)= 0.65579398374758854246146234684717478D+00
  pw(13)= 0.10219768938841077866955934226960186D+01
  pw(14)= 0.16043073953579345130225854215735434D+01
  pw(15)= 0.25972025694404090887006269510370113D+01
  pw(16)= 0.47309741605753804978373532621330190D+01
endif
if(kn == 17) then
  px( 1)= 0.86635871969021922697368620380719171D-03
  px( 2)= 0.46809392638055264395521402125297454D-02
  px( 3)= 0.12063365169996780691336553708488918D-01
  px( 4)= 0.24103101327380368111361062755741909D-01
  px( 5)= 0.42839783531484774994275135488102184D-01
  px( 6)= 0.71796215026314425758110076991702409D-01
  px( 7)= 0.11667729790867741765510249018437646D+00
  px( 8)= 0.18634666322578944021297170782701070D+00
  px( 9)= 0.29431002802504656436686613469103506D+00
  px(10)= 0.46097947485749393786168585286436753D+00
  px(11)= 0.71707474488613285211211458276745483D+00
  px(12)= 0.11087399814864640384073502346191564D+01
  px(13)= 0.17054769509601451753469079240400202D+01
  px(14)= 0.26134294141755383267430920003219774D+01
  px(15)= 0.40013054555328633047267069424482020D+01
  px(16)= 0.61658542528138849120122933226961818D+01
  px(17)= 0.97863651496368699835621922821544266D+01
  pw( 1)= 0.22362031087732985183223720565899613D-02
  pw( 2)= 0.54748197495181657019575138084577960D-02
  pw( 3)= 0.94654762542541339323585186529928706D-02
  pw( 4)= 0.14944978294023789536885689508849665D-01
  pw( 5)= 0.23104141337215046610391678093559219D-01
  pw( 6)= 0.35743858431643263735692324511510319D-01
  pw( 7)= 0.55471485911701630593769305151799996D-01
  pw( 8)= 0.86081253422553517325473099895533971D-01
  pw( 9)= 0.13319208512009976788628468120231006D+00
  pw(10)= 0.20518383340535621745997474262468218D+00
  pw(11)= 0.31457026902282458163459435604989060D+00
  pw(12)= 0.48013605826872593355323421318271994D+00
  pw(13)= 0.73064164224806746286555643417201840D+00
  pw(14)= 0.11124853152432080885402590631214998D+01
  pw(15)= 0.17098620915289443753971369096340138D+01
  pw(16)= 0.27167962114974631513284929060677873D+01
  pw(17)= 0.48693666605809874327613580765223186D+01
endif
if(kn == 18) then
  px( 1)= 0.81534546944719247652148851160350705D-03
  px( 2)= 0.43921383032957290852797835084086745D-02
  px( 3)= 0.11252831287113979876218879126262041D-01
  px( 4)= 0.22272809918423842477230910840641111D-01
  px( 5)= 0.39059190621733757694717358109890744D-01
  px( 6)= 0.64351345855435130240707418934923649D-01
  px( 7)= 0.10254178168021558618169365620644254D+00
  px( 8)= 0.16036912239056014178785088963204099D+00
  px( 9)= 0.24793085437822483127871211432445117D+00
  px(10)= 0.38020606680363380296594904808373420D+00
  px(11)= 0.57931198537370336370768123946111904D+00
  px(12)= 0.87782030094596229067122251201903469D+00
  px(13)= 0.13236886505899049407415999004449793D+01
  px(14)= 0.19878981731926587403713993880950166D+01
  px(15)= 0.29773742063276571130424960439239811D+01
  px(16)= 0.44606479473592453417809733684642453D+01
  px(17)= 0.67336454736569532214104241445939923D+01
  px(18)= 0.10476870213785278025831291196419849D+02
  pw( 1)= 0.21031106134613254745224559686561387D-02
  pw( 2)= 0.51180225478690087298803997939678307D-02
  pw( 3)= 0.87447370935970058836913883371899363D-02
  pw( 4)= 0.13556333730223126136121123231259769D-01
  pw( 5)= 0.20464410216338036789779126385561199D-01
  pw( 6)= 0.30840826466947410241261173555971053D-01
  pw( 7)= 0.46646725563835069845910497771424517D-01
  pw( 8)= 0.70665992632893967524146851106623791D-01
  pw( 9)= 0.10691711075454395961181073477729829D+00
  pw(10)= 0.16126547210903485792084905962898804D+00
  pw(11)= 0.24229509616610255685205188073761953D+00
  pw(12)= 0.36259234617456851620630123413473169D+00
  pw(13)= 0.54077318770758097024862643911836327D+00
  pw(14)= 0.80508517291294611337977692389747849D+00
  pw(15)= 0.12010568605667241321654935386099247D+01
  pw(16)= 0.18119190754724382445935517697030275D+01
  pw(17)= 0.28316640971192016310500153967949394D+01
  pw(18)= 0.50023398513295527439214736503709354D+01
endif
if(kn == 19) then
  px( 1)= 0.77004314038027538186473565824644713D-03
  px( 2)= 0.41377999330050882914315571254404182D-02
  px( 3)= 0.10550059721986121680218103475882631D-01
  px( 4)= 0.20721165151890931602860316370210977D-01
  px( 5)= 0.35938464219963308088025295472146865D-01
  px( 6)= 0.58366846240533488939212086566679739D-01
  px( 7)= 0.91445878837421954880767431790624735D-01
  px( 8)= 0.14039874091074934933241224785817280D+00
  px( 9)= 0.21294392165350590964714225395783962D+00
  px(10)= 0.32034449388214261059174416345147381D+00
  px(11)= 0.47894630556295055579310759106626288D+00
  px(12)= 0.71240272881825772752142518345001522D+00
  px(13)= 0.10548945187200170944433178271823931D+01
  px(14)= 0.15558853016268620673915640887496031D+01
  px(15)= 0.22875048294126069831169385958820912D+01
  px(16)= 0.33571879025245227476638520498261293D+01
  px(17)= 0.49331870217088227943005162552018204D+01
  px(18)= 0.73107657529555946558412435928344152D+01
  px(19)= 0.11172033293322081236666941378477642D+02
  pw( 1)= 0.19851404434292128161572603749012797D-02
  pw( 2)= 0.48068259850224485883558544189622861D-02
  pw( 3)= 0.81333622551403917938013382271885652D-02
  pw( 4)= 0.12418290368147926797125266347472059D-01
  pw( 5)= 0.18370520996399132266929646675963512D-01
  pw( 6)= 0.27051260748772011764068846294046263D-01
  pw( 7)= 0.39965808856363914121506612420685851D-01
  pw( 8)= 0.59209186306872358867005896800202963D-01
  pw( 9)= 0.87733163743117132114765866319084195D-01
  pw(10)= 0.12975590467993236932824761605587432D+00
  pw(11)= 0.19133746801777096221136436300603368D+00
  pw(12)= 0.28119521004597734924657796391935552D+00
  pw(13)= 0.41191451657988898367993353735036478D+00
  pw(14)= 0.60189235614006428503841831846326255D+00
  pw(15)= 0.87887424161089233540150542700936886D+00
  pw(16)= 0.12876310724220064351766502884115249D+01
  pw(17)= 0.19106555786053829247748848866287425D+01
  pw(18)= 0.29421880423760456779000496029582960D+01
  pw(19)= 0.51303663807899157605725316747503964D+01
endif
if(kn == 20) then
  px( 1)= 0.72953870581824875898426590899779881D-03
  px( 2)= 0.39119765013576279090594732249736674D-02
  px( 3)= 0.99341482544177994609830844666447236D-02
  px( 4)= 0.19386948343749964006247704258211447D-01
  px( 5)= 0.33316937960159820123580449168857215D-01
  px( 6)= 0.53460240758464289437871006955420897D-01
  px( 7)= 0.82550373662718413944945968267436420D-01
  px( 8)= 0.12470333365766989270462564119778831D+00
  px( 9)= 0.18593248929460522396945432673813683D+00
  px(10)= 0.27488824477709750979845021236505632D+00
  px(11)= 0.40393075219294011341163041535306531D+00
  px(12)= 0.59066371193107531104946391158049526D+00
  px(13)= 0.86011311520208939992657730367961144D+00
  px(14)= 0.12478475018108315971898483004517581D+01
  px(15)= 0.18045718085352853467882826664457563D+01
  px(16)= 0.26032962838705539076929338309800964D+01
  px(17)= 0.37517626775845063477806691210141684D+01
  px(18)= 0.54178931704948062041809621881307184D+01
  px(19)= 0.78964489442873309920085649476831128D+01
  px(20)= 0.11871472067202549660846380067126100D+02
  pw( 1)= 0.18798307004678227911126701301382902D-02
  pw( 2)= 0.45327579066213798867372241143837770D-02
  pw( 3)= 0.76074915984009747299662992379957293D-02
  pw( 4)= 0.11468617772837279819666929117999041D-01
  pw( 5)= 0.16675567273387276975224875991907841D-01
  pw( 6)= 0.24060338209931569028899923305997740D-01
  pw( 7)= 0.34797589593340192429611675508702300D-01
  pw( 8)= 0.50498483539096564292114787807163509D-01
  pw( 9)= 0.73383972617080340693094946803759227D-01
  pw(10)= 0.10656241858153477344295213679085888D+00
  pw(11)= 0.15442089967699606004539206241769081D+00
  pw(12)= 0.22316517325789412150938929616587900D+00
  pw(13)= 0.32158746804288047814456613183637546D+00
  pw(14)= 0.46221802166864090447194287669501892D+00
  pw(15)= 0.66320650916245908698703462902787156D+00
  pw(16)= 0.95182294118921990028099509733606027D+00
  pw(17)= 0.13721884223731472188837264029436159D+01
  pw(18)= 0.20062479833990429444286070644467212D+01
  pw(19)= 0.30487071357319501782576369389563967D+01
  pw(20)= 0.52538573669990067214113994100342659D+01
endif
if(kn == 21) then
  px( 1)= 0.69310486169589490054767779485652272D-03
  px( 2)= 0.37100374076510691098395748526914731D-02
  px( 3)= 0.93893881986074420164580675137225674D-02
  px( 4)= 0.18225818290917406339248365551994452D-01
  px( 5)= 0.31081498488793808069000194256763116D-01
  px( 6)= 0.49367420729419602783748969736699563D-01
  px( 7)= 0.75284896750519291461000850881359128D-01
  px( 8)= 0.11212409497044480168252045403791321D+00
  px( 9)= 0.16464732212808249809258249926002432D+00
  px(10)= 0.23962225781352520103022311097593359D+00
  px(11)= 0.34658518012264822513642471749928831D+00
  px(12)= 0.49892252217405192191396093341852149D+00
  px(13)= 0.71538674271382417280638826801508549D+00
  px(14)= 0.10222215706608203725632212510312547D+01
  px(15)= 0.14561846864798943048112298539958500D+01
  px(16)= 0.20689966860645877444413948503855558D+01
  px(17)= 0.29343325491322992822962883455667422D+01
  px(18)= 0.41600923418527605289681744860608923D+01
  px(19)= 0.59138510177367345119623187111536027D+01
  px(20)= 0.84900211059998571872908583995965399D+01
  px(21)= 0.12574850278864023350809778583936857D+02
  pw( 1)= 0.17852307235103793959959450796716884D-02
  pw( 2)= 0.42893635684453385047417019848134615D-02
  pw( 3)= 0.71497939239830042802199211798008382D-02
  pw( 4)= 0.10663735418026519276123538929713931D-01
  pw( 5)= 0.15278738558420813530874306732239620D-01
  pw( 6)= 0.21655078725685226823011775486802689D-01
  pw( 7)= 0.30722016510142553890174563226245394D-01
  pw( 8)= 0.43741403514742541630405757195910036D-01
  pw( 9)= 0.62420477800170703110133642765679935D-01
  pw(10)= 0.89101011801730193914410815797468243D-01
  pw(11)= 0.12703103910528559102170033988553577D+00
  pw(12)= 0.18073427743399167030424190804804963D+00
  pw(13)= 0.25651888703698665673377349665161239D+00
  pw(14)= 0.36320523524230891449268691236436560D+00
  pw(15)= 0.51323006313409951821184870857512202D+00
  pw(16)= 0.72448352105440485035350350605592673D+00
  pw(17)= 0.10237957354057707173113819962280747D+01
  pw(18)= 0.14547382360170350806458262214201030D+01
  pw(19)= 0.20988676887781728328899280598296916D+01
  pw(20)= 0.31515233601433750723678379202457850D+01
  pw(21)= 0.53731727475008532237843822389416189D+01
endif
if(kn == 22) then
  px( 1)= 0.66015487793114579672026064530843580D-03
  px( 2)= 0.35283188763257655749934705032913356D-02
  px( 3)= 0.89037268484852140335335192775132156D-02
  px( 4)= 0.17204887313904086178312640698870646D-01
  px( 5)= 0.29150571838447577747778236163957035D-01
  px( 6)= 0.45901615793714000736387715594203021D-01
  px( 7)= 0.69252127065257752538232461849428663D-01
  px( 8)= 0.10186530460793644200891559033979032D+00
  px( 9)= 0.14756646191534939234956638050262194D+00
  px(10)= 0.21173627302990231446602872154763540D+00
  px(11)= 0.30186392834135377102923595739844832D+00
  px(12)= 0.42832456502483048109845734510065518D+00
  px(13)= 0.60545815580026546162531862085612489D+00
  px(14)= 0.85305900599439063193443527117705937D+00
  px(15)= 0.11984444149249300732981072917233551D+01
  px(16)= 0.16793849380767164321266153811733636D+01
  px(17)= 0.23484259421990250059871794075320909D+01
  px(18)= 0.32797346839031417791643463913803933D+01
  px(19)= 0.45812624093642886254220734381797637D+01
  px(20)= 0.64202435545325521457505355440378480D+01
  px(21)= 0.90908861089411744472574137099194608D+01
  px(22)= 0.13281870386631548366752315803495071D+02
  pw( 1)= 0.16997739815079876291270142303147830D-02
  pw( 2)= 0.40716314869569174969368080298995427D-02
  pw( 3)= 0.67473810622389953786984914722964259D-02
  pw( 4)= 0.99723772588960829502246883384624672D-02
  pw( 5)= 0.14109253034463888804804922921072868D-01
  pw( 6)= 0.19687945390172770224722572299963933D-01
  pw( 7)= 0.27452171417575159428955066586690985D-01
  pw( 8)= 0.38405330139190366155267988240486796D-01
  pw( 9)= 0.53884692766803369761362767720533598D-01
  pw(10)= 0.75690346610129349832179626694927492D-01
  pw(11)= 0.10627642236395592176596973365055862D+00
  pw(12)= 0.14901040431853077087285757833822327D+00
  pw(13)= 0.20852197820697925399881980495903384D+00
  pw(14)= 0.29118491216948479495401093995994782D+00
  pw(15)= 0.40581134430662519733362245846705041D+00
  pw(16)= 0.56471875154845478179304492458155087D+00
  pw(17)= 0.78553695828755046999062010778990119D+00
  pw(18)= 0.10946963582465286266450172551190923D+01
  pw(19)= 0.15353099122697920414083249854348604D+01
  pw(20)= 0.21886787280255501097880613119022761D+01
  pw(21)= 0.32509064591655802312953073550183727D+01
  pw(22)= 0.54886295320492726768301302193581765D+01
endif
if(kn == 23) then
  px( 1)= 0.63021006363433841831474149369938629D-03
  px( 2)= 0.33638809698722088589479529444503357D-02
  px( 3)= 0.84677484260852652320615476282127309D-02
  px( 4)= 0.16299243886097943905725295278638059D-01
  px( 5)= 0.27464030423556247673984741054128575D-01
  px( 6)= 0.42927866788160825736932098072471507D-01
  px( 7)= 0.64169139230662564082303838471065529D-01
  px( 8)= 0.93367767657860048911427490092659179D-01
  px( 9)= 0.13363456957733254533882679272072078D+00
  px(10)= 0.18930799757692553449088970134122038D+00
  px(11)= 0.26636229253087365091814709204751323D+00
  px(12)= 0.37297580801326442775998852633706569D+00
  px(13)= 0.52031366792206514283148817023645741D+00
  px(14)= 0.72359600291057382682653618452186879D+00
  px(15)= 0.10035561979187412137041345167147008D+01
  px(16)= 0.13884527722049286720427614547615987D+01
  px(17)= 0.19169141925914051220031027488430615D+01
  px(18)= 0.26421501677657864516298531009004741D+01
  px(19)= 0.36386833380196488331409942198293287D+01
  px(20)= 0.50144408008467284169777642211293427D+01
  px(21)= 0.69363388633219643316723260573935269D+01
  px(22)= 0.96985139442985089392873665294609340D+01
  px(23)= 0.13992267642385099650757505185917464D+02
  pw( 1)= 0.16221873306891233611184498841470861D-02
  pw( 2)= 0.38756062368028647892929037543456805D-02
  pw( 3)= 0.63904681228155448198104664799116312D-02
  pw( 4)= 0.93716130533642383510190970859726025D-02
  pw( 5)= 0.13116359133127231514779092120465823D-01
  pw( 6)= 0.18054564644654175010476006376716577D-01
  pw( 7)= 0.24787545528949442975874855915817576D-01
  pw( 8)= 0.34123347100699979880664417166869481D-01
  pw( 9)= 0.47126644724531756094751076593005203D-01
  pw(10)= 0.65206569654682359265380728357008572D-01
  pw(11)= 0.90252198579742822099518198813744744D-01
  pw(12)= 0.12481812207643272140418893825548652D+00
  pw(13)= 0.17237035227520038668196439463328275D+00
  pw(14)= 0.23761696881618806722148067227743494D+00
  pw(15)= 0.32696691109252817236452507243569941D+00
  pw(16)= 0.44919654054160466696484020754729982D+00
  pw(17)= 0.61648810596906235080169489216474494D+00
  pw(18)= 0.84621818814094735945360350883771170D+00
  pw(19)= 0.11644590806092632658493343351752018D+01
  pw(20)= 0.16139465349437736570093587472680170D+01
  pw(21)= 0.22758365152455412423280162288521126D+01
  pw(22)= 0.33470981208584956190993329351906399D+01
  pw(23)= 0.56005084488693785143169408072395655D+01
endif
if(kn == 24) then
  px( 1)= 0.60287590220675965883655392550708199D-03
  px( 2)= 0.32143351024974124786544026559297415D-02
  px( 3)= 0.80739802149419819753399469823810803D-02
  px( 4)= 0.15489662347070758196056101724102825D-01
  px( 5)= 0.25976667055963881164895151817795199D-01
  px( 6)= 0.40346714011175627204924600258024553D-01
  px( 7)= 0.59830440001259694739569609351980817D-01
  px( 8)= 0.86230308264184025703796753562250373D-01
  px( 9)= 0.12210371973165121163051429982451776D+00
  px(10)= 0.17099203191550984584070639962768156D+00
  px(11)= 0.23772719534691312495205955287685848D+00
  px(12)= 0.32885366959546582684337055007155510D+00
  px(13)= 0.45320556860130100192674333119232671D+00
  px(14)= 0.62268761188094067470211791701931515D+00
  px(15)= 0.85332750333845602641945072572045710D+00
  px(16)= 0.11667004858019451293051164929872329D+01
  px(17)= 0.15918861333740258915421115101398109D+01
  px(18)= 0.21682356132478165458928387387641436D+01
  px(19)= 0.29494889123245918407695084553095216D+01
  px(20)= 0.40104161879498382932676206134824540D+01
  px(21)= 0.54588693247348625992863433295378994D+01
  px(22)= 0.74614789122023638202247166496000371D+01
  px(23)= 0.10312431148373425365575271866282924D+02
  px(24)= 0.14705805275028081231659123827294642D+02
  pw( 1)= 0.15514249847644583248110080072115634D-02
  pw( 2)= 0.36981205611282502501592938773909080D-02
  pw( 3)= 0.60714888966684178001398442739385021D-02
  pw( 4)= 0.88442862964874279166007983229029862D-02
  pw( 5)= 0.12262956109957475661400953934190561D-01
  pw( 6)= 0.16679687959122678642462992762851947D-01
  pw( 7)= 0.22585160392521754760445705422367202D-01
  pw( 8)= 0.30637073979795749450832614038637313D-01
  pw( 9)= 0.41694955770756579068288981525602823D-01
  pw(10)= 0.56880053645721037701497821632682136D-01
  pw(11)= 0.77671508906845583575064408093070968D-01
  pw(12)= 0.10604093207274572585305524523636662D+00
  pw(13)= 0.14462967696642788409146183249874326D+00
  pw(14)= 0.19698231180562617603349065754159954D+00
  pw(15)= 0.26786134570104304270817950330971854D+00
  pw(16)= 0.36368625547483729027913381140943346D+00
  pw(17)= 0.49317740444788268405884668163369343D+00
  pw(18)= 0.66837334895456593354822252636195142D+00
  pw(19)= 0.90640972513509685558875644594827397D+00
  pw(20)= 0.12330418540439459719440490731353612D+01
  pw(21)= 0.16907002256383886184087957665579435D+01
  pw(22)= 0.23604873140910405927871490349730829D+01
  pw(23)= 0.34403155641323731993571442081042100D+01
  pw(24)= 0.57090593461669661084141390492124683D+01
endif
if(kn == 25) then
  px( 1)= 0.57782426626576571901902524785967824D-03
  px( 2)= 0.30777191085612843075800020147563616D-02
  px( 3)= 0.77164086160794063370485387996841129D-02
  px( 4)= 0.14761056704626219657716466804157254D-01
  px( 5)= 0.24653875400014389680962462419049193D-01
  px( 6)= 0.38083523913823039614894844760656273D-01
  px( 7)= 0.56084067240729530165951958613013393D-01
  px( 8)= 0.80159727346580499135438064461924847D-01
  px( 9)= 0.11243339120217788148662085401543468D+00
  px(10)= 0.15582715928119113928223955420169306D+00
  px(11)= 0.21429698577498381337290048538797344D+00
  px(12)= 0.29315054947238081211765761052065623D+00
  px(13)= 0.39947904356246012931942329550682875D+00
  px(14)= 0.54273750890918728697108592749256418D+00
  px(15)= 0.73551917539468211697041027264605642D+00
  px(16)= 0.99458876650351865510403034983347981D+00
  px(17)= 0.13422725867611823095435983972364716D+01
  px(18)= 0.18083631354696402035562158086478313D+01
  px(19)= 0.24328170422327489041615980739248420D+01
  px(20)= 0.32697931199298648820663632485790012D+01
  px(21)= 0.43942247576362161609644700980578340D+01
  px(22)= 0.59138559751958628054368604601307713D+01
  px(23)= 0.79950700685028878658475844781145359D+01
  px(24)= 0.10932212901976999668719864628273880D+02
  px(25)= 0.15422270538187376197239585881075748D+02
  pw( 1)= 0.14866196466384881027031457863846341D-02
  pw( 2)= 0.35366057944120495831689126436344645D-02
  pw( 3)= 0.57844969402891304739165399375745324D-02
  pw( 4)= 0.83773253924994338826352544649181741D-02
  pw( 5)= 0.11521432119169876731207250699755894D-01
  pw( 6)= 0.15508119705558278186014992003540867D-01
  pw( 7)= 0.20741213416907048628693122469214068D-01
  pw( 8)= 0.27760968610727861118254402368893756D-01
  pw( 9)= 0.37269537287121025856202203197461521D-01
  pw(10)= 0.50172098341486540969354039874345299D-01
  pw(11)= 0.67645050740466106776500656782887390D-01
  pw(12)= 0.91234375023821592290664320838692913D-01
  pw(13)= 0.12298569754451901426257783074280505D+00
  pw(14)= 0.16561310646694880188580709432419945D+00
  pw(15)= 0.22272153335996509389159575477724314D+00
  pw(16)= 0.29910756989135904284632341805878551D+00
  pw(17)= 0.40118169825940023204127855629976398D+00
  pw(18)= 0.53759403804464314015326297165302822D+00
  pw(19)= 0.72023661788993173698912869326221741D+00
  pw(20)= 0.96601967120274407325842915516032939D+00
  pw(21)= 0.13004209336797472935438387369012951D+01
  pw(22)= 0.17656287674999046987390122872170472D+01
  pw(23)= 0.24427681629137658222037012630588612D+01
  pw(24)= 0.35307546103133160002458888441211917D+01
  pw(25)= 0.58145056190411423438373377369723833D+01
endif
if(kn == 26) then
  px( 1)= 0.55477997323631075943068059436768679D-03
  px( 2)= 0.29524051251057578595813790584093855D-02
  px( 3)= 0.73901342939831943165981049698675567D-02
  px( 4)= 0.14101412872584234971190262785177463D-01
  px( 5)= 0.23468728331528566192654626405819210D-01
  px( 6)= 0.36081354457771003437927577005080307D-01
  px( 7)= 0.52815777662090440120493976780463113D-01
  px( 8)= 0.74938112557816762151465822385814066D-01
  px( 9)= 0.10422602290395549848995179022541619D+00
  px(10)= 0.14311379843177524483131355370021475D+00
  px(11)= 0.19487526595566569453971371848061316D+00
  px(12)= 0.26386679946717607062454498658707156D+00
  px(13)= 0.35585463477981546153201478673425350D+00
  px(14)= 0.47845228003668789580973663677048048D+00
  px(15)= 0.64169971258466993649179145930192297D+00
  px(16)= 0.85882779202859317392945336605019422D+00
  px(17)= 0.11472706757497270472184438297710363D+01
  px(18)= 0.15300218181930435465993945481075142D+01
  px(19)= 0.20374900555366768284567833572011801D+01
  px(20)= 0.27101363667403762213767958798451042D+01
  px(21)= 0.36024461925895008266595796162422643D+01
  px(22)= 0.47894509506391986224214442346207227D+01
  px(23)= 0.63787680281602106661197309343576824D+01
  px(24)= 0.85365750410497181159653468391328011D+01
  px(25)= 0.11557476465733555694328533876083768D+02
  px(26)= 0.16141471440934226918800792463390524D+02
  pw( 1)= 0.14270457888511795867992646035078330D-02
  pw( 2)= 0.33889549852374609060800978480342579D-02
  pw( 3)= 0.55247507422590039192859514393700253D-02
  pw( 4)= 0.79606058991690688534072920870913751D-02
  pw( 5)= 0.10870893529433384055135393826453360D-01
  pw( 6)= 0.14498723203402237674680094273702632D-01
  pw( 7)= 0.19179116372035461554716799339102955D-01
  pw( 8)= 0.25359449796805531683017831774564858D-01
  pw( 9)= 0.33619093306389351199382063563600456D-01
  pw(10)= 0.44698102947503307879411438578940957D-01
  pw(11)= 0.59545498569788992362177569759542076D-01
  pw(12)= 0.79391390756669405807121619168425508D-01
  pw(13)= 0.10584364527942384492476511067473085D+00
  pw(14)= 0.14101237929374191599558996117239049D+00
  pw(15)= 0.18767097313836850144218059320809785D+00
  pw(16)= 0.24946862930962964921754344345139933D+00
  pw(17)= 0.33121906265157831801486301115689293D+00
  pw(18)= 0.43930860961154203611926221969681638D+00
  pw(19)= 0.58230770087411222173176311911927048D+00
  pw(20)= 0.77196313761963428481446391672957021D+00
  pw(21)= 0.10249770981257475300463739775919616D+01
  pw(22)= 0.13665866627564720110102420582560601D+01
  pw(23)= 0.18387931590238615303343058387625137D+01
  pw(24)= 0.25228070818980592228138174960180006D+01
  pw(25)= 0.36185923153701902774641344711352413D+01
  pw(26)= 0.59170478659334870019465678075549678D+01
endif
if(kn == 27) then
  px( 1)= 0.53351049035404632679792315747760926D-03
  px( 2)= 0.28370305792687798355464055618059207D-02
  px( 3)= 0.70911216690725917919709661777310467D-02
  px( 4)= 0.13501035871356777604646936827660401D-01
  px( 5)= 0.22399961695605187088994736400122990D-01
  px( 6)= 0.34296092152256244946377676950669096D-01
  px( 7)= 0.49938369643043464349412733250120371D-01
  px( 8)= 0.70401007218931052290887962696404315D-01
  px( 9)= 0.97184515439527403402719960641852663D-01
  px(10)= 0.13233419679650342626453438780924062D+00
  px(11)= 0.17858535768221430523992541052027664D+00
  px(12)= 0.23955186967002279067082055689473205D+00
  px(13)= 0.31997738343786115574032202180084953D+00
  px(14)= 0.42606917808870858677237819912563285D+00
  px(15)= 0.56593757336952698275709554352322422D+00
  px(16)= 0.75017087050170008688238981674255895D+00
  px(17)= 0.99258767627203407312800418206037430D+00
  px(18)= 0.13112276119862221456283706350994460D+01
  px(19)= 0.17296743945926671138206419268165977D+01
  px(20)= 0.22788674435500397192690477951071238D+01
  px(21)= 0.29996852862458953100640794763905730D+01
  px(22)= 0.39468640965897806748062604397538661D+01
  px(23)= 0.51954835049739316659023548298272390D+01
  px(24)= 0.68530258860308177417175245026171396D+01
  px(25)= 0.90855060116903171155308252608094055D+01
  px(26)= 0.12187875689542501045614051917426613D+02
  px(27)= 0.16863234023420842677139640506273211D+02
  pw( 1)= 0.13720916834443970883055143999864006D-02
  pw( 2)= 0.32534222826312859680330393960878445D-02
  pw( 3)= 0.52884203958454954233826913886323010D-02
  pw( 4)= 0.75861682815905379946822876423968075D-02
  pw( 5)= 0.10295285639112777079908697606376495D-01
  pw( 6)= 0.13620382459545697869019461721069283D-01
  pw( 7)= 0.17841523884178755603525268045244929D-01
  pw( 8)= 0.23331884086195134219312146516778989D-01
  pw( 9)= 0.30573638051336305998992920739412241D-01
  pw(10)= 0.40178513173563771124515253029295068D-01
  pw(11)= 0.52921980029762362141777841892525060D-01
  pw(12)= 0.69796141123370781915050562748149785D-01
  pw(13)= 0.92082178946617789793924526199756695D-01
  pw(14)= 0.12144364501581543284664137255263233D+00
  pw(15)= 0.16004546398125829773973180676428128D+00
  pw(16)= 0.21070793305215927164839501305159383D+00
  pw(17)= 0.27711057981819535787363684480367458D+00
  pw(18)= 0.36407033983503565406434335329539225D+00
  pw(19)= 0.47793795110360227457939282572737921D+00
  pw(20)= 0.62719851165950099532441318332470642D+00
  pw(21)= 0.82345785449976155240467438227528273D+00
  pw(22)= 0.10832282284259041619866566987699138D+01
  pw(23)= 0.14315401678117573067846471990768551D+01
  pw(24)= 0.19102558501900861570470238950653852D+01
  pw(25)= 0.26007234476536547511161089599236255D+01
  pw(26)= 0.37039892290540711004993184577181103D+01
  pw(27)= 0.60168669305235587630364842700538762D+01
endif
if(kn == 28) then
  px( 1)= 0.51381795837439443363513212680713947D-03
  px( 2)= 0.27304457410704199858650659828620367D-02
  px( 3)= 0.68160137769119765426643490207146340D-02
  px( 4)= 0.12952008943105054557760398423212956D-01
  px( 5)= 0.21430556623995591107026232001066913D-01
  px( 6)= 0.32693077435416129189765100617149847D-01
  px( 7)= 0.47384339361452651219408943088094832D-01
  px( 8)= 0.66422538658869906464895332297645726D-01
  px( 9)= 0.91083609265701992171879031038032271D-01
  px(10)= 0.12309931515680468843361103443044334D+00
  px(11)= 0.16477454361350713713658223760718724D+00
  px(12)= 0.21913585560877712250760133646822826D+00
  px(13)= 0.29012664768975497883815066595179815D+00
  px(14)= 0.38286487674840579443374001038670456D+00
  px(15)= 0.50398058179729621330814443966676445D+00
  px(16)= 0.66205451410726746024107068348273274D+00
  px(17)= 0.86818664253955900521872813145997494D+00
  px(18)= 0.11367350670636899400604869200366967D+01
  px(19)= 0.14862849200104679887431662518488448D+01
  px(20)= 0.19409402276831122951996033127610769D+01
  px(21)= 0.25320952507423009788362491203678215D+01
  px(22)= 0.33009718613493033820591483341014688D+01
  px(23)= 0.43024948141012255149771188379035923D+01
  px(24)= 0.56117545045133971321428621533897157D+01
  px(25)= 0.73360976078470116280524716610880778D+01
  px(26)= 0.96414187592042593009284671180300365D+01
  px(27)= 0.12823096392169689557014539066503465D+02
  px(28)= 0.17587400071042305461725873529323834D+02
  pw( 1)= 0.13212378315760757100801294124815478D-02
  pw( 2)= 0.31285477801160114283501913408130908D-02
  pw( 3)= 0.50723762615025144279692888527822532D-02
  pw( 4)= 0.72476698125814896247817149986171532D-02
  pw( 5)= 0.97820955598317266921336611328577874D-02
  pw( 6)= 0.12849233584715652412922486858932270D-01
  pw( 7)= 0.16684914458309663575212478712400069D-01
  pw( 8)= 0.21602517467719514930691067702478109D-01
  pw( 9)= 0.28006326728639319667000527469785398D-01
  pw(10)= 0.36406794940307839233444412699072219D-01
  pw(11)= 0.47444873633013210207704765440613480D-01
  pw(12)= 0.61930727493054842346818886062879310D-01
  pw(13)= 0.80898273560459582900261577117872215D-01
  pw(14)= 0.10567594748292560400210313567244803D+00
  pw(15)= 0.13797620661979101239766714101470269D+00
  pw(16)= 0.18000947429659496345933986602370689D+00
  pw(17)= 0.23463186153608726981379368239281040D+00
  pw(18)= 0.30554132794139847744947603213040709D+00
  pw(19)= 0.39754682244155206328794798554812257D+00
  pw(20)= 0.51695511158335980560554454196568031D+00
  pw(21)= 0.67216328370835447637864341433166332D+00
  pw(22)= 0.87464250694849374310652866430377750D+00
  pw(23)= 0.11407332853853718344895028360165344D+01
  pw(24)= 0.14952907674277354153396565164371127D+01
  pw(25)= 0.19800794802566744638917545875047599D+01
  pw(26)= 0.26766284602650483548086237399782999D+01
  pw(27)= 0.37870913379223214170502998382833988D+01
  pw(28)= 0.61141264493435815963177300026057897D+01
endif
if(kn == 29) then
  px( 1)= 0.49553294523216557706121043094899937D-03
  px( 2)= 0.26316733478032430241054271443133571D-02
  px( 3)= 0.65619932921719095950945647167842097D-02
  px( 4)= 0.12447798146998465679635850497317547D-01
  px( 5)= 0.20546725218853503579585565380355127D-01
  px( 6)= 0.31244723477287375693064121565353181D-01
  px( 7)= 0.45100744250336127000529420647899915D-01
  px( 8)= 0.62905104337181109718071876082818174D-01
  px( 9)= 0.85750236217882191338049895922209411D-01
  px(10)= 0.11511276616778913843095284495474961D+00
  px(11)= 0.15294975780371902992191410154541288D+00
  px(12)= 0.20181754709239365590998602589064153D+00
  px(13)= 0.26502522465295890912360438565915637D+00
  px(14)= 0.34683572458174845871862351357320832D+00
  px(15)= 0.45272795494425557401215215391241853D+00
  px(16)= 0.58973560996706034541847942850272405D+00
  px(17)= 0.76688297098562182278932098742313991D+00
  px(18)= 0.99574549679776398032257261690761656D+00
  px(19)= 0.12911746195797983348858102746352939D+01
  px(20)= 0.16722452518287396697078251913438203D+01
  px(21)= 0.21635184617418031866723236843209620D+01
  px(22)= 0.27967767483991669703409180904294707D+01
  px(23)= 0.36135221397956750546277975652240522D+01
  px(24)= 0.46688173594398401975825823496477303D+01
  px(25)= 0.60377360285854709978780788792051344D+01
  px(26)= 0.78274940573494599108741305430804683D+01
  px(27)= 0.10203907613754336363839677845176062D+02
  px(28)= 0.13462852450631673420328416214301979D+02
  px(29)= 0.18313825184349771602172383716912527D+02
  pw( 1)= 0.12740401404642070584625642978316674D-02
  pw( 2)= 0.30131005567070877653374960845857871D-02
  pw( 3)= 0.48740340828768558996439695359657849D-02
  pw( 4)= 0.69399937174499322748248258405693356D-02
  pw( 5)= 0.93214421069590292260830707831625273D-02
  pw( 6)= 0.12166736320428934613437189621950636D-01
  pw( 7)= 0.15675841191975760517355581582896129D-01
  pw( 8)= 0.20113588991116143831392394792507242D-01
  pw( 9)= 0.25821196242227502811986031677074846D-01
  pw(10)= 0.33228090412405890048263783552877789D-01
  pw(11)= 0.42869421776728397919368187941044920D-01
  pw(12)= 0.55414351585478714766063918835679369D-01
  pw(13)= 0.71707159949828379722440698604318357D-01
  pw(14)= 0.92821391683596645191185627202531776D-01
  pw(15)= 0.12012815275736363503642593112420207D+00
  pw(16)= 0.15538195214533728663259981412132171D+00
  pw(17)= 0.20083006704520997993532092391882379D+00
  pw(18)= 0.25935464058941676571399243604292685D+00
  pw(19)= 0.33466206352796625147483719389400201D+00
  pw(20)= 0.43154442816926686793937626854331538D+00
  pw(21)= 0.55625869020489676787739935371459343D+00
  pw(22)= 0.71711352998990444136642620781136560D+00
  pw(23)= 0.92545309501307835297306650109719589D+00
  pw(24)= 0.11974638996261713170731294345952752D+01
  pw(25)= 0.15578539402639460936307650070163272D+01
  pw(26)= 0.20483259849497670771611527406588667D+01
  pw(27)= 0.27506256539950821112799212513803514D+01
  pw(28)= 0.38680317406459942528573299847997115D+01
  pw(29)= 0.62089749987608497692655462325987093D+01
endif
if(kn == 30) then
  px( 1)= 0.47850950616663001797979108558563715D-03
  px( 2)= 0.25398771556977649765987433184628366D-02
  px( 3)= 0.63266767276005636636918971079049107D-02
  px( 4)= 0.11982958698830863481679603697851263D-01
  px( 5)= 0.19737172990592845187334346934200923D-01
  px( 6)= 0.29928809539955562795388150514477224D-01
  px( 7)= 0.43045554614365273736449489448924963D-01
  px( 8)= 0.59772102008795894644542468648119854D-01
  px( 9)= 0.81049794509547598102960610576252333D-01
  px(10)= 0.10814588049834038786751975710018494D+00
  px(11)= 0.14273357759635461536908362003919156D+00
  px(12)= 0.18698857852398412902900671067259807D+00
  px(13)= 0.24371127323293364985980734512310093D+00
  px(14)= 0.31648527240822183351218895583590417D+00
  px(15)= 0.40988303161683259239808922937843934D+00
  px(16)= 0.52973043830387724896707606257507982D+00
  px(17)= 0.68344507067026327204085106743008657D+00
  px(18)= 0.88046769972296521320190133680773247D+00
  px(19)= 0.11328140045719997686900182451437385D+01
  px(20)= 0.14557849987988940136735253178131959D+01
  px(21)= 0.18688939211845819607060281336643708D+01
  px(22)= 0.23971019483057447245002052718973892D+01
  px(23)= 0.30725214791534315669485745292475362D+01
  px(24)= 0.39368810885201871521056281051541589D+01
  px(25)= 0.50453405183264296277555982679398449D+01
  px(26)= 0.64729369863961542161639397127927023D+01
  px(27)= 0.83267646024511909496921957165518850D+01
  px(28)= 0.10772601108679545696397581453580679D+02
  px(29)= 0.14106882472397927743465848536293191D+02
  px(30)= 0.19042377139722396576925840568797290D+02
  pw( 1)= 0.12301166672602858132749403305585138D-02
  pw( 2)= 0.29060349388917145213464128010319648D-02
  pw( 3)= 0.46912396989831005493100286944698875D-02
  pw( 4)= 0.66589658633863613568668981891460303D-02
  pw( 5)= 0.89054272701749525193189873717149483D-02
  pw( 6)= 0.11558310934603853176421212815818196D-01
  pw( 7)= 0.14788296604172157875123267577237353D-01
  pw( 8)= 0.18820536178193913710320280585533146D-01
  pw( 9)= 0.23944736371120032144351948458331453D-01
  pw(10)= 0.30524720054213913983988370110313231D-01
  pw(11)= 0.39011278230203159299747340391501401D-01
  pw(12)= 0.49962838489107032100208706917355628D-01
  pw(13)= 0.64076419786867156599743093793566683D-01
  pw(14)= 0.82229278957901320956487642041730955D-01
  pw(15)= 0.10553162871986467114052832148689872D+00
  pw(16)= 0.13539231869402525697097331669289294D+00
  pw(17)= 0.17360130147051396517985693386136263D+00
  pw(18)= 0.22243486135302704942601690670544171D+00
  pw(19)= 0.28479267765730766074850970825016903D+00
  pw(20)= 0.36438127580923131688892141299329716D+00
  pw(21)= 0.46596902265107476258412993277856600D+00
  pw(22)= 0.59575928418635779724375261556025579D+00
  pw(23)= 0.76197365269330802425420319974692784D+00
  pw(24)= 0.97583770654840390135150485526335360D+00
  pw(25)= 0.12534009762825410047987823857212526D+01
  pw(26)= 0.16192497318165861534514297610388291D+01
  pw(27)= 0.21150559758743170143427430064927639D+01
  pw(28)= 0.28228114202692982120171862876336191D+01
  pw(29)= 0.39469320964297990895048746179623006D+01
  pw(30)= 0.63015479148815916165232775496615043D+01
endif
if(kn == 31) then
  px( 1)= 0.46262124155980990900658158435387435D-03
  px( 2)= 0.24543371823976573134043990222488764D-02
  px( 3)= 0.61080328529962740945375030974273550D-02
  px( 4)= 0.11552913696384311289392080456928671D-01
  px( 5)= 0.18992554406021427042667932899509712D-01
  px( 6)= 0.28727239767175649142836330874634688D-01
  px( 7)= 0.41185025043396586435794925588583817D-01
  px( 8)= 0.56962729337650718045473296117050346D-01
  px( 9)= 0.76876408592321896648696565625767740D-01
  px(10)= 0.10202017613750426995368814592543654D+00
  px(11)= 0.13383358226439616664891093380483172D+00
  px(12)= 0.17418111785696519564699242954723688D+00
  px(13)= 0.22545079288954335283945305080525555D+00
  px(14)= 0.29068039334037578871072959727864135D+00
  px(15)= 0.37372028651206644042103206921271373D+00
  px(16)= 0.47944207171169672906363477630137984D+00
  px(17)= 0.61400401892256187595697112035275391D+00
  px(18)= 0.78518739405456531463788153132800130D+00
  px(19)= 0.10028226298243299869022545200635749D+01
  px(20)= 0.12793315955946422764804637028085576D+01
  px(21)= 0.16304237404723823714635864157191701D+01
  px(22)= 0.20760033968995280036753528016386266D+01
  px(23)= 0.26413808369702250796358745676110842D+01
  px(24)= 0.33589474379157213932868619266312477D+01
  px(25)= 0.42706130083047912404753160217494471D+01
  px(26)= 0.54316014237021642862351869609909389D+01
  px(27)= 0.69169001596879784406900118967237735D+01
  px(28)= 0.88334933035422052410960663437339313D+01
  px(29)= 0.11347158219793510037091924273351551D+02
  px(30)= 0.14754946949122040546764367410101515D+02
  px(31)= 0.19772934489331283651619534072783573D+02
  pw( 1)= 0.11891370745192323541501363233610476D-02
  pw( 2)= 0.28064565117632969596616229162402416D-02
  pw( 3)= 0.45221820039177658202628966334564400D-02
  pw( 4)= 0.64011462699419650278998414745094563D-02
  pw( 5)= 0.85276672843451997393681235521893987D-02
  pw( 6)= 0.11012361472143567538937306026897082D-01
  pw( 7)= 0.14001834101185433452944676115710984D-01
  pw( 8)= 0.17688602970920088694526112750101821D-01
  pw( 9)= 0.22319993264776239711478935025076064D-01
  pw(10)= 0.28206159264133299993412221361362783D-01
  pw(11)= 0.35729779624362463483758438125027756D-01
  pw(12)= 0.45361209930192015109636119041934318D-01
  pw(13)= 0.57681745959882977997939097436077625D-01
  pw(14)= 0.73415730766069123013128503531856238D-01
  pw(15)= 0.93471597750154348901340915093546613D-01
  pw(16)= 0.11899278980540690788248491553604027D+00
  pw(17)= 0.15142094037875549556146133150023155D+00
  pw(18)= 0.19257526453331204560446543583285304D+00
  pw(19)= 0.24475404687248924789069417791551804D+00
  pw(20)= 0.31086721331790994056051025981812504D+00
  pw(21)= 0.39461463811187169999440896691515521D+00
  pw(22)= 0.50073578853625257469356342726971100D+00
  pw(23)= 0.63537831862561035023942323431330555D+00
  pw(24)= 0.80667931860754124288487929852367162D+00
  pw(25)= 0.10257546571965496140352844249415068D+01
  pw(26)= 0.13085329420794059702124934248171024D+01
  pw(27)= 0.16795015057251400866456256943483557D+01
  pw(28)= 0.21803283205051475095028864283497279D+01
  pw(29)= 0.28932755231818831561701787327064654D+01
  pw(30)= 0.40239038808605675586573707403263756D+01
  pw(31)= 0.63919688446180182394784276398611383D+01
endif
if(kn == 32) then
  px( 1)= 0.44775812457284018024389459757135253D-03
  px( 2)= 0.23744300256081390660731331947131448D-02
  px( 3)= 0.59043190530701947087959015074527131D-02
  px( 4)= 0.11153785163059738085602585751236982D-01
  px( 5)= 0.18305065328015338438613004118489460D-01
  px( 6)= 0.27625127970368047372371104083117018D-01
  px( 7)= 0.39491775186977265606198670142306198D-01
  px( 8)= 0.54428213199640073895058009136940445D-01
  px( 9)= 0.73145916598392207837439901430911881D-01
  px(10)= 0.96594842317146387626737019235932073D-01
  px(11)= 0.12602067507135613816122919853447211D+00
  px(12)= 0.16303119243744080803051027229475087D+00
  px(13)= 0.20967680096838206807696535069330795D+00
  px(14)= 0.26855214787001775388966483767701730D+00
  px(15)= 0.34292617657317298468348748407414908D+00
  px(16)= 0.43690813207789007326976756359678361D+00
  px(17)= 0.55565789063347173772943038765658058D+00
  px(18)= 0.70565099753808518503172131364185913D+00
  px(19)= 0.89501204411614229330337167600565325D+00
  px(20)= 0.11339348063954267650829490706793417D+01
  px(21)= 0.14352147947875517113501672147412666D+01
  px(22)= 0.18149314500489324404656062560197686D+01
  px(23)= 0.22933370525154514327968223407435420D+01
  px(24)= 0.28960454333191297694038803298227801D+01
  px(25)= 0.36556826421582258456995650363192002D+01
  px(26)= 0.46143015669042314317688786912840126D+01
  px(27)= 0.58271640488452237241101113536108246D+01
  px(28)= 0.73691994618471152327249495515078891D+01
  px(29)= 0.93472955333283431319402613994267131D+01
  px(30)= 0.11927265101386731589772177284607045D+02
  px(31)= 0.15406825810545224143258580731663182D+02
  px(32)= 0.20505385359315843909738804845728816D+02
  pw( 1)= 0.11508141693310289431516002902194819D-02
  pw( 2)= 0.27135954170378174829279299706770743D-02
  pw( 3)= 0.43653263744209382080072687149869796D-02
  pw( 4)= 0.61636735125379730211346708661816263D-02
  pw( 5)= 0.81829488620066496094938528145972129D-02
  pw( 6)= 0.10519566782024470065554644097490174D-01
  pw( 7)= 0.13300211432891686360240172032295580D-01
  pw( 8)= 0.16690405167066082789755182863245534D-01
  pw( 9)= 0.20902378399561394483383583702025306D-01
  pw(10)= 0.26201993681677797113818409392334214D-01
  pw(11)= 0.32916309597556149563466321558626500D-01
  pw(12)= 0.41444783686249708806280965671571355D-01
  pw(13)= 0.52276724501596285458733044616038927D-01
  pw(14)= 0.66016045915514602434595691235181054D-01
  pw(15)= 0.83413404413409668999356206612085646D-01
  pw(16)= 0.10540610055778962043592758135111163D+00
  pw(17)= 0.13316716078519390466674733202657980D+00
  pw(18)= 0.16816620873421840783275153829642565D+00
  pw(19)= 0.21224605690896243222098764241728942D+00
  pw(20)= 0.26772081279710238967904075331055395D+00
  pw(21)= 0.33750446543867324459731453510204593D+00
  pw(22)= 0.42528477444911122706373139673310844D+00
  pw(23)= 0.53576855465657922120503664249148172D+00
  pw(24)= 0.67504694124786279657121038348068956D+00
  pw(25)= 0.85117601343595945001255999545786031D+00
  pw(26)= 0.10751709034800588277387396074134080D+01
  pw(27)= 0.13628543051087082785935353862196062D+01
  pw(28)= 0.17386349660199069072599128814460612D+01
  pw(29)= 0.22441998697757930470131299950344772D+01
  pw(30)= 0.29621015955004271568195551910771395D+01
  pw(31)= 0.40990494779803030065007758020292907D+01
  pw(32)= 0.64803510743879183341918928981358705D+01
endif
if(kn == 33) then
  px( 1)= 0.43382392840086627333673371770410791D-03
  px( 2)= 0.22996130762133902306219348170634844D-02
  px( 3)= 0.57140311482877757226936621231899489D-02
  px( 4)= 0.10782263460575904849778834680881905D-01
  px( 5)= 0.17668133941325186930637700801463696D-01
  px( 6)= 0.26610114005745400437311454869685139D-01
  px( 7)= 0.37943370827578419250767127256762961D-01
  px( 8)= 0.52129041240975080218154665697626616D-01
  px( 9)= 0.69790754616119288011923380403081974D-01
  px(10)= 0.91757677110053287920628073294896820D-01
  px(11)= 0.11911351898045213836878312985804824D+00
  px(12)= 0.15325258383592569039382713986292282D+00
  px(13)= 0.19594640045311118270956256575773479D+00
  px(14)= 0.24942637714448661140410427601352782D+00
  px(15)= 0.31648861015431273270737411206235176D+00
  px(16)= 0.40062704984338027141229486836727772D+00
  px(17)= 0.50620162303052368324000671362943743D+00
  px(18)= 0.63864913663861731335041615079256755D+00
  px(19)= 0.80474696130540033570426941368276095D+00
  px(20)= 0.10129427268888740212312948144945017D+01
  px(21)= 0.12737679814899102853785194013828910D+01
  px(22)= 0.16003609719649203492661497770183358D+01
  px(23)= 0.20091354103290292174609108669156369D+01
  px(24)= 0.25206522780436439397099624663858851D+01
  px(25)= 0.31607884518783084627961967518655955D+01
  px(26)= 0.39623662204110196024719874486085284D+01
  px(27)= 0.49675495548589556752790709024651368D+01
  px(28)= 0.62316176745314993859698590995521575D+01
  px(29)= 0.78294374119411180631665027515007813D+01
  px(30)= 0.98678149766403120157427026982285647D+01
  px(31)= 0.12512632243648644312040507648114218D+02
  px(32)= 0.16062316312799007384705365546800182D+02
  px(33)= 0.21239626413140571003413447643564263D+02
  pw( 1)= 0.11148970595521907012019732812607055D-02
  pw( 2)= 0.26267851653678976569258782421234610D-02
  pw( 3)= 0.42193631422457547168621098688321193D-02
  pw( 4)= 0.59441470797152969047545135707624789D-02
  pw( 5)= 0.78669738899974671911070000143132306D-02
  pw( 6)= 0.10072359597590157564525137294462730D-01
  pw( 7)= 0.12670399361862170180506056379944600D-01
  pw( 8)= 0.15804160264438711138334353671976234D-01
  pw( 9)= 0.19656646222033544724001127769742948D-01
  pw(10)= 0.24456891716604317647752096255377977D-01
  pw(11)= 0.30486078976025291042502816433302855D-01
  pw(12)= 0.38085942822052281180984432235900915D-01
  pw(13)= 0.47671859587250413816889365465789990D-01
  pw(14)= 0.59751905747580346721160295363733596D-01
  pw(15)= 0.74952101551419066714546625345670463D-01
  pw(16)= 0.94047940645329027189027157260871966D-01
  pw(17)= 0.11800297644299036213439491803576584D+00
  pw(18)= 0.14801615944289654934244517014490498D+00
  pw(19)= 0.18558059212548173745682851099099352D+00
  pw(20)= 0.23255756871893273043599614945440298D+00
  pw(21)= 0.29127163202367449192902938057774536D+00
  pw(22)= 0.36463564879320343679994202632934432D+00
  pw(23)= 0.45632094652154984485718193074718634D+00
  pw(24)= 0.57099911532700834474505095568484057D+00
  pw(25)= 0.71470499479041253227766745277939393D+00
  pw(26)= 0.89541776346343118676696712049315123D+00
  pw(27)= 0.11240606917291058823868093321319567D+01
  pw(28)= 0.14163644716761897658439794410119483D+01
  pw(29)= 0.17966773927205272792519385809395869D+01
  pw(30)= 0.23067252939728463992747791116176630D+01
  pw(31)= 0.30293676082841986853392483236331039D+01
  pw(32)= 0.41724631327442166841549815997399232D+01
  pw(33)= 0.65667986737889171343050053820031099D+01
endif
if(kn == 34) then
  px( 1)= 0.42073412472404638893756652613349609D-03
  px( 2)= 0.22294117501223585040813842121338791D-02
  px( 3)= 0.55358634424631592178894736933123541D-02
  px( 4)= 0.10435505221909818911938312253494801D-01
  px( 5)= 0.17076183522530106340715524871890215D-01
  px( 6)= 0.25671846892716699934599581849440412D-01
  px( 7)= 0.36521262393930458152775347026295878D-01
  px( 8)= 0.50032905506982571537052624490236219D-01
  px( 9)= 0.66756179329851771946428938115562858D-01
  px(10)= 0.87418440517600995276435533200107158D-01
  px(11)= 0.11296720871152482793171861979004167D+00
  px(12)= 0.14461798209060507185491668160548863D+00
  px(13)= 0.18391003445626398421131159916752177D+00
  px(14)= 0.23277438392452600064632190536358711D+00
  px(15)= 0.29361900416298607661742971283165405D+00
  px(16)= 0.36943648509469646191303516064166821D+00
  px(17)= 0.46393948817397095233405427748578045D+00
  px(18)= 0.58173003909628716647282591793935082D+00
  px(19)= 0.72851013492593350843955115700236997D+00
  px(20)= 0.91134335818633179015533214138153748D+00
  px(21)= 0.11389803746065945729570613409749246D+01
  px(22)= 0.14222658613929989350760708533653619D+01
  px(23)= 0.17746516415212834951524711400325322D+01
  px(24)= 0.22128526659161258391280177907354742D+01
  px(25)= 0.27577030475922356628315880749135163D+01
  px(26)= 0.34353067716163467499117583277012187D+01
  px(27)= 0.42786491225875840394307069342936437D+01
  px(28)= 0.53299784436903981664272138662385839D+01
  px(29)= 0.66445753694632339412682622877981687D+01
  px(30)= 0.82972428161435530717136911066799313D+01
  px(31)= 0.10394720964339982803669830220514570D+02
  px(32)= 0.13102991988894450504911092547924425D+02
  px(33)= 0.16721231207604090231249152699717947D+02
  px(34)= 0.21975561953387058269749184334695681D+02
  pw( 1)= 0.10811655766145357018010507192110778D-02
  pw( 2)= 0.25454456692504695230374260776656758D-02
  pw( 3)= 0.40831672721796992810291858236827121D-02
  pw( 4)= 0.57405373464649057612542381878716024D-02
  pw( 5)= 0.75761674957710259616551754950037804D-02
  pw( 6)= 0.96645393330211172110854747921485211D-02
  pw( 7)= 0.12101849132180839391980047456808267D-01
  pw( 8)= 0.15012385166203703798856896165367048D-01
  pw( 9)= 0.18554685664439102794960148200939741D-01
  pw(10)= 0.22926965460919156862511787954586100D-01
  pw(11)= 0.28372234446912034618472293586026471D-01
  pw(12)= 0.35184737546237040728179133891634893D-01
  pw(13)= 0.43719795721391424383284929004984363D-01
  pw(14)= 0.54408450285118084483187831793976080D-01
  pw(15)= 0.67777311678116535143958157494852949D-01
  pw(16)= 0.84473623053475603301350103260219498D-01
  pw(17)= 0.10529589998535694380806537413267952D+00
  pw(18)= 0.13123120457466970233581600829200986D+00
  pw(19)= 0.16350086670529523991639926152378893D+00
  pw(20)= 0.20361729924366521691008806803033027D+00
  pw(21)= 0.25345571161549014721855872141678839D+00
  pw(22)= 0.31534642949457072923890964012293452D+00
  pw(23)= 0.39219690177745437575400107500840528D+00
  pw(24)= 0.48765869057533013816866773942301700D+00
  pw(25)= 0.60636656060951114856441189594293935D+00
  pw(26)= 0.75430007270808930870580918261471173D+00
  pw(27)= 0.93936601064002840188234207354112438D+00
  pw(28)= 0.11724044094922051599035401593357573D+01
  pw(29)= 0.14690667743714044794229623979582298D+01
  pw(30)= 0.18536570456604450828475022635489700D+01
  pw(31)= 0.23679569977291335149484204767547713D+01
  pw(32)= 0.30951463106197815052582135293694448D+01
  pw(33)= 0.42442317841513325464351782732665369D+01
  pw(34)= 0.66514074844570206292427905989816795D+01
endif
if(kn == 35) then
  px( 1)= 0.40841415548604021515920964002399699D-03
  px( 2)= 0.21634090823285078411638264192646176D-02
  px( 3)= 0.53686766256969092483856645653707325D-02
  px( 4)= 0.10111052749147679432588829471203234D-01
  px( 5)= 0.16524448303260385083329478751404387D-01
  px( 6)= 0.24801589512429266354562963867459375D-01
  px( 7)= 0.35209981971294629902224557027954734D-01
  px( 8)= 0.48113158246267914322027983645621137D-01
  px( 9)= 0.63997447579595411241665965285069235D-01
  px(10)= 0.83503921106837065850088749934585509D-01
  px(11)= 0.10746492183189159858451002479100191D+00
  px(12)= 0.13694520147247420040072594436271529D+00
  px(13)= 0.17328916996785784591140856733770825D+00
  px(14)= 0.21817740121438829093802932764502942D+00
  px(15)= 0.27369653832797779961249433698659440D+00
  px(16)= 0.34242699906149186851837117836266744D+00
  px(17)= 0.42755291549796611179923030387067599D+00
  px(18)= 0.53299909554182158428637150014155340D+00
  px(19)= 0.66360070964681593124502281725999578D+00
  px(20)= 0.82531292882837242125696121653082133D+00
  px(21)= 0.10254699397214209538105608220109125D+01
  px(22)= 0.12731058972360937198805843671213415D+01
  px(23)= 0.15793550240911338542780101952325349D+01
  px(24)= 0.19579553515472245197868811537799063D+01
  px(25)= 0.24258926480980508600328748991363509D+01
  px(26)= 0.30042420249956940401285542677229005D+01
  px(27)= 0.37193027838966272865717795755051677D+01
  px(28)= 0.46041945352246751335584778757254638D+01
  px(29)= 0.57012278072022800341169042054436900D+01
  px(30)= 0.70656725104389005421933634969655744D+01
  px(31)= 0.87722686454754899579881428713693370D+01
  px(32)= 0.10927706100825575628425432470397431D+02
  px(33)= 0.13698096354347216687650292593862930D+02
  px(34)= 0.17383397148588794631800252981912492D+02
  px(35)= 0.22713103140185533251728138884147593D+02
  pw( 1)= 0.10494256988526777696106600190246748D-02
  pw( 2)= 0.24690695403322712989700976425347600D-02
  pw( 3)= 0.39557664886781607598248979520245308D-02
  pw( 4)= 0.55511159047852988512979064225320046D-02
  pw( 5)= 0.73075320876513631863948214849392405D-02
  pw( 6)= 0.92909810870320629850049703997767543D-02
  pw( 7)= 0.11585945487945439996692114097667348D-01
  pw( 8)= 0.14300927726198362348901143963929085D-01
  pw( 9)= 0.17573886933485282780152536853558582D-01
  pw(10)= 0.21577101857175674214083208317224449D-01
  pw(11)= 0.26521578525384159056539231969282277D-01
  pw(12)= 0.32662117530178998186687978899517756D-01
  pw(13)= 0.40304760583700356024679394121082348D-01
  pw(14)= 0.49818024406493848323885700890345396D-01
  pw(15)= 0.61648498278387927702353594142316029D-01
  pw(16)= 0.76340842519971003579540175209086024D-01
  pw(17)= 0.94562313841812711417919902804637839D-01
  pw(18)= 0.11713243611448668905011510723033361D+00
  pw(19)= 0.14505903302187588429490257418340878D+00
  pw(20)= 0.17958246056420660249030476513346108D+00
  pw(21)= 0.22223064193925674596660827103307295D+00
  pw(22)= 0.27488866495140173131704069241445894D+00
  pw(23)= 0.33988865913831065785773004058455433D+00
  pw(24)= 0.42012914561889293897263514396102618D+00
  pw(25)= 0.51923942630667304009247143973261919D+00
  pw(26)= 0.64181663147268449329914151912099321D+00
  pw(27)= 0.79378665914719288398623606417929212D+00
  pw(28)= 0.98298862630823929161929765759110274D+00
  pw(29)= 0.12201876100804632086249205242578178D+01
  pw(30)= 0.15209676736777719585360185637783971D+01
  pw(31)= 0.19096027011177832508222236236206329D+01
  pw(32)= 0.24279450923678125311674033890233300D+01
  pw(33)= 0.31595056381881229211813965570928908D+01
  pw(34)= 0.43144357961085612515538420099471387D+01
  pw(35)= 0.67342659787038143488625655899472123D+01
endif
if(kn == 36) then
  px( 1)= 0.39679800273035937692456569764529929D-03
  px( 2)= 0.21012371857514574429814634636370868D-02
  px( 3)= 0.52114717733736355471865173697424917D-02
  px( 4)= 0.98067697534794548776488857189272695D-02
  px( 5)= 0.16008829048610610861085787414831567D-01
  px( 6)= 0.23991913025422802197171963117636148D-01
  px( 7)= 0.33996529414545629919769339896568646D-01
  px( 8)= 0.46347640349961743012995653495638967D-01
  px( 9)= 0.61477688475695067453069318914244194D-01
  px(10)= 0.79954234262530625440149978974196142D-01
  px(11)= 0.10251169364078550312390054066216880D+00
  px(12)= 0.13008697511618887542147079025562156D+00
  px(13)= 0.16385989560749921185926347303565033D+00
  px(14)= 0.20530066324396880599546126878370330D+00
  px(15)= 0.25622775706568656239933185280550197D+00
  px(16)= 0.31887992047473434247218676095668498D+00
  px(17)= 0.39600601270766777602081700578327931D+00
  px(18)= 0.49097660869784478263571961512354166D+00
  px(19)= 0.60792179107232897416464078744063313D+00
  px(20)= 0.75190061348713360022081088193051979D+00
  px(21)= 0.92910925563205451252801298079690580D+00
  px(22)= 0.11471370551908310980346755006364606D+01
  px(23)= 0.14152827011474745738425470935393175D+01
  px(24)= 0.17449475260933662620173991491940897D+01
  px(25)= 0.21501302020535220058465237512287759D+01
  px(26)= 0.26480593984665582591226977578025315D+01
  px(27)= 0.32600222787200297912657865580064671D+01
  px(28)= 0.40124854077257132134482639353308378D+01
  px(29)= 0.49386780680939238173283121803851184D+01
  px(30)= 0.60809546519546778854776584514884910D+01
  px(31)= 0.74945653594942201002132544001003708D+01
  px(32)= 0.92541900969385753944715137178141946D+01
  px(33)= 0.11466484149563363201326491294746713D+02
  px(34)= 0.14297715117728357842590639672319382D+02
  px(35)= 0.18048653298710078396919876650411551D+02
  px(36)= 0.23452167308415151157069277254133065D+02
  pw( 1)= 0.10195057714700151361278566695804673D-02
  pw( 2)= 0.23972109360881477362914694357034945D-02
  pw( 3)= 0.38363158447342177123425836110343923D-02
  pw( 4)= 0.53744010839767438647013296257593752D-02
  pw( 5)= 0.70585351522933460613686733697482296D-02
  pw( 6)= 0.89474146486528988019752703037120466D-02
  pw( 7)= 0.11115594177177423398237576162176609D-01
  pw( 8)= 0.13658239363054657454269471936854599D-01
  pw( 9)= 0.16695920500566358906782047930663171D-01
  pw(10)= 0.20378981713905551927970998274789754D-01
  pw(11)= 0.24891420496520210335919294073059272D-01
  pw(12)= 0.30454995468399097263969267647541847D-01
  pw(13)= 0.37334924544188163864246559109559135D-01
  pw(14)= 0.45848499525488242728225859778156080D-01
  pw(15)= 0.56377323577091624057815057252308315D-01
  pw(16)= 0.69383296835632602012769529156119272D-01
  pw(17)= 0.85428366438632838815674340562473751D-01
  pw(18)= 0.10519836473842813187954075539197942D+00
  pw(19)= 0.12953172788969281249628541902884322D+00
  pw(20)= 0.15945437502320699870857044488189859D+00
  pw(21)= 0.19622256830996434214924230362068723D+00
  pw(22)= 0.24137631349243177937384183525770442D+00
  pw(23)= 0.29680703930305420431908018221051720D+00
  pw(24)= 0.36484530976842630509122266207581834D+00
  pw(25)= 0.44837789623740881716704249442275046D+00
  pw(26)= 0.55101005426642996452229825498001978D+00
  pw(27)= 0.67730110868383751051906031936646973D+00
  pw(28)= 0.83312535104283525888024444527691004D+00
  pw(29)= 0.10262590489160128936079715697075387D+01
  pw(30)= 0.12674001847129782122095271537034034D+01
  pw(31)= 0.15720761022006313395632370048802129D+01
  pw(32)= 0.19645432933987013230055443656345311D+01
  pw(33)= 0.24867374093856289898664232230940440D+01
  pw(34)= 0.32225090907915900251361180974071379D+01
  pw(35)= 0.43831496004036045715808964702697293D+01
  pw(36)= 0.68154560080748566632769223367688120D+01
endif
if(kn == 37) then
  px( 1)= 0.38582699810911109314412610582600285D-03
  px( 2)= 0.20425701942290192876130910611009103D-02
  px( 3)= 0.50633691210660737148684629408797998D-02
  px( 4)= 0.95207896708291718422773083291578438D-02
  px( 5)= 0.15525778682735758953134513377993514D-01
  px( 6)= 0.23236458251477143892762148491421503D-01
  px( 7)= 0.32869898315502381365977793756399700D-01
  px( 8)= 0.44717783821182009237592740999277480D-01
  px( 9)= 0.59166282378413474386219652173387790D-01
  px(10)= 0.76720016407611302507577044991006663D-01
  px(11)= 0.98029725568599136751267367485311366D-01
  px(12)= 0.12392331356464118155739304688774820D+00
  px(13)= 0.15544072437387706131982741857227680D+00
  px(14)= 0.19387425549171156055801006554376491D+00
  px(15)= 0.24081693190720646255336253748180444D+00
  px(16)= 0.29822205905402883495704063798959865D+00
  px(17)= 0.36847715057286422135924881742734873D+00
  px(18)= 0.45449546602004465241771763312107545D+00
  px(19)= 0.55982869948207391699702170763669914D+00
  px(20)= 0.68880504649787296744511192196333508D+00
  px(21)= 0.84669796033901533360995646038438838D+00
  px(22)= 0.10399324356558473561934598413040205D+01
  px(23)= 0.12763377882779834661586906782407420D+01
  px(24)= 0.15654589805265212137286807835074586D+01
  px(25)= 0.19189432205583964070987477122905362D+01
  px(26)= 0.23510260307961591423359389441199440D+01
  px(27)= 0.28791534439182687258499291870153821D+01
  px(28)= 0.35247986674670581588018777649051460D+01
  px(29)= 0.43145708343894232186639323097990119D+01
  px(30)= 0.52817877652195029549414854087069499D+01
  px(31)= 0.64688326916686594614365796118970700D+01
  px(32)= 0.79309297085796581254349823893132444D+01
  px(33)= 0.97427028243618144296296506331896705D+01
  px(34)= 0.12010788145502681400420281251059076D+02
  px(35)= 0.14901634128904268951043131468444574D+02
  px(36)= 0.18716850108988162034804184337830585D+02
  px(37)= 0.24192677368936148334878341907713337D+02
  pw( 1)= 0.99125336551824862194889482679760082D-03
  pw( 2)= 0.23294764153889055024996601218914981D-02
  pw( 3)= 0.37240772547834537676742266421935443D-02
  pw( 4)= 0.52091149342528848273366607113774535D-02
  pw( 5)= 0.68270221227859789716885624541247654D-02
  pw( 6)= 0.86302549871569688435939302492406456D-02
  pw( 7)= 0.10684907929606001826647765915296935D-01
  pw( 8)= 0.13074823650284587459124044679067858D-01
  pw( 9)= 0.15905815137012769943635728692865399D-01
  pw(10)= 0.19309592949421631021202995586098476D-01
  pw(11)= 0.23447231955796843102356124526512731D-01
  pw(12)= 0.28512602643555882480364043596258204D-01
  pw(13)= 0.34736803269082359319855891282489532D-01
  pw(14)= 0.42394778196431500823106022890118590D-01
  pw(15)= 0.51814900990726921245206073768999637D-01
  pw(16)= 0.63391754887352977638748380428399567D-01
  pw(17)= 0.77602103176771937423249866012581660D-01
  pw(18)= 0.95024188094564273453247510650970162D-01
  pw(19)= 0.11636084820208068310423973571076075D+00
  pw(20)= 0.14246733764500807361275561785541076D+00
  pw(21)= 0.17438513757282787980358846897741684D+00
  pw(22)= 0.21338354906834882772151573726954513D+00
  pw(23)= 0.26101159566291693588807442987832548D+00
  pw(24)= 0.31916397294414160306456288368801219D+00
  pw(25)= 0.39016685675452558044568607656388734D+00
  pw(26)= 0.47689304458379631259135969323199221D+00
  pw(27)= 0.58292255373275454371013059783773154D+00
  pw(28)= 0.71277724055369180393369777699867214D+00
  pw(29)= 0.87228215826925362283182363826585130D+00
  pw(30)= 0.10691555317433509592820312414251932D+01
  pw(31)= 0.13140356602358313756291999585335256D+01
  pw(32)= 0.16224029261605229346735838359067505D+01
  pw(33)= 0.20185076394260072518838683149008566D+01
  pw(34)= 0.25443795429863924820797324346795088D+01
  pw(35)= 0.32842160798477830990525297742207531D+01
  pw(36)= 0.44504422639266402367212097908451198D+01
  pw(37)= 0.68950534584189288110300715731079937D+01
endif
if(kn == 38) then
  px( 1)= 0.37544882641214739544404487691314902D-03
  px( 2)= 0.19871183957226785505693683210337852D-02
  px( 3)= 0.49235906141676391015802154321946533D-02
  px( 4)= 0.92514737512580193448510992395727495D-02
  px( 5)= 0.15072210889929832914852564552062275D-01
  px( 6)= 0.22529747565558688599709359818783270D-01
  px( 7)= 0.31820706479818463453808764992549706D-01
  px( 8)= 0.43207917804566229579979815937989733D-01
  px( 9)= 0.57037614703055219788340245932475170D-01
  px(10)= 0.73760278305643433875885418326364923D-01
  px(11)= 0.93954814072806105125535625384970094D-01
  px(12)= 0.11835572279751275812340426098616966D+00
  px(13)= 0.14788342387597970850254556771271985D+00
  px(14)= 0.18367881184867197784381084444678116D+00
  px(15)= 0.22714406717510235393336995794234796D+00
  px(16)= 0.27999230770730436478836636945630613D+00
  px(17)= 0.34430881911279975709736095638802572D+00
  px(18)= 0.42262660561797928237112864643574725D+00
  px(19)= 0.51801914793576724661446993655612171D+00
  px(20)= 0.63421369082081852676499438226656058D+00
  px(21)= 0.77572913890901541203968257694714068D+00
  px(22)= 0.94804373045176433040869132064288662D+00
  px(23)= 0.11577991608735723735204737419458983D+01
  px(24)= 0.14130499332620481162978195094240590D+01
  px(25)= 0.17235697910838497297077019443263907D+01
  px(26)= 0.21012318099421305470189826928381899D+01
  px(27)= 0.25604863031155004117350909468147106D+01
  px(28)= 0.31189733700354116534218512680792939D+01
  px(29)= 0.37983289491193925871766329237375059D+01
  px(30)= 0.46252830528399268638347963582117115D+01
  px(31)= 0.56332239825265713634766419255858690D+01
  px(32)= 0.68645515916046830561016745830456758D+01
  px(33)= 0.83744595975704688906750898197385297D+01
  px(34)= 0.10237521325244942798063968606118549D+02
  px(35)= 0.12560368707162995423911721031640974D+02
  px(36)= 0.15509653816608570103011114649053437D+02
  px(37)= 0.19387848243793684608247770401886161D+02
  px(38)= 0.24934561281635323945874914765928781D+02
  pw( 1)= 0.96453265301318427548094362468201990D-03
  pw( 2)= 0.22655173902979609807058505788853476D-02
  pw( 3)= 0.36184028900176044156504296271444603D-02
  pw( 4)= 0.50541489537150279336470105887486457D-02
  pw( 5)= 0.66111480676528721493086153967962652D-02
  pw( 6)= 0.83364709970141383682744167961798317D-02
  pw( 7)= 0.10288965239682486008404941690219778D-01
  pw( 8)= 0.12542814650103402794331337460320134D-01
  pw( 9)= 0.15191255363614986206935175799741358D-01
  pw(10)= 0.18350103409130288787013350611437802D-01
  pw(11)= 0.22160882105318682870151221782836377D-01
  pw(12)= 0.26793767627663720473790893510507021D-01
  pw(13)= 0.32451109787899399883524910095936794D-01
  pw(14)= 0.39372541954009629417292538828294592D-01
  pw(15)= 0.47842474290684012119499234323721647D-01
  pw(16)= 0.58200301955035707564120883548436910D-01
  pw(17)= 0.70853350044334604149559560301899009D-01
  pw(18)= 0.86292591208817884216614254072269241D-01
  pw(19)= 0.10511141477535783724613732416344133D+00
  pw(20)= 0.12802804286358628862797652201096219D+00
  pw(21)= 0.15591251149396720172437659323068423D+00
  pw(22)= 0.18981949259837187914390190669151597D+00
  pw(23)= 0.23102871661757404151219056182072738D+00
  pw(24)= 0.28109550616216987958688311291596089D+00
  pw(25)= 0.34191517456611856887400710976438959D+00
  pw(26)= 0.41580717321823436217712748531850542D+00
  pw(27)= 0.50562861773538920954280122211069833D+00
  pw(28)= 0.61493358954575527626904288123143367D+00
  pw(29)= 0.74820721198453838888752387245859917D+00
  pw(30)= 0.91122787666637256187790465660240598D+00
  pw(31)= 0.11116604876702928314541969577850448D+01
  pw(32)= 0.13600906035248579424433723117814169D+01
  pw(33)= 0.16719605033700192144793651594580592D+01
  pw(34)= 0.20715242290059813187830495943964160D+01
  pw(35)= 0.26009149126553161918961209793496358D+01
  pw(36)= 0.33446822473746498943306001989892373D+01
  pw(37)= 0.45163779904182883931050846768355054D+01
  pw(38)= 0.69731288252045659086112524629580346D+01
endif
if(kn == 39) then
  px( 1)= 0.36561668715257863266695867839020084D-03
  px( 2)= 0.19346233268023844607752680140092771D-02
  px( 3)= 0.47914454654721250429608171020940566D-02
  px( 4)= 0.89973768150331118636464557997751850D-02
  px( 5)= 0.14645426459456932116061991386768235D-01
  px( 6)= 0.21867035291160181873696376563265340D-01
  px( 7)= 0.30840905275941465760959181463130484D-01
  px( 8)= 0.41804727278858172089611260923812570D-01
  px( 9)= 0.55070109596011254633584203260158210D-01
  px(10)= 0.71040748192925559559810356000599258D-01
  px(11)= 0.90233607305000360208735980487986444D-01
  px(12)= 0.11330278644013276387294932973826412D+00
  px(13)= 0.14106605202734226946949558771740988D+00
  px(14)= 0.17453471922456742887333856505611605D+00
  px(15)= 0.21494840120203884103453089817606487D+00
  px(16)= 0.26381673974086082406623827494703215D+00
  px(17)= 0.32297045833724193805138734154727157D+00
  px(18)= 0.39462409178162717260419023658129017D+00
  px(19)= 0.48145279757007806226628785793904093D+00
  px(20)= 0.58668591241992432419881469135301121D+00
  px(21)= 0.71422043441619441875490470925759117D+00
  px(22)= 0.86875839397007365611188934469437619D+00
  px(23)= 0.10559731561016268223241013124184012D+01
  px(24)= 0.12827111749931695832113875967148563D+01
  px(25)= 0.15572378120557119987867239447717751D+01
  px(26)= 0.18895389181496921659373840308737441D+01
  px(27)= 0.22916946565666188923157402572614733D+01
  px(28)= 0.27783497396142931899333530655336223D+01
  px(29)= 0.33673171344416414054075236409384439D+01
  px(30)= 0.40803746579421435360342926127423516D+01
  px(31)= 0.49443541982197303363350679681860647D+01
  px(32)= 0.59926991656565097356612507658187921D+01
  px(33)= 0.72678162022521051390335450639073869D+01
  px(34)= 0.88248661080276432761936204880867089D+01
  px(35)= 0.10738377470289614240120984197486960D+02
  px(36)= 0.13114992524642316318648160324994074D+02
  px(37)= 0.16121587864037157860973324745148775D+02
  px(38)= 0.20061517632007615495343028194490514D+02
  px(39)= 0.25677751590102375173572742100364982D+02
  pw( 1)= 0.93922220165197278758235278705125378D-03
  pw( 2)= 0.22050238560788499833482429614154492D-02
  pw( 3)= 0.35187216063020038804486790499409390D-02
  pw( 4)= 0.49085365506617880092326144941967522D-02
  pw( 5)= 0.64093236535073721253961413565734053D-02
  pw( 6)= 0.80634829478885867255854065621590218D-02
  pw( 7)= 0.99236234747694546900134742610818704D-02
  pw( 8)= 0.12055651790884970603397688654161516D-01
  pw( 9)= 0.14542041549622581450180752510105879D-01
  pw(10)= 0.17484998327571243644029476510788471D-01
  pw(11)= 0.21009295862219636601744654763649681D-01
  pw(12)= 0.25264862509860073296774992740630911D-01
  pw(13)= 0.30429647240913452161840939756263150D-01
  pw(14)= 0.36713599504420717007290949145895236D-01
  pw(15)= 0.44364526109307181291869691370038599D-01
  pw(16)= 0.53676231693459070390920038412533532D-01
  pw(17)= 0.64999020675906355562370375168522980D-01
  pw(18)= 0.78752553989958863994856994484156486D-01
  pw(19)= 0.95441198327713183692637121288756175D-01
  pw(20)= 0.11567225339206538896170499893449828D+00
  pw(21)= 0.14017770592600709076251201422928256D+00
  pw(22)= 0.16984043156916862434884153031547730D+00
  pw(23)= 0.20572609864904223612685592628540649D+00
  pw(24)= 0.24912251113833289072621517399741476D+00
  pw(25)= 0.30158889670929686638710684005186011D+00
  pw(26)= 0.36501892348491283180440889799004221D+00
  pw(27)= 0.44172341189659552954879007161166844D+00
  pw(28)= 0.53454253015480261760607954897116394D+00
  pw(29)= 0.64700413373280623862585575306735597D+00
  pw(30)= 0.78355765539183802574608463599148275D+00
  pw(31)= 0.94993752822514424638014213628449162D+00
  pw(32)= 0.11537599191614455897031555123375337D+01
  pw(33)= 0.14055641164435818777056131176331966D+01
  pw(34)= 0.17207623206557334615184702866032957D+01
  pw(35)= 0.21236210670677286367475649834301224D+01
  pw(36)= 0.26563848390712257212223490954097065D+01
  pw(37)= 0.34039597582687380169009802962894561D+01
  pw(38)= 0.45810165654673262153491823163228067D+01
  pw(39)= 0.70497477205153040846297597338553262D+01
endif
if(kn == 40) then
  px( 1)= 0.35628858567646346686837324510549370D-03
  px( 2)= 0.18848536486770311807591243848705546D-02
  px( 3)= 0.46663181280317856746168443158323968D-02
  px( 4)= 0.87572190745324032833162010260613025D-02
  px( 5)= 0.14243053462025729117427416370397854D-01
  px( 6)= 0.21244187714177671012923575144774521D-01
  px( 7)= 0.29923549070178329860704059006245261D-01
  px( 8)= 0.40496827285887221934804797848083118D-01
  px( 9)= 0.53245474481585595162008164942410512D-01
  px(10)= 0.68532582430157398594384714629729053D-01
  px(11)= 0.86821479567961854490494392488927025D-01
  px(12)= 0.10869675959524067911380119096839804D+00
  px(13)= 0.13488761722649275069059959653024014D+00
  px(14)= 0.16629388885455273807852247897310019D+00
  px(15)= 0.20401590432120076472183920609098846D+00
  px(16)= 0.24938984749465339706889280753165521D+00
  px(17)= 0.30403061355446670063478194165459695D+00
  px(18)= 0.36988419909316149270323787724602738D+00
  px(19)= 0.44929166750312582192671647579960907D+00
  px(20)= 0.54506686870623140996608099899850594D+00
  px(21)= 0.66059043398617261201896956069992349D+00
  px(22)= 0.79992312516554243682533149390065526D+00
  px(23)= 0.96794240207734869040410161024196399D+00
  px(24)= 0.11705071340447720718704866053067197D+01
  px(25)= 0.14146568411163837104501550620112388D+01
  px(26)= 0.17088539364613371655586392377700409D+01
  px(27)= 0.20632805527205428543659205472373927D+01
  px(28)= 0.24902063739619416723013658330633921D+01
  px(29)= 0.30044517126674338175114949672570867D+01
  px(30)= 0.36239831566943951780098581431720407D+01
  px(31)= 0.43707017882279510268089904263627705D+01
  px(32)= 0.52715247584257797079839546521646347D+01
  px(33)= 0.63599375545114314246728093354610643D+01
  px(34)= 0.76783457965158492083638000098773087D+01
  px(35)= 0.92818762327705176821137326934557272D+01
  px(36)= 0.11245019162985129683252871377987811D+02
  px(37)= 0.13674441002824139783929760948169562D+02
  px(38)= 0.16737262031081031207287624813172862D+02
  px(39)= 0.20737736626704553460329127303821744D+02
  px(40)= 0.26422185009410264431343933932848600D+02
  pw( 1)= 0.91521311273862401110414707754929676D-03
  pw( 2)= 0.21477191521928219197974773759587103D-02
  pw( 3)= 0.34245277733745781136392870149979323D-02
  pw( 4)= 0.47714307428687057651870425259278087D-02
  pw( 5)= 0.62201720373839252470536835470530964D-02
  pw( 6)= 0.78090816762799270025355432702422127D-02
  pw( 7)= 0.95853728776285881753692296587104674D-02
  pw( 8)= 0.11607827206228475028893871423142139D-01
  pw( 9)= 0.13949671718334027814092300225470600D-01
  pw(10)= 0.16701414648594482319533882783791014D-01
  pw(11)= 0.19973423842092704666661066907283955D-01
  pw(12)= 0.23898237345016617036372142753573396D-01
  pw(13)= 0.28632957303620028137537791558953675D-01
  pw(14)= 0.34362389756581172586707762233025920D-01
  pw(15)= 0.41303629060426009015015262453667296D-01
  pw(16)= 0.49712538117407657728121783442595623D-01
  pw(17)= 0.59892265779927519547458491064456622D-01
  pw(18)= 0.72203793116717427042782050909270304D-01
  pw(19)= 0.87078559354632307141427375007562753D-01
  pw(20)= 0.10503340154082661838457995134010675D+00
  pw(21)= 0.12668825810872029062869005987170137D+00
  pw(22)= 0.15278730399841792433216511718627756D+00
  pw(23)= 0.18422442714170367120354764302353497D+00
  pw(24)= 0.22207427969059917966672557751489214D+00
  pw(25)= 0.26763062752730913486480650477422812D+00
  pw(26)= 0.32245451049240744596849032983153986D+00
  pw(27)= 0.38843603675318055142995014015287773D+00
  pw(28)= 0.46787586661529213993652263387714350D+00
  pw(29)= 0.56359633220992492533897924842606201D+00
  pw(30)= 0.67909910572915995345517074647986275D+00
  pw(31)= 0.81879920277693732798543935642566763D+00
  pw(32)= 0.98838986255598396167621024931216632D+00
  pw(33)= 0.11954429228293928218210248618287692D+01
  pw(34)= 0.14504574076282353803601676013439121D+01
  pw(35)= 0.17688226967485673903033088821262440D+01
  pw(36)= 0.21748255570140773474399755838047824D+01
  pw(37)= 0.27108286283847583355764140776741630D+01
  pw(38)= 0.34620975677969687591016085409314313D+01
  pw(39)= 0.46444137521824838114376662229079725D+01
  pw(40)= 0.71249713212825268738104553603659849D+01
endif
if(kn == 41) then
  px( 1)= 0.34742673101001169298125786189192247D-03
  px( 2)= 0.18376016626066348589572611512977315D-02
  px( 3)= 0.45476582212664459469467031011454626D-02
  px( 4)= 0.85298627941631364768947297314276555D-02
  px( 5)= 0.13862998302969016172574004035541326D-01
  px( 6)= 0.20657586094570613395846290407493021D-01
  px( 7)= 0.29062610848297752288163047809306784D-01
  px( 8)= 0.39274425358723378021088136325757383D-01
  px( 9)= 0.51548104852787877566528890250659503D-01
  px(10)= 0.66211354354233299700140534259286291D-01
  px(11)= 0.83680871232624778086967339679729237D-01
  px(12)= 0.10448092042565902676173295142297193D+00
  px(13)= 0.12926394759018944327153762885108248D+00
  px(14)= 0.15883342588000497563552833153551216D+00
  px(15)= 0.19416971506631978910646170849840836D+00
  px(16)= 0.23646026989593002896655227863024343D+00
  px(17)= 0.28713586785719640965554266593644607D+00
  px(18)= 0.34791462052391896376462581083932962D+00
  px(19)= 0.42085552853141849349998238918417102D+00
  px(20)= 0.50842339932407666570140739641291868D+00
  px(21)= 0.61356716058210435249023757196485689D+00
  px(22)= 0.73981399451706291428067431492187345D+00
  px(23)= 0.89138229125166542251073985530751701D+00
  px(24)= 0.10733171950376849976883148880289368D+01
  px(25)= 0.12916535619608503598632452641060769D+01
  px(26)= 0.15536125962495445292827177181517718D+01
  px(27)= 0.18678405221272713224762723085314113D+01
  px(28)= 0.22447007897223064544921318025044505D+01
  px(29)= 0.26966362208010185020303083586792707D+01
  px(30)= 0.32386254398637317225899745563640301D+01
  px(31)= 0.38887712166747737454815122744695001D+01
  px(32)= 0.46690813167550880509031095796259491D+01
  px(33)= 0.56065436673995350526181894949125319D+01
  px(34)= 0.67346748355004755553478375342343373D+01
  px(35)= 0.80958733206377174584850755308484861D+01
  px(36)= 0.97452318197102039374768068435419398D+01
  px(37)= 0.11757209117436549173752389088784801D+02
  px(38)= 0.14238509041698890616269777375250039D+02
  px(39)= 0.17356513104267573046562740943972043D+02
  px(40)= 0.21416391258741087275776630427364534D+02
  px(41)= 0.27167802059826190961056594217938860D+02
  pw( 1)= 0.89240744144922233411809208993761819D-03
  pw( 2)= 0.20933555605342582529457970383304286D-02
  pw( 3)= 0.33353720205083480430061442115773668D-02
  pw( 4)= 0.46420859644861606778799308270413399D-02
  pw( 5)= 0.60424942046045364422720752662654441D-02
  pw( 6)= 0.75713643924191847990582966217707736D-02
  pw( 7)= 0.92712216138022670728066109402065568D-02
  pw( 8)= 0.11194687905391631640874958915231129D-01
  pw( 9)= 0.13407015211365284658909716719520612D-01
  pw(10)= 0.15988623214362774067334406180515621D-01
  pw(11)= 0.19037444847571012625771486857897508D-01
  pw(12)= 0.22671015569010270758765332286863717D-01
  pw(13)= 0.27028523256092179219838374149240132D-01
  pw(14)= 0.32273327230549150524506142920429224D-01
  pw(15)= 0.38596560710149393493004578367090095D-01
  pw(16)= 0.46222282500302385970118307137327059D-01
  pw(17)= 0.55414377032731402665476377100171599D-01
  pw(18)= 0.66485217878875067216476264141658569D-01
  pw(19)= 0.79806099857296581997108727302834078D-01
  pw(20)= 0.95819567831341990475832520086841170D-01
  pw(21)= 0.11505394471321825395206987370902480D+00
  pw(22)= 0.13814054039338535506658629671808687D+00
  pw(23)= 0.16583420916823077593541262981490681D+00
  pw(24)= 0.19903814998014368860888042911909173D+00
  pw(25)= 0.23883416675372027779180574899396133D+00
  pw(26)= 0.28652010702264135124796999487042423D+00
  pw(27)= 0.34365700663826115610743525613053815D+00
  pw(28)= 0.41212981100557300459399743393003457D+00
  pw(29)= 0.49422782047790986141383860345034700D+00
  pw(30)= 0.59275496121528084438932784828140258D+00
  pw(31)= 0.71118703347840582157967515903715531D+00
  pw(32)= 0.85390607737164494406520343373727721D+00
  pw(33)= 0.10265669138579149759586965414767668D+01
  pw(34)= 0.12367012590999922651850699786000809D+01
  pw(35)= 0.14947734294405908884100490275594732D+01
  pw(36)= 0.18161565391675246807943861856738552D+01
  pw(37)= 0.22251644165626364386518263812767700D+01
  pw(38)= 0.27642836611922099334373971118073338D+01
  pw(39)= 0.35191416662378097344643779658011469D+01
  pw(40)= 0.47066216438742057965343731115092608D+01
  pw(41)= 0.71988567667853812451766331822159390D+01
endif
if(kn == 42) then
  px( 1)= 0.33899702213207280303556565703741990D-03
  px( 2)= 0.17926803514586918122543179233298713D-02
  px( 3)= 0.44349720472477033588788261295928634D-02
  px( 4)= 0.83142928381370954944600712429031326D-02
  px( 5)= 0.13503405398912139202218387144909328D-01
  px( 6)= 0.20104047687222803992574530787065418D-01
  px( 7)= 0.28252833643724993821423023769509983D-01
  px( 8)= 0.38129051839561461833536104861505433D-01
  px( 9)= 0.49964611823304399745794720191846551D-01
  px(10)= 0.64056255466771758626847757441909748D-01
  px(11)= 0.80779982442382913230902383270370264D-01
  px(12)= 0.10060749467110151157610640414769097D+00
  px(13)= 0.12412446888143911749100232205634547D+00
  px(14)= 0.15205071694865663047292718989423185D+00
  px(15)= 0.18526275842687218439176583557408384D+00
  px(16)= 0.22481983515906206676758114216568014D+00
  px(17)= 0.27199475262711723613680204884879081D+00
  px(18)= 0.32831107191481630404052581830045252D+00
  px(19)= 0.39558818386929789909718409480658300D+00
  px(20)= 0.47599581233231530250697095670252798D+00
  px(21)= 0.57211961616026616366050109797592391D+00
  px(22)= 0.68703982771101430011400322499023268D+00
  px(23)= 0.82442528240215569955771735381318182D+00
  px(24)= 0.98864576667159865631116805089235696D+00
  px(25)= 0.11849063745873302190560203655789150D+01
  px(26)= 0.14194085949505718343903162487063753D+01
  px(27)= 0.16995442942632463982698312503343140D+01
  px(28)= 0.20341308620656637127889186046327503D+01
  px(29)= 0.24336989628881715953740329050451161D+01
  px(30)= 0.29108493179186889815360617341447733D+01
  px(31)= 0.34807029996457758665062194913386789D+01
  px(32)= 0.41614831892896507985708808145127823D+01
  px(33)= 0.49752895914290239340663575251573810D+01
  px(34)= 0.59491683086745559122027634515663744D+01
  px(35)= 0.71166577579837023101788394059159047D+01
  px(36)= 0.85201446660709564225208283238116453D+01
  px(37)= 0.10214688587324610607847909840137625D+02
  px(38)= 0.12274723743508615874901666750507663D+02
  px(39)= 0.14807003938009410302904866873102566D+02
  px(40)= 0.17979187958243548948159702687043315D+02
  px(41)= 0.22097374571880291313408725390611447D+02
  px(42)= 0.27914546740390271130933515005738687D+02
  pw( 1)= 0.87071685062486345289172157206777171D-03
  pw( 2)= 0.20417105878963868357298871515770460D-02
  pw( 3)= 0.32508535230574150323908782582998050D-02
  pw( 4)= 0.45198431212516341141392418533095799D-02
  pw( 5)= 0.58752408889593859079959250826252330D-02
  pw( 6)= 0.73486832934924937540882060804195150D-02
  pw( 7)= 0.89786045784956752332612520710862566D-02
  pw( 8)= 0.10812279756759579335639253148771645D-01
  pw( 9)= 0.12908056239717444457676015564846892D-01
  pw(10)= 0.15337623022218768136530241218842739D-01
  pw(11)= 0.18188143417513304840817866168341234D-01
  pw(12)= 0.21564159053085002516938026776853287D-01
  pw(13)= 0.25589384327944258948303670138994570D-01
  pw(14)= 0.30408768217117848936156421895538494D-01
  pw(15)= 0.36191344708155839281431088511826248D-01
  pw(16)= 0.43134326776658801296020544503200249D-01
  pw(17)= 0.51468687405796338041097105695766697D-01
  pw(18)= 0.61466278505771427877600196882159870D-01
  pw(19)= 0.73448477231342626126309188685807545D-01
  pw(20)= 0.87796417742468560052699023987407758D-01
  pw(21)= 0.10496300171125714320281462758628502D+00
  pw(22)= 0.12548703017795381911118827176515123D+00
  pw(23)= 0.15000994875313221416387070158771740D+00
  pw(24)= 0.17929586510892162331076812701124762D+00
  pw(25)= 0.21425571841544983392913772225490756D+00
  pw(26)= 0.25597680754299265400920520155620068D+00
  pw(27)= 0.30575939808892163354965075699382712D+00
  pw(28)= 0.36516295819168300959340602426394554D+00
  pw(29)= 0.43606594548816172375527529406447798D+00
  pw(30)= 0.52074538635856855968547701789163874D+00
  pw(31)= 0.62198649880275266624161896479324475D+00
  pw(32)= 0.74323973657036909817079545894769618D+00
  pw(33)= 0.88885572273739267168333040860537136D+00
  pw(34)= 0.10644536078580082753759483481056876D+01
  pw(35)= 0.12775289785980491630656102334631630D+01
  pw(36)= 0.15385165702010908217004674883905600D+01
  pw(37)= 0.18627791456676687262611182457669180D+01
  pw(38)= 0.22746636192228746631618234661193503D+01
  pw(39)= 0.28167854835143406837432208820997977D+01
  pw(40)= 0.35751353025579259567249078677450433D+01
  pw(41)= 0.47676889791677097956471776553934610D+01
  pw(42)= 0.72714575121908501417344894592801099D+01
endif
if(kn == 43) then
  px( 1)= 0.33096860786757750154898847120917057D-03
  px( 2)= 0.17499208566123461094898550046151874D-02
  px( 3)= 0.43278154096847331355188904178071447D-02
  px( 4)= 0.81096003646317825364067625754120221D-02
  px( 5)= 0.13162623744349233672062735003036974D-01
  px( 6)= 0.19580760979979784765554480104376286D-01
  px( 7)= 0.27489609951663532195103068673087354D-01
  px( 8)= 0.37053342869799653592283933396820960D-01
  px( 9)= 0.48483444452707627033448163720522761D-01
  px(10)= 0.62049459953072389488156028383179189D-01
  px(11)= 0.78091737934971368286739663026054961D-01
  px(12)= 0.97036017163386886705197231591959380D-01
  px(13)= 0.11940967168918372175774848212559756D+00
  px(14)= 0.14585958712300992040134315459436264D+00
  px(15)= 0.17717200022543900754299287107723618D+00
  px(16)= 0.21429507577429224752942159606670995D+00
  px(17)= 0.25836535107930525415060613221934697D+00
  px(18)= 0.31073935543877479582966549813156744D+00
  px(19)= 0.37303174367650550564362643090028699D+00
  px(20)= 0.44716127946900452807387231860775343D+00
  px(21)= 0.53540606537110705599704958284246183D+00
  px(22)= 0.64046959170961720285075028881968045D+00
  px(23)= 0.76555947611245457114222548768598476D+00
  px(24)= 0.91448119032995475750346963701721081D+00
  px(25)= 0.10917496366295753151128433644125688D+01
  px(26)= 0.13027221869155879323859021531153006D+01
  px(27)= 0.15537578204695570075088633454278321D+01
  px(28)= 0.18524084405877676482171967152697008D+01
  px(29)= 0.22076505684206197863173711190960219D+01
  px(30)= 0.26301688303884504911030778880813732D+01
  px(31)= 0.31327077074207879423269172652003364D+01
  px(32)= 0.37305161917200709143270025763858640D+01
  px(33)= 0.44419236396092482776254163193454757D+01
  px(34)= 0.52891086092067566005114585507151512D+01
  px(35)= 0.62991644484541209348967251319712091D+01
  px(36)= 0.75056437278338836321053009023954332D+01
  px(37)= 0.89509179672327616775374703555124487D+01
  px(38)= 0.10690015208487653327362214867738207D+02
  px(39)= 0.12797352129263264861734948864857745D+02
  px(40)= 0.15379744394428552764554128123427935D+02
  px(41)= 0.18605142714959248273487455172506479D+02
  px(42)= 0.22780586028957730000926904102977113D+02
  px(43)= 0.28662366237232832381924388811320297D+02
  pw( 1)= 0.85006145870848429334757469982573891D-03
  pw( 2)= 0.19925838109657703878469708707415329D-02
  pw( 3)= 0.31706135365278565227115398483457554D-02
  pw( 4)= 0.44041172343279662518790702958553625D-02
  pw( 5)= 0.57174896648731729427179253475841935D-02
  pw( 6)= 0.71396041280184287136596813041547263D-02
  pw( 7)= 0.87053105293648014281590926123488040D-02
  pw( 8)= 0.10457223593582426133616067442291247D-01
  pw( 9)= 0.12447691003362071183889633075575652D-01
  pw(10)= 0.14740821116468595319728157346456377D-01
  pw(11)= 0.17414420402114891406970230872875573D-01
  pw(12)= 0.20561736545282396913149978083028889D-01
  pw(13)= 0.24293057998247351709738591334952020D-01
  pw(14)= 0.28737438822145949516145087089517893D-01
  pw(15)= 0.34044977279791239841839057487094614D-01
  pw(16)= 0.40390072912737209513481740353650117D-01
  pw(17)= 0.47975933504865389303614731289416436D-01
  pw(18)= 0.57040421240269648291641111667509080D-01
  pw(19)= 0.67863232374253637764436196090399013D-01
  pw(20)= 0.80774426563059878523617995686503505D-01
  pw(21)= 0.96164420051293883535914595526514204D-01
  pw(22)= 0.11449568019439733156432157598398321D+00
  pw(23)= 0.13631648279559252800439663886965342D+00
  pw(24)= 0.16227722290947194423527738296713650D+00
  pw(25)= 0.19314992693280818601029240961091576D+00
  pw(26)= 0.22985183401280394837726875217480564D+00
  pw(27)= 0.27347424857196858115127321375763169D+00
  pw(28)= 0.32531839177175415639431272795218179D+00
  pw(29)= 0.38694082912221267186717847996208730D+00
  pw(30)= 0.46021245154573169215949688893911839D+00
  pw(31)= 0.54739734403912358955407316606691874D+00
  pw(32)= 0.65126193729202891760603881973382504D+00
  pw(33)= 0.77523203175189474974013051456241330D+00
  pw(34)= 0.92362846689464044743151918155531626D+00
  pw(35)= 0.11020374135362457925484267398369432D+01
  pw(36)= 0.13179220978816197700516342241847467D+01
  pw(37)= 0.15816923933252917714931130477654841D+01
  pw(38)= 0.19087060424955494066311220499293247D+01
  pw(39)= 0.23233483559535813743753279936284135D+01
  pw(40)= 0.28683678978287494020672145638838434D+01
  pw(41)= 0.36301191889236335565768841054222539D+01
  pw(42)= 0.48276614242022139042477288493084378D+01
  pw(43)= 0.73428236438762783138460481364952627D+01
endif
if(kn == 44) then
  px( 1)= 0.32331350836957546603744084419849788D-03
  px( 2)= 0.17091703169716826666769331280363544D-02
  px( 3)= 0.42257875064315455206561743770986376D-02
  px( 4)= 0.79149690832372160827916911872302865D-02
  px( 5)= 0.12839179023186853233140061142661062D-01
  px( 6)= 0.19085232241568949577899855509474977D-01
  px( 7)= 0.26768883186791699077493305776558926D-01
  px( 8)= 0.36040864557027892650839059295103373D-01
  px( 9)= 0.47094585778667144264845412823636449D-01
  px(10)= 0.60175615761544264401796703227341314D-01
  px(11)= 0.75592961225388113581704029754538741D-01
  px(12)= 0.93732029387412788080736336661325883D-01
  px(13)= 0.11506910593622805003749038841255850D+00
  px(14)= 0.14018727035639085866142640394142696D+00
  px(15)= 0.16979393946354437271616691990993614D+00
  px(16)= 0.20474060430292067802523043906109989D+00
  px(17)= 0.24604566740448100845633933054720796D+00
  px(18)= 0.29492149096685690036119497895105667D+00
  px(19)= 0.35280682708785925696562700896642017D+00
  px(20)= 0.42140579664772257270434756016372204D+00
  px(21)= 0.50273460611520704557595850856713180D+00
  px(22)= 0.59917729885865279633574477547906320D+00
  px(23)= 0.71355204803416102949757204396579206D+00
  px(24)= 0.84918981260514039761248477195520438D+00
  px(25)= 0.10100276016887074982125673033831345D+01
  px(26)= 0.12007191488994777606413935958511916D+01
  px(27)= 0.14267665395522811775994265815554724D+01
  px(28)= 0.16946773518359189852395063278947950D+01
  px(29)= 0.20121533231038550963171865171844820D+01
  px(30)= 0.23883186915697571717337880438736199D+01
  px(31)= 0.28339996248002878664983052972434529D+01
  px(32)= 0.33620712713198530053650295556681017D+01
  px(33)= 0.39878972622760453246577762221089257D+01
  px(34)= 0.47299002992789324698627794306541718D+01
  px(35)= 0.56103262027415485179449762966436919D+01
  px(36)= 0.66563061139504917392538125507749794D+01
  px(37)= 0.79014003881557845126238132373008625D+01
  px(38)= 0.93879629282953731177093056973506411D+01
  px(39)= 0.11170992458953013913700288894894255D+02
  px(40)= 0.13324895111520577881664368628734089D+02
  px(41)= 0.15956559624176004069472090284905753D+02
  px(42)= 0.19234241988629565032886618545011883D+02
  px(43)= 0.23465930980103016989495364982244146D+02
  px(44)= 0.29411210662212999597346209126697707D+02
  pw( 1)= 0.83036884987403513181911166534208663D-03
  pw( 2)= 0.19457941864115460112729277032771097D-02
  pw( 3)= 0.30943299472937825975912487677647078D-02
  pw( 4)= 0.42943871620956718877444401513682917D-02
  pw( 5)= 0.55684261348013693314562032089920088D-02
  pw( 6)= 0.69428725530123470368722128932621244D-02
  pw( 7)= 0.84494234604398957532432243635753483D-02
  pw( 8)= 0.10126616172976027067397699017267216D-01
  pw( 9)= 0.12021566160747622141057949671782224D-01
  pw(10)= 0.14191778414242213809164508501045497D-01
  pw(11)= 0.16706905485358088359523445571590018D-01
  pw(12)= 0.19650346938023694904494456157357191D-01
  pw(13)= 0.23120695042785977245044097938079732D-01
  pw(14)= 0.27233209875082837015975056631389154D-01
  pw(15)= 0.32121665600246232435212867479076854D-01
  pw(16)= 0.37940949845194110884289250317530407D-01
  pw(17)= 0.44870698984096406199701289089460328D-01
  pw(18)= 0.53120093303752446444612781898982047D-01
  pw(19)= 0.62933823516449817737731500047201570D-01
  pw(20)= 0.74599224373678150636698930396457382D-01
  pw(21)= 0.88454634536330462816566048592135618D-01
  pw(22)= 0.10489914083790778708121373941299966D+00
  pw(23)= 0.12440396953470249784020277878699461D+00
  pw(24)= 0.14752589155074737609776847913675882D+00
  pw(25)= 0.17492312579420798336376479913219788D+00
  pw(26)= 0.20737437787760038519638439806427540D+00
  pw(27)= 0.24580187433567244121381237836878940D+00
  pw(28)= 0.29129959389673368311222620480570831D+00
  pw(29)= 0.34516843605203008284533614069195425D+00
  pw(30)= 0.40896093500380134048288051036096437D+00
  pw(31)= 0.48453955284019804235911876681118743D+00
  pw(32)= 0.57415497731524515579134334664918167D+00
  pw(33)= 0.68055495684587130214889340452349758D+00
  pw(34)= 0.80714146055673592921708826105860249D+00
  pw(35)= 0.95820721891454345652447310233062356D+00
  pw(36)= 0.11393080348437704220650007990276423D+01
  pw(37)= 0.13578783180672521841897407574039451D+01
  pw(38)= 0.16243074162684344243952826001273292D+01
  pw(39)= 0.19539528530618256474917072512577991D+01
  pw(40)= 0.23712430126501098428281754997758214D+01
  pw(41)= 0.29190630527561174415810627420409994D+01
  pw(42)= 0.36841316877299013922727992267156054D+01
  pw(43)= 0.48865818259133309055220603437140743D+01
  pw(44)= 0.74130021614058319715789731577046943D+01
endif
if(kn == 45) then
  px( 1)= 0.31600628834973779292559127048190037D-03
  px( 2)= 0.16702900106190273328935895866739893D-02
  px( 3)= 0.41285257114804008864642830706317964D-02
  px( 4)= 0.77296636135218507544800673352591724D-02
  px( 5)= 0.12531750213154611452085965505028540D-01
  px( 6)= 0.18615241131540077290889348326202186D-01
  px( 7)= 0.26087066631843252886061485477515189D-01
  px( 8)= 0.35085969566222178513934460224332887D-01
  px( 9)= 0.45789306577033888813174278261897663D-01
  px(10)= 0.58421434435784388362459047968056087D-01
  px(11)= 0.73263711622882621260808485115770070D-01
  px(12)= 0.90666037430716786669379135384670844D-01
  px(13)= 0.11105978210403381887459852100321712D+00
  px(14)= 0.13497200418547898709664745719407710D+00
  px(15)= 0.16304104546216750230118904547804422D+00
  px(16)= 0.19603390202336562386932779699909816D+00
  px(17)= 0.23486608544820513725469302847128384D+00
  px(18)= 0.28062490631545969684155812688765467D+00
  px(19)= 0.33459720050887095268667406972580638D+00
  px(20)= 0.39830252448023971951147973257838648D+00
  px(21)= 0.47353284765622731594152923198004578D+00
  px(22)= 0.56239982933240531713761978532829046D+00
  px(23)= 0.66739091019498584233201402129369733D+00
  px(24)= 0.79143567909811363215071199148744656D+00
  px(25)= 0.93798429449898007763809445265874043D+00
  px(26)= 0.11111001581385252565298438994097319D+01
  px(27)= 0.13155695863345333806714751926528375D+01
  px(28)= 0.15570319587074322621285835341493748D+01
  px(29)= 0.18421348417902183390620002381054988D+01
  px(30)= 0.21787200444979152172206336828110265D+01
  px(31)= 0.25760487257631498506605264603704116D+01
  px(32)= 0.30450769803228709332081128619189764D+01
  px(33)= 0.35987985256158263799485414495379126D+01
  px(34)= 0.42526795117768400994862312123212388D+01
  px(35)= 0.50252244422171176606674140586086445D+01
  px(36)= 0.59387361521365530542536690567593329D+01
  px(37)= 0.70203754298618509877391417240792276D+01
  px(38)= 0.83037051949719291418317245580593492D+01
  px(39)= 0.98310601809174348734008913125923897D+01
  px(40)= 0.11657412426662143324540788749464127D+02
  px(41)= 0.13857164426266931434200566791289955D+02
  px(42)= 0.16537288540540952756080764303901777D+02
  px(43)= 0.19866358206258941542582357564294186D+02
  px(44)= 0.24153320185396072162240284411839110D+02
  px(45)= 0.30161032818176703094230836042654050D+02
  pw( 1)= 0.81157322026241886094392714295783692D-03
  pw( 2)= 0.19011777475163676304804330211208542D-02
  pw( 3)= 0.30217126568442239903479316417011601D-02
  pw( 4)= 0.41901870013204838998208477401165665D-02
  pw( 5)= 0.54273283828323581210343431353844446D-02
  pw( 6)= 0.67573866388465515363650925512746062D-02
  pw( 7)= 0.82092751225427288897814574011554460D-02
  pw( 8)= 0.98179504955536258107199257981433439D-02
  pw( 9)= 0.11625949429528062575538287604998941D-01
  pw(10)= 0.13685006654390859174410475886206370D-01
  pw(11)= 0.16057648452306267238525538418198228D-01
  pw(12)= 0.18818661412340581662760322741958838D-01
  pw(13)= 0.22056412054981119160700553625749748D-01
  pw(14)= 0.25874134633155885709619608590472202D-01
  pw(15)= 0.30391451859719384524106580753360271D-01
  pw(16)= 0.35746460932048448724214073937351505D-01
  pw(17)= 0.42098664685115079575098628197326142D-01
  pw(18)= 0.49632898864791727296990224145235518D-01
  pw(19)= 0.58564289944594589064829987997677920D-01
  pw(20)= 0.69144234514984419908558444457124034D-01
  pw(21)= 0.81667423637721859042077146566843517D-01
  pw(22)= 0.96480011247988074883978780802066204D-01
  pw(23)= 0.11398911344507944971212279753122991D+00
  pw(24)= 0.13467391267458107409324694436955753D+00
  pw(25)= 0.15909873207292332703499649578337212D+00
  pw(26)= 0.18792855598692739186974920544448162D+00
  pw(27)= 0.22194762553095863671304473597844931D+00
  pw(28)= 0.26208196494751982936477406183051153D+00
  pw(29)= 0.30942704406840347450420829122426871D+00
  pw(30)= 0.36528233311686115136869183803961988D+00
  pw(31)= 0.43119539125683582249214467187083528D+00
  pw(32)= 0.50901957973734783536801637831942790D+00
  pw(33)= 0.60099191357850333533977421143095798D+00
  pw(34)= 0.70984171451926250865508439176773176D+00
  pw(35)= 0.83894803839540918949226578045417203D+00
  pw(36)= 0.99257719538081268693583754948673040D+00
  pw(37)= 0.11762571380368294152931731126534612D+01
  pw(38)= 0.13973967807100820386062004887130792D+01
  pw(39)= 0.16663689232723581345802345799199851D+01
  pw(40)= 0.19985351917633034604206124546990186D+01
  pw(41)= 0.24183711599931949498296065604711404D+01
  pw(42)= 0.29689015304223315699189706042837967D+01
  pw(43)= 0.37372089827137538865937716176457237D+01
  pw(44)= 0.49444904398530770204722137069339350D+01
  pw(45)= 0.74820372303276097896128738491191685D+01
endif
if(kn == 46) then
  px( 1)= 0.30902377399120893788354424898855426D-03
  px( 2)= 0.16331537506671398843215268321368443D-02
  px( 3)= 0.40357010980175320995569579449408174D-02
  px( 4)= 0.75530195763806797812195436379199476D-02
  px( 5)= 0.12239149854724502952182976196758722D-01
  px( 6)= 0.18168803621919060471207612598191755D-01
  px( 7)= 0.25440976363694145320552734001486569D-01
  px( 8)= 0.34183679422904259346408703316308100D-01
  px( 9)= 0.44559964643964573543760075913259475D-01
  px(10)= 0.56775358517699538859278511856645348D-01
  px(11)= 0.71086748757462020933356688085151754D-01
  px(12)= 0.87812673145710441814424785984121246D-01
  px(13)= 0.10734488854150171164189046430233515D+00
  px(14)= 0.13016110718036063404346759877348097D+00
  px(15)= 0.15683892196176944176774935350653314D+00
  px(16)= 0.18807118924767432734960867652772029D+00
  px(17)= 0.22468341948583423108691031411123462D+00
  px(18)= 0.26765394743983501400088905846999460D+00
  px(19)= 0.31813776531045013135926232571664330D+00
  px(20)= 0.37749492399880062738311332663588965D+00
  px(21)= 0.44732440247018853385136813722855067D+00
  px(22)= 0.52950437210775343555603255060398518D+00
  px(23)= 0.62623987488687805361419457851831370D+00
  px(24)= 0.74011910006308993968762196795007188D+00
  px(25)= 0.87417968361959824522374584708126947D+00
  px(26)= 0.10319867719667534605241559659266134D+01
  px(27)= 0.12177250028776661981781648200867157D+01
  px(28)= 0.14363070973204841479279696750353849D+01
  px(29)= 0.16935024864806789035793857077605729D+01
  px(30)= 0.19960904185444808460178685393801009D+01
  px(31)= 0.23520434618090888941520463681053941D+01
  px(32)= 0.27707495103418382337989450786653183D+01
  px(33)= 0.32632837492864188626066742354315931D+01
  px(34)= 0.38427473041855077266339137871017428D+01
  px(35)= 0.45246978009253960226440639549407685D+01
  px(36)= 0.53277111750428588477775437304742452D+01
  px(37)= 0.62741382355089597665586817773799499D+01
  px(38)= 0.73911624234084726194161817156844889D+01
  px(39)= 0.87123449938120379656808053147144537D+01
  px(40)= 0.10280000673796667050592943428615469D+02
  px(41)= 0.12149077777983097408939533602647387D+02
  px(42)= 0.14393981931423795298134131653931530D+02
  px(43)= 0.17121779022116518315203538273624565D+02
  px(44)= 0.20501370994989532793115106347627070D+02
  px(45)= 0.24842669385551363138030331359754804D+02
  px(46)= 0.30911787987864913738727989247192145D+02
  pw( 1)= 0.79361463897360195929686273302248409D-03
  pw( 2)= 0.18585856237700307630029880256700761D-02
  pw( 3)= 0.29524996535416808392477309033103772D-02
  pw( 4)= 0.40910988545579399083185141944050702D-02
  pw( 5)= 0.52935540515794390997929859327326122D-02
  pw( 6)= 0.65821742586378490181117941215141045D-02
  pw( 7)= 0.79834063288880762331149927032946792D-02
  pw( 8)= 0.95290513069482303557158918089126201D-02
  pw( 9)= 0.11257625314697109024742951848074159D-01
  pw(10)= 0.13215805246967286000173950239611213D-01
  pw(11)= 0.15459871723048351392169871195100160D-01
  pw(12)= 0.18057057593147761999943506400696980D-01
  pw(13)= 0.21086760440076034016469007977829453D-01
  pw(14)= 0.24641687279129405797304341158994351D-01
  pw(15)= 0.28829130387470289935818007648098355D-01
  pw(16)= 0.33772655230285352209194232463306431D-01
  pw(17)= 0.39614465986840122572670076622475638D-01
  pw(18)= 0.46518617394519992951670269787487787D-01
  pw(19)= 0.54675131186708511535131483491430821D-01
  pw(20)= 0.64305014007496806948186778346285377D-01
  pw(21)= 0.75666179654741774777744798242374952D-01
  pw(22)= 0.89060332032660676125924796117040007D-01
  pw(23)= 0.10484093752103114356647229133814935D+00
  pw(24)= 0.12342248951027967461470307235875341D+00
  pw(25)= 0.14529134199630383752180561542530020D+00
  pw(26)= 0.17101847250539549716018144547422270D+00
  pw(27)= 0.20127464277089058198410341836023683D+00
  pw(28)= 0.23684858001359149093932878615193101D+00
  pw(29)= 0.27866903348006793962100039913921415D+00
  pw(30)= 0.32783191849208153321924464180174769D+00
  pw(31)= 0.38563432289935890460881756854144066D+00
  pw(32)= 0.45361805217372703197887339399899876D+00
  pw(33)= 0.53362686058844350813392769068823926D+00
  pw(34)= 0.62788396771362463542546047416846800D+00
  pw(35)= 0.73910064578742344795091934329070699D+00
  pw(36)= 0.87063402416829911198578365788259413D+00
  pw(37)= 0.10267256741807495552845728772900802D+01
  pw(38)= 0.12128781106626951287021151112542470D+01
  pw(39)= 0.14364778560404412196974965116370614D+01
  pw(40)= 0.17078848068460459936312054922566995D+01
  pw(41)= 0.20424685786283419841913953641602057D+01
  pw(42)= 0.24647555529206493569854377641616308D+01
  pw(43)= 0.30179124308683067944200720815335092D+01
  pw(44)= 0.37893852356394974569134386395867514D+01
  pw(45)= 0.50014251355936200780723745695031871D+01
  pw(46)= 0.75499704094498894150628414754712103D+01
endif
if(kn == 47) then
  px( 1)= 0.30234480684949870042066556848012510D-03
  px( 2)= 0.15976464953770958135599778441796202D-02
  px( 3)= 0.39470145814685269106194100213451950D-02
  px( 4)= 0.73844351214347704596731706115099534D-02
  px( 5)= 0.11960307325670953208852468939751834D-01
  px( 6)= 0.17744140854528926114461559850667081D-01
  px( 7)= 0.24827775421109866384949286855042231D-01
  px( 8)= 0.33329587337597891764863922994014555D-01
  px( 9)= 0.43399840203304717839217570161011672D-01
  px(10)= 0.55227290263964079065971805634237348D-01
  px(11)= 0.69047097585245923081163450963219921D-01
  px(12)= 0.85150014954361349896311981444336255D-01
  px(13)= 0.10389275615680304450176721539326430D+00
  px(14)= 0.12570943253264044220914087598374078D+00
  px(15)= 0.15112403488297752197534393801499475D+00
  px(16)= 0.18076413027130191024242456354592003D+00
  px(17)= 0.21537618776652269918043941270387835D+00
  px(18)= 0.25584316244558279667676325421037561D+00
  px(19)= 0.30320509530959575930710602679134976D+00
  px(20)= 0.35868352704264273864602902528848421D+00
  px(21)= 0.42371052026058185226325968835995444D+00
  px(22)= 0.49996309228509504682760172037312828D+00
  px(23)= 0.58940391513730639900316144249394630D+00
  px(24)= 0.69432925544472178824662119719828653D+00
  px(25)= 0.81742530558526965352748082134155990D+00
  px(26)= 0.96183429918308909086642705501460506D+00
  px(27)= 0.11312321171355587417637105018144043D+01
  px(28)= 0.13299194954977380580964549469885521D+01
  px(29)= 0.15629294821033111247460192707385455D+01
  px(30)= 0.18361545182421012128782235750936341D+01
  px(31)= 0.21564975473013180685304927966921050D+01
  px(32)= 0.25320530389913426066138968271032273D+01
  px(33)= 0.29723260351325192884401956439321237D+01
  px(34)= 0.34885007189662000039152029330111157D+01
  px(35)= 0.40937753452277820469237089959367401D+01
  px(36)= 0.48037889682999426543864264911219419D+01
  px(37)= 0.56371796552402367761125198516216112D+01
  px(38)= 0.66163382295353580459275111274902267D+01
  px(39)= 0.77684648059929853861219213698259439D+01
  px(40)= 0.91271156012149482363243828361549091D+01
  px(41)= 0.10734585093601096152552856517558275D+02
  px(42)= 0.12645801076306643342528896213826369D+02
  px(43)= 0.14935178894323617316649392464504258D+02
  px(44)= 0.17709887244612807742256277065719222D+02
  px(45)= 0.21139166627448714331281414920298006D+02
  px(46)= 0.25533898913637103231788330664255958D+02
  px(47)= 0.31663433742152343555689779493983534D+02
  pw( 1)= 0.77643840612392469558233568878288438D-03
  pw( 2)= 0.18178823313702654997790171434491737D-02
  pw( 3)= 0.28864536542127938374932216849800024D-02
  pw( 4)= 0.39967467153526294501560789189634526D-02
  pw( 5)= 0.51665295391631236792192347882343893D-02
  pw( 6)= 0.64163743838733321438814922251353746D-02
  pw( 7)= 0.77705352297994246418018494260403994D-02
  pw( 8)= 0.92580225788462023682293420241402079D-02
  pw( 9)= 0.10913810605238600296521875414785753D-01
  pw(10)= 0.12780129454852165115348470540659794D-01
  pw(11)= 0.14907770873253776058864543333587366D-01
  pw(12)= 0.17357325452550337474212111231031977D-01
  pw(13)= 0.20200301191038969448754000899427036D-01
  pw(14)= 0.23520156080274576647610305543693418D-01
  pw(15)= 0.27413389239659681777619137570103249D-01
  pw(16)= 0.31990921824324695951826704036400849D-01
  pw(17)= 0.37380010931288310349162200884914999D-01
  pw(18)= 0.43726873583833196750460928410582440D-01
  pw(19)= 0.51200100443073974036149329120700021D-01
  pw(20)= 0.59994868260574886373334055836155630D-01
  pw(21)= 0.70337945020122803930065727247244319D-01
  pw(22)= 0.82493514750755835638795021587104324D-01
  pw(23)= 0.96769906495425836064670059167481399D-01
  pw(24)= 0.11352737495114584133685628457043583D+00
  pw(25)= 0.13318714247714292913023639085868125D+00
  pw(26)= 0.15624197763113426788311768418626933D+00
  pw(27)= 0.18326866459826594224170442595536027D+00
  pw(28)= 0.21494282570862350034472593398023850D+00
  pw(29)= 0.25205671631617380517032575867290262D+00
  pw(30)= 0.29554084830882541265073842592331588D+00
  pw(31)= 0.34649066398539118260401510223685881D+00
  pw(32)= 0.40620005573936491411597998731411544D+00
  pw(33)= 0.47620444337408185641294547642135994D+00
  pw(34)= 0.55833761203594537949491272468091006D+00
  pw(35)= 0.65480899160066358211037008014529884D+00
  pw(36)= 0.76831227871509708311671525382157320D+00
  pw(37)= 0.90218370924525609794334519875989345D+00
  pw(38)= 0.10606417731219318086869090064772246D+01
  pw(39)= 0.12491658485426170682375819102086492D+01
  pw(40)= 0.14751229591934938816623767074938966D+01
  pw(41)= 0.17488634335620615325269065049873221D+01
  pw(42)= 0.20857683710668100441568568919092486D+01
  pw(43)= 0.25104181373755596577440533667319287D+01
  pw(44)= 0.30661234529278624717819692903450825D+01
  pw(45)= 0.38406927297086597567375854792414220D+01
  pw(46)= 0.50574215821071962594952640986635070D+01
  pw(47)= 0.76168408553950413361259182112809766D+01
endif
if(kn == 48) then
  px( 1)= 0.29595002899720089598048509729240858D-03
  px( 2)= 0.15636631385928177658857961799981344D-02
  px( 3)= 0.38621935810659565095543543710661065D-02
  px( 4)= 0.72233636458828631437195788212396685D-02
  px( 5)= 0.11694254587023519966120947669484770D-01
  px( 6)= 0.17339652834546167382576155326885531D-01
  px( 7)= 0.24244927054495278219738066751504960D-01
  px( 8)= 0.32519777490587042844934209629601974D-01
  px( 9)= 0.42303000131579013083618262933841541D-01
  px(10)= 0.53768369083049019518863347968872785D-01
  px(11)= 0.67131693007024900369022557250738329D-01
  px(12)= 0.82659034800333661590098251027713411D-01
  px(13)= 0.10067601794995718748717592252167950D+00
  px(14)= 0.12157811670283109994038391671204829D+00
  px(15)= 0.14584188025331271469532975454293184D+00
  px(16)= 0.17403718708094337911584686617663455D+00
  px(17)= 0.20684083223970121872293135877750441D+00
  px(18)= 0.24505195226053213810882336066380088D+00
  px(19)= 0.28960993053758356990356801037005909D+00
  px(20)= 0.34161548376800915367159074480126869D+00
  px(21)= 0.40235563464585336049157109682672131D+00
  px(22)= 0.47333327369938541669100296412222937D+00
  px(23)= 0.55630204160312520623134123151678925D+00
  px(24)= 0.65330734108265942786541154430622162D+00
  px(25)= 0.76673441875356785236785315155850152D+00
  px(26)= 0.89936464142274902321479563230619771D+00
  px(27)= 0.10544413316663370284059399235987637D+01
  px(28)= 0.12357468356208411453551987100600846D+01
  px(29)= 0.14476928958143963682846712437006035D+01
  px(30)= 0.16954269342764845689137922115223447D+01
  px(31)= 0.19849575816646326604339901913933094D+01
  px(32)= 0.23233038211583159605827592291675721D+01
  px(33)= 0.27186736189401563011050998256085975D+01
  px(34)= 0.31806801589007531007613766645355501D+01
  px(35)= 0.37206072396727045282926190726802162D+01
  px(36)= 0.43517407927213647930655693816847034D+01
  px(37)= 0.50897921727561576322594218577457258D+01
  px(38)= 0.59534532497729963738598299894774892D+01
  px(39)= 0.69651478712196520721782791126144665D+01
  px(40)= 0.81520877402662049285349974267562675D+01
  px(41)= 0.95478213967711421151781315680800985D+01
  px(42)= 0.11194623319536797531467272595329506D+02
  px(43)= 0.13147404152263011059682758275653972D+02
  px(44)= 0.15480595341123512509584325553694590D+02
  px(45)= 0.18301477075836510534702330167968349D+02
  px(46)= 0.21779637522565706043537218918652790D+02
  px(47)= 0.26226933347488070796043946213342574D+02
  px(48)= 0.32415929770269557720899017070958329D+02
  pw( 1)= 0.75999449282242525498888775227070420D-03
  pw( 2)= 0.17789442907920029044278935841370033D-02
  pw( 3)= 0.28233592185581488393945265516117315D-02
  pw( 4)= 0.39067912705549311303324714399927545D-02
  pw( 5)= 0.50457409167121635114256894882489535D-02
  pw( 6)= 0.62592215195201857161143217251824231D-02
  pw( 7)= 0.75695311456923674293727515403732119D-02
  pw( 8)= 0.90032044940945145010068536558863271D-02
  pw( 9)= 0.10592085506839418968886878624905230D-01
  pw(10)= 0.12374483314193827446279695880913988D-01
  pw(11)= 0.14396352965559528046529852650738501D-01
  pw(12)= 0.16712429540159363311802064676696312D-01
  pw(13)= 0.19387262265658075348794679025267961D-01
  pw(14)= 0.22496156590284673178523069618335189D-01
  pw(15)= 0.26126125032895265676414993536188666D-01
  pw(16)= 0.30377032282566849853328475248140570D-01
  pw(17)= 0.35363150724079551172748521328984452D-01
  pw(18)= 0.41215303456842402904128482278539693D-01
  pw(19)= 0.48083691328284411416338444917462566D-01
  pw(20)= 0.56141427938196717060539102662208221D-01
  pw(21)= 0.65588776105316823321919603829156998D-01
  pw(22)= 0.76658094133956830129535839504567249D-01
  pw(23)= 0.89619543419632664042116217247700679D-01
  pw(24)= 0.10478766192717970201342332439078370D+00
  pw(25)= 0.12252896123742271255427206161487662D+00
  pw(26)= 0.14327075828486752574672706211131092D+00
  pw(27)= 0.16751151313821774235835757278858330D+00
  pw(28)= 0.19583302163349966411912965960570620D+00
  pw(29)= 0.22891492049551029451481007469340092D+00
  pw(30)= 0.26755212283797206211340817029488241D+00
  pw(31)= 0.31267604416833112127254011348613261D+00
  pw(32)= 0.36538085205037423661137648346933768D+00
  pw(33)= 0.42695655668634922335366944118783047D+00
  pw(34)= 0.49893168999297620297105696955480497D+00
  pw(35)= 0.58312983017364951950857474996168896D+00
  pw(36)= 0.68174673032193870559875685439839375D+00
  pw(37)= 0.79745906091752647870294820280336694D+00
  pw(38)= 0.93358322488211662322908533451921218D+00
  pw(39)= 0.10943162513760950011430094815688344D+01
  pw(40)= 0.12851165678797307366335354072388698D+01
  pw(41)= 0.15133343910778260993594764587330245D+01
  pw(42)= 0.17893135308834332452949764559455513D+01
  pw(43)= 0.21284497101212601640922819767089646D+01
  pw(44)= 0.25553800629427160180922388763367066D+01
  pw(45)= 0.31135609716998794233456050246781466D+01
  pw(46)= 0.38911620012948672120134104867773046D+01
  pw(47)= 0.51125134158119019180657428081205730D+01
  pw(48)= 0.76826855076385203411408423144047970D+01
endif
if(kn == 49) then
  px( 1)= 0.28982169661609259925974979296199715D-03
  px( 2)= 0.15311074628945562334530690364685912D-02
  px( 3)= 0.37809891427061498988417968394892015D-02
  px( 4)= 0.70693075551075721251308809528074262D-02
  px( 5)= 0.11440114051043380640580809174873546D-01
  px( 6)= 0.16953896205505568651585337372141638D-01
  px( 7)= 0.23690155524198397880316141824091359D-01
  px( 8)= 0.31750757826730201808237900276821105D-01
  px( 9)= 0.41264185607363735111209847472395680D-01
  px(10)= 0.52390788296171869395123759706096667D-01
  px(11)= 0.65329088415812943007951010158851832D-01
  px(12)= 0.80323145971104464698417160245071838D-01
  px(13)= 0.97670923692398180646763841694521778D-01
  px(14)= 0.11773356193272553739176999855177642D+00
  px(15)= 0.14094549927124676527452589226795674D+00
  px(16)= 0.16782548211787615810300942831732404D+00
  px(17)= 0.19898867709139685594599685847717735D+00
  px(18)= 0.23516028351061490409755316887724481D+00
  px(19)= 0.27719118480638011914316315022611666D+00
  px(20)= 0.32607625000818758221137748238031822D+00
  px(21)= 0.38297591208948031388506643958671483D+00
  px(22)= 0.44924164526126338307000295982995931D+00
  px(23)= 0.52644597452520216232192817378809657D+00
  px(24)= 0.61641769981161764547143482902113440D+00
  px(25)= 0.72128311119138160917726410382682506D+00
  px(26)= 0.84351411110478227605310059636301640D+00
  px(27)= 0.98598434482611919288728229535556820D+00
  px(28)= 0.11520346774611530676609320335187635D+01
  px(29)= 0.13455496592189661370306885171963069D+01
  px(30)= 0.15710470166859281003411527674326210D+01
  px(31)= 0.18337827389082834345983893278310805D+01
  px(32)= 0.21398750605157030327208430120547271D+01
  px(33)= 0.24964516861943417767039670584804599D+01
  px(34)= 0.29118261213763337159423664681275174D+01
  px(35)= 0.33957112485642962686719816570055312D+01
  px(36)= 0.39594817726282308325228740791813504D+01
  px(37)= 0.46165026215025079679688539374253711D+01
  px(38)= 0.53825491684099448048962771604007379D+01
  px(39)= 0.62763596401674826758369077814162276D+01
  px(40)= 0.73203847840971806343130509762279760D+01
  px(41)= 0.85418435921307030922239809237588315D+01
  px(42)= 0.99742749209607261981040189301013931D+01
  px(43)= 0.11659933902343682924575082774292738D+02
  px(44)= 0.13653717512175632633212031175648009D+02
  px(45)= 0.16030079451319704520212844485652403D+02
  px(46)= 0.18896419514536338819621757969794054D+02
  px(47)= 0.22422681781072229358731374027395797D+02
  px(48)= 0.26921701181159762662101522272189023D+02
  px(49)= 0.33169237709310133472812163437610434D+02
  pw( 1)= 0.74423705557468321912970974468971512D-03
  pw( 2)= 0.17416585473194369192981311717828790D-02
  pw( 3)= 0.27630202767273380717880972293549723D-02
  pw( 4)= 0.38209254857123832686825908868042634D-02
  pw( 5)= 0.49307262850810818969143173604709699D-02
  pw( 6)= 0.61100327216620297105479543777143453D-02
  pw( 7)= 0.73793929142489472766538930130422414D-02
  pw( 8)= 0.87631380820224889920133086400922484D-02
  pw( 9)= 0.10290337290113942038466358200627605D-01
  pw(10)= 0.11995832288470777205381700382547014D-01
  pw(11)= 0.13921304955008894938778083468431898D-01
  pw(12)= 0.16116315842092009170407309532189491D-01
  pw(13)= 0.18639261057732707055179140040607199D-01
  pw(14)= 0.21558238862705300435120252889679016D-01
  pw(15)= 0.24951892641527327511221421263371520D-01
  pw(16)= 0.28910375260277562929269397616107752D-01
  pw(17)= 0.33536621862509534402237961505810400D-01
  pw(18)= 0.38948101356497020534071631819477111D-01
  pw(19)= 0.45279154574446597766189875771988559D-01
  pw(20)= 0.52683958194920854977905259654150493D-01
  pw(21)= 0.61340113116439272718820743217394536D-01
  pw(22)= 0.71452855489322219691816819653732876D-01
  pw(23)= 0.83259918269799951973839847297358939D-01
  pw(24)= 0.97037114546374637815371486877102608D-01
  pw(25)= 0.11310475960635753107742085931930780D+00
  pw(26)= 0.13183509368952202468340313538628788D+00
  pw(27)= 0.15366091498274177979540995552638069D+00
  pw(28)= 0.17908568983953526314195097583061572D+00
  pw(29)= 0.20869548441677582027963091462587493D+00
  pw(30)= 0.24317317246706239890716235938537564D+00
  pw(31)= 0.28331553768501980083448486564952605D+00
  pw(32)= 0.33005413638688135108429388605654924D+00
  pw(33)= 0.38448116653084696134266394851745611D+00
  pw(34)= 0.44788218293156059076871251650381853D+00
  pw(35)= 0.52177844169743715495966266074704591D+00
  pw(36)= 0.60798318304777180959943540325649013D+00
  pw(37)= 0.70867868475109945308012661652305988D+00
  pw(38)= 0.82652519802949145510247997374762292D+00
  pw(39)= 0.96482036576439726113478189858839344D+00
  pw(40)= 0.11277413304728328935012105843530012D+01
  pw(41)= 0.13207276384535346696169033036111123D+01
  pw(42)= 0.15511151994361137315814825047961978D+01
  pw(43)= 0.18292440906220512275179521250816934D+01
  pw(44)= 0.21705274773423284009902208179302011D+01
  pw(45)= 0.25996616983900981131162894691162348D+01
  pw(46)= 0.31602501106700710441030906881720498D+01
  pw(47)= 0.39408219589198821554199569326106068D+01
  pw(48)= 0.51667323905056736314902652284285907D+01
  pw(49)= 0.77475392524477876553320371372226975D+01
endif
if(kn == 50) then
  px( 1)= 0.28394351112953297748994559783102511D-03
  px( 2)= 0.14998911954688725774856401484033629D-02
  px( 3)= 0.37031733634109224832474380329849766D-02
  px( 4)= 0.69218127312350228406485064567062889D-02
  px( 5)= 0.11197087943784824700478952929697149D-01
  px( 6)= 0.16585564985245590131106268275448670D-01
  px( 7)= 0.23161412500517665834595664639261402D-01
  px( 8)= 0.31019403043677038055911010779170235D-01
  px( 9)= 0.40278717647655643037391307728658037D-01
  px(10)= 0.51087642190675989042234002017798487D-01
  px(11)= 0.63629213809160599368347959049041399D-01
  px(12)= 0.78127829475675329032296849094039453D-01
  px(13)= 0.94856775739499734452627500076424815D-01
  px(14)= 0.11414660148335876745918230546444594D+00
  px(15)= 0.13639426440178507981483041317230735D+00
  px(16)= 0.16207305783142124363194134470205347D+00
  px(17)= 0.19174346191330080395615598185222217D+00
  px(18)= 0.22606522557261662878988725676839652D+00
  px(19)= 0.26581112483702385355663297234020894D+00
  px(20)= 0.31188292620679003206265405632135533D+00
  px(21)= 0.36533011131301634013423764015010912D+00
  px(22)= 0.42737191711071555589396273204369958D+00
  px(23)= 0.49942324705020639374541286536052638D+00
  px(24)= 0.58312503667951418472684968751768941D+00
  px(25)= 0.68037972242344487980438298325566643D+00
  px(26)= 0.79339256658260940896953648094143840D+00
  px(27)= 0.92471973446804368904394005417532194D+00
  px(28)= 0.10773242035057135225415445929049064D+01
  px(29)= 0.12546408175407001854792111537007726D+01
  px(30)= 0.14606520990918797361653158063467201D+01
  px(31)= 0.16999768257560608388590285583482666D+01
  px(32)= 0.19779739082773843717702150700803880D+01
  px(33)= 0.23008648456607864889580088643288349D+01
  px(34)= 0.26758790850855905290663568936243531D+01
  px(35)= 0.31114281531421848676256035865658428D+01
  px(36)= 0.36173167280945029265548597355573382D+01
  px(37)= 0.42050023489136640359196188798116726D+01
  px(38)= 0.48879209793922610146974780441291671D+01
  px(39)= 0.56819045073984933891246336517741761D+01
  px(40)= 0.66057308705566818707545720531514149D+01
  px(41)= 0.76818723662188017987959388336177329D+01
  px(42)= 0.89375516656298253147474053069187414D+01
  px(43)= 0.10406296477480503239729452647809424D+02
  px(44)= 0.12130343567869783578305872825995901D+02
  px(45)= 0.14164579787764828196349642136898031D+02
  px(46)= 0.16583487005376427804066458589286026D+02
  px(47)= 0.19494592188944424125485472332517264D+02
  px(48)= 0.23068202782732093092557399540639023D+02
  px(49)= 0.27618134557703623179690912010041751D+02
  px(50)= 0.33923321036009768333728618541703920D+02
  pw( 1)= 0.72912399684308635017096115410335056D-03
  pw( 2)= 0.17059216228519449314704147393870548D-02
  pw( 3)= 0.27052579385463033654518158126252911D-02
  pw( 4)= 0.37388707495255014610097719618737042D-02
  pw( 5)= 0.48210691945239681765906911252349642D-02
  pw( 6)= 0.59681965658636724574936823069437344D-02
  pw( 7)= 0.71992306962236770905536136519431856D-02
  pw( 8)= 0.85365357689533034566484478187242343D-02
  pw( 9)= 0.10006713677868850439161417859632759D-01
  pw(10)= 0.11641531351319812896113767691847514D-01
  pw(11)= 0.13478885680498147705267761047018866D-01
  pw(12)= 0.15563753671054168683182913698539199D-01
  pw(13)= 0.17949077884564351780048811341841315D-01
  pw(14)= 0.20696568103487745734831198958981091D-01
  pw(15)= 0.23877459843864173187990416648243479D-01
  pw(16)= 0.27573340091582106763900700105376174D-01
  pw(17)= 0.31877198204074685512995246247087960D-01
  pw(18)= 0.36894860399462428730109186000241340D-01
  pw(19)= 0.42746921785947037355880124311792745D-01
  pw(20)= 0.49571228532988571977201451960147272D-01
  pw(21)= 0.57525917359503163899312028414966321D-01
  pw(22)= 0.66793006913272852902897497204087823D-01
  pw(23)= 0.77582552855288975335680322806095329D-01
  pw(24)= 0.90137412508095941124740779645748160D-01
  pw(25)= 0.10473870396294021438411474581832967D+00
  pw(26)= 0.12171208319009365070220694175921390D+00
  pw(27)= 0.14143500171709279543618029697282644D+00
  pw(28)= 0.16434515151851001863886624876712371D+00
  pw(29)= 0.19095035999365251682074028234920175D+00
  pw(30)= 0.22184027575178191861381490980142531D+00
  pw(31)= 0.25770029856713080526288855613179455D+00
  pw(32)= 0.29932837398793730342885176518781178D+00
  pw(33)= 0.34765552544247195237609202772613096D+00
  pw(34)= 0.40377138372726537143521552364635440D+00
  pw(35)= 0.46895657668751681273934682099459395D+00
  pw(36)= 0.54472479692767961940426388856919793D+00
  pw(37)= 0.63287890678130081055700714208328112D+00
  pw(38)= 0.73558798250487807944749198073740843D+00
  pw(39)= 0.85549650522124124655227075039375323D+00
  pw(40)= 0.99588443073362582872294183483256617D+00
  pw(41)= 0.11609105355219986209989146786182259D+01
  pw(42)= 0.13559974384949635725484334023159422D+01
  pw(43)= 0.15884690610914334611993355370110858D+01
  pw(44)= 0.18686642910659719608475187905997900D+01
  pw(45)= 0.22120162660997500537540215058314098D+01
  pw(46)= 0.26432826564193229543032457728289448D+01
  pw(47)= 0.32062148179068205963629824250927723D+01
  pw(48)= 0.39897000025706165355011208836568943D+01
  pw(49)= 0.52201085267504392582124308457577559D+01
  pw(50)= 0.78114350904888610285435916161990246D+01
endif
if(kn == 51) then
  px( 1)= 0.27830048331694745146626670725003848D-03
  px( 2)= 0.14699332467589495012214296420135614D-02
  px( 3)= 0.36285373076700958382889506232860957D-02
  px( 4)= 0.67804640421568805932750563900953938D-02
  px( 5)= 0.10964449641475153555650317586921338D-01
  px( 6)= 0.16233474841656748209131399424045480D-01
  px( 7)= 0.22656849606742837535759660703189982D-01
  px( 8)= 0.30322907994226545082257492807954794D-01
  px( 9)= 0.39342419929775285730416663052397862D-01
  px(10)= 0.49852801135275356633188650023787799D-01
  px(11)= 0.62023178388698049878991488778075058D-01
  px(12)= 0.76060329272036397821127225875497380D-01
  px(13)= 0.92215469045402426815676149451909456D-01
  px(14)= 0.11079181963288772179472869891025245D+00
  px(15)= 0.13215289192145648970655359123013550D+00
  px(16)= 0.15673146375949390138182262372756365D+00
  px(17)= 0.18503934411172685168403222212810987D+00
  px(18)= 0.21767815425667758980667415659377157D+00
  px(19)= 0.25535148902919646272821292167480645D+00
  px(20)= 0.29887891101338956958304222194317216D+00
  px(21)= 0.34921226930606420176060402127989888D+00
  px(22)= 0.40745483836472093899131085922052085D+00
  px(23)= 0.47488376920818361679977841816170633D+00
  px(24)= 0.55297635865326739663234570169538373D+00
  px(25)= 0.64344068535303042620990947995897496D+00
  px(26)= 0.74825123790612149826635700308884120D+00
  px(27)= 0.86969026995696913003053787424248180D+00
  px(28)= 0.10103957605313364799613553988071921D+01
  px(29)= 0.11734170393027801618266450011528511D+01
  px(30)= 0.13622793663980858168640978903164547D+01
  px(31)= 0.15810590528845442660473438585783950D+01
  px(32)= 0.18344711002533369402909515294518176D+01
  px(33)= 0.21279718700902070387593931590109607D+01
  px(34)= 0.24678800386227544163678584032999521D+01
  px(35)= 0.28615201544104645116093866929518600D+01
  px(36)= 0.33173946748043709269495501699195293D+01
  px(37)= 0.38453926882082167185869634333011899D+01
  px(38)= 0.44570470958112522799784043488271277D+01
  px(39)= 0.51658576054751924442339769813379872D+01
  px(40)= 0.59877058293844537789530450556075720D+01
  px(41)= 0.69414034941300311714983901016833412D+01
  px(42)= 0.80494397879808445218602940428136405D+01
  px(43)= 0.93390380570666107887290025527994856D+01
  px(44)= 0.10843713859839632308899371210210092D+02
  px(45)= 0.12605686843057786008572981971452711D+02
  px(46)= 0.14679837296994134584444426535907765D+02
  px(47)= 0.17140680920657630892046419784075754D+02
  px(48)= 0.20095878907672599896988947474029035D+02
  px(49)= 0.23716108785958653467610019526488283D+02
  px(50)= 0.28316168939449414612178766745269557D+02
  px(51)= 0.34678144812502309409979036489309933D+02
  pw( 1)= 0.71461661125073618577714141168068574D-03
  pw( 2)= 0.16716385878603382275615092392545966D-02
  pw( 3)= 0.26499087137809206936489894716951881D-02
  pw( 4)= 0.36603737280291944817450300201489801D-02
  pw( 5)= 0.47163932617577667464231453856574222D-02
  pw( 6)= 0.58331641163766286245746932185477944D-02
  pw( 7)= 0.70282510906775725331369422805168084D-02
  pw( 8)= 0.83222573157223186581625603590243717D-02
  pw( 9)= 0.97395848045625290059070106665033066D-02
  pw(10)= 0.11309266338983814689829245251610443D-01
  pw(11)= 0.13065837815189701273276681449362080D-01
  pw(12)= 0.15050206824622500427636027066505286D-01
  pw(13)= 0.17310471604431563174843365788224820D-01
  pw(14)= 0.19902665286202140668402395991957144D-01
  pw(15)= 0.22891446750016473901306940204721219D-01
  pw(16)= 0.26350819616702910168573443501795867D-01
  pw(17)= 0.30365009714194435950502154476602598D-01
  pw(18)= 0.35029644330122852911457703936925401D-01
  pw(19)= 0.40453348181743022646044235704229779D-01
  pw(20)= 0.46759819486523129479791042090399526D-01
  pw(21)= 0.54090403179921190709407057449782309D-01
  pw(22)= 0.62607156912964304588823654347725686D-01
  pw(23)= 0.72496411785130069944054386511386143D-01
  pw(24)= 0.83972854815470973907373202544753383D-01
  pw(25)= 0.97284192841846608857881098157165865D-01
  pw(26)= 0.11271649103721755058596361082284142D+00
  pw(27)= 0.13060031219247571052268358514865611D+00
  pw(28)= 0.15131781797811823631871970343701060D+00
  pw(29)= 0.17531103556726408969705872673699634D+00
  pw(30)= 0.20309154904134215752202092778295388D+00
  pw(31)= 0.23525195397891395078569762059044835D+00
  pw(32)= 0.27247952854009146289412622775860388D+00
  pw(33)= 0.31557274490479512420214647476118810D+00
  pw(34)= 0.36546150205090068791751615370418030D+00
  pw(35)= 0.42323235431744446559543345018447882D+00
  pw(36)= 0.49016062156217930068156275755723687D+00
  pw(37)= 0.56775223265564612092706940030068368D+00
  pw(38)= 0.65779970939872780221136201150769308D+00
  pw(39)= 0.76245925865498574135551621597788489D+00
  pw(40)= 0.88436027001142532199927186614862192D+00
  pw(41)= 0.10267660753266581074365019471728486D+01
  pw(42)= 0.11938185471963720076518527335025432D+01
  pw(43)= 0.13909252171844327541246452342529830D+01
  pw(44)= 0.16254001662180292675140925291992103D+01
  pw(45)= 0.19075834129441296076092154965785291D+01
  pw(46)= 0.22529303361525593567401491175421270D+01
  pw(47)= 0.26862617892200971765670039600369766D+01
  pw(48)= 0.32514778994133779406256785815727141D+01
  pw(49)= 0.40378220858095016239167419409137174D+01
  pw(50)= 0.52726701882528895779137444037618021D+01
  pw(51)= 0.78744042074131644922750515876542347D+01
endif
if(kn == 52) then
  px( 1)= 0.27287878963778979318704099764976979D-03
  px( 2)= 0.14411589143135589309910830756029883D-02
  px( 3)= 0.35568888680936775757132750276695479D-02
  px( 4)= 0.66448808369926751816655531142947976D-02
  px( 5)= 0.10741535203421646235306609286779033D-01
  px( 6)= 0.15896548124765745985567116234974430D-01
  px( 7)= 0.22174792928607557748215031029525379D-01
  px( 8)= 0.29658745389012720604963104746455902D-01
  px( 9)= 0.38451550078535438960644609304592703D-01
  px(10)= 0.48680802154773981897502480211717432D-01
  px(11)= 0.60503099784552369897160088385145451D-01
  px(12)= 0.74109391214600302911242894598461603D-01
  px(13)= 0.89731100249233358933686871661989877D-01
  px(14)= 0.10764697753584156876969725074282997D+00
  px(15)= 0.12819061301398605430851761152295284D+00
  px(16)= 0.15175857698395808054368327545045674D+00
  px(17)= 0.17881924018609623916197948354619579D+00
  px(18)= 0.20992244196465392763256291141326856D+00
  px(19)= 0.24571029757551810503161176844891960D+00
  px(20)= 0.28692952833595684927481466342699473D+00
  px(21)= 0.33444574647578471028054731992057917D+00
  px(22)= 0.38926013793139080772351691924522347D+00
  px(23)= 0.45252898276941636881394275842894023D+00
  px(24)= 0.52558645699160000314972991962565110D+00
  px(25)= 0.60997118585865879765197048254341330D+00
  px(26)= 0.70745707342364955349644867464416164D+00
  px(27)= 0.82008901627275511415852311384357046D+00
  px(28)= 0.95022422122473475017786104441461093D+00
  px(29)= 0.11005799888944176702824780847485411D+01
  px(30)= 0.12742890037078181125625630187828027D+01
  px(31)= 0.14749633979156047676958663456164965D+01
  px(32)= 0.17067691516542664863528589999065341D+01
  px(33)= 0.19745127831074488312044849464771686D+01
  px(34)= 0.22837428183447160072986023000468876D+01
  px(35)= 0.26408692804764055817543358579323038D+01
  px(36)= 0.30533055131576702465080896333143573D+01
  px(37)= 0.35296382295469342100204889068765045D+01
  px(38)= 0.40798340368281393790208425276818839D+01
  px(39)= 0.47154942919829600315975357986809138D+01
  px(40)= 0.54501757769677042873771351203731296D+01
  px(41)= 0.62998036929575447450649046764701569D+01
  px(42)= 0.72832182898545812637798931719272845D+01
  px(43)= 0.84229216047310103819935078476256484D+01
  px(44)= 0.97461351851146406033204591955381092D+01
  px(45)= 0.11286361832018459964955857919026558D+02
  px(46)= 0.13085805530780086242892657357654051D+02
  px(47)= 0.15199343565107891341827069072222156D+02
  px(48)= 0.17701530875675334700619075035054618D+02
  px(49)= 0.20700169445006682515691632852528091D+02
  px(50)= 0.24366312928914848142376439425799257D+02
  px(51)= 0.29015743374923417716784066471530138D+02
  px(52)= 0.35433676271462821390664880501380081D+02
  pw( 1)= 0.70067921248512656450750262380470989D-03
  pw( 2)= 0.16387221028734144344416061643064582D-02
  pw( 3)= 0.25968227302892772688118502909161922D-02
  pw( 4)= 0.35852033221618217540588075672036645D-02
  pw( 5)= 0.46163571334057459414651619546435755D-02
  pw( 6)= 0.57044407177542779516540853577376776D-02
  pw( 7)= 0.68657439258466701284209801337979038D-02
  pw( 8)= 0.81192888642852760066695573485214022D-02
  pw( 9)= 0.94875105621027290016976460295608743D-02
  pw(10)= 0.10997004127430955685924352255220372D-01
  pw(11)= 0.12679313613778005716132640549939369D-01
  pw(12)= 0.14571725519850453422967526162847044D-01
  pw(13)= 0.16718025683719221072849622604121732D-01
  pw(14)= 0.19169191632602931509237238888017571D-01
  pw(15)= 0.21984027773632325146538486813698425D-01
  pw(16)= 0.25229801526425832500489421276402268D-01
  pw(17)= 0.28982985579859711073310312330962579D-01
  pw(18)= 0.33330232727989722055601631534296414D-01
  pw(19)= 0.38369695026986305327273292677722862D-01
  pw(20)= 0.44212758195453754037273486501473222D-01
  pw(21)= 0.50986218113528798819802588773272107D-01
  pw(22)= 0.58834899219859082186151202608595314D-01
  pw(23)= 0.67924711805560266218170048520749527D-01
  pw(24)= 0.78446161793212774417972991998090425D-01
  pw(25)= 0.90618353089338093281832862102708959D-01
  pw(26)= 0.10469355154807580861182066828267783D+00
  pw(27)= 0.12096240801949377693281668581524884D+00
  pw(28)= 0.13975996681192581185584791335037507D+00
  pw(29)= 0.16147261854647111561641477797041919D+00
  pw(30)= 0.18654619771836799217214159212739546D+00
  pw(31)= 0.21549548172910307786548214775429476D+00
  pw(32)= 0.24891542853693721010435838752243091D+00
  pw(33)= 0.28749460731095023155833868404490821D+00
  pw(34)= 0.33203145035164386811290281590906319D+00
  pw(35)= 0.38345421620808062938143753495150014D+00
  pw(36)= 0.44284595340052667020006768746408026D+00
  pw(37)= 0.51147637334768443075077758376770258D+00
  pw(38)= 0.59084351705391666304914198628651331D+00
  pw(39)= 0.68272966822652633355509618616923460D+00
  pw(40)= 0.78927854268555272214405511831212374D+00
  pw(41)= 0.91310513570381533776392939171880649D+00
  pw(42)= 0.10574572006171471782817226512789618D+01
  pw(43)= 0.12264611065174215544931924431769419D+01
  pw(44)= 0.14255110268002246494143307711209540D+01
  pw(45)= 0.16619131890762190850734830449377183D+01
  pw(46)= 0.19460108584649183568553387986228161D+01
  pw(47)= 0.22932836878593317486878267058034769D+01
  pw(48)= 0.27286173208169332405445956554845995D+01
  pw(49)= 0.32960612083291505532244371231002347D+01
  pw(50)= 0.40852129572893008083223241182607456D+01
  pw(51)= 0.53244443718708726283429813785502501D+01
  pw(52)= 0.79364763274033460235909669710486787D+01
endif
if(kn == 53) then
  px( 1)= 0.26766570337770727528170071246520492D-03
  px( 2)= 0.14134994888717316196512141359660423D-02
  px( 3)= 0.34880516519107403970758408932728686D-02
  px( 4)= 0.65147144546990128201893001657184119D-02
  px( 5)= 0.10527738385818098548917273507385571D-01
  px( 6)= 0.15573804518451021912970981414950172D-01
  px( 7)= 0.21713726252830234938777297490158659D-01
  px( 8)= 0.29024636763636674603190500526652300D-01
  px( 9)= 0.37602750842526664184644761079770188D-01
  px(10)= 0.47566769031392334409003814047662918D-01
  px(11)= 0.59061976687480610814082596844534784D-01
  px(12)= 0.72265065129161553717681820608077034D-01
  px(13)= 0.87389667514901234333023139285043850D-01
  px(14)= 0.10469256811716735138855696367380459D+00
  px(15)= 0.12448052659100388617653071564391793D+00
  px(16)= 0.14711767656647036665309334227739246D+00
  px(17)= 0.17303351979129595018460716414084922D+00
  px(18)= 0.20273163525968242510069482779745799D+00
  px(19)= 0.23679933260205764383581082765297944D+00
  px(20)= 0.27591857089423386003627193488624766D+00
  px(21)= 0.32087851933017891678519245554349762D+00
  px(22)= 0.37259015544714682612264560035248998D+00
  px(23)= 0.43210329558213462840685308411772863D+00
  px(24)= 0.50062645115169427006331566594320087D+00
  px(25)= 0.57954991863929172590111454477122563D+00
  px(26)= 0.67047254853929904297053555520671948D+00
  px(27)= 0.77523270078396767247020251586833006D+00
  px(28)= 0.89594398099521297070364552635590329D+00
  px(29)= 0.10350364637633983911134434941276054D+01
  px(30)= 0.11953042494029295972874450876803876D+01
  px(31)= 0.13799603766985451495079757379930050D+01
  px(32)= 0.15927003388200029769046949954648636D+01
  px(33)= 0.18377757429440148519213952318668567D+01
  px(34)= 0.21200800469036983170430724963400520D+01
  px(35)= 0.24452488452376621255574183769872919D+01
  px(36)= 0.28197779343346462148849901776278631D+01
  px(37)= 0.32511634739679835132078134711319616D+01
  px(38)= 0.37480701572008120067601493824866792D+01
  px(39)= 0.43205356864545827578744429205984365D+01
  px(40)= 0.49802234963192223418120333779580923D+01
  px(41)= 0.57407413466949074338019856932754499D+01
  px(42)= 0.66180524896462577279982649502155498D+01
  px(43)= 0.76310210235736203134564527928377033D+01
  px(44)= 0.88021583399572758584848067436385530D+01
  px(45)= 0.10158682176971824690390966321630474D+02
  px(46)= 0.11734082305033337839638441179290729D+02
  px(47)= 0.13570548670500422261838718291627263D+02
  px(48)= 0.15722959067717953266995872699981198D+02
  px(49)= 0.18265912835593835999181449267925846D+02
  px(50)= 0.21307358846087134932506642776378880D+02
  px(51)= 0.25018732302848078195180809407087663D+02
  px(52)= 0.29716799310767845023829953456809187D+02
  px(53)= 0.36189883296712405656605145166567620D+02
  pw( 1)= 0.68727895311546056672417632556060663D-03
  pw( 2)= 0.16070919274300689247610198780862261D-02
  pw( 3)= 0.25458627429238886643700982329323737D-02
  pw( 4)= 0.35131488282427671750845547282299960D-02
  pw( 5)= 0.45206512132016346669133873690489887D-02
  pw( 6)= 0.55815803493477684696883612785461534D-02
  pw( 7)= 0.67110727810055987477008256080221629D-02
  pw( 8)= 0.79267274337364857488746447630284210D-02
  pw( 9)= 0.92492158987355566092832344937099689D-02
  pw(10)= 0.10702954335651349887056984538693118D-01
  pw(11)= 0.12316817159979657159477748940914048D-01
  pw(12)= 0.14124861608422353998695630535116428D-01
  pw(13)= 0.16167026688242225669124227980203198D-01
  pw(14)= 0.18489777850309322975434696546792003D-01
  pw(15)= 0.21146695079329887928180449259296579D-01
  pw(16)= 0.24199043898015304232347701717858443D-01
  pw(17)= 0.27716412274949780256699383093693372D-01
  pw(18)= 0.31777522531875989191876025347365721D-01
  pw(19)= 0.36471323604726302437811675512366006D-01
  pw(20)= 0.41898438814168148316223242028468085D-01
  pw(21)= 0.48173004736710585958446082731843080D-01
  pw(22)= 0.55424906910282799399495351801946886D-01
  pw(23)= 0.63802408146079784845031445360740918D-01
  pw(24)= 0.73475174123291445512755683573657914D-01
  pw(25)= 0.84637721415891914195614185274215305D-01
  pw(26)= 0.97513337772431529356043555523731762D-01
  pw(27)= 0.11235854926743224508497153739859653D+00
  pw(28)= 0.12946823338997306958433565807904794D+00
  pw(29)= 0.14918150326264123120255847449750618D+00
  pw(30)= 0.17188851951158054500285261747356087D+00
  pw(31)= 0.19803842749441616169319688491554627D+00
  pw(32)= 0.22814867480320173542334621460640035D+00
  pw(33)= 0.26281604587933027973782593098613157D+00
  pw(34)= 0.30272987012943215567370818850475517D+00
  pw(35)= 0.34868803701893003485156344297085159D+00
  pw(36)= 0.40161671758475143724478782201274920D+00
  pw(37)= 0.46259509691660897469854774936577795D+00
  pw(38)= 0.53288704858998218510998379047232847D+00
  pw(39)= 0.61398266720080789199956346065784397D+00
  pw(40)= 0.70765415497287477021582999321525042D+00
  pw(41)= 0.81603315079286754570846341816085723D+00
  pw(42)= 0.94172096259934976721215747985393842D+00
  pw(43)= 0.10879507869255648374416119995114567D+01
  pw(44)= 0.12588348263164235013060998002290594D+01
  pw(45)= 0.14597555182997943253538598754860232D+01
  pw(46)= 0.16980130743144824162948847512548702D+01
  pw(47)= 0.19839559340047588104729344306844787D+01
  pw(48)= 0.23330898446405588037915551380406672D+01
  pw(49)= 0.27703666290115585782188239169095417D+01
  pw(50)= 0.33399854209196729287026099030910255D+01
  pw(51)= 0.41318959182038353492816091595673578D+01
  pw(52)= 0.53754564214506164841297568531690314D+01
  pw(53)= 0.79976793171584998097855897868836215D+01
endif
if(kn == 54) then
  px( 1)= 0.26264930117348429139290996151281804D-03
  px( 2)= 0.13868906738912660879236605780496720D-02
  px( 3)= 0.34218609389365101881877496771598208D-02
  px( 4)= 0.63896402666404078488978957960735342D-02
  px( 5)= 0.10322496845387460828947292469844905D-01
  px( 6)= 0.15264338738352449380895430335814458D-01
  px( 7)= 0.21272256455056810596723516130341971D-01
  px( 8)= 0.28418500058997028295178690126035519D-01
  px( 9)= 0.36792971921502915811121828397263107D-01
  px(10)= 0.46506297013822420204383294802715589D-01
  px(11)= 0.57693520466708188814704660142883650D-01
  px(12)= 0.70518461365129452425223403139712676D-01
  px(13)= 0.85178722402024364366080809274553805D-01
  px(14)= 0.10191132396313916367597436543864246D+00
  px(15)= 0.12099891148146303511007328280200670D+00
  px(16)= 0.14277649208960370764126858545635037D+00
  px(17)= 0.16763870128060588007507633768412165D+00
  px(18)= 0.19604767989373694212165892917330544D+00
  px(19)= 0.22854173844903711798992185084177464D+00
  px(20)= 0.26574507414867220998786541508194950D+00
  px(21)= 0.30837886575038189865518112878881341D+00
  px(22)= 0.35727409810156122358477142059464743D+00
  px(23)= 0.41338647141242328011007195602712556D+00
  px(24)= 0.47781374735909608618161123128437916D+00
  px(25)= 0.55181589013188334829869817262449587D+00
  px(26)= 0.63683838468354892203676383796234712D+00
  px(27)= 0.73453915990617498625433330235628987D+00
  px(28)= 0.84681961134902351472977037719948889D+00
  px(29)= 0.97586030619425103922072317930864173D+00
  px(30)= 0.11241620640819289778534857523108689D+01
  px(31)= 0.12945932455227004001780815602771556D+01
  px(32)= 0.14904442534576446040956072788546865D+01
  px(33)= 0.17154904765677712078499252639933687D+01
  px(34)= 0.19740651959466252026766816200100743D+01
  px(35)= 0.22711443710983615908928413364407126D+01
  px(36)= 0.26124457644974208978288838251819154D+01
  px(37)= 0.30045456290378285221329470833486270D+01
  px(38)= 0.34550172827009750892780305838794194D+01
  px(39)= 0.39725975078115629937328151923773107D+01
  px(40)= 0.45673891239659119753724152909459628D+01
  px(41)= 0.52511117619579365605498903719507942D+01
  px(42)= 0.60374185967841005869825918871706947D+01
  px(43)= 0.69423059418930191122711841795147301D+01
  px(44)= 0.79846576055279832356713682899398131D+01
  px(45)= 0.91869913294368492995853064476380612D+01
  px(46)= 0.10576519438659101773107722114056823D+02
  px(47)= 0.12186718685254033866362337537527451D+02
  px(48)= 0.14059766727898227283287996455084238D+02
  px(49)= 0.16250545334714196738451761057164415D+02
  px(50)= 0.18833703150856317701270861469808901D+02
  px(51)= 0.21917341606064316865260155485126217D+02
  px(52)= 0.25673282302478359060862571209297198D+02
  px(53)= 0.30419275213506007788817412536110986D+02
  px(54)= 0.36946729449797287732704130194371723D+02
  pw( 1)= 0.67438506760335604670255898997892204D-03
  pw( 2)= 0.15766730795758068292367252096595575D-02
  pw( 3)= 0.24969010052497357618191188751223522D-02
  pw( 4)= 0.34440151585437669876044394575278031D-02
  pw( 5)= 0.44289906416819842278218395665719176D-02
  pw( 6)= 0.54641754472827296169646638159218540D-02
  pw( 7)= 0.65636602656678083773300472655876417D-02
  pw( 8)= 0.77437596216345299454674361542457447D-02
  pw( 9)= 0.90235600454359303552602178356724465D-02
  pw(10)= 0.10425525098028000202217706397525802D-01
  pw(11)= 0.11976141415278903324803398081755125D-01
  pw(12)= 0.13706580129463991816022845593243222D-01
  pw(13)= 0.15653341765432086164765180782288484D-01
  pw(14)= 0.17858856637993859978963097726835278D-01
  pw(15)= 0.20372031993532375434976430093094102D-01
  pw(16)= 0.23248770947110602095264163700609205D-01
  pw(17)= 0.26552527146765384924391807859062013D-01
  pw(18)= 0.30354987338193146683949319082938468D-01
  pw(19)= 0.34736978572221172926784909895879575D-01
  pw(20)= 0.39789676392153673565656352708108709D-01
  pw(21)= 0.45616156632160377923066059864692116D-01
  pw(22)= 0.52333303181858472447283586460111768D-01
  pw(23)= 0.60074068936523280823710913114576385D-01
  pw(24)= 0.68990089360969502777474092821797731D-01
  pw(25)= 0.79254662793149992222714102849062817D-01
  pw(26)= 0.91066132125499050058268572358948574D-01
  pw(27)= 0.10465172413589772775444532528313942D+00
  pw(28)= 0.12027192389960804141840562034167157D+00
  pw(29)= 0.13822548329913942877038198233392259D+00
  pw(30)= 0.15885518710020893698686679081438881D+00
  pw(31)= 0.18255453080015552034691247423767820D+00
  pw(32)= 0.20977550590982571093431208426850228D+00
  pw(33)= 0.24103774649612254567565390373246475D+00
  pw(34)= 0.27693937431815337409878200394680401D+00
  pw(35)= 0.31817000170668241587144774061721975D+00
  pw(36)= 0.36552653149467718606906358503261169D+00
  pw(37)= 0.41993266332639492829188554992634159D+00
  pw(38)= 0.48246342603227571148223509952223773D+00
  pw(39)= 0.55437668888757955166034857478955110D+00
  pw(40)= 0.63715459820483206603034925190427611D+00
  pw(41)= 0.73255947628580611457525194256778522D+00
  pw(42)= 0.84271132620425470830602701627255624D+00
  pw(43)= 0.97019847802255398271823872088809738D+00
  pw(44)= 0.11182405648635278467279403261340421D+01
  pw(45)= 0.12909368955309583178279432436240182D+01
  pw(46)= 0.14936596913948188663729129981816013D+01
  pw(47)= 0.17337048448489904526596452227676677D+01
  pw(48)= 0.20214277264670434357889736680445585D+01
  pw(49)= 0.23723618064324051170579931680799604D+01
  pw(50)= 0.28115262822357354520836275890201874D+01
  pw(51)= 0.33832701615264074051804266553052254D+01
  pw(52)= 0.41778930411553237976334045242367218D+01
  pw(53)= 0.54257303561036728308093456793849096D+01
  pw(54)= 0.80580396891998440461864612470334815D+01
endif
if(kn == 55) then
  px( 1)= 0.25781894164194012434309377930977151D-03
  px( 2)= 0.13612751031594850206775668181403743D-02
  px( 3)= 0.33581698458852455723214904600493989D-02
  px( 4)= 0.62693690413467873882583513720977616D-02
  px( 5)= 0.10125310136665687971355854015542415D-01
  px( 6)= 0.14967346351298576942771412456996075D-01
  px( 7)= 0.20849147888131304033053596047200679D-01
  px( 8)= 0.27838492572990899694403556585128016D-01
  px( 9)= 0.36019520279673976527480271121267550D-01
  px(10)= 0.45495507499439646885138144349015201D-01
  px(11)= 0.56392208694907062019327988961512485D-01
  px(12)= 0.68861794220674272839206633722494427D-01
  px(13)= 0.83087389784370585294971502938757785D-01
  px(14)= 0.99288194535557030324060332733237417D-01
  px(15)= 0.11772513411433556959001042015562167D+00
  px(16)= 0.13870700468575135671370372276360989D+00
  px(17)= 0.16259709487800222734179448321576442D+00
  px(18)= 0.18982033572772041366926851284912359D+00
  px(19)= 0.22087111215348614429940107012361562D+00
  px(20)= 0.25632195206452177680013231303976781D+00
  px(21)= 0.29683337125272468206259039405023979D+00
  px(22)= 0.34316518501958180617486163242847902D+00
  px(23)= 0.39618960592837583486273888758703435D+00
  px(24)= 0.45690644457913117767731277056887464D+00
  px(25)= 0.52646073119585672648955063711186170D+00
  px(26)= 0.60616309005755762712921556869139875D+00
  px(27)= 0.69751323092341496562260118366147217D+00
  px(28)= 0.80222697243582393516449526286850739D+00
  px(29)= 0.92226728168578278287496843309443837D+00
  px(30)= 0.10598799021605760545446954338407357D+01
  px(31)= 0.12176342516911872309482334694729854D+01
  px(32)= 0.13984704081792695653834769855727069D+01
  px(33)= 0.16057531729310064020228982054108760D+01
  px(34)= 0.18433344234846220454903450952844757D+01
  px(35)= 0.21156252611660201772094982169604363D+01
  px(36)= 0.24276798551755632926179359953601148D+01
  px(37)= 0.27852934330452205314765679671405731D+01
  px(38)= 0.31951176405057028717258322130425570D+01
  px(39)= 0.36647976062397870566073557102018905D+01
  px(40)= 0.42031366779907243753664331178612278D+01
  px(41)= 0.48202972331234718143106561639280279D+01
  px(42)= 0.55280496786915488679928146699422870D+01
  px(43)= 0.63400875319084531166198158934082316D+01
  px(44)= 0.72724356766190935880980645516629891D+01
  px(45)= 0.83439939737765991151533907320407321D+01
  px(46)= 0.95772839454414406682247983833388953D+01
  px(47)= 0.10999511253155353900722704602341888D+02
  px(48)= 0.12644139881765944224874013113714956D+02
  px(49)= 0.14553337047736742937007375682160668D+02
  px(50)= 0.16781991883653111960448246164544552D+02
  px(51)= 0.19404807001908978674636447631480543D+02
  px(52)= 0.22530041649957455873120088574563768D+02
  px(53)= 0.26329908156600549662558562174411129D+02
  px(54)= 0.31123139662609753954221361691834122D+02
  px(55)= 0.37704208661211514525413812039019937D+02
  pw( 1)= 0.66197010017150176035001943503791612D-03
  pw( 2)= 0.15473986838973462236228078334406893D-02
  pw( 3)= 0.24498237063923531340555158367628164D-02
  pw( 4)= 0.33776287859319922812719456819175282D-02
  pw( 5)= 0.43411225775038708068974684768107364D-02
  pw( 6)= 0.53518651954260805354105863317050609D-02
  pw( 7)= 0.64229967432330231179415055321225939D-02
  pw( 8)= 0.75696698103592431759756449888418760D-02
  pw( 9)= 0.88095427367590507023412664390713554D-02
  pw(10)= 0.10163325161348951569439668089332658D-01
  pw(11)= 0.11655363240567140813674097334911855D-01
  pw(12)= 0.13314243348515058027067949270881268D-01
  pw(13)= 0.15173386635166955733192695121243376D-01
  pw(14)= 0.17271608028279645041513857207256865D-01
  pw(15)= 0.19653626901657341159725115198646941D-01
  pw(16)= 0.22370543498465587594423534082963911D-01
  pw(17)= 0.25480329057857957803698239091828550D-01
  pw(18)= 0.29048405984491612079844523910580431D-01
  pw(19)= 0.33148404854392620654285014862228099D-01
  pw(20)= 0.37863173170688566168679168381831541D-01
  pw(21)= 0.43286083546221674152033551748574709D-01
  pw(22)= 0.49522660152701866580552473522264330D-01
  pw(23)= 0.56692523854953065740425656620598762D-01
  pw(24)= 0.64931653102898776070657891627893174D-01
  pw(25)= 0.74394966967471873327666467149784361D-01
  pw(26)= 0.85259253137910454276787766290602372D-01
  pw(27)= 0.97726482395605256876361711073457773D-01
  pw(28)= 0.11202756962445724523518796251371951D+00
  pw(29)= 0.12842665975742201914453661139337216D+00
  pw(30)= 0.14722603673926230968313687924515801D+00
  pw(31)= 0.16877177710790063461389831494800560D+00
  pw(32)= 0.19346030041623174522759333491248744D+00
  pw(33)= 0.22174601068744206398277053899636196D+00
  pw(34)= 0.25415028231904386989193251104458640D+00
  pw(35)= 0.29127212894662705701804000206750184D+00
  pw(36)= 0.33380101778748297671825708760982179D+00
  pw(37)= 0.38253247505964083905642476699352139D+00
  pw(38)= 0.43838740189609651989190850364739389D+00
  pw(39)= 0.50243643541811971842045067743697266D+00
  pw(40)= 0.57593132895181935261643585397322053D+00
  pw(41)= 0.66034632680141149455034526996759720D+00
  pw(42)= 0.75743410948623930877746056875550536D+00
  pw(43)= 0.86930350487407763483137649785144665D+00
  pw(44)= 0.99853057127864209173395623916848905D+00
  pw(45)= 0.11483223403291556759761625679375804D+01
  pw(46)= 0.13227664361633706905774477225292859D+01
  pw(47)= 0.15272262858299299746420952422140745D+01
  pw(48)= 0.17689950292216856169402049903686857D+01
  pw(49)= 0.20584365667376688423615789562990280D+01
  pw(50)= 0.24111135465716154769717216299933567D+01
  pw(51)= 0.28521135641444982391089026540840319D+01
  pw(52)= 0.34259355468040848187361378226527105D+01
  pw(53)= 0.42232267265008794416077388243344182D+01
  pw(54)= 0.54752904412621487070917591943555763D+01
  pw(55)= 0.81175842524558588852537391429064074D+01
endif
if(kn == 56) then
  px( 1)= 0.25316296361047986979222704481695825D-03
  px( 2)= 0.13365901075979378376059799633963547D-02
  px( 3)= 0.32968187867088652972746128579161298D-02
  px( 4)= 0.61535889280423947494589016534393146D-02
  px( 5)= 0.99356438145931069871255487366443905D-02
  px( 6)= 0.14681977810167156277573501598213788D-01
  px( 7)= 0.20443111678193472909091734497338465D-01
  px( 8)= 0.27282717458052044439797443722558727D-01
  px( 9)= 0.35279661237909244138393562138044293D-01
  px(10)= 0.44530515113621224893066466054989604D-01
  px(11)= 0.55152581833421451048846493819641517D-01
  px(12)= 0.67287461982589797279652325494947566D-01
  px(13)= 0.81105172698463510127775615113455155D-01
  px(14)= 0.96808802192712951405093425956382214D-01
  px(15)= 0.11463966370426778674305108921559686D+00
  px(16)= 0.13488290707039924587391549901601733D+00
  px(17)= 0.15787356616502069558695735577341045D+00
  px(18)= 0.18400306948311470201893098688372094D+00
  px(19)= 0.21372631172205091315476055948506776D+00
  px(20)= 0.24756945964825417876144186941921348D+00
  px(21)= 0.28613872754179262008712244069824825D+00
  px(22)= 0.33013039508573925156714087895320715D+00
  px(23)= 0.38034235430595768392206349401494352D+00
  px(24)= 0.43768747182717257038476928803614522D+00
  px(25)= 0.50320905100551354990170632643254963D+00
  px(26)= 0.57809868566859133942855647933251305D+00
  px(27)= 0.66371681885395609603081291900385610D+00
  px(28)= 0.76161635782113158520389067408690172D+00
  px(29)= 0.87356975058892174416448481275277481D+00
  px(30)= 0.10015999992219932485646137689436440D+01
  px(31)= 0.11480161722880751230648197166792158D+01
  px(32)= 0.13154540866711925408169656894558134D+01
  px(33)= 0.15069229633419957830339656064577451D+01
  px(34)= 0.17258590324121035302982461790011709D+01
  px(35)= 0.19761872844199233411044622815807802D+01
  px(36)= 0.22623928590392104330658026022941003D+01
  px(37)= 0.25896039617088162412729887555211206D+01
  px(38)= 0.29636887519045083121995707405502705D+01
  px(39)= 0.33913694283389338916129064504517107D+01
  px(40)= 0.38803578612346352983211862453492671D+01
  px(41)= 0.44395187703404766581147350250334258D+01
  px(42)= 0.50790689079212912344545291525845662D+01
  px(43)= 0.58108244499131239038620507188960897D+01
  px(44)= 0.66485146168191270558987216454001789D+01
  px(45)= 0.76081888077726672589265324613407006D+01
  px(46)= 0.87087596930040374091019857045701857D+01
  px(47)= 0.99727503684543062151028368853863376D+01
  px(48)= 0.11427358864753300284154140246256655D+02
  px(49)= 0.13106036822460464759217266858454354D+02
  px(50)= 0.15050942893772414274408031537252686D+02
  px(51)= 0.17316976836533264840463009058352564D+02
  px(52)= 0.19978899582721245916009884455806908D+02
  px(53)= 0.23145132959066649402957025145184967D+02
  px(54)= 0.26988283646585129742188842153188599D+02
  px(55)= 0.31828066291287360025547176837209814D+02
  px(56)= 0.38461992963555384952401394913962473D+02
  pw( 1)= 0.65000398579028612344523107765589882D-03
  pw( 2)= 0.15191959531332206241117313092588598D-02
  pw( 3)= 0.24045082453807306790230685497814259D-02
  pw( 4)= 0.33138053120687689905848031561566419D-02
  pw( 5)= 0.42567825727886822265204218213429885D-02
  pw( 6)= 0.52442786039205566768969009014580993D-02
  pw( 7)= 0.62885672143814305898041140071920990D-02
  pw( 8)= 0.74037469337422375540169840316881048D-02
  pw( 9)= 0.86061856387838724696966695518776445D-02
  pw(10)= 0.99150131408851259539215604893253718D-02
  pw(11)= 0.11352651712245621514495559004367745D-01
  pw(12)= 0.12945367107597103270871461076597819D-01
  pw(13)= 0.14723816350026995714384635716386299D-01
  pw(14)= 0.16723567921281172025119870508991203D-01
  pw(15)= 0.18985579339702223096072943965050960D-01
  pw(16)= 0.21556638092713088509079450535846802D-01
  pw(17)= 0.24489800737865776493594940653820355D-01
  pw(18)= 0.27844892154300886517220254607831059D-01
  pw(19)= 0.31689141187091977270960955143508341D-01
  pw(20)= 0.36098024102012043921594821940947720D-01
  pw(21)= 0.41156366531808391430233301214909888D-01
  pw(22)= 0.46959728529751547723837911521797776D-01
  pw(23)= 0.53616077334483042468992867566071648D-01
  pw(24)= 0.61247744777900280040241146591130434D-01
  pw(25)= 0.69993670734405775857440933512557351D-01
  pw(26)= 0.80011946473114843210018552446024989D-01
  pw(27)= 0.91482687623385083454637087474649108D-01
  pw(28)= 0.10461128275712219242263696233465467D+00
  pw(29)= 0.11963207950030344698937570198730592D+00
  pw(30)= 0.13681258639855890430946376814155933D+00
  pw(31)= 0.15645828725394505928296678986188780D+00
  pw(32)= 0.17891818774495993299205732107037433D+00
  pw(33)= 0.20459124493705478925339465025762632D+00
  pw(34)= 0.23393387292296502681950858384393993D+00
  pw(35)= 0.26746877815837016930288816174815801D+00
  pw(36)= 0.30579546472966641872754674677137451D+00
  pw(37)= 0.34960287592590148622876766322786034D+00
  pw(38)= 0.39968482435244330897498051519252302D+00
  pw(39)= 0.45695914023983362115797429164759424D+00
  pw(40)= 0.52249188739719558018523893289646747D+00
  pw(41)= 0.59752864128661802876559766037133258D+00
  pw(42)= 0.68353583227497725169589493456556878D+00
  pw(43)= 0.78225676673770165676669761907089189D+00
  pw(44)= 0.89578957040518890914540096033762699D+00
  pw(45)= 0.10266987265790718339050961200134187D+01
  pw(46)= 0.11781795916828648269313771182072094D+01
  pw(47)= 0.13543092491251640404184331203718613D+01
  pw(48)= 0.15604436574176829660651085498995850D+01
  pw(49)= 0.18038746446191042006169647129755746D+01
  pw(50)= 0.20949760879837258079028998605170623D+01
  pw(51)= 0.24493410971001376006947638889013500D+01
  pw(52)= 0.28921265037563651103311910556760302D+01
  pw(53)= 0.34679810059374950896183058369361721D+01
  pw(54)= 0.42678969880522956032021408252168488D+01
  pw(55)= 0.55241361350341697933563283440847313D+01
  pw(56)= 0.81763098024027352046055737635386992D+01
endif
if(kn == 57) then
  px( 1)= 0.24868815335455860789772463829278776D-03
  px( 2)= 0.13128708050967756872359979837581267D-02
  px( 3)= 0.32378911411275754242453920014506796D-02
  px( 4)= 0.60424464389102377765134145508034116D-02
  px( 5)= 0.97537140744139523885808398942622953D-02
  px( 6)= 0.14408512776948249945597359956767419D-01
  px( 7)= 0.20054465803924087173957630667856565D-01
  px( 8)= 0.26751478412571506944557766303264093D-01
  px( 9)= 0.34573592603908669936189665703461548D-01
  px(10)= 0.43611265799596486187161513111221049D-01
  px(11)= 0.53974113832253153451922084032312655D-01
  px(12)= 0.65794147604388044446693612420778637D-01
  px(13)= 0.79229515286929499370440341287450519D-01
  px(14)= 0.94468740236461490024906772241244278D-01
  px(15)= 0.11173542497728950196695294189711635D+00
  px(16)= 0.13129338283356472153949413479135588D+00
  px(17)= 0.15345217055234222351399145423334369D+00
  px(18)= 0.17857303240016059517363555848698504D+00
  px(19)= 0.20707532489301037480311227730726369D+00
  px(20)= 0.23944355888568364571611377084388653D+00
  px(21)= 0.27623525598764641501713800314236035D+00
  px(22)= 0.31808985711331926597193028676339348D+00
  px(23)= 0.36573893965362420393418300064924317D+00
  px(24)= 0.42001800250816678509315665005653842D+00
  px(25)= 0.48188007571772045658000477338572683D+00
  px(26)= 0.55241141366947723712332135298933352D+00
  px(27)= 0.63284954422789175567060868091083275D+00
  px(28)= 0.72460397335389008193055638126809504D+00
  px(29)= 0.82927988618893103652768340546531032D+00
  px(30)= 0.94870524097232991512519332944115950D+00
  px(31)= 0.10849617219948828718866932170405878D+01
  px(32)= 0.12404201040143688064542721435857076D+01
  px(33)= 0.14177806871234317057617629235375845D+01
  px(34)= 0.16201195944991234133183611776590787D+01
  px(35)= 0.18509418957597958737177594237457576D+01
  px(36)= 0.21142427406807205051181553190404025D+01
  px(37)= 0.24145779838341929681853920899859986D+01
  px(38)= 0.27571461831926801287738694538112624D+01
  px(39)= 0.31478844142641227801141212544520951D+01
  px(40)= 0.35935811310102033845744816463442230D+01
  px(41)= 0.41020104413877221957804467425939289D+01
  px(42)= 0.46820938302391253474628239056559849D+01
  px(43)= 0.53440978451440606526835982001965101D+01
  px(44)= 0.60998800348958771477889866745643881D+01
  px(45)= 0.69632012890426281929489833882602384D+01
  px(46)= 0.79501320435284778078392913107490947D+01
  px(47)= 0.90795950558462101790938546852706470D+01
  px(48)= 0.10374113225206633587054123726355172D+02
  px(49)= 0.11860876304821553920803819021800250D+02
  px(50)= 0.13573324197835825157192895761042269D+02
  px(51)= 0.15553608911071130591094968547049722D+02
  px(52)= 0.17856644009398398334027651945364308D+02
  px(53)= 0.20557252972621646881571546529989799D+02
  px(54)= 0.23764024975150934121434317734353805D+02
  px(55)= 0.27649965226105594436613117812938989D+02
  px(56)= 0.32535770450738589606101398766605691D+02
  px(57)= 0.39221977092927801982893352173282336D+02
  pw( 1)= 0.63850406831505099738052476325581961D-03
  pw( 2)= 0.14921037986204782494894229786059731D-02
  pw( 3)= 0.23610114029305975624758426308210372D-02
  pw( 4)= 0.32526128541318438561754430100405078D-02
  pw( 5)= 0.41760397770836242676248541207424580D-02
  pw( 6)= 0.51414703399848581702756105177606384D-02
  pw( 7)= 0.61603891216042467763280301070012439D-02
  pw( 8)= 0.72459385496994110627368996655782062D-02
  pw( 9)= 0.84133204261124725154997593044037002D-02
  pw(10)= 0.96802413566072434418561861828501851D-02
  pw(11)= 0.11067394131957919015201993364016383D-01
  pw(12)= 0.12598960733898038415484720369114255D-01
  pw(13)= 0.14303116690973784728070109566032249D-01
  pw(14)= 0.16212514694032192842344075317239116D-01
  pw(15)= 0.18364731480288355645565506966903663D-01
  pw(16)= 0.20802678116001007719911702716244623D-01
  pw(17)= 0.23574997949263392825181094032890825D-01
  pw(18)= 0.26736501608313518430082020410358951D-01
  pw(19)= 0.30348704821972667356360038317766333D-01
  pw(20)= 0.34480535573107543829081934087773551D-01
  pw(21)= 0.39209262449594068155056630028607624D-01
  pw(22)= 0.44621673558809258382775767008026743D-01
  pw(23)= 0.50815515123079612189194336850658426D-01
  pw(24)= 0.57901188015516540741960287519003280D-01
  pw(25)= 0.66003700690181420273674403867109883D-01
  pw(26)= 0.75264885586780504125481386653660311D-01
  pw(27)= 0.85845899110248805481309245561278484D-01
  pw(28)= 0.97930039537017286368934956545788095D-01
  pw(29)= 0.11172593126446497910307506265827343D+00
  pw(30)= 0.12747113783580932628750351291841410D+00
  pw(31)= 0.14543628129357976189998302298577329D+00
  pw(32)= 0.16592976340385132601117576239709225D+00
  pw(33)= 0.18930320741347600799686592812399379D+00
  pw(34)= 0.21595777019635163082254656264589623D+00
  pw(35)= 0.24635151796681218166031807821910603D+00
  pw(36)= 0.28100812005137097745126867432418044D+00
  pw(37)= 0.32052720324236309080623061527301095D+00
  pw(38)= 0.36559683724134186969654741198617812D+00
  pw(39)= 0.41700881002095348086483260374822063D+00
  pw(40)= 0.47567763253365164936264867132129384D+00
  pw(41)= 0.54266463607013432598384544728159736D+00
  pw(42)= 0.61920917583183104118650977432015768D+00
  pw(43)= 0.70676996963437778493319526328106689D+00
  pw(44)= 0.80708121914722438188398403384545040D+00
  pw(45)= 0.92223080476089922545257576125601390D+00
  pw(46)= 0.10547722906765838946076024117162519D+01
  pw(47)= 0.12078902142342952742295563718452734D+01
  pw(48)= 0.13856521611695241681852077225258712D+01
  pw(49)= 0.15934078194682780100598346033527563D+01
  pw(50)= 0.18384490024798631769423787694389017D+01
  pw(51)= 0.21311608735825934018647767200886737D+01
  pw(52)= 0.24871681932345592025950623054739285D+01
  pw(53)= 0.29316978875123326489119117358318389D+01
  pw(54)= 0.35095485536224900059615141531182325D+01
  pw(55)= 0.43120561559297553662108510075135951D+01
  pw(56)= 0.55724340409598520094151224510004002D+01
  pw(57)= 0.82344141971751154156256216589492573D+01
endif
if(kn == 58) then
  px( 1)= 0.24434033394451184831332088274972614D-03
  px( 2)= 0.12898297855758084794990735012824795D-02
  px( 3)= 0.31806717757901164181366233077269143D-02
  px( 4)= 0.59345896357739671411939250656689172D-02
  px( 5)= 0.95773007935647589740131510133326933D-02
  px( 6)= 0.14143599916031750336288464659818307D-01
  px( 7)= 0.19678421471099466334328004427638463D-01
  px( 8)= 0.26238185206866063929609421458766724D-01
  px( 9)= 0.33892482730395244265993385655932016D-01
  px(10)= 0.42726147636423146495787112568669502D-01
  px(11)= 0.52841746547136186264664886791106024D-01
  px(12)= 0.64362519550464307152961734809637400D-01
  px(13)= 0.77435783944099717432445083945677444D-01
  px(14)= 0.92236796334736021064525541096205779D-01
  px(15)= 0.10897304960833762497368263739776640D+00
  px(16)= 0.12788897058127535161532867316020021D+00
  px(17)= 0.14927098966869470910429970787632708D+00
  px(18)= 0.17345298118495822795560109857844673D+00
  px(19)= 0.20082212068477187733619503336787526D+00
  px(20)= 0.23182526492157509727427115110610957D+00
  px(21)= 0.26697601677385238610408934208835716D+00
  px(22)= 0.30686267976111180750915583977482233D+00
  px(23)= 0.35215732947079012938113786105805915D+00
  px(24)= 0.40362623554087235036623549904310772D+00
  px(25)= 0.46214186627722416843651050017300999D+00
  px(26)= 0.52869670779772405928275015906498196D+00
  px(27)= 0.60441913758500942132872353014906915D+00
  px(28)= 0.69059161190173186977923080505129435D+00
  px(29)= 0.78867145852021566336079167775472318D+00
  px(30)= 0.90031461037842010940804732183197484D+00
  px(31)= 0.10274026720013124888351576363117054D+01
  px(32)= 0.11720737797358867139870870772361403D+01
  px(33)= 0.13367578014779413237552856365102921D+01
  px(34)= 0.15242165260123579138727083350791305D+01
  px(35)= 0.17375896232753198202855353912673167D+01
  px(36)= 0.19804473251817493601350778629165516D+01
  px(37)= 0.22568509975250307614430520806868566D+01
  px(38)= 0.25714230695306034625372310347575688D+01
  px(39)= 0.29294281925088078526353597436284922D+01
  px(40)= 0.33368680628505624786084197643705525D+01
  px(41)= 0.38005931431891197468681483744664603D+01
  px(42)= 0.43284356654318541562597981524559705D+01
  px(43)= 0.49293699827199698643746537542247355D+01
  px(44)= 0.56137088447382837752405108085311518D+01
  px(45)= 0.63933479763797142778167198658680473D+01
  px(46)= 0.72820772388702724076103924229296585D+01
  px(47)= 0.82959860217191960273479806666773572D+01
  px(48)= 0.94540058246887833757920831704609262D+01
  px(49)= 0.10778658868884060967669218732823142D+02
  px(50)= 0.12297127123681394967235226888868496D+02
  px(51)= 0.14042840296906789602475373898648457D+02
  px(52)= 0.16057946341424185599637733181299734D+02
  px(53)= 0.18397376144609008660129440553886667D+02
  px(54)= 0.21136019829441359432294268771943368D+02
  px(55)= 0.24382637830465314053970048093781607D+02
  px(56)= 0.28310635883229105824662724848457888D+02
  px(57)= 0.33241688156491882652244516947157465D+02
  px(58)= 0.39979324854730350560380760310991567D+02
  pw( 1)= 0.62733109048409588703595816867276199D-03
  pw( 2)= 0.14657936036557848053358560746138226D-02
  pw( 3)= 0.23188039412803108240913072658971970D-02
  pw( 4)= 0.31933033503497732665912080929284740D-02
  pw( 5)= 0.40979006451946182384357721499095629D-02
  pw( 6)= 0.50421643688026695837303498584333168D-02
  pw( 7)= 0.60368540232012649771110859344923619D-02
  pw( 8)= 0.70942376382161779284891095459836907D-02
  pw( 9)= 0.82284548942576416691892667668446138D-02
  pw(10)= 0.94559203825706345816982076964964040D-02
  pw(11)= 0.10795760712764688238988523701079555D-01
  pw(12)= 0.12270273749594030379848145803872545D-01
  pw(13)= 0.13905392767905254997074541953428596D-01
  pw(14)= 0.15731135789435791324224040917880572D-01
  pw(15)= 0.17782024053941809054144110879593548D-01
  pw(16)= 0.20097465728382493095345225347477278D-01
  pw(17)= 0.22722120795621834323838288686748639D-01
  pw(18)= 0.25706285556264310174964040630928441D-01
  pw(19)= 0.29106352315788903005352971189456581D-01
  pw(20)= 0.32985404610440883148326461811537831D-01
  pw(21)= 0.37413999049710482757623335110546207D-01
  pw(22)= 0.42471166374810272031277917315265662D-01
  pw(23)= 0.48245645122530704885901911499992297D-01
  pw(24)= 0.54837348649234653699497897577026759D-01
  pw(25)= 0.62359063229977042722185054531332040D-01
  pw(26)= 0.70938380290334218998361325437647613D-01
  pw(27)= 0.80719876243549163356586986213036934D-01
  pw(28)= 0.91867565718926819665093909060870324D-01
  pw(29)= 0.10456766632576442199326583277715739D+00
  pw(30)= 0.11903172509910440103985964305294291D+00
  pw(31)= 0.13550016907993941758980848856857065D+00
  pw(32)= 0.15424635639536902570179058036488656D+00
  pw(33)= 0.17558122145590420153365262455970893D+00
  pw(34)= 0.19985863067967063227542616526431877D+00
  pw(35)= 0.22748159641691842637396351126311924D+00
  pw(36)= 0.25890954059680923306019616384762021D+00
  pw(37)= 0.29466686202428234212246962384893466D+00
  pw(38)= 0.33535315105334115324523894344163479D+00
  pw(39)= 0.38165552584862205474730474843490408D+00
  pw(40)= 0.43436375602075320325783351993460999D+00
  pw(41)= 0.49438912403001643077208212506747590D+00
  pw(42)= 0.56278840340808053436660241948913705D+00
  pw(43)= 0.64079498868817746739885701660482042D+00
  pw(44)= 0.72986023375748618090030528388862540D+00
  pw(45)= 0.83170968157393847753518524949795654D+00
  pw(46)= 0.94842152201009860199494152865552426D+00
  pw(47)= 0.10825390752513919957077425880259437D+01
  pw(48)= 0.12372368612987946539691608858506276D+01
  pw(49)= 0.14165738915071239610049524678978730D+01
  pw(50)= 0.16258946038408501735019290717589660D+01
  pw(51)= 0.18724918616166796018089411475069718D+01
  pw(52)= 0.21667631278657422335640585222239716D+01
  pw(53)= 0.25243656135025940850141001255242091D+01
  pw(54)= 0.29705966338517197699939016107637128D+01
  pw(55)= 0.35504038802739003258026682341550974D+01
  pw(56)= 0.43554634619204172726228503521716960D+01
  pw(57)= 0.56199288682781632030749398177962085D+01
  pw(58)= 0.82915991164603216241594990786246181D+01
endif
if(kn == 59) then
  px( 1)= 0.24017044279779292814629839617243450D-03
  px( 2)= 0.12677357311318245204340430050679257D-02
  px( 3)= 0.31258222629100185940076720172210997D-02
  px( 4)= 0.58312499497336295459920293987796347D-02
  px( 5)= 0.94083841957770971773603088185375410D-02
  px( 6)= 0.13890148671899779318807930205580027D-01
  px( 7)= 0.19318997801708323654202530335822085D-01
  px( 8)= 0.25748144263471581820366574897844328D-01
  px( 9)= 0.33243095406506599413902998194831696D-01
  px(10)= 0.41883537206821979634762367168491752D-01
  px(11)= 0.51765600230040784734413248495245234D-01
  px(12)= 0.63004534953194280528857501029401263D-01
  px(13)= 0.75737811688489614503254126944665394D-01
  px(14)= 0.90128644081599828866050645306435530D-01
  px(15)= 0.10636991817245456656640674998882425D+00
  px(16)= 0.12468849734796975917708256298381635D+00
  px(17)= 0.14534987449428730815870543082646967D+00
  px(18)= 0.16866316194781867947963273417414352D+00
  px(19)= 0.19498644807014926777480289949553731D+00
  px(20)= 0.22473260025151679743882657221256944D+00
  px(21)= 0.25837564665252656619516749971741362D+00
  px(22)= 0.29645791158221640514428954276611043D+00
  px(23)= 0.33959810551825596456611237045554791D+00
  px(24)= 0.38850058094912455808801515111809716D+00
  px(25)= 0.44396596557949377138507728624091020D+00
  px(26)= 0.50690338304849533824426898328468191D+00
  px(27)= 0.57834447492359249583873987633512907D+00
  px(28)= 0.65945945037149605268093152551109157D+00
  px(29)= 0.75157541311753698549281538653947915D+00
  px(30)= 0.85619724923675556880411715666490139D+00
  px(31)= 0.97503140385009140556694003085244755D+00
  px(32)= 0.11100129303358947930559321811557219D+01
  px(33)= 0.12633362636366230834317390982154572D+01
  px(34)= 0.14374902524376435821063430688457459D+01
  px(35)= 0.16352980880451859683554892839580029D+01
  px(36)= 0.18599628978969427131632789868222316D+01
  px(37)= 0.21151199396574527695286927569279424D+01
  px(38)= 0.24048965537486799801854034104807364D+01
  px(39)= 0.27339813311614543030519151016136162D+01
  px(40)= 0.31077043634013766751037593199231006D+01
  px(41)= 0.35321310127538594381872851430342547D+01
  px(42)= 0.40141724497033117837380156117688880D+01
  px(43)= 0.45617173671065324231220714157123560D+01
  px(44)= 0.51837909802502262421170872012101186D+01
  px(45)= 0.58907499495757681122761284245660513D+01
  px(46)= 0.66945256944244027786731357744463874D+01
  px(47)= 0.76089345000234897625689957165319158D+01
  px(48)= 0.86500822381865882984046085645261005D+01
  px(49)= 0.98369069052844445818188741380057179D+01
  px(50)= 0.11191928172141132463081500916511436D+02
  px(51)= 0.12742318869317979750127012420299866D+02
  px(52)= 0.14521497812382557030759980660881216D+02
  px(53)= 0.16571609002403235432729979108495388D+02
  px(54)= 0.18947601696583022289134197021834890D+02
  px(55)= 0.21724434819141199485567406823338980D+02
  px(56)= 0.25011043569653595241704228425344735D+02
  px(57)= 0.28981239539754668238717062448027987D+02
  px(58)= 0.33957682861442574052880069059391550D+02
  px(59)= 0.40746915059614258028591599305878563D+02
  pw( 1)= 0.61661580843002818474199774713820435D-03
  pw( 2)= 0.14405704070514471179034636856714158D-02
  pw( 3)= 0.22783669060606481294489644369246025D-02
  pw( 4)= 0.31365358110962922351769249715961996D-02
  pw( 5)= 0.40232040175153947001508790877931979D-02
  pw( 6)= 0.49473803193663214737587320055863858D-02
  pw( 7)= 0.59191612038299517714653169073172258D-02
  pw( 8)= 0.69500182956008661963671339567494311D-02
  pw( 9)= 0.80531272876872073780988243944927837D-02
  pw(10)= 0.92437335233207542919233267694815444D-02
  pw(11)= 0.10539549268603537847804050413706850D-01
  pw(12)= 0.11961173126551657822377551429583253D-01
  pw(13)= 0.13532517058206043238763114996607351D-01
  pw(14)= 0.15281223576152454708908655408040014D-01
  pw(15)= 0.17239057603729693052163344051819092D-01
  pw(16)= 0.19442266458961476989325558184455495D-01
  pw(17)= 0.21931917469546401944382556564398834D-01
  pw(18)= 0.24754242433746641427431268228835038D-01
  pw(19)= 0.27961035103797151420897993567315053D-01
  pw(20)= 0.31610155514745908523448651363558848D-01
  pw(21)= 0.35766190345276654301560678957468317D-01
  pw(22)= 0.40501304167252803397704165063681030D-01
  pw(23)= 0.45896299064297235092911388363815978D-01
  pw(24)= 0.52041886574768681501627601462919698D-01
  pw(25)= 0.59040170127350183777203679746281117D-01
  pw(26)= 0.67006338167425270345951219198202241D-01
  pw(27)= 0.76070575665505304542628473598135760D-01
  pw(28)= 0.86380211831507007368019890251542642D-01
  pw(29)= 0.98102132636666032695755579145966437D-01
  pw(30)= 0.11142549737101106673605436812360518D+00
  pw(31)= 0.12656480912918894407887994146661412D+00
  pw(32)= 0.14376340063800550321586640229070301D+00
  pw(33)= 0.16329741041010875411766070944591531D+00
  pw(34)= 0.18548034139204283612129505343431894D+00
  pw(35)= 0.21066831722133520869183148142544999D+00
  pw(36)= 0.23926618297652114852711313447455029D+00
  pw(37)= 0.27173464220061857023595757633130234D+00
  pw(38)= 0.30859868602838502541227655874922030D+00
  pw(39)= 0.35045766213824028933896241045941680D+00
  pw(40)= 0.39799746405898883695366965337609207D+00
  pw(41)= 0.45200551538659797325171404962194440D+00
  pw(42)= 0.51338951072222608042425293298227461D+00
  pw(43)= 0.58320130681121704145811176462102830D+00
  pw(44)= 0.66266801682533587367291708503855157D+00
  pw(45)= 0.75323338727944523148159051268884834D+00
  pw(46)= 0.85661417022141803759749168951905898D+00
  pw(47)= 0.97487886818484736512715176832767718D+00
  pw(48)= 0.11105607080548591676445817081025167D+01
  pw(49)= 0.12668244926674778382406916781590943D+01
  pw(50)= 0.14477211050240886139248358867709201D+01
  pw(51)= 0.16585903209293941982874152551002654D+01
  pw(52)= 0.19067267819120553533052269878705101D+01
  pw(53)= 0.22025411213234530205031685493395576D+01
  pw(54)= 0.25617240229328119031730477599209231D+01
  pw(55)= 0.30096444005352699081587070335073080D+01
  pw(56)= 0.35914005587611010508966597641663763D+01
  pw(57)= 0.43990110029151586972435889347654638D+01
  pw(58)= 0.56675740145564914236518411943414860D+01
  pw(59)= 0.83489730609712306624049954354151761D+01
endif
end subroutine wts500
end MODULE WTS500_MOD
