#############################################################
##                                                         ##
## Copyright (c) 2003-2013 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################
"""
Defines the L{TriangulatedSurface} class.
"""
from esys.lsm.vis import core
from modifier import Modifiable

class TriangulatedSurface(core.TriangulatedSurface, Modifiable):
    def __init__(self, nodeSequence, faceSequence):
        core.TriangulatedSurface.__init__(self, nodeSequence, faceSequence)
        Modifiable.__init__(self)

    def writeSdl(self, f):
        f.write("mesh2 {\n")
        f.write("  vertex_vectors {\n")
        f.write("    %s" % len(self.nodeSequence))
        for node in self.nodeSequence:
            f.write(",\n    <%s,%s,%s>" % tuple(node))
        f.write("\n  }\n")
        f.write("  face_indices {\n")
        f.write("    %s" % len(self.faceSequence))
        for face in self.faceSequence:
            f.write(",\n    <%s,%s,%s>" % tuple(face))
        f.write("\n  }\n")
        Modifiable.writeSdl(self, f)
        f.write("}")


