/*
 * --- GSMP-COPYRIGHT-NOTE-BEGIN ---
 * 
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * Please add additional copyright information _after_ the line containing
 * the GSMP-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
 * the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
 * 
 * GSMP: utility/include/File.hh
 * General Sound Manipulation Program is Copyright (C) 2000 - 2004
 *   Valentin Ziegler and Ren Rebe
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2. A copy of the GNU General
 * Public License can be found in the file LICENSE.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
 * ABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * --- GSMP-COPYRIGHT-NOTE-END ---
 */

/* Short Description:
 *   A simple POSIX file abstraction.
 */

#ifndef UTILITY__FILE_HH__
#define UTILITY__FILE_HH__

#include <sys/stat.h>

#include <string>

namespace Utility
{
  
  class FileType
  {
  private:
    int type;
    
  public:
    FileType (int i_type = 0) {type = i_type;}
    
    const FileType& operator= (int n_type) {type = n_type; return *this;}
    
    bool IsUnknown () const {return (type & S_IFMT) == 0;}
    bool IsFile () const {return S_ISREG(type);}
    bool IsDirectory () const {return S_ISDIR(type);}
    bool IsCharDevice () const {return S_ISCHR(type);}
    bool IsBlockDevice () const {return S_ISBLK(type);}
    bool IsFIFO () const {return S_ISFIFO(type);}
    bool IsSymlink () const {return S_ISLNK(type);}
    bool IsSocket () const {return S_ISSOCK(type);}
  };
  
  /* this is some wrapping around the (ugly) posix directory stuff
     not really a perfectly crafted object */
  class File
  {
  public:
    File ();
    File (const std::string& str);
    ~File ();
    
    void SetFile (const std::string& str);

    const std::string& Dirname ();
    const std::string& Basename ();
    std::string BasenameWOExtension ();
    const std::string& Extension ();
    
    const FileType Type ();
    
    const std::string Name () const {
      return filename;
    }
    
    // more to be done on demand
    
 private:
  
    inline bool updateStat ();
    void updateDirBaseExt ();
    
    void reset ();
    
    std::string filename;
    std::string dirname; // just cached
    std::string basename; // just cached
    std::string extension; // just cached
    
    struct stat c_stat;
    bool c_stat_valid;
  };
  
  std::ostream& operator<< (std::ostream& os, const File& file);

} // namespace Utility

#endif // UTILITY__FILE_HH__
