/************************************************************************
**
**  Copyright (C) 2010  Strahinja Markovic
**
**  This file is part of FlightCrew.
**
**  FlightCrew is free software: you can redistribute it and/or modify
**  it under the terms of the GNU Lesser General Public License as published
**  by the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  FlightCrew is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU Lesser General Public License for more details.
**
**  You should have received a copy of the GNU Lesser General Public License
**  along with FlightCrew.  If not, see <http://www.gnu.org/licenses/>.
**
*************************************************************************/

#include <stdafx.h>

/*
   (Part of the) Open Publication Structure (OPS) 2.0.1 v1.0, XSD
   (only houses the <switch>, <case> and <default> elements)
   
   Specification: http://www.idpf.org/doc_library/epub/OPS_2.0.1_draft.htm

   Namespace: http://www.idpf.org/2007/ops
   
   Created by hand.
   
 */

namespace FlightCrew
{

const char*         OPS_SWITCH_XSD_ID  = "ops_switch.xsd";
const unsigned int  OPS_SWITCH_XSD_LEN = 1504;
const unsigned char OPS_SWITCH_XSD[]   = {
  0x3c, 0x3f, 0x78, 0x6d, 0x6c, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x31, 0x2e, 0x30, 0x22, 0x20, 0x65, 0x6e, 0x63, 0x6f,
  0x64, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x55, 0x54, 0x46, 0x2d, 0x38, 0x22,
  0x3f, 0x3e, 0x0d, 0x0a, 0x3c, 0x78, 0x73, 0x3a, 0x73, 0x63, 0x68, 0x65,
  0x6d, 0x61, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x3a, 0x78, 0x73, 0x3d,
  0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
  0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x32, 0x30, 0x30, 0x31, 0x2f,
  0x58, 0x4d, 0x4c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x20, 0x78,
  0x6d, 0x6c, 0x6e, 0x73, 0x3a, 0x6f, 0x70, 0x73, 0x3d, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x69, 0x64, 0x70,
  0x66, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x32, 0x30, 0x30, 0x37, 0x2f, 0x6f,
  0x70, 0x73, 0x22, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x3a, 0x78, 0x68,
  0x74, 0x6d, 0x6c, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x31,
  0x39, 0x39, 0x39, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20, 0x74,
  0x61, 0x72, 0x67, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
  0x63, 0x65, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77,
  0x77, 0x77, 0x2e, 0x69, 0x64, 0x70, 0x66, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
  0x32, 0x30, 0x30, 0x37, 0x2f, 0x6f, 0x70, 0x73, 0x22, 0x20, 0x65, 0x6c,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x66,
  0x61, 0x75, 0x6c, 0x74, 0x3d, 0x22, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66,
  0x69, 0x65, 0x64, 0x22, 0x3e, 0x0d, 0x0a, 0x09, 0x3c, 0x78, 0x73, 0x3a,
  0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73,
  0x70, 0x61, 0x63, 0x65, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
  0x31, 0x39, 0x39, 0x39, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20,
  0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x3d, 0x22, 0x6f, 0x70, 0x73, 0x32, 0x30, 0x31, 0x2e, 0x78,
  0x73, 0x64, 0x22, 0x2f, 0x3e, 0x0d, 0x0a, 0x09, 0x3c, 0x78, 0x73, 0x3a,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x22, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x22, 0x3e, 0x0d, 0x0a,
  0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c,
  0x78, 0x73, 0x3a, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e,
  0x0d, 0x0a, 0x09, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x65, 0x6c,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x6f,
  0x70, 0x73, 0x3a, 0x63, 0x61, 0x73, 0x65, 0x22, 0x20, 0x6d, 0x61, 0x78,
  0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x22, 0x75, 0x6e, 0x62, 0x6f,
  0x75, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x2f, 0x3e, 0x0d, 0x0a, 0x09, 0x09,
  0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x6f, 0x70, 0x73, 0x3a, 0x64,
  0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x22, 0x2f, 0x3e, 0x0d, 0x0a, 0x09,
  0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x63, 0x65, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73,
  0x3a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x69, 0x64, 0x22, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x78, 0x73, 0x3a, 0x49, 0x44, 0x22, 0x2f, 0x3e, 0x0d,
  0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0d, 0x0a, 0x09, 0x3c,
  0x2f, 0x78, 0x73, 0x3a, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3e,
  0x0d, 0x0a, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x65, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x63, 0x61, 0x73,
  0x65, 0x22, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x61,
  0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a,
  0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x64, 0x6f, 0x63, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x6e, 0x79, 0x74, 0x68,
  0x69, 0x6e, 0x67, 0x20, 0x67, 0x6f, 0x65, 0x73, 0x2e, 0x0d, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x64, 0x6f,
  0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e,
  0x0d, 0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x61, 0x6e, 0x6e,
  0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a, 0x09, 0x09,
  0x3c, 0x78, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54,
  0x79, 0x70, 0x65, 0x20, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x3d, 0x22, 0x74,
  0x72, 0x75, 0x65, 0x22, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c, 0x78,
  0x73, 0x3a, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0d,
  0x0a, 0x09, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x61, 0x6e, 0x79,
  0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x73, 0x3d, 0x22, 0x6c, 0x61, 0x78, 0x22, 0x20, 0x6d,
  0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x22, 0x30, 0x22,
  0x20, 0x6d, 0x61, 0x78, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x22,
  0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x2f, 0x3e,
  0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x73, 0x65,
  0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09,
  0x3c, 0x78, 0x73, 0x3a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x69, 0x64, 0x22, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x78, 0x73, 0x3a, 0x49, 0x44, 0x22,
  0x2f, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x61,
  0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x2d,
  0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x20, 0x75,
  0x73, 0x65, 0x3d, 0x22, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
  0x22, 0x2f, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a,
  0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x22, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
  0x2d, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x2f, 0x3e, 0x0d,
  0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0d, 0x0a, 0x09, 0x3c,
  0x2f, 0x78, 0x73, 0x3a, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3e,
  0x0d, 0x0a, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x65, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x64, 0x65, 0x66,
  0x61, 0x75, 0x6c, 0x74, 0x22, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x3c, 0x78,
  0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x64, 0x6f,
  0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e,
  0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x42, 0x61,
  0x73, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x61, 0x6e, 0x79, 0x20,
  0x58, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
  0x3b, 0x20, 0x61, 0x63, 0x74, 0x73, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20,
  0x64, 0x69, 0x76, 0x2e, 0x20, 0x0d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
  0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a, 0x09, 0x09,
  0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a,
  0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x20,
  0x6d, 0x69, 0x78, 0x65, 0x64, 0x3d, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22,
  0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a, 0x63, 0x6f,
  0x6d, 0x70, 0x6c, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
  0x20, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x3d, 0x22, 0x74, 0x72, 0x75, 0x65,
  0x22, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x09, 0x3c, 0x78, 0x73, 0x3a,
  0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x62, 0x61,
  0x73, 0x65, 0x3d, 0x22, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x3a, 0x46, 0x6c,
  0x6f, 0x77, 0x22, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x09, 0x09, 0x3c,
  0x78, 0x73, 0x3a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x69, 0x64, 0x22, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x78, 0x73, 0x3a, 0x49, 0x44, 0x22, 0x2f,
  0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a,
  0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a,
  0x09, 0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3e, 0x0d,
  0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0d, 0x0a, 0x09, 0x3c,
  0x2f, 0x78, 0x73, 0x3a, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3e,
  0x0d, 0x0a, 0x3c, 0x2f, 0x78, 0x73, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x6d,
  0x61, 0x3e, 0x0d, 0x0a
};

} //namespace FlightCrew
