/*=============================================================================

    This file is part of FLINT.

    FLINT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    FLINT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FLINT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

=============================================================================*/
/******************************************************************************

    Copyright (C) 2010 William Hart
    Copyright (C) 2012 Andres Goens
    Copyright (C) 2013 Mike Hansen

******************************************************************************/


#ifdef T

#include "templates.h"

#include <stdio.h>
#include <stdlib.h>
int
main(void)
{
    int i, result;
    FLINT_TEST_INIT(state);

    flint_printf("make_monic....");
    fflush(stdout);

    /* test aliasing */
    for (i = 0; i < 100 * flint_test_multiplier(); i++)
    {

        slong len;
        TEMPLATE(T, ctx_t) ctx;

        TEMPLATE(T, poly_t) a, b;
        len = n_randint(state, 15) + 1;
        TEMPLATE(T, ctx_randtest) (ctx, state);
        TEMPLATE(T, poly_init) (a, ctx);
        TEMPLATE(T, poly_init) (b, ctx);

        TEMPLATE(T, poly_randtest_not_zero) (a, state, len, ctx);
        TEMPLATE(T, poly_make_monic) (b, a, ctx);
        TEMPLATE(T, poly_make_monic) (a, a, ctx);
        result = TEMPLATE(T, poly_equal) (a, b, ctx);
        if (!result)
        {
            flint_printf("FAIL:\n");
            flint_printf("a = "), TEMPLATE(T, poly_print_pretty) (a, "X", ctx),
                flint_printf("\n");
            flint_printf("b = "), TEMPLATE(T, poly_print_pretty) (a, "X", ctx),
                flint_printf("\n");

        }

        TEMPLATE(T, poly_clear) (a, ctx);
        TEMPLATE(T, ctx_clear) (ctx);
    }



    /* Check new leading coeff = 1 */
    for (i = 0; i < 100 * flint_test_multiplier(); i++)
    {

        slong len;
        TEMPLATE(T, ctx_t) ctx;

        TEMPLATE(T, poly_t) a;

        len = n_randint(state, 15) + 1;
        TEMPLATE(T, ctx_randtest) (ctx, state);
        TEMPLATE(T, poly_init) (a, ctx);

        TEMPLATE(T, poly_randtest_not_zero) (a, state, len, ctx);
        TEMPLATE(T, poly_make_monic) (a, a, ctx);

        result = TEMPLATE(T, is_one) (TEMPLATE(T, poly_lead) (a, ctx), ctx);
        if (!result)
        {
            flint_printf("FAIL:\n");
            flint_printf("a = "), TEMPLATE(T, poly_print_pretty) (a, "X", ctx),
                flint_printf("\n");
            flint_printf("lead ="), TEMPLATE(T,
                                             print_pretty) (TEMPLATE(T,
                                                                     poly_lead)
                                                            (a, ctx), ctx),
                flint_printf("\n");
        }

        TEMPLATE(T, poly_clear) (a, ctx);
        TEMPLATE(T, ctx_clear) (ctx);

    }

    FLINT_TEST_CLEANUP(state);
    flint_printf("PASS\n");
    return 0;
}


#endif
