/*
*
* Do not edit directly. See build-aux directory
*
*/

G_BEGIN_DECLS

#define MAX_VENDOR_ID_LENGTH 5
#define MAX_VENDOR_LENGTH 100

static const struct
{
    const gchar vendor_id[MAX_VENDOR_LENGTH];
    const gchar vendor[MAX_VENDOR_LENGTH];
}
/* Order is significant. */
NoticeData [] =
{
    /* Notice data sourced from fcfreetype.c - http://www.freetype.org/ */
    {"Bigelow", "Bigelow & Holmes"},
    {"Adobe", "Adobe"},
    {"Bitstream", "Bitstream"},
    {"Monotype", "Monotype Imaging"},
    {"Linotype", "Linotype GmbH"},
    {"LINOTYPE-HELL", "Linotype GmbH"},
    {"IBM", "IBM"},
    {"URW", "URW"},
    {"International Typeface Corporation", "ITC"},
    {"Tiro Typeworks", "Tiro Typeworks"},
    {"XFree86", "XFree86"},
    {"Microsoft", "Microsoft Corporation"},
    {"Omega", "Omega"},
    {"Font21", "Hwan"},
    {"HanYang System", "HanYang Information & Communication"}
};

static const struct
{
    const gchar vendor_id[MAX_VENDOR_ID_LENGTH];
    const gchar vendor[MAX_VENDOR_LENGTH];
}
VendorData[] =
{

    /* Various Sources */
    {"ACG", "Monotype Imaging"},
    {"B?", "Bigelow & Holmes"},
    {"FJ", "Fujitsu"},
    {"RICO", "Ricoh"},


    /* Courtesy of Microsoft Typography - http://www.microsoft.com/typography/links/vendorlist.aspx */
    {"!ETF", "!Exclamachine Type Foundry"},
    {"$pro", "CheapProFonts"},
    {"1ASC", "Ascender Corporation"},
    {"1BOU", "Boutros International"},
    {"1KTF", "Kief Type Foundry"},
    {"2DLT", "2D Typo"},
    {"2REB", "2Rebels"},
    {"39BC", "Finley's Barcode Fonts"},
    {"3ip", "Three Islands Press"},
    {"4FEB", "4th february"},
    {"5PTS", "Five Points Technology"},
    {"918", "RavenType"},
    {"A&S;", "Art&Sign; Studio"},
    {"A2", "A2-Type"},
    {"aaff", "AstroAcademia Font Foundry"},
    {"ABBO", "Arabic Dictionary Lab"},
    {"ABC", "Altek Instruments"},
    {"ABOU", "Aboutype, Inc."},
    {"ACUT", "Acute Type"},
    {"ADBE", "Adobe"},
    {"ADBO", "Adobe"},
    {"ADG", "Apply Design Group"},
    {"AE", "AE Type"},
    {"AEF", "Altered Ego Fonts"},
    {"AGFA", "Monotype Imaging (replaced by MONO)"},
    {"AID", "Artistic Imposter Design"},
    {"AJPT", "Alan Jay Prescott Typography"},
    {"AKOF", "AKOFAType"},
    {"ALFA", "Alphabets"},
    {"ALPH", "Alphameric Broadcast Solutions Limited"},
    {"ALPN", "Alpona Portal"},
    {"ALS", "Art. Lebedev Studio"},
    {"alte", "Altemus"},
    {"ALTS", "Altsys / Made with Fontographer"},
    {"AMUT", "Kwesi Amuti"},
    {"ANDO", "Osam Ando"},
    {"anty", "Anatoletype"},
    {"AOP", "an Art Of Pengwyn"},
    {"APLY", "Apply Interactive"},
    {"APOS", "Apostrophic Laboratories"},
    {"APPL", "Apple"},
    {"ARBX", "Arabetics"},
    {"ARCH", "Architext"},
    {"ARIN", "Aring Typeface AB"},
    {"ARPH", "Arphic Technology Co."},
    {"ARS", "EN ARS Ltd."},
    {"ArTy", "Archive Type"},
    {"ASL", "Abneil Software Ltd fonts"},
    {"ASSA", "astype"},
    {"ASYM", "Applied Symbols"},
    {"ATEC", "Page Technology Marketing, Inc."},
    {"ATF", "American Type Founders Collection"},
    {"ATF1", "Australian Type Foundry"},
    {"ATFS", "Andrew Tyler's fonts"},
    {"AURE", "Aure Font Design"},
    {"AUTO", "Autodidakt"},
    {"AVFF", "Agustín Varela Font Factory"},
    {"AVP", "Aviation Partners"},
    {"AZLS", "Azalea Software, Inc."},
    {"B&H;", "Bigelow & Holmes"},
    {"BARS", "CIA (BAR CODES) UK"},
    {"BASE", "Baseline Fonts"},
    {"BAT", "BUREAU DES AFFAIRES TYPOGRAPHIQUES"},
    {"BCP", "Expert Labels Ltd."},
    {"BDX", "Studio Christian Bordeaux"},
    {"BERT", "Berthold"},
    {"BITM", "Bitmap Software"},
    {"BITS", "Bitstream"},
    {"bizf", "Bizfonts.com"},
    {"BL", "Binnenland"},
    {"BLAB", "BaseLab"},
    {"BLAH", "Mister Bla's Fontworx"},
    {"BLCK", "Black Foundry"},
    {"BLI", "Blissym Language Institute"},
    {"BLV", "Bladvulling"},
    {"BOLD", "Bold Monday"},
    {"BORW", "em2 Solutions"},
    {"BOYB", "BoyBeaver Fonts"},
    {"BRDV", "BoardVantage, Inc."},
    {"BREM", "Mark Bremmer"},
    {"BROS", "Michael Brosnan"},
    {"BRTC", "ITSCO - Bar Code Fonts"},
    {"BS", "Barcodesoft"},
    {"BSYV", "Ben Syverson"},
    {"BUBU", "BUBULogix"},
    {"BWFW", "B/W Fontworks"},
    {"C&B;", "Coppers & Brasses"},
    {"C&C;", "Carter & Cone"},
    {"C&G;", "C&G; Inc."},
    {"C21", "Club 21"},
    {"CAK", "pluginfonts.com"},
    {"CAM", "Camelot Typefaces"},
    {"CANO", "Canon"},
    {"CASL", "H.W. Caslon & Company Ltd."},
    {"CATG", "CAT-Fonts Germany"},
    {"CB", "Christian Büning"},
    {"CBDO", "Borges Lettering & Design"},
    {"CDAC", "Centre for Development of Advanced Computing"},
    {"cdd", "Crazy Diamond Design"},
    {"CDFP", "VT2000 Technical Services"},
    {"CELB", "Celebrity Fontz"},
    {"CF", "Colophon Foundry"},
    {"CFA", "Computer Fonts Australia"},
    {"CFF", "Characters Font Foundry"},
    {"CJCJ", "Creative Juncture"},
    {"CKTP", "CakeType"},
    {"CLM", "Culmus Project"},
    {"CMJK", "Slanted Hall"},
    {"COMM", "Commercial Type"},
    {"CONR", "Connare.com"},
    {"COOL", "Cool Fonts"},
    {"CORD", "corduroy"},
    {"CR8", "CR8 Software Solutions"},
    {"CRRT", "Carrot Type"},
    {"CT", "CastleType"},
    {"CTDL", "China Type Designs Ltd."},
    {"CTL", "Chaitanya Type Library"},
    {"cwwf", "Computers World Wide/AC Capital Funding"},
    {"CYPE", "Club Type"},
    {"CYRE", "Cyreal"},
    {"DADA", "Dada Studio"},
    {"DAMA", "Dalton Maag Limited"},
    {"DB", "Daniel Bruce"},
    {"DBFF", "DesignBase"},
    {"DD", "Devon DeLapp"},
    {"Deco", "DecoType (replaced by DT)"},
    {"DELV", "Delve Fonts"},
    {"dezc", "Dezcom"},
    {"DFS", "Datascan Font Service Ltd"},
    {"DGL", "Digital Graphic Labs foundry"},
    {"DOM", "Dukom Design"},
    {"DS", "Dainippon Screen Mfg. Co., Inc."},
    {"DSBV", "Datascan bv"},
    {"DSCI", "Design Science Inc."},
    {"DSGN", "DizajnDesign"},
    {"DSKY", "Jacek Dziubinski"},
    {"DSSR", "Dresser Johnson"},
    {"DSST", "Dubina Nikolay"},
    {"DST", "DSType"},
    {"DSTE", "Dieste"},
    {"DT", "DecoType"},
    {"DTC", "Digital Typeface Corp."},
    {"DTF", "Dunwich Type Founders"},
    {"DTL", "Dutch Type Library"},
    {"DTPS", "DTP-Software"},
    {"dtpT", "dtpTypes Limited"},
    {"DUXB", "Duxbury Systems, Inc."},
    {"DYNA", "DynaComware"},
    {"ECAL", "ECAL Typefaces"},
    {"EDBI", "edilbiStudio"},
    {"EDGE", "Rivers Edge Corp."},
    {"EF", "Elsner+Flake"},
    {"EFF", "Electronic Font Foundry"},
    {"EFI", "Elfring Fonts Inc."},
    {"EFNT", "E Fonts L.L.C."},
    {"EFWS", "eFilm World"},
    {"EKIO", "Ekioh"},
    {"ELSE", "Elseware"},
    {"EMGR", "Emigre"},
    {"EPSN", "Epson"},
    {"ESIG", "E-Signature"},
    {"ETIO", "Ethiopian Font Foundry"},
    {"EVER", "Evertype"},
    {"FA", "FontArte Type Foundry"},
    {"FAFO", "FamiraFonts"},
    {"FAPA", "FamiljenPangea"},
    {"FAT", "Fatype"},
    {"FBI", "The Font Bureau, Inc."},
    {"FCAB", "The Font Cabinet"},
    {"FCAN", "fontage canada"},
    {"FCTP", "Facetype"},
    {"FDI", "FDI fonts.info"},
    {"FEED", "Studio Feed Inc."},
    {"FeoN", "Feòrag NìcBhrìde"},
    {"FGOD", "FontGod"},
    {"FJTY", "Frank Jonen - Illustration & Typography"},
    {"FMFO", "Fontmill Foundry"},
    {"FMST", "Formist"},
    {"FNTF", "Fontfoundry"},
    {"FoFa", "FontFabrik"},
    {"FONT", "Font Source"},
    {"FORM", "Formation Type Foundry"},
    {"FOUN", "The Foundry"},
    {"FP", "The Fontpad"},
    {"FRJN", "Frere-Jones Type"},
    {"FRML", "formlos"},
    {"FRTH", "Forthcome"},
    {"FS", "Formula Solutions"},
    {"FSE", "Font Source Europe"},
    {"FSI", "FontShop International"},
    {"FSL", "FontSurfer Ltd"},
    {"fsmi", "Fontsmith"},
    {"FTF", "Fontef"},
    {"FTFT", "FontFont"},
    {"FTGD", "Font Garden"},
    {"FTH", "For the Hearts"},
    {"FTN", "Fountain"},
    {"FTPT", "Fontpartners"},
    {"FWKS", "Fontworks"},
    {"FWRE", "Fontware Limited"},
    {"FY", "Fontyou"},
    {"GAF", "Glifo Art Fonts Inc."},
    {"GALA", "Galápagos Design Group, Inc."},
    {"GALO", "Gerald Gallo"},
    {"GARI", "Gary Ritchie"},
    {"GATF", "Greater Albion Typefounders"},
    {"GD", "GD Fonts"},
    {"GF", "GarageFonts"},
    {"GIA", "Georgian Internet Avenue"},
    {"GLCF", "GLC foundry"},
    {"GLYF", "Glyph Systems"},
    {"GNU", "Free Software Foundation, Inc."},
    {"GOAT", "Dingbat Dungeon"},
    {"GOGO", "Fonts-A-Go-Go"},
    {"GOHE", "GoHebrew, division of GoME2.com Inc."},
    {"GOOG", "Google"},
    {"GPI", "Gamma Productions, Inc."},
    {"GRAF", "Grafikarna d.o.o."},
    {"GRCR", "Graphicore"},
    {"GREY", "Greyletter"},
    {"GRIL", "Grilled cheese"},
    {"GRIM", "Legacy publishing"},
    {"grro", "grafikk RØren"},
    {"GT", "Graphity!"},
    {"GTYP", "G-Type"},
    {"H", "Hurme Design"},
    {"H&FJ;", "Hoefler & Frere-Jones"},
    {"HA", "HoboArt"},
    {"HAD", "Hoffmann Angelic Design"},
    {"HAIL", "Hail Design"},
    {"HanS", "HanStyle"},
    {"HAUS", "TypeHaus"},
    {"HEB", "Sivan Toledo"},
    {"HFJ", "Hoefler & Frere-Jones (replaced by H&FJ;)"},
    {"HIH", "HiH Retrofonts"},
    {"HILL", "Hill Systems"},
    {"HJZ", "Hans J. Zinken"},
    {"HL", "High-Logic"},
    {"HM", "Haiku Monkey"},
    {"HoP", "House of Pretty"},
    {"HOUS", "House Industries"},
    {"HP", "Hewlett-Packard"},
    {"HS", "HermesSOFT Company"},
    {"HT", "Huerta Tipográfica"},
    {"HTF", "The Hoefler Type Foundry, Inc."},
    {"HVD", "HVD Fonts GmbH"},
    {"HXTP", "Hexatype"},
    {"HY", "HanYang Information & Communication"},
    {"IBM", "IBM"},
    {"IDAU", "IDAutomation.com, Inc."},
    {"IDEA", "Glenn Campbell t/a Idea Studio"},
    {"IDEE", "IDEE TYPOGRAFICA"},
    {"IDF", "International Digital Fonts"},
    {"IFF", "Indian Font Factory"},
    {"IKOF", "IKOffice GmbH"},
    {"ILP", "Indigenous Languages Project"},
    {"IMPR", "Impress"},
    {"INGT", "Ingrimayne Type"},
    {"INRA", "INRAY Inc."},
    {"INTR", "Interstitial Entertainment"},
    {"INVC", "Invoice Central"},
    {"INVD", "TYPE INVADERS"},
    {"ISE", "ISE-Aditi Info. Pvt . Ltd."},
    {"ITC", "ITC"},
    {"ITF", "Red Rooster Collection (ITF, Inc.)"},
    {"ITFO", "Indian Type Foundry"},
    {"ITSM", "Simon Stratford"},
    {"JABM", "JAB'M Foundry"},
    {"JAF", "Just Another Foundry"},
    {"JAKE", "Jake Tilson Studio"},
    {"JBLT", "JEAN-BAPTISTE LEVÉE TYPOGRAPHY"},
    {"JDB", "Jeff Bensch"},
    {"jeff", "jeff-levine"},
    {"JF", "Jan Fromm"},
    {"JHA", "Jan Henrik Arnold"},
    {"JHF", "JH Fonts"},
    {"JP", "Jamra Patel"},
    {"JPTT", "Jeremy Tankard Typography Ltd"},
    {"JWTM", "Type Matters"},
    {"JY", "JIYUKOBO Ltd."},
    {"KATF", "Kingsley/ATF"},
    {"KBNT", "Kombinat-Typefounders"},
    {"KDW", "Kinuta Font Factory"},
    {"KF", "Karakta Fonthome"},
    {"KLIM", "Klim Typographic Design"},
    {"KLTF", "Karsten Luecke"},
    {"KNST", "Konst.ru"},
    {"KNTR", "Kontour"},
    {"KOP", "Leo Koppelkamm"},
    {"KORK", "Khork OÜ"},
    {"KOVL", "Koval Type Foundry"},
    {"KrKo", "Kreative Software"},
    {"KRND", "Karandash Type & Graphics Foundry"},
    {"KTF", "Kustomtype"},
    {"KUBA", "Kuba Tatarkiewicz"},
    {"LAIT", "la laiterie"},
    {"LANS", "Lanston Type Company"},
    {"LARA", "Larabiefonts"},
    {"LAUD", "Carolina Laudon"},
    {"LAYT", "LAYOUT SARL"},
    {"LEAF", "Interleaf, Inc."},
    {"LETR", "Letraset"},
    {"lewd", "Lettering World LLC"},
    {"LFS", "Letters from Sweden"},
    {"LGX", "Logix Research Institute, Inc."},
    {"LHF", "Letterhead Fonts"},
    {"LIND", "Lindenberg Software LLC"},
    {"LING", "Linguist's Software"},
    {"LINO", "Linotype GmbH"},
    {"LIVE", "Livedesign"},
    {"LNGU", "LangusteFonts"},
    {"LNTO", "Lineto"},
    {"LORO", "LoRo Productions"},
    {"LP", "LetterPerfect Fonts"},
    {"LT", "Le Typophage"},
    {"LTF", "Liberty Type Foundry"},
    {"Ltrm", "Lettermin type and design"},
    {"LTRX", "Lighttracks"},
    {"LTTR", "LettError"},
    {"LUD", "Ludlow"},
    {"LuFo", "LucasFonts"},
    {"LUSH", "Lush Type"},
    {"LUV", "iLUVfonts"},
    {"MACR", "Macromedia / Made with Fontographer"},
    {"MADT", "MADType"},
    {"MagD", "Magus Digital"},
    {"MANS", "Aring Typeface AB"},
    {"MAPS", "Tom Mouat's Map Symbol Fonts"},
    {"MATE", "TypeMates"},
    {"MATS", "Match Fonts"},
    {"MC", "Cerajewski Computer Consulting"},
    {"MCHL", "Michal Sahar"},
    {"MCKL", "MCKL"},
    {"MCOW", "Mountaincow"},
    {"MDSN", "Moraitis Design"},
    {"MEH", "Steve Mehallo"},
    {"MEIR", "Meir Sadan"},
    {"MESA", "FontMesa,"},
    {"MF", "Magic Fonts"},
    {"MFNT", "Masterfont"},
    {"MG", "Milieu Grotesque"},
    {"MGD", "Matt Grey Design"},
    {"MILL", "Millan"},
    {"MJ", "Majus Corporation"},
    {"MJR", "Majur Inc."},
    {"MLBU", "Malibu Dream Designs, LLC"},
    {"MLGC", "Micrologic Software"},
    {"mlss", "Mark Simonson Studio LLC"},
    {"MMFT", "Michel M."},
    {"MMIK", "Monomonnik"},
    {"MNCK", "Mine Creek"},
    {"MNKR", "Monokrom Skriftforlag AS"},
    {"MODI", "Modular Infotech Private Limited."},
    {"MOHT", "Al Mohtaraf Assaudi Ltd"},
    {"MOJI", "Mojijuku"},
    {"MONB", "Monib"},
    {"MONE", "Meta One Limited"},
    {"MONO", "Monotype Imaging"},
    {"MOON", "Moonlight Type and Technolog"},
    {"MOTA", "Mota Italic"},
    {"MRSW", "Morisawa & Company, Ltd."},
    {"MRV", "Morovia Corporation"},
    {"MS", "Microsoft Corp."},
    {"MSCH", "Guitar-Injection"},
    {"MSCR", "Majus Corporation"},
    {"MSE", "MSE-iT"},
    {"MT", "Monotype Imaging (replaced by MONO)"},
    {"MTF", "Miss Tiina Fonts"},
    {"MTY", "Motoya Co. ,LTD."},
    {"MUTF", "Murasu Systems Sdn. Bhd"},
    {"MVB", "MVB Fonts"},
    {"MVTP", "Mauve Type"},
    {"MVty", "MV Typo"},
    {"MW", "Michael Want"},
    {"MYFO", "MyFonts.com"},
    {"NB", "No Bodoni Typography"},
    {"ncnd", "&cond;"},
    {"NDCT", "Neufville Digital Corporatype"},
    {"NDTC", "Neufville Digital"},
    {"NEC", "NEC Corporation"},
    {"NEWL", "Newlyn"},
    {"NICK", "Nick's Fonts"},
    {"NIS", "NIS Corporation"},
    {"NORF", "Norfok Incredible Font Design"},
    {"NOVA", "NOVATYPE"},
    {"NP", "Nipponia"},
    {"ODSR", "Oddsorts"},
    {"OHG", "Our House Graphic Design"},
    {"OHNO", "OH no Type Company"},
    {"OKAY", "Okay Type"},
    {"OPTM", "Optimo"},
    {"OPTO", "Opto"},
    {"ORBI", "Orbit Enterprises, Inc."},
    {"ORK1", "Ork1"},
    {"OSFC", "Out Of Step Font Company"},
    {"OURT", "Ourtype"},
    {"P22", "P22 Inc."},
    {"PARA", "ParaType Inc."},
    {"PDWX", "Parsons Design Workx"},
    {"PECI", "Pecita"},
    {"PF", "Phil's Fonts, Inc."},
    {"PINT", "PintassilgoPrints"},
    {"PIXL", "Pixilate"},
    {"PKDD", "Philip Kelly Digital Design"},
    {"PLAT", "PLATINUM technology"},
    {"PRFS", "Production First Software"},
    {"PRGR", "Paragraph"},
    {"PROD", "Production Type"},
    {"PROT", "PROTOTYPO"},
    {"PRTF", "Process Type Foundry"},
    {"PSIS", "PhotoShopIsland.com"},
    {"PSY", "PSY/OPS"},
    {"PT", "Playtype APS"},
    {"PTF", "Porchez Typofonderie"},
    {"PTMI", "Page Technology Marketing, Inc."},
    {"PTYP", "preussTYPE"},
    {"PYRS", "PYRS   Fontlab Ltd. / Made with FontLab"},
    {"QMSI", "QMS/Imagen"},
    {"QRAT", "Quadrat Communications"},
    {"QTYP", "Qtypography"},
    {"READ", "ReadyType"},
    {"REAL", "Underware"},
    {"RES", "Resultat"},
    {"RJPS", "Reall Graphics"},
    {"RKFN", "R K Fonts"},
    {"RL", "Ruben Holthuijsen"},
    {"RLTF", "Rebeletter Studios"},
    {"RMU", "RMU TypeDesign"},
    {"robo", "Buro Petr van Blokland"},
    {"ROBU", "SC ROBU DESIGN S.R.L."},
    {"ROHH", "ROHH studio"},
    {"RRT", "Red Rooster Collection (ITF, Inc.)"},
    {"RSJ", "RSJ Software"},
    {"RST", "Rosetta"},
    {"RUDY", "RudynFluffy"},
    {"RYOB", "Ryobi Limited"},
    {"SAJA", "Saja Typeworks"},
    {"SALT", "Solonka Type Foundry"},
    {"SAND", "Sandoll"},
    {"SAPL", "Fonderie sans plomb"},
    {"SATY", "Samuelstype Design AB"},
    {"SAX", "s.a.x. Software gmbh"},
    {"SbB", "Sketchbook B"},
    {"SBT", "SelfBuild Type Foundry"},
    {"SCTO", "Schick Toikka"},
    {"SE", "Stéphane Elbaz"},
    {"Sean", "The FontSite"},
    {"SFS", "Sarumadhu Services Pvt. Ltd."},
    {"SFUN", "Software Union"},
    {"SG", "Scooter Graphics"},
    {"SHAM", "ShamFonts / Shamrock Int."},
    {"SHFT", "Shift"},
    {"SHOT", "Shotype"},
    {"SHRP", "Sharp Type"},
    {"SHS", "Shahab Siavash Studio"},
    {"SHUB", "The Software Hub"},
    {"SIG", "vLetter, Inc"},
    {"SIL", "SIL International (SIL)"},
    {"SIT", "Summit Information Technologies Pvt.Ltd,"},
    {"SKP", "Essqué Productions"},
    {"skz", "Celtic Lady's Fonts"},
    {"SL", "Silesian Letters"},
    {"Slab", "Schriftlabor"},
    {"SMC", "Swathanthra Malayalam Computing"},
    {"SN", "SourceNet"},
    {"SOHO", "Soft Horizons"},
    {"SOS", "Standing Ovations Software"},
    {"SPRT", "Sports Fonts"},
    {"STC", "Sorkin Type Co"},
    {"STF", "Brian Sooy & Co + Sooy Type Foundry"},
    {"Stor", "Storm Type Foundry"},
    {"STYP", "Stone Type Foundry"},
    {"SUNW", "sunwalk fontworks"},
    {"SVTD", "Synthview"},
    {"SWFT", "Swfte International"},
    {"SWTY", "Swiss Typefaces"},
    {"SXRA", "Page42 Type Foundry"},
    {"SYDA", "Shree Muktananda Ashram"},
    {"SYN", "SynFonts"},
    {"SYRC", "Syriac Computing Institute"},
    {"TBFF", "TrueBlue Font Foundry"},
    {"TC", "Typeco"},
    {"TCH", "Darryl Cook"},
    {"TD", "Typedepot"},
    {"TDR", "Tansin A. Darcos & Co."},
    {"TERM", "Terminal Design, Inc."},
    {"TF", "Treacyfaces / Headliners"},
    {"TF3D", "TattooFont3D"},
    {"TFAC", "Typefactory"},
    {"TFND", "Typefounding"},
    {"THIN", "Thinstroke Design LLC"},
    {"TILD", "Tilde, SIA"},
    {"TIMO", "Tim Romano"},
    {"TIMR", "Tim Rolands"},
    {"TIPO", "Tipo"},
    {"TIRO", "Tiro Typeworks"},
    {"TJS", "Typejockeys"},
    {"TL", "Typeland"},
    {"TLIN", "Teeline Fonts"},
    {"TMF", "The MicroFoundry"},
    {"TMT", "TypeMyType Comm. V."},
    {"TNTY", "tntypography"},
    {"TOPP", "Toppan Printing Co., Ltd."},
    {"TPDP", "Type Department"},
    {"TPMA", "typoma"},
    {"TPSP", "Type Supply"},
    {"TPTA", "TPTQ Arabic"},
    {"TPTC", "Test Pilot Collective"},
    {"TPTQ", "Typotheque"},
    {"TR", "Type Revivals"},
    {"TRAF", "Traffictype"},
    {"TREE", "Treeflow"},
    {"TS", "TamilSoft Corporation"},
    {"TSPC", "Typespec Ltd"},
    {"TSTY", "Torleiv Georg Sverdrup"},
    {"TT", "TypeTogether"},
    {"TTG", "Twardoch Typography"},
    {"TTY", "Tipotype"},
    {"TYCU", "TypeCulture"},
    {"TYFR", "typographies.fr"},
    {"TYME", "type me! Font Foundry"},
    {"TYPA", "Typadelic"},
    {"TYPE", "Type Associates Pty Ltd"},
    {"TYPO", "Typodermic"},
    {"TYPR", "Type Project"},
    {"TYRE", "typerepublic"},
    {"UA", "UnAuthorized Type"},
    {"ULA", "Montserrat Typeface"},
    {"UNDT", "ÜNDT"},
    {"URW", "URW++"},
    {"UT", "Unitype Inc"},
    {"VINT", "Vinterstille"},
    {"VJ", "eDESIGNzone"},
    {"VKP", "Vijay K. Patel"},
    {"VLKF", "Visualogik Technology & Design"},
    {"VLNL", "VetteLetters.nl"},
    {"VMT", "VMType"},
    {"VOG", "Martin Vogel"},
    {"VROM", "Vladimir Romanov"},
    {"VS", "VorSicht GmbH"},
    {"VT", "VISUALTYPE SRL"},
    {"VTF", "Velvetyne Type Foundry"},
    {"WASP", "Wasp Barcode Technologies"},
    {"WILL", "Willerstorfer Font Foundry"},
    {"WL", "Writ Large Fonts"},
    {"WM", "Webmakers India"},
    {"XFC", "Xerox Font Services"},
    {"XOTH", "Xoth Morello"},
    {"XYZ", "XYZ Type LLC"},
    {"Y&Y;", "Y&Y;, Inc."},
    {"YDS", "Yellow Design Studio"},
    {"YN", "Yanone"},
    {"YOFF", "Your Own Font Foundry"},
    {"YOKO", "Yokokaku"},
    {"YOUR", "YourFonts.com"},
    {"ZANE", "Unrender"},
    {"ZeGr", "Zebra Font Factory"},
    {"zeta", "Tangram Studio"},
    {"ZSFT", "Zsoft"},

};

#define NOTICE_ENTRIES G_N_ELEMENTS(NoticeData)
#define VENDOR_ENTRIES G_N_ELEMENTS(VendorData)

gchar * get_vendor_from_notice(const gchar *notice);
gchar * get_vendor_from_vendor_id(const gchar vendor[MAX_VENDOR_ID_LENGTH]);

G_END_DECLS

