//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: BoundaryConditionExpressionNeumann.cpp,v 1.4 2007/02/10 17:20:53 delpinux Exp $

#include <BoundaryConditionExpressionNeumann.hpp>

#include <FunctionExpression.hpp>
#include <BoundaryCondition.hpp>

#include <UnknownListExpression.hpp>

#include <Information.hpp>

#include <ScalarFunctionBase.hpp>
#include <Neumann.hpp>

std::ostream&
BoundaryConditionExpressionNeumann::
put(std::ostream& os) const
{
  os << "\t\tdnu(" << __unknownName << ") = "<< (*__g)
     << " on " << (*__boundary);
  return os;
}

void
BoundaryConditionExpressionNeumann::
execute()
{
  __boundary->execute();
  __g->execute();
  ConstReferenceCounting<ScalarFunctionBase> g = __g->function();

  ReferenceCounting<UnknownListExpression> L
    = Information::instance().getUnknownList();

  size_t n = L->number(__unknownName);

  ReferenceCounting<PDECondition> N = new Neumann(g,n);

  __boundaryCondition
      = new BoundaryCondition(N, __boundary->boundary());
}

BoundaryConditionExpressionNeumann::
BoundaryConditionExpressionNeumann(const std::string& unknownName,
				   ReferenceCounting<FunctionExpression> g,
				   ReferenceCounting<BoundaryExpression> boundary)
  : BoundaryConditionExpression(boundary,
				unknownName,
				BoundaryConditionExpression::neumann),
    __g(g)
{
  ;
}

BoundaryConditionExpressionNeumann::
BoundaryConditionExpressionNeumann(const BoundaryConditionExpressionNeumann& d)
  : BoundaryConditionExpression(d),
    __g(d.__g)
{
  ;
}

BoundaryConditionExpressionNeumann::
~BoundaryConditionExpressionNeumann()
{
  ;
}
