/* game-view.c generated by valac 0.40.0.6-2c488, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_SCOREBOARD_PROPERTY,
	GAME_VIEW_SOUND_FLIP_PROPERTY,
	GAME_VIEW_SOUND_GAMEOVER_PROPERTY,
	GAME_VIEW_GAME_PROPERTY,
	GAME_VIEW_THEME_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_PLAYER (player_get_type ())
typedef struct _Block2Data Block2Data;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	GAME_VIEW_MOVE_SIGNAL,
	GAME_VIEW_NUM_SIGNALS
};
static guint game_view_signals[GAME_VIEW_NUM_SIGNALS] = {0};

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	GtkDrawingArea* _scoreboard;
	gchar* pieces_file;
	gdouble background_red;
	gdouble background_green;
	gdouble background_blue;
	gint background_radius;
	gdouble mark_red;
	gdouble mark_green;
	gdouble mark_blue;
	gint mark_width;
	gdouble border_red;
	gdouble border_green;
	gdouble border_blue;
	gint border_width;
	gdouble spacing_red;
	gdouble spacing_green;
	gdouble spacing_blue;
	gint spacing_width;
	gdouble highlight_red;
	gdouble highlight_green;
	gdouble highlight_blue;
	gdouble highlight_alpha;
	gchar* _sound_flip;
	gchar* _sound_gameover;
	gint paving_size;
	gint tile_size;
	gint board_size;
	gboolean show_highlight;
	gint highlight_x;
	gint highlight_y;
	gint highlight_state;
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	cairo_pattern_t* scoreboard_tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gint current_player_number;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _Block2Data {
	int _ref_count_;
	GameView* self;
	gint x;
	gint y;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
#define GAME_VIEW_HIGHLIGHT_MAX 5
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
static void game_view_set_default_theme (GameView* self,
                                  GKeyFile* * key);
static void game_view_load_theme (GameView* self,
                           GKeyFile* key);
static void game_view_set_sound_flip (GameView* self,
                               const gchar* value);
static void game_view_set_sound_gameover (GameView* self,
                                   const gchar* value);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_calculate (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_size (Game* self);
static gboolean game_view_real_draw (GtkWidget* base,
                              cairo_t* cr);
static void game_view_load_image (GameView* self,
                           cairo_t* c,
                           gint width,
                           gint height);
static gint game_view_get_board_x (GameView* self);
static gint game_view_get_board_y (GameView* self);
static void game_view_rounded_square (GameView* self,
                               cairo_t* cr,
                               gdouble x,
                               gdouble y,
                               gint size,
                               gdouble width,
                               gdouble radius_percent);
gboolean game_get_is_complete (Game* self);
GType player_get_type (void) G_GNUC_CONST;
static void game_view_square_changed_cb (GameView* self,
                                  gint x,
                                  gint y,
                                  Player replacement);
static void game_view_update_square (GameView* self,
                              gint x,
                              gint y);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint game_view_get_pixmap (GameView* self,
                           Player color);
Player game_get_owner (Game* self,
                       gint x,
                       gint y);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self,
                           gint x,
                           gint y,
                           gint pixmap);
static gboolean ___lambda6_ (Block2Data* _data2_);
static gboolean ____lambda6__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base,
                                            GdkEventButton* event);
static gboolean game_view_real_key_press_event (GtkWidget* base,
                                         GdkEventKey* event);
static gboolean game_view_draw_scoreboard (GameView* self,
                                    cairo_t* cr);
static GtkDrawingArea* game_view_get_scoreboard (GameView* self);
void game_view_update_scoreboard (GameView* self);
Player game_get_current_color (Game* self);
void game_view_set_scoreboard (GameView* self,
                               GtkDrawingArea* value);
static gboolean _game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender,
                                                     cairo_t* cr,
                                                     gpointer self);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
void game_view_set_game (GameView* self,
                         Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender,
                                                       gint x,
                                                       gint y,
                                                       Player new_color,
                                                       gpointer self);
const gchar* game_view_get_theme (GameView* self);
void game_view_set_theme (GameView* self,
                          const gchar* value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void game_view_finalize (GObject * obj);
static void _vala_game_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static void
game_view_set_default_theme (GameView* self,
                             GKeyFile* * key)
{
	GtkSettings* defaults = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	gchar* filename = NULL;
	GtkSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* filepath = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*key != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	defaults = _tmp1_;
	_tmp2_ = defaults;
	g_object_get (_tmp2_, "gtk-theme-name", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = string_contains (_tmp5_, "HighContrast");
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("high_contrast.theme");
		_g_free0 (filename);
		filename = _tmp7_;
	} else {
		GtkSettings* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = defaults;
		g_object_get (_tmp8_, "gtk-application-prefer-dark-theme", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == TRUE) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("adwaita.theme");
			_g_free0 (filename);
			filename = _tmp11_;
		} else {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("classic.theme");
			_g_free0 (filename);
			filename = _tmp12_;
		}
	}
	_tmp13_ = filename;
	_tmp14_ = g_build_filename (DATA_DIRECTORY, "themes", "key", _tmp13_, NULL);
	filepath = _tmp14_;
	{
		g_key_file_load_from_file (*key, filepath, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filepath);
		_g_free0 (filename);
		_g_object_unref0 (defaults);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (filepath);
	_g_free0 (filename);
	_g_object_unref0 (defaults);
}


static void
game_view_load_theme (GameView* self,
                      GKeyFile* key)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	{
		gchar* svg_path = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gint _tmp15_ = 0;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
		gdouble _tmp18_ = 0.0;
		gint _tmp19_ = 0;
		gdouble _tmp20_ = 0.0;
		gdouble _tmp21_ = 0.0;
		gdouble _tmp22_ = 0.0;
		gint _tmp23_ = 0;
		gdouble _tmp24_ = 0.0;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
		gint _tmp27_ = 0;
		gdouble _tmp28_ = 0.0;
		gdouble _tmp29_ = 0.0;
		gdouble _tmp30_ = 0.0;
		gdouble _tmp31_ = 0.0;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		_tmp0_ = g_build_filename (DATA_DIRECTORY, "themes", "svg", NULL);
		svg_path = _tmp0_;
		_tmp2_ = g_key_file_get_string (key, "Pieces", "File", &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = svg_path;
		_tmp4_ = g_build_filename (_tmp3_, _tmp1_, NULL);
		_g_free0 (self->priv->pieces_file);
		self->priv->pieces_file = _tmp4_;
		_tmp5_ = self->priv->pieces_file;
		_tmp6_ = g_path_get_dirname (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = svg_path;
		_tmp9_ = g_strcmp0 (_tmp7_, _tmp8_) != 0;
		_g_free0 (_tmp7_);
		if (_tmp9_) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = svg_path;
			_tmp11_ = g_build_filename (_tmp10_, "black_and_white.svg", NULL);
			_g_free0 (self->priv->pieces_file);
			self->priv->pieces_file = _tmp11_;
		}
		_tmp12_ = g_key_file_get_double (key, "Background", "Red", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_red = _tmp12_;
		_tmp13_ = g_key_file_get_double (key, "Background", "Green", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_green = _tmp13_;
		_tmp14_ = g_key_file_get_double (key, "Background", "Blue", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_blue = _tmp14_;
		_tmp15_ = g_key_file_get_integer (key, "Background", "Radius", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->background_radius = _tmp15_;
		_tmp16_ = g_key_file_get_double (key, "Mark", "Red", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_red = _tmp16_;
		_tmp17_ = g_key_file_get_double (key, "Mark", "Green", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_green = _tmp17_;
		_tmp18_ = g_key_file_get_double (key, "Mark", "Blue", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_blue = _tmp18_;
		_tmp19_ = g_key_file_get_integer (key, "Mark", "Width", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->mark_width = _tmp19_;
		_tmp20_ = g_key_file_get_double (key, "Border", "Red", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_red = _tmp20_;
		_tmp21_ = g_key_file_get_double (key, "Border", "Green", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_green = _tmp21_;
		_tmp22_ = g_key_file_get_double (key, "Border", "Blue", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_blue = _tmp22_;
		_tmp23_ = g_key_file_get_integer (key, "Border", "Width", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->border_width = _tmp23_;
		_tmp24_ = g_key_file_get_double (key, "Spacing", "Red", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_red = _tmp24_;
		_tmp25_ = g_key_file_get_double (key, "Spacing", "Green", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_green = _tmp25_;
		_tmp26_ = g_key_file_get_double (key, "Spacing", "Blue", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_blue = _tmp26_;
		_tmp27_ = g_key_file_get_integer (key, "Spacing", "Width", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->spacing_width = _tmp27_;
		_tmp28_ = g_key_file_get_double (key, "Highlight", "Red", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_red = _tmp28_;
		_tmp29_ = g_key_file_get_double (key, "Highlight", "Green", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_green = _tmp29_;
		_tmp30_ = g_key_file_get_double (key, "Highlight", "Blue", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_blue = _tmp30_;
		_tmp31_ = g_key_file_get_double (key, "Highlight", "Alpha", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->highlight_alpha = _tmp31_;
		_tmp33_ = g_key_file_get_string (key, "Sound", "Flip", &_inner_error_);
		_tmp32_ = _tmp33_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		game_view_set_sound_flip (self, _tmp32_);
		_tmp35_ = g_key_file_get_string (key, "Sound", "GameOver", &_inner_error_);
		_tmp34_ = _tmp35_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp32_);
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_free0 (_tmp32_);
			_g_free0 (_tmp1_);
			_g_free0 (svg_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		game_view_set_sound_gameover (self, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp1_);
		_g_free0 (svg_path);
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_warning ("game-view.vala:226: Errors when loading theme: %s", _tmp37_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GameView*
game_view_construct (GType object_type)
{
	GameView * self = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK));
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
	return self;
}


GameView*
game_view_new (void)
{
	return game_view_construct (TYPE_GAME_VIEW);
}


static void
game_view_calculate (GameView* self)
{
	gint size = 0;
	gint _tmp0_;
	gint _tmp1_;
	Game* _tmp2_;
	Game* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	Game* _tmp9_;
	Game* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	size = MIN (gtk_widget_get_allocated_width ((GtkWidget*) self), gtk_widget_get_allocated_height ((GtkWidget*) self));
	_tmp0_ = self->priv->border_width;
	_tmp1_ = self->priv->spacing_width;
	_tmp2_ = game_view_get_game (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = game_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->paving_size = ((size - (2 * _tmp0_)) + _tmp1_) / _tmp5_;
	_tmp6_ = self->priv->paving_size;
	_tmp7_ = self->priv->spacing_width;
	self->priv->tile_size = _tmp6_ - _tmp7_;
	_tmp8_ = self->priv->paving_size;
	_tmp9_ = game_view_get_game (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = game_get_size (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->spacing_width;
	self->priv->board_size = (_tmp8_ * _tmp12_) - _tmp13_;
}


static gboolean
game_view_real_draw (GtkWidget* base,
                     cairo_t* cr)
{
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	gint _tmp34_;
	self = (GameView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	game_view_calculate (self);
	_tmp3_ = self->priv->tiles_pattern;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		guint _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->render_size;
		_tmp5_ = self->priv->tile_size;
		_tmp2_ = _tmp4_ != ((guint) _tmp5_);
	}
	if (_tmp2_) {
		gint _tmp6_;
		cairo_surface_t* surface = NULL;
		cairo_surface_t* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		cairo_surface_t* _tmp10_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp11_;
		cairo_t* _tmp12_;
		cairo_t* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		cairo_surface_t* _tmp16_;
		cairo_pattern_t* _tmp17_;
		_tmp6_ = self->priv->tile_size;
		self->priv->render_size = (guint) _tmp6_;
		_tmp7_ = cairo_get_target (cr);
		_tmp8_ = self->priv->tile_size;
		_tmp9_ = self->priv->tile_size;
		_tmp10_ = cairo_surface_create_similar (_tmp7_, CAIRO_CONTENT_COLOR_ALPHA, _tmp8_ * 8, _tmp9_ * 4);
		surface = _tmp10_;
		_tmp11_ = surface;
		_tmp12_ = cairo_create (_tmp11_);
		c = _tmp12_;
		_tmp13_ = c;
		_tmp14_ = self->priv->tile_size;
		_tmp15_ = self->priv->tile_size;
		game_view_load_image (self, _tmp13_, _tmp14_ * 8, _tmp15_ * 4);
		_tmp16_ = surface;
		_tmp17_ = cairo_pattern_create_for_surface (_tmp16_);
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
		self->priv->tiles_pattern = _tmp17_;
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
	}
	_tmp18_ = game_view_get_board_x (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = game_view_get_board_y (self);
	_tmp21_ = _tmp20_;
	cairo_translate (cr, (gdouble) _tmp19_, (gdouble) _tmp21_);
	_tmp22_ = self->priv->spacing_red;
	_tmp23_ = self->priv->spacing_green;
	_tmp24_ = self->priv->spacing_blue;
	cairo_set_source_rgba (cr, _tmp22_, _tmp23_, _tmp24_, 1.0);
	_tmp25_ = self->priv->border_width;
	_tmp26_ = self->priv->border_width;
	_tmp27_ = self->priv->board_size;
	_tmp28_ = self->priv->border_width;
	_tmp29_ = self->priv->board_size;
	_tmp30_ = self->priv->border_width;
	cairo_rectangle (cr, (-_tmp25_) / 2.0, (-_tmp26_) / 2.0, (gdouble) (_tmp27_ + _tmp28_), (gdouble) (_tmp29_ + _tmp30_));
	cairo_fill_preserve (cr);
	_tmp31_ = self->priv->border_red;
	_tmp32_ = self->priv->border_green;
	_tmp33_ = self->priv->border_blue;
	cairo_set_source_rgba (cr, _tmp31_, _tmp32_, _tmp33_, 1.0);
	_tmp34_ = self->priv->border_width;
	cairo_set_line_width (cr, (gdouble) _tmp34_);
	cairo_stroke (cr);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				gint _tmp37_;
				Game* _tmp38_;
				Game* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = x;
					x = _tmp36_ + 1;
				}
				_tmp35_ = FALSE;
				_tmp37_ = x;
				_tmp38_ = game_view_get_game (self);
				_tmp39_ = _tmp38_;
				_tmp40_ = game_get_size (_tmp39_);
				_tmp41_ = _tmp40_;
				if (!(_tmp37_ < _tmp41_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp42_ = FALSE;
						_tmp42_ = TRUE;
						while (TRUE) {
							gint _tmp44_;
							Game* _tmp45_;
							Game* _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
							gint tile_x = 0;
							gint _tmp49_;
							gint _tmp50_;
							gint tile_y = 0;
							gint _tmp51_;
							gint _tmp52_;
							gdouble _tmp53_;
							gdouble _tmp54_;
							gdouble _tmp55_;
							gint _tmp56_;
							gint _tmp57_;
							gint _tmp58_;
							gint _tmp59_;
							gboolean _tmp60_ = FALSE;
							gboolean _tmp61_ = FALSE;
							gboolean _tmp62_ = FALSE;
							gint _tmp63_;
							gint _tmp64_;
							gint* _tmp102_;
							gint _tmp102__length1;
							gint _tmp102__length2;
							gint _tmp103_;
							gint _tmp104_;
							gint _tmp105_;
							gint texture_x = 0;
							gint* _tmp106_;
							gint _tmp106__length1;
							gint _tmp106__length2;
							gint _tmp107_;
							gint _tmp108_;
							gint _tmp109_;
							gint _tmp110_;
							gint texture_y = 0;
							gint* _tmp111_;
							gint _tmp111__length1;
							gint _tmp111__length2;
							gint _tmp112_;
							gint _tmp113_;
							gint _tmp114_;
							gint _tmp115_;
							cairo_matrix_t matrix = {0};
							gint _tmp116_;
							gint _tmp117_;
							gint _tmp118_;
							gint _tmp119_;
							cairo_pattern_t* _tmp120_;
							cairo_matrix_t _tmp121_;
							cairo_pattern_t* _tmp122_;
							gint _tmp123_;
							gint _tmp124_;
							gint _tmp125_;
							gint _tmp126_;
							if (!_tmp42_) {
								gint _tmp43_;
								_tmp43_ = y;
								y = _tmp43_ + 1;
							}
							_tmp42_ = FALSE;
							_tmp44_ = y;
							_tmp45_ = game_view_get_game (self);
							_tmp46_ = _tmp45_;
							_tmp47_ = game_get_size (_tmp46_);
							_tmp48_ = _tmp47_;
							if (!(_tmp44_ < _tmp48_)) {
								break;
							}
							_tmp49_ = x;
							_tmp50_ = self->priv->paving_size;
							tile_x = _tmp49_ * _tmp50_;
							_tmp51_ = y;
							_tmp52_ = self->priv->paving_size;
							tile_y = _tmp51_ * _tmp52_;
							_tmp53_ = self->priv->background_red;
							_tmp54_ = self->priv->background_green;
							_tmp55_ = self->priv->background_blue;
							cairo_set_source_rgba (cr, _tmp53_, _tmp54_, _tmp55_, 1.0);
							_tmp56_ = tile_x;
							_tmp57_ = tile_y;
							_tmp58_ = self->priv->tile_size;
							_tmp59_ = self->priv->background_radius;
							game_view_rounded_square (self, cr, (gdouble) _tmp56_, (gdouble) _tmp57_, _tmp58_, (gdouble) 0, (gdouble) _tmp59_);
							cairo_fill (cr);
							_tmp63_ = self->priv->highlight_x;
							_tmp64_ = x;
							if (_tmp63_ == _tmp64_) {
								gint _tmp65_;
								gint _tmp66_;
								_tmp65_ = self->priv->highlight_y;
								_tmp66_ = y;
								_tmp62_ = _tmp65_ == _tmp66_;
							} else {
								_tmp62_ = FALSE;
							}
							if (_tmp62_) {
								gboolean _tmp67_ = FALSE;
								gboolean _tmp68_;
								_tmp68_ = self->priv->show_highlight;
								if (_tmp68_) {
									_tmp67_ = TRUE;
								} else {
									gint _tmp69_;
									_tmp69_ = self->priv->highlight_state;
									_tmp67_ = _tmp69_ != 0;
								}
								_tmp61_ = _tmp67_;
							} else {
								_tmp61_ = FALSE;
							}
							if (_tmp61_) {
								Game* _tmp70_;
								Game* _tmp71_;
								gboolean _tmp72_;
								gboolean _tmp73_;
								_tmp70_ = game_view_get_game (self);
								_tmp71_ = _tmp70_;
								_tmp72_ = game_get_is_complete (_tmp71_);
								_tmp73_ = _tmp72_;
								_tmp60_ = !_tmp73_;
							} else {
								_tmp60_ = FALSE;
							}
							if (_tmp60_) {
								gboolean _tmp74_ = FALSE;
								gboolean _tmp75_;
								gdouble _tmp89_;
								gdouble _tmp90_;
								gdouble _tmp91_;
								gdouble _tmp92_;
								gint _tmp93_;
								gint _tmp94_;
								gint _tmp95_;
								gint _tmp96_;
								gint _tmp97_;
								gint _tmp98_;
								gint _tmp99_;
								gint _tmp100_;
								gint _tmp101_;
								_tmp75_ = self->priv->show_highlight;
								if (_tmp75_) {
									gint _tmp76_;
									_tmp76_ = self->priv->highlight_state;
									_tmp74_ = _tmp76_ != GAME_VIEW_HIGHLIGHT_MAX;
								} else {
									_tmp74_ = FALSE;
								}
								if (_tmp74_) {
									gint _tmp77_;
									gint _tmp78_;
									gint _tmp79_;
									gint _tmp80_;
									gint _tmp81_;
									gint _tmp82_;
									gint _tmp83_;
									gint _tmp84_;
									gint _tmp85_;
									_tmp77_ = self->priv->highlight_state;
									self->priv->highlight_state = _tmp77_ + 1;
									_tmp78_ = game_view_get_board_x (self);
									_tmp79_ = _tmp78_;
									_tmp80_ = tile_x;
									_tmp81_ = game_view_get_board_y (self);
									_tmp82_ = _tmp81_;
									_tmp83_ = tile_y;
									_tmp84_ = self->priv->tile_size;
									_tmp85_ = self->priv->tile_size;
									gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp79_ + _tmp80_, _tmp82_ + _tmp83_, _tmp84_, _tmp85_);
								} else {
									gboolean _tmp86_ = FALSE;
									gboolean _tmp87_;
									_tmp87_ = self->priv->show_highlight;
									if (!_tmp87_) {
										gint _tmp88_;
										_tmp88_ = self->priv->highlight_state;
										_tmp86_ = _tmp88_ != 0;
									} else {
										_tmp86_ = FALSE;
									}
									if (_tmp86_) {
										self->priv->highlight_state = 0;
									}
								}
								_tmp89_ = self->priv->highlight_red;
								_tmp90_ = self->priv->highlight_green;
								_tmp91_ = self->priv->highlight_blue;
								_tmp92_ = self->priv->highlight_alpha;
								cairo_set_source_rgba (cr, _tmp89_, _tmp90_, _tmp91_, _tmp92_);
								_tmp93_ = tile_x;
								_tmp94_ = self->priv->tile_size;
								_tmp95_ = self->priv->highlight_state;
								_tmp96_ = tile_y;
								_tmp97_ = self->priv->tile_size;
								_tmp98_ = self->priv->highlight_state;
								_tmp99_ = self->priv->tile_size;
								_tmp100_ = self->priv->highlight_state;
								_tmp101_ = self->priv->background_radius;
								game_view_rounded_square (self, cr, (gdouble) (_tmp93_ + ((_tmp94_ * (GAME_VIEW_HIGHLIGHT_MAX - _tmp95_)) / (2 * GAME_VIEW_HIGHLIGHT_MAX))), (gdouble) (_tmp96_ + ((_tmp97_ * (GAME_VIEW_HIGHLIGHT_MAX - _tmp98_)) / (2 * GAME_VIEW_HIGHLIGHT_MAX))), (_tmp99_ * _tmp100_) / GAME_VIEW_HIGHLIGHT_MAX, (gdouble) 0, (gdouble) _tmp101_);
								cairo_fill (cr);
							}
							_tmp102_ = self->priv->pixmaps;
							_tmp102__length1 = self->priv->pixmaps_length1;
							_tmp102__length2 = self->priv->pixmaps_length2;
							_tmp103_ = x;
							_tmp104_ = y;
							_tmp105_ = _tmp102_[(_tmp103_ * _tmp102__length2) + _tmp104_];
							if (_tmp105_ == 0) {
								continue;
							}
							_tmp106_ = self->priv->pixmaps;
							_tmp106__length1 = self->priv->pixmaps_length1;
							_tmp106__length2 = self->priv->pixmaps_length2;
							_tmp107_ = x;
							_tmp108_ = y;
							_tmp109_ = _tmp106_[(_tmp107_ * _tmp106__length2) + _tmp108_];
							_tmp110_ = self->priv->tile_size;
							texture_x = (_tmp109_ % 8) * _tmp110_;
							_tmp111_ = self->priv->pixmaps;
							_tmp111__length1 = self->priv->pixmaps_length1;
							_tmp111__length2 = self->priv->pixmaps_length2;
							_tmp112_ = x;
							_tmp113_ = y;
							_tmp114_ = _tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_];
							_tmp115_ = self->priv->tile_size;
							texture_y = (_tmp114_ / 8) * _tmp115_;
							cairo_matrix_init_identity (&matrix);
							_tmp116_ = texture_x;
							_tmp117_ = tile_x;
							_tmp118_ = texture_y;
							_tmp119_ = tile_y;
							cairo_matrix_translate (&matrix, (gdouble) (_tmp116_ - _tmp117_), (gdouble) (_tmp118_ - _tmp119_));
							_tmp120_ = self->priv->tiles_pattern;
							_tmp121_ = matrix;
							cairo_pattern_set_matrix (_tmp120_, &_tmp121_);
							_tmp122_ = self->priv->tiles_pattern;
							cairo_set_source (cr, _tmp122_);
							_tmp123_ = tile_x;
							_tmp124_ = tile_y;
							_tmp125_ = self->priv->tile_size;
							_tmp126_ = self->priv->tile_size;
							cairo_rectangle (cr, (gdouble) _tmp123_, (gdouble) _tmp124_, (gdouble) _tmp125_, (gdouble) _tmp126_);
							cairo_fill (cr);
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void
game_view_rounded_square (GameView* self,
                          cairo_t* cr,
                          gdouble x,
                          gdouble y,
                          gint size,
                          gdouble width,
                          gdouble radius_percent)
{
	gdouble radius_border = 0.0;
	gdouble radius_arc = 0.0;
	gdouble _tmp0_;
	gdouble x1 = 0.0;
	gdouble _tmp1_;
	gdouble y1 = 0.0;
	gdouble _tmp2_;
	gdouble x2 = 0.0;
	gdouble _tmp3_;
	gdouble y2 = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (radius_percent <= ((gdouble) 0)) {
		cairo_rectangle (cr, x + (width / 2.0), y + (width / 2.0), size + width, size + width);
		return;
	}
	if (radius_percent > ((gdouble) 50)) {
		radius_percent = (gdouble) 50;
	}
	radius_border = (radius_percent * size) / 100.0;
	_tmp0_ = radius_border;
	radius_arc = _tmp0_ - (width / 2.0);
	_tmp1_ = radius_border;
	x1 = x + _tmp1_;
	_tmp2_ = radius_border;
	y1 = y + _tmp2_;
	_tmp3_ = radius_border;
	x2 = (x + size) - _tmp3_;
	_tmp4_ = radius_border;
	y2 = (y + size) - _tmp4_;
	_tmp5_ = x1;
	_tmp6_ = y1;
	_tmp7_ = radius_arc;
	cairo_arc (cr, _tmp5_, _tmp6_, _tmp7_, G_PI, (G_PI * 3) / 2.0);
	_tmp8_ = x2;
	_tmp9_ = y1;
	_tmp10_ = radius_arc;
	cairo_arc (cr, _tmp8_, _tmp9_, _tmp10_, (G_PI * 3) / 2.0, (gdouble) 0);
	_tmp11_ = x2;
	_tmp12_ = y2;
	_tmp13_ = radius_arc;
	cairo_arc (cr, _tmp11_, _tmp12_, _tmp13_, (gdouble) 0, G_PI / 2.0);
	_tmp14_ = x1;
	_tmp15_ = y2;
	_tmp16_ = radius_arc;
	cairo_arc (cr, _tmp14_, _tmp15_, _tmp16_, G_PI / 2.0, G_PI);
	_tmp17_ = x1;
	_tmp18_ = y1;
	_tmp19_ = radius_arc;
	cairo_arc (cr, _tmp17_, _tmp18_, _tmp19_, G_PI, (G_PI * 3) / 2.0);
}


static void
game_view_load_image (GameView* self,
                      cairo_t* c,
                      gint width,
                      gint height)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp0_;
		RsvgHandle* _tmp1_;
		cairo_matrix_t m = {0};
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		cairo_matrix_t _tmp6_;
		_tmp0_ = self->priv->pieces_file;
		_tmp1_ = rsvg_handle_new_from_file (_tmp0_, &_inner_error_);
		h = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		cairo_matrix_init_identity (&m);
		g_object_get (h, "width", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		g_object_get (h, "height", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		cairo_matrix_scale (&m, ((gdouble) width) / _tmp3_, ((gdouble) height) / _tmp5_);
		_tmp6_ = m;
		cairo_set_matrix (c, &_tmp6_);
		rsvg_handle_render_cairo (h, c);
		_g_object_unref0 (h);
		return;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		_tmp7_ = self->priv->pieces_file;
		_tmp8_ = gdk_pixbuf_new_from_file_at_scale (_tmp7_, width, height, FALSE, &_inner_error_);
		p = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp9_ = p;
		gdk_cairo_set_source_pixbuf (c, _tmp9_, (gdouble) 0, (gdouble) 0);
		cairo_paint (c);
		_g_object_unref0 (p);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = self->priv->pieces_file;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("game-view.vala:374: Failed to load theme image %s: %s", _tmp10_, _tmp12_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
game_view_square_changed_cb (GameView* self,
                             gint x,
                             gint y,
                             Player replacement)
{
	g_return_if_fail (self != NULL);
	if (replacement == PLAYER_NONE) {
		self->priv->highlight_x = x;
		self->priv->highlight_y = y;
	}
	game_view_update_square (self, x, y);
}


static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GameView* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean
___lambda6_ (Block2Data* _data2_)
{
	GameView* self;
	gboolean result = FALSE;
	self = _data2_->self;
	self->priv->flip_final_result_now = TRUE;
	game_view_update_square (self, _data2_->x, _data2_->y);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}


static void
game_view_update_square (GameView* self,
                         gint x,
                         gint y)
{
	Block2Data* _data2_;
	gint pixmap = 0;
	Game* _tmp0_;
	Game* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gint _tmp33_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	Game* _tmp36_;
	Game* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->x = x;
	_data2_->y = y;
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	pixmap = game_view_get_pixmap (self, game_get_owner (_tmp1_, _data2_->x, _data2_->y));
	_tmp3_ = self->priv->flip_final_result_now;
	if (_tmp3_) {
		Game* _tmp4_;
		Game* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = game_view_get_game (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = game_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint n = 0;
		Game* _tmp8_;
		Game* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp12_;
		Game* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint n_losing_tiles = 0;
		Game* _tmp16_;
		Game* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp8_ = game_view_get_game (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = game_get_size (_tmp9_);
		_tmp11_ = _tmp10_;
		n = (_data2_->y * _tmp11_) + _data2_->x;
		winning_color = PLAYER_LIGHT;
		losing_color = PLAYER_DARK;
		_tmp12_ = game_view_get_game (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = game_get_n_light_tiles (_tmp13_);
		_tmp15_ = _tmp14_;
		n_winning_tiles = _tmp15_;
		_tmp16_ = game_view_get_game (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = game_get_n_dark_tiles (_tmp17_);
		_tmp19_ = _tmp18_;
		n_losing_tiles = _tmp19_;
		_tmp20_ = n_losing_tiles;
		_tmp21_ = n_winning_tiles;
		if (_tmp20_ > _tmp21_) {
			gint t = 0;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			winning_color = PLAYER_DARK;
			losing_color = PLAYER_LIGHT;
			_tmp22_ = n_winning_tiles;
			t = _tmp22_;
			_tmp23_ = n_losing_tiles;
			n_winning_tiles = _tmp23_;
			_tmp24_ = t;
			n_losing_tiles = _tmp24_;
		}
		_tmp25_ = n;
		_tmp26_ = n_winning_tiles;
		if (_tmp25_ < _tmp26_) {
			Player _tmp27_;
			_tmp27_ = winning_color;
			pixmap = game_view_get_pixmap (self, _tmp27_);
		} else {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			_tmp28_ = n;
			_tmp29_ = n_winning_tiles;
			_tmp30_ = n_losing_tiles;
			if (_tmp28_ < (_tmp29_ + _tmp30_)) {
				Player _tmp31_;
				_tmp31_ = losing_color;
				pixmap = game_view_get_pixmap (self, _tmp31_);
			} else {
				pixmap = game_view_get_pixmap (self, PLAYER_NONE);
			}
		}
	} else {
		gboolean _tmp32_;
		_tmp32_ = self->priv->flip_final_result_now;
		if (_tmp32_) {
			self->priv->flip_final_result_now = FALSE;
		}
	}
	_tmp33_ = pixmap;
	game_view_set_square (self, _data2_->x, _data2_->y, _tmp33_);
	_tmp36_ = game_view_get_game (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = game_get_is_complete (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_) {
		Game* _tmp40_;
		Game* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		_tmp40_ = game_view_get_game (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = game_get_n_light_tiles (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp35_ = _tmp43_ > 0;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		Game* _tmp44_;
		Game* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		_tmp44_ = game_view_get_game (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = game_get_n_dark_tiles (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp34_ = _tmp47_ > 0;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static gboolean
_game_view_animate_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = game_view_animate_cb ((GameView*) self);
	return result;
}


static void
game_view_set_square (GameView* self,
                      gint x,
                      gint y,
                      gint pixmap)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pixmaps;
	_tmp0__length1 = self->priv->pixmaps_length1;
	_tmp0__length2 = self->priv->pixmaps_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	if (_tmp1_ == pixmap) {
		return;
	}
	if (pixmap == 0) {
		_tmp2_ = TRUE;
	} else {
		gint* _tmp3_;
		gint _tmp3__length1;
		gint _tmp3__length2;
		gint _tmp4_;
		_tmp3_ = self->priv->pixmaps;
		_tmp3__length1 = self->priv->pixmaps_length1;
		_tmp3__length2 = self->priv->pixmaps_length2;
		_tmp4_ = _tmp3_[(x * _tmp3__length2) + y];
		_tmp2_ = _tmp4_ == 0;
	}
	if (_tmp2_) {
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp5__length2;
		gint _tmp6_;
		_tmp5_ = self->priv->pixmaps;
		_tmp5__length1 = self->priv->pixmaps_length1;
		_tmp5__length2 = self->priv->pixmaps_length2;
		_tmp5_[(x * _tmp5__length2) + y] = pixmap;
		_tmp6_ = _tmp5_[(x * _tmp5__length2) + y];
	} else {
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		gint _tmp8_;
		guint _tmp13_;
		_tmp7_ = self->priv->pixmaps;
		_tmp7__length1 = self->priv->pixmaps_length1;
		_tmp7__length2 = self->priv->pixmaps_length2;
		_tmp8_ = _tmp7_[(x * _tmp7__length2) + y];
		if (pixmap > _tmp8_) {
			gint* _tmp9_;
			gint _tmp9__length1;
			gint _tmp9__length2;
			gint _tmp10_;
			_tmp9_ = self->priv->pixmaps;
			_tmp9__length1 = self->priv->pixmaps_length1;
			_tmp9__length2 = self->priv->pixmaps_length2;
			_tmp10_ = _tmp9_[(x * _tmp9__length2) + y];
			_tmp9_[(x * _tmp9__length2) + y] = _tmp10_ + 1;
		} else {
			gint* _tmp11_;
			gint _tmp11__length1;
			gint _tmp11__length2;
			gint _tmp12_;
			_tmp11_ = self->priv->pixmaps;
			_tmp11__length1 = self->priv->pixmaps_length1;
			_tmp11__length2 = self->priv->pixmaps_length2;
			_tmp12_ = _tmp11_[(x * _tmp11__length2) + y];
			_tmp11_[(x * _tmp11__length2) + y] = _tmp12_ - 1;
		}
		_tmp13_ = self->priv->animate_timeout;
		if (_tmp13_ == ((guint) 0)) {
			self->priv->animate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	_tmp14_ = game_view_get_board_x (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->paving_size;
	_tmp17_ = game_view_get_board_y (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->paving_size;
	_tmp20_ = self->priv->tile_size;
	_tmp21_ = self->priv->tile_size;
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp15_ + (x * _tmp16_), _tmp18_ + (y * _tmp19_), _tmp20_, _tmp21_);
}


static gboolean
game_view_animate_cb (GameView* self)
{
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp25_;
	g_return_val_if_fail (self != NULL, FALSE);
	animating = FALSE;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				Game* _tmp3_;
				Game* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				_tmp3_ = game_view_get_game (self);
				_tmp4_ = _tmp3_;
				_tmp5_ = game_get_size (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							Game* _tmp10_;
							Game* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							gint old = 0;
							gint* _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							gint _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gint* _tmp20_;
							gint _tmp20__length1;
							gint _tmp20__length2;
							gint _tmp21_;
							gint _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = game_view_get_game (self);
							_tmp11_ = _tmp10_;
							_tmp12_ = game_get_size (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->pixmaps;
							_tmp14__length1 = self->priv->pixmaps_length1;
							_tmp14__length2 = self->priv->pixmaps_length2;
							_tmp15_ = x;
							_tmp16_ = y;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							old = _tmp17_;
							_tmp18_ = x;
							_tmp19_ = y;
							game_view_update_square (self, _tmp18_, _tmp19_);
							_tmp20_ = self->priv->pixmaps;
							_tmp20__length1 = self->priv->pixmaps_length1;
							_tmp20__length2 = self->priv->pixmaps_length2;
							_tmp21_ = x;
							_tmp22_ = y;
							_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
							_tmp24_ = old;
							if (_tmp23_ != _tmp24_) {
								animating = TRUE;
							}
						}
					}
				}
			}
		}
	}
	_tmp25_ = animating;
	if (!_tmp25_) {
		self->priv->animate_timeout = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gint
game_view_get_pixmap (GameView* self,
                      Player color)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (color) {
		default:
		case PLAYER_NONE:
		{
			result = 0;
			return result;
		}
		case PLAYER_DARK:
		{
			result = 1;
			return result;
		}
		case PLAYER_LIGHT:
		{
			result = 31;
			return result;
		}
	}
}


static gboolean
game_view_real_button_press_event (GtkWidget* base,
                                   GdkEventButton* event)
{
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event->button;
	if (_tmp1_ == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_;
		_tmp2_ = event->button;
		_tmp0_ = _tmp2_ == ((guint) GDK_BUTTON_SECONDARY);
	}
	if (_tmp0_) {
		gint x = 0;
		gdouble _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint y = 0;
		gdouble _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		_tmp3_ = event->x;
		_tmp4_ = game_view_get_board_x (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->paving_size;
		x = ((gint) (_tmp3_ - _tmp5_)) / _tmp6_;
		_tmp7_ = event->y;
		_tmp8_ = game_view_get_board_y (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->paving_size;
		y = ((gint) (_tmp7_ - _tmp9_)) / _tmp10_;
		_tmp14_ = x;
		if (_tmp14_ >= 0) {
			gint _tmp15_;
			Game* _tmp16_;
			Game* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_tmp15_ = x;
			_tmp16_ = game_view_get_game (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = game_get_size (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp13_ = _tmp15_ < _tmp19_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gint _tmp20_;
			_tmp20_ = y;
			_tmp12_ = _tmp20_ >= 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gint _tmp21_;
			Game* _tmp22_;
			Game* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp21_ = y;
			_tmp22_ = game_view_get_game (self);
			_tmp23_ = _tmp22_;
			_tmp24_ = game_get_size (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp11_ = _tmp21_ < _tmp25_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			self->priv->show_highlight = FALSE;
			gtk_widget_queue_draw ((GtkWidget*) self);
			_tmp26_ = x;
			self->priv->highlight_x = _tmp26_;
			_tmp27_ = y;
			self->priv->highlight_y = _tmp27_;
			_tmp28_ = x;
			_tmp29_ = y;
			g_signal_emit (self, game_view_signals[GAME_VIEW_MOVE_SIGNAL], 0, _tmp28_, _tmp29_);
		}
	}
	result = TRUE;
	return result;
}


static gboolean
game_view_real_key_press_event (GtkWidget* base,
                                GdkEventKey* event)
{
	GameView * self;
	gboolean result = FALSE;
	gchar* key = NULL;
	guint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	Game* _tmp18_;
	Game* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	GQuark _tmp80_ = 0U;
	static GQuark _tmp79_label0 = 0;
	static GQuark _tmp79_label1 = 0;
	static GQuark _tmp79_label2 = 0;
	static GQuark _tmp79_label3 = 0;
	static GQuark _tmp79_label4 = 0;
	static GQuark _tmp79_label5 = 0;
	static GQuark _tmp79_label6 = 0;
	static GQuark _tmp79_label7 = 0;
	static GQuark _tmp79_label8 = 0;
	static GQuark _tmp79_label9 = 0;
	static GQuark _tmp79_label10 = 0;
	static GQuark _tmp79_label11 = 0;
	static GQuark _tmp79_label12 = 0;
	static GQuark _tmp79_label13 = 0;
	static GQuark _tmp79_label14 = 0;
	static GQuark _tmp79_label15 = 0;
	static GQuark _tmp79_label16 = 0;
	static GQuark _tmp79_label17 = 0;
	static GQuark _tmp79_label18 = 0;
	static GQuark _tmp79_label19 = 0;
	static GQuark _tmp79_label20 = 0;
	static GQuark _tmp79_label21 = 0;
	static GQuark _tmp79_label22 = 0;
	static GQuark _tmp79_label23 = 0;
	static GQuark _tmp79_label24 = 0;
	static GQuark _tmp79_label25 = 0;
	static GQuark _tmp79_label26 = 0;
	static GQuark _tmp79_label27 = 0;
	static GQuark _tmp79_label28 = 0;
	static GQuark _tmp79_label29 = 0;
	static GQuark _tmp79_label30 = 0;
	static GQuark _tmp79_label31 = 0;
	static GQuark _tmp79_label32 = 0;
	static GQuark _tmp79_label33 = 0;
	static GQuark _tmp79_label34 = 0;
	static GQuark _tmp79_label35 = 0;
	static GQuark _tmp79_label36 = 0;
	static GQuark _tmp79_label37 = 0;
	static GQuark _tmp79_label38 = 0;
	static GQuark _tmp79_label39 = 0;
	static GQuark _tmp79_label40 = 0;
	static GQuark _tmp79_label41 = 0;
	static GQuark _tmp79_label42 = 0;
	static GQuark _tmp79_label43 = 0;
	static GQuark _tmp79_label44 = 0;
	static GQuark _tmp79_label45 = 0;
	static GQuark _tmp79_label46 = 0;
	static GQuark _tmp79_label47 = 0;
	static GQuark _tmp79_label48 = 0;
	static GQuark _tmp79_label49 = 0;
	const gchar* _tmp105_;
	self = (GameView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->keyval;
	_tmp1_ = gdk_keyval_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	key = _tmp2_;
	_tmp4_ = self->priv->show_highlight;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = key;
		if (g_strcmp0 (_tmp7_, "space") == 0) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp8_;
			_tmp8_ = key;
			_tmp6_ = g_strcmp0 (_tmp8_, "Return") == 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = key;
			_tmp5_ = g_strcmp0 (_tmp9_, "KP_Enter") == 0;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint _tmp10_;
		gint _tmp11_;
		_tmp10_ = self->priv->highlight_x;
		_tmp11_ = self->priv->highlight_y;
		g_signal_emit (self, game_view_signals[GAME_VIEW_MOVE_SIGNAL], 0, _tmp10_, _tmp11_);
		result = TRUE;
		_g_free0 (key);
		return result;
	}
	_tmp18_ = game_view_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = game_get_size (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ <= 4) {
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		_tmp24_ = key;
		if (g_strcmp0 (_tmp24_, "e") == 0) {
			_tmp23_ = TRUE;
		} else {
			const gchar* _tmp25_;
			_tmp25_ = key;
			_tmp23_ = g_strcmp0 (_tmp25_, "5") == 0;
		}
		if (_tmp23_) {
			_tmp22_ = TRUE;
		} else {
			const gchar* _tmp26_;
			_tmp26_ = key;
			_tmp22_ = g_strcmp0 (_tmp26_, "KP_5") == 0;
		}
		_tmp17_ = _tmp22_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		Game* _tmp28_;
		Game* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		_tmp28_ = game_view_get_game (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = game_get_size (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ <= 5) {
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			const gchar* _tmp34_;
			_tmp34_ = key;
			if (g_strcmp0 (_tmp34_, "f") == 0) {
				_tmp33_ = TRUE;
			} else {
				const gchar* _tmp35_;
				_tmp35_ = key;
				_tmp33_ = g_strcmp0 (_tmp35_, "6") == 0;
			}
			if (_tmp33_) {
				_tmp32_ = TRUE;
			} else {
				const gchar* _tmp36_;
				_tmp36_ = key;
				_tmp32_ = g_strcmp0 (_tmp36_, "KP_6") == 0;
			}
			_tmp27_ = _tmp32_;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp16_ = _tmp27_;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp37_ = FALSE;
		Game* _tmp38_;
		Game* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp38_ = game_view_get_game (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = game_get_size (_tmp39_);
		_tmp41_ = _tmp40_;
		if (_tmp41_ <= 6) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			const gchar* _tmp44_;
			_tmp44_ = key;
			if (g_strcmp0 (_tmp44_, "g") == 0) {
				_tmp43_ = TRUE;
			} else {
				const gchar* _tmp45_;
				_tmp45_ = key;
				_tmp43_ = g_strcmp0 (_tmp45_, "7") == 0;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				const gchar* _tmp46_;
				_tmp46_ = key;
				_tmp42_ = g_strcmp0 (_tmp46_, "KP_7") == 0;
			}
			_tmp37_ = _tmp42_;
		} else {
			_tmp37_ = FALSE;
		}
		_tmp15_ = _tmp37_;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp47_ = FALSE;
		Game* _tmp48_;
		Game* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		_tmp48_ = game_view_get_game (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = game_get_size (_tmp49_);
		_tmp51_ = _tmp50_;
		if (_tmp51_ <= 7) {
			gboolean _tmp52_ = FALSE;
			gboolean _tmp53_ = FALSE;
			const gchar* _tmp54_;
			_tmp54_ = key;
			if (g_strcmp0 (_tmp54_, "h") == 0) {
				_tmp53_ = TRUE;
			} else {
				const gchar* _tmp55_;
				_tmp55_ = key;
				_tmp53_ = g_strcmp0 (_tmp55_, "8") == 0;
			}
			if (_tmp53_) {
				_tmp52_ = TRUE;
			} else {
				const gchar* _tmp56_;
				_tmp56_ = key;
				_tmp52_ = g_strcmp0 (_tmp56_, "KP_8") == 0;
			}
			_tmp47_ = _tmp52_;
		} else {
			_tmp47_ = FALSE;
		}
		_tmp14_ = _tmp47_;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp57_ = FALSE;
		Game* _tmp58_;
		Game* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		_tmp58_ = game_view_get_game (self);
		_tmp59_ = _tmp58_;
		_tmp60_ = game_get_size (_tmp59_);
		_tmp61_ = _tmp60_;
		if (_tmp61_ <= 8) {
			gboolean _tmp62_ = FALSE;
			gboolean _tmp63_ = FALSE;
			const gchar* _tmp64_;
			_tmp64_ = key;
			if (g_strcmp0 (_tmp64_, "i") == 0) {
				_tmp63_ = TRUE;
			} else {
				const gchar* _tmp65_;
				_tmp65_ = key;
				_tmp63_ = g_strcmp0 (_tmp65_, "9") == 0;
			}
			if (_tmp63_) {
				_tmp62_ = TRUE;
			} else {
				const gchar* _tmp66_;
				_tmp66_ = key;
				_tmp62_ = g_strcmp0 (_tmp66_, "KP_9") == 0;
			}
			_tmp57_ = _tmp62_;
		} else {
			_tmp57_ = FALSE;
		}
		_tmp13_ = _tmp57_;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp67_ = FALSE;
		Game* _tmp68_;
		Game* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		_tmp68_ = game_view_get_game (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = game_get_size (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ <= 9) {
			gboolean _tmp72_ = FALSE;
			gboolean _tmp73_ = FALSE;
			const gchar* _tmp74_;
			_tmp74_ = key;
			if (g_strcmp0 (_tmp74_, "j") == 0) {
				_tmp73_ = TRUE;
			} else {
				const gchar* _tmp75_;
				_tmp75_ = key;
				_tmp73_ = g_strcmp0 (_tmp75_, "0") == 0;
			}
			if (_tmp73_) {
				_tmp72_ = TRUE;
			} else {
				const gchar* _tmp76_;
				_tmp76_ = key;
				_tmp72_ = g_strcmp0 (_tmp76_, "KP_0") == 0;
			}
			_tmp67_ = _tmp72_;
		} else {
			_tmp67_ = FALSE;
		}
		_tmp12_ = _tmp67_;
	}
	if (_tmp12_) {
		result = FALSE;
		_g_free0 (key);
		return result;
	}
	_tmp77_ = key;
	_tmp78_ = _tmp77_;
	_tmp80_ = (NULL == _tmp78_) ? 0 : g_quark_from_string (_tmp78_);
	if ((_tmp80_ == ((0 != _tmp79_label0) ? _tmp79_label0 : (_tmp79_label0 = g_quark_from_static_string ("Left")))) || (_tmp80_ == ((0 != _tmp79_label1) ? _tmp79_label1 : (_tmp79_label1 = g_quark_from_static_string ("KP_Left"))))) {
		switch (0) {
			default:
			{
				gint _tmp81_;
				_tmp81_ = self->priv->highlight_x;
				if (_tmp81_ > 0) {
					gint _tmp82_;
					_tmp82_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp82_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label2) ? _tmp79_label2 : (_tmp79_label2 = g_quark_from_static_string ("Right")))) || (_tmp80_ == ((0 != _tmp79_label3) ? _tmp79_label3 : (_tmp79_label3 = g_quark_from_static_string ("KP_Right"))))) {
		switch (0) {
			default:
			{
				gint _tmp83_;
				Game* _tmp84_;
				Game* _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				_tmp83_ = self->priv->highlight_x;
				_tmp84_ = game_view_get_game (self);
				_tmp85_ = _tmp84_;
				_tmp86_ = game_get_size (_tmp85_);
				_tmp87_ = _tmp86_;
				if (_tmp83_ < (_tmp87_ - 1)) {
					gint _tmp88_;
					_tmp88_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp88_ + 1;
				}
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label4) ? _tmp79_label4 : (_tmp79_label4 = g_quark_from_static_string ("Up")))) || (_tmp80_ == ((0 != _tmp79_label5) ? _tmp79_label5 : (_tmp79_label5 = g_quark_from_static_string ("KP_Up"))))) {
		switch (0) {
			default:
			{
				gint _tmp89_;
				_tmp89_ = self->priv->highlight_y;
				if (_tmp89_ > 0) {
					gint _tmp90_;
					_tmp90_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp90_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label6) ? _tmp79_label6 : (_tmp79_label6 = g_quark_from_static_string ("Down")))) || (_tmp80_ == ((0 != _tmp79_label7) ? _tmp79_label7 : (_tmp79_label7 = g_quark_from_static_string ("KP_Down"))))) {
		switch (0) {
			default:
			{
				gint _tmp91_;
				Game* _tmp92_;
				Game* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				_tmp91_ = self->priv->highlight_y;
				_tmp92_ = game_view_get_game (self);
				_tmp93_ = _tmp92_;
				_tmp94_ = game_get_size (_tmp93_);
				_tmp95_ = _tmp94_;
				if (_tmp91_ < (_tmp95_ - 1)) {
					gint _tmp96_;
					_tmp96_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp96_ + 1;
				}
				break;
			}
		}
	} else if ((((_tmp80_ == ((0 != _tmp79_label8) ? _tmp79_label8 : (_tmp79_label8 = g_quark_from_static_string ("space")))) || (_tmp80_ == ((0 != _tmp79_label9) ? _tmp79_label9 : (_tmp79_label9 = g_quark_from_static_string ("Return"))))) || (_tmp80_ == ((0 != _tmp79_label10) ? _tmp79_label10 : (_tmp79_label10 = g_quark_from_static_string ("KP_Enter"))))) || (_tmp80_ == ((0 != _tmp79_label11) ? _tmp79_label11 : (_tmp79_label11 = g_quark_from_static_string ("Escape"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label12) ? _tmp79_label12 : (_tmp79_label12 = g_quark_from_static_string ("a")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 0;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label13) ? _tmp79_label13 : (_tmp79_label13 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 1;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label14) ? _tmp79_label14 : (_tmp79_label14 = g_quark_from_static_string ("c")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 2;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label15) ? _tmp79_label15 : (_tmp79_label15 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 3;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label16) ? _tmp79_label16 : (_tmp79_label16 = g_quark_from_static_string ("e")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 4;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label17) ? _tmp79_label17 : (_tmp79_label17 = g_quark_from_static_string ("f")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 5;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label18) ? _tmp79_label18 : (_tmp79_label18 = g_quark_from_static_string ("g")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 6;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label19) ? _tmp79_label19 : (_tmp79_label19 = g_quark_from_static_string ("h")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 7;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label20) ? _tmp79_label20 : (_tmp79_label20 = g_quark_from_static_string ("i")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 8;
				break;
			}
		}
	} else if (_tmp80_ == ((0 != _tmp79_label21) ? _tmp79_label21 : (_tmp79_label21 = g_quark_from_static_string ("j")))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 9;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label22) ? _tmp79_label22 : (_tmp79_label22 = g_quark_from_static_string ("1")))) || (_tmp80_ == ((0 != _tmp79_label23) ? _tmp79_label23 : (_tmp79_label23 = g_quark_from_static_string ("KP_1"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 0;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label24) ? _tmp79_label24 : (_tmp79_label24 = g_quark_from_static_string ("2")))) || (_tmp80_ == ((0 != _tmp79_label25) ? _tmp79_label25 : (_tmp79_label25 = g_quark_from_static_string ("KP_2"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 1;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label26) ? _tmp79_label26 : (_tmp79_label26 = g_quark_from_static_string ("3")))) || (_tmp80_ == ((0 != _tmp79_label27) ? _tmp79_label27 : (_tmp79_label27 = g_quark_from_static_string ("KP_3"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 2;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label28) ? _tmp79_label28 : (_tmp79_label28 = g_quark_from_static_string ("4")))) || (_tmp80_ == ((0 != _tmp79_label29) ? _tmp79_label29 : (_tmp79_label29 = g_quark_from_static_string ("KP_4"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 3;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label30) ? _tmp79_label30 : (_tmp79_label30 = g_quark_from_static_string ("5")))) || (_tmp80_ == ((0 != _tmp79_label31) ? _tmp79_label31 : (_tmp79_label31 = g_quark_from_static_string ("KP_5"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 4;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label32) ? _tmp79_label32 : (_tmp79_label32 = g_quark_from_static_string ("6")))) || (_tmp80_ == ((0 != _tmp79_label33) ? _tmp79_label33 : (_tmp79_label33 = g_quark_from_static_string ("KP_6"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 5;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label34) ? _tmp79_label34 : (_tmp79_label34 = g_quark_from_static_string ("7")))) || (_tmp80_ == ((0 != _tmp79_label35) ? _tmp79_label35 : (_tmp79_label35 = g_quark_from_static_string ("KP_7"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 6;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label36) ? _tmp79_label36 : (_tmp79_label36 = g_quark_from_static_string ("8")))) || (_tmp80_ == ((0 != _tmp79_label37) ? _tmp79_label37 : (_tmp79_label37 = g_quark_from_static_string ("KP_8"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 7;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label38) ? _tmp79_label38 : (_tmp79_label38 = g_quark_from_static_string ("9")))) || (_tmp80_ == ((0 != _tmp79_label39) ? _tmp79_label39 : (_tmp79_label39 = g_quark_from_static_string ("KP_9"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 8;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label40) ? _tmp79_label40 : (_tmp79_label40 = g_quark_from_static_string ("0")))) || (_tmp80_ == ((0 != _tmp79_label41) ? _tmp79_label41 : (_tmp79_label41 = g_quark_from_static_string ("KP_0"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 9;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label42) ? _tmp79_label42 : (_tmp79_label42 = g_quark_from_static_string ("Home")))) || (_tmp80_ == ((0 != _tmp79_label43) ? _tmp79_label43 : (_tmp79_label43 = g_quark_from_static_string ("KP_Home"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_x = 0;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label44) ? _tmp79_label44 : (_tmp79_label44 = g_quark_from_static_string ("End")))) || (_tmp80_ == ((0 != _tmp79_label45) ? _tmp79_label45 : (_tmp79_label45 = g_quark_from_static_string ("KP_End"))))) {
		switch (0) {
			default:
			{
				Game* _tmp97_;
				Game* _tmp98_;
				gint _tmp99_;
				gint _tmp100_;
				_tmp97_ = game_view_get_game (self);
				_tmp98_ = _tmp97_;
				_tmp99_ = game_get_size (_tmp98_);
				_tmp100_ = _tmp99_;
				self->priv->highlight_x = _tmp100_ - 1;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label46) ? _tmp79_label46 : (_tmp79_label46 = g_quark_from_static_string ("Page_Up")))) || (_tmp80_ == ((0 != _tmp79_label47) ? _tmp79_label47 : (_tmp79_label47 = g_quark_from_static_string ("KP_Page_Up"))))) {
		switch (0) {
			default:
			{
				self->priv->highlight_y = 0;
				break;
			}
		}
	} else if ((_tmp80_ == ((0 != _tmp79_label48) ? _tmp79_label48 : (_tmp79_label48 = g_quark_from_static_string ("Page_Down")))) || (_tmp80_ == ((0 != _tmp79_label49) ? _tmp79_label49 : (_tmp79_label49 = g_quark_from_static_string ("KP_Next"))))) {
		switch (0) {
			default:
			{
				Game* _tmp101_;
				Game* _tmp102_;
				gint _tmp103_;
				gint _tmp104_;
				_tmp101_ = game_view_get_game (self);
				_tmp102_ = _tmp101_;
				_tmp103_ = game_get_size (_tmp102_);
				_tmp104_ = _tmp103_;
				self->priv->highlight_y = _tmp104_ - 1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (key);
				return result;
			}
		}
	}
	_tmp105_ = key;
	if (g_strcmp0 (_tmp105_, "Escape") == 0) {
		self->priv->show_highlight = FALSE;
	} else {
		gboolean _tmp106_;
		_tmp106_ = self->priv->show_highlight;
		if (_tmp106_) {
			self->priv->highlight_state = GAME_VIEW_HIGHLIGHT_MAX;
		} else {
			self->priv->show_highlight = TRUE;
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = TRUE;
	_g_free0 (key);
	return result;
}


static gboolean
game_view_draw_scoreboard (GameView* self,
                           cairo_t* cr)
{
	gboolean result = FALSE;
	gint height = 0;
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	gint width = 0;
	GtkDrawingArea* _tmp2_;
	GtkDrawingArea* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_t* c = NULL;
	cairo_t* _tmp11_;
	cairo_pattern_t* _tmp12_;
	cairo_matrix_t matrix = {0};
	cairo_pattern_t* _tmp13_;
	cairo_matrix_t _tmp14_;
	cairo_pattern_t* _tmp15_;
	cairo_pattern_t* _tmp16_;
	cairo_matrix_t _tmp17_;
	cairo_pattern_t* _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = game_view_get_scoreboard (self);
	_tmp1_ = _tmp0_;
	height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp1_);
	_tmp2_ = game_view_get_scoreboard (self);
	_tmp3_ = _tmp2_;
	width = gtk_widget_get_allocated_width ((GtkWidget*) _tmp3_);
	cairo_set_line_cap (cr, CAIRO_LINE_CAP_ROUND);
	cairo_set_line_join (cr, CAIRO_LINE_JOIN_ROUND);
	cairo_save (cr);
	_tmp4_ = self->priv->mark_red;
	_tmp5_ = self->priv->mark_green;
	_tmp6_ = self->priv->mark_blue;
	cairo_set_source_rgba (cr, _tmp4_, _tmp5_, _tmp6_, 1.0);
	_tmp7_ = self->priv->mark_width;
	cairo_set_line_width (cr, (gdouble) _tmp7_);
	_tmp8_ = self->priv->current_player_number;
	cairo_translate (cr, (gdouble) 0, (_tmp8_ * height) / 2.0);
	cairo_move_to (cr, height / 4.0, height / 8.0);
	cairo_line_to (cr, width - ((5.0 * height) / 8.0), height / 4.0);
	cairo_line_to (cr, height / 4.0, (3.0 * height) / 8.0);
	cairo_stroke (cr);
	cairo_restore (cr);
	_tmp9_ = cairo_get_target (cr);
	_tmp10_ = cairo_surface_create_similar (_tmp9_, CAIRO_CONTENT_COLOR_ALPHA, height * 4, height * 2);
	surface = _tmp10_;
	_tmp11_ = cairo_create (surface);
	c = _tmp11_;
	game_view_load_image (self, c, height * 4, height * 2);
	_tmp12_ = cairo_pattern_create_for_surface (surface);
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
	self->priv->scoreboard_tiles_pattern = _tmp12_;
	cairo_translate (cr, width - (height / 2.0), (gdouble) 0);
	cairo_matrix_init_identity (&matrix);
	cairo_matrix_translate (&matrix, height / 2.0, (gdouble) 0);
	_tmp13_ = self->priv->scoreboard_tiles_pattern;
	_tmp14_ = matrix;
	cairo_pattern_set_matrix (_tmp13_, &_tmp14_);
	_tmp15_ = self->priv->scoreboard_tiles_pattern;
	cairo_set_source (cr, _tmp15_);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, height / 2.0, height / 2.0);
	cairo_fill (cr);
	cairo_matrix_translate (&matrix, (gdouble) (3 * height), (gdouble) height);
	_tmp16_ = self->priv->scoreboard_tiles_pattern;
	_tmp17_ = matrix;
	cairo_pattern_set_matrix (_tmp16_, &_tmp17_);
	_tmp18_ = self->priv->scoreboard_tiles_pattern;
	cairo_set_source (cr, _tmp18_);
	cairo_rectangle (cr, (gdouble) 0, height / 2.0, height / 2.0, height / 2.0);
	cairo_fill (cr);
	result = TRUE;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


void
game_view_update_scoreboard (GameView* self)
{
	gint _tmp0_ = 0;
	Game* _tmp1_;
	Game* _tmp2_;
	Player _tmp3_;
	Player _tmp4_;
	GtkDrawingArea* _tmp5_;
	GtkDrawingArea* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_DARK) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	self->priv->current_player_number = _tmp0_;
	_tmp5_ = game_view_get_scoreboard (self);
	_tmp6_ = _tmp5_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
}


static GtkDrawingArea*
game_view_get_scoreboard (GameView* self)
{
	GtkDrawingArea* result;
	GtkDrawingArea* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scoreboard;
	result = _tmp0_;
	return result;
}


static gboolean
_game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender,
                                            cairo_t* cr,
                                            gpointer self)
{
	gboolean result;
	result = game_view_draw_scoreboard ((GameView*) self, cr);
	return result;
}


void
game_view_set_scoreboard (GameView* self,
                          GtkDrawingArea* value)
{
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_scoreboard);
	self->priv->_scoreboard = _tmp0_;
	_tmp1_ = self->priv->_scoreboard;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "draw", (GCallback) _game_view_draw_scoreboard_gtk_widget_draw, self, 0);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SCOREBOARD_PROPERTY]);
}


const gchar*
game_view_get_sound_flip (GameView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sound_flip;
	result = _tmp0_;
	return result;
}


static void
game_view_set_sound_flip (GameView* self,
                          const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, game_view_get_sound_flip (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sound_flip);
		self->priv->_sound_flip = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SOUND_FLIP_PROPERTY]);
	}
}


const gchar*
game_view_get_sound_gameover (GameView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sound_gameover;
	result = _tmp0_;
	return result;
}


static void
game_view_set_sound_gameover (GameView* self,
                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, game_view_get_sound_gameover (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sound_gameover);
		self->priv->_sound_gameover = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_SOUND_GAMEOVER_PROPERTY]);
	}
}


static gint
game_view_get_board_x (GameView* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->board_size;
	result = (gtk_widget_get_allocated_width ((GtkWidget*) self) - _tmp0_) / 2;
	return result;
}


static gint
game_view_get_board_y (GameView* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->board_size;
	result = (gtk_widget_get_allocated_height ((GtkWidget*) self) - _tmp0_) / 2;
	return result;
}


Game*
game_view_get_game (GameView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void
_game_view_square_changed_cb_game_square_changed (Game* _sender,
                                                  gint x,
                                                  gint y,
                                                  Player new_color,
                                                  gpointer self)
{
	game_view_square_changed_cb ((GameView*) self, x, y, new_color);
}


void
game_view_set_game (GameView* self,
                    Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint* _tmp11_;
	Game* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = game_view_get_game (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_get_size (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = game_view_get_game (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = game_get_size (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_new0 (gint, _tmp6_ * _tmp10_);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	self->priv->pixmaps = _tmp11_;
	self->priv->pixmaps_length1 = _tmp6_;
	self->priv->pixmaps_length2 = _tmp10_;
	_tmp12_ = self->priv->_game;
	if (_tmp12_ != NULL) {
		Game* _tmp13_;
		_tmp13_ = self->priv->_game;
		g_signal_connect_object (_tmp13_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gint _tmp16_;
					Game* _tmp17_;
					Game* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = x;
						x = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = x;
					_tmp17_ = game_view_get_game (self);
					_tmp18_ = _tmp17_;
					_tmp19_ = game_get_size (_tmp18_);
					_tmp20_ = _tmp19_;
					if (!(_tmp16_ < _tmp20_)) {
						break;
					}
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp21_ = FALSE;
							_tmp21_ = TRUE;
							while (TRUE) {
								gint _tmp23_;
								Game* _tmp24_;
								Game* _tmp25_;
								gint _tmp26_;
								gint _tmp27_;
								gint* _tmp28_;
								gint _tmp28__length1;
								gint _tmp28__length2;
								gint _tmp29_;
								gint _tmp30_;
								Game* _tmp31_;
								gint _tmp32_;
								gint _tmp33_;
								gint _tmp34_;
								if (!_tmp21_) {
									gint _tmp22_;
									_tmp22_ = y;
									y = _tmp22_ + 1;
								}
								_tmp21_ = FALSE;
								_tmp23_ = y;
								_tmp24_ = game_view_get_game (self);
								_tmp25_ = _tmp24_;
								_tmp26_ = game_get_size (_tmp25_);
								_tmp27_ = _tmp26_;
								if (!(_tmp23_ < _tmp27_)) {
									break;
								}
								_tmp28_ = self->priv->pixmaps;
								_tmp28__length1 = self->priv->pixmaps_length1;
								_tmp28__length2 = self->priv->pixmaps_length2;
								_tmp29_ = x;
								_tmp30_ = y;
								_tmp31_ = self->priv->_game;
								_tmp32_ = x;
								_tmp33_ = y;
								_tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_] = game_view_get_pixmap (self, game_get_owner (_tmp31_, _tmp32_, _tmp33_));
								_tmp34_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
							}
						}
					}
				}
			}
		}
	}
	self->priv->show_highlight = FALSE;
	self->priv->highlight_x = 3;
	self->priv->highlight_y = 3;
	self->priv->highlight_state = 0;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_GAME_PROPERTY]);
}


const gchar*
game_view_get_theme (GameView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}


void
game_view_set_theme (GameView* self,
                     const gchar* value)
{
	GKeyFile* key = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp14_;
	gchar* _tmp15_;
	GtkDrawingArea* _tmp16_;
	GtkDrawingArea* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	key = _tmp0_;
	if (g_strcmp0 (value, "default") == 0) {
		game_view_set_default_theme (self, &key);
	} else {
		{
			gchar* key_path = NULL;
			gchar* _tmp1_;
			gchar* filepath = NULL;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gboolean _tmp8_;
			GKeyFile* _tmp10_;
			const gchar* _tmp11_;
			_tmp1_ = g_build_filename (DATA_DIRECTORY, "themes", "key", NULL);
			key_path = _tmp1_;
			_tmp2_ = key_path;
			_tmp3_ = g_build_filename (_tmp2_, value, NULL);
			filepath = _tmp3_;
			_tmp4_ = filepath;
			_tmp5_ = g_path_get_dirname (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = key_path;
			_tmp8_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
			_g_free0 (_tmp6_);
			if (_tmp8_) {
				GError* _tmp9_;
				_tmp9_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Theme file is not in the \"key\" directory.");
				_inner_error_ = _tmp9_;
				_g_free0 (filepath);
				_g_free0 (key_path);
				goto __catch4_g_error;
			}
			_tmp10_ = key;
			_tmp11_ = filepath;
			g_key_file_load_from_file (_tmp10_, _tmp11_, G_KEY_FILE_NONE, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (filepath);
				_g_free0 (key_path);
				goto __catch4_g_error;
			}
			_g_free0 (filepath);
			_g_free0 (key_path);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_warning ("game-view.vala:149: Failed to load theme: %s", _tmp13_);
			game_view_set_default_theme (self, &key);
			value = "default";
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_key_file_unref0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = key;
	game_view_load_theme (self, _tmp14_);
	_tmp15_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp15_;
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	self->priv->tiles_pattern = NULL;
	_tmp16_ = game_view_get_scoreboard (self);
	_tmp17_ = _tmp16_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp17_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_key_file_unref0 (key);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_THEME_PROPERTY]);
}


static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void
game_view_class_init (GameViewClass * klass)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) game_view_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) game_view_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) game_view_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SCOREBOARD_PROPERTY, game_view_properties[GAME_VIEW_SCOREBOARD_PROPERTY] = g_param_spec_object ("scoreboard", "scoreboard", "scoreboard", gtk_drawing_area_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_FLIP_PROPERTY, game_view_properties[GAME_VIEW_SOUND_FLIP_PROPERTY] = g_param_spec_string ("sound-flip", "sound-flip", "sound-flip", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_GAMEOVER_PROPERTY, game_view_properties[GAME_VIEW_SOUND_GAMEOVER_PROPERTY] = g_param_spec_string ("sound-gameover", "sound-gameover", "sound-gameover", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME_PROPERTY, game_view_properties[GAME_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_PROPERTY, game_view_properties[GAME_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	game_view_signals[GAME_VIEW_MOVE_SIGNAL] = g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
}


static void
game_view_instance_init (GameView * self)
{
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->background_red = 0.2;
	self->priv->background_green = 0.6;
	self->priv->background_blue = 0.4;
	self->priv->background_radius = 0;
	self->priv->mark_red = 0.2;
	self->priv->mark_green = 0.6;
	self->priv->mark_blue = 0.4;
	self->priv->mark_width = 2;
	self->priv->border_red = 0.1;
	self->priv->border_green = 0.1;
	self->priv->border_blue = 0.1;
	self->priv->border_width = 3;
	self->priv->spacing_red = 0.1;
	self->priv->spacing_green = 0.3;
	self->priv->spacing_blue = 0.2;
	self->priv->spacing_width = 2;
	self->priv->highlight_red = 0.1;
	self->priv->highlight_green = 0.3;
	self->priv->highlight_blue = 0.2;
	self->priv->highlight_alpha = 0.4;
	self->priv->render_size = (guint) 0;
	self->priv->tiles_pattern = NULL;
	self->priv->scoreboard_tiles_pattern = NULL;
	self->priv->animate_timeout = (guint) 0;
	self->priv->current_player_number = 0;
	self->priv->flip_final_result_now = FALSE;
	self->priv->_game = NULL;
	self->priv->_theme = NULL;
}


static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->_scoreboard);
	_g_free0 (self->priv->pieces_file);
	_g_free0 (self->priv->_sound_flip);
	_g_free0 (self->priv->_sound_gameover);
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType
game_view_get_type (void)
{
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void
_vala_game_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_SCOREBOARD_PROPERTY:
		g_value_set_object (value, game_view_get_scoreboard (self));
		break;
		case GAME_VIEW_SOUND_FLIP_PROPERTY:
		g_value_set_string (value, game_view_get_sound_flip (self));
		break;
		case GAME_VIEW_SOUND_GAMEOVER_PROPERTY:
		g_value_set_string (value, game_view_get_sound_gameover (self));
		break;
		case GAME_VIEW_GAME_PROPERTY:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		g_value_set_string (value, game_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_game_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_SCOREBOARD_PROPERTY:
		game_view_set_scoreboard (self, g_value_get_object (value));
		break;
		case GAME_VIEW_SOUND_FLIP_PROPERTY:
		game_view_set_sound_flip (self, g_value_get_string (value));
		break;
		case GAME_VIEW_SOUND_GAMEOVER_PROPERTY:
		game_view_set_sound_gameover (self, g_value_get_string (value));
		break;
		case GAME_VIEW_GAME_PROPERTY:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



