/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcBoolean.h"
#include "ifcpp/IFC4/include/IfcBoundaryCurve.h"
#include "ifcpp/IFC4/include/IfcCurveBoundedSurface.h"
#include "ifcpp/IFC4/include/IfcPresentationLayerAssignment.h"
#include "ifcpp/IFC4/include/IfcStyledItem.h"
#include "ifcpp/IFC4/include/IfcSurface.h"

// ENTITY IfcCurveBoundedSurface 
IfcCurveBoundedSurface::IfcCurveBoundedSurface( int id ) { m_entity_id = id; }
IfcCurveBoundedSurface::~IfcCurveBoundedSurface() {}
shared_ptr<BuildingObject> IfcCurveBoundedSurface::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcCurveBoundedSurface> copy_self( new IfcCurveBoundedSurface() );
	if( m_BasisSurface ) { copy_self->m_BasisSurface = dynamic_pointer_cast<IfcSurface>( m_BasisSurface->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_Boundaries.size(); ++ii )
	{
		auto item_ii = m_Boundaries[ii];
		if( item_ii )
		{
			copy_self->m_Boundaries.emplace_back( dynamic_pointer_cast<IfcBoundaryCurve>(item_ii->getDeepCopy(options) ) );
		}
	}
	if( m_ImplicitOuter ) { copy_self->m_ImplicitOuter = dynamic_pointer_cast<IfcBoolean>( m_ImplicitOuter->getDeepCopy(options) ); }
	return copy_self;
}
void IfcCurveBoundedSurface::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCCURVEBOUNDEDSURFACE" << "(";
	if( m_BasisSurface ) { stream << "#" << m_BasisSurface->m_entity_id; } else { stream << "$"; }
	stream << ",";
	writeEntityList( stream, m_Boundaries );
	stream << ",";
	if( m_ImplicitOuter ) { m_ImplicitOuter->getStepParameter( stream ); } else { stream << "$"; }
	stream << ");";
}
void IfcCurveBoundedSurface::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcCurveBoundedSurface::toString() const { return L"IfcCurveBoundedSurface"; }
void IfcCurveBoundedSurface::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 3 ){ std::stringstream err; err << "Wrong parameter count for entity IfcCurveBoundedSurface, expecting 3, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	readEntityReference( args[0], m_BasisSurface, map );
	readEntityReferenceList( args[1], m_Boundaries, map );
	m_ImplicitOuter = IfcBoolean::createObjectFromSTEP( args[2], map );
}
void IfcCurveBoundedSurface::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcBoundedSurface::getAttributes( vec_attributes );
	vec_attributes.emplace_back( std::make_pair( "BasisSurface", m_BasisSurface ) );
	if( !m_Boundaries.empty() )
	{
		shared_ptr<AttributeObjectVector> Boundaries_vec_object( new AttributeObjectVector() );
		std::copy( m_Boundaries.begin(), m_Boundaries.end(), std::back_inserter( Boundaries_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "Boundaries", Boundaries_vec_object ) );
	}
	vec_attributes.emplace_back( std::make_pair( "ImplicitOuter", m_ImplicitOuter ) );
}
void IfcCurveBoundedSurface::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcBoundedSurface::getAttributesInverse( vec_attributes_inverse );
}
void IfcCurveBoundedSurface::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcBoundedSurface::setInverseCounterparts( ptr_self_entity );
}
void IfcCurveBoundedSurface::unlinkFromInverseCounterparts()
{
	IfcBoundedSurface::unlinkFromInverseCounterparts();
}
