#!/usr/bin/env perl

# $Header: /cvs/src/jbofihe/mkdict.pl,v 1.1 2001/01/11 21:34:14 richard Exp $

# Script to build dictionary compiler inputs from gismu and cmavo files.

#
# Copyright (C) Richard P. Curnow  1998-2001
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
# 
#

open (IN, "<reduced_gismu") || die "Cannot open reduced_gismu";
while (<IN>) {
    chomp;
    $gis = substr($_,0,6);
    $gis =~ s/[ \t]+$//o;
    $eng = substr($_,19,20);
    $eng =~ s/([^ ])[ ]*$/$1/;
    print $gis.":".$eng."\n";
    $raf = substr($_, 6, 12);
    $raf =~ s/[ \t]+/ /og;
    $raf =~ s/^ //o;
    $raf =~ s/ $//o;
    @raf = split / /, $raf;
    for $r (@raf) {
        print "%".$r.":".$eng."\n";
        print "@".$r.":".$gis."\n";
    }
    if (length($gis) == 5) {
        $raf4 = substr($gis,0,4);
        print "%".$raf4.":".$eng."\n";
        print "@".$raf4.":".$gis."\n";

    }
}

close (IN);

open (IN, "<reduced_cmavo") || die "Cannot open reduced_cmavo";
while(<IN>) {
    chomp;
    $cma = substr($_,0,10);
    $cma =~ s/[ \t]+$//o;
    $cma =~ s/^[ \t]+//o;
    $cma =~ s/^\.//;
    $sma = substr($_,10,6);
    $sma =~ s/[ \t]+$//o;
    $sma =~ s/^[ \t]+//o;
    $sma =~ s/^\.//;
    $eng = substr($_,20,40);
    $eng =~ s/[ \t]+$//o;

    print $cma.":".$eng."\n";
    print "+".$cma.":".$sma."\n";

}
close(IN);


