/*
 * This file derives from SFMT 1.3.3
 * (http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/SFMT/index.html), which was
 * released under the terms of the following license:
 *
 *   Copyright (c) 2006,2007 Mutsuo Saito, Makoto Matsumoto and Hiroshima
 *   University. All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions are
 *   met:
 *
 *       * Redistributions of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 *       * Redistributions in binary form must reproduce the above
 *         copyright notice, this list of conditions and the following
 *         disclaimer in the documentation and/or other materials provided
 *         with the distribution.
 *       * Neither the name of the Hiroshima University nor the names of
 *         its contributors may be used to endorse or promote products
 *         derived from this software without specific prior written
 *         permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "test/jemalloc_test.h"

#define	BLOCK_SIZE 10000
#define	BLOCK_SIZE64 (BLOCK_SIZE / 2)
#define	COUNT_1 1000
#define	COUNT_2 700

static const uint32_t init_gen_rand_32_expected[] = {
	3440181298U, 1564997079U, 1510669302U, 2930277156U, 1452439940U,
	3796268453U,  423124208U, 2143818589U, 3827219408U, 2987036003U,
	2674978610U, 1536842514U, 2027035537U, 2534897563U, 1686527725U,
	 545368292U, 1489013321U, 1370534252U, 4231012796U, 3994803019U,
	1764869045U,  824597505U,  862581900U, 2469764249U,  812862514U,
	 359318673U,  116957936U, 3367389672U, 2327178354U, 1898245200U,
	3206507879U, 2378925033U, 1040214787U, 2524778605U, 3088428700U,
	1417665896U,  964324147U, 2282797708U, 2456269299U,  313400376U,
	2245093271U, 1015729427U, 2694465011U, 3246975184U, 1992793635U,
	 463679346U, 3721104591U, 3475064196U,  856141236U, 1499559719U,
	3522818941U, 3721533109U, 1954826617U, 1282044024U, 1543279136U,
	1301863085U, 2669145051U, 4221477354U, 3896016841U, 3392740262U,
	 462466863U, 1037679449U, 1228140306U,  922298197U, 1205109853U,
	1872938061U, 3102547608U, 2742766808U, 1888626088U, 4028039414U,
	 157593879U, 1136901695U, 4038377686U, 3572517236U, 4231706728U,
	2997311961U, 1189931652U, 3981543765U, 2826166703U,   87159245U,
	1721379072U, 3897926942U, 1790395498U, 2569178939U, 1047368729U,
	2340259131U, 3144212906U, 2301169789U, 2442885464U, 3034046771U,
	3667880593U, 3935928400U, 2372805237U, 1666397115U, 2460584504U,
	 513866770U, 3810869743U, 2147400037U, 2792078025U, 2941761810U,
	3212265810U,  984692259U,  346590253U, 1804179199U, 3298543443U,
	 750108141U, 2880257022U,  243310542U, 1869036465U, 1588062513U,
	2983949551U, 1931450364U, 4034505847U, 2735030199U, 1628461061U,
	2539522841U,  127965585U, 3992448871U,  913388237U,  559130076U,
	1202933193U, 4087643167U, 2590021067U, 2256240196U, 1746697293U,
	1013913783U, 1155864921U, 2715773730U,  915061862U, 1948766573U,
	2322882854U, 3761119102U, 1343405684U, 3078711943U, 3067431651U,
	3245156316U, 3588354584U, 3484623306U, 3899621563U, 4156689741U,
	3237090058U, 3880063844U,  862416318U, 4039923869U, 2303788317U,
	3073590536U,  701653667U, 2131530884U, 3169309950U, 2028486980U,
	 747196777U, 3620218225U,  432016035U, 1449580595U, 2772266392U,
	 444224948U, 1662832057U, 3184055582U, 3028331792U, 1861686254U,
	1104864179U,  342430307U, 1350510923U, 3024656237U, 1028417492U,
	2870772950U,  290847558U, 3675663500U,  508431529U, 4264340390U,
	2263569913U, 1669302976U,  519511383U, 2706411211U, 3764615828U,
	3883162495U, 4051445305U, 2412729798U, 3299405164U, 3991911166U,
	2348767304U, 2664054906U, 3763609282U,  593943581U, 3757090046U,
	2075338894U, 2020550814U, 4287452920U, 4290140003U, 1422957317U,
	2512716667U, 2003485045U, 2307520103U, 2288472169U, 3940751663U,
	4204638664U, 2892583423U, 1710068300U, 3904755993U, 2363243951U,
	3038334120U,  547099465U,  771105860U, 3199983734U, 4282046461U,
	2298388363U,  934810218U, 2837827901U, 3952500708U, 2095130248U,
	3083335297U,   26885281U, 3932155283U, 1531751116U, 1425227133U,
	 495654159U, 3279634176U, 3855562207U, 3957195338U, 4159985527U,
	 893375062U, 1875515536U, 1327247422U, 3754140693U, 1028923197U,
	1729880440U,  805571298U,  448971099U, 2726757106U, 2749436461U,
	2485987104U,  175337042U, 3235477922U, 3882114302U, 2020970972U,
	 943926109U, 2762587195U, 1904195558U, 3452650564U,  108432281U,
	3893463573U, 3977583081U, 2636504348U, 1110673525U, 3548479841U,
	4258854744U,  980047703U, 4057175418U, 3890008292U,  145653646U,
	3141868989U, 3293216228U, 1194331837U, 1254570642U, 3049934521U,
	2868313360U, 2886032750U, 1110873820U,  279553524U, 3007258565U,
	1104807822U, 3186961098U,  315764646U, 2163680838U, 3574508994U,
	3099755655U,  191957684U, 3642656737U, 3317946149U, 3522087636U,
	 444526410U,  779157624U, 1088229627U, 1092460223U, 1856013765U,
	3659877367U,  368270451U,  503570716U, 3000984671U, 2742789647U,
	 928097709U, 2914109539U,  308843566U, 2816161253U, 3667192079U,
	2762679057U, 3395240989U, 2928925038U, 1491465914U, 3458702834U,
	3787782576U, 2894104823U, 1296880455U, 1253636503U,  989959407U,
	2291560361U, 2776790436U, 1913178042U, 1584677829U,  689637520U,
	1898406878U,  688391508U, 3385234998U,  845493284U, 1943591856U,
	2720472050U,  222695101U, 1653320868U, 2904632120U, 4084936008U,
	1080720688U, 3938032556U,  387896427U, 2650839632U,   99042991U,
	1720913794U, 1047186003U, 1877048040U, 2090457659U,  517087501U,
	4172014665U, 2129713163U, 2413533132U, 2760285054U, 4129272496U,
	1317737175U, 2309566414U, 2228873332U, 3889671280U, 1110864630U,
	3576797776U, 2074552772U,  832002644U, 3097122623U, 2464859298U,
	2679603822U, 1667489885U, 3237652716U, 1478413938U, 1719340335U,
	2306631119U,  639727358U, 3369698270U,  226902796U, 2099920751U,
	1892289957U, 2201594097U, 3508197013U, 3495811856U, 3900381493U,
	 841660320U, 3974501451U, 3360949056U, 1676829340U,  728899254U,
	2047809627U, 2390948962U,  670165943U, 3412951831U, 4189320049U,
	1911595255U, 2055363086U,  507170575U,  418219594U, 4141495280U,
	2692088692U, 4203630654U, 3540093932U,  791986533U, 2237921051U,
	2526864324U, 2956616642U, 1394958700U, 1983768223U, 1893373266U,
	 591653646U,  228432437U, 1611046598U, 3007736357U, 1040040725U,
	2726180733U, 2789804360U, 4263568405U,  829098158U, 3847722805U,
	1123578029U, 1804276347U,  997971319U, 4203797076U, 4185199713U,
	2811733626U, 2343642194U, 2985262313U, 1417930827U, 3759587724U,
	1967077982U, 1585223204U, 1097475516U, 1903944948U,  740382444U,
	1114142065U, 1541796065U, 1718384172U, 1544076191U, 1134682254U,
	3519754455U, 2866243923U,  341865437U,  645498576U, 2690735853U,
	1046963033U, 2493178460U, 1187604696U, 1619577821U,  488503634U,
	3255768161U, 2306666149U, 1630514044U, 2377698367U, 2751503746U,
	3794467088U, 1796415981U, 3657173746U,  409136296U, 1387122342U,
	1297726519U,  219544855U, 4270285558U,  437578827U, 1444698679U,
	2258519491U,  963109892U, 3982244073U, 3351535275U,  385328496U,
	1804784013U,  698059346U, 3920535147U,  708331212U,  784338163U,
	 785678147U, 1238376158U, 1557298846U, 2037809321U,  271576218U,
	4145155269U, 1913481602U, 2763691931U,  588981080U, 1201098051U,
	3717640232U, 1509206239U,  662536967U, 3180523616U, 1133105435U,
	2963500837U, 2253971215U, 3153642623U, 1066925709U, 2582781958U,
	3034720222U, 1090798544U, 2942170004U, 4036187520U,  686972531U,
	2610990302U, 2641437026U, 1837562420U,  722096247U, 1315333033U,
	2102231203U, 3402389208U, 3403698140U, 1312402831U, 2898426558U,
	 814384596U,  385649582U, 1916643285U, 1924625106U, 2512905582U,
	2501170304U, 4275223366U, 2841225246U, 1467663688U, 3563567847U,
	2969208552U,  884750901U,  102992576U,  227844301U, 3681442994U,
	3502881894U, 4034693299U, 1166727018U, 1697460687U, 1737778332U,
	1787161139U, 1053003655U, 1215024478U, 2791616766U, 2525841204U,
	1629323443U,    3233815U, 2003823032U, 3083834263U, 2379264872U,
	3752392312U, 1287475550U, 3770904171U, 3004244617U, 1502117784U,
	 918698423U, 2419857538U, 3864502062U, 1751322107U, 2188775056U,
	4018728324U,  983712955U,  440071928U, 3710838677U, 2001027698U,
	3994702151U,   22493119U, 3584400918U, 3446253670U, 4254789085U,
	1405447860U, 1240245579U, 1800644159U, 1661363424U, 3278326132U,
	3403623451U,   67092802U, 2609352193U, 3914150340U, 1814842761U,
	3610830847U,  591531412U, 3880232807U, 1673505890U, 2585326991U,
	1678544474U, 3148435887U, 3457217359U, 1193226330U, 2816576908U,
	 154025329U,  121678860U, 1164915738U,  973873761U,  269116100U,
	  52087970U,  744015362U,  498556057U,   94298882U, 1563271621U,
	2383059628U, 4197367290U, 3958472990U, 2592083636U, 2906408439U,
	1097742433U, 3924840517U,  264557272U, 2292287003U, 3203307984U,
	4047038857U, 3820609705U, 2333416067U, 1839206046U, 3600944252U,
	3412254904U,  583538222U, 2390557166U, 4140459427U, 2810357445U,
	 226777499U, 2496151295U, 2207301712U, 3283683112U,  611630281U,
	1933218215U, 3315610954U, 3889441987U, 3719454256U, 3957190521U,
	1313998161U, 2365383016U, 3146941060U, 1801206260U,  796124080U,
	2076248581U, 1747472464U, 3254365145U,  595543130U, 3573909503U,
	3758250204U, 2020768540U, 2439254210U,   93368951U, 3155792250U,
	2600232980U, 3709198295U, 3894900440U, 2971850836U, 1578909644U,
	1443493395U, 2581621665U, 3086506297U, 2443465861U,  558107211U,
	1519367835U,  249149686U,  908102264U, 2588765675U, 1232743965U,
	1001330373U, 3561331654U, 2259301289U, 1564977624U, 3835077093U,
	 727244906U, 4255738067U, 1214133513U, 2570786021U, 3899704621U,
	1633861986U, 1636979509U, 1438500431U,   58463278U, 2823485629U,
	2297430187U, 2926781924U, 3371352948U, 1864009023U, 2722267973U,
	1444292075U,  437703973U, 1060414512U,  189705863U,  910018135U,
	4077357964U,  884213423U, 2644986052U, 3973488374U, 1187906116U,
	2331207875U,  780463700U, 3713351662U, 3854611290U,  412805574U,
	2978462572U, 2176222820U,  829424696U, 2790788332U, 2750819108U,
	1594611657U, 3899878394U, 3032870364U, 1702887682U, 1948167778U,
	  14130042U,  192292500U,  947227076U,   90719497U, 3854230320U,
	 784028434U, 2142399787U, 1563449646U, 2844400217U,  819143172U,
	2883302356U, 2328055304U, 1328532246U, 2603885363U, 3375188924U,
	 933941291U, 3627039714U, 2129697284U, 2167253953U, 2506905438U,
	1412424497U, 2981395985U, 1418359660U, 2925902456U,   52752784U,
	3713667988U, 3924669405U,  648975707U, 1145520213U, 4018650664U,
	3805915440U, 2380542088U, 2013260958U, 3262572197U, 2465078101U,
	1114540067U, 3728768081U, 2396958768U,  590672271U,  904818725U,
	4263660715U,  700754408U, 1042601829U, 4094111823U, 4274838909U,
	2512692617U, 2774300207U, 2057306915U, 3470942453U,   99333088U,
	1142661026U, 2889931380U,   14316674U, 2201179167U,  415289459U,
	 448265759U, 3515142743U, 3254903683U,  246633281U, 1184307224U,
	2418347830U, 2092967314U, 2682072314U, 2558750234U, 2000352263U,
	1544150531U,  399010405U, 1513946097U,  499682937U,  461167460U,
	3045570638U, 1633669705U,  851492362U, 4052801922U, 2055266765U,
	 635556996U,  368266356U, 2385737383U, 3218202352U, 2603772408U,
	 349178792U,  226482567U, 3102426060U, 3575998268U, 2103001871U,
	3243137071U,  225500688U, 1634718593U, 4283311431U, 4292122923U,
	3842802787U,  811735523U,  105712518U,  663434053U, 1855889273U,
	2847972595U, 1196355421U, 2552150115U, 4254510614U, 3752181265U,
	3430721819U, 3828705396U, 3436287905U, 3441964937U, 4123670631U,
	 353001539U,  459496439U, 3799690868U, 1293777660U, 2761079737U,
	 498096339U, 3398433374U, 4080378380U, 2304691596U, 2995729055U,
	4134660419U, 3903444024U, 3576494993U,  203682175U, 3321164857U,
	2747963611U,   79749085U, 2992890370U, 1240278549U, 1772175713U,
	2111331972U, 2655023449U, 1683896345U, 2836027212U, 3482868021U,
	2489884874U,  756853961U, 2298874501U, 4013448667U, 4143996022U,
	2948306858U, 4132920035U, 1283299272U,  995592228U, 3450508595U,
	1027845759U, 1766942720U, 3861411826U, 1446861231U,   95974993U,
	3502263554U, 1487532194U,  601502472U, 4129619129U,  250131773U,
	2050079547U, 3198903947U, 3105589778U, 4066481316U, 3026383978U,
	2276901713U,  365637751U, 2260718426U, 1394775634U, 1791172338U,
	2690503163U, 2952737846U, 1568710462U,  732623190U, 2980358000U,
	1053631832U, 1432426951U, 3229149635U, 1854113985U, 3719733532U,
	3204031934U,  735775531U,  107468620U, 3734611984U,  631009402U,
	3083622457U, 4109580626U,  159373458U, 1301970201U, 4132389302U,
	1293255004U,  847182752U, 4170022737U,   96712900U, 2641406755U,
	1381727755U,  405608287U, 4287919625U, 1703554290U, 3589580244U,
	2911403488U,    2166565U, 2647306451U, 2330535117U, 1200815358U,
	1165916754U,  245060911U, 4040679071U, 3684908771U, 2452834126U,
	2486872773U, 2318678365U, 2940627908U, 1837837240U, 3447897409U,
	4270484676U, 1495388728U, 3754288477U, 4204167884U, 1386977705U,
	2692224733U, 3076249689U, 4109568048U, 4170955115U, 4167531356U,
	4020189950U, 4261855038U, 3036907575U, 3410399885U, 3076395737U,
	1046178638U,  144496770U,  230725846U, 3349637149U,   17065717U,
	2809932048U, 2054581785U, 3608424964U, 3259628808U,  134897388U,
	3743067463U,  257685904U, 3795656590U, 1562468719U, 3589103904U,
	3120404710U,  254684547U, 2653661580U, 3663904795U, 2631942758U,
	1063234347U, 2609732900U, 2332080715U, 3521125233U, 1180599599U,
	1935868586U, 4110970440U,  296706371U, 2128666368U, 1319875791U,
	1570900197U, 3096025483U, 1799882517U, 1928302007U, 1163707758U,
	1244491489U, 3533770203U,  567496053U, 2757924305U, 2781639343U,
	2818420107U,  560404889U, 2619609724U, 4176035430U, 2511289753U,
	2521842019U, 3910553502U, 2926149387U, 3302078172U, 4237118867U,
	 330725126U,  367400677U,  888239854U,  545570454U, 4259590525U,
	 134343617U, 1102169784U, 1647463719U, 3260979784U, 1518840883U,
	3631537963U, 3342671457U, 1301549147U, 2083739356U,  146593792U,
	3217959080U,  652755743U, 2032187193U, 3898758414U, 1021358093U,
	4037409230U, 2176407931U, 3427391950U, 2883553603U,  985613827U,
	3105265092U, 3423168427U, 3387507672U,  467170288U, 2141266163U,
	3723870208U,  916410914U, 1293987799U, 2652584950U,  769160137U,
	3205292896U, 1561287359U, 1684510084U, 3136055621U, 3765171391U,
	 639683232U, 2639569327U, 1218546948U, 4263586685U, 3058215773U,
	2352279820U,  401870217U, 2625822463U, 1529125296U, 2981801895U,
	1191285226U, 4027725437U, 3432700217U, 4098835661U,  971182783U,
	2443861173U, 3881457123U, 3874386651U,  457276199U, 2638294160U,
	4002809368U,  421169044U, 1112642589U, 3076213779U, 3387033971U,
	2499610950U, 3057240914U, 1662679783U,  461224431U, 1168395933U
};
static const uint32_t init_by_array_32_expected[] = {
	2920711183U, 3885745737U, 3501893680U,  856470934U, 1421864068U,
	 277361036U, 1518638004U, 2328404353U, 3355513634U,   64329189U,
	1624587673U, 3508467182U, 2481792141U, 3706480799U, 1925859037U,
	2913275699U,  882658412U,  384641219U,  422202002U, 1873384891U,
	2006084383U, 3924929912U, 1636718106U, 3108838742U, 1245465724U,
	4195470535U,  779207191U, 1577721373U, 1390469554U, 2928648150U,
	 121399709U, 3170839019U, 4044347501U,  953953814U, 3821710850U,
	3085591323U, 3666535579U, 3577837737U, 2012008410U, 3565417471U,
	4044408017U,  433600965U, 1637785608U, 1798509764U,  860770589U,
	3081466273U, 3982393409U, 2451928325U, 3437124742U, 4093828739U,
	3357389386U, 2154596123U,  496568176U, 2650035164U, 2472361850U,
	   3438299U, 2150366101U, 1577256676U, 3802546413U, 1787774626U,
	4078331588U, 3706103141U,  170391138U, 3806085154U, 1680970100U,
	1961637521U, 3316029766U,  890610272U, 1453751581U, 1430283664U,
	3051057411U, 3597003186U,  542563954U, 3796490244U, 1690016688U,
	3448752238U,  440702173U,  347290497U, 1121336647U, 2540588620U,
	 280881896U, 2495136428U,  213707396U,   15104824U, 2946180358U,
	 659000016U,  566379385U, 2614030979U, 2855760170U,  334526548U,
	2315569495U, 2729518615U,  564745877U, 1263517638U, 3157185798U,
	1604852056U, 1011639885U, 2950579535U, 2524219188U,  312951012U,
	1528896652U, 1327861054U, 2846910138U, 3966855905U, 2536721582U,
	 855353911U, 1685434729U, 3303978929U, 1624872055U, 4020329649U,
	3164802143U, 1642802700U, 1957727869U, 1792352426U, 3334618929U,
	2631577923U, 3027156164U,  842334259U, 3353446843U, 1226432104U,
	1742801369U, 3552852535U, 3471698828U, 1653910186U, 3380330939U,
	2313782701U, 3351007196U, 2129839995U, 1800682418U, 4085884420U,
	1625156629U, 3669701987U,  615211810U, 3294791649U, 4131143784U,
	2590843588U, 3207422808U, 3275066464U,  561592872U, 3957205738U,
	3396578098U,   48410678U, 3505556445U, 1005764855U, 3920606528U,
	2936980473U, 2378918600U, 2404449845U, 1649515163U,  701203563U,
	3705256349U,   83714199U, 3586854132U,  922978446U, 2863406304U,
	3523398907U, 2606864832U, 2385399361U, 3171757816U, 4262841009U,
	3645837721U, 1169579486U, 3666433897U, 3174689479U, 1457866976U,
	3803895110U, 3346639145U, 1907224409U, 1978473712U, 1036712794U,
	 980754888U, 1302782359U, 1765252468U,  459245755U, 3728923860U,
	1512894209U, 2046491914U,  207860527U,  514188684U, 2288713615U,
	1597354672U, 3349636117U, 2357291114U, 3995796221U,  945364213U,
	1893326518U, 3770814016U, 1691552714U, 2397527410U,  967486361U,
	 776416472U, 4197661421U,  951150819U, 1852770983U, 4044624181U,
	1399439738U, 4194455275U, 2284037669U, 1550734958U, 3321078108U,
	1865235926U, 2912129961U, 2664980877U, 1357572033U, 2600196436U,
	2486728200U, 2372668724U, 1567316966U, 2374111491U, 1839843570U,
	  20815612U, 3727008608U, 3871996229U,  824061249U, 1932503978U,
	3404541726U,  758428924U, 2609331364U, 1223966026U, 1299179808U,
	 648499352U, 2180134401U,  880821170U, 3781130950U,  113491270U,
	1032413764U, 4185884695U, 2490396037U, 1201932817U, 4060951446U,
	4165586898U, 1629813212U, 2887821158U,  415045333U,  628926856U,
	2193466079U, 3391843445U, 2227540681U, 1907099846U, 2848448395U,
	1717828221U, 1372704537U, 1707549841U, 2294058813U, 2101214437U,
	2052479531U, 1695809164U, 3176587306U, 2632770465U,   81634404U,
	1603220563U,  644238487U,  302857763U,  897352968U, 2613146653U,
	1391730149U, 4245717312U, 4191828749U, 1948492526U, 2618174230U,
	3992984522U, 2178852787U, 3596044509U, 3445573503U, 2026614616U,
	 915763564U, 3415689334U, 2532153403U, 3879661562U, 2215027417U,
	3111154986U, 2929478371U,  668346391U, 1152241381U, 2632029711U,
	3004150659U, 2135025926U,  948690501U, 2799119116U, 4228829406U,
	1981197489U, 4209064138U,  684318751U, 3459397845U,  201790843U,
	4022541136U, 3043635877U,  492509624U, 3263466772U, 1509148086U,
	 921459029U, 3198857146U,  705479721U, 3835966910U, 3603356465U,
	 576159741U, 1742849431U,  594214882U, 2055294343U, 3634861861U,
	 449571793U, 3246390646U, 3868232151U, 1479156585U, 2900125656U,
	2464815318U, 3960178104U, 1784261920U,   18311476U, 3627135050U,
	 644609697U,  424968996U,  919890700U, 2986824110U,  816423214U,
	4003562844U, 1392714305U, 1757384428U, 2569030598U,  995949559U,
	3875659880U, 2933807823U, 2752536860U, 2993858466U, 4030558899U,
	2770783427U, 2775406005U, 2777781742U, 1931292655U,  472147933U,
	3865853827U, 2726470545U, 2668412860U, 2887008249U,  408979190U,
	3578063323U, 3242082049U, 1778193530U,   27981909U, 2362826515U,
	 389875677U, 1043878156U,  581653903U, 3830568952U,  389535942U,
	3713523185U, 2768373359U, 2526101582U, 1998618197U, 1160859704U,
	3951172488U, 1098005003U,  906275699U, 3446228002U, 2220677963U,
	2059306445U,  132199571U,  476838790U, 1868039399U, 3097344807U,
	 857300945U,  396345050U, 2835919916U, 1782168828U, 1419519470U,
	4288137521U,  819087232U,  596301494U,  872823172U, 1526888217U,
	 805161465U, 1116186205U, 2829002754U, 2352620120U,  620121516U,
	 354159268U, 3601949785U,  209568138U, 1352371732U, 2145977349U,
	4236871834U, 1539414078U, 3558126206U, 3224857093U, 4164166682U,
	3817553440U, 3301780278U, 2682696837U, 3734994768U, 1370950260U,
	1477421202U, 2521315749U, 1330148125U, 1261554731U, 2769143688U,
	3554756293U, 4235882678U, 3254686059U, 3530579953U, 1215452615U,
	3574970923U, 4057131421U,  589224178U, 1000098193U,  171190718U,
	2521852045U, 2351447494U, 2284441580U, 2646685513U, 3486933563U,
	3789864960U, 1190528160U, 1702536782U, 1534105589U, 4262946827U,
	2726686826U, 3584544841U, 2348270128U, 2145092281U, 2502718509U,
	1027832411U, 3571171153U, 1287361161U, 4011474411U, 3241215351U,
	2419700818U,  971242709U, 1361975763U, 1096842482U, 3271045537U,
	  81165449U,  612438025U, 3912966678U, 1356929810U,  733545735U,
	 537003843U, 1282953084U,  884458241U,  588930090U, 3930269801U,
	2961472450U, 1219535534U, 3632251943U,  268183903U, 1441240533U,
	3653903360U, 3854473319U, 2259087390U, 2548293048U, 2022641195U,
	2105543911U, 1764085217U, 3246183186U,  482438805U,  888317895U,
	2628314765U, 2466219854U,  717546004U, 2322237039U,  416725234U,
	1544049923U, 1797944973U, 3398652364U, 3111909456U,  485742908U,
	2277491072U, 1056355088U, 3181001278U,  129695079U, 2693624550U,
	1764438564U, 3797785470U,  195503713U, 3266519725U, 2053389444U,
	1961527818U, 3400226523U, 3777903038U, 2597274307U, 4235851091U,
	4094406648U, 2171410785U, 1781151386U, 1378577117U,  654643266U,
	3424024173U, 3385813322U,  679385799U,  479380913U,  681715441U,
	3096225905U,  276813409U, 3854398070U, 2721105350U,  831263315U,
	3276280337U, 2628301522U, 3984868494U, 1466099834U, 2104922114U,
	1412672743U,  820330404U, 3491501010U,  942735832U,  710652807U,
	3972652090U,  679881088U,   40577009U, 3705286397U, 2815423480U,
	3566262429U,  663396513U, 3777887429U, 4016670678U,  404539370U,
	1142712925U, 1140173408U, 2913248352U, 2872321286U,  263751841U,
	3175196073U, 3162557581U, 2878996619U,   75498548U, 3836833140U,
	3284664959U, 1157523805U,  112847376U,  207855609U, 1337979698U,
	1222578451U,  157107174U,  901174378U, 3883717063U, 1618632639U,
	1767889440U, 4264698824U, 1582999313U,  884471997U, 2508825098U,
	3756370771U, 2457213553U, 3565776881U, 3709583214U,  915609601U,
	 460833524U, 1091049576U,   85522880U,    2553251U,  132102809U,
	2429882442U, 2562084610U, 1386507633U, 4112471229U,   21965213U,
	1981516006U, 2418435617U, 3054872091U, 4251511224U, 2025783543U,
	1916911512U, 2454491136U, 3938440891U, 3825869115U, 1121698605U,
	3463052265U,  802340101U, 1912886800U, 4031997367U, 3550640406U,
	1596096923U,  610150600U,  431464457U, 2541325046U,  486478003U,
	 739704936U, 2862696430U, 3037903166U, 1129749694U, 2611481261U,
	1228993498U,  510075548U, 3424962587U, 2458689681U,  818934833U,
	4233309125U, 1608196251U, 3419476016U, 1858543939U, 2682166524U,
	3317854285U,  631986188U, 3008214764U,  613826412U, 3567358221U,
	3512343882U, 1552467474U, 3316162670U, 1275841024U, 4142173454U,
	 565267881U,  768644821U,  198310105U, 2396688616U, 1837659011U,
	 203429334U,  854539004U, 4235811518U, 3338304926U, 3730418692U,
	3852254981U, 3032046452U, 2329811860U, 2303590566U, 2696092212U,
	3894665932U,  145835667U,  249563655U, 1932210840U, 2431696407U,
	3312636759U,  214962629U, 2092026914U, 3020145527U, 4073039873U,
	2739105705U, 1308336752U,  855104522U, 2391715321U,   67448785U,
	 547989482U,  854411802U, 3608633740U,  431731530U,  537375589U,
	3888005760U,  696099141U,  397343236U, 1864511780U,   44029739U,
	1729526891U, 1993398655U, 2010173426U, 2591546756U,  275223291U,
	1503900299U, 4217765081U, 2185635252U, 1122436015U, 3550155364U,
	 681707194U, 3260479338U,  933579397U, 2983029282U, 2505504587U,
	2667410393U, 2962684490U, 4139721708U, 2658172284U, 2452602383U,
	2607631612U, 1344296217U, 3075398709U, 2949785295U, 1049956168U,
	3917185129U, 2155660174U, 3280524475U, 1503827867U,  674380765U,
	1918468193U, 3843983676U,  634358221U, 2538335643U, 1873351298U,
	3368723763U, 2129144130U, 3203528633U, 3087174986U, 2691698871U,
	2516284287U,   24437745U, 1118381474U, 2816314867U, 2448576035U,
	4281989654U,  217287825U,  165872888U, 2628995722U, 3533525116U,
	2721669106U,  872340568U, 3429930655U, 3309047304U, 3916704967U,
	3270160355U, 1348884255U, 1634797670U,  881214967U, 4259633554U,
	 174613027U, 1103974314U, 1625224232U, 2678368291U, 1133866707U,
	3853082619U, 4073196549U, 1189620777U,  637238656U,  930241537U,
	4042750792U, 3842136042U, 2417007212U, 2524907510U, 1243036827U,
	1282059441U, 3764588774U, 1394459615U, 2323620015U, 1166152231U,
	3307479609U, 3849322257U, 3507445699U, 4247696636U,  758393720U,
	 967665141U, 1095244571U, 1319812152U,  407678762U, 2640605208U,
	2170766134U, 3663594275U, 4039329364U, 2512175520U,  725523154U,
	2249807004U, 3312617979U, 2414634172U, 1278482215U,  349206484U,
	1573063308U, 1196429124U, 3873264116U, 2400067801U,  268795167U,
	 226175489U, 2961367263U, 1968719665U,   42656370U, 1010790699U,
	 561600615U, 2422453992U, 3082197735U, 1636700484U, 3977715296U,
	3125350482U, 3478021514U, 2227819446U, 1540868045U, 3061908980U,
	1087362407U, 3625200291U,  361937537U,  580441897U, 1520043666U,
	2270875402U, 1009161260U, 2502355842U, 4278769785U,  473902412U,
	1057239083U, 1905829039U, 1483781177U, 2080011417U, 1207494246U,
	1806991954U, 2194674403U, 3455972205U,  807207678U, 3655655687U,
	 674112918U,  195425752U, 3917890095U, 1874364234U, 1837892715U,
	3663478166U, 1548892014U, 2570748714U, 2049929836U, 2167029704U,
	 697543767U, 3499545023U, 3342496315U, 1725251190U, 3561387469U,
	2905606616U, 1580182447U, 3934525927U, 4103172792U, 1365672522U,
	1534795737U, 3308667416U, 2841911405U, 3943182730U, 4072020313U,
	3494770452U, 3332626671U,   55327267U,  478030603U,  411080625U,
	3419529010U, 1604767823U, 3513468014U,  570668510U,  913790824U,
	2283967995U,  695159462U, 3825542932U, 4150698144U, 1829758699U,
	 202895590U, 1609122645U, 1267651008U, 2910315509U, 2511475445U,
	2477423819U, 3932081579U,  900879979U, 2145588390U, 2670007504U,
	 580819444U, 1864996828U, 2526325979U, 1019124258U,  815508628U,
	2765933989U, 1277301341U, 3006021786U,  855540956U,  288025710U,
	1919594237U, 2331223864U,  177452412U, 2475870369U, 2689291749U,
	 865194284U,  253432152U, 2628531804U, 2861208555U, 2361597573U,
	1653952120U, 1039661024U, 2159959078U, 3709040440U, 3564718533U,
	2596878672U, 2041442161U,   31164696U, 2662962485U, 3665637339U,
	1678115244U, 2699839832U, 3651968520U, 3521595541U,  458433303U,
	2423096824U,   21831741U,  380011703U, 2498168716U,  861806087U,
	1673574843U, 4188794405U, 2520563651U, 2632279153U, 2170465525U,
	4171949898U, 3886039621U, 1661344005U, 3424285243U,  992588372U,
	2500984144U, 2993248497U, 3590193895U, 1535327365U,  515645636U,
	 131633450U, 3729760261U, 1613045101U, 3254194278U,   15889678U,
	1493590689U,  244148718U, 2991472662U, 1401629333U,  777349878U,
	2501401703U, 4285518317U, 3794656178U,  955526526U, 3442142820U,
	3970298374U,  736025417U, 2737370764U, 1271509744U,  440570731U,
	 136141826U, 1596189518U,  923399175U,  257541519U, 3505774281U,
	2194358432U, 2518162991U, 1379893637U, 2667767062U, 3748146247U,
	1821712620U, 3923161384U, 1947811444U, 2392527197U, 4127419685U,
	1423694998U, 4156576871U, 1382885582U, 3420127279U, 3617499534U,
	2994377493U, 4038063986U, 1918458672U, 2983166794U, 4200449033U,
	 353294540U, 1609232588U,  243926648U, 2332803291U,  507996832U,
	2392838793U, 4075145196U, 2060984340U, 4287475136U,   88232602U,
	2491531140U, 4159725633U, 2272075455U,  759298618U,  201384554U,
	 838356250U, 1416268324U,  674476934U,   90795364U,  141672229U,
	3660399588U, 4196417251U, 3249270244U, 3774530247U,   59587265U,
	3683164208U,   19392575U, 1463123697U, 1882205379U,  293780489U,
	2553160622U, 2933904694U,  675638239U, 2851336944U, 1435238743U,
	2448730183U,  804436302U, 2119845972U,  322560608U, 4097732704U,
	2987802540U,  641492617U, 2575442710U, 4217822703U, 3271835300U,
	2836418300U, 3739921620U, 2138378768U, 2879771855U, 4294903423U,
	3121097946U, 2603440486U, 2560820391U, 1012930944U, 2313499967U,
	 584489368U, 3431165766U,  897384869U, 2062537737U, 2847889234U,
	3742362450U, 2951174585U, 4204621084U, 1109373893U, 3668075775U,
	2750138839U, 3518055702U,  733072558U, 4169325400U,  788493625U
};
static const uint64_t init_gen_rand_64_expected[] = {
	QU(16924766246869039260LLU), QU( 8201438687333352714LLU),
	QU( 2265290287015001750LLU), QU(18397264611805473832LLU),
	QU( 3375255223302384358LLU), QU( 6345559975416828796LLU),
	QU(18229739242790328073LLU), QU( 7596792742098800905LLU),
	QU(  255338647169685981LLU), QU( 2052747240048610300LLU),
	QU(18328151576097299343LLU), QU(12472905421133796567LLU),
	QU(11315245349717600863LLU), QU(16594110197775871209LLU),
	QU(15708751964632456450LLU), QU(10452031272054632535LLU),
	QU(11097646720811454386LLU), QU( 4556090668445745441LLU),
	QU(17116187693090663106LLU), QU(14931526836144510645LLU),
	QU( 9190752218020552591LLU), QU( 9625800285771901401LLU),
	QU(13995141077659972832LLU), QU( 5194209094927829625LLU),
	QU( 4156788379151063303LLU), QU( 8523452593770139494LLU),
	QU(14082382103049296727LLU), QU( 2462601863986088483LLU),
	QU( 3030583461592840678LLU), QU( 5221622077872827681LLU),
	QU( 3084210671228981236LLU), QU(13956758381389953823LLU),
	QU(13503889856213423831LLU), QU(15696904024189836170LLU),
	QU( 4612584152877036206LLU), QU( 6231135538447867881LLU),
	QU(10172457294158869468LLU), QU( 6452258628466708150LLU),
	QU(14044432824917330221LLU), QU(  370168364480044279LLU),
	QU(10102144686427193359LLU), QU(  667870489994776076LLU),
	QU( 2732271956925885858LLU), QU(18027788905977284151LLU),
	QU(15009842788582923859LLU), QU( 7136357960180199542LLU),
	QU(15901736243475578127LLU), QU(16951293785352615701LLU),
	QU(10551492125243691632LLU), QU(17668869969146434804LLU),
	QU(13646002971174390445LLU), QU( 9804471050759613248LLU),
	QU( 5511670439655935493LLU), QU(18103342091070400926LLU),
	QU(17224512747665137533LLU), QU(15534627482992618168LLU),
	QU( 1423813266186582647LLU), QU(15821176807932930024LLU),
	QU(   30323369733607156LLU), QU(11599382494723479403LLU),
	QU(  653856076586810062LLU), QU( 3176437395144899659LLU),
	QU(14028076268147963917LLU), QU(16156398271809666195LLU),
	QU( 3166955484848201676LLU), QU( 5746805620136919390LLU),
	QU(17297845208891256593LLU), QU(11691653183226428483LLU),
	QU(17900026146506981577LLU), QU(15387382115755971042LLU),
	QU(16923567681040845943LLU), QU( 8039057517199388606LLU),
	QU(11748409241468629263LLU), QU(  794358245539076095LLU),
	QU(13438501964693401242LLU), QU(14036803236515618962LLU),
	QU( 5252311215205424721LLU), QU(17806589612915509081LLU),
	QU( 6802767092397596006LLU), QU(14212120431184557140LLU),
	QU( 1072951366761385712LLU), QU(13098491780722836296LLU),
	QU( 9466676828710797353LLU), QU(12673056849042830081LLU),
	QU(12763726623645357580LLU), QU(16468961652999309493LLU),
	QU(15305979875636438926LLU), QU(17444713151223449734LLU),
	QU( 5692214267627883674LLU), QU(13049589139196151505LLU),
	QU(  880115207831670745LLU), QU( 1776529075789695498LLU),
	QU(16695225897801466485LLU), QU(10666901778795346845LLU),
	QU( 6164389346722833869LLU), QU( 2863817793264300475LLU),
	QU( 9464049921886304754LLU), QU( 3993566636740015468LLU),
	QU( 9983749692528514136LLU), QU(16375286075057755211LLU),
	QU(16042643417005440820LLU), QU(11445419662923489877LLU),
	QU( 7999038846885158836LLU), QU( 6721913661721511535LLU),
	QU( 5363052654139357320LLU), QU( 1817788761173584205LLU),
	QU(13290974386445856444LLU), QU( 4650350818937984680LLU),
	QU( 8219183528102484836LLU), QU( 1569862923500819899LLU),
	QU( 4189359732136641860LLU), QU(14202822961683148583LLU),
	QU( 4457498315309429058LLU), QU(13089067387019074834LLU),
	QU(11075517153328927293LLU), QU(10277016248336668389LLU),
	QU( 7070509725324401122LLU), QU(17808892017780289380LLU),
	QU(13143367339909287349LLU), QU( 1377743745360085151LLU),
	QU( 5749341807421286485LLU), QU(14832814616770931325LLU),
	QU( 7688820635324359492LLU), QU(10960474011539770045LLU),
	QU(   81970066653179790LLU), QU(12619476072607878022LLU),
	QU( 4419566616271201744LLU), QU(15147917311750568503LLU),
	QU( 5549739182852706345LLU), QU( 7308198397975204770LLU),
	QU(13580425496671289278LLU), QU(17070764785210130301LLU),
	QU( 8202832846285604405LLU), QU( 6873046287640887249LLU),
	QU( 6927424434308206114LLU), QU( 6139014645937224874LLU),
	QU(10290373645978487639LLU), QU(15904261291701523804LLU),
	QU( 9628743442057826883LLU), QU(18383429096255546714LLU),
	QU( 4977413265753686967LLU), QU( 7714317492425012869LLU),
	QU( 9025232586309926193LLU), QU(14627338359776709107LLU),
	QU(14759849896467790763LLU), QU(10931129435864423252LLU),
	QU( 4588456988775014359LLU), QU(10699388531797056724LLU),
	QU(  468652268869238792LLU), QU( 5755943035328078086LLU),
	QU( 2102437379988580216LLU), QU( 9986312786506674028LLU),
	QU( 2654207180040945604LLU), QU( 8726634790559960062LLU),
	QU(  100497234871808137LLU), QU( 2800137176951425819LLU),
	QU( 6076627612918553487LLU), QU( 5780186919186152796LLU),
	QU( 8179183595769929098LLU), QU( 6009426283716221169LLU),
	QU( 2796662551397449358LLU), QU( 1756961367041986764LLU),
	QU( 6972897917355606205LLU), QU(14524774345368968243LLU),
	QU( 2773529684745706940LLU), QU( 4853632376213075959LLU),
	QU( 4198177923731358102LLU), QU( 8271224913084139776LLU),
	QU( 2741753121611092226LLU), QU(16782366145996731181LLU),
	QU(15426125238972640790LLU), QU(13595497100671260342LLU),
	QU( 3173531022836259898LLU), QU( 6573264560319511662LLU),
	QU(18041111951511157441LLU), QU( 2351433581833135952LLU),
	QU( 3113255578908173487LLU), QU( 1739371330877858784LLU),
	QU(16046126562789165480LLU), QU( 8072101652214192925LLU),
	QU(15267091584090664910LLU), QU( 9309579200403648940LLU),
	QU( 5218892439752408722LLU), QU(14492477246004337115LLU),
	QU(17431037586679770619LLU), QU( 7385248135963250480LLU),
	QU( 9580144956565560660LLU), QU( 4919546228040008720LLU),
	QU(15261542469145035584LLU), QU(18233297270822253102LLU),
	QU( 5453248417992302857LLU), QU( 9309519155931460285LLU),
	QU(10342813012345291756LLU), QU(15676085186784762381LLU),
	QU(15912092950691300645LLU), QU( 9371053121499003195LLU),
	QU( 9897186478226866746LLU), QU(14061858287188196327LLU),
	QU(  122575971620788119LLU), QU(12146750969116317754LLU),
	QU( 4438317272813245201LLU), QU( 8332576791009527119LLU),
	QU(13907785691786542057LLU), QU(10374194887283287467LLU),
	QU( 2098798755649059566LLU), QU( 3416235197748288894LLU),
	QU( 8688269957320773484LLU), QU( 7503964602397371571LLU),
	QU(16724977015147478236LLU), QU( 9461512855439858184LLU),
	QU(13259049744534534727LLU), QU( 3583094952542899294LLU),
	QU( 8764245731305528292LLU), QU(13240823595462088985LLU),
	QU(13716141617617910448LLU), QU(18114969519935960955LLU),
	QU( 2297553615798302206LLU), QU( 4585521442944663362LLU),
	QU(17776858680630198686LLU), QU( 4685873229192163363LLU),
	QU(  152558080671135627LLU), QU(15424900540842670088LLU),
	QU(13229630297130024108LLU), QU(17530268788245718717LLU),
	QU(16675633913065714144LLU), QU( 3158912717897568068LLU),
	QU(15399132185380087288LLU), QU( 7401418744515677872LLU),
	QU(13135412922344398535LLU), QU( 6385314346100509511LLU),
	QU(13962867001134161139LLU), QU(10272780155442671999LLU),
	QU(12894856086597769142LLU), QU(13340877795287554994LLU),
	QU(12913630602094607396LLU), QU(12543167911119793857LLU),
	QU(17343570372251873096LLU), QU(10959487764494150545LLU),
	QU( 6966737953093821128LLU), QU(13780699135496988601LLU),
	QU( 4405070719380142046LLU), QU(14923788365607284982LLU),
	QU( 2869487678905148380LLU), QU( 6416272754197188403LLU),
	QU(15017380475943612591LLU), QU( 1995636220918429487LLU),
	QU( 3402016804620122716LLU), QU(15800188663407057080LLU),
	QU(11362369990390932882LLU), QU(15262183501637986147LLU),
	QU(10239175385387371494LLU), QU( 9352042420365748334LLU),
	QU( 1682457034285119875LLU), QU( 1724710651376289644LLU),
	QU( 2038157098893817966LLU), QU( 9897825558324608773LLU),
	QU( 1477666236519164736LLU), QU(16835397314511233640LLU),
	QU(10370866327005346508LLU), QU(10157504370660621982LLU),
	QU(12113904045335882069LLU), QU(13326444439742783008LLU),
	QU(11302769043000765804LLU), QU(13594979923955228484LLU),
	QU(11779351762613475968LLU), QU( 3786101619539298383LLU),
	QU( 8021122969180846063LLU), QU(15745904401162500495LLU),
	QU(10762168465993897267LLU), QU(13552058957896319026LLU),
	QU(11200228655252462013LLU), QU( 5035370357337441226LLU),
	QU( 7593918984545500013LLU), QU( 5418554918361528700LLU),
	QU( 4858270799405446371LLU), QU( 9974659566876282544LLU),
	QU(18227595922273957859LLU), QU( 2772778443635656220LLU),
	QU(14285143053182085385LLU), QU( 9939700992429600469LLU),
	QU(12756185904545598068LLU), QU( 2020783375367345262LLU),
	QU(   57026775058331227LLU), QU(  950827867930065454LLU),
	QU( 6602279670145371217LLU), QU( 2291171535443566929LLU),
	QU( 5832380724425010313LLU), QU( 1220343904715982285LLU),
	QU(17045542598598037633LLU), QU(15460481779702820971LLU),
	QU(13948388779949365130LLU), QU(13975040175430829518LLU),
	QU(17477538238425541763LLU), QU(11104663041851745725LLU),
	QU(15860992957141157587LLU), QU(14529434633012950138LLU),
	QU( 2504838019075394203LLU), QU( 7512113882611121886LLU),
	QU( 4859973559980886617LLU), QU( 1258601555703250219LLU),
	QU(15594548157514316394LLU), QU( 4516730171963773048LLU),
	QU(11380103193905031983LLU), QU( 6809282239982353344LLU),
	QU(18045256930420065002LLU), QU( 2453702683108791859LLU),
	QU(  977214582986981460LLU), QU( 2006410402232713466LLU),
	QU( 6192236267216378358LLU), QU( 3429468402195675253LLU),
	QU(18146933153017348921LLU), QU(17369978576367231139LLU),
	QU( 1246940717230386603LLU), QU(11335758870083327110LLU),
	QU(14166488801730353682LLU), QU( 9008573127269635732LLU),
	QU(10776025389820643815LLU), QU(15087605441903942962LLU),
	QU( 1359542462712147922LLU), QU(13898874411226454206LLU),
	QU(17911176066536804411LLU), QU( 9435590428600085274LLU),
	QU(  294488509967864007LLU), QU( 8890111397567922046LLU),
	QU( 7987823476034328778LLU), QU(13263827582440967651LLU),
	QU( 7503774813106751573LLU), QU(14974747296185646837LLU),
	QU( 8504765037032103375LLU), QU(17340303357444536213LLU),
	QU( 7704610912964485743LLU), QU( 8107533670327205061LLU),
	QU( 9062969835083315985LLU), QU(16968963142126734184LLU),
	QU(12958041214190810180LLU), QU( 2720170147759570200LLU),
	QU( 2986358963942189566LLU), QU(14884226322219356580LLU),
	QU(  286224325144368520LLU), QU(11313800433154279797LLU),
	QU(18366849528439673248LLU), QU(17899725929482368789LLU),
	QU( 3730004284609106799LLU), QU( 1654474302052767205LLU),
	QU( 5006698007047077032LLU), QU( 8196893913601182838LLU),
	QU(15214541774425211640LLU), QU(17391346045606626073LLU),
	QU( 8369003584076969089LLU), QU( 3939046733368550293LLU),
	QU(10178639720308707785LLU), QU( 2180248669304388697LLU),
	QU(   62894391300126322LLU), QU( 9205708961736223191LLU),
	QU( 6837431058165360438LLU), QU( 3150743890848308214LLU),
	QU(17849330658111464583LLU), QU(12214815643135450865LLU),
	QU(13410713840519603402LLU), QU( 3200778126692046802LLU),
	QU(13354780043041779313LLU), QU(  800850022756886036LLU),
	QU(15660052933953067433LLU), QU( 6572823544154375676LLU),
	QU(11030281857015819266LLU), QU(12682241941471433835LLU),
	QU(11654136407300274693LLU), QU( 4517795492388641109LLU),
	QU( 9757017371504524244LLU), QU(17833043400781889277LLU),
	QU(12685085201747792227LLU), QU(10408057728835019573LLU),
	QU(   98370418513455221LLU), QU( 6732663555696848598LLU),
	QU(13248530959948529780LLU), QU( 3530441401230622826LLU),
	QU(18188251992895660615LLU), QU( 1847918354186383756LLU),
	QU( 1127392190402660921LLU), QU(11293734643143819463LLU),
	QU( 3015506344578682982LLU), QU(13852645444071153329LLU),
	QU( 2121359659091349142LLU), QU( 1294604376116677694LLU),
	QU( 5616576231286352318LLU), QU( 7112502442954235625LLU),
	QU(11676228199551561689LLU), QU(12925182803007305359LLU),
	QU( 7852375518160493082LLU), QU( 1136513130539296154LLU),
	QU( 5636923900916593195LLU), QU( 3221077517612607747LLU),
	QU(17784790465798152513LLU), QU( 3554210049056995938LLU),
	QU(17476839685878225874LLU), QU( 3206836372585575732LLU),
	QU( 2765333945644823430LLU), QU(10080070903718799528LLU),
	QU( 5412370818878286353LLU), QU( 9689685887726257728LLU),
	QU( 8236117509123533998LLU), QU( 1951139137165040214LLU),
	QU( 4492205209227980349LLU), QU(16541291230861602967LLU),
	QU( 1424371548301437940LLU), QU( 9117562079669206794LLU),
	QU(14374681563251691625LLU), QU(13873164030199921303LLU),
	QU( 6680317946770936731LLU), QU(15586334026918276214LLU),
	QU(10896213950976109802LLU), QU( 9506261949596413689LLU),
	QU( 9903949574308040616LLU), QU( 6038397344557204470LLU),
	QU(  174601465422373648LLU), QU(15946141191338238030LLU),
	QU(17142225620992044937LLU), QU( 7552030283784477064LLU),
	QU( 2947372384532947997LLU), QU(  510797021688197711LLU),
	QU( 4962499439249363461LLU), QU(   23770320158385357LLU),
	QU(  959774499105138124LLU), QU( 1468396011518788276LLU),
	QU( 2015698006852312308LLU), QU( 4149400718489980136LLU),
	QU( 5992916099522371188LLU), QU(10819182935265531076LLU),
	QU(16189787999192351131LLU), QU(  342833961790261950LLU),
	QU(12470830319550495336LLU), QU(18128495041912812501LLU),
	QU( 1193600899723524337LLU), QU( 9056793666590079770LLU),
	QU( 2154021227041669041LLU), QU( 4963570213951235735LLU),
	QU( 4865075960209211409LLU), QU( 2097724599039942963LLU),
	QU( 2024080278583179845LLU), QU(11527054549196576736LLU),
	QU(10650256084182390252LLU), QU( 4808408648695766755LLU),
	QU( 1642839215013788844LLU), QU(10607187948250398390LLU),
	QU( 7076868166085913508LLU), QU(  730522571106887032LLU),
	QU(12500579240208524895LLU), QU( 4484390097311355324LLU),
	QU(15145801330700623870LLU), QU( 8055827661392944028LLU),
	QU( 5865092976832712268LLU), QU(15159212508053625143LLU),
	QU( 3560964582876483341LLU), QU( 4070052741344438280LLU),
	QU( 6032585709886855634LLU), QU(15643262320904604873LLU),
	QU( 2565119772293371111LLU), QU(  318314293065348260LLU),
	QU(15047458749141511872LLU), QU( 7772788389811528730LLU),
	QU( 7081187494343801976LLU), QU( 6465136009467253947LLU),
	QU(10425940692543362069LLU), QU(  554608190318339115LLU),
	QU(14796699860302125214LLU), QU( 1638153134431111443LLU),
	QU(10336967447052276248LLU), QU( 8412308070396592958LLU),
	QU( 4004557277152051226LLU), QU( 8143598997278774834LLU),
	QU(16413323996508783221LLU), QU(13139418758033994949LLU),
	QU( 9772709138335006667LLU), QU( 2818167159287157659LLU),
	QU(17091740573832523669LLU), QU(14629199013130751608LLU),
	QU(18268322711500338185LLU), QU( 8290963415675493063LLU),
	QU( 8830864907452542588LLU), QU( 1614839084637494849LLU),
	QU(14855358500870422231LLU), QU( 3472996748392519937LLU),
	QU(15317151166268877716LLU), QU( 5825895018698400362LLU),
	QU(16730208429367544129LLU), QU(10481156578141202800LLU),
	QU( 4746166512382823750LLU), QU(12720876014472464998LLU),
	QU( 8825177124486735972LLU), QU(13733447296837467838LLU),
	QU( 6412293741681359625LLU), QU( 8313213138756135033LLU),
	QU(11421481194803712517LLU), QU( 7997007691544174032LLU),
	QU( 6812963847917605930LLU), QU( 9683091901227558641LLU),
	QU(14703594165860324713LLU), QU( 1775476144519618309LLU),
	QU( 2724283288516469519LLU), QU(  717642555185856868LLU),
	QU( 8736402192215092346LLU), QU(11878800336431381021LLU),
	QU( 4348816066017061293LLU), QU( 6115112756583631307LLU),
	QU( 9176597239667142976LLU), QU(12615622714894259204LLU),
	QU(10283406711301385987LLU), QU( 5111762509485379420LLU),
	QU( 3118290051198688449LLU), QU( 7345123071632232145LLU),
	QU( 9176423451688682359LLU), QU( 4843865456157868971LLU),
	QU(12008036363752566088LLU), QU(12058837181919397720LLU),
	QU( 2145073958457347366LLU), QU( 1526504881672818067LLU),
	QU( 3488830105567134848LLU), QU(13208362960674805143LLU),
	QU( 4077549672899572192LLU), QU( 7770995684693818365LLU),
	QU( 1398532341546313593LLU), QU(12711859908703927840LLU),
	QU( 1417561172594446813LLU), QU(17045191024194170604LLU),
	QU( 4101933177604931713LLU), QU(14708428834203480320LLU),
	QU(17447509264469407724LLU), QU(14314821973983434255LLU),
	QU(17990472271061617265LLU), QU( 5087756685841673942LLU),
	QU(12797820586893859939LLU), QU( 1778128952671092879LLU),
	QU( 3535918530508665898LLU), QU( 9035729701042481301LLU),
	QU(14808661568277079962LLU), QU(14587345077537747914LLU),
	QU(11920080002323122708LLU), QU( 6426515805197278753LLU),
	QU( 3295612216725984831LLU), QU(11040722532100876120LLU),
	QU(12305952936387598754LLU), QU(16097391899742004253LLU),
	QU( 4908537335606182208LLU), QU(12446674552196795504LLU),
	QU(16010497855816895177LLU), QU( 9194378874788615551LLU),
	QU( 3382957529567613384LLU), QU( 5154647600754974077LLU),
	QU( 9801822865328396141LLU), QU( 9023662173919288143LLU),
	QU(17623115353825147868LLU), QU( 8238115767443015816LLU),
	QU(15811444159859002560LLU), QU( 9085612528904059661LLU),
	QU( 6888601089398614254LLU), QU(  258252992894160189LLU),
	QU( 6704363880792428622LLU), QU( 6114966032147235763LLU),
	QU(11075393882690261875LLU), QU( 8797664238933620407LLU),
	QU( 5901892006476726920LLU), QU( 5309780159285518958LLU),
	QU(14940808387240817367LLU), QU(14642032021449656698LLU),
	QU( 9808256672068504139LLU), QU( 3670135111380607658LLU),
	QU(11211211097845960152LLU), QU( 1474304506716695808LLU),
	QU(15843166204506876239LLU), QU( 7661051252471780561LLU),
	QU(10170905502249418476LLU), QU( 7801416045582028589LLU),
	QU( 2763981484737053050LLU), QU( 9491377905499253054LLU),
	QU(16201395896336915095LLU), QU( 9256513756442782198LLU),
	QU( 5411283157972456034LLU), QU( 5059433122288321676LLU),
	QU( 4327408006721123357LLU), QU( 9278544078834433377LLU),
	QU( 7601527110882281612LLU), QU(11848295896975505251LLU),
	QU(12096998801094735560LLU), QU(14773480339823506413LLU),
	QU(15586227433895802149LLU), QU(12786541257830242872LLU),
	QU( 6904692985140503067LLU), QU( 5309011515263103959LLU),
	QU(12105257191179371066LLU), QU(14654380212442225037LLU),
	QU( 2556774974190695009LLU), QU( 4461297399927600261LLU),
	QU(14888225660915118646LLU), QU(14915459341148291824LLU),
	QU( 2738802166252327631LLU), QU( 6047155789239131512LLU),
	QU(12920545353217010338LLU), QU(10697617257007840205LLU),
	QU( 2751585253158203504LLU), QU(13252729159780047496LLU),
	QU(14700326134672815469LLU), QU(14082527904374600529LLU),
	QU(16852962273496542070LLU), QU(17446675504235853907LLU),
	QU(15019600398527572311LLU), QU(12312781346344081551LLU),
	QU(14524667935039810450LLU), QU( 5634005663377195738LLU),
	QU(11375574739525000569LLU), QU( 2423665396433260040LLU),
	QU( 5222836914796015410LLU), QU( 4397666386492647387LLU),
	QU( 4619294441691707638LLU), QU(  665088602354770716LLU),
	QU(13246495665281593610LLU), QU( 6564144270549729409LLU),
	QU(10223216188145661688LLU), QU( 3961556907299230585LLU),
	QU(11543262515492439914LLU), QU(16118031437285993790LLU),
	QU( 7143417964520166465LLU), QU(13295053515909486772LLU),
	QU(   40434666004899675LLU), QU(17127804194038347164LLU),
	QU( 8599165966560586269LLU), QU( 8214016749011284903LLU),
	QU(13725130352140465239LLU), QU( 5467254474431726291LLU),
	QU( 7748584297438219877LLU), QU(16933551114829772472LLU),
	QU( 2169618439506799400LLU), QU( 2169787627665113463LLU),
	QU(17314493571267943764LLU), QU(18053575102911354912LLU),
	QU(11928303275378476973LLU), QU(11593850925061715550LLU),
	QU(17782269923473589362LLU), QU( 3280235307704747039LLU),
	QU( 6145343578598685149LLU), QU(17080117031114086090LLU),
	QU(18066839902983594755LLU), QU( 6517508430331020706LLU),
	QU( 8092908893950411541LLU), QU(12558378233386153732LLU),
	QU( 4476532167973132976LLU), QU(16081642430367025016LLU),
	QU( 4233154094369139361LLU), QU( 8693630486693161027LLU),
	QU(11244959343027742285LLU), QU(12273503967768513508LLU),
	QU(14108978636385284876LLU), QU( 7242414665378826984LLU),
	QU( 6561316938846562432LLU), QU( 8601038474994665795LLU),
	QU(17532942353612365904LLU), QU(17940076637020912186LLU),
	QU( 7340260368823171304LLU), QU( 7061807613916067905LLU),
	QU(10561734935039519326LLU), QU(17990796503724650862LLU),
	QU( 6208732943911827159LLU), QU(  359077562804090617LLU),
	QU(14177751537784403113LLU), QU(10659599444915362902LLU),
	QU(15081727220615085833LLU), QU(13417573895659757486LLU),
	QU(15513842342017811524LLU), QU(11814141516204288231LLU),
	QU( 1827312513875101814LLU), QU( 2804611699894603103LLU),
	QU(17116500469975602763LLU), QU(12270191815211952087LLU),
	QU(12256358467786024988LLU), QU(18435021722453971267LLU),
	QU(  671330264390865618LLU), QU(  476504300460286050LLU),
	QU(16465470901027093441LLU), QU( 4047724406247136402LLU),
	QU( 1322305451411883346LLU), QU( 1388308688834322280LLU),
	QU( 7303989085269758176LLU), QU( 9323792664765233642LLU),
	QU( 4542762575316368936LLU), QU(17342696132794337618LLU),
	QU( 4588025054768498379LLU), QU(13415475057390330804LLU),
	QU(17880279491733405570LLU), QU(10610553400618620353LLU),
	QU( 3180842072658960139LLU), QU(13002966655454270120LLU),
	QU( 1665301181064982826LLU), QU( 7083673946791258979LLU),
	QU(  190522247122496820LLU), QU(17388280237250677740LLU),
	QU( 8430770379923642945LLU), QU(12987180971921668584LLU),
	QU( 2311086108365390642LLU), QU( 2870984383579822345LLU),
	QU(14014682609164653318LLU), QU(14467187293062251484LLU),
	QU(  192186361147413298LLU), QU(15171951713531796524LLU),
	QU( 9900305495015948728LLU), QU(17958004775615466344LLU),
	QU(14346380954498606514LLU), QU(18040047357617407096LLU),
	QU( 5035237584833424532LLU), QU(15089555460613972287LLU),
	QU( 4131411873749729831LLU), QU( 1329013581168250330LLU),
	QU(10095353333051193949LLU), QU(10749518561022462716LLU),
	QU( 9050611429810755847LLU), QU(15022028840236655649LLU),
	QU( 8775554279239748298LLU), QU(13105754025489230502LLU),
	QU(15471300118574167585LLU), QU(   89864764002355628LLU),
	QU( 8776416323420466637LLU), QU( 5280258630612040891LLU),
	QU( 2719174488591862912LLU), QU( 7599309137399661994LLU),
	QU(15012887256778039979LLU), QU(14062981725630928925LLU),
	QU(12038536286991689603LLU), QU( 7089756544681775245LLU),
	QU(10376661532744718039LLU), QU( 1265198725901533130LLU),
	QU(13807996727081142408LLU), QU( 2935019626765036403LLU),
	QU( 7651672460680700141LLU), QU( 3644093016200370795LLU),
	QU( 2840982578090080674LLU), QU(17956262740157449201LLU),
	QU(18267979450492880548LLU), QU(11799503659796848070LLU),
	QU( 9942537025669672388LLU), QU(11886606816406990297LLU),
	QU( 5488594946437447576LLU), QU( 7226714353282744302LLU),
	QU( 3784851653123877043LLU), QU(  878018453244803041LLU),
	QU(12110022586268616085LLU), QU(  734072179404675123LLU),
	QU(11869573627998248542LLU), QU(  469150421297783998LLU),
	QU(  260151124912803804LLU), QU(11639179410120968649LLU),
	QU( 9318165193840846253LLU), QU(12795671722734758075LLU),
	QU(15318410297267253933LLU), QU(  691524703570062620LLU),
	QU( 5837129010576994601LLU), QU(15045963859726941052LLU),
	QU( 5850056944932238169LLU), QU(12017434144750943807LLU),
	QU( 7447139064928956574LLU), QU( 3101711812658245019LLU),
	QU(16052940704474982954LLU), QU(18195745945986994042LLU),
	QU( 8932252132785575659LLU), QU(13390817488106794834LLU),
	QU(11582771836502517453LLU), QU( 4964411326683611686LLU),
	QU( 2195093981702694011LLU), QU(14145229538389675669LLU),
	QU(16459605532062271798LLU), QU(  866316924816482864LLU),
	QU( 4593041209937286377LLU), QU( 8415491391910972138LLU),
	QU( 4171236715600528969LLU), QU(16637569303336782889LLU),
	QU( 2002011073439212680LLU), QU(17695124661097601411LLU),
	QU( 4627687053598611702LLU), QU( 7895831936020190403LLU),
	QU( 8455951300917267802LLU), QU( 2923861649108534854LLU),
	QU( 8344557563927786255LLU), QU( 6408671940373352556LLU),
	QU(12210227354536675772LLU), QU(14294804157294222295LLU),
	QU(10103022425071085127LLU), QU(10092959489504123771LLU),
	QU( 6554774405376736268LLU), QU(12629917718410641774LLU),
	QU( 6260933257596067126LLU), QU( 2460827021439369673LLU),
	QU( 2541962996717103668LLU), QU(  597377203127351475LLU),
	QU( 5316984203117315309LLU), QU( 4811211393563241961LLU),
	QU(13119698597255811641LLU), QU( 8048691512862388981LLU),
	QU(10216818971194073842LLU), QU( 4612229970165291764LLU),
	QU(10000980798419974770LLU), QU( 6877640812402540687LLU),
	QU( 1488727563290436992LLU), QU( 2227774069895697318LLU),
	QU(11237754507523316593LLU), QU(13478948605382290972LLU),
	QU( 1963583846976858124LLU), QU( 5512309205269276457LLU),
	QU( 3972770164717652347LLU), QU( 3841751276198975037LLU),
	QU(10283343042181903117LLU), QU( 8564001259792872199LLU),
	QU(16472187244722489221LLU), QU( 8953493499268945921LLU),
	QU( 3518747340357279580LLU), QU( 4003157546223963073LLU),
	QU( 3270305958289814590LLU), QU( 3966704458129482496LLU),
	QU( 8122141865926661939LLU), QU(14627734748099506653LLU),
	QU(13064426990862560568LLU), QU( 2414079187889870829LLU),
	QU( 5378461209354225306LLU), QU(10841985740128255566LLU),
	QU(  538582442885401738LLU), QU( 7535089183482905946LLU),
	QU(16117559957598879095LLU), QU( 8477890721414539741LLU),
	QU( 1459127491209533386LLU), QU(17035126360733620462LLU),
	QU( 8517668552872379126LLU), QU(10292151468337355014LLU),
	QU(17081267732745344157LLU), QU(13751455337946087178LLU),
	QU(14026945459523832966LLU), QU( 6653278775061723516LLU),
	QU(10619085543856390441LLU), QU( 2196343631481122885LLU),
	QU(10045966074702826136LLU), QU(10082317330452718282LLU),
	QU( 5920859259504831242LLU), QU( 9951879073426540617LLU),
	QU( 7074696649151414158LLU), QU(15808193543879464318LLU),
	QU( 7385247772746953374LLU), QU( 3192003544283864292LLU),
	QU(18153684490917593847LLU), QU(12423498260668568905LLU),
	QU(10957758099756378169LLU), QU(11488762179911016040LLU),
	QU( 2099931186465333782LLU), QU(11180979581250294432LLU),
	QU( 8098916250668367933LLU), QU( 3529200436790763465LLU),
	QU(12988418908674681745LLU), QU( 6147567275954808580LLU),
	QU( 3207503344604030989LLU), QU(10761592604898615360LLU),
	QU(  229854861031893504LLU), QU( 8809853962667144291LLU),
	QU(13957364469005693860LLU), QU( 7634287665224495886LLU),
	QU(12353487366976556874LLU), QU( 1134423796317152034LLU),
	QU( 2088992471334107068LLU), QU( 7393372127190799698LLU),
	QU( 1845367839871058391LLU), QU(  207922563987322884LLU),
	QU(11960870813159944976LLU), QU(12182120053317317363LLU),
	QU(17307358132571709283LLU), QU(13871081155552824936LLU),
	QU(18304446751741566262LLU), QU( 7178705220184302849LLU),
	QU(10929605677758824425LLU), QU(16446976977835806844LLU),
	QU(13723874412159769044LLU), QU( 6942854352100915216LLU),
	QU( 1726308474365729390LLU), QU( 2150078766445323155LLU),
	QU(15345558947919656626LLU), QU(12145453828874527201LLU),
	QU( 2054448620739726849LLU), QU( 2740102003352628137LLU),
	QU(11294462163577610655LLU), QU(  756164283387413743LLU),
	QU(17841144758438810880LLU), QU(10802406021185415861LLU),
	QU( 8716455530476737846LLU), QU( 6321788834517649606LLU),
	QU(14681322910577468426LLU), QU(17330043563884336387LLU),
	QU(12701802180050071614LLU), QU(14695105111079727151LLU),
	QU( 5112098511654172830LLU), QU( 4957505496794139973LLU),
	QU( 8270979451952045982LLU), QU(12307685939199120969LLU),
	QU(12425799408953443032LLU), QU( 8376410143634796588LLU),
	QU(16621778679680060464LLU), QU( 3580497854566660073LLU),
	QU( 1122515747803382416LLU), QU(  857664980960597599LLU),
	QU( 6343640119895925918LLU), QU(12878473260854462891LLU),
	QU(10036813920765722626LLU), QU(14451335468363173812LLU),
	QU( 5476809692401102807LLU), QU(16442255173514366342LLU),
	QU(13060203194757167104LLU), QU(14354124071243177715LLU),
	QU(15961249405696125227LLU), QU(13703893649690872584LLU),
	QU(  363907326340340064LLU), QU( 6247455540491754842LLU),
	QU(12242249332757832361LLU), QU(  156065475679796717LLU),
	QU( 9351116235749732355LLU), QU( 4590350628677701405LLU),
	QU( 1671195940982350389LLU), QU(13501398458898451905LLU),
	QU( 6526341991225002255LLU), QU( 1689782913778157592LLU),
	QU( 7439222350869010334LLU), QU(13975150263226478308LLU),
	QU(11411961169932682710LLU), QU(17204271834833847277LLU),
	QU(  541534742544435367LLU), QU( 6591191931218949684LLU),
	QU( 2645454775478232486LLU), QU( 4322857481256485321LLU),
	QU( 8477416487553065110LLU), QU(12902505428548435048LLU),
	QU(  971445777981341415LLU), QU(14995104682744976712LLU),
	QU( 4243341648807158063LLU), QU( 8695061252721927661LLU),
	QU( 5028202003270177222LLU), QU( 2289257340915567840LLU),
	QU(13870416345121866007LLU), QU(13994481698072092233LLU),
	QU( 6912785400753196481LLU), QU( 2278309315841980139LLU),
	QU( 4329765449648304839LLU), QU( 5963108095785485298LLU),
	QU( 4880024847478722478LLU), QU(16015608779890240947LLU),
	QU( 1866679034261393544LLU), QU(  914821179919731519LLU),
	QU( 9643404035648760131LLU), QU( 2418114953615593915LLU),
	QU(  944756836073702374LLU), QU(15186388048737296834LLU),
	QU( 7723355336128442206LLU), QU( 7500747479679599691LLU),
	QU(18013961306453293634LLU), QU( 2315274808095756456LLU),
	QU(13655308255424029566LLU), QU(17203800273561677098LLU),
	QU( 1382158694422087756LLU), QU( 5090390250309588976LLU),
	QU(  517170818384213989LLU), QU( 1612709252627729621LLU),
	QU( 1330118955572449606LLU), QU(  300922478056709885LLU),
	QU(18115693291289091987LLU), QU(13491407109725238321LLU),
	QU(15293714633593827320LLU), QU( 5151539373053314504LLU),
	QU( 5951523243743139207LLU), QU(14459112015249527975LLU),
	QU( 5456113959000700739LLU), QU( 3877918438464873016LLU),
	QU(12534071654260163555LLU), QU(15871678376893555041LLU),
	QU(11005484805712025549LLU), QU(16353066973143374252LLU),
	QU( 4358331472063256685LLU), QU( 8268349332210859288LLU),
	QU(12485161590939658075LLU), QU(13955993592854471343LLU),
	QU( 5911446886848367039LLU), QU(14925834086813706974LLU),
	QU( 6590362597857994805LLU), QU( 1280544923533661875LLU),
	QU( 1637756018947988164LLU), QU( 4734090064512686329LLU),
	QU(16693705263131485912LLU), QU( 6834882340494360958LLU),
	QU( 8120732176159658505LLU), QU( 2244371958905329346LLU),
	QU(10447499707729734021LLU), QU( 7318742361446942194LLU),
	QU( 8032857516355555296LLU), QU(14023605983059313116LLU),
	QU( 1032336061815461376LLU), QU( 9840995337876562612LLU),
	QU( 9869256223029203587LLU), QU(12227975697177267636LLU),
	QU(12728115115844186033LLU), QU( 7752058479783205470LLU),
	QU(  729733219713393087LLU), QU(12954017801239007622LLU)
};
static const uint64_t init_by_array_64_expected[] = {
	QU( 2100341266307895239LLU), QU( 8344256300489757943LLU),
	QU(15687933285484243894LLU), QU( 8268620370277076319LLU),
	QU(12371852309826545459LLU), QU( 8800491541730110238LLU),
	QU(18113268950100835773LLU), QU( 2886823658884438119LLU),
	QU( 3293667307248180724LLU), QU( 9307928143300172731LLU),
	QU( 7688082017574293629LLU), QU(  900986224735166665LLU),
	QU( 9977972710722265039LLU), QU( 6008205004994830552LLU),
	QU(  546909104521689292LLU), QU( 7428471521869107594LLU),
	QU(14777563419314721179LLU), QU(16116143076567350053LLU),
	QU( 5322685342003142329LLU), QU( 4200427048445863473LLU),
	QU( 4693092150132559146LLU), QU(13671425863759338582LLU),
	QU( 6747117460737639916LLU), QU( 4732666080236551150LLU),
	QU( 5912839950611941263LLU), QU( 3903717554504704909LLU),
	QU( 2615667650256786818LLU), QU(10844129913887006352LLU),
	QU(13786467861810997820LLU), QU(14267853002994021570LLU),
	QU(13767807302847237439LLU), QU(16407963253707224617LLU),
	QU( 4802498363698583497LLU), QU( 2523802839317209764LLU),
	QU( 3822579397797475589LLU), QU( 8950320572212130610LLU),
	QU( 3745623504978342534LLU), QU(16092609066068482806LLU),
	QU( 9817016950274642398LLU), QU(10591660660323829098LLU),
	QU(11751606650792815920LLU), QU( 5122873818577122211LLU),
	QU(17209553764913936624LLU), QU( 6249057709284380343LLU),
	QU(15088791264695071830LLU), QU(15344673071709851930LLU),
	QU( 4345751415293646084LLU), QU( 2542865750703067928LLU),
	QU(13520525127852368784LLU), QU(18294188662880997241LLU),
	QU( 3871781938044881523LLU), QU( 2873487268122812184LLU),
	QU(15099676759482679005LLU), QU(15442599127239350490LLU),
	QU( 6311893274367710888LLU), QU( 3286118760484672933LLU),
	QU( 4146067961333542189LLU), QU(13303942567897208770LLU),
	QU( 8196013722255630418LLU), QU( 4437815439340979989LLU),
	QU(15433791533450605135LLU), QU( 4254828956815687049LLU),
	QU( 1310903207708286015LLU), QU(10529182764462398549LLU),
	QU(14900231311660638810LLU), QU( 9727017277104609793LLU),
	QU( 1821308310948199033LLU), QU(11628861435066772084LLU),
	QU( 9469019138491546924LLU), QU( 3145812670532604988LLU),
	QU( 9938468915045491919LLU), QU( 1562447430672662142LLU),
	QU(13963995266697989134LLU), QU( 3356884357625028695LLU),
	QU( 4499850304584309747LLU), QU( 8456825817023658122LLU),
	QU(10859039922814285279LLU), QU( 8099512337972526555LLU),
	QU(  348006375109672149LLU), QU(11919893998241688603LLU),
	QU( 1104199577402948826LLU), QU(16689191854356060289LLU),
	QU(10992552041730168078LLU), QU( 7243733172705465836LLU),
	QU( 5668075606180319560LLU), QU(18182847037333286970LLU),
	QU( 4290215357664631322LLU), QU( 4061414220791828613LLU),
	QU(13006291061652989604LLU), QU( 7140491178917128798LLU),
	QU(12703446217663283481LLU), QU( 5500220597564558267LLU),
	QU(10330551509971296358LLU), QU(15958554768648714492LLU),
	QU( 5174555954515360045LLU), QU( 1731318837687577735LLU),
	QU( 3557700801048354857LLU), QU(13764012341928616198LLU),
	QU(13115166194379119043LLU), QU( 7989321021560255519LLU),
	QU( 2103584280905877040LLU), QU( 9230788662155228488LLU),
	QU(16396629323325547654LLU), QU(  657926409811318051LLU),
	QU(15046700264391400727LLU), QU( 5120132858771880830LLU),
	QU( 7934160097989028561LLU), QU( 6963121488531976245LLU),
	QU(17412329602621742089LLU), QU(15144843053931774092LLU),
	QU(17204176651763054532LLU), QU(13166595387554065870LLU),
	QU( 8590377810513960213LLU), QU( 5834365135373991938LLU),
	QU( 7640913007182226243LLU), QU( 3479394703859418425LLU),
	QU(16402784452644521040LLU), QU( 4993979809687083980LLU),
	QU(13254522168097688865LLU), QU(15643659095244365219LLU),
	QU( 5881437660538424982LLU), QU(11174892200618987379LLU),
	QU(  254409966159711077LLU), QU(17158413043140549909LLU),
	QU( 3638048789290376272LLU), QU( 1376816930299489190LLU),
	QU( 4622462095217761923LLU), QU(15086407973010263515LLU),
	QU(13253971772784692238LLU), QU( 5270549043541649236LLU),
	QU(11182714186805411604LLU), QU(12283846437495577140LLU),
	QU( 5297647149908953219LLU), QU(10047451738316836654LLU),
	QU( 4938228100367874746LLU), QU(12328523025304077923LLU),
	QU( 3601049438595312361LLU), QU( 9313624118352733770LLU),
	QU(13322966086117661798LLU), QU(16660005705644029394LLU),
	QU(11337677526988872373LLU), QU(13869299102574417795LLU),
	QU(15642043183045645437LLU), QU( 3021755569085880019LLU),
	QU( 4979741767761188161LLU), QU(13679979092079279587LLU),
	QU( 3344685842861071743LLU), QU(13947960059899588104LLU),
	QU(  305806934293368007LLU), QU( 5749173929201650029LLU),
	QU(11123724852118844098LLU), QU(15128987688788879802LLU),
	QU(15251651211024665009LLU), QU( 7689925933816577776LLU),
	QU(16732804392695859449LLU), QU(17087345401014078468LLU),
	QU(14315108589159048871LLU), QU( 4820700266619778917LLU),
	QU(16709637539357958441LLU), QU( 4936227875177351374LLU),
	QU( 2137907697912987247LLU), QU(11628565601408395420LLU),
	QU( 2333250549241556786LLU), QU( 5711200379577778637LLU),
	QU( 5170680131529031729LLU), QU(12620392043061335164LLU),
	QU(   95363390101096078LLU), QU( 5487981914081709462LLU),
	QU( 1763109823981838620LLU), QU( 3395861271473224396LLU),
	QU( 1300496844282213595LLU), QU( 6894316212820232902LLU),
	QU(10673859651135576674LLU), QU( 5911839658857903252LLU),
	QU(17407110743387299102LLU), QU( 8257427154623140385LLU),
	QU(11389003026741800267LLU), QU( 4070043211095013717LLU),
	QU(11663806997145259025LLU), QU(15265598950648798210LLU),
	QU(  630585789434030934LLU), QU( 3524446529213587334LLU),
	QU( 7186424168495184211LLU), QU(10806585451386379021LLU),
	QU(11120017753500499273LLU), QU( 1586837651387701301LLU),
	QU(17530454400954415544LLU), QU( 9991670045077880430LLU),
	QU( 7550997268990730180LLU), QU( 8640249196597379304LLU),
	QU( 3522203892786893823LLU), QU(10401116549878854788LLU),
	QU(13690285544733124852LLU), QU( 8295785675455774586LLU),
	QU(15535716172155117603LLU), QU( 3112108583723722511LLU),
	QU(17633179955339271113LLU), QU(18154208056063759375LLU),
	QU( 1866409236285815666LLU), QU(13326075895396412882LLU),
	QU( 8756261842948020025LLU), QU( 6281852999868439131LLU),
	QU(15087653361275292858LLU), QU(10333923911152949397LLU),
	QU( 5265567645757408500LLU), QU(12728041843210352184LLU),
	QU( 6347959327507828759LLU), QU(  154112802625564758LLU),
	QU(18235228308679780218LLU), QU( 3253805274673352418LLU),
	QU( 4849171610689031197LLU), QU(17948529398340432518LLU),
	QU(13803510475637409167LLU), QU(13506570190409883095LLU),
	QU(15870801273282960805LLU), QU( 8451286481299170773LLU),
	QU( 9562190620034457541LLU), QU( 8518905387449138364LLU),
	QU(12681306401363385655LLU), QU( 3788073690559762558LLU),
	QU( 5256820289573487769LLU), QU( 2752021372314875467LLU),
	QU( 6354035166862520716LLU), QU( 4328956378309739069LLU),
	QU(  449087441228269600LLU), QU( 5533508742653090868LLU),
	QU( 1260389420404746988LLU), QU(18175394473289055097LLU),
	QU( 1535467109660399420LLU), QU( 8818894282874061442LLU),
	QU(12140873243824811213LLU), QU(15031386653823014946LLU),
	QU( 1286028221456149232LLU), QU( 6329608889367858784LLU),
	QU( 9419654354945132725LLU), QU( 6094576547061672379LLU),
	QU(17706217251847450255LLU), QU( 1733495073065878126LLU),
	QU(16918923754607552663LLU), QU( 8881949849954945044LLU),
	QU(12938977706896313891LLU), QU(14043628638299793407LLU),
	QU(18393874581723718233LLU), QU( 6886318534846892044LLU),
	QU(14577870878038334081LLU), QU(13541558383439414119LLU),
	QU(13570472158807588273LLU), QU(18300760537910283361LLU),
	QU(  818368572800609205LLU), QU( 1417000585112573219LLU),
	QU(12337533143867683655LLU), QU(12433180994702314480LLU),
	QU(  778190005829189083LLU), QU(13667356216206524711LLU),
	QU( 9866149895295225230LLU), QU(11043240490417111999LLU),
	QU( 1123933826541378598LLU), QU( 6469631933605123610LLU),
	QU(14508554074431980040LLU), QU(13918931242962026714LLU),
	QU( 2870785929342348285LLU), QU(14786362626740736974LLU),
	QU(13176680060902695786LLU), QU( 9591778613541679456LLU),
	QU( 9097662885117436706LLU), QU(  749262234240924947LLU),
	QU( 1944844067793307093LLU), QU( 4339214904577487742LLU),
	QU( 8009584152961946551LLU), QU(16073159501225501777LLU),
	QU( 3335870590499306217LLU), QU(17088312653151202847LLU),
	QU( 3108893142681931848LLU), QU(16636841767202792021LLU),
	QU(10423316431118400637LLU), QU( 8008357368674443506LLU),
	QU(11340015231914677875LLU), QU(17687896501594936090LLU),
	QU(15173627921763199958LLU), QU(  542569482243721959LLU),
	QU(15071714982769812975LLU), QU( 4466624872151386956LLU),
	QU( 1901780715602332461LLU), QU( 9822227742154351098LLU),
	QU( 1479332892928648780LLU), QU( 6981611948382474400LLU),
	QU( 7620824924456077376LLU), QU(14095973329429406782LLU),
	QU( 7902744005696185404LLU), QU(15830577219375036920LLU),
	QU(10287076667317764416LLU), QU(12334872764071724025LLU),
	QU( 4419302088133544331LLU), QU(14455842851266090520LLU),
	QU(12488077416504654222LLU), QU( 7953892017701886766LLU),
	QU( 6331484925529519007LLU), QU( 4902145853785030022LLU),
	QU(17010159216096443073LLU), QU(11945354668653886087LLU),
	QU(15112022728645230829LLU), QU(17363484484522986742LLU),
	QU( 4423497825896692887LLU), QU( 8155489510809067471LLU),
	QU(  258966605622576285LLU), QU( 5462958075742020534LLU),
	QU( 6763710214913276228LLU), QU( 2368935183451109054LLU),
	QU(14209506165246453811LLU), QU( 2646257040978514881LLU),
	QU( 3776001911922207672LLU), QU( 1419304601390147631LLU),
	QU(14987366598022458284LLU), QU( 3977770701065815721LLU),
	QU(  730820417451838898LLU), QU( 3982991703612885327LLU),
	QU( 2803544519671388477LLU), QU(17067667221114424649LLU),
	QU( 2922555119737867166LLU), QU( 1989477584121460932LLU),
	QU(15020387605892337354LLU), QU( 9293277796427533547LLU),
	QU(10722181424063557247LLU), QU(16704542332047511651LLU),
	QU( 5008286236142089514LLU), QU(16174732308747382540LLU),
	QU(17597019485798338402LLU), QU(13081745199110622093LLU),
	QU( 8850305883842258115LLU), QU(12723629125624589005LLU),
	QU( 8140566453402805978LLU), QU(15356684607680935061LLU),
	QU(14222190387342648650LLU), QU(11134610460665975178LLU),
	QU( 1259799058620984266LLU), QU(13281656268025610041LLU),
	QU(  298262561068153992LLU), QU(12277871700239212922LLU),
	QU(13911297774719779438LLU), QU(16556727962761474934LLU),
	QU(17903010316654728010LLU), QU( 9682617699648434744LLU),
	QU(14757681836838592850LLU), QU( 1327242446558524473LLU),
	QU(11126645098780572792LLU), QU( 1883602329313221774LLU),
	QU( 2543897783922776873LLU), QU(15029168513767772842LLU),
	QU(12710270651039129878LLU), QU(16118202956069604504LLU),
	QU(15010759372168680524LLU), QU( 2296827082251923948LLU),
	QU(10793729742623518101LLU), QU(13829764151845413046LLU),
	QU(17769301223184451213LLU), QU( 3118268169210783372LLU),
	QU(17626204544105123127LLU), QU( 7416718488974352644LLU),
	QU(10450751996212925994LLU), QU( 9352529519128770586LLU),
	QU(  259347569641110140LLU), QU( 8048588892269692697LLU),
	QU( 1774414152306494058LLU), QU(10669548347214355622LLU),
	QU(13061992253816795081LLU), QU(18432677803063861659LLU),
	QU( 8879191055593984333LLU), QU(12433753195199268041LLU),
	QU(14919392415439730602LLU), QU( 6612848378595332963LLU),
	QU( 6320986812036143628LLU), QU(10465592420226092859LLU),
	QU( 4196009278962570808LLU), QU( 3747816564473572224LLU),
	QU(17941203486133732898LLU), QU( 2350310037040505198LLU),
	QU( 5811779859134370113LLU), QU(10492109599506195126LLU),
	QU( 7699650690179541274LLU), QU( 1954338494306022961LLU),
	QU(14095816969027231152LLU), QU( 5841346919964852061LLU),
	QU(14945969510148214735LLU), QU( 3680200305887550992LLU),
	QU( 6218047466131695792LLU), QU( 8242165745175775096LLU),
	QU(11021371934053307357LLU), QU( 1265099502753169797LLU),
	QU( 4644347436111321718LLU), QU( 3609296916782832859LLU),
	QU( 8109807992218521571LLU), QU(18387884215648662020LLU),
	QU(14656324896296392902LLU), QU(17386819091238216751LLU),
	QU(17788300878582317152LLU), QU( 7919446259742399591LLU),
	QU( 4466613134576358004LLU), QU(12928181023667938509LLU),
	QU(13147446154454932030LLU), QU(16552129038252734620LLU),
	QU( 8395299403738822450LLU), QU(11313817655275361164LLU),
	QU(  434258809499511718LLU), QU( 2074882104954788676LLU),
	QU( 7929892178759395518LLU), QU( 9006461629105745388LLU),
	QU( 5176475650000323086LLU), QU(11128357033468341069LLU),
	QU(12026158851559118955LLU), QU(14699716249471156500LLU),
	QU(  448982497120206757LLU), QU( 4156475356685519900LLU),
	QU( 6063816103417215727LLU), QU(10073289387954971479LLU),
	QU( 8174466846138590962LLU), QU( 2675777452363449006LLU),
	QU( 9090685420572474281LLU), QU( 6659652652765562060LLU),
	QU(12923120304018106621LLU), QU(11117480560334526775LLU),
	QU(  937910473424587511LLU), QU( 1838692113502346645LLU),
	QU(11133914074648726180LLU), QU( 7922600945143884053LLU),
	QU(13435287702700959550LLU), QU( 5287964921251123332LLU),
	QU(11354875374575318947LLU), QU(17955724760748238133LLU),
	QU(13728617396297106512LLU), QU( 4107449660118101255LLU),
	QU( 1210269794886589623LLU), QU(11408687205733456282LLU),
	QU( 4538354710392677887LLU), QU(13566803319341319267LLU),
	QU(17870798107734050771LLU), QU( 3354318982568089135LLU),
	QU( 9034450839405133651LLU), QU(13087431795753424314LLU),
	QU(  950333102820688239LLU), QU( 1968360654535604116LLU),
	QU(16840551645563314995LLU), QU( 8867501803892924995LLU),
	QU(11395388644490626845LLU), QU( 1529815836300732204LLU),
	QU(13330848522996608842LLU), QU( 1813432878817504265LLU),
	QU( 2336867432693429560LLU), QU(15192805445973385902LLU),
	QU( 2528593071076407877LLU), QU(  128459777936689248LLU),
	QU( 9976345382867214866LLU), QU( 6208885766767996043LLU),
	QU(14982349522273141706LLU), QU( 3099654362410737822LLU),
	QU(13776700761947297661LLU), QU( 8806185470684925550LLU),
	QU( 8151717890410585321LLU), QU(  640860591588072925LLU),
	QU(14592096303937307465LLU), QU( 9056472419613564846LLU),
	QU(14861544647742266352LLU), QU(12703771500398470216LLU),
	QU( 3142372800384138465LLU), QU( 6201105606917248196LLU),
	QU(18337516409359270184LLU), QU(15042268695665115339LLU),
	QU(15188246541383283846LLU), QU(12800028693090114519LLU),
	QU( 5992859621101493472LLU), QU(18278043971816803521LLU),
	QU( 9002773075219424560LLU), QU( 7325707116943598353LLU),
	QU( 7930571931248040822LLU), QU( 5645275869617023448LLU),
	QU( 7266107455295958487LLU), QU( 4363664528273524411LLU),
	QU(14313875763787479809LLU), QU(17059695613553486802LLU),
	QU( 9247761425889940932LLU), QU(13704726459237593128LLU),
	QU( 2701312427328909832LLU), QU(17235532008287243115LLU),
	QU(14093147761491729538LLU), QU( 6247352273768386516LLU),
	QU( 8268710048153268415LLU), QU( 7985295214477182083LLU),
	QU(15624495190888896807LLU), QU( 3772753430045262788LLU),
	QU( 9133991620474991698LLU), QU( 5665791943316256028LLU),
	QU( 7551996832462193473LLU), QU(13163729206798953877LLU),
	QU( 9263532074153846374LLU), QU( 1015460703698618353LLU),
	QU(17929874696989519390LLU), QU(18257884721466153847LLU),
	QU(16271867543011222991LLU), QU( 3905971519021791941LLU),
	QU(16814488397137052085LLU), QU( 1321197685504621613LLU),
	QU( 2870359191894002181LLU), QU(14317282970323395450LLU),
	QU(13663920845511074366LLU), QU( 2052463995796539594LLU),
	QU(14126345686431444337LLU), QU( 1727572121947022534LLU),
	QU(17793552254485594241LLU), QU( 6738857418849205750LLU),
	QU( 1282987123157442952LLU), QU(16655480021581159251LLU),
	QU( 6784587032080183866LLU), QU(14726758805359965162LLU),
	QU( 7577995933961987349LLU), QU(12539609320311114036LLU),
	QU(10789773033385439494LLU), QU( 8517001497411158227LLU),
	QU(10075543932136339710LLU), QU(14838152340938811081LLU),
	QU( 9560840631794044194LLU), QU(17445736541454117475LLU),
	QU(10633026464336393186LLU), QU(15705729708242246293LLU),
	QU( 1117517596891411098LLU), QU( 4305657943415886942LLU),
	QU( 4948856840533979263LLU), QU(16071681989041789593LLU),
	QU(13723031429272486527LLU), QU( 7639567622306509462LLU),
	QU(12670424537483090390LLU), QU( 9715223453097197134LLU),
	QU( 5457173389992686394LLU), QU(  289857129276135145LLU),
	QU(17048610270521972512LLU), QU(  692768013309835485LLU),
	QU(14823232360546632057LLU), QU(18218002361317895936LLU),
	QU( 3281724260212650204LLU), QU(16453957266549513795LLU),
	QU( 8592711109774511881LLU), QU(  929825123473369579LLU),
	QU(15966784769764367791LLU), QU( 9627344291450607588LLU),
	QU(10849555504977813287LLU), QU( 9234566913936339275LLU),
	QU( 6413807690366911210LLU), QU(10862389016184219267LLU),
	QU(13842504799335374048LLU), QU( 1531994113376881174LLU),
	QU( 2081314867544364459LLU), QU(16430628791616959932LLU),
	QU( 8314714038654394368LLU), QU( 9155473892098431813LLU),
	QU(12577843786670475704LLU), QU( 4399161106452401017LLU),
	QU( 1668083091682623186LLU), QU( 1741383777203714216LLU),
	QU( 2162597285417794374LLU), QU(15841980159165218736LLU),
	QU( 1971354603551467079LLU), QU( 1206714764913205968LLU),
	QU( 4790860439591272330LLU), QU(14699375615594055799LLU),
	QU( 8374423871657449988LLU), QU(10950685736472937738LLU),
	QU(  697344331343267176LLU), QU(10084998763118059810LLU),
	QU(12897369539795983124LLU), QU(12351260292144383605LLU),
	QU( 1268810970176811234LLU), QU( 7406287800414582768LLU),
	QU(  516169557043807831LLU), QU( 5077568278710520380LLU),
	QU( 3828791738309039304LLU), QU( 7721974069946943610LLU),
	QU( 3534670260981096460LLU), QU( 4865792189600584891LLU),
	QU(16892578493734337298LLU), QU( 9161499464278042590LLU),
	QU(11976149624067055931LLU), QU(13219479887277343990LLU),
	QU(14161556738111500680LLU), QU(14670715255011223056LLU),
	QU( 4671205678403576558LLU), QU(12633022931454259781LLU),
	QU(14821376219869187646LLU), QU(  751181776484317028LLU),
	QU( 2192211308839047070LLU), QU(11787306362361245189LLU),
	QU(10672375120744095707LLU), QU( 4601972328345244467LLU),
	QU(15457217788831125879LLU), QU( 8464345256775460809LLU),
	QU(10191938789487159478LLU), QU( 6184348739615197613LLU),
	QU(11425436778806882100LLU), QU( 2739227089124319793LLU),
	QU(  461464518456000551LLU), QU( 4689850170029177442LLU),
	QU( 6120307814374078625LLU), QU(11153579230681708671LLU),
	QU( 7891721473905347926LLU), QU(10281646937824872400LLU),
	QU( 3026099648191332248LLU), QU( 8666750296953273818LLU),
	QU(14978499698844363232LLU), QU(13303395102890132065LLU),
	QU( 8182358205292864080LLU), QU(10560547713972971291LLU),
	QU(11981635489418959093LLU), QU( 3134621354935288409LLU),
	QU(11580681977404383968LLU), QU(14205530317404088650LLU),
	QU( 5997789011854923157LLU), QU(13659151593432238041LLU),
	QU(11664332114338865086LLU), QU( 7490351383220929386LLU),
	QU( 7189290499881530378LLU), QU(15039262734271020220LLU),
	QU( 2057217285976980055LLU), QU(  555570804905355739LLU),
	QU(11235311968348555110LLU), QU(13824557146269603217LLU),
	QU(16906788840653099693LLU), QU( 7222878245455661677LLU),
	QU( 5245139444332423756LLU), QU( 4723748462805674292LLU),
	QU(12216509815698568612LLU), QU(17402362976648951187LLU),
	QU(17389614836810366768LLU), QU( 4880936484146667711LLU),
	QU( 9085007839292639880LLU), QU(13837353458498535449LLU),
	QU(11914419854360366677LLU), QU(16595890135313864103LLU),
	QU( 6313969847197627222LLU), QU(18296909792163910431LLU),
	QU(10041780113382084042LLU), QU( 2499478551172884794LLU),
	QU(11057894246241189489LLU), QU( 9742243032389068555LLU),
	QU(12838934582673196228LLU), QU(13437023235248490367LLU),
	QU(13372420669446163240LLU), QU( 6752564244716909224LLU),
	QU( 7157333073400313737LLU), QU(12230281516370654308LLU),
	QU( 1182884552219419117LLU), QU( 2955125381312499218LLU),
	QU(10308827097079443249LLU), QU( 1337648572986534958LLU),
	QU(16378788590020343939LLU), QU(  108619126514420935LLU),
	QU( 3990981009621629188LLU), QU( 5460953070230946410LLU),
	QU( 9703328329366531883LLU), QU(13166631489188077236LLU),
	QU( 1104768831213675170LLU), QU( 3447930458553877908LLU),
	QU( 8067172487769945676LLU), QU( 5445802098190775347LLU),
	QU( 3244840981648973873LLU), QU(17314668322981950060LLU),
	QU( 5006812527827763807LLU), QU(18158695070225526260LLU),
	QU( 2824536478852417853LLU), QU(13974775809127519886LLU),
	QU( 9814362769074067392LLU), QU(17276205156374862128LLU),
	QU(11361680725379306967LLU), QU( 3422581970382012542LLU),
	QU(11003189603753241266LLU), QU(11194292945277862261LLU),
	QU( 6839623313908521348LLU), QU(11935326462707324634LLU),
	QU( 1611456788685878444LLU), QU(13112620989475558907LLU),
	QU(  517659108904450427LLU), QU(13558114318574407624LLU),
	QU(15699089742731633077LLU), QU( 4988979278862685458LLU),
	QU( 8111373583056521297LLU), QU( 3891258746615399627LLU),
	QU( 8137298251469718086LLU), QU(12748663295624701649LLU),
	QU( 4389835683495292062LLU), QU( 5775217872128831729LLU),
	QU( 9462091896405534927LLU), QU( 8498124108820263989LLU),
	QU( 8059131278842839525LLU), QU(10503167994254090892LLU),
	QU(11613153541070396656LLU), QU(18069248738504647790LLU),
	QU(  570657419109768508LLU), QU( 3950574167771159665LLU),
	QU( 5514655599604313077LLU), QU( 2908460854428484165LLU),
	QU(10777722615935663114LLU), QU(12007363304839279486LLU),
	QU( 9800646187569484767LLU), QU( 8795423564889864287LLU),
	QU(14257396680131028419LLU), QU( 6405465117315096498LLU),
	QU( 7939411072208774878LLU), QU(17577572378528990006LLU),
	QU(14785873806715994850LLU), QU(16770572680854747390LLU),
	QU(18127549474419396481LLU), QU(11637013449455757750LLU),
	QU(14371851933996761086LLU), QU( 3601181063650110280LLU),
	QU( 4126442845019316144LLU), QU(10198287239244320669LLU),
	QU(18000169628555379659LLU), QU(18392482400739978269LLU),
	QU( 6219919037686919957LLU), QU( 3610085377719446052LLU),
	QU( 2513925039981776336LLU), QU(16679413537926716955LLU),
	QU(12903302131714909434LLU), QU( 5581145789762985009LLU),
	QU(12325955044293303233LLU), QU(17216111180742141204LLU),
	QU( 6321919595276545740LLU), QU( 3507521147216174501LLU),
	QU( 9659194593319481840LLU), QU(11473976005975358326LLU),
	QU(14742730101435987026LLU), QU(  492845897709954780LLU),
	QU(16976371186162599676LLU), QU(17712703422837648655LLU),
	QU( 9881254778587061697LLU), QU( 8413223156302299551LLU),
	QU( 1563841828254089168LLU), QU( 9996032758786671975LLU),
	QU(  138877700583772667LLU), QU(13003043368574995989LLU),
	QU( 4390573668650456587LLU), QU( 8610287390568126755LLU),
	QU(15126904974266642199LLU), QU( 6703637238986057662LLU),
	QU( 2873075592956810157LLU), QU( 6035080933946049418LLU),
	QU(13382846581202353014LLU), QU( 7303971031814642463LLU),
	QU(18418024405307444267LLU), QU( 5847096731675404647LLU),
	QU( 4035880699639842500LLU), QU(11525348625112218478LLU),
	QU( 3041162365459574102LLU), QU( 2604734487727986558LLU),
	QU(15526341771636983145LLU), QU(14556052310697370254LLU),
	QU(12997787077930808155LLU), QU( 9601806501755554499LLU),
	QU(11349677952521423389LLU), QU(14956777807644899350LLU),
	QU(16559736957742852721LLU), QU(12360828274778140726LLU),
	QU( 6685373272009662513LLU), QU(16932258748055324130LLU),
	QU(15918051131954158508LLU), QU( 1692312913140790144LLU),
	QU(  546653826801637367LLU), QU( 5341587076045986652LLU),
	QU(14975057236342585662LLU), QU(12374976357340622412LLU),
	QU(10328833995181940552LLU), QU(12831807101710443149LLU),
	QU(10548514914382545716LLU), QU( 2217806727199715993LLU),
	QU(12627067369242845138LLU), QU( 4598965364035438158LLU),
	QU(  150923352751318171LLU), QU(14274109544442257283LLU),
	QU( 4696661475093863031LLU), QU( 1505764114384654516LLU),
	QU(10699185831891495147LLU), QU( 2392353847713620519LLU),
	QU( 3652870166711788383LLU), QU( 8640653276221911108LLU),
	QU( 3894077592275889704LLU), QU( 4918592872135964845LLU),
	QU(16379121273281400789LLU), QU(12058465483591683656LLU),
	QU(11250106829302924945LLU), QU( 1147537556296983005LLU),
	QU( 6376342756004613268LLU), QU(14967128191709280506LLU),
	QU(18007449949790627628LLU), QU( 9497178279316537841LLU),
	QU( 7920174844809394893LLU), QU(10037752595255719907LLU),
	QU(15875342784985217697LLU), QU(15311615921712850696LLU),
	QU( 9552902652110992950LLU), QU(14054979450099721140LLU),
	QU( 5998709773566417349LLU), QU(18027910339276320187LLU),
	QU( 8223099053868585554LLU), QU( 7842270354824999767LLU),
	QU( 4896315688770080292LLU), QU(12969320296569787895LLU),
	QU( 2674321489185759961LLU), QU( 4053615936864718439LLU),
	QU(11349775270588617578LLU), QU( 4743019256284553975LLU),
	QU( 5602100217469723769LLU), QU(14398995691411527813LLU),
	QU( 7412170493796825470LLU), QU(  836262406131744846LLU),
	QU( 8231086633845153022LLU), QU( 5161377920438552287LLU),
	QU( 8828731196169924949LLU), QU(16211142246465502680LLU),
	QU( 3307990879253687818LLU), QU( 5193405406899782022LLU),
	QU( 8510842117467566693LLU), QU( 6070955181022405365LLU),
	QU(14482950231361409799LLU), QU(12585159371331138077LLU),
	QU( 3511537678933588148LLU), QU( 2041849474531116417LLU),
	QU(10944936685095345792LLU), QU(18303116923079107729LLU),
	QU( 2720566371239725320LLU), QU( 4958672473562397622LLU),
	QU( 3032326668253243412LLU), QU(13689418691726908338LLU),
	QU( 1895205511728843996LLU), QU( 8146303515271990527LLU),
	QU(16507343500056113480LLU), QU(  473996939105902919LLU),
	QU( 9897686885246881481LLU), QU(14606433762712790575LLU),
	QU( 6732796251605566368LLU), QU( 1399778120855368916LLU),
	QU(  935023885182833777LLU), QU(16066282816186753477LLU),
	QU( 7291270991820612055LLU), QU(17530230393129853844LLU),
	QU(10223493623477451366LLU), QU(15841725630495676683LLU),
	QU(17379567246435515824LLU), QU( 8588251429375561971LLU),
	QU(18339511210887206423LLU), QU(17349587430725976100LLU),
	QU(12244876521394838088LLU), QU( 6382187714147161259LLU),
	QU(12335807181848950831LLU), QU(16948885622305460665LLU),
	QU(13755097796371520506LLU), QU(14806740373324947801LLU),
	QU( 4828699633859287703LLU), QU( 8209879281452301604LLU),
	QU(12435716669553736437LLU), QU(13970976859588452131LLU),
	QU( 6233960842566773148LLU), QU(12507096267900505759LLU),
	QU( 1198713114381279421LLU), QU(14989862731124149015LLU),
	QU(15932189508707978949LLU), QU( 2526406641432708722LLU),
	QU(   29187427817271982LLU), QU( 1499802773054556353LLU),
	QU(10816638187021897173LLU), QU( 5436139270839738132LLU),
	QU( 6659882287036010082LLU), QU( 2154048955317173697LLU),
	QU(10887317019333757642LLU), QU(16281091802634424955LLU),
	QU(10754549879915384901LLU), QU(10760611745769249815LLU),
	QU( 2161505946972504002LLU), QU( 5243132808986265107LLU),
	QU(10129852179873415416LLU), QU(  710339480008649081LLU),
	QU( 7802129453068808528LLU), QU(17967213567178907213LLU),
	QU(15730859124668605599LLU), QU(13058356168962376502LLU),
	QU( 3701224985413645909LLU), QU(14464065869149109264LLU),
	QU( 9959272418844311646LLU), QU(10157426099515958752LLU),
	QU(14013736814538268528LLU), QU(17797456992065653951LLU),
	QU(17418878140257344806LLU), QU(15457429073540561521LLU),
	QU( 2184426881360949378LLU), QU( 2062193041154712416LLU),
	QU( 8553463347406931661LLU), QU( 4913057625202871854LLU),
	QU( 2668943682126618425LLU), QU(17064444737891172288LLU),
	QU( 4997115903913298637LLU), QU(12019402608892327416LLU),
	QU(17603584559765897352LLU), QU(11367529582073647975LLU),
	QU( 8211476043518436050LLU), QU( 8676849804070323674LLU),
	QU(18431829230394475730LLU), QU(10490177861361247904LLU),
	QU( 9508720602025651349LLU), QU( 7409627448555722700LLU),
	QU( 5804047018862729008LLU), QU(11943858176893142594LLU),
	QU(11908095418933847092LLU), QU( 5415449345715887652LLU),
	QU( 1554022699166156407LLU), QU( 9073322106406017161LLU),
	QU( 7080630967969047082LLU), QU(18049736940860732943LLU),
	QU(12748714242594196794LLU), QU( 1226992415735156741LLU),
	QU(17900981019609531193LLU), QU(11720739744008710999LLU),
	QU( 3006400683394775434LLU), QU(11347974011751996028LLU),
	QU( 3316999628257954608LLU), QU( 8384484563557639101LLU),
	QU(18117794685961729767LLU), QU( 1900145025596618194LLU),
	QU(17459527840632892676LLU), QU( 5634784101865710994LLU),
	QU( 7918619300292897158LLU), QU( 3146577625026301350LLU),
	QU( 9955212856499068767LLU), QU( 1873995843681746975LLU),
	QU( 1561487759967972194LLU), QU( 8322718804375878474LLU),
	QU(11300284215327028366LLU), QU( 4667391032508998982LLU),
	QU( 9820104494306625580LLU), QU(17922397968599970610LLU),
	QU( 1784690461886786712LLU), QU(14940365084341346821LLU),
	QU( 5348719575594186181LLU), QU(10720419084507855261LLU),
	QU(14210394354145143274LLU), QU( 2426468692164000131LLU),
	QU(16271062114607059202LLU), QU(14851904092357070247LLU),
	QU( 6524493015693121897LLU), QU( 9825473835127138531LLU),
	QU(14222500616268569578LLU), QU(15521484052007487468LLU),
	QU(14462579404124614699LLU), QU(11012375590820665520LLU),
	QU(11625327350536084927LLU), QU(14452017765243785417LLU),
	QU( 9989342263518766305LLU), QU( 3640105471101803790LLU),
	QU( 4749866455897513242LLU), QU(13963064946736312044LLU),
	QU(10007416591973223791LLU), QU(18314132234717431115LLU),
	QU( 3286596588617483450LLU), QU( 7726163455370818765LLU),
	QU( 7575454721115379328LLU), QU( 5308331576437663422LLU),
	QU(18288821894903530934LLU), QU( 8028405805410554106LLU),
	QU(15744019832103296628LLU), QU(  149765559630932100LLU),
	QU( 6137705557200071977LLU), QU(14513416315434803615LLU),
	QU(11665702820128984473LLU), QU(  218926670505601386LLU),
	QU( 6868675028717769519LLU), QU(15282016569441512302LLU),
	QU( 5707000497782960236LLU), QU( 6671120586555079567LLU),
	QU( 2194098052618985448LLU), QU(16849577895477330978LLU),
	QU(12957148471017466283LLU), QU( 1997805535404859393LLU),
	QU( 1180721060263860490LLU), QU(13206391310193756958LLU),
	QU(12980208674461861797LLU), QU( 3825967775058875366LLU),
	QU(17543433670782042631LLU), QU( 1518339070120322730LLU),
	QU(16344584340890991669LLU), QU( 2611327165318529819LLU),
	QU(11265022723283422529LLU), QU( 4001552800373196817LLU),
	QU(14509595890079346161LLU), QU( 3528717165416234562LLU),
	QU(18153222571501914072LLU), QU( 9387182977209744425LLU),
	QU(10064342315985580021LLU), QU(11373678413215253977LLU),
	QU( 2308457853228798099LLU), QU( 9729042942839545302LLU),
	QU( 7833785471140127746LLU), QU( 6351049900319844436LLU),
	QU(14454610627133496067LLU), QU(12533175683634819111LLU),
	QU(15570163926716513029LLU), QU(13356980519185762498LLU)
};

TEST_BEGIN(test_gen_rand_32)
{
	uint32_t array32[BLOCK_SIZE] JEMALLOC_ATTR(aligned(16));
	uint32_t array32_2[BLOCK_SIZE] JEMALLOC_ATTR(aligned(16));
	int i;
	uint32_t r32;
	sfmt_t *ctx;

	assert_d_le(get_min_array_size32(), BLOCK_SIZE,
	    "Array size too small");
	ctx = init_gen_rand(1234);
	fill_array32(ctx, array32, BLOCK_SIZE);
	fill_array32(ctx, array32_2, BLOCK_SIZE);
	fini_gen_rand(ctx);

	ctx = init_gen_rand(1234);
	for (i = 0; i < BLOCK_SIZE; i++) {
		if (i < COUNT_1) {
			assert_u32_eq(array32[i], init_gen_rand_32_expected[i],
			    "Output mismatch for i=%d", i);
		}
		r32 = gen_rand32(ctx);
		assert_u32_eq(r32, array32[i],
		    "Mismatch at array32[%d]=%x, gen=%x", i, array32[i], r32);
	}
	for (i = 0; i < COUNT_2; i++) {
		r32 = gen_rand32(ctx);
		assert_u32_eq(r32, array32_2[i],
		    "Mismatch at array32_2[%d]=%x, gen=%x", i, array32_2[i],
		    r32);
	}
	fini_gen_rand(ctx);
}
TEST_END

TEST_BEGIN(test_by_array_32)
{
	uint32_t array32[BLOCK_SIZE] JEMALLOC_ATTR(aligned(16));
	uint32_t array32_2[BLOCK_SIZE] JEMALLOC_ATTR(aligned(16));
	int i;
	uint32_t ini[4] = {0x1234, 0x5678, 0x9abc, 0xdef0};
	uint32_t r32;
	sfmt_t *ctx;

	assert_d_le(get_min_array_size32(), BLOCK_SIZE,
	    "Array size too small");
	ctx = init_by_array(ini, 4);
	fill_array32(ctx, array32, BLOCK_SIZE);
	fill_array32(ctx, array32_2, BLOCK_SIZE);
	fini_gen_rand(ctx);

	ctx = init_by_array(ini, 4);
	for (i = 0; i < BLOCK_SIZE; i++) {
		if (i < COUNT_1) {
			assert_u32_eq(array32[i], init_by_array_32_expected[i],
			    "Output mismatch for i=%d", i);
		}
		r32 = gen_rand32(ctx);
		assert_u32_eq(r32, array32[i],
		    "Mismatch at array32[%d]=%x, gen=%x", i, array32[i], r32);
	}
	for (i = 0; i < COUNT_2; i++) {
		r32 = gen_rand32(ctx);
		assert_u32_eq(r32, array32_2[i],
		    "Mismatch at array32_2[%d]=%x, gen=%x", i, array32_2[i],
		    r32);
	}
	fini_gen_rand(ctx);
}
TEST_END

TEST_BEGIN(test_gen_rand_64)
{
	uint64_t array64[BLOCK_SIZE64] JEMALLOC_ATTR(aligned(16));
	uint64_t array64_2[BLOCK_SIZE64] JEMALLOC_ATTR(aligned(16));
	int i;
	uint64_t r;
	sfmt_t *ctx;

	assert_d_le(get_min_array_size64(), BLOCK_SIZE64,
	    "Array size too small");
	ctx = init_gen_rand(4321);
	fill_array64(ctx, array64, BLOCK_SIZE64);
	fill_array64(ctx, array64_2, BLOCK_SIZE64);
	fini_gen_rand(ctx);

	ctx = init_gen_rand(4321);
	for (i = 0; i < BLOCK_SIZE64; i++) {
		if (i < COUNT_1) {
			assert_u64_eq(array64[i], init_gen_rand_64_expected[i],
			    "Output mismatch for i=%d", i);
		}
		r = gen_rand64(ctx);
		assert_u64_eq(r, array64[i],
		    "Mismatch at array64[%d]=%"PRIx64", gen=%"PRIx64, i,
		    array64[i], r);
	}
	for (i = 0; i < COUNT_2; i++) {
		r = gen_rand64(ctx);
		assert_u64_eq(r, array64_2[i],
		    "Mismatch at array64_2[%d]=%"PRIx64" gen=%"PRIx64"", i,
		    array64_2[i], r);
	}
	fini_gen_rand(ctx);
}
TEST_END

TEST_BEGIN(test_by_array_64)
{
	uint64_t array64[BLOCK_SIZE64] JEMALLOC_ATTR(aligned(16));
	uint64_t array64_2[BLOCK_SIZE64] JEMALLOC_ATTR(aligned(16));
	int i;
	uint64_t r;
	uint32_t ini[] = {5, 4, 3, 2, 1};
	sfmt_t *ctx;

	assert_d_le(get_min_array_size64(), BLOCK_SIZE64,
	    "Array size too small");
	ctx = init_by_array(ini, 5);
	fill_array64(ctx, array64, BLOCK_SIZE64);
	fill_array64(ctx, array64_2, BLOCK_SIZE64);
	fini_gen_rand(ctx);

	ctx = init_by_array(ini, 5);
	for (i = 0; i < BLOCK_SIZE64; i++) {
		if (i < COUNT_1) {
			assert_u64_eq(array64[i], init_by_array_64_expected[i],
			    "Output mismatch for i=%d", i);
		}
		r = gen_rand64(ctx);
		assert_u64_eq(r, array64[i],
		    "Mismatch at array64[%d]=%"PRIx64" gen=%"PRIx64, i,
		    array64[i], r);
	}
	for (i = 0; i < COUNT_2; i++) {
		r = gen_rand64(ctx);
		assert_u64_eq(r, array64_2[i],
		    "Mismatch at array64_2[%d]=%"PRIx64" gen=%"PRIx64, i,
		    array64_2[i], r);
	}
	fini_gen_rand(ctx);
}
TEST_END

int
main(void)
{

	return (test(
	    test_gen_rand_32,
	    test_by_array_32,
	    test_gen_rand_64,
	    test_by_array_64));
}
