# ***************************************************************************
# *   Copyright (C) 2003 by abdulhaq                                        *
# *   aalynch@users.sourceforge.net                                        *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License version 2 as published by  *
# *   the Free Software Foundation;                                         *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
# ***************************************************************************/

from PyQt4 import QtGui, QtCore

import equation

class GraphLabel(QtGui.QLabel):

    popup = None

    def __init__(self, calcWindow, *args):
        QtGui.QLabel.__init__(self, calcWindow, *args)

        self.calcWindow = calcWindow
        return
        self.popupMenu = QPopupMenu(self)
        caption = QtGui.QLabel( "<font color=darkblue><b>Kayali - Plot</b></font>", self)
        caption.setAlignment( QtGui.AlignCenter )
        self.popupMenu.insertItem(caption)
        self.popupMenu.insertItem( "&Open in GnuPlot", self.reopen, Qt.CTRL+Qt.Key_O )
        self.popupMenu.insertItem( "&Close", self.close, Qt.CTRL+Qt.Key_C )
        self.popupMenu.insertItem( "&Replot with new parameters", self.replot, Qt.CTRL+Qt.Key_R )

    def mousePressEvent(self, e):
        if e.button() == Qt.RightButton:
            self.popupMenu.popup(e.globalPos())

    def reopen(self):
        thisPlot = equation.plots[self]
        equation,allVars,options = thisPlot
        plotCommand = self.calcWindow.dlgPlot.getPlotCommand(equation.text,allVars,options,True)
        self.calcWindow.calcEngine.evaluateInput(plotCommand)

    def close(self):
        self.tab.removePage(self)

    def replot(self):

        thisPlot = equation.plots[self]
        equation,allVars,options = thisPlot
        self.calcWindow.dlgPlot.showVars(allVars)
        self.calcWindow.dlgPlot.equation.setEquation(equation)
        plotOptions = self.calcWindow.dlgPlot.getPlotOptions()
        plotCommand = self.calcWindow.dlgPlot.getPlotCommand(equation,allVars,options,True)
        self.calcWindow.evaluateInput(plotCommand)
