/* ----- nG/montgomery25519, derived from supercop/crypto_nG/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <lib25519.h>
#include "lib25519_test.h"

#define fail ((ok = 0),printf)
static const char *nG_montgomery25519_checksums[] = {
  "5c8a5d8b32e3d26b33071779ce9191095d7bd4ab3bb6a40b68976e41a98cfc3b",
  "2becc8cd065820fcf82e53a03c5b5235582480fc11d072f2bd15153aebd4e057",
} ;

static void (*crypto_nG)(unsigned char *,const unsigned char *);
#define crypto_nG_SCALARBYTES lib25519_nG_montgomery25519_SCALARBYTES
#define crypto_nG_POINTBYTES lib25519_nG_montgomery25519_POINTBYTES

static void *storage_nG_montgomery25519_q;
static unsigned char *test_nG_montgomery25519_q;
static void *storage_nG_montgomery25519_n;
static unsigned char *test_nG_montgomery25519_n;
static void *storage_nG_montgomery25519_q2;
static unsigned char *test_nG_montgomery25519_q2;
static void *storage_nG_montgomery25519_n2;
static unsigned char *test_nG_montgomery25519_n2;

#define precomputed_nG_montgomery25519_NUM 204

static const unsigned char precomputed_nG_montgomery25519_q_0[] = {44,101,73,224,192,197,182,193,198,236,100,246,66,1,61,81,166,127,157,110,54,66,251,198,92,55,173,36,249,59,233,126};
static const unsigned char precomputed_nG_montgomery25519_n_0[] = {248,181,1,40,168,159,146,159,7,139,148,246,114,42,35,194,81,211,62,44,126,145,190,89,62,58,107,20,218,93,118,95};
static const unsigned char precomputed_nG_montgomery25519_q_1[] = {22,233,216,103,29,176,73,7,154,58,234,156,164,185,58,67,63,98,25,70,163,27,197,131,27,124,136,194,50,127,27,91};
static const unsigned char precomputed_nG_montgomery25519_n_1[] = {14,232,69,146,96,32,217,118,165,148,112,63,5,13,120,17,228,235,88,112,98,223,9,159,154,56,205,253,30,183,254,241};
static const unsigned char precomputed_nG_montgomery25519_q_2[] = {11,119,200,123,188,243,40,196,247,76,172,56,18,200,54,108,199,218,66,158,249,60,59,253,46,128,27,35,33,98,140,121};
static const unsigned char precomputed_nG_montgomery25519_n_2[] = {11,163,86,36,137,113,113,229,202,180,1,160,250,8,230,243,132,17,69,51,144,151,87,27,156,223,140,110,112,87,53,140};
static const unsigned char precomputed_nG_montgomery25519_q_3[] = {232,150,156,228,44,205,185,197,125,253,134,159,89,140,116,166,52,204,93,160,165,235,252,106,74,24,135,3,220,188,153,18};
static const unsigned char precomputed_nG_montgomery25519_n_3[] = {16,216,149,3,205,241,168,94,207,104,27,160,54,112,73,99,134,123,175,246,124,247,59,182,146,31,82,203,200,18,92,130};
static const unsigned char precomputed_nG_montgomery25519_q_4[] = {251,17,37,208,222,241,58,226,178,13,172,0,33,142,148,168,121,36,132,171,245,230,144,7,155,170,104,45,90,96,96,72};
static const unsigned char precomputed_nG_montgomery25519_n_4[] = {148,4,13,240,188,103,159,76,215,255,194,136,69,190,104,224,217,76,164,0,233,176,114,160,88,113,113,9,79,141,177,167};
static const unsigned char precomputed_nG_montgomery25519_q_5[] = {42,58,16,107,223,183,177,33,181,110,224,163,48,54,79,177,87,245,128,181,167,50,136,8,250,202,95,210,148,233,40,116};
static const unsigned char precomputed_nG_montgomery25519_n_5[] = {18,57,230,52,26,1,62,159,250,37,100,205,24,38,31,225,20,8,251,54,163,185,28,238,130,157,199,35,237,92,244,183};
static const unsigned char precomputed_nG_montgomery25519_q_6[] = {97,239,71,43,224,161,158,90,19,122,241,102,97,255,166,42,96,161,158,9,11,221,175,222,163,228,209,79,49,242,182,119};
static const unsigned char precomputed_nG_montgomery25519_n_6[] = {31,148,53,108,30,105,71,99,143,68,89,101,48,139,33,183,231,45,1,138,84,28,226,175,40,187,63,17,182,147,181,111};
static const unsigned char precomputed_nG_montgomery25519_q_7[] = {154,114,106,210,32,53,205,118,189,69,147,82,82,194,188,134,3,234,129,186,111,226,201,222,157,165,205,54,110,139,120,83};
static const unsigned char precomputed_nG_montgomery25519_n_7[] = {88,108,123,69,26,196,138,148,157,192,0,60,139,64,0,18,50,253,240,196,178,158,190,242,213,127,171,27,171,100,126,98};
static const unsigned char precomputed_nG_montgomery25519_q_8[] = {255,124,30,66,230,132,210,253,61,154,13,174,253,37,123,239,111,36,77,63,2,122,199,142,34,154,140,2,60,18,193,38};
static const unsigned char precomputed_nG_montgomery25519_n_8[] = {199,203,24,166,64,157,248,207,126,145,226,70,226,46,83,164,212,97,249,87,34,190,68,80,167,63,215,145,26,153,223,72};
static const unsigned char precomputed_nG_montgomery25519_q_9[] = {233,203,176,130,48,239,30,31,73,239,234,82,72,96,143,113,37,101,28,17,113,90,196,238,212,68,64,137,165,236,73,32};
static const unsigned char precomputed_nG_montgomery25519_n_9[] = {12,178,98,251,119,168,170,140,182,33,62,143,118,199,236,245,180,189,123,225,65,6,230,228,227,92,55,211,134,132,198,38};
static const unsigned char precomputed_nG_montgomery25519_q_10[] = {235,43,183,250,73,96,207,60,226,212,213,174,72,40,62,49,32,238,19,237,100,203,157,20,16,80,17,188,169,199,87,69};
static const unsigned char precomputed_nG_montgomery25519_n_10[] = {202,122,215,32,241,88,182,107,239,199,244,200,35,37,123,181,26,150,59,21,180,73,135,215,184,42,187,112,115,13,235,84};
static const unsigned char precomputed_nG_montgomery25519_q_11[] = {201,14,27,106,204,26,136,248,200,36,109,120,34,56,120,195,103,145,198,66,151,130,68,56,51,120,64,116,101,166,148,34};
static const unsigned char precomputed_nG_montgomery25519_n_11[] = {119,199,1,5,187,141,221,57,160,118,141,51,84,183,7,115,31,183,209,1,224,243,85,240,163,250,207,186,125,153,24,121};
static const unsigned char precomputed_nG_montgomery25519_q_12[] = {18,17,188,202,61,40,175,192,37,198,66,1,209,60,129,254,194,76,254,181,30,207,172,187,242,254,97,118,71,131,64,121};
static const unsigned char precomputed_nG_montgomery25519_n_12[] = {147,181,139,164,118,11,157,253,138,152,243,158,200,155,204,226,14,234,142,113,42,233,232,152,113,172,69,205,115,162,116,65};
static const unsigned char precomputed_nG_montgomery25519_q_13[] = {37,224,252,164,235,13,240,252,189,252,60,188,200,216,143,15,252,125,135,25,180,38,248,255,215,211,197,207,205,250,234,6};
static const unsigned char precomputed_nG_montgomery25519_n_13[] = {151,201,136,193,3,163,232,197,250,69,54,50,146,250,192,80,116,116,69,85,81,243,34,135,215,190,6,34,187,205,146,211};
static const unsigned char precomputed_nG_montgomery25519_q_14[] = {109,65,57,126,39,59,194,55,244,212,93,233,113,222,214,19,240,116,36,152,0,118,101,227,49,251,93,111,143,23,201,29};
static const unsigned char precomputed_nG_montgomery25519_n_14[] = {53,140,196,22,171,6,214,196,80,29,248,191,58,99,92,7,43,116,208,20,74,221,103,42,77,122,30,52,191,213,24,111};
static const unsigned char precomputed_nG_montgomery25519_q_15[] = {140,101,22,137,6,44,213,100,234,203,208,180,139,115,83,102,43,195,100,183,105,9,246,30,25,84,161,100,50,117,182,83};
static const unsigned char precomputed_nG_montgomery25519_n_15[] = {152,21,165,122,147,183,199,178,223,227,148,248,12,192,148,244,198,101,20,221,20,40,81,179,137,166,133,247,158,97,16,186};
static const unsigned char precomputed_nG_montgomery25519_q_16[] = {203,46,169,217,216,136,69,179,134,217,182,110,81,152,110,71,18,222,44,153,11,72,221,54,218,73,175,50,62,227,189,105};
static const unsigned char precomputed_nG_montgomery25519_n_16[] = {199,126,47,157,213,119,132,90,244,150,154,153,154,154,175,20,126,75,236,6,157,105,203,242,103,149,187,238,74,100,29,95};
static const unsigned char precomputed_nG_montgomery25519_q_17[] = {128,93,5,190,107,222,19,204,217,12,113,236,162,176,166,25,251,40,252,164,171,43,90,44,6,77,20,164,154,63,158,7};
static const unsigned char precomputed_nG_montgomery25519_n_17[] = {147,41,221,16,120,22,132,154,184,105,117,139,112,209,48,48,102,83,82,213,18,58,173,96,158,249,223,174,110,72,249,153};
static const unsigned char precomputed_nG_montgomery25519_q_18[] = {9,218,176,210,206,47,135,144,154,202,245,156,198,134,209,172,52,35,134,21,218,42,99,135,81,134,110,255,138,126,248,34};
static const unsigned char precomputed_nG_montgomery25519_n_18[] = {112,148,171,50,138,202,67,156,140,89,111,230,219,30,184,200,227,20,71,82,155,103,17,59,134,168,24,154,48,55,32,71};
static const unsigned char precomputed_nG_montgomery25519_q_19[] = {8,3,202,49,25,245,106,49,116,110,42,158,86,222,129,254,168,26,255,3,247,11,249,170,190,211,250,155,24,150,192,41};
static const unsigned char precomputed_nG_montgomery25519_n_19[] = {199,183,70,67,59,68,228,176,208,10,125,52,255,142,161,107,28,174,244,115,102,51,114,77,64,190,79,234,136,47,175,91};
static const unsigned char precomputed_nG_montgomery25519_q_20[] = {228,227,141,214,206,35,141,24,202,113,127,15,243,143,213,65,42,116,208,171,234,179,152,66,10,169,171,57,71,192,159,85};
static const unsigned char precomputed_nG_montgomery25519_n_20[] = {233,159,249,86,219,139,158,70,42,195,176,76,198,41,132,143,44,224,5,108,23,14,93,69,204,227,164,90,104,14,60,40};
static const unsigned char precomputed_nG_montgomery25519_q_21[] = {207,123,193,30,219,178,11,72,105,117,4,65,4,162,57,212,54,199,105,198,19,197,31,67,143,39,113,74,202,173,159,91};
static const unsigned char precomputed_nG_montgomery25519_n_21[] = {190,72,88,96,176,73,76,47,132,132,175,86,38,14,206,53,218,244,156,179,108,147,149,29,169,28,214,15,234,26,85,53};
static const unsigned char precomputed_nG_montgomery25519_q_22[] = {126,135,38,197,155,193,166,187,158,210,160,0,248,215,35,59,136,120,38,73,173,186,23,18,95,9,248,187,43,13,199,101};
static const unsigned char precomputed_nG_montgomery25519_n_22[] = {61,117,112,156,219,187,229,35,238,210,246,106,48,168,101,69,220,180,114,154,115,7,171,250,27,121,92,134,165,83,99,112};
static const unsigned char precomputed_nG_montgomery25519_q_23[] = {90,163,30,112,14,2,97,154,84,67,176,71,190,143,20,7,240,216,14,241,210,1,250,181,129,147,94,225,35,32,40,76};
static const unsigned char precomputed_nG_montgomery25519_n_23[] = {250,220,191,52,104,105,84,62,242,254,8,18,46,88,247,248,39,31,253,69,209,26,127,225,178,41,120,249,238,52,73,53};
static const unsigned char precomputed_nG_montgomery25519_q_24[] = {43,176,209,174,33,167,159,219,239,213,211,254,235,136,64,88,102,86,126,197,24,230,200,108,26,105,230,132,70,203,15,60};
static const unsigned char precomputed_nG_montgomery25519_n_24[] = {165,236,60,105,227,60,108,62,233,194,213,235,121,33,24,69,113,87,55,189,250,66,55,250,182,214,129,41,251,136,2,211};
static const unsigned char precomputed_nG_montgomery25519_q_25[] = {18,108,13,98,125,12,35,117,78,14,173,144,130,233,220,103,61,48,61,138,173,73,78,230,43,146,200,198,202,68,166,114};
static const unsigned char precomputed_nG_montgomery25519_n_25[] = {183,127,46,22,41,41,11,240,249,213,246,134,2,67,153,129,251,42,136,14,216,249,183,120,53,251,1,106,115,229,245,147};
static const unsigned char precomputed_nG_montgomery25519_q_26[] = {36,32,32,180,194,114,27,225,13,172,80,245,211,245,17,217,34,50,62,79,248,217,44,43,7,129,4,138,24,80,143,79};
static const unsigned char precomputed_nG_montgomery25519_n_26[] = {144,246,246,13,14,80,136,47,137,223,221,221,172,249,61,118,37,166,102,74,111,169,38,132,56,10,247,64,253,214,61,241};
static const unsigned char precomputed_nG_montgomery25519_q_27[] = {14,21,190,58,193,178,32,136,216,132,1,159,253,136,204,25,198,161,209,166,24,212,123,57,204,106,194,185,61,102,133,114};
static const unsigned char precomputed_nG_montgomery25519_n_27[] = {185,57,126,93,32,245,59,244,228,128,212,243,96,46,242,13,13,75,2,167,111,120,117,105,47,12,230,96,5,40,73,184};
static const unsigned char precomputed_nG_montgomery25519_q_28[] = {213,51,228,40,129,146,130,248,131,62,14,178,172,217,20,149,191,212,249,72,1,34,156,61,74,34,226,105,17,84,209,80};
static const unsigned char precomputed_nG_montgomery25519_n_28[] = {109,84,200,146,153,129,235,230,7,79,177,144,214,106,177,23,5,90,63,28,203,159,12,93,87,217,61,244,52,63,225,61};
static const unsigned char precomputed_nG_montgomery25519_q_29[] = {129,167,201,196,132,169,163,1,17,105,68,159,113,135,169,108,40,212,23,159,143,238,70,113,27,52,199,197,95,146,85,126};
static const unsigned char precomputed_nG_montgomery25519_n_29[] = {228,162,222,194,144,84,3,9,115,119,212,85,233,217,59,199,57,157,40,142,48,6,250,102,92,195,127,128,27,22,158,71};
static const unsigned char precomputed_nG_montgomery25519_q_30[] = {120,103,152,49,82,245,180,210,18,103,251,55,45,145,67,83,21,117,18,175,181,22,48,61,206,21,154,250,12,134,157,23};
static const unsigned char precomputed_nG_montgomery25519_n_30[] = {171,218,223,232,27,15,193,203,132,118,247,251,155,117,124,7,128,103,192,93,64,34,74,143,66,151,138,176,6,252,218,205};
static const unsigned char precomputed_nG_montgomery25519_q_31[] = {127,149,123,121,135,208,71,131,79,205,255,68,95,48,168,111,64,113,226,65,209,97,166,86,123,14,198,194,84,249,147,57};
static const unsigned char precomputed_nG_montgomery25519_n_31[] = {73,212,56,83,87,96,45,59,56,150,101,42,101,118,4,94,69,135,31,96,60,74,155,222,137,187,207,211,110,129,54,134};
static const unsigned char precomputed_nG_montgomery25519_q_32[] = {137,150,86,87,214,209,137,142,54,23,127,97,186,99,246,136,84,195,89,22,226,112,3,222,181,48,26,113,72,46,18,68};
static const unsigned char precomputed_nG_montgomery25519_n_32[] = {128,86,9,240,10,150,186,54,196,60,206,41,190,111,6,15,104,70,250,151,198,189,157,227,13,100,184,190,70,252,108,106};
static const unsigned char precomputed_nG_montgomery25519_q_33[] = {120,108,163,209,215,42,47,22,132,165,178,217,23,235,221,94,11,144,55,102,118,56,235,203,26,31,235,91,2,233,9,57};
static const unsigned char precomputed_nG_montgomery25519_n_33[] = {143,68,191,130,34,54,10,179,78,122,92,103,61,194,242,182,56,117,173,172,239,46,26,254,221,174,44,106,77,163,109,150};
static const unsigned char precomputed_nG_montgomery25519_q_34[] = {51,39,77,39,12,64,251,237,75,31,86,190,173,24,121,116,204,235,21,66,28,17,160,215,115,32,87,235,99,0,70,73};
static const unsigned char precomputed_nG_montgomery25519_n_34[] = {6,48,68,18,62,116,229,178,180,39,94,200,111,75,220,203,76,199,207,219,113,118,148,175,32,32,107,146,64,12,228,65};
static const unsigned char precomputed_nG_montgomery25519_q_35[] = {156,178,123,100,84,35,125,66,241,126,52,112,26,121,95,96,46,13,32,86,1,209,114,182,78,32,135,74,149,53,56,89};
static const unsigned char precomputed_nG_montgomery25519_n_35[] = {54,5,81,2,149,104,165,112,156,85,53,35,105,152,8,215,27,169,227,200,119,128,41,178,83,124,82,55,80,34,124,147};
static const unsigned char precomputed_nG_montgomery25519_q_36[] = {64,79,89,242,159,172,86,45,6,141,239,99,98,223,140,102,111,250,187,174,139,78,208,60,128,208,255,239,40,124,197,100};
static const unsigned char precomputed_nG_montgomery25519_n_36[] = {132,195,224,61,35,5,159,144,25,69,4,4,244,116,232,252,18,91,221,80,99,247,100,169,124,166,202,86,74,253,217,77};
static const unsigned char precomputed_nG_montgomery25519_q_37[] = {83,156,177,241,3,80,35,145,181,118,166,248,17,239,23,170,31,152,148,199,160,196,98,107,210,33,239,125,129,173,11,112};
static const unsigned char precomputed_nG_montgomery25519_n_37[] = {80,56,243,242,188,63,207,83,52,5,144,165,76,248,253,168,159,178,148,61,10,233,168,227,9,236,253,57,87,93,157,133};
static const unsigned char precomputed_nG_montgomery25519_q_38[] = {243,184,108,115,167,61,66,115,189,103,208,101,151,125,150,73,235,160,215,7,167,34,113,116,91,10,18,21,241,157,169,25};
static const unsigned char precomputed_nG_montgomery25519_n_38[] = {231,188,33,49,132,250,243,148,132,244,118,152,49,163,206,63,32,69,96,52,196,79,0,159,62,60,118,108,183,151,228,232};
static const unsigned char precomputed_nG_montgomery25519_q_39[] = {219,184,178,42,76,242,99,76,211,155,123,47,162,5,41,170,253,180,125,151,68,141,133,133,149,250,27,187,31,238,212,31};
static const unsigned char precomputed_nG_montgomery25519_n_39[] = {43,158,30,127,10,160,120,118,158,170,140,134,64,33,132,156,29,44,71,180,174,52,16,184,8,204,93,155,16,209,127,97};
static const unsigned char precomputed_nG_montgomery25519_q_40[] = {24,77,226,254,82,120,244,151,250,191,142,87,196,80,117,173,128,35,37,190,63,246,152,209,55,109,125,174,176,123,195,42};
static const unsigned char precomputed_nG_montgomery25519_n_40[] = {150,131,157,218,200,100,94,164,145,203,20,105,222,208,169,27,13,186,35,245,28,144,248,193,82,95,235,172,180,170,118,124};
static const unsigned char precomputed_nG_montgomery25519_q_41[] = {111,125,87,59,189,141,150,157,177,154,49,224,192,185,125,47,118,225,94,50,164,225,47,31,26,59,3,110,175,121,255,63};
static const unsigned char precomputed_nG_montgomery25519_n_41[] = {193,246,237,0,40,33,29,56,183,153,174,89,123,144,18,83,96,136,49,82,239,132,102,241,0,53,52,62,17,45,121,18};
static const unsigned char precomputed_nG_montgomery25519_q_42[] = {74,161,209,191,143,72,135,114,36,221,77,51,77,61,210,243,82,42,233,127,149,62,173,6,142,107,76,119,122,52,0,24};
static const unsigned char precomputed_nG_montgomery25519_n_42[] = {70,3,65,0,114,24,25,165,155,42,222,112,212,37,3,7,163,20,13,4,9,101,15,124,148,110,72,37,49,216,152,0};
static const unsigned char precomputed_nG_montgomery25519_q_43[] = {240,17,65,128,222,188,51,179,44,254,96,233,152,221,248,113,109,126,143,3,165,24,49,239,182,203,195,77,153,21,26,16};
static const unsigned char precomputed_nG_montgomery25519_n_43[] = {33,194,117,109,66,207,181,250,92,38,54,162,70,144,28,242,118,168,64,183,98,239,199,235,154,113,222,57,0,186,194,49};
static const unsigned char precomputed_nG_montgomery25519_q_44[] = {70,60,90,37,152,210,72,119,75,248,250,200,153,217,188,179,196,241,189,227,97,221,11,237,158,126,217,113,77,144,83,35};
static const unsigned char precomputed_nG_montgomery25519_n_44[] = {193,201,139,241,210,71,234,92,126,85,186,0,4,145,4,241,77,35,164,79,95,114,230,112,21,41,180,230,215,116,73,184};
static const unsigned char precomputed_nG_montgomery25519_q_45[] = {129,118,6,79,108,115,231,206,173,24,242,100,63,20,27,107,141,232,187,210,82,114,175,42,14,76,72,103,186,85,27,46};
static const unsigned char precomputed_nG_montgomery25519_n_45[] = {150,139,28,166,172,205,159,1,23,222,96,89,102,139,25,175,183,101,239,183,206,32,33,192,41,22,223,107,143,73,160,50};
static const unsigned char precomputed_nG_montgomery25519_q_46[] = {219,61,28,233,38,51,65,2,96,178,192,54,95,214,207,115,46,121,124,181,251,20,214,205,199,27,84,8,85,19,48,103};
static const unsigned char precomputed_nG_montgomery25519_n_46[] = {251,133,84,194,4,222,184,37,45,25,80,61,85,223,22,91,124,40,235,196,203,193,31,137,38,211,231,154,76,104,73,200};
static const unsigned char precomputed_nG_montgomery25519_q_47[] = {165,191,33,172,185,254,208,67,197,9,199,247,156,53,228,176,95,45,236,46,250,120,42,230,68,117,25,236,2,161,233,38};
static const unsigned char precomputed_nG_montgomery25519_n_47[] = {131,86,213,72,251,92,146,144,158,137,245,228,136,104,186,182,226,128,158,192,62,202,69,189,225,43,214,117,51,26,31,51};
static const unsigned char precomputed_nG_montgomery25519_q_48[] = {2,194,163,242,105,204,65,204,69,54,166,138,0,160,39,161,68,206,132,81,40,122,143,120,238,196,216,243,243,86,9,3};
static const unsigned char precomputed_nG_montgomery25519_n_48[] = {60,42,201,227,21,150,42,186,133,169,250,72,97,236,91,235,123,183,31,173,64,51,96,236,221,228,0,223,179,62,23,89};
static const unsigned char precomputed_nG_montgomery25519_q_49[] = {59,49,73,91,67,32,68,135,249,39,2,143,248,204,34,10,163,154,194,12,173,67,107,115,194,162,64,117,168,63,45,68};
static const unsigned char precomputed_nG_montgomery25519_n_49[] = {128,199,106,32,154,78,38,27,72,148,80,4,95,247,73,203,28,41,88,197,27,184,58,22,198,111,243,15,190,166,149,198};
static const unsigned char precomputed_nG_montgomery25519_q_50[] = {118,185,133,0,163,216,37,228,197,73,162,158,208,118,252,196,144,118,90,172,3,170,49,62,40,161,26,79,99,207,48,73};
static const unsigned char precomputed_nG_montgomery25519_n_50[] = {127,101,191,28,148,8,98,199,227,49,249,127,188,215,238,202,94,48,189,113,126,162,24,156,49,220,132,169,16,205,44,51};
static const unsigned char precomputed_nG_montgomery25519_q_51[] = {151,140,64,139,222,109,163,24,8,7,171,199,62,167,194,130,220,166,14,55,133,56,215,239,100,79,12,215,59,35,47,5};
static const unsigned char precomputed_nG_montgomery25519_n_51[] = {32,114,157,231,253,81,34,116,65,111,53,89,235,252,196,252,48,13,141,44,21,182,186,106,84,221,61,119,12,206,88,155};
static const unsigned char precomputed_nG_montgomery25519_q_52[] = {146,200,111,108,165,8,233,118,47,44,9,200,173,98,87,150,201,29,12,120,52,115,41,9,102,238,154,13,118,165,80,8};
static const unsigned char precomputed_nG_montgomery25519_n_52[] = {25,189,178,233,5,103,25,80,233,209,70,192,154,204,135,200,150,5,16,53,37,51,165,109,147,246,72,162,122,250,68,194};
static const unsigned char precomputed_nG_montgomery25519_q_53[] = {219,85,213,7,35,123,174,0,146,57,249,221,49,106,153,177,125,210,202,249,215,106,135,220,50,108,101,221,120,222,209,121};
static const unsigned char precomputed_nG_montgomery25519_n_53[] = {172,208,42,169,82,1,140,1,13,13,126,143,78,134,234,87,52,24,69,233,98,68,63,110,47,160,4,231,94,116,177,114};
static const unsigned char precomputed_nG_montgomery25519_q_54[] = {238,52,219,74,35,150,194,118,91,22,192,59,176,21,39,105,71,79,179,208,28,50,48,174,222,202,50,32,17,86,136,74};
static const unsigned char precomputed_nG_montgomery25519_n_54[] = {34,121,0,61,76,153,99,93,123,129,113,110,206,196,186,13,188,221,84,169,8,138,142,207,90,12,143,247,209,84,77,131};
static const unsigned char precomputed_nG_montgomery25519_q_55[] = {238,83,44,137,90,53,130,229,180,124,10,146,170,228,211,83,122,247,24,29,38,201,8,67,244,71,153,35,158,158,248,94};
static const unsigned char precomputed_nG_montgomery25519_n_55[] = {42,136,94,105,148,88,105,238,54,10,193,182,191,238,173,106,165,179,167,114,129,129,171,197,72,161,212,183,140,130,184,99};
static const unsigned char precomputed_nG_montgomery25519_q_56[] = {92,28,64,43,179,201,212,121,19,176,150,159,19,34,105,211,186,150,29,79,217,30,43,18,91,244,147,30,37,50,145,73};
static const unsigned char precomputed_nG_montgomery25519_n_56[] = {18,205,14,159,90,202,16,229,181,12,52,228,161,16,61,44,107,173,102,151,53,184,32,24,130,29,92,84,67,92,132,180};
static const unsigned char precomputed_nG_montgomery25519_q_57[] = {42,123,79,236,5,178,213,172,228,33,53,20,223,155,22,83,178,60,197,76,216,66,253,72,234,255,100,190,187,215,47,111};
static const unsigned char precomputed_nG_montgomery25519_n_57[] = {163,203,116,25,171,243,121,61,195,21,221,204,26,153,102,181,18,126,247,132,97,24,154,66,189,179,44,203,2,156,163,230};
static const unsigned char precomputed_nG_montgomery25519_q_58[] = {250,177,147,217,233,160,186,29,119,105,104,242,246,148,130,225,133,120,254,157,80,7,137,38,116,114,236,211,201,59,47,56};
static const unsigned char precomputed_nG_montgomery25519_n_58[] = {125,31,64,167,137,175,45,21,51,211,233,128,110,198,74,117,45,90,176,84,221,252,149,184,186,209,44,76,155,54,22,59};
static const unsigned char precomputed_nG_montgomery25519_q_59[] = {129,77,30,15,126,37,8,178,208,227,146,4,183,147,231,48,102,168,28,240,188,210,90,245,217,121,55,56,86,40,22,112};
static const unsigned char precomputed_nG_montgomery25519_n_59[] = {201,219,182,219,90,131,170,113,119,195,100,44,89,247,250,41,204,90,36,184,227,150,213,164,34,114,159,96,7,210,203,249};
static const unsigned char precomputed_nG_montgomery25519_q_60[] = {121,66,2,74,6,6,88,169,97,137,221,1,33,78,114,235,25,147,99,206,254,85,152,219,170,41,133,78,143,99,59,127};
static const unsigned char precomputed_nG_montgomery25519_n_60[] = {80,128,135,167,93,150,211,226,214,185,68,212,42,8,155,194,56,246,61,248,130,15,179,233,68,78,0,21,88,229,27,250};
static const unsigned char precomputed_nG_montgomery25519_q_61[] = {170,119,56,39,128,28,95,151,68,67,79,245,138,27,171,172,185,60,193,43,24,47,44,22,133,51,192,33,91,235,206,106};
static const unsigned char precomputed_nG_montgomery25519_n_61[] = {156,66,77,180,174,107,233,12,184,58,46,61,64,98,183,92,16,219,71,111,27,51,188,248,186,186,102,180,73,56,13,192};
static const unsigned char precomputed_nG_montgomery25519_q_62[] = {8,65,6,229,48,237,228,7,186,78,20,76,185,115,71,216,3,174,43,115,161,223,182,143,26,77,223,136,88,179,28,15};
static const unsigned char precomputed_nG_montgomery25519_n_62[] = {126,105,113,222,138,197,147,2,78,6,164,71,89,108,88,171,66,1,135,129,235,20,23,71,23,196,77,202,214,125,157,175};
static const unsigned char precomputed_nG_montgomery25519_q_63[] = {97,202,213,1,93,35,63,31,114,140,174,116,11,159,132,134,43,215,202,227,193,252,196,226,200,189,101,97,25,250,52,110};
static const unsigned char precomputed_nG_montgomery25519_n_63[] = {210,1,39,43,213,4,113,52,209,168,194,36,183,83,208,113,96,24,160,90,15,173,111,2,218,216,204,35,245,82,131,100};
static const unsigned char precomputed_nG_montgomery25519_q_64[] = {144,90,151,40,70,230,158,150,37,254,76,138,189,139,90,226,169,139,212,188,116,43,13,72,178,251,51,114,187,178,133,105};
static const unsigned char precomputed_nG_montgomery25519_n_64[] = {26,133,164,74,34,10,213,241,118,228,228,196,85,9,45,2,27,221,132,101,239,21,197,32,148,26,6,122,61,238,33,109};
static const unsigned char precomputed_nG_montgomery25519_q_65[] = {10,188,206,205,136,173,60,128,77,197,17,231,223,211,230,220,17,104,1,218,62,134,163,191,85,109,102,124,51,150,122,56};
static const unsigned char precomputed_nG_montgomery25519_n_65[] = {24,77,11,250,21,9,26,2,228,106,203,113,113,8,205,27,52,212,75,253,88,90,98,94,225,3,17,117,52,37,118,8};
static const unsigned char precomputed_nG_montgomery25519_q_66[] = {208,24,51,144,1,211,11,51,209,140,140,180,150,71,16,72,255,82,76,63,254,109,43,14,72,89,12,117,77,196,221,112};
static const unsigned char precomputed_nG_montgomery25519_n_66[] = {143,172,134,214,84,140,49,228,174,156,78,179,61,77,91,228,144,247,118,134,122,129,186,68,152,25,181,254,25,239,203,173};
static const unsigned char precomputed_nG_montgomery25519_q_67[] = {50,40,208,33,127,78,209,52,163,161,65,165,100,201,185,211,194,83,220,236,171,131,64,9,243,32,91,219,61,241,131,20};
static const unsigned char precomputed_nG_montgomery25519_n_67[] = {219,123,41,215,52,53,170,77,222,109,52,73,25,99,9,198,56,1,84,246,138,208,150,1,142,15,66,240,6,89,57,84};
static const unsigned char precomputed_nG_montgomery25519_q_68[] = {255,255,52,23,148,8,10,129,27,228,21,242,65,164,23,127,138,187,31,100,178,128,195,40,228,149,121,155,207,184,181,12};
static const unsigned char precomputed_nG_montgomery25519_n_68[] = {204,171,34,245,66,116,196,142,227,179,177,211,221,118,54,247,140,254,82,214,0,116,156,233,213,182,128,73,40,197,46,135};
static const unsigned char precomputed_nG_montgomery25519_q_69[] = {169,10,50,75,199,215,160,218,225,10,166,49,42,98,157,131,106,197,113,14,21,16,69,162,127,31,115,83,26,50,220,44};
static const unsigned char precomputed_nG_montgomery25519_n_69[] = {61,124,30,206,44,119,58,162,88,242,155,6,244,255,208,58,104,217,249,227,171,95,17,220,83,192,221,148,164,122,8,64};
static const unsigned char precomputed_nG_montgomery25519_q_70[] = {33,128,135,172,244,183,44,121,229,229,30,190,63,226,46,39,242,3,248,58,154,233,198,50,245,4,78,235,192,222,16,116};
static const unsigned char precomputed_nG_montgomery25519_n_70[] = {11,222,99,51,38,46,245,94,147,100,179,51,147,230,162,113,17,37,165,101,252,247,185,36,144,73,114,123,22,194,214,45};
static const unsigned char precomputed_nG_montgomery25519_q_71[] = {144,75,112,204,177,170,103,101,100,245,2,231,54,239,231,165,204,193,16,59,117,199,192,107,107,218,95,48,56,38,110,59};
static const unsigned char precomputed_nG_montgomery25519_n_71[] = {0,109,134,77,20,214,239,230,93,78,150,182,114,48,60,49,182,164,80,57,127,100,123,26,249,117,119,77,10,164,16,174};
static const unsigned char precomputed_nG_montgomery25519_q_72[] = {236,116,148,250,53,204,255,155,189,174,49,31,227,4,199,185,208,101,4,144,61,99,214,209,250,189,47,68,87,244,255,119};
static const unsigned char precomputed_nG_montgomery25519_n_72[] = {190,52,77,80,59,196,250,15,154,113,245,213,86,255,155,2,170,204,185,85,136,183,10,194,90,223,247,17,165,194,113,185};
static const unsigned char precomputed_nG_montgomery25519_q_73[] = {190,179,239,119,211,163,178,156,228,21,15,252,208,25,41,206,154,89,209,161,71,3,248,190,218,248,185,156,20,160,126,76};
static const unsigned char precomputed_nG_montgomery25519_n_73[] = {115,106,3,157,86,134,12,145,213,31,164,99,232,92,120,54,207,172,141,117,138,12,49,213,173,20,82,175,80,110,119,181};
static const unsigned char precomputed_nG_montgomery25519_q_74[] = {151,247,57,97,74,63,212,198,121,181,59,203,196,23,78,158,248,155,40,115,225,235,68,103,24,145,186,35,48,255,78,29};
static const unsigned char precomputed_nG_montgomery25519_n_74[] = {75,105,208,239,69,92,1,44,88,234,160,169,110,27,102,193,137,141,31,119,244,190,62,149,23,253,114,138,166,219,233,12};
static const unsigned char precomputed_nG_montgomery25519_q_75[] = {91,88,13,142,88,152,119,94,151,178,38,105,65,203,224,246,198,72,71,98,229,32,31,51,217,79,138,34,198,58,179,70};
static const unsigned char precomputed_nG_montgomery25519_n_75[] = {25,4,206,72,111,144,216,129,151,243,187,122,192,98,90,152,226,21,218,134,198,164,40,4,78,212,53,34,231,49,235,93};
static const unsigned char precomputed_nG_montgomery25519_q_76[] = {113,242,158,115,21,159,155,180,109,128,161,142,51,244,151,129,226,247,98,58,15,136,15,211,29,232,125,88,18,156,4,87};
static const unsigned char precomputed_nG_montgomery25519_n_76[] = {130,177,74,203,203,9,147,135,150,55,71,149,91,175,112,194,97,100,29,255,151,202,137,159,32,238,169,17,105,195,248,204};
static const unsigned char precomputed_nG_montgomery25519_q_77[] = {59,136,166,195,70,104,62,128,52,248,9,234,7,194,70,131,203,213,54,0,194,151,73,250,173,41,5,68,170,108,31,97};
static const unsigned char precomputed_nG_montgomery25519_n_77[] = {26,139,84,222,73,164,95,200,197,246,159,238,232,197,100,177,248,155,162,245,92,148,69,65,182,152,102,102,144,175,66,166};
static const unsigned char precomputed_nG_montgomery25519_q_78[] = {202,17,137,96,105,114,181,212,253,36,207,127,122,175,226,141,188,173,58,232,56,248,91,180,241,125,166,251,235,85,42,112};
static const unsigned char precomputed_nG_montgomery25519_n_78[] = {114,164,45,29,139,80,49,60,106,107,60,128,63,120,253,179,193,56,108,162,227,252,98,109,0,25,202,38,28,138,44,27};
static const unsigned char precomputed_nG_montgomery25519_q_79[] = {170,194,130,44,72,120,74,92,93,148,117,38,246,71,92,140,114,84,251,163,98,26,115,180,126,160,230,40,229,122,74,88};
static const unsigned char precomputed_nG_montgomery25519_n_79[] = {140,255,196,225,13,181,102,161,58,158,219,87,108,13,233,160,85,170,107,238,165,112,3,40,204,223,33,176,135,137,131,231};
static const unsigned char precomputed_nG_montgomery25519_q_80[] = {37,181,156,223,73,148,255,25,225,127,31,176,26,136,85,198,118,20,104,38,18,215,103,66,160,33,238,135,14,72,65,85};
static const unsigned char precomputed_nG_montgomery25519_n_80[] = {89,164,46,121,146,172,87,140,34,168,132,6,230,49,237,159,96,92,236,101,47,59,64,29,206,188,61,248,197,236,69,167};
static const unsigned char precomputed_nG_montgomery25519_q_81[] = {31,131,56,113,246,52,240,82,43,199,215,249,193,40,111,135,237,109,39,35,12,11,42,67,129,73,56,188,52,215,185,88};
static const unsigned char precomputed_nG_montgomery25519_n_81[] = {15,224,104,161,59,86,211,32,209,58,171,165,234,218,86,47,130,95,28,62,155,193,166,66,168,42,126,13,43,240,89,217};
static const unsigned char precomputed_nG_montgomery25519_q_82[] = {169,156,99,85,216,243,253,94,165,4,157,157,50,105,112,162,106,23,170,55,67,80,69,166,131,249,157,9,223,46,95,107};
static const unsigned char precomputed_nG_montgomery25519_n_82[] = {91,21,41,161,17,32,132,81,220,123,110,142,13,121,29,181,216,173,254,249,123,99,54,191,199,98,8,201,237,129,121,229};
static const unsigned char precomputed_nG_montgomery25519_q_83[] = {70,37,114,73,84,70,104,61,216,163,160,43,161,16,125,139,33,44,118,108,80,0,40,14,175,183,38,130,96,78,152,39};
static const unsigned char precomputed_nG_montgomery25519_n_83[] = {119,175,107,233,214,49,15,33,34,240,165,131,124,172,88,165,151,21,231,192,33,212,143,125,164,32,251,55,215,88,94,173};
static const unsigned char precomputed_nG_montgomery25519_q_84[] = {169,247,83,137,121,24,61,102,195,157,195,159,35,145,47,183,46,246,87,52,6,96,168,129,208,74,198,116,5,100,41,21};
static const unsigned char precomputed_nG_montgomery25519_n_84[] = {45,185,247,101,62,178,115,117,40,137,19,3,52,214,247,56,98,107,124,152,151,34,77,254,14,218,87,71,38,70,109,201};
static const unsigned char precomputed_nG_montgomery25519_q_85[] = {244,201,218,228,24,195,67,76,89,84,36,108,125,251,247,27,12,181,242,88,132,116,255,121,142,33,45,179,14,63,74,45};
static const unsigned char precomputed_nG_montgomery25519_n_85[] = {212,148,110,55,200,16,191,27,144,170,216,245,122,143,77,52,2,173,111,97,150,226,50,250,255,202,251,217,158,10,214,176};
static const unsigned char precomputed_nG_montgomery25519_q_86[] = {235,42,62,230,239,101,137,17,210,137,216,226,83,83,199,183,46,85,55,18,144,218,212,187,11,229,21,108,58,2,154,16};
static const unsigned char precomputed_nG_montgomery25519_n_86[] = {83,109,4,217,251,38,255,79,150,202,155,27,23,235,50,83,71,46,95,204,190,1,133,105,176,96,36,185,100,100,219,160};
static const unsigned char precomputed_nG_montgomery25519_q_87[] = {115,196,14,7,223,5,34,5,145,161,211,231,159,143,233,118,19,24,78,249,104,215,51,54,88,168,226,120,163,227,155,38};
static const unsigned char precomputed_nG_montgomery25519_n_87[] = {220,73,255,236,98,106,71,217,120,72,104,95,145,59,95,228,172,211,130,57,153,25,136,142,244,43,208,201,7,59,127,82};
static const unsigned char precomputed_nG_montgomery25519_q_88[] = {115,253,197,120,56,153,69,26,253,71,74,213,1,23,182,13,27,7,160,241,108,64,86,196,241,157,106,63,59,102,83,70};
static const unsigned char precomputed_nG_montgomery25519_n_88[] = {101,45,94,226,67,86,209,9,52,17,7,240,188,142,33,206,171,161,24,172,81,96,131,173,95,1,190,230,66,32,127,37};
static const unsigned char precomputed_nG_montgomery25519_q_89[] = {166,74,198,146,147,49,106,142,62,179,216,242,183,55,52,108,245,246,139,38,110,64,8,26,208,107,9,188,81,47,146,68};
static const unsigned char precomputed_nG_montgomery25519_n_89[] = {139,29,203,36,46,99,179,5,84,125,7,126,231,205,84,116,96,255,175,78,138,28,127,170,191,60,163,92,81,71,35,141};
static const unsigned char precomputed_nG_montgomery25519_q_90[] = {56,254,54,251,73,9,106,208,32,93,47,47,184,0,187,3,250,206,159,119,108,28,207,205,6,107,79,126,117,212,229,104};
static const unsigned char precomputed_nG_montgomery25519_n_90[] = {218,129,65,22,37,94,131,101,35,110,15,119,83,245,240,48,244,186,36,142,53,245,35,180,236,233,183,22,106,235,36,246};
static const unsigned char precomputed_nG_montgomery25519_q_91[] = {42,113,184,14,22,84,226,141,134,22,150,26,253,241,96,135,90,28,222,1,178,62,150,181,184,105,88,129,174,162,148,31};
static const unsigned char precomputed_nG_montgomery25519_n_91[] = {134,239,139,12,40,148,217,177,8,124,217,162,184,125,47,135,143,189,125,245,99,46,131,92,130,250,53,108,244,194,45,133};
static const unsigned char precomputed_nG_montgomery25519_q_92[] = {99,65,125,140,163,100,187,220,51,93,151,14,223,124,138,182,211,85,220,102,72,111,151,161,197,39,207,150,74,161,195,72};
static const unsigned char precomputed_nG_montgomery25519_n_92[] = {230,3,148,40,241,93,220,142,10,240,184,111,118,170,205,217,252,224,208,159,65,35,156,179,246,174,57,32,65,59,60,236};
static const unsigned char precomputed_nG_montgomery25519_q_93[] = {248,127,161,232,101,239,115,61,149,169,29,53,123,150,212,49,199,212,35,26,112,56,50,56,38,192,228,150,254,103,189,37};
static const unsigned char precomputed_nG_montgomery25519_n_93[] = {123,179,56,107,13,69,146,119,8,144,192,54,27,20,55,8,83,79,44,187,149,68,160,184,173,31,244,171,70,41,131,106};
static const unsigned char precomputed_nG_montgomery25519_q_94[] = {65,117,211,12,216,225,143,146,33,92,96,43,220,234,33,87,126,58,103,77,161,160,102,185,241,215,210,159,17,71,11,5};
static const unsigned char precomputed_nG_montgomery25519_n_94[] = {134,128,185,138,206,221,239,252,160,115,159,34,206,174,143,34,93,127,60,193,12,198,66,6,163,192,30,205,168,82,170,178};
static const unsigned char precomputed_nG_montgomery25519_q_95[] = {221,57,1,167,72,124,145,106,61,123,89,250,26,224,11,219,121,16,207,132,86,104,47,8,29,126,69,51,110,83,43,27};
static const unsigned char precomputed_nG_montgomery25519_n_95[] = {139,0,60,75,217,43,90,39,138,78,41,105,11,51,18,195,181,67,4,2,160,54,244,203,125,170,229,99,68,44,246,50};
static const unsigned char precomputed_nG_montgomery25519_q_96[] = {136,160,227,119,24,213,77,220,29,148,198,247,252,173,61,88,71,207,43,69,129,84,18,236,191,3,122,36,144,171,75,20};
static const unsigned char precomputed_nG_montgomery25519_n_96[] = {130,119,54,17,101,169,43,173,142,182,170,201,18,38,139,248,159,4,19,116,61,37,18,196,236,194,38,233,123,175,78,46};
static const unsigned char precomputed_nG_montgomery25519_q_97[] = {39,176,114,157,15,77,195,47,98,46,154,106,101,97,186,245,113,93,10,243,11,51,126,171,222,29,36,172,254,185,16,107};
static const unsigned char precomputed_nG_montgomery25519_n_97[] = {203,223,42,236,165,214,194,133,186,90,243,232,20,65,51,85,124,253,59,176,226,143,40,176,27,56,128,97,229,157,203,62};
static const unsigned char precomputed_nG_montgomery25519_q_98[] = {4,112,186,26,73,115,35,109,244,30,18,239,197,25,210,206,205,96,194,179,248,102,154,82,203,230,30,234,127,20,47,124};
static const unsigned char precomputed_nG_montgomery25519_n_98[] = {233,83,35,64,153,97,121,198,109,141,67,100,71,202,244,103,185,53,218,170,171,201,115,137,228,128,154,136,5,207,1,237};
static const unsigned char precomputed_nG_montgomery25519_q_99[] = {247,1,180,237,7,35,235,55,91,30,219,255,215,219,252,149,109,218,104,100,69,236,67,247,154,161,81,88,69,65,32,118};
static const unsigned char precomputed_nG_montgomery25519_n_99[] = {70,227,81,151,194,81,152,39,109,58,72,118,146,53,147,99,166,243,65,97,127,11,103,218,15,58,248,94,80,141,219,179};
static const unsigned char precomputed_nG_montgomery25519_q_100[] = {90,21,64,11,37,11,141,49,46,74,98,219,243,147,68,174,67,63,55,239,169,24,90,91,169,140,138,183,205,46,99,16};
static const unsigned char precomputed_nG_montgomery25519_n_100[] = {176,126,237,81,102,102,132,124,198,161,76,34,206,83,37,206,222,67,114,153,232,1,251,175,144,138,7,199,201,115,7,28};
static const unsigned char precomputed_nG_montgomery25519_q_101[] = {82,74,202,211,226,26,97,34,75,225,54,117,19,142,96,216,218,114,149,24,159,148,129,161,240,127,243,22,171,202,34,125};
static const unsigned char precomputed_nG_montgomery25519_n_101[] = {8,139,80,129,28,92,227,252,104,99,17,50,65,187,193,22,212,206,170,208,43,233,87,99,27,150,116,7,208,93,145,84};
static const unsigned char precomputed_nG_montgomery25519_q_102[] = {190,106,244,14,253,44,237,59,19,182,46,49,42,4,13,23,206,21,53,123,219,92,219,72,189,254,12,254,222,163,139,112};
static const unsigned char precomputed_nG_montgomery25519_n_102[] = {29,177,188,135,13,64,192,142,201,69,250,152,30,173,54,236,59,99,15,242,142,72,189,22,157,126,27,244,31,52,167,177};
static const unsigned char precomputed_nG_montgomery25519_q_103[] = {11,192,78,123,179,201,109,66,134,214,78,204,16,96,195,16,175,13,246,229,141,108,82,77,67,243,128,121,82,195,16,43};
static const unsigned char precomputed_nG_montgomery25519_n_103[] = {106,62,139,211,234,205,169,252,229,42,19,207,121,246,194,120,167,15,115,166,20,223,32,104,216,154,194,95,131,167,36,197};
static const unsigned char precomputed_nG_montgomery25519_q_104[] = {59,19,185,127,46,16,161,64,111,171,136,138,68,224,35,109,105,28,245,243,51,65,0,166,142,105,203,98,99,113,14,78};
static const unsigned char precomputed_nG_montgomery25519_n_104[] = {87,95,6,48,16,178,73,234,28,200,209,171,227,63,109,129,57,214,223,106,131,249,240,73,116,200,157,242,240,42,76,162};
static const unsigned char precomputed_nG_montgomery25519_q_105[] = {126,41,246,11,112,28,100,230,194,136,26,88,211,173,236,33,44,41,106,174,67,215,91,37,46,49,215,16,209,95,196,8};
static const unsigned char precomputed_nG_montgomery25519_n_105[] = {204,15,228,131,156,185,61,161,152,150,67,113,68,53,243,62,24,216,129,171,30,11,31,102,248,59,127,142,161,57,80,215};
static const unsigned char precomputed_nG_montgomery25519_q_106[] = {218,219,136,245,228,2,203,64,153,42,104,191,33,82,145,64,77,113,118,66,59,175,113,230,17,39,108,240,48,135,218,5};
static const unsigned char precomputed_nG_montgomery25519_n_106[] = {55,138,52,244,26,64,233,55,219,89,73,81,174,126,193,63,206,82,174,123,74,198,156,229,224,10,38,108,77,120,157,26};
static const unsigned char precomputed_nG_montgomery25519_q_107[] = {215,252,67,88,250,76,235,146,160,67,132,180,99,166,125,255,236,116,0,120,234,205,110,20,121,207,98,60,13,181,143,4};
static const unsigned char precomputed_nG_montgomery25519_n_107[] = {85,137,204,48,130,249,234,35,89,233,48,221,53,243,96,97,211,18,211,45,21,98,234,221,177,119,203,170,210,44,229,164};
static const unsigned char precomputed_nG_montgomery25519_q_108[] = {177,225,217,188,205,185,112,112,6,225,160,156,86,13,239,157,124,31,215,163,40,199,131,58,85,193,231,193,206,186,98,77};
static const unsigned char precomputed_nG_montgomery25519_n_108[] = {56,252,57,128,138,57,148,28,83,174,202,88,98,17,163,34,82,26,247,112,162,64,192,167,231,8,189,28,156,29,188,251};
static const unsigned char precomputed_nG_montgomery25519_q_109[] = {217,169,80,55,17,90,153,11,148,47,211,56,65,144,161,138,66,5,206,212,207,66,115,159,107,113,126,238,3,82,214,54};
static const unsigned char precomputed_nG_montgomery25519_n_109[] = {112,121,57,107,72,182,104,221,176,75,223,205,42,214,83,163,255,49,31,102,204,116,167,237,242,106,100,110,205,135,219,89};
static const unsigned char precomputed_nG_montgomery25519_q_110[] = {106,232,125,67,140,243,175,7,29,77,204,9,36,222,19,112,33,80,108,118,175,181,57,13,53,82,180,200,198,104,114,100};
static const unsigned char precomputed_nG_montgomery25519_n_110[] = {44,125,194,131,141,28,85,153,189,124,131,6,215,148,12,146,101,154,22,73,139,185,118,218,137,216,101,196,127,218,186,94};
static const unsigned char precomputed_nG_montgomery25519_q_111[] = {25,167,166,42,250,60,154,221,179,53,153,104,130,229,157,17,231,241,201,107,57,106,224,96,242,13,148,59,97,220,153,42};
static const unsigned char precomputed_nG_montgomery25519_n_111[] = {51,130,62,172,209,36,41,161,29,1,87,181,150,163,126,169,188,192,128,188,163,6,47,152,40,145,201,170,93,219,137,176};
static const unsigned char precomputed_nG_montgomery25519_q_112[] = {68,33,236,124,237,226,8,150,133,116,178,140,238,225,215,179,52,244,84,146,197,55,48,62,196,98,118,86,18,69,78,109};
static const unsigned char precomputed_nG_montgomery25519_n_112[] = {117,39,80,87,195,165,184,217,135,17,153,93,117,67,4,42,11,71,238,32,18,163,25,219,224,124,157,18,124,177,88,48};
static const unsigned char precomputed_nG_montgomery25519_q_113[] = {33,37,129,47,133,98,239,169,189,200,141,166,43,22,238,225,172,247,225,218,173,149,150,77,179,73,52,25,216,221,41,3};
static const unsigned char precomputed_nG_montgomery25519_n_113[] = {99,161,20,181,199,241,107,128,91,222,223,174,253,195,200,117,10,189,188,0,149,112,34,159,91,220,244,190,164,50,47,91};
static const unsigned char precomputed_nG_montgomery25519_q_114[] = {215,39,57,114,185,6,106,47,249,244,241,228,115,218,5,72,202,54,192,107,229,202,220,157,233,113,60,93,190,49,132,127};
static const unsigned char precomputed_nG_montgomery25519_n_114[] = {129,131,164,9,1,35,50,200,135,132,250,64,150,121,41,247,33,174,51,108,194,47,111,153,203,98,177,70,155,227,121,56};
static const unsigned char precomputed_nG_montgomery25519_q_115[] = {4,160,84,26,135,171,173,252,81,216,123,198,123,183,81,98,69,205,244,47,30,1,131,217,10,22,97,41,89,219,154,42};
static const unsigned char precomputed_nG_montgomery25519_n_115[] = {74,193,132,93,153,229,221,132,20,175,212,87,254,121,113,97,254,58,26,58,211,44,26,123,29,223,66,16,103,248,71,41};
static const unsigned char precomputed_nG_montgomery25519_q_116[] = {134,187,23,244,110,88,203,14,172,152,244,161,178,203,137,72,214,92,117,231,113,66,108,33,14,122,4,43,30,153,41,58};
static const unsigned char precomputed_nG_montgomery25519_n_116[] = {115,254,100,139,60,197,181,208,22,157,181,82,59,72,36,58,212,9,46,184,187,159,233,153,4,128,243,94,6,94,131,242};
static const unsigned char precomputed_nG_montgomery25519_q_117[] = {109,131,103,194,88,121,106,20,61,194,0,112,7,219,194,121,205,239,137,238,145,227,176,145,116,169,132,110,222,186,25,13};
static const unsigned char precomputed_nG_montgomery25519_n_117[] = {219,73,229,221,188,105,135,94,153,141,144,222,123,209,184,245,88,225,11,205,31,170,143,55,8,119,4,13,98,20,122,168};
static const unsigned char precomputed_nG_montgomery25519_q_118[] = {204,41,112,129,220,87,8,115,81,70,91,107,192,66,116,55,79,98,37,51,156,120,70,3,43,144,95,139,52,48,224,41};
static const unsigned char precomputed_nG_montgomery25519_n_118[] = {196,193,187,93,241,121,11,47,90,122,60,236,194,215,109,163,178,7,61,147,65,26,117,3,164,2,158,146,36,119,32,60};
static const unsigned char precomputed_nG_montgomery25519_q_119[] = {134,162,134,212,176,129,0,175,152,87,105,13,210,170,183,174,181,214,22,255,166,217,245,17,157,178,60,67,182,213,243,81};
static const unsigned char precomputed_nG_montgomery25519_n_119[] = {227,222,100,66,28,246,173,249,53,149,213,37,185,54,69,163,16,250,185,224,102,146,4,98,179,194,53,222,8,220,97,123};
static const unsigned char precomputed_nG_montgomery25519_q_120[] = {163,57,72,14,105,41,25,105,33,251,68,189,186,30,95,182,210,48,26,251,148,236,40,94,236,6,100,46,116,13,102,73};
static const unsigned char precomputed_nG_montgomery25519_n_120[] = {209,99,147,114,75,237,209,1,229,15,127,18,235,119,0,211,147,124,173,121,62,141,17,8,76,143,7,103,226,214,166,146};
static const unsigned char precomputed_nG_montgomery25519_q_121[] = {231,214,186,185,132,85,228,182,28,78,168,61,112,205,229,145,139,97,178,236,91,120,171,153,29,24,190,249,110,159,96,14};
static const unsigned char precomputed_nG_montgomery25519_n_121[] = {103,224,148,94,155,129,179,251,105,250,220,47,46,139,24,183,209,66,113,59,131,78,182,20,165,48,145,219,12,96,248,18};
static const unsigned char precomputed_nG_montgomery25519_q_122[] = {18,2,183,113,150,221,15,140,218,124,112,103,112,27,4,89,12,253,76,44,209,86,249,235,77,10,204,164,190,77,237,10};
static const unsigned char precomputed_nG_montgomery25519_n_122[] = {208,4,251,158,62,204,198,242,117,188,234,88,248,175,49,90,172,113,94,200,25,91,3,16,43,140,111,76,171,161,135,4};
static const unsigned char precomputed_nG_montgomery25519_q_123[] = {248,99,147,125,98,129,78,142,57,115,131,11,241,197,240,182,57,193,94,193,14,11,136,122,72,116,247,254,53,232,184,73};
static const unsigned char precomputed_nG_montgomery25519_n_123[] = {126,74,143,250,221,41,169,175,238,249,166,84,124,36,25,221,221,106,160,39,213,160,65,1,220,177,253,54,123,209,136,144};
static const unsigned char precomputed_nG_montgomery25519_q_124[] = {103,102,33,65,143,34,247,169,101,62,153,147,175,173,107,164,123,7,10,12,57,84,221,14,208,230,35,240,80,156,123,102};
static const unsigned char precomputed_nG_montgomery25519_n_124[] = {143,57,128,178,242,8,119,32,25,176,50,115,223,118,164,211,113,228,56,213,248,18,237,148,101,184,118,9,25,46,43,44};
static const unsigned char precomputed_nG_montgomery25519_q_125[] = {131,46,70,237,163,138,5,131,9,132,240,153,214,179,149,218,22,99,31,46,136,7,28,80,213,71,143,234,132,201,142,32};
static const unsigned char precomputed_nG_montgomery25519_n_125[] = {245,122,67,58,179,139,166,104,97,201,74,88,230,100,106,82,94,69,97,82,95,158,166,80,96,136,166,26,117,220,136,213};
static const unsigned char precomputed_nG_montgomery25519_q_126[] = {18,236,254,203,182,30,41,246,109,110,144,221,12,121,3,75,88,133,20,228,205,237,237,21,179,34,177,40,34,171,125,37};
static const unsigned char precomputed_nG_montgomery25519_n_126[] = {177,1,54,227,31,2,70,177,148,115,178,232,34,44,225,90,104,138,115,154,32,57,48,20,168,164,0,83,173,234,42,97};
static const unsigned char precomputed_nG_montgomery25519_q_127[] = {164,246,166,99,198,192,139,239,233,157,116,118,18,84,11,82,8,253,193,169,18,215,22,128,96,174,105,202,219,183,140,17};
static const unsigned char precomputed_nG_montgomery25519_n_127[] = {127,247,155,26,58,240,193,235,103,31,209,206,83,124,54,240,122,240,31,168,185,104,161,158,250,17,202,252,121,120,91,1};
static const unsigned char precomputed_nG_montgomery25519_q_128[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_128[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_q_129[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_129[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_montgomery25519_q_130[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_130[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_q_131[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_131[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_montgomery25519_q_132[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_132[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_q_133[] = {47,229,125,163,71,205,98,67,21,40,218,172,95,187,41,7,48,255,246,132,175,196,207,194,237,144,153,95,88,203,59,116};
static const unsigned char precomputed_nG_montgomery25519_n_133[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_nG_montgomery25519_q_134[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_134[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_135[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_135[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_136[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_136[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_137[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_137[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_138[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_138[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_139[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_139[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_140[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_140[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_141[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_141[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_142[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_142[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_nG_montgomery25519_q_143[] = {195,166,48,25,132,99,114,14,28,223,119,38,243,122,231,159,191,27,92,243,17,18,22,201,77,251,14,81,224,73,208,113};
static const unsigned char precomputed_nG_montgomery25519_n_143[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_nG_montgomery25519_q_144[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_144[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_145[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_145[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_146[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_146[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_147[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_147[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_148[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_148[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_149[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_149[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_150[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_150[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_151[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_151[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_152[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_152[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_nG_montgomery25519_q_153[] = {58,19,199,99,205,16,241,198,49,144,137,227,220,29,92,41,147,79,255,160,161,146,18,67,210,38,76,113,3,191,249,11};
static const unsigned char precomputed_nG_montgomery25519_n_153[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_nG_montgomery25519_q_154[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_154[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_155[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_155[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_156[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_156[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_157[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_157[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_158[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_158[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_159[] = {129,96,75,13,134,130,203,253,136,159,23,146,238,55,240,99,36,115,117,88,2,108,40,255,68,207,86,174,255,137,20,91};
static const unsigned char precomputed_nG_montgomery25519_n_159[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_160[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_160[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_161[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_161[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_162[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_162[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_nG_montgomery25519_q_163[] = {41,204,100,115,229,19,170,59,195,143,92,9,18,123,202,155,144,96,108,128,22,254,48,177,149,5,166,70,76,3,74,5};
static const unsigned char precomputed_nG_montgomery25519_n_163[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_nG_montgomery25519_q_164[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_164[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_165[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_165[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_166[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_166[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_167[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_167[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_168[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_168[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_169[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_169[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_170[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_170[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_171[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_171[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_172[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_172[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_nG_montgomery25519_q_173[] = {239,19,0,85,228,133,238,15,35,42,93,205,223,5,24,254,95,49,91,161,116,208,209,231,125,157,104,224,183,152,206,121};
static const unsigned char precomputed_nG_montgomery25519_n_173[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_nG_montgomery25519_q_174[] = {186,100,129,102,128,121,51,14,111,124,248,226,230,194,177,153,116,171,27,164,13,96,68,219,72,119,208,151,145,146,43,25};
static const unsigned char precomputed_nG_montgomery25519_n_174[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_175[] = {186,100,129,102,128,121,51,14,111,124,248,226,230,194,177,153,116,171,27,164,13,96,68,219,72,119,208,151,145,146,43,25};
static const unsigned char precomputed_nG_montgomery25519_n_175[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_176[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_176[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_177[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_177[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_178[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_178[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_179[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_179[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_180[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_180[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_181[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_181[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_182[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_182[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_nG_montgomery25519_q_183[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_nG_montgomery25519_n_183[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_nG_montgomery25519_q_184[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_184[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_185[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_185[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_186[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_186[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_187[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_187[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_188[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_188[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_189[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_189[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_190[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_190[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_191[] = {49,69,121,140,250,11,254,249,40,76,73,64,54,199,254,133,6,8,187,230,229,221,241,248,52,191,158,201,205,76,149,38};
static const unsigned char precomputed_nG_montgomery25519_n_191[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_192[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_montgomery25519_n_192[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_nG_montgomery25519_q_193[] = {251,78,104,221,156,70,174,92,92,11,53,30,237,92,63,143,20,113,21,125,104,12,117,217,183,241,115,24,213,66,211,32};
static const unsigned char precomputed_nG_montgomery25519_n_193[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_nG_montgomery25519_q_194[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_194[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_195[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_195[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_196[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_196[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_197[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_197[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_198[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_198[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_199[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_199[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_200[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_200[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_201[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_201[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_nG_montgomery25519_q_202[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_202[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_nG_montgomery25519_q_203[] = {18,60,113,251,175,3,10,192,89,8,28,98,103,78,130,248,100,186,27,194,145,77,83,69,230,171,87,109,26,188,18,28};
static const unsigned char precomputed_nG_montgomery25519_n_203[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *n;
  long long nsize;
} precomputed_nG_montgomery25519[precomputed_nG_montgomery25519_NUM] = {
  {
    precomputed_nG_montgomery25519_q_0,32,
    precomputed_nG_montgomery25519_n_0,32,
  },
  {
    precomputed_nG_montgomery25519_q_1,32,
    precomputed_nG_montgomery25519_n_1,32,
  },
  {
    precomputed_nG_montgomery25519_q_2,32,
    precomputed_nG_montgomery25519_n_2,32,
  },
  {
    precomputed_nG_montgomery25519_q_3,32,
    precomputed_nG_montgomery25519_n_3,32,
  },
  {
    precomputed_nG_montgomery25519_q_4,32,
    precomputed_nG_montgomery25519_n_4,32,
  },
  {
    precomputed_nG_montgomery25519_q_5,32,
    precomputed_nG_montgomery25519_n_5,32,
  },
  {
    precomputed_nG_montgomery25519_q_6,32,
    precomputed_nG_montgomery25519_n_6,32,
  },
  {
    precomputed_nG_montgomery25519_q_7,32,
    precomputed_nG_montgomery25519_n_7,32,
  },
  {
    precomputed_nG_montgomery25519_q_8,32,
    precomputed_nG_montgomery25519_n_8,32,
  },
  {
    precomputed_nG_montgomery25519_q_9,32,
    precomputed_nG_montgomery25519_n_9,32,
  },
  {
    precomputed_nG_montgomery25519_q_10,32,
    precomputed_nG_montgomery25519_n_10,32,
  },
  {
    precomputed_nG_montgomery25519_q_11,32,
    precomputed_nG_montgomery25519_n_11,32,
  },
  {
    precomputed_nG_montgomery25519_q_12,32,
    precomputed_nG_montgomery25519_n_12,32,
  },
  {
    precomputed_nG_montgomery25519_q_13,32,
    precomputed_nG_montgomery25519_n_13,32,
  },
  {
    precomputed_nG_montgomery25519_q_14,32,
    precomputed_nG_montgomery25519_n_14,32,
  },
  {
    precomputed_nG_montgomery25519_q_15,32,
    precomputed_nG_montgomery25519_n_15,32,
  },
  {
    precomputed_nG_montgomery25519_q_16,32,
    precomputed_nG_montgomery25519_n_16,32,
  },
  {
    precomputed_nG_montgomery25519_q_17,32,
    precomputed_nG_montgomery25519_n_17,32,
  },
  {
    precomputed_nG_montgomery25519_q_18,32,
    precomputed_nG_montgomery25519_n_18,32,
  },
  {
    precomputed_nG_montgomery25519_q_19,32,
    precomputed_nG_montgomery25519_n_19,32,
  },
  {
    precomputed_nG_montgomery25519_q_20,32,
    precomputed_nG_montgomery25519_n_20,32,
  },
  {
    precomputed_nG_montgomery25519_q_21,32,
    precomputed_nG_montgomery25519_n_21,32,
  },
  {
    precomputed_nG_montgomery25519_q_22,32,
    precomputed_nG_montgomery25519_n_22,32,
  },
  {
    precomputed_nG_montgomery25519_q_23,32,
    precomputed_nG_montgomery25519_n_23,32,
  },
  {
    precomputed_nG_montgomery25519_q_24,32,
    precomputed_nG_montgomery25519_n_24,32,
  },
  {
    precomputed_nG_montgomery25519_q_25,32,
    precomputed_nG_montgomery25519_n_25,32,
  },
  {
    precomputed_nG_montgomery25519_q_26,32,
    precomputed_nG_montgomery25519_n_26,32,
  },
  {
    precomputed_nG_montgomery25519_q_27,32,
    precomputed_nG_montgomery25519_n_27,32,
  },
  {
    precomputed_nG_montgomery25519_q_28,32,
    precomputed_nG_montgomery25519_n_28,32,
  },
  {
    precomputed_nG_montgomery25519_q_29,32,
    precomputed_nG_montgomery25519_n_29,32,
  },
  {
    precomputed_nG_montgomery25519_q_30,32,
    precomputed_nG_montgomery25519_n_30,32,
  },
  {
    precomputed_nG_montgomery25519_q_31,32,
    precomputed_nG_montgomery25519_n_31,32,
  },
  {
    precomputed_nG_montgomery25519_q_32,32,
    precomputed_nG_montgomery25519_n_32,32,
  },
  {
    precomputed_nG_montgomery25519_q_33,32,
    precomputed_nG_montgomery25519_n_33,32,
  },
  {
    precomputed_nG_montgomery25519_q_34,32,
    precomputed_nG_montgomery25519_n_34,32,
  },
  {
    precomputed_nG_montgomery25519_q_35,32,
    precomputed_nG_montgomery25519_n_35,32,
  },
  {
    precomputed_nG_montgomery25519_q_36,32,
    precomputed_nG_montgomery25519_n_36,32,
  },
  {
    precomputed_nG_montgomery25519_q_37,32,
    precomputed_nG_montgomery25519_n_37,32,
  },
  {
    precomputed_nG_montgomery25519_q_38,32,
    precomputed_nG_montgomery25519_n_38,32,
  },
  {
    precomputed_nG_montgomery25519_q_39,32,
    precomputed_nG_montgomery25519_n_39,32,
  },
  {
    precomputed_nG_montgomery25519_q_40,32,
    precomputed_nG_montgomery25519_n_40,32,
  },
  {
    precomputed_nG_montgomery25519_q_41,32,
    precomputed_nG_montgomery25519_n_41,32,
  },
  {
    precomputed_nG_montgomery25519_q_42,32,
    precomputed_nG_montgomery25519_n_42,32,
  },
  {
    precomputed_nG_montgomery25519_q_43,32,
    precomputed_nG_montgomery25519_n_43,32,
  },
  {
    precomputed_nG_montgomery25519_q_44,32,
    precomputed_nG_montgomery25519_n_44,32,
  },
  {
    precomputed_nG_montgomery25519_q_45,32,
    precomputed_nG_montgomery25519_n_45,32,
  },
  {
    precomputed_nG_montgomery25519_q_46,32,
    precomputed_nG_montgomery25519_n_46,32,
  },
  {
    precomputed_nG_montgomery25519_q_47,32,
    precomputed_nG_montgomery25519_n_47,32,
  },
  {
    precomputed_nG_montgomery25519_q_48,32,
    precomputed_nG_montgomery25519_n_48,32,
  },
  {
    precomputed_nG_montgomery25519_q_49,32,
    precomputed_nG_montgomery25519_n_49,32,
  },
  {
    precomputed_nG_montgomery25519_q_50,32,
    precomputed_nG_montgomery25519_n_50,32,
  },
  {
    precomputed_nG_montgomery25519_q_51,32,
    precomputed_nG_montgomery25519_n_51,32,
  },
  {
    precomputed_nG_montgomery25519_q_52,32,
    precomputed_nG_montgomery25519_n_52,32,
  },
  {
    precomputed_nG_montgomery25519_q_53,32,
    precomputed_nG_montgomery25519_n_53,32,
  },
  {
    precomputed_nG_montgomery25519_q_54,32,
    precomputed_nG_montgomery25519_n_54,32,
  },
  {
    precomputed_nG_montgomery25519_q_55,32,
    precomputed_nG_montgomery25519_n_55,32,
  },
  {
    precomputed_nG_montgomery25519_q_56,32,
    precomputed_nG_montgomery25519_n_56,32,
  },
  {
    precomputed_nG_montgomery25519_q_57,32,
    precomputed_nG_montgomery25519_n_57,32,
  },
  {
    precomputed_nG_montgomery25519_q_58,32,
    precomputed_nG_montgomery25519_n_58,32,
  },
  {
    precomputed_nG_montgomery25519_q_59,32,
    precomputed_nG_montgomery25519_n_59,32,
  },
  {
    precomputed_nG_montgomery25519_q_60,32,
    precomputed_nG_montgomery25519_n_60,32,
  },
  {
    precomputed_nG_montgomery25519_q_61,32,
    precomputed_nG_montgomery25519_n_61,32,
  },
  {
    precomputed_nG_montgomery25519_q_62,32,
    precomputed_nG_montgomery25519_n_62,32,
  },
  {
    precomputed_nG_montgomery25519_q_63,32,
    precomputed_nG_montgomery25519_n_63,32,
  },
  {
    precomputed_nG_montgomery25519_q_64,32,
    precomputed_nG_montgomery25519_n_64,32,
  },
  {
    precomputed_nG_montgomery25519_q_65,32,
    precomputed_nG_montgomery25519_n_65,32,
  },
  {
    precomputed_nG_montgomery25519_q_66,32,
    precomputed_nG_montgomery25519_n_66,32,
  },
  {
    precomputed_nG_montgomery25519_q_67,32,
    precomputed_nG_montgomery25519_n_67,32,
  },
  {
    precomputed_nG_montgomery25519_q_68,32,
    precomputed_nG_montgomery25519_n_68,32,
  },
  {
    precomputed_nG_montgomery25519_q_69,32,
    precomputed_nG_montgomery25519_n_69,32,
  },
  {
    precomputed_nG_montgomery25519_q_70,32,
    precomputed_nG_montgomery25519_n_70,32,
  },
  {
    precomputed_nG_montgomery25519_q_71,32,
    precomputed_nG_montgomery25519_n_71,32,
  },
  {
    precomputed_nG_montgomery25519_q_72,32,
    precomputed_nG_montgomery25519_n_72,32,
  },
  {
    precomputed_nG_montgomery25519_q_73,32,
    precomputed_nG_montgomery25519_n_73,32,
  },
  {
    precomputed_nG_montgomery25519_q_74,32,
    precomputed_nG_montgomery25519_n_74,32,
  },
  {
    precomputed_nG_montgomery25519_q_75,32,
    precomputed_nG_montgomery25519_n_75,32,
  },
  {
    precomputed_nG_montgomery25519_q_76,32,
    precomputed_nG_montgomery25519_n_76,32,
  },
  {
    precomputed_nG_montgomery25519_q_77,32,
    precomputed_nG_montgomery25519_n_77,32,
  },
  {
    precomputed_nG_montgomery25519_q_78,32,
    precomputed_nG_montgomery25519_n_78,32,
  },
  {
    precomputed_nG_montgomery25519_q_79,32,
    precomputed_nG_montgomery25519_n_79,32,
  },
  {
    precomputed_nG_montgomery25519_q_80,32,
    precomputed_nG_montgomery25519_n_80,32,
  },
  {
    precomputed_nG_montgomery25519_q_81,32,
    precomputed_nG_montgomery25519_n_81,32,
  },
  {
    precomputed_nG_montgomery25519_q_82,32,
    precomputed_nG_montgomery25519_n_82,32,
  },
  {
    precomputed_nG_montgomery25519_q_83,32,
    precomputed_nG_montgomery25519_n_83,32,
  },
  {
    precomputed_nG_montgomery25519_q_84,32,
    precomputed_nG_montgomery25519_n_84,32,
  },
  {
    precomputed_nG_montgomery25519_q_85,32,
    precomputed_nG_montgomery25519_n_85,32,
  },
  {
    precomputed_nG_montgomery25519_q_86,32,
    precomputed_nG_montgomery25519_n_86,32,
  },
  {
    precomputed_nG_montgomery25519_q_87,32,
    precomputed_nG_montgomery25519_n_87,32,
  },
  {
    precomputed_nG_montgomery25519_q_88,32,
    precomputed_nG_montgomery25519_n_88,32,
  },
  {
    precomputed_nG_montgomery25519_q_89,32,
    precomputed_nG_montgomery25519_n_89,32,
  },
  {
    precomputed_nG_montgomery25519_q_90,32,
    precomputed_nG_montgomery25519_n_90,32,
  },
  {
    precomputed_nG_montgomery25519_q_91,32,
    precomputed_nG_montgomery25519_n_91,32,
  },
  {
    precomputed_nG_montgomery25519_q_92,32,
    precomputed_nG_montgomery25519_n_92,32,
  },
  {
    precomputed_nG_montgomery25519_q_93,32,
    precomputed_nG_montgomery25519_n_93,32,
  },
  {
    precomputed_nG_montgomery25519_q_94,32,
    precomputed_nG_montgomery25519_n_94,32,
  },
  {
    precomputed_nG_montgomery25519_q_95,32,
    precomputed_nG_montgomery25519_n_95,32,
  },
  {
    precomputed_nG_montgomery25519_q_96,32,
    precomputed_nG_montgomery25519_n_96,32,
  },
  {
    precomputed_nG_montgomery25519_q_97,32,
    precomputed_nG_montgomery25519_n_97,32,
  },
  {
    precomputed_nG_montgomery25519_q_98,32,
    precomputed_nG_montgomery25519_n_98,32,
  },
  {
    precomputed_nG_montgomery25519_q_99,32,
    precomputed_nG_montgomery25519_n_99,32,
  },
  {
    precomputed_nG_montgomery25519_q_100,32,
    precomputed_nG_montgomery25519_n_100,32,
  },
  {
    precomputed_nG_montgomery25519_q_101,32,
    precomputed_nG_montgomery25519_n_101,32,
  },
  {
    precomputed_nG_montgomery25519_q_102,32,
    precomputed_nG_montgomery25519_n_102,32,
  },
  {
    precomputed_nG_montgomery25519_q_103,32,
    precomputed_nG_montgomery25519_n_103,32,
  },
  {
    precomputed_nG_montgomery25519_q_104,32,
    precomputed_nG_montgomery25519_n_104,32,
  },
  {
    precomputed_nG_montgomery25519_q_105,32,
    precomputed_nG_montgomery25519_n_105,32,
  },
  {
    precomputed_nG_montgomery25519_q_106,32,
    precomputed_nG_montgomery25519_n_106,32,
  },
  {
    precomputed_nG_montgomery25519_q_107,32,
    precomputed_nG_montgomery25519_n_107,32,
  },
  {
    precomputed_nG_montgomery25519_q_108,32,
    precomputed_nG_montgomery25519_n_108,32,
  },
  {
    precomputed_nG_montgomery25519_q_109,32,
    precomputed_nG_montgomery25519_n_109,32,
  },
  {
    precomputed_nG_montgomery25519_q_110,32,
    precomputed_nG_montgomery25519_n_110,32,
  },
  {
    precomputed_nG_montgomery25519_q_111,32,
    precomputed_nG_montgomery25519_n_111,32,
  },
  {
    precomputed_nG_montgomery25519_q_112,32,
    precomputed_nG_montgomery25519_n_112,32,
  },
  {
    precomputed_nG_montgomery25519_q_113,32,
    precomputed_nG_montgomery25519_n_113,32,
  },
  {
    precomputed_nG_montgomery25519_q_114,32,
    precomputed_nG_montgomery25519_n_114,32,
  },
  {
    precomputed_nG_montgomery25519_q_115,32,
    precomputed_nG_montgomery25519_n_115,32,
  },
  {
    precomputed_nG_montgomery25519_q_116,32,
    precomputed_nG_montgomery25519_n_116,32,
  },
  {
    precomputed_nG_montgomery25519_q_117,32,
    precomputed_nG_montgomery25519_n_117,32,
  },
  {
    precomputed_nG_montgomery25519_q_118,32,
    precomputed_nG_montgomery25519_n_118,32,
  },
  {
    precomputed_nG_montgomery25519_q_119,32,
    precomputed_nG_montgomery25519_n_119,32,
  },
  {
    precomputed_nG_montgomery25519_q_120,32,
    precomputed_nG_montgomery25519_n_120,32,
  },
  {
    precomputed_nG_montgomery25519_q_121,32,
    precomputed_nG_montgomery25519_n_121,32,
  },
  {
    precomputed_nG_montgomery25519_q_122,32,
    precomputed_nG_montgomery25519_n_122,32,
  },
  {
    precomputed_nG_montgomery25519_q_123,32,
    precomputed_nG_montgomery25519_n_123,32,
  },
  {
    precomputed_nG_montgomery25519_q_124,32,
    precomputed_nG_montgomery25519_n_124,32,
  },
  {
    precomputed_nG_montgomery25519_q_125,32,
    precomputed_nG_montgomery25519_n_125,32,
  },
  {
    precomputed_nG_montgomery25519_q_126,32,
    precomputed_nG_montgomery25519_n_126,32,
  },
  {
    precomputed_nG_montgomery25519_q_127,32,
    precomputed_nG_montgomery25519_n_127,32,
  },
  {
    precomputed_nG_montgomery25519_q_128,32,
    precomputed_nG_montgomery25519_n_128,32,
  },
  {
    precomputed_nG_montgomery25519_q_129,32,
    precomputed_nG_montgomery25519_n_129,32,
  },
  {
    precomputed_nG_montgomery25519_q_130,32,
    precomputed_nG_montgomery25519_n_130,32,
  },
  {
    precomputed_nG_montgomery25519_q_131,32,
    precomputed_nG_montgomery25519_n_131,32,
  },
  {
    precomputed_nG_montgomery25519_q_132,32,
    precomputed_nG_montgomery25519_n_132,32,
  },
  {
    precomputed_nG_montgomery25519_q_133,32,
    precomputed_nG_montgomery25519_n_133,32,
  },
  {
    precomputed_nG_montgomery25519_q_134,32,
    precomputed_nG_montgomery25519_n_134,32,
  },
  {
    precomputed_nG_montgomery25519_q_135,32,
    precomputed_nG_montgomery25519_n_135,32,
  },
  {
    precomputed_nG_montgomery25519_q_136,32,
    precomputed_nG_montgomery25519_n_136,32,
  },
  {
    precomputed_nG_montgomery25519_q_137,32,
    precomputed_nG_montgomery25519_n_137,32,
  },
  {
    precomputed_nG_montgomery25519_q_138,32,
    precomputed_nG_montgomery25519_n_138,32,
  },
  {
    precomputed_nG_montgomery25519_q_139,32,
    precomputed_nG_montgomery25519_n_139,32,
  },
  {
    precomputed_nG_montgomery25519_q_140,32,
    precomputed_nG_montgomery25519_n_140,32,
  },
  {
    precomputed_nG_montgomery25519_q_141,32,
    precomputed_nG_montgomery25519_n_141,32,
  },
  {
    precomputed_nG_montgomery25519_q_142,32,
    precomputed_nG_montgomery25519_n_142,32,
  },
  {
    precomputed_nG_montgomery25519_q_143,32,
    precomputed_nG_montgomery25519_n_143,32,
  },
  {
    precomputed_nG_montgomery25519_q_144,32,
    precomputed_nG_montgomery25519_n_144,32,
  },
  {
    precomputed_nG_montgomery25519_q_145,32,
    precomputed_nG_montgomery25519_n_145,32,
  },
  {
    precomputed_nG_montgomery25519_q_146,32,
    precomputed_nG_montgomery25519_n_146,32,
  },
  {
    precomputed_nG_montgomery25519_q_147,32,
    precomputed_nG_montgomery25519_n_147,32,
  },
  {
    precomputed_nG_montgomery25519_q_148,32,
    precomputed_nG_montgomery25519_n_148,32,
  },
  {
    precomputed_nG_montgomery25519_q_149,32,
    precomputed_nG_montgomery25519_n_149,32,
  },
  {
    precomputed_nG_montgomery25519_q_150,32,
    precomputed_nG_montgomery25519_n_150,32,
  },
  {
    precomputed_nG_montgomery25519_q_151,32,
    precomputed_nG_montgomery25519_n_151,32,
  },
  {
    precomputed_nG_montgomery25519_q_152,32,
    precomputed_nG_montgomery25519_n_152,32,
  },
  {
    precomputed_nG_montgomery25519_q_153,32,
    precomputed_nG_montgomery25519_n_153,32,
  },
  {
    precomputed_nG_montgomery25519_q_154,32,
    precomputed_nG_montgomery25519_n_154,32,
  },
  {
    precomputed_nG_montgomery25519_q_155,32,
    precomputed_nG_montgomery25519_n_155,32,
  },
  {
    precomputed_nG_montgomery25519_q_156,32,
    precomputed_nG_montgomery25519_n_156,32,
  },
  {
    precomputed_nG_montgomery25519_q_157,32,
    precomputed_nG_montgomery25519_n_157,32,
  },
  {
    precomputed_nG_montgomery25519_q_158,32,
    precomputed_nG_montgomery25519_n_158,32,
  },
  {
    precomputed_nG_montgomery25519_q_159,32,
    precomputed_nG_montgomery25519_n_159,32,
  },
  {
    precomputed_nG_montgomery25519_q_160,32,
    precomputed_nG_montgomery25519_n_160,32,
  },
  {
    precomputed_nG_montgomery25519_q_161,32,
    precomputed_nG_montgomery25519_n_161,32,
  },
  {
    precomputed_nG_montgomery25519_q_162,32,
    precomputed_nG_montgomery25519_n_162,32,
  },
  {
    precomputed_nG_montgomery25519_q_163,32,
    precomputed_nG_montgomery25519_n_163,32,
  },
  {
    precomputed_nG_montgomery25519_q_164,32,
    precomputed_nG_montgomery25519_n_164,32,
  },
  {
    precomputed_nG_montgomery25519_q_165,32,
    precomputed_nG_montgomery25519_n_165,32,
  },
  {
    precomputed_nG_montgomery25519_q_166,32,
    precomputed_nG_montgomery25519_n_166,32,
  },
  {
    precomputed_nG_montgomery25519_q_167,32,
    precomputed_nG_montgomery25519_n_167,32,
  },
  {
    precomputed_nG_montgomery25519_q_168,32,
    precomputed_nG_montgomery25519_n_168,32,
  },
  {
    precomputed_nG_montgomery25519_q_169,32,
    precomputed_nG_montgomery25519_n_169,32,
  },
  {
    precomputed_nG_montgomery25519_q_170,32,
    precomputed_nG_montgomery25519_n_170,32,
  },
  {
    precomputed_nG_montgomery25519_q_171,32,
    precomputed_nG_montgomery25519_n_171,32,
  },
  {
    precomputed_nG_montgomery25519_q_172,32,
    precomputed_nG_montgomery25519_n_172,32,
  },
  {
    precomputed_nG_montgomery25519_q_173,32,
    precomputed_nG_montgomery25519_n_173,32,
  },
  {
    precomputed_nG_montgomery25519_q_174,32,
    precomputed_nG_montgomery25519_n_174,32,
  },
  {
    precomputed_nG_montgomery25519_q_175,32,
    precomputed_nG_montgomery25519_n_175,32,
  },
  {
    precomputed_nG_montgomery25519_q_176,32,
    precomputed_nG_montgomery25519_n_176,32,
  },
  {
    precomputed_nG_montgomery25519_q_177,32,
    precomputed_nG_montgomery25519_n_177,32,
  },
  {
    precomputed_nG_montgomery25519_q_178,32,
    precomputed_nG_montgomery25519_n_178,32,
  },
  {
    precomputed_nG_montgomery25519_q_179,32,
    precomputed_nG_montgomery25519_n_179,32,
  },
  {
    precomputed_nG_montgomery25519_q_180,32,
    precomputed_nG_montgomery25519_n_180,32,
  },
  {
    precomputed_nG_montgomery25519_q_181,32,
    precomputed_nG_montgomery25519_n_181,32,
  },
  {
    precomputed_nG_montgomery25519_q_182,32,
    precomputed_nG_montgomery25519_n_182,32,
  },
  {
    precomputed_nG_montgomery25519_q_183,32,
    precomputed_nG_montgomery25519_n_183,32,
  },
  {
    precomputed_nG_montgomery25519_q_184,32,
    precomputed_nG_montgomery25519_n_184,32,
  },
  {
    precomputed_nG_montgomery25519_q_185,32,
    precomputed_nG_montgomery25519_n_185,32,
  },
  {
    precomputed_nG_montgomery25519_q_186,32,
    precomputed_nG_montgomery25519_n_186,32,
  },
  {
    precomputed_nG_montgomery25519_q_187,32,
    precomputed_nG_montgomery25519_n_187,32,
  },
  {
    precomputed_nG_montgomery25519_q_188,32,
    precomputed_nG_montgomery25519_n_188,32,
  },
  {
    precomputed_nG_montgomery25519_q_189,32,
    precomputed_nG_montgomery25519_n_189,32,
  },
  {
    precomputed_nG_montgomery25519_q_190,32,
    precomputed_nG_montgomery25519_n_190,32,
  },
  {
    precomputed_nG_montgomery25519_q_191,32,
    precomputed_nG_montgomery25519_n_191,32,
  },
  {
    precomputed_nG_montgomery25519_q_192,32,
    precomputed_nG_montgomery25519_n_192,32,
  },
  {
    precomputed_nG_montgomery25519_q_193,32,
    precomputed_nG_montgomery25519_n_193,32,
  },
  {
    precomputed_nG_montgomery25519_q_194,32,
    precomputed_nG_montgomery25519_n_194,32,
  },
  {
    precomputed_nG_montgomery25519_q_195,32,
    precomputed_nG_montgomery25519_n_195,32,
  },
  {
    precomputed_nG_montgomery25519_q_196,32,
    precomputed_nG_montgomery25519_n_196,32,
  },
  {
    precomputed_nG_montgomery25519_q_197,32,
    precomputed_nG_montgomery25519_n_197,32,
  },
  {
    precomputed_nG_montgomery25519_q_198,32,
    precomputed_nG_montgomery25519_n_198,32,
  },
  {
    precomputed_nG_montgomery25519_q_199,32,
    precomputed_nG_montgomery25519_n_199,32,
  },
  {
    precomputed_nG_montgomery25519_q_200,32,
    precomputed_nG_montgomery25519_n_200,32,
  },
  {
    precomputed_nG_montgomery25519_q_201,32,
    precomputed_nG_montgomery25519_n_201,32,
  },
  {
    precomputed_nG_montgomery25519_q_202,32,
    precomputed_nG_montgomery25519_n_202,32,
  },
  {
    precomputed_nG_montgomery25519_q_203,32,
    precomputed_nG_montgomery25519_n_203,32,
  },
} ;

static void test_nG_montgomery25519_impl(long long impl)
{
  unsigned char *q = test_nG_montgomery25519_q;
  unsigned char *n = test_nG_montgomery25519_n;
  unsigned char *q2 = test_nG_montgomery25519_q2;
  unsigned char *n2 = test_nG_montgomery25519_n2;
  long long qlen = crypto_nG_POINTBYTES;
  long long nlen = crypto_nG_SCALARBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,lib25519_dispatch_nG_montgomery25519_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_nG = lib25519_dispatch_nG_montgomery25519(impl);
    printf("nG_montgomery25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_nG_montgomery25519_implementation(impl),lib25519_dispatch_nG_montgomery25519_compiler(impl));
  } else {
    crypto_nG = lib25519_nG_montgomery25519;
    printf("nG_montgomery25519 selected implementation %s compiler %s\n",lib25519_nG_montgomery25519_implementation(),lib25519_nG_montgomery25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(q2,q,qlen);
      input_prepare(n2,n,nlen);
      secret(n,nlen);
      crypto_nG(q,n);
      public(n,nlen);
      public(q,qlen);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_nG");
      input_compare(n2,n,nlen,"crypto_nG");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      secret(n2,nlen);
      crypto_nG(q2,n2);
      public(n2,nlen);
      public(q2,qlen);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_nG is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(n2,n,nlen);
      secret(n2,nlen);
      crypto_nG(n2,n2);
      public(n2,qlen);
      if (memcmp(n2,q,qlen) != 0) fail("failure: crypto_nG does not handle n=q overlap\n");
      memcpy(n2,n,nlen);
    }
    checksum_expected(nG_montgomery25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_nG_montgomery25519_NUM;++precomp) {
    output_prepare(q2,q,precomputed_nG_montgomery25519[precomp].qsize);
    input_prepare(n2,n,precomputed_nG_montgomery25519[precomp].nsize);
    memcpy(n,precomputed_nG_montgomery25519[precomp].n,precomputed_nG_montgomery25519[precomp].nsize);
    memcpy(n2,precomputed_nG_montgomery25519[precomp].n,precomputed_nG_montgomery25519[precomp].nsize);
    crypto_nG(q,n);
    if (memcmp(q,precomputed_nG_montgomery25519[precomp].q,precomputed_nG_montgomery25519[precomp].qsize)) {
      fail("failure: crypto_nG fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_nG_montgomery25519[precomp].qsize;++pos) printf("%02x",precomputed_nG_montgomery25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_nG_montgomery25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_nG_montgomery25519[precomp].qsize,"crypto_nG");
    input_compare(n2,n,precomputed_nG_montgomery25519[precomp].nsize,"crypto_nG");
  }
}

void test_nG_montgomery25519(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"nG")) return;
  if (targetp && strcmp(targetp,"montgomery25519")) return;
  storage_nG_montgomery25519_q = callocplus(crypto_nG_POINTBYTES);
  test_nG_montgomery25519_q = aligned(storage_nG_montgomery25519_q,crypto_nG_POINTBYTES);
  if (crypto_nG_POINTBYTES > maxalloc) maxalloc = crypto_nG_POINTBYTES;
  storage_nG_montgomery25519_n = callocplus(crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);
  test_nG_montgomery25519_n = aligned(storage_nG_montgomery25519_n,crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);
  if (crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES > maxalloc) maxalloc = crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES;
  storage_nG_montgomery25519_q2 = callocplus(maxalloc);
  test_nG_montgomery25519_q2 = aligned(storage_nG_montgomery25519_q2,crypto_nG_POINTBYTES);
  storage_nG_montgomery25519_n2 = callocplus(maxalloc);
  test_nG_montgomery25519_n2 = aligned(storage_nG_montgomery25519_n2,crypto_nG_SCALARBYTES+crypto_nG_POINTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("nG_montgomery25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_nG_montgomery25519();++impl)
      forked(test_nG_montgomery25519_impl,impl);
    ++test_nG_montgomery25519_q;
    ++test_nG_montgomery25519_n;
    ++test_nG_montgomery25519_q2;
    ++test_nG_montgomery25519_n2;
  }
  free(storage_nG_montgomery25519_n2);
  free(storage_nG_montgomery25519_q2);
  free(storage_nG_montgomery25519_n);
  free(storage_nG_montgomery25519_q);
}
#undef crypto_nG_SCALARBYTES
#undef crypto_nG_POINTBYTES

