/*
 * @(#)NetworkIconSet.java 3/10/2009
 *
 * Copyright 2002 - 2009 JIDE Software Inc. All rights reserved.
 *
 */

package com.jidesoft.icons;

/**
 * <code>NetworkIconSet</code> is a class which works with JIDE Network Icon Set (<a
 * href="http://www.jidesoft.com/icon/">http://www.jidesoft.com/icon/</a>). It defines 72 icons in 6 sections in this
 * class. We could add more in the future. All JIDE icon set will follow the naming conversion as defined here.
 *
 * @see com.jidesoft.icons.IconSetManager
 */
public class NetworkIconSet {
    public static class Email {
        public static final String EMAIL_CLOSED = "Email-EmailClosed.png";
        public static final String EMAIL_OPENED = "Email-EmailOpened.png";
        public static final String NEW = "Email-New.png";
        public static final String REPLY = "Email-Reply.png";
        public static final String REPLY_ALL = "Email-ReplyAll.png";
        public static final String FORWARD = "Email-Forward.png";
        public static final String SEND = "Email-Send.png";
        public static final String ATTACHMENT = "Email-Attachment.png";
        public static final String SEND_RECEIVE = "Email-SendReceieve.png";
        public static final String FOLLOW_UP = "Email-FollowUp.png";
        public static final String BLOCKED = "Email-Blocked.png";
        public static final String READ = "Email-Read.png";
        public static final String UNREAD = "Email-Unread.png";
        public static final String HIGH_IMPORTANCE = "Email-HighImportance.png";
        public static final String LOW_IMPORTANCE = "Email-LowImportance.png";
        public static final String SIGNATURE = "Email-Signature.png";
        public static final String AUTO_RESPONSE = "Email-AutoResponse.png";
        public static final String CONFIRMATION = "Email-Confirmation.png";
        public static final String MAILING_LIST = "Email-MailingList.png";
        public static final String CERTIFICATE = "Email-Certificate.png";
        public static final String SPAM = "Email-Spam.png";
    }

    public static class Internet {
        public static final String WEBSITE = "Internet-Website.png";
        public static final String BLOG = "Internet-Blog.png";
        public static final String FEED = "Internet-Feed.png";
        public static final String FORUM = "Internet-Forum.png";
        public static final String NEWSGROUP = "Internet-Newsgroup.png";
        public static final String COMMENT = "Internet-Comment.png";
        public static final String CONNECTED = "Internet-Connected.png";
        public static final String DISCONNECTED = "Internet-Disconnected.png";
        public static final String SEARCH_ENGINE = "Internet-SearchEngine.png";
        public static final String DOWNLOAD = "Internet-Download.png";
        public static final String UPLOAD = "Internet-Upload.png";
        public static final String MESSENGER = "Internet-Messenger.png";
        public static final String KEYWORD = "Internet-Keyword.png";
        public static final String HYPERLINK = "Internet-Hyperlink.png";
        public static final String BROKEN_LINK = "Internet-BrokenLink.png";
        public static final String SITE_MAP = "Internet-SiteMap.png";
        public static final String PODCASTS = "Internet-Podcasts.png";
        public static final String MUSIC = "Internet-Music.png";
        public static final String MOVIE = "Internet-Movie.png";
    }

    public static class Security {
        public static final String LOGIN = "Security-Login.png";
        public static final String SNIFFER = "Security-Sniffer.png";
        public static final String VIRUS = "Security-Virus.png";
        public static final String SECURITY = "Security-Security.png";
        public static final String HACKER = "Security-Hacker.png";
        public static final String ALARM = "Security-Alarm.png";
        public static final String SHIELD = "Security-Shield.png";
    }

    public static class Ecommerce {
        public static final String SHOPPING_CART_EMPTY = "Ecommerce-ShoppingCartEmpty.png";
        public static final String SHOPPING_CART_FULL = "Ecommerce-ShoppingCartFull.png";
        public static final String PRODUCT_BOX_OPENNED = "Ecommerce-ProductBoxOpenned.png";
        public static final String PRODUCT_BOX_CLOSED = "Ecommerce-ProductBoxClosed.png";
        public static final String PACKAGE_OPENED = "Ecommerce-PackagOpenned.png";
        public static final String PACKAGE_CLOSED = "Ecommerce-PackageClosed.png";
    }

    public static class NetworkDevices {
        public static final String FIREWALL = "NetworkDevices-Firewall.png";
        public static final String SWITCH = "NetworkDevices-Switch.png";
        public static final String ROUTER = "NetworkDevices-Router.png";
        public static final String WIRELESS_ROUTER = "NetworkDevices-WirelessRouter.png";
        public static final String NETWORK_ADAPTER = "NetworkDevices-NetworkAdapter.png";
        public static final String MODEM = "NetworkDevices-Modem.png";
        public static final String STORAGE = "NetworkDevices-Storage.png";
        public static final String NETWORK_STORAGE = "NetworkDevices-NetworkStorage.png";
        public static final String WEB_CAM = "NetworkDevices-WebCam.png";
        public static final String VPN = "NetworkDevices-VPN.png";
    }

    public static class Interface {
        public static final String USB = "Interface-USB.png";
        public static final String USB2 = "Interface-USB2.png";
        public static final String FIREWIRE = "Interface-Firewire.png";
        public static final String BLUETOOTH = "Interface-Bluetooth.png";
        public static final String WIFI = "Interface-WiFi.png";
        public static final String ACCESS_POINT = "Interface-AccessPoint.png";
        public static final String LAN = "Interface-LAN.png";
        public static final String PARALLEL_PORT = "Interface-ParallelPort.png";
        public static final String SERIES_PORT = "Interface-SeriesPort.png";
    }
}
