package Locales::DB::Language::fi;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::fi::VERSION = '0.09';

$Locales::DB::Language::fi::cldr_version = '2.0';

%Locales::DB::Language::fi::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}\.\.\.",
            'initial' => "\.\.\.\{0\}",
            'medial'  => "\{0\}\.\.\.\{1\}"
        },
        'language' => "kieli\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ ja\ \{1\}",
            'end'    => "\{0\}\ ja\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "alue\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '’',
        'quotation_end'             => '”',
        'quotation_start'           => '”'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "ei\:e",
        'yesstr' => "kyllä\:k"
    },
);

%Locales::DB::Language::fi::code_to_name = (
    'aa'     => 'afar',
    'ab'     => 'abhaasi',
    'ace'    => 'atšeh',
    'ach'    => 'atšoli',
    'ada'    => 'adangme',
    'ady'    => 'adyge',
    'ae'     => 'avesta',
    'af'     => 'afrikaans',
    'afa'    => "afroaasialainen\ kieli",
    'afh'    => 'afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'ainu',
    'ak'     => 'akan',
    'akk'    => 'akkadi',
    'ale'    => 'aleutti',
    'alg'    => 'algonkikieli',
    'alt'    => 'altai',
    'am'     => 'amhara',
    'an'     => 'aragonia',
    'ang'    => 'muinaisenglanti',
    'anp'    => 'angika',
    'apa'    => 'apaššikieli',
    'ar'     => 'arabia',
    'arc'    => 'valtakunnanaramea',
    'arn'    => 'mapudungun',
    'arp'    => 'arapaho',
    'art'    => "keinotekoinen\ kieli",
    'arw'    => 'arawak',
    'as'     => 'assami',
    'asa'    => 'asu',
    'ast'    => 'asturia',
    'ath'    => 'athabascakieli',
    'aus'    => "australialainen\ kieli",
    'av'     => 'avaari',
    'awa'    => 'awadhi',
    'ay'     => 'aimara',
    'az'     => 'azeri',
    'ba'     => 'baškiiri',
    'bad'    => 'banda',
    'bai'    => 'bamilekekieli',
    'bal'    => 'belutši',
    'ban'    => 'bali',
    'bas'    => 'basa',
    'bat'    => "balttilainen\ kieli",
    'be'     => 'valkovenäjä',
    'bej'    => 'bedža',
    'bem'    => 'bemba',
    'ber'    => 'berberikieli',
    'bez'    => 'bena',
    'bg'     => 'bulgaria',
    'bh'     => 'bihari',
    'bho'    => 'bhodžpuri',
    'bi'     => 'bislama',
    'bik'    => 'bikol',
    'bin'    => 'bini',
    'bla'    => 'siksika',
    'bm'     => 'bambara',
    'bn'     => 'bengali',
    'bnt'    => 'bantukieli',
    'bo'     => 'tiibet',
    'br'     => 'bretoni',
    'bra'    => 'bradž',
    'brx'    => 'bodo',
    'bs'     => 'bosnia',
    'btk'    => 'batakkieli',
    'bua'    => 'burjaatti',
    'bug'    => 'bugi',
    'byn'    => 'bilin',
    'ca'     => 'katalaani',
    'cad'    => 'caddo',
    'cai'    => "keskiamerikkalainen\ intiaanikieli",
    'car'    => 'karibi',
    'cau'    => "kaukasialainen\ kieli",
    'cay'    => 'Cayuga',
    'cch'    => 'atsam',
    'ce'     => 'tšetšeeni',
    'ceb'    => 'cebuano',
    'cel'    => "kelttiläinen\ kieli",
    'cgg'    => 'Chiga',
    'ch'     => 'tšamorro',
    'chb'    => 'tšibtša',
    'chg'    => 'tšagatai',
    'chk'    => 'chuuk',
    'chm'    => 'mari',
    'chn'    => "chinook\-jargon",
    'cho'    => 'choctaw',
    'chp'    => 'chipewyan',
    'chr'    => 'cherokee',
    'chy'    => 'cheyenne',
    'cmc'    => 'tšamkieli',
    'co'     => 'korsika',
    'cop'    => 'kopti',
    'cpe'    => "englantiin\ perustuva\ kreoli\-\ tai\ pidgin\-kieli",
    'cpf'    => "ranskaan\ perustuva\ kreoli\-\ tai\ pidgin\-kieli",
    'cpp'    => "portugaliin\ perustuva\ kreoli\-\ tai\ pidgin\-kieli",
    'cr'     => 'cree',
    'crh'    => 'kriminturkki',
    'crp'    => "kreoli\-\ tai\ pidgin\-kieli",
    'cs'     => 'tšekki',
    'csb'    => 'kašubi',
    'cu'     => 'kirkkoslaavi',
    'cus'    => "kuušilainen\ kieli",
    'cv'     => 'tšuvassi',
    'cy'     => 'kymri',
    'da'     => 'tanska',
    'dak'    => 'dakota',
    'dar'    => 'dargi',
    'dav'    => 'Taita',
    'day'    => "land\-dajakki\-kieli",
    'de'     => 'saksa',
    'de_at'  => 'itävallansaksa',
    'de_ch'  => 'sveitsinyläsaksa',
    'del'    => 'delaware',
    'den'    => 'slevi',
    'dgr'    => 'dogrib',
    'din'    => 'dinka',
    'dje'    => 'Zarma',
    'doi'    => 'dogri',
    'dra'    => 'dravidakieli',
    'dsb'    => 'alasorbi',
    'dua'    => 'duala',
    'dum'    => 'keskihollanti',
    'dv'     => 'divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'djula',
    'dz'     => 'dzongkha',
    'ebu'    => 'embu',
    'ee'     => 'ewe',
    'efi'    => 'efik',
    'egy'    => 'muinaisegypti',
    'eka'    => 'ekajuk',
    'el'     => 'kreikka',
    'elx'    => 'elami',
    'en'     => 'englanti',
    'en_au'  => 'australianenglanti',
    'en_ca'  => 'kanadanenglanti',
    'en_gb'  => 'britannianenglanti',
    'en_us'  => 'amerikanenglanti',
    'enm'    => 'keskienglanti',
    'eo'     => 'esperanto',
    'es'     => 'espanja',
    'es_419' => 'amerikanespanja',
    'es_es'  => 'espanjanespanja',
    'et'     => 'viro',
    'eu'     => 'baski',
    'ewo'    => 'ewondo',
    'fa'     => 'persia',
    'fan'    => 'fang',
    'fat'    => 'fanti',
    'ff'     => 'fulani',
    'fi'     => 'suomi',
    'fil'    => 'filipino',
    'fiu'    => "suomalais\-ugrilainen\ kieli",
    'fj'     => 'fidži',
    'fo'     => 'fääri',
    'fon'    => 'fon',
    'fr'     => 'ranska',
    'fr_ca'  => 'kanadanranska',
    'fr_ch'  => 'sveitsinranska',
    'frm'    => 'keskiranska',
    'fro'    => 'muinaisranska',
    'frr'    => 'pohjoisfriisi',
    'frs'    => 'itäfriisi',
    'fur'    => 'friuli',
    'fy'     => 'länsifriisi',
    'ga'     => 'iiri',
    'gaa'    => 'ga',
    'gay'    => 'gajo',
    'gba'    => 'gbaja',
    'gd'     => 'gaeli',
    'gem'    => "germaaninen\ kieli",
    'gez'    => 'ge’ez',
    'gil'    => 'kiribati',
    'gl'     => 'galicia',
    'gmh'    => 'keskiyläsaksa',
    'gn'     => 'guarani',
    'goh'    => 'muinaisyläsaksa',
    'gon'    => 'gondi',
    'gor'    => 'gorontalo',
    'got'    => 'gootti',
    'grb'    => 'grebo',
    'grc'    => 'muinaiskreikka',
    'gsw'    => 'sveitsinsaksa',
    'gu'     => 'gudžarati',
    'guz'    => 'Gusii',
    'gv'     => 'manksi',
    'gwi'    => 'gwitšin',
    'ha'     => 'hausa',
    'hai'    => 'haida',
    'haw'    => 'havaiji',
    'he'     => 'heprea',
    'hi'     => 'hindi',
    'hil'    => 'hiligaino',
    'him'    => 'himatšali',
    'hit'    => 'heetti',
    'hmn'    => 'hmong',
    'ho'     => "hiri\-motu",
    'hr'     => 'kroatia',
    'hsb'    => 'yläsorbi',
    'ht'     => 'haiti',
    'hu'     => 'unkari',
    'hup'    => 'hupa',
    'hy'     => 'armenia',
    'hz'     => 'herero',
    'ia'     => 'interlingua',
    'iba'    => 'iban',
    'id'     => 'indonesia',
    'ie'     => 'interlingue',
    'ig'     => 'igbo',
    'ii'     => "sichuanin\-yi",
    'ijo'    => 'idžokieli',
    'ik'     => 'inupiaq',
    'ilo'    => 'iloko',
    'inc'    => "indoarjalainen\ kieli",
    'ine'    => "indoeurooppalainen\ kieli",
    'inh'    => 'inguuši',
    'io'     => 'ido',
    'ira'    => "iranilainen\ kieli",
    'iro'    => 'irokeesikieli',
    'is'     => 'islanti',
    'it'     => 'italia',
    'iu'     => 'inuktitut',
    'ja'     => 'japani',
    'jbo'    => 'lojban',
    'jmc'    => 'Machame',
    'jpr'    => 'juutalaispersia',
    'jrb'    => 'juutalaisarabia',
    'jv'     => 'jaava',
    'ka'     => 'georgia',
    'kaa'    => 'karakalpakki',
    'kab'    => 'kabyyli',
    'kac'    => 'katšin',
    'kaj'    => 'jju',
    'kam'    => 'kamba',
    'kar'    => 'karen',
    'kaw'    => 'kavi',
    'kbd'    => 'kabardi',
    'kcg'    => 'tyap',
    'kde'    => 'Makonde',
    'kea'    => 'kapverdenkreoli',
    'kfo'    => 'norsunluurannikonkoro',
    'kg'     => 'kongo',
    'kha'    => 'khasi',
    'khi'    => 'khoisankieli',
    'kho'    => 'khotani',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'kikuju',
    'kj'     => 'kuanjama',
    'kk'     => 'kazakki',
    'kl'     => 'grönlanti',
    'kln'    => 'Kalenjin',
    'km'     => 'keskikhmer',
    'kmb'    => 'kimbundu',
    'kn'     => 'kannada',
    'ko'     => 'korea',
    'kok'    => 'konkani',
    'kos'    => 'kosrae',
    'kpe'    => 'kpelle',
    'kr'     => 'kanuri',
    'krc'    => "karatšai\-balkaari",
    'krl'    => 'karjala',
    'kro'    => "kru\-kieli",
    'kru'    => 'kurukh',
    'ks'     => 'kašmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'kurdi',
    'kum'    => 'kumykki',
    'kut'    => 'kutenai',
    'kv'     => 'komi',
    'kw'     => 'korni',
    'ky'     => 'kirgiisi',
    'la'     => 'latina',
    'lad'    => 'juutalaisespanja',
    'lag'    => 'Langi',
    'lah'    => 'lahnda',
    'lam'    => 'lamba',
    'lb'     => 'luxemburg',
    'lez'    => 'lezgi',
    'lg'     => 'ganda',
    'li'     => 'limburg',
    'ln'     => 'lingala',
    'lo'     => 'lao',
    'lol'    => 'mongo',
    'loz'    => 'lozi',
    'lt'     => 'liettua',
    'lu'     => 'katanganluba',
    'lua'    => 'luluanluba',
    'lui'    => 'luiseño',
    'lun'    => 'lunda',
    'luo'    => 'luo',
    'lus'    => 'lusai',
    'luy'    => 'luhya',
    'lv'     => 'latvia',
    'mad'    => 'madura',
    'mag'    => 'magahi',
    'mai'    => 'maithili',
    'mak'    => 'makassar',
    'man'    => 'mandingo',
    'map'    => "austronesialainen\ kieli",
    'mas'    => 'maasai',
    'mdf'    => 'mokša',
    'mdr'    => 'mandar',
    'men'    => 'mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'malagassi',
    'mga'    => "keski\-iiri",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'marshall',
    'mi'     => 'maori',
    'mic'    => 'micmac',
    'min'    => 'minangkabau',
    'mis'    => "luokittelematon\ kieli",
    'mk'     => 'makedonia',
    'mkh'    => "mon\-khmer\-kieli",
    'ml'     => 'malajalam',
    'mn'     => 'mongoli',
    'mnc'    => 'mantšu',
    'mni'    => 'manipuri',
    'mno'    => 'manobokieli',
    'mo'     => 'moldova',
    'moh'    => 'mohawk',
    'mos'    => 'mossi',
    'mr'     => 'marathi',
    'ms'     => 'malaiji',
    'mt'     => 'malta',
    'mua'    => 'Mundang',
    'mul'    => "monia\ kieliä",
    'mun'    => 'mundakieli',
    'mus'    => 'creek',
    'mwl'    => 'mirandeesi',
    'mwr'    => 'marwari',
    'my'     => 'burma',
    'myn'    => 'mayakieli',
    'myv'    => 'ersä',
    'na'     => 'nauru',
    'nah'    => 'nahuatlkieli',
    'nai'    => "pohjoisamerikkalainen\ intiaanikieli",
    'nap'    => 'napoli',
    'naq'    => 'Nama',
    'nb'     => "norjan\ bokmål",
    'nd'     => "pohjois\-ndebele",
    'nds'    => 'alasaksa',
    'ne'     => 'nepali',
    'new'    => 'newari',
    'ng'     => 'ndonga',
    'nia'    => 'nias',
    'nic'    => "nigeriläis\-kongolainen\ kieli",
    'niu'    => 'niue',
    'nl'     => 'hollanti',
    'nl_be'  => 'flaami',
    'nmg'    => 'Kwasio',
    'nn'     => "norjan\ nynorsk",
    'no'     => 'norja',
    'nog'    => 'nogai',
    'non'    => 'muinaisnorja',
    'nqo'    => 'n’ko',
    'nr'     => "etelä\-ndebele",
    'nso'    => 'pohjoissotho',
    'nub'    => "nubialainen\ kieli",
    'nus'    => 'Nuer',
    'nv'     => 'navajo',
    'nwc'    => "klassinen\ newari",
    'ny'     => 'njandža',
    'nym'    => 'nyamwezi',
    'nyn'    => 'nyankole',
    'nyo'    => 'nyoro',
    'nzi'    => 'nzima',
    'oc'     => 'oksitaani',
    'oj'     => 'odžibwa',
    'om'     => 'oromo',
    'or'     => 'orija',
    'os'     => 'osseetti',
    'osa'    => 'osage',
    'ota'    => 'osmani',
    'oto'    => 'otomikieli',
    'pa'     => 'pandžabi',
    'paa'    => 'papualaiskieli',
    'pag'    => 'pangasinan',
    'pal'    => 'pahlavi',
    'pam'    => 'pampanga',
    'pap'    => 'papiamentu',
    'pau'    => 'palau',
    'peo'    => 'muinaispersia',
    'phi'    => 'filippiiniläiskieli',
    'phn'    => 'foinikia',
    'pi'     => 'paali',
    'pl'     => 'puola',
    'pon'    => 'pohnpei',
    'pra'    => 'prakritkieli',
    'pro'    => 'muinaisprovensaali',
    'ps'     => 'paštu',
    'pt'     => 'portugali',
    'pt_br'  => 'brasilianportugali',
    'pt_pt'  => 'portugalinportugali',
    'qu'     => 'ketšua',
    'raj'    => 'radžastani',
    'rap'    => 'rapanui',
    'rar'    => 'rarotonga',
    'rm'     => 'retoromaani',
    'rn'     => 'rundi',
    'ro'     => 'romania',
    'roa'    => "romaaninen\ kieli",
    'rof'    => 'rombo',
    'rom'    => 'romani',
    'ru'     => 'venäjä',
    'rup'    => 'aromania',
    'rw'     => 'ruanda',
    'rwk'    => 'rwa',
    'sa'     => 'sanskrit',
    'sad'    => 'sandawe',
    'sah'    => 'jakuutti',
    'sai'    => "eteläamerikkalainen\ intiaanikieli",
    'sal'    => "sališilainen\ kieli",
    'sam'    => 'samarianaramea',
    'saq'    => 'Samburu',
    'sas'    => 'sasak',
    'sat'    => 'santali',
    'sbp'    => 'Sangu',
    'sc'     => 'sardi',
    'scn'    => 'sisilia',
    'sco'    => 'skotti',
    'sd'     => 'sindhi',
    'se'     => 'pohjoissaame',
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'selkuppi',
    'sem'    => "seemiläinen\ kieli",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'sango',
    'sga'    => 'muinaisiiri',
    'sgn'    => 'viittomakieli',
    'sh'     => 'serbokroaatti',
    'shi'    => 'Tachelhit',
    'shn'    => 'shan',
    'si'     => 'sinhala',
    'sid'    => 'sidamo',
    'sio'    => 'siouxkieli',
    'sit'    => "sinotiibetiläinen\ kieli",
    'sk'     => 'slovakki',
    'sl'     => 'sloveeni',
    'sla'    => "slaavilainen\ kieli",
    'sm'     => 'samoa',
    'sma'    => 'eteläsaame',
    'smi'    => 'saamelaiskieli',
    'smj'    => 'luulajansaame',
    'smn'    => 'inarinsaame',
    'sms'    => 'koltansaame',
    'sn'     => 'šona',
    'snk'    => 'soninke',
    'so'     => 'somali',
    'sog'    => 'sogdi',
    'son'    => 'songhaikieli',
    'sq'     => 'albania',
    'sr'     => 'serbia',
    'srn'    => 'sranan',
    'srr'    => 'serer',
    'ss'     => 'swazi',
    'ssa'    => "niililäis\-saharalainen\ kieli",
    'ssy'    => 'Saho',
    'st'     => 'eteläsotho',
    'su'     => 'sunda',
    'suk'    => 'sukuma',
    'sus'    => 'susu',
    'sux'    => 'sumeri',
    'sv'     => 'ruotsi',
    'sw'     => 'swahili',
    'swb'    => 'komori',
    'swc'    => "Congo\ Swahili",
    'syc'    => 'muinaissyyria',
    'syr'    => 'syyria',
    'ta'     => 'tamili',
    'tai'    => 'thaikieli',
    'te'     => 'telugu',
    'tem'    => 'temne',
    'teo'    => 'Teso',
    'ter'    => 'tereno',
    'tet'    => 'tetum',
    'tg'     => 'tadžikki',
    'th'     => 'thai',
    'ti'     => 'tigrinja',
    'tig'    => 'tigre',
    'tiv'    => 'tiv',
    'tk'     => 'turkmeeni',
    'tkl'    => 'tokelau',
    'tl'     => 'tagalog',
    'tlh'    => 'klingon',
    'tli'    => 'tlingit',
    'tmh'    => 'tamašek',
    'tn'     => 'tswana',
    'to'     => 'tongantonga',
    'tog'    => 'malawintonga',
    'tpi'    => "tok\-pisin",
    'tr'     => 'turkki',
    'trv'    => 'Taroko',
    'ts'     => 'tsonga',
    'tsi'    => 'tsimši',
    'tt'     => 'tataari',
    'tum'    => 'tumbuka',
    'tup'    => 'tupikieli',
    'tut'    => "altailainen\ kieli",
    'tvl'    => 'tuvalu',
    'tw'     => 'twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'tahiti',
    'tyv'    => 'tuva',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'udmurtti',
    'ug'     => 'uiguuri',
    'uga'    => 'ugarit',
    'uk'     => 'ukraina',
    'umb'    => 'mbundu',
    'und'    => "määrittämätön\ kieli",
    'ur'     => 'urdu',
    'uz'     => 'uzbekki',
    'vai'    => 'vai',
    've'     => 'venda',
    'vi'     => 'vietnam',
    'vo'     => 'volapük',
    'vot'    => 'vatja',
    'vun'    => 'Vunjo',
    'wa'     => 'valloni',
    'wae'    => 'walser',
    'wak'    => 'wakashkieli',
    'wal'    => 'wolaitta',
    'war'    => 'waray',
    'was'    => 'washo',
    'wen'    => 'sorbikieli',
    'wo'     => 'wolof',
    'xal'    => 'kalmukki',
    'xh'     => 'xhosa',
    'xog'    => 'Soga',
    'yao'    => 'jao',
    'yap'    => 'japi',
    'yav'    => 'Yangben',
    'yi'     => 'jiddiš',
    'yo'     => 'joruba',
    'ypk'    => 'jupikkikieli',
    'yue'    => 'kantoninkiina',
    'za'     => 'zhuang',
    'zap'    => 'zapoteekki',
    'zbl'    => 'blisskieli',
    'zen'    => 'zenaga',
    'zh'     => 'kiina',
    'znd'    => 'zandekieli',
    'zu'     => 'zulu',
    'zun'    => 'zuni',
    'zxx'    => "ei\ kielellistä\ sisältöä",
    'zza'    => 'zaza',
);

%Locales::DB::Language::fi::name_to_code = (
    'abhaasi'                                  => 'ab',
    'adangme'                                  => 'ada',
    'adyge'                                    => 'ady',
    'afar'                                     => 'aa',
    'afrihili'                                 => 'afh',
    'afrikaans'                                => 'af',
    'afroaasialainenkieli'                     => 'afa',
    'aghem'                                    => 'agq',
    'aimara'                                   => 'ay',
    'ainu'                                     => 'ain',
    'akan'                                     => 'ak',
    'akkadi'                                   => 'akk',
    'alasaksa'                                 => 'nds',
    'alasorbi'                                 => 'dsb',
    'albania'                                  => 'sq',
    'aleutti'                                  => 'ale',
    'algonkikieli'                             => 'alg',
    'altai'                                    => 'alt',
    'altailainenkieli'                         => 'tut',
    'amerikanenglanti'                         => 'en_us',
    'amerikanespanja'                          => 'es_419',
    'amhara'                                   => 'am',
    'angika'                                   => 'anp',
    'apaššikieli'                            => 'apa',
    'arabia'                                   => 'ar',
    'aragonia'                                 => 'an',
    'arapaho'                                  => 'arp',
    'arawak'                                   => 'arw',
    'armenia'                                  => 'hy',
    'aromania'                                 => 'rup',
    'assami'                                   => 'as',
    'asturia'                                  => 'ast',
    'asu'                                      => 'asa',
    'athabascakieli'                           => 'ath',
    'atsam'                                    => 'cch',
    'atšeh'                                   => 'ace',
    'atšoli'                                  => 'ach',
    'australialainenkieli'                     => 'aus',
    'australianenglanti'                       => 'en_au',
    'austronesialainenkieli'                   => 'map',
    'avaari'                                   => 'av',
    'avesta'                                   => 'ae',
    'awadhi'                                   => 'awa',
    'azeri'                                    => 'az',
    'bafia'                                    => 'ksf',
    'bali'                                     => 'ban',
    'balttilainenkieli'                        => 'bat',
    'bambara'                                  => 'bm',
    'bamilekekieli'                            => 'bai',
    'banda'                                    => 'bad',
    'bantukieli'                               => 'bnt',
    'basa'                                     => 'bas',
    'baski'                                    => 'eu',
    'batakkieli'                               => 'btk',
    'baškiiri'                                => 'ba',
    'bedža'                                   => 'bej',
    'belutši'                                 => 'bal',
    'bemba'                                    => 'bem',
    'bena'                                     => 'bez',
    'bengali'                                  => 'bn',
    'berberikieli'                             => 'ber',
    'bhodžpuri'                               => 'bho',
    'bihari'                                   => 'bh',
    'bikol'                                    => 'bik',
    'bilin'                                    => 'byn',
    'bini'                                     => 'bin',
    'bislama'                                  => 'bi',
    'blisskieli'                               => 'zbl',
    'bodo'                                     => 'brx',
    'bosnia'                                   => 'bs',
    'bradž'                                   => 'bra',
    'brasilianportugali'                       => 'pt_br',
    'bretoni'                                  => 'br',
    'britannianenglanti'                       => 'en_gb',
    'bugi'                                     => 'bug',
    'bulgaria'                                 => 'bg',
    'burjaatti'                                => 'bua',
    'burma'                                    => 'my',
    'caddo'                                    => 'cad',
    'cayuga'                                   => 'cay',
    'cebuano'                                  => 'ceb',
    'centralmoroccotamazight'                  => 'tzm',
    'cherokee'                                 => 'chr',
    'cheyenne'                                 => 'chy',
    'chiga'                                    => 'cgg',
    'chinookjargon'                            => 'chn',
    'chipewyan'                                => 'chp',
    'choctaw'                                  => 'cho',
    'chuuk'                                    => 'chk',
    'colognian'                                => 'ksh',
    'congoswahili'                             => 'swc',
    'cree'                                     => 'cr',
    'creek'                                    => 'mus',
    'dakota'                                   => 'dak',
    'dargi'                                    => 'dar',
    'delaware'                                 => 'del',
    'dinka'                                    => 'din',
    'divehi'                                   => 'dv',
    'djula'                                    => 'dyu',
    'dogri'                                    => 'doi',
    'dogrib'                                   => 'dgr',
    'dravidakieli'                             => 'dra',
    'duala'                                    => 'dua',
    'dzongkha'                                 => 'dz',
    'efik'                                     => 'efi',
    'eikielellistäsisältöä'                => 'zxx',
    'ekajuk'                                   => 'eka',
    'elami'                                    => 'elx',
    'embu'                                     => 'ebu',
    'englanti'                                 => 'en',
    'englantiinperustuvakreolitaipidginkieli'  => 'cpe',
    'ersä'                                    => 'myv',
    'espanja'                                  => 'es',
    'espanjanespanja'                          => 'es_es',
    'esperanto'                                => 'eo',
    'eteläamerikkalainenintiaanikieli'        => 'sai',
    'eteländebele'                            => 'nr',
    'eteläsaame'                              => 'sma',
    'eteläsotho'                              => 'st',
    'ewe'                                      => 'ee',
    'ewondo'                                   => 'ewo',
    'fang'                                     => 'fan',
    'fanti'                                    => 'fat',
    'fidži'                                   => 'fj',
    'filipino'                                 => 'fil',
    'filippiiniläiskieli'                     => 'phi',
    'flaami'                                   => 'nl_be',
    'foinikia'                                 => 'phn',
    'fon'                                      => 'fon',
    'friuli'                                   => 'fur',
    'fulani'                                   => 'ff',
    'fääri'                                  => 'fo',
    'ga'                                       => 'gaa',
    'gaeli'                                    => 'gd',
    'gajo'                                     => 'gay',
    'galicia'                                  => 'gl',
    'ganda'                                    => 'lg',
    'gbaja'                                    => 'gba',
    'georgia'                                  => 'ka',
    'germaaninenkieli'                         => 'gem',
    'ge’ez'                                  => 'gez',
    'gondi'                                    => 'gon',
    'gootti'                                   => 'got',
    'gorontalo'                                => 'gor',
    'grebo'                                    => 'grb',
    'grönlanti'                               => 'kl',
    'guarani'                                  => 'gn',
    'gudžarati'                               => 'gu',
    'gusii'                                    => 'guz',
    'gwitšin'                                 => 'gwi',
    'haida'                                    => 'hai',
    'haiti'                                    => 'ht',
    'hausa'                                    => 'ha',
    'havaiji'                                  => 'haw',
    'heetti'                                   => 'hit',
    'heprea'                                   => 'he',
    'herero'                                   => 'hz',
    'hiligaino'                                => 'hil',
    'himatšali'                               => 'him',
    'hindi'                                    => 'hi',
    'hirimotu'                                 => 'ho',
    'hmong'                                    => 'hmn',
    'hollanti'                                 => 'nl',
    'hupa'                                     => 'hup',
    'iban'                                     => 'iba',
    'ido'                                      => 'io',
    'idžokieli'                               => 'ijo',
    'igbo'                                     => 'ig',
    'iiri'                                     => 'ga',
    'iloko'                                    => 'ilo',
    'inarinsaame'                              => 'smn',
    'indoarjalainenkieli'                      => 'inc',
    'indoeurooppalainenkieli'                  => 'ine',
    'indonesia'                                => 'id',
    'inguuši'                                 => 'inh',
    'interlingua'                              => 'ia',
    'interlingue'                              => 'ie',
    'inuktitut'                                => 'iu',
    'inupiaq'                                  => 'ik',
    'iranilainenkieli'                         => 'ira',
    'irokeesikieli'                            => 'iro',
    'islanti'                                  => 'is',
    'italia'                                   => 'it',
    'itäfriisi'                               => 'frs',
    'itävallansaksa'                          => 'de_at',
    'jaava'                                    => 'jv',
    'jakuutti'                                 => 'sah',
    'jao'                                      => 'yao',
    'japani'                                   => 'ja',
    'japi'                                     => 'yap',
    'jiddiš'                                  => 'yi',
    'jju'                                      => 'kaj',
    'jolafonyi'                                => 'dyo',
    'joruba'                                   => 'yo',
    'jupikkikieli'                             => 'ypk',
    'juutalaisarabia'                          => 'jrb',
    'juutalaisespanja'                         => 'lad',
    'juutalaispersia'                          => 'jpr',
    'kabardi'                                  => 'kbd',
    'kabyyli'                                  => 'kab',
    'kalenjin'                                 => 'kln',
    'kalmukki'                                 => 'xal',
    'kamba'                                    => 'kam',
    'kanadanenglanti'                          => 'en_ca',
    'kanadanranska'                            => 'fr_ca',
    'kannada'                                  => 'kn',
    'kantoninkiina'                            => 'yue',
    'kanuri'                                   => 'kr',
    'kapverdenkreoli'                          => 'kea',
    'karakalpakki'                             => 'kaa',
    'karatšaibalkaari'                        => 'krc',
    'karen'                                    => 'kar',
    'karibi'                                   => 'car',
    'karjala'                                  => 'krl',
    'katalaani'                                => 'ca',
    'katanganluba'                             => 'lu',
    'katšin'                                  => 'kac',
    'kaukasialainenkieli'                      => 'cau',
    'kavi'                                     => 'kaw',
    'kazakki'                                  => 'kk',
    'kašmiri'                                 => 'ks',
    'kašubi'                                  => 'csb',
    'keinotekoinenkieli'                       => 'art',
    'kelttiläinenkieli'                       => 'cel',
    'keskiamerikkalainenintiaanikieli'         => 'cai',
    'keskienglanti'                            => 'enm',
    'keskihollanti'                            => 'dum',
    'keskiiiri'                                => 'mga',
    'keskikhmer'                               => 'km',
    'keskiranska'                              => 'frm',
    'keskiyläsaksa'                           => 'gmh',
    'ketšua'                                  => 'qu',
    'khasi'                                    => 'kha',
    'khoisankieli'                             => 'khi',
    'khotani'                                  => 'kho',
    'kiina'                                    => 'zh',
    'kikuju'                                   => 'ki',
    'kimbundu'                                 => 'kmb',
    'kirgiisi'                                 => 'ky',
    'kiribati'                                 => 'gil',
    'kirkkoslaavi'                             => 'cu',
    'klassinennewari'                          => 'nwc',
    'klingon'                                  => 'tlh',
    'koltansaame'                              => 'sms',
    'komi'                                     => 'kv',
    'komori'                                   => 'swb',
    'kongo'                                    => 'kg',
    'konkani'                                  => 'kok',
    'kopti'                                    => 'cop',
    'korea'                                    => 'ko',
    'korni'                                    => 'kw',
    'korsika'                                  => 'co',
    'kosrae'                                   => 'kos',
    'koyraborosenni'                           => 'ses',
    'koyrachiini'                              => 'khq',
    'kpelle'                                   => 'kpe',
    'kreikka'                                  => 'el',
    'kreolitaipidginkieli'                     => 'crp',
    'kriminturkki'                             => 'crh',
    'kroatia'                                  => 'hr',
    'krukieli'                                 => 'kro',
    'kuanjama'                                 => 'kj',
    'kumykki'                                  => 'kum',
    'kurdi'                                    => 'ku',
    'kurukh'                                   => 'kru',
    'kutenai'                                  => 'kut',
    'kuušilainenkieli'                        => 'cus',
    'kwasio'                                   => 'nmg',
    'kymri'                                    => 'cy',
    'lahnda'                                   => 'lah',
    'lamba'                                    => 'lam',
    'landdajakkikieli'                         => 'day',
    'langi'                                    => 'lag',
    'lao'                                      => 'lo',
    'latina'                                   => 'la',
    'latvia'                                   => 'lv',
    'lezgi'                                    => 'lez',
    'liettua'                                  => 'lt',
    'limburg'                                  => 'li',
    'lingala'                                  => 'ln',
    'lojban'                                   => 'jbo',
    'lozi'                                     => 'loz',
    'luhya'                                    => 'luy',
    'luiseño'                                 => 'lui',
    'luluanluba'                               => 'lua',
    'lunda'                                    => 'lun',
    'luo'                                      => 'luo',
    'luokittelematonkieli'                     => 'mis',
    'lusai'                                    => 'lus',
    'luulajansaame'                            => 'smj',
    'luxemburg'                                => 'lb',
    'länsifriisi'                             => 'fy',
    'maasai'                                   => 'mas',
    'machame'                                  => 'jmc',
    'madura'                                   => 'mad',
    'magahi'                                   => 'mag',
    'maithili'                                 => 'mai',
    'makassar'                                 => 'mak',
    'makedonia'                                => 'mk',
    'makhuwameetto'                            => 'mgh',
    'makonde'                                  => 'kde',
    'malagassi'                                => 'mg',
    'malaiji'                                  => 'ms',
    'malajalam'                                => 'ml',
    'malawintonga'                             => 'tog',
    'malta'                                    => 'mt',
    'mandar'                                   => 'mdr',
    'mandingo'                                 => 'man',
    'manipuri'                                 => 'mni',
    'manksi'                                   => 'gv',
    'manobokieli'                              => 'mno',
    'mantšu'                                  => 'mnc',
    'maori'                                    => 'mi',
    'mapudungun'                               => 'arn',
    'marathi'                                  => 'mr',
    'mari'                                     => 'chm',
    'marshall'                                 => 'mh',
    'marwari'                                  => 'mwr',
    'mayakieli'                                => 'myn',
    'mbundu'                                   => 'umb',
    'mende'                                    => 'men',
    'meru'                                     => 'mer',
    'micmac'                                   => 'mic',
    'minangkabau'                              => 'min',
    'mirandeesi'                               => 'mwl',
    'mohawk'                                   => 'moh',
    'mokša'                                   => 'mdf',
    'moldova'                                  => 'mo',
    'mongo'                                    => 'lol',
    'mongoli'                                  => 'mn',
    'moniakieliä'                             => 'mul',
    'monkhmerkieli'                            => 'mkh',
    'morisyen'                                 => 'mfe',
    'mossi'                                    => 'mos',
    'muinaisegypti'                            => 'egy',
    'muinaisenglanti'                          => 'ang',
    'muinaisiiri'                              => 'sga',
    'muinaiskreikka'                           => 'grc',
    'muinaisnorja'                             => 'non',
    'muinaispersia'                            => 'peo',
    'muinaisprovensaali'                       => 'pro',
    'muinaisranska'                            => 'fro',
    'muinaissyyria'                            => 'syc',
    'muinaisyläsaksa'                         => 'goh',
    'mundakieli'                               => 'mun',
    'mundang'                                  => 'mua',
    'määrittämätönkieli'                  => 'und',
    'nahuatlkieli'                             => 'nah',
    'nama'                                     => 'naq',
    'napoli'                                   => 'nap',
    'nauru'                                    => 'na',
    'navajo'                                   => 'nv',
    'ndonga'                                   => 'ng',
    'nepali'                                   => 'ne',
    'newari'                                   => 'new',
    'nias'                                     => 'nia',
    'nigeriläiskongolainenkieli'              => 'nic',
    'niililäissaharalainenkieli'              => 'ssa',
    'niue'                                     => 'niu',
    'njandža'                                 => 'ny',
    'nogai'                                    => 'nog',
    'norja'                                    => 'no',
    'norjanbokmål'                            => 'nb',
    'norjannynorsk'                            => 'nn',
    'norsunluurannikonkoro'                    => 'kfo',
    'nubialainenkieli'                         => 'nub',
    'nuer'                                     => 'nus',
    'nyamwezi'                                 => 'nym',
    'nyankole'                                 => 'nyn',
    'nyoro'                                    => 'nyo',
    'nzima'                                    => 'nzi',
    'n’ko'                                   => 'nqo',
    'odžibwa'                                 => 'oj',
    'oksitaani'                                => 'oc',
    'orija'                                    => 'or',
    'oromo'                                    => 'om',
    'osage'                                    => 'osa',
    'osmani'                                   => 'ota',
    'osseetti'                                 => 'os',
    'otomikieli'                               => 'oto',
    'paali'                                    => 'pi',
    'pahlavi'                                  => 'pal',
    'palau'                                    => 'pau',
    'pampanga'                                 => 'pam',
    'pandžabi'                                => 'pa',
    'pangasinan'                               => 'pag',
    'papiamentu'                               => 'pap',
    'papualaiskieli'                           => 'paa',
    'paštu'                                   => 'ps',
    'persia'                                   => 'fa',
    'pohjoisamerikkalainenintiaanikieli'       => 'nai',
    'pohjoisfriisi'                            => 'frr',
    'pohjoisndebele'                           => 'nd',
    'pohjoissaame'                             => 'se',
    'pohjoissotho'                             => 'nso',
    'pohnpei'                                  => 'pon',
    'portugali'                                => 'pt',
    'portugaliinperustuvakreolitaipidginkieli' => 'cpp',
    'portugalinportugali'                      => 'pt_pt',
    'prakritkieli'                             => 'pra',
    'puola'                                    => 'pl',
    'radžastani'                              => 'raj',
    'ranska'                                   => 'fr',
    'ranskaanperustuvakreolitaipidginkieli'    => 'cpf',
    'rapanui'                                  => 'rap',
    'rarotonga'                                => 'rar',
    'retoromaani'                              => 'rm',
    'romaaninenkieli'                          => 'roa',
    'romani'                                   => 'rom',
    'romania'                                  => 'ro',
    'rombo'                                    => 'rof',
    'ruanda'                                   => 'rw',
    'rundi'                                    => 'rn',
    'ruotsi'                                   => 'sv',
    'rwa'                                      => 'rwk',
    'saamelaiskieli'                           => 'smi',
    'saho'                                     => 'ssy',
    'saksa'                                    => 'de',
    'sališilainenkieli'                       => 'sal',
    'samarianaramea'                           => 'sam',
    'samburu'                                  => 'saq',
    'samoa'                                    => 'sm',
    'sandawe'                                  => 'sad',
    'sango'                                    => 'sg',
    'sangu'                                    => 'sbp',
    'sanskrit'                                 => 'sa',
    'santali'                                  => 'sat',
    'sardi'                                    => 'sc',
    'sasak'                                    => 'sas',
    'seemiläinenkieli'                        => 'sem',
    'selkuppi'                                 => 'sel',
    'sena'                                     => 'seh',
    'seneca'                                   => 'see',
    'serbia'                                   => 'sr',
    'serbokroaatti'                            => 'sh',
    'serer'                                    => 'srr',
    'shambala'                                 => 'ksb',
    'shan'                                     => 'shn',
    'sichuaninyi'                              => 'ii',
    'sidamo'                                   => 'sid',
    'siksika'                                  => 'bla',
    'sindhi'                                   => 'sd',
    'sinhala'                                  => 'si',
    'sinotiibetiläinenkieli'                  => 'sit',
    'siouxkieli'                               => 'sio',
    'sisilia'                                  => 'scn',
    'skotti'                                   => 'sco',
    'slaavilainenkieli'                        => 'sla',
    'slevi'                                    => 'den',
    'slovakki'                                 => 'sk',
    'sloveeni'                                 => 'sl',
    'soga'                                     => 'xog',
    'sogdi'                                    => 'sog',
    'somali'                                   => 'so',
    'songhaikieli'                             => 'son',
    'soninke'                                  => 'snk',
    'sorbikieli'                               => 'wen',
    'sranan'                                   => 'srn',
    'sukuma'                                   => 'suk',
    'sumeri'                                   => 'sux',
    'sunda'                                    => 'su',
    'suomalaisugrilainenkieli'                 => 'fiu',
    'suomi'                                    => 'fi',
    'susu'                                     => 'sus',
    'sveitsinranska'                           => 'fr_ch',
    'sveitsinsaksa'                            => 'gsw',
    'sveitsinyläsaksa'                        => 'de_ch',
    'swahili'                                  => 'sw',
    'swazi'                                    => 'ss',
    'syyria'                                   => 'syr',
    'tachelhit'                                => 'shi',
    'tadžikki'                                => 'tg',
    'tagalog'                                  => 'tl',
    'tahiti'                                   => 'ty',
    'taita'                                    => 'dav',
    'tamašek'                                 => 'tmh',
    'tamili'                                   => 'ta',
    'tanska'                                   => 'da',
    'taroko'                                   => 'trv',
    'tasawaq'                                  => 'twq',
    'tataari'                                  => 'tt',
    'telugu'                                   => 'te',
    'temne'                                    => 'tem',
    'tereno'                                   => 'ter',
    'teso'                                     => 'teo',
    'tetum'                                    => 'tet',
    'thai'                                     => 'th',
    'thaikieli'                                => 'tai',
    'tigre'                                    => 'tig',
    'tigrinja'                                 => 'ti',
    'tiibet'                                   => 'bo',
    'tiv'                                      => 'tiv',
    'tlingit'                                  => 'tli',
    'tokelau'                                  => 'tkl',
    'tokpisin'                                 => 'tpi',
    'tongantonga'                              => 'to',
    'tsimši'                                  => 'tsi',
    'tsonga'                                   => 'ts',
    'tswana'                                   => 'tn',
    'tumbuka'                                  => 'tum',
    'tupikieli'                                => 'tup',
    'turkki'                                   => 'tr',
    'turkmeeni'                                => 'tk',
    'tuva'                                     => 'tyv',
    'tuvalu'                                   => 'tvl',
    'twi'                                      => 'tw',
    'tyap'                                     => 'kcg',
    'tšagatai'                                => 'chg',
    'tšamkieli'                               => 'cmc',
    'tšamorro'                                => 'ch',
    'tšekki'                                  => 'cs',
    'tšetšeeni'                              => 'ce',
    'tšibtša'                                => 'chb',
    'tšuvassi'                                => 'cv',
    'udmurtti'                                 => 'udm',
    'ugarit'                                   => 'uga',
    'uiguuri'                                  => 'ug',
    'ukraina'                                  => 'uk',
    'unkari'                                   => 'hu',
    'urdu'                                     => 'ur',
    'uzbekki'                                  => 'uz',
    'vai'                                      => 'vai',
    'valkovenäjä'                            => 'be',
    'valloni'                                  => 'wa',
    'valtakunnanaramea'                        => 'arc',
    'vatja'                                    => 'vot',
    'venda'                                    => 've',
    'venäjä'                                 => 'ru',
    'vietnam'                                  => 'vi',
    'viittomakieli'                            => 'sgn',
    'viro'                                     => 'et',
    'volapük'                                 => 'vo',
    'vunjo'                                    => 'vun',
    'wakashkieli'                              => 'wak',
    'walser'                                   => 'wae',
    'waray'                                    => 'war',
    'washo'                                    => 'was',
    'wolaitta'                                 => 'wal',
    'wolof'                                    => 'wo',
    'xhosa'                                    => 'xh',
    'yangben'                                  => 'yav',
    'yläsorbi'                                => 'hsb',
    'zandekieli'                               => 'znd',
    'zapoteekki'                               => 'zap',
    'zarma'                                    => 'dje',
    'zaza'                                     => 'zza',
    'zenaga'                                   => 'zen',
    'zhuang'                                   => 'za',
    'zulu'                                     => 'zu',
    'zuni'                                     => 'zun',
    'šona'                                    => 'sn',
);

1;
