/* Generated from file: oaep-vect.txt
 * with md5 hash: 9c79a5465c35222512ed3e7ac1ad3190
 */


typedef struct rsaKey {
  int n_l;
  unsigned char n[256];
  int e_l;
  unsigned char e[256];
  int d_l;
  unsigned char d[256];
  int p_l;
  unsigned char p[256];
  int q_l;
  unsigned char q[256];
  int dP_l;
  unsigned char dP[256];
  int dQ_l;
  unsigned char dQ[256];
  int qInv_l;
  unsigned char qInv[256];
} rsaKey_t;

typedef struct rsaData {
  const char* name;
  int o1_l;
  unsigned char o1[256];
  int o2_l;
  unsigned char o2[256];
  int o3_l;
  unsigned char o3[256];
} rsaData_t;

typedef struct testcase {
  const char* name;
  rsaKey_t rsa;
#ifdef LTC_TEST_EXT
  rsaData_t data[6];
#else
  rsaData_t data[1];
#endif /* LTC_TEST_EXT */
} testcase_t;

testcase_t testcases_oaep[] =
    {
{
  "Example 1: A 1024-bit RSA Key Pair",
{
  /* RSA modulus n */
  128,
  { 0xa8, 0xb3, 0xb2, 0x84, 0xaf, 0x8e, 0xb5, 0x0b, 0x38, 0x70, 0x34, 0xa8, 0x60, 0xf1, 0x46, 0xc4, 0x91, 0x9f, 0x31, 0x87, 0x63, 0xcd, 0x6c, 0x55, 0x98, 0xc8, 0xae, 0x48, 0x11, 0xa1, 0xe0, 0xab, 0xc4, 0xc7, 0xe0, 0xb0, 0x82, 0xd6, 0x93, 0xa5, 0xe7, 0xfc, 0xed, 0x67, 0x5c, 0xf4, 0x66, 0x85, 0x12, 0x77, 0x2c, 0x0c, 0xbc, 0x64, 0xa7, 0x42, 0xc6, 0xc6, 0x30, 0xf5, 0x33, 0xc8, 0xcc, 0x72, 0xf6, 0x2a, 0xe8, 0x33, 0xc4, 0x0b, 0xf2, 0x58, 0x42, 0xe9, 0x84, 0xbb, 0x78, 0xbd, 0xbf, 0x97, 0xc0, 0x10, 0x7d, 0x55, 0xbd, 0xb6, 0x62, 0xf5, 0xc4, 0xe0, 0xfa, 0xb9, 0x84, 0x5c, 0xb5, 0x14, 0x8e, 0xf7, 0x39, 0x2d, 0xd3, 0xaa, 0xff, 0x93, 0xae, 0x1e, 0x6b, 0x66, 0x7b, 0xb3, 0xd4, 0x24, 0x76, 0x16, 0xd4, 0xf5, 0xba, 0x10, 0xd4, 0xcf, 0xd2, 0x26, 0xde, 0x88, 0xd3, 0x9f, 0x16, 0xfb }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x53, 0x33, 0x9c, 0xfd, 0xb7, 0x9f, 0xc8, 0x46, 0x6a, 0x65, 0x5c, 0x73, 0x16, 0xac, 0xa8, 0x5c, 0x55, 0xfd, 0x8f, 0x6d, 0xd8, 0x98, 0xfd, 0xaf, 0x11, 0x95, 0x17, 0xef, 0x4f, 0x52, 0xe8, 0xfd, 0x8e, 0x25, 0x8d, 0xf9, 0x3f, 0xee, 0x18, 0x0f, 0xa0, 0xe4, 0xab, 0x29, 0x69, 0x3c, 0xd8, 0x3b, 0x15, 0x2a, 0x55, 0x3d, 0x4a, 0xc4, 0xd1, 0x81, 0x2b, 0x8b, 0x9f, 0xa5, 0xaf, 0x0e, 0x7f, 0x55, 0xfe, 0x73, 0x04, 0xdf, 0x41, 0x57, 0x09, 0x26, 0xf3, 0x31, 0x1f, 0x15, 0xc4, 0xd6, 0x5a, 0x73, 0x2c, 0x48, 0x31, 0x16, 0xee, 0x3d, 0x3d, 0x2d, 0x0a, 0xf3, 0x54, 0x9a, 0xd9, 0xbf, 0x7c, 0xbf, 0xb7, 0x8a, 0xd8, 0x84, 0xf8, 0x4d, 0x5b, 0xeb, 0x04, 0x72, 0x4d, 0xc7, 0x36, 0x9b, 0x31, 0xde, 0xf3, 0x7d, 0x0c, 0xf5, 0x39, 0xe9, 0xcf, 0xcd, 0xd3, 0xde, 0x65, 0x37, 0x29, 0xea, 0xd5, 0xd1 }
,
  /* Prime p */
  64,
  { 0xd3, 0x27, 0x37, 0xe7, 0x26, 0x7f, 0xfe, 0x13, 0x41, 0xb2, 0xd5, 0xc0, 0xd1, 0x50, 0xa8, 0x1b, 0x58, 0x6f, 0xb3, 0x13, 0x2b, 0xed, 0x2f, 0x8d, 0x52, 0x62, 0x86, 0x4a, 0x9c, 0xb9, 0xf3, 0x0a, 0xf3, 0x8b, 0xe4, 0x48, 0x59, 0x8d, 0x41, 0x3a, 0x17, 0x2e, 0xfb, 0x80, 0x2c, 0x21, 0xac, 0xf1, 0xc1, 0x1c, 0x52, 0x0c, 0x2f, 0x26, 0xa4, 0x71, 0xdc, 0xad, 0x21, 0x2e, 0xac, 0x7c, 0xa3, 0x9d }
,
  /* Prime q */
  64,
  { 0xcc, 0x88, 0x53, 0xd1, 0xd5, 0x4d, 0xa6, 0x30, 0xfa, 0xc0, 0x04, 0xf4, 0x71, 0xf2, 0x81, 0xc7, 0xb8, 0x98, 0x2d, 0x82, 0x24, 0xa4, 0x90, 0xed, 0xbe, 0xb3, 0x3d, 0x3e, 0x3d, 0x5c, 0xc9, 0x3c, 0x47, 0x65, 0x70, 0x3d, 0x1d, 0xd7, 0x91, 0x64, 0x2f, 0x1f, 0x11, 0x6a, 0x0d, 0xd8, 0x52, 0xbe, 0x24, 0x19, 0xb2, 0xaf, 0x72, 0xbf, 0xe9, 0xa0, 0x30, 0xe8, 0x60, 0xb0, 0x28, 0x8b, 0x5d, 0x77 }
,
  /* p's CRT exponent dP */
  64,
  { 0x0e, 0x12, 0xbf, 0x17, 0x18, 0xe9, 0xce, 0xf5, 0x59, 0x9b, 0xa1, 0xc3, 0x88, 0x2f, 0xe8, 0x04, 0x6a, 0x90, 0x87, 0x4e, 0xef, 0xce, 0x8f, 0x2c, 0xcc, 0x20, 0xe4, 0xf2, 0x74, 0x1f, 0xb0, 0xa3, 0x3a, 0x38, 0x48, 0xae, 0xc9, 0xc9, 0x30, 0x5f, 0xbe, 0xcb, 0xd2, 0xd7, 0x68, 0x19, 0x96, 0x7d, 0x46, 0x71, 0xac, 0xc6, 0x43, 0x1e, 0x40, 0x37, 0x96, 0x8d, 0xb3, 0x78, 0x78, 0xe6, 0x95, 0xc1 }
,
  /* q's CRT exponent dQ */
  64,
  { 0x95, 0x29, 0x7b, 0x0f, 0x95, 0xa2, 0xfa, 0x67, 0xd0, 0x07, 0x07, 0xd6, 0x09, 0xdf, 0xd4, 0xfc, 0x05, 0xc8, 0x9d, 0xaf, 0xc2, 0xef, 0x6d, 0x6e, 0xa5, 0x5b, 0xec, 0x77, 0x1e, 0xa3, 0x33, 0x73, 0x4d, 0x92, 0x51, 0xe7, 0x90, 0x82, 0xec, 0xda, 0x86, 0x6e, 0xfe, 0xf1, 0x3c, 0x45, 0x9e, 0x1a, 0x63, 0x13, 0x86, 0xb7, 0xe3, 0x54, 0xc8, 0x99, 0xf5, 0xf1, 0x12, 0xca, 0x85, 0xd7, 0x15, 0x83 }
,
  /* CRT coefficient qInv */
  64,
  { 0x4f, 0x45, 0x6c, 0x50, 0x24, 0x93, 0xbd, 0xc0, 0xed, 0x2a, 0xb7, 0x56, 0xa3, 0xa6, 0xed, 0x4d, 0x67, 0x35, 0x2a, 0x69, 0x7d, 0x42, 0x16, 0xe9, 0x32, 0x12, 0xb1, 0x27, 0xa6, 0x3d, 0x54, 0x11, 0xce, 0x6f, 0xa9, 0x8d, 0x5d, 0xbe, 0xfd, 0x73, 0x26, 0x3e, 0x37, 0x28, 0x14, 0x27, 0x43, 0x81, 0x81, 0x66, 0xed, 0x7d, 0xd6, 0x36, 0x87, 0xdd, 0x2a, 0x8c, 0xa1, 0xd2, 0xf4, 0xfb, 0xd8, 0xe1 }

}
,
{{
  "RSAES-OAEP Encryption Example 1.1",
  /* Message to be encrypted */
  28,
  { 0x66, 0x28, 0x19, 0x4e, 0x12, 0x07, 0x3d, 0xb0, 0x3b, 0xa9, 0x4c, 0xda, 0x9e, 0xf9, 0x53, 0x23, 0x97, 0xd5, 0x0d, 0xba, 0x79, 0xb9, 0x87, 0x00, 0x4a, 0xfe, 0xfe, 0x34 }
,
  /* Seed */
  20,
  { 0x18, 0xb7, 0x76, 0xea, 0x21, 0x06, 0x9d, 0x69, 0x77, 0x6a, 0x33, 0xe9, 0x6b, 0xad, 0x48, 0xe1, 0xdd, 0xa0, 0xa5, 0xef }
,
  /* Encryption */
  128,
  { 0x35, 0x4f, 0xe6, 0x7b, 0x4a, 0x12, 0x6d, 0x5d, 0x35, 0xfe, 0x36, 0xc7, 0x77, 0x79, 0x1a, 0x3f, 0x7b, 0xa1, 0x3d, 0xef, 0x48, 0x4e, 0x2d, 0x39, 0x08, 0xaf, 0xf7, 0x22, 0xfa, 0xd4, 0x68, 0xfb, 0x21, 0x69, 0x6d, 0xe9, 0x5d, 0x0b, 0xe9, 0x11, 0xc2, 0xd3, 0x17, 0x4f, 0x8a, 0xfc, 0xc2, 0x01, 0x03, 0x5f, 0x7b, 0x6d, 0x8e, 0x69, 0x40, 0x2d, 0xe5, 0x45, 0x16, 0x18, 0xc2, 0x1a, 0x53, 0x5f, 0xa9, 0xd7, 0xbf, 0xc5, 0xb8, 0xdd, 0x9f, 0xc2, 0x43, 0xf8, 0xcf, 0x92, 0x7d, 0xb3, 0x13, 0x22, 0xd6, 0xe8, 0x81, 0xea, 0xa9, 0x1a, 0x99, 0x61, 0x70, 0xe6, 0x57, 0xa0, 0x5a, 0x26, 0x64, 0x26, 0xd9, 0x8c, 0x88, 0x00, 0x3f, 0x84, 0x77, 0xc1, 0x22, 0x70, 0x94, 0xa0, 0xd9, 0xfa, 0x1e, 0x8c, 0x40, 0x24, 0x30, 0x9c, 0xe1, 0xec, 0xcc, 0xb5, 0x21, 0x00, 0x35, 0xd4, 0x7a, 0xc7, 0x2e, 0x8a }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 1.2",
  /* Message to be encrypted */
  28,
  { 0x75, 0x0c, 0x40, 0x47, 0xf5, 0x47, 0xe8, 0xe4, 0x14, 0x11, 0x85, 0x65, 0x23, 0x29, 0x8a, 0xc9, 0xba, 0xe2, 0x45, 0xef, 0xaf, 0x13, 0x97, 0xfb, 0xe5, 0x6f, 0x9d, 0xd5 }
,
  /* Seed */
  20,
  { 0x0c, 0xc7, 0x42, 0xce, 0x4a, 0x9b, 0x7f, 0x32, 0xf9, 0x51, 0xbc, 0xb2, 0x51, 0xef, 0xd9, 0x25, 0xfe, 0x4f, 0xe3, 0x5f }
,
  /* Encryption */
  128,
  { 0x64, 0x0d, 0xb1, 0xac, 0xc5, 0x8e, 0x05, 0x68, 0xfe, 0x54, 0x07, 0xe5, 0xf9, 0xb7, 0x01, 0xdf, 0xf8, 0xc3, 0xc9, 0x1e, 0x71, 0x6c, 0x53, 0x6f, 0xc7, 0xfc, 0xec, 0x6c, 0xb5, 0xb7, 0x1c, 0x11, 0x65, 0x98, 0x8d, 0x4a, 0x27, 0x9e, 0x15, 0x77, 0xd7, 0x30, 0xfc, 0x7a, 0x29, 0x93, 0x2e, 0x3f, 0x00, 0xc8, 0x15, 0x15, 0x23, 0x6d, 0x8d, 0x8e, 0x31, 0x01, 0x7a, 0x7a, 0x09, 0xdf, 0x43, 0x52, 0xd9, 0x04, 0xcd, 0xeb, 0x79, 0xaa, 0x58, 0x3a, 0xdc, 0xc3, 0x1e, 0xa6, 0x98, 0xa4, 0xc0, 0x52, 0x83, 0xda, 0xba, 0x90, 0x89, 0xbe, 0x54, 0x91, 0xf6, 0x7c, 0x1a, 0x4e, 0xe4, 0x8d, 0xc7, 0x4b, 0xbb, 0xe6, 0x64, 0x3a, 0xef, 0x84, 0x66, 0x79, 0xb4, 0xcb, 0x39, 0x5a, 0x35, 0x2d, 0x5e, 0xd1, 0x15, 0x91, 0x2d, 0xf6, 0x96, 0xff, 0xe0, 0x70, 0x29, 0x32, 0x94, 0x6d, 0x71, 0x49, 0x2b, 0x44 }

}
,
{
  "RSAES-OAEP Encryption Example 1.3",
  /* Message to be encrypted */
  55,
  { 0xd9, 0x4a, 0xe0, 0x83, 0x2e, 0x64, 0x45, 0xce, 0x42, 0x33, 0x1c, 0xb0, 0x6d, 0x53, 0x1a, 0x82, 0xb1, 0xdb, 0x4b, 0xaa, 0xd3, 0x0f, 0x74, 0x6d, 0xc9, 0x16, 0xdf, 0x24, 0xd4, 0xe3, 0xc2, 0x45, 0x1f, 0xff, 0x59, 0xa6, 0x42, 0x3e, 0xb0, 0xe1, 0xd0, 0x2d, 0x4f, 0xe6, 0x46, 0xcf, 0x69, 0x9d, 0xfd, 0x81, 0x8c, 0x6e, 0x97, 0xb0, 0x51 }
,
  /* Seed */
  20,
  { 0x25, 0x14, 0xdf, 0x46, 0x95, 0x75, 0x5a, 0x67, 0xb2, 0x88, 0xea, 0xf4, 0x90, 0x5c, 0x36, 0xee, 0xc6, 0x6f, 0xd2, 0xfd }
,
  /* Encryption */
  128,
  { 0x42, 0x37, 0x36, 0xed, 0x03, 0x5f, 0x60, 0x26, 0xaf, 0x27, 0x6c, 0x35, 0xc0, 0xb3, 0x74, 0x1b, 0x36, 0x5e, 0x5f, 0x76, 0xca, 0x09, 0x1b, 0x4e, 0x8c, 0x29, 0xe2, 0xf0, 0xbe, 0xfe, 0xe6, 0x03, 0x59, 0x5a, 0xa8, 0x32, 0x2d, 0x60, 0x2d, 0x2e, 0x62, 0x5e, 0x95, 0xeb, 0x81, 0xb2, 0xf1, 0xc9, 0x72, 0x4e, 0x82, 0x2e, 0xca, 0x76, 0xdb, 0x86, 0x18, 0xcf, 0x09, 0xc5, 0x34, 0x35, 0x03, 0xa4, 0x36, 0x08, 0x35, 0xb5, 0x90, 0x3b, 0xc6, 0x37, 0xe3, 0x87, 0x9f, 0xb0, 0x5e, 0x0e, 0xf3, 0x26, 0x85, 0xd5, 0xae, 0xc5, 0x06, 0x7c, 0xd7, 0xcc, 0x96, 0xfe, 0x4b, 0x26, 0x70, 0xb6, 0xea, 0xc3, 0x06, 0x6b, 0x1f, 0xcf, 0x56, 0x86, 0xb6, 0x85, 0x89, 0xaa, 0xfb, 0x7d, 0x62, 0x9b, 0x02, 0xd8, 0xf8, 0x62, 0x5c, 0xa3, 0x83, 0x36, 0x24, 0xd4, 0x80, 0x0f, 0xb0, 0x81, 0xb1, 0xcf, 0x94, 0xeb }

}
,
{
  "RSAES-OAEP Encryption Example 1.4",
  /* Message to be encrypted */
  26,
  { 0x52, 0xe6, 0x50, 0xd9, 0x8e, 0x7f, 0x2a, 0x04, 0x8b, 0x4f, 0x86, 0x85, 0x21, 0x53, 0xb9, 0x7e, 0x01, 0xdd, 0x31, 0x6f, 0x34, 0x6a, 0x19, 0xf6, 0x7a, 0x85 }
,
  /* Seed */
  20,
  { 0xc4, 0x43, 0x5a, 0x3e, 0x1a, 0x18, 0xa6, 0x8b, 0x68, 0x20, 0x43, 0x62, 0x90, 0xa3, 0x7c, 0xef, 0xb8, 0x5d, 0xb3, 0xfb }
,
  /* Encryption */
  128,
  { 0x45, 0xea, 0xd4, 0xca, 0x55, 0x1e, 0x66, 0x2c, 0x98, 0x00, 0xf1, 0xac, 0xa8, 0x28, 0x3b, 0x05, 0x25, 0xe6, 0xab, 0xae, 0x30, 0xbe, 0x4b, 0x4a, 0xba, 0x76, 0x2f, 0xa4, 0x0f, 0xd3, 0xd3, 0x8e, 0x22, 0xab, 0xef, 0xc6, 0x97, 0x94, 0xf6, 0xeb, 0xbb, 0xc0, 0x5d, 0xdb, 0xb1, 0x12, 0x16, 0x24, 0x7d, 0x2f, 0x41, 0x2f, 0xd0, 0xfb, 0xa8, 0x7c, 0x6e, 0x3a, 0xcd, 0x88, 0x88, 0x13, 0x64, 0x6f, 0xd0, 0xe4, 0x8e, 0x78, 0x52, 0x04, 0xf9, 0xc3, 0xf7, 0x3d, 0x6d, 0x82, 0x39, 0x56, 0x27, 0x22, 0xdd, 0xdd, 0x87, 0x71, 0xfe, 0xc4, 0x8b, 0x83, 0xa3, 0x1e, 0xe6, 0xf5, 0x92, 0xc4, 0xcf, 0xd4, 0xbc, 0x88, 0x17, 0x4f, 0x3b, 0x13, 0xa1, 0x12, 0xaa, 0xe3, 0xb9, 0xf7, 0xb8, 0x0e, 0x0f, 0xc6, 0xf7, 0x25, 0x5b, 0xa8, 0x80, 0xdc, 0x7d, 0x80, 0x21, 0xe2, 0x2a, 0xd6, 0xa8, 0x5f, 0x07, 0x55 }

}
,
{
  "RSAES-OAEP Encryption Example 1.5",
  /* Message to be encrypted */
  20,
  { 0x8d, 0xa8, 0x9f, 0xd9, 0xe5, 0xf9, 0x74, 0xa2, 0x9f, 0xef, 0xfb, 0x46, 0x2b, 0x49, 0x18, 0x0f, 0x6c, 0xf9, 0xe8, 0x02 }
,
  /* Seed */
  20,
  { 0xb3, 0x18, 0xc4, 0x2d, 0xf3, 0xbe, 0x0f, 0x83, 0xfe, 0xa8, 0x23, 0xf5, 0xa7, 0xb4, 0x7e, 0xd5, 0xe4, 0x25, 0xa3, 0xb5 }
,
  /* Encryption */
  128,
  { 0x36, 0xf6, 0xe3, 0x4d, 0x94, 0xa8, 0xd3, 0x4d, 0xaa, 0xcb, 0xa3, 0x3a, 0x21, 0x39, 0xd0, 0x0a, 0xd8, 0x5a, 0x93, 0x45, 0xa8, 0x60, 0x51, 0xe7, 0x30, 0x71, 0x62, 0x00, 0x56, 0xb9, 0x20, 0xe2, 0x19, 0x00, 0x58, 0x55, 0xa2, 0x13, 0xa0, 0xf2, 0x38, 0x97, 0xcd, 0xcd, 0x73, 0x1b, 0x45, 0x25, 0x7c, 0x77, 0x7f, 0xe9, 0x08, 0x20, 0x2b, 0xef, 0xdd, 0x0b, 0x58, 0x38, 0x6b, 0x12, 0x44, 0xea, 0x0c, 0xf5, 0x39, 0xa0, 0x5d, 0x5d, 0x10, 0x32, 0x9d, 0xa4, 0x4e, 0x13, 0x03, 0x0f, 0xd7, 0x60, 0xdc, 0xd6, 0x44, 0xcf, 0xef, 0x20, 0x94, 0xd1, 0x91, 0x0d, 0x3f, 0x43, 0x3e, 0x1c, 0x7c, 0x6d, 0xd1, 0x8b, 0xc1, 0xf2, 0xdf, 0x7f, 0x64, 0x3d, 0x66, 0x2f, 0xb9, 0xdd, 0x37, 0xea, 0xd9, 0x05, 0x91, 0x90, 0xf4, 0xfa, 0x66, 0xca, 0x39, 0xe8, 0x69, 0xc4, 0xeb, 0x44, 0x9c, 0xbd, 0xc4, 0x39 }

}
,
{
  "RSAES-OAEP Encryption Example 1.6",
  /* Message to be encrypted */
  7,
  { 0x26, 0x52, 0x10, 0x50, 0x84, 0x42, 0x71 }
,
  /* Seed */
  20,
  { 0xe4, 0xec, 0x09, 0x82, 0xc2, 0x33, 0x6f, 0x3a, 0x67, 0x7f, 0x6a, 0x35, 0x61, 0x74, 0xeb, 0x0c, 0xe8, 0x87, 0xab, 0xc2 }
,
  /* Encryption */
  128,
  { 0x42, 0xce, 0xe2, 0x61, 0x7b, 0x1e, 0xce, 0xa4, 0xdb, 0x3f, 0x48, 0x29, 0x38, 0x6f, 0xbd, 0x61, 0xda, 0xfb, 0xf0, 0x38, 0xe1, 0x80, 0xd8, 0x37, 0xc9, 0x63, 0x66, 0xdf, 0x24, 0xc0, 0x97, 0xb4, 0xab, 0x0f, 0xac, 0x6b, 0xdf, 0x59, 0x0d, 0x82, 0x1c, 0x9f, 0x10, 0x64, 0x2e, 0x68, 0x1a, 0xd0, 0x5b, 0x8d, 0x78, 0xb3, 0x78, 0xc0, 0xf4, 0x6c, 0xe2, 0xfa, 0xd6, 0x3f, 0x74, 0xe0, 0xad, 0x3d, 0xf0, 0x6b, 0x07, 0x5d, 0x7e, 0xb5, 0xf5, 0x63, 0x6f, 0x8d, 0x40, 0x3b, 0x90, 0x59, 0xca, 0x76, 0x1b, 0x5c, 0x62, 0xbb, 0x52, 0xaa, 0x45, 0x00, 0x2e, 0xa7, 0x0b, 0xaa, 0xce, 0x08, 0xde, 0xd2, 0x43, 0xb9, 0xd8, 0xcb, 0xd6, 0x2a, 0x68, 0xad, 0xe2, 0x65, 0x83, 0x2b, 0x56, 0x56, 0x4e, 0x43, 0xa6, 0xfa, 0x42, 0xed, 0x19, 0x9a, 0x09, 0x97, 0x69, 0x74, 0x2d, 0xf1, 0x53, 0x9e, 0x82, 0x55 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 2: A 1025-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x01, 0x94, 0x7c, 0x7f, 0xce, 0x90, 0x42, 0x5f, 0x47, 0x27, 0x9e, 0x70, 0x85, 0x1f, 0x25, 0xd5, 0xe6, 0x23, 0x16, 0xfe, 0x8a, 0x1d, 0xf1, 0x93, 0x71, 0xe3, 0xe6, 0x28, 0xe2, 0x60, 0x54, 0x3e, 0x49, 0x01, 0xef, 0x60, 0x81, 0xf6, 0x8c, 0x0b, 0x81, 0x41, 0x19, 0x0d, 0x2a, 0xe8, 0xda, 0xba, 0x7d, 0x12, 0x50, 0xec, 0x6d, 0xb6, 0x36, 0xe9, 0x44, 0xec, 0x37, 0x22, 0x87, 0x7c, 0x7c, 0x1d, 0x0a, 0x67, 0xf1, 0x4b, 0x16, 0x94, 0xc5, 0xf0, 0x37, 0x94, 0x51, 0xa4, 0x3e, 0x49, 0xa3, 0x2d, 0xde, 0x83, 0x67, 0x0b, 0x73, 0xda, 0x91, 0xa1, 0xc9, 0x9b, 0xc2, 0x3b, 0x43, 0x6a, 0x60, 0x05, 0x5c, 0x61, 0x0f, 0x0b, 0xaf, 0x99, 0xc1, 0xa0, 0x79, 0x56, 0x5b, 0x95, 0xa3, 0xf1, 0x52, 0x66, 0x32, 0xd1, 0xd4, 0xda, 0x60, 0xf2, 0x0e, 0xda, 0x25, 0xe6, 0x53, 0xc4, 0xf0, 0x02, 0x76, 0x6f, 0x45 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x08, 0x23, 0xf2, 0x0f, 0xad, 0xb5, 0xda, 0x89, 0x08, 0x8a, 0x9d, 0x00, 0x89, 0x3e, 0x21, 0xfa, 0x4a, 0x1b, 0x11, 0xfb, 0xc9, 0x3c, 0x64, 0xa3, 0xbe, 0x0b, 0xaa, 0xea, 0x97, 0xfb, 0x3b, 0x93, 0xc3, 0xff, 0x71, 0x37, 0x04, 0xc1, 0x9c, 0x96, 0x3c, 0x1d, 0x10, 0x7a, 0xae, 0x99, 0x05, 0x47, 0x39, 0xf7, 0x9e, 0x02, 0xe1, 0x86, 0xde, 0x86, 0xf8, 0x7a, 0x6d, 0xde, 0xfe, 0xa6, 0xd8, 0xcc, 0xd1, 0xd3, 0xc8, 0x1a, 0x47, 0xbf, 0xa7, 0x25, 0x5b, 0xe2, 0x06, 0x01, 0xa4, 0xa4, 0xb2, 0xf0, 0x8a, 0x16, 0x7b, 0x5e, 0x27, 0x9d, 0x71, 0x5b, 0x1b, 0x45, 0x5b, 0xdd, 0x7e, 0xab, 0x24, 0x59, 0x41, 0xd9, 0x76, 0x8b, 0x9a, 0xce, 0xfb, 0x3c, 0xcd, 0xa5, 0x95, 0x2d, 0xa3, 0xce, 0xe7, 0x25, 0x25, 0xb4, 0x50, 0x16, 0x63, 0xa8, 0xee, 0x15, 0xc9, 0xe9, 0x92, 0xd9, 0x24, 0x62, 0xfe, 0x39 }
,
  /* Prime p */
  65,
  { 0x01, 0x59, 0xdb, 0xde, 0x04, 0xa3, 0x3e, 0xf0, 0x6f, 0xb6, 0x08, 0xb8, 0x0b, 0x19, 0x0f, 0x4d, 0x3e, 0x22, 0xbc, 0xc1, 0x3a, 0xc8, 0xe4, 0xa0, 0x81, 0x03, 0x3a, 0xbf, 0xa4, 0x16, 0xed, 0xb0, 0xb3, 0x38, 0xaa, 0x08, 0xb5, 0x73, 0x09, 0xea, 0x5a, 0x52, 0x40, 0xe7, 0xdc, 0x6e, 0x54, 0x37, 0x8c, 0x69, 0x41, 0x4c, 0x31, 0xd9, 0x7d, 0xdb, 0x1f, 0x40, 0x6d, 0xb3, 0x76, 0x9c, 0xc4, 0x1a, 0x43 }
,
  /* Prime q */
  65,
  { 0x01, 0x2b, 0x65, 0x2f, 0x30, 0x40, 0x3b, 0x38, 0xb4, 0x09, 0x95, 0xfd, 0x6f, 0xf4, 0x1a, 0x1a, 0xcc, 0x8a, 0xda, 0x70, 0x37, 0x32, 0x36, 0xb7, 0x20, 0x2d, 0x39, 0xb2, 0xee, 0x30, 0xcf, 0xb4, 0x6d, 0xb0, 0x95, 0x11, 0xf6, 0xf3, 0x07, 0xcc, 0x61, 0xcc, 0x21, 0x60, 0x6c, 0x18, 0xa7, 0x5b, 0x8a, 0x62, 0xf8, 0x22, 0xdf, 0x03, 0x1b, 0xa0, 0xdf, 0x0d, 0xaf, 0xd5, 0x50, 0x6f, 0x56, 0x8b, 0xd7 }
,
  /* p's CRT exponent dP */
  64,
  { 0x43, 0x6e, 0xf5, 0x08, 0xde, 0x73, 0x65, 0x19, 0xc2, 0xda, 0x4c, 0x58, 0x0d, 0x98, 0xc8, 0x2c, 0xb7, 0x45, 0x2a, 0x3f, 0xb5, 0xef, 0xad, 0xc3, 0xb9, 0xc7, 0x78, 0x9a, 0x1b, 0xc6, 0x58, 0x4f, 0x79, 0x5a, 0xdd, 0xbb, 0xd3, 0x24, 0x39, 0xc7, 0x46, 0x86, 0x55, 0x2e, 0xcb, 0x6c, 0x2c, 0x30, 0x7a, 0x4d, 0x3a, 0xf7, 0xf5, 0x39, 0xee, 0xc1, 0x57, 0x24, 0x8c, 0x7b, 0x31, 0xf1, 0xa2, 0x55 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x01, 0x2b, 0x15, 0xa8, 0x9f, 0x3d, 0xfb, 0x2b, 0x39, 0x07, 0x3e, 0x73, 0xf0, 0x2b, 0xdd, 0x0c, 0x1a, 0x7b, 0x37, 0x9d, 0xd4, 0x35, 0xf0, 0x5c, 0xdd, 0xe2, 0xef, 0xf9, 0xe4, 0x62, 0x94, 0x8b, 0x7c, 0xec, 0x62, 0xee, 0x90, 0x50, 0xd5, 0xe0, 0x81, 0x6e, 0x07, 0x85, 0xa8, 0x56, 0xb4, 0x91, 0x08, 0xdc, 0xb7, 0x5f, 0x36, 0x83, 0x87, 0x4d, 0x1c, 0xa6, 0x32, 0x9a, 0x19, 0x01, 0x30, 0x66, 0xff }
,
  /* CRT coefficient qInv */
  64,
  { 0x02, 0x70, 0xdb, 0x17, 0xd5, 0x91, 0x4b, 0x01, 0x8d, 0x76, 0x11, 0x8b, 0x24, 0x38, 0x9a, 0x73, 0x50, 0xec, 0x83, 0x6b, 0x00, 0x63, 0xa2, 0x17, 0x21, 0x23, 0x6f, 0xd8, 0xed, 0xb6, 0xd8, 0x9b, 0x51, 0xe7, 0xee, 0xb8, 0x7b, 0x61, 0x1b, 0x71, 0x32, 0xcb, 0x7e, 0xa7, 0x35, 0x6c, 0x23, 0x15, 0x1c, 0x1e, 0x77, 0x51, 0x50, 0x7c, 0x78, 0x6d, 0x9e, 0xe1, 0x79, 0x41, 0x70, 0xa8, 0xc8, 0xe8 }

}
,
{{
  "RSAES-OAEP Encryption Example 2.1",
  /* Message to be encrypted */
  27,
  { 0x8f, 0xf0, 0x0c, 0xaa, 0x60, 0x5c, 0x70, 0x28, 0x30, 0x63, 0x4d, 0x9a, 0x6c, 0x3d, 0x42, 0xc6, 0x52, 0xb5, 0x8c, 0xf1, 0xd9, 0x2f, 0xec, 0x57, 0x0b, 0xee, 0xe7 }
,
  /* Seed */
  20,
  { 0x8c, 0x40, 0x7b, 0x5e, 0xc2, 0x89, 0x9e, 0x50, 0x99, 0xc5, 0x3e, 0x8c, 0xe7, 0x93, 0xbf, 0x94, 0xe7, 0x1b, 0x17, 0x82 }
,
  /* Encryption */
  129,
  { 0x01, 0x81, 0xaf, 0x89, 0x22, 0xb9, 0xfc, 0xb4, 0xd7, 0x9d, 0x92, 0xeb, 0xe1, 0x98, 0x15, 0x99, 0x2f, 0xc0, 0xc1, 0x43, 0x9d, 0x8b, 0xcd, 0x49, 0x13, 0x98, 0xa0, 0xf4, 0xad, 0x3a, 0x32, 0x9a, 0x5b, 0xd9, 0x38, 0x55, 0x60, 0xdb, 0x53, 0x26, 0x83, 0xc8, 0xb7, 0xda, 0x04, 0xe4, 0xb1, 0x2a, 0xed, 0x6a, 0xac, 0xdf, 0x47, 0x1c, 0x34, 0xc9, 0xcd, 0xa8, 0x91, 0xad, 0xdc, 0xc2, 0xdf, 0x34, 0x56, 0x65, 0x3a, 0xa6, 0x38, 0x2e, 0x9a, 0xe5, 0x9b, 0x54, 0x45, 0x52, 0x57, 0xeb, 0x09, 0x9d, 0x56, 0x2b, 0xbe, 0x10, 0x45, 0x3f, 0x2b, 0x6d, 0x13, 0xc5, 0x9c, 0x02, 0xe1, 0x0f, 0x1f, 0x8a, 0xbb, 0x5d, 0xa0, 0xd0, 0x57, 0x09, 0x32, 0xda, 0xcf, 0x2d, 0x09, 0x01, 0xdb, 0x72, 0x9d, 0x0f, 0xef, 0xcc, 0x05, 0x4e, 0x70, 0x96, 0x8e, 0xa5, 0x40, 0xc8, 0x1b, 0x04, 0xbc, 0xae, 0xfe, 0x72, 0x0e }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 2.2",
  /* Message to be encrypted */
  1,
  { 0x2d }
,
  /* Seed */
  20,
  { 0xb6, 0x00, 0xcf, 0x3c, 0x2e, 0x50, 0x6d, 0x7f, 0x16, 0x77, 0x8c, 0x91, 0x0d, 0x3a, 0x8b, 0x00, 0x3e, 0xee, 0x61, 0xd5 }
,
  /* Encryption */
  129,
  { 0x01, 0x87, 0x59, 0xff, 0x1d, 0xf6, 0x3b, 0x27, 0x92, 0x41, 0x05, 0x62, 0x31, 0x44, 0x16, 0xa8, 0xae, 0xaf, 0x2a, 0xc6, 0x34, 0xb4, 0x6f, 0x94, 0x0a, 0xb8, 0x2d, 0x64, 0xdb, 0xf1, 0x65, 0xee, 0xe3, 0x30, 0x11, 0xda, 0x74, 0x9d, 0x4b, 0xab, 0x6e, 0x2f, 0xcd, 0x18, 0x12, 0x9c, 0x9e, 0x49, 0x27, 0x7d, 0x84, 0x53, 0x11, 0x2b, 0x42, 0x9a, 0x22, 0x2a, 0x84, 0x71, 0xb0, 0x70, 0x99, 0x39, 0x98, 0xe7, 0x58, 0x86, 0x1c, 0x4d, 0x3f, 0x6d, 0x74, 0x9d, 0x91, 0xc4, 0x29, 0x0d, 0x33, 0x2c, 0x7a, 0x4a, 0xb3, 0xf7, 0xea, 0x35, 0xff, 0x3a, 0x07, 0xd4, 0x97, 0xc9, 0x55, 0xff, 0x0f, 0xfc, 0x95, 0x00, 0x6b, 0x62, 0xc6, 0xd2, 0x96, 0x81, 0x0d, 0x9b, 0xfa, 0xb0, 0x24, 0x19, 0x6c, 0x79, 0x34, 0x01, 0x2c, 0x2d, 0xf9, 0x78, 0xef, 0x29, 0x9a, 0xba, 0x23, 0x99, 0x40, 0xcb, 0xa1, 0x02, 0x45 }

}
,
{
  "RSAES-OAEP Encryption Example 2.3",
  /* Message to be encrypted */
  26,
  { 0x74, 0xfc, 0x88, 0xc5, 0x1b, 0xc9, 0x0f, 0x77, 0xaf, 0x9d, 0x5e, 0x9a, 0x4a, 0x70, 0x13, 0x3d, 0x4b, 0x4e, 0x0b, 0x34, 0xda, 0x3c, 0x37, 0xc7, 0xef, 0x8e }
,
  /* Seed */
  20,
  { 0xa7, 0x37, 0x68, 0xae, 0xea, 0xa9, 0x1f, 0x9d, 0x8c, 0x1e, 0xd6, 0xf9, 0xd2, 0xb6, 0x34, 0x67, 0xf0, 0x7c, 0xca, 0xe3 }
,
  /* Encryption */
  129,
  { 0x01, 0x88, 0x02, 0xba, 0xb0, 0x4c, 0x60, 0x32, 0x5e, 0x81, 0xc4, 0x96, 0x23, 0x11, 0xf2, 0xbe, 0x7c, 0x2a, 0xdc, 0xe9, 0x30, 0x41, 0xa0, 0x07, 0x19, 0xc8, 0x8f, 0x95, 0x75, 0x75, 0xf2, 0xc7, 0x9f, 0x1b, 0x7b, 0xc8, 0xce, 0xd1, 0x15, 0xc7, 0x06, 0xb3, 0x11, 0xc0, 0x8a, 0x2d, 0x98, 0x6c, 0xa3, 0xb6, 0xa9, 0x33, 0x6b, 0x14, 0x7c, 0x29, 0xc6, 0xf2, 0x29, 0x40, 0x9d, 0xde, 0xc6, 0x51, 0xbd, 0x1f, 0xdd, 0x5a, 0x0b, 0x7f, 0x61, 0x0c, 0x99, 0x37, 0xfd, 0xb4, 0xa3, 0xa7, 0x62, 0x36, 0x4b, 0x8b, 0x32, 0x06, 0xb4, 0xea, 0x48, 0x5f, 0xd0, 0x98, 0xd0, 0x8f, 0x63, 0xd4, 0xaa, 0x8b, 0xb2, 0x69, 0x7d, 0x02, 0x7b, 0x75, 0x0c, 0x32, 0xd7, 0xf7, 0x4e, 0xaf, 0x51, 0x80, 0xd2, 0xe9, 0xb6, 0x6b, 0x17, 0xcb, 0x2f, 0xa5, 0x55, 0x23, 0xbc, 0x28, 0x0d, 0xa1, 0x0d, 0x14, 0xbe, 0x20, 0x53 }

}
,
{
  "RSAES-OAEP Encryption Example 2.4",
  /* Message to be encrypted */
  53,
  { 0xa7, 0xeb, 0x2a, 0x50, 0x36, 0x93, 0x1d, 0x27, 0xd4, 0xe8, 0x91, 0x32, 0x6d, 0x99, 0x69, 0x2f, 0xfa, 0xdd, 0xa9, 0xbf, 0x7e, 0xfd, 0x3e, 0x34, 0xe6, 0x22, 0xc4, 0xad, 0xc0, 0x85, 0xf7, 0x21, 0xdf, 0xe8, 0x85, 0x07, 0x2c, 0x78, 0xa2, 0x03, 0xb1, 0x51, 0x73, 0x9b, 0xe5, 0x40, 0xfa, 0x8c, 0x15, 0x3a, 0x10, 0xf0, 0x0a }
,
  /* Seed */
  20,
  { 0x9a, 0x7b, 0x3b, 0x0e, 0x70, 0x8b, 0xd9, 0x6f, 0x81, 0x90, 0xec, 0xab, 0x4f, 0xb9, 0xb2, 0xb3, 0x80, 0x5a, 0x81, 0x56 }
,
  /* Encryption */
  129,
  { 0x00, 0xa4, 0x57, 0x8c, 0xbc, 0x17, 0x63, 0x18, 0xa6, 0x38, 0xfb, 0xa7, 0xd0, 0x1d, 0xf1, 0x57, 0x46, 0xaf, 0x44, 0xd4, 0xf6, 0xcd, 0x96, 0xd7, 0xe7, 0xc4, 0x95, 0xcb, 0xf4, 0x25, 0xb0, 0x9c, 0x64, 0x9d, 0x32, 0xbf, 0x88, 0x6d, 0xa4, 0x8f, 0xba, 0xf9, 0x89, 0xa2, 0x11, 0x71, 0x87, 0xca, 0xfb, 0x1f, 0xb5, 0x80, 0x31, 0x76, 0x90, 0xe3, 0xcc, 0xd4, 0x46, 0x92, 0x0b, 0x7a, 0xf8, 0x2b, 0x31, 0xdb, 0x58, 0x04, 0xd8, 0x7d, 0x01, 0x51, 0x4a, 0xcb, 0xfa, 0x91, 0x56, 0xe7, 0x82, 0xf8, 0x67, 0xf6, 0xbe, 0xd9, 0x44, 0x9e, 0x0e, 0x9a, 0x2c, 0x09, 0xbc, 0xec, 0xc6, 0xaa, 0x08, 0x76, 0x36, 0x96, 0x5e, 0x34, 0xb3, 0xec, 0x76, 0x6f, 0x2f, 0xe2, 0xe4, 0x30, 0x18, 0xa2, 0xfd, 0xde, 0xb1, 0x40, 0x61, 0x6a, 0x0e, 0x9d, 0x82, 0xe5, 0x33, 0x10, 0x24, 0xee, 0x06, 0x52, 0xfc, 0x76, 0x41 }

}
,
{
  "RSAES-OAEP Encryption Example 2.5",
  /* Message to be encrypted */
  19,
  { 0x2e, 0xf2, 0xb0, 0x66, 0xf8, 0x54, 0xc3, 0x3f, 0x3b, 0xdc, 0xbb, 0x59, 0x94, 0xa4, 0x35, 0xe7, 0x3d, 0x6c, 0x6c }
,
  /* Seed */
  20,
  { 0xeb, 0x3c, 0xeb, 0xbc, 0x4a, 0xdc, 0x16, 0xbb, 0x48, 0xe8, 0x8c, 0x8a, 0xec, 0x0e, 0x34, 0xaf, 0x7f, 0x42, 0x7f, 0xd3 }
,
  /* Encryption */
  129,
  { 0x00, 0xeb, 0xc5, 0xf5, 0xfd, 0xa7, 0x7c, 0xfd, 0xad, 0x3c, 0x83, 0x64, 0x1a, 0x90, 0x25, 0xe7, 0x7d, 0x72, 0xd8, 0xa6, 0xfb, 0x33, 0xa8, 0x10, 0xf5, 0x95, 0x0f, 0x8d, 0x74, 0xc7, 0x3e, 0x8d, 0x93, 0x1e, 0x86, 0x34, 0xd8, 0x6a, 0xb1, 0x24, 0x62, 0x56, 0xae, 0x07, 0xb6, 0x00, 0x5b, 0x71, 0xb7, 0xf2, 0xfb, 0x98, 0x35, 0x12, 0x18, 0x33, 0x1c, 0xe6, 0x9b, 0x8f, 0xfb, 0xdc, 0x9d, 0xa0, 0x8b, 0xbc, 0x9c, 0x70, 0x4f, 0x87, 0x6d, 0xeb, 0x9d, 0xf9, 0xfc, 0x2e, 0xc0, 0x65, 0xca, 0xd8, 0x7f, 0x90, 0x90, 0xb0, 0x7a, 0xcc, 0x17, 0xaa, 0x7f, 0x99, 0x7b, 0x27, 0xac, 0xa4, 0x88, 0x06, 0xe8, 0x97, 0xf7, 0x71, 0xd9, 0x51, 0x41, 0xfe, 0x45, 0x26, 0xd8, 0xa5, 0x30, 0x1b, 0x67, 0x86, 0x27, 0xef, 0xab, 0x70, 0x7f, 0xd4, 0x0f, 0xbe, 0xbd, 0x6e, 0x79, 0x2a, 0x25, 0x61, 0x3e, 0x7a, 0xec }

}
,
{
  "RSAES-OAEP Encryption Example 2.6",
  /* Message to be encrypted */
  22,
  { 0x8a, 0x7f, 0xb3, 0x44, 0xc8, 0xb6, 0xcb, 0x2c, 0xf2, 0xef, 0x1f, 0x64, 0x3f, 0x9a, 0x32, 0x18, 0xf6, 0xe1, 0x9b, 0xba, 0x89, 0xc0 }
,
  /* Seed */
  20,
  { 0x4c, 0x45, 0xcf, 0x4d, 0x57, 0xc9, 0x8e, 0x3d, 0x6d, 0x20, 0x95, 0xad, 0xc5, 0x1c, 0x48, 0x9e, 0xb5, 0x0d, 0xff, 0x84 }
,
  /* Encryption */
  129,
  { 0x01, 0x08, 0x39, 0xec, 0x20, 0xc2, 0x7b, 0x90, 0x52, 0xe5, 0x5b, 0xef, 0xb9, 0xb7, 0x7e, 0x6f, 0xc2, 0x6e, 0x90, 0x75, 0xd7, 0xa5, 0x43, 0x78, 0xc6, 0x46, 0xab, 0xdf, 0x51, 0xe4, 0x45, 0xbd, 0x57, 0x15, 0xde, 0x81, 0x78, 0x9f, 0x56, 0xf1, 0x80, 0x3d, 0x91, 0x70, 0x76, 0x4a, 0x9e, 0x93, 0xcb, 0x78, 0x79, 0x86, 0x94, 0x02, 0x3e, 0xe7, 0x39, 0x3c, 0xe0, 0x4b, 0xc5, 0xd8, 0xf8, 0xc5, 0xa5, 0x2c, 0x17, 0x1d, 0x43, 0x83, 0x7e, 0x3a, 0xca, 0x62, 0xf6, 0x09, 0xeb, 0x0a, 0xa5, 0xff, 0xb0, 0x96, 0x0e, 0xf0, 0x41, 0x98, 0xdd, 0x75, 0x4f, 0x57, 0xf7, 0xfb, 0xe6, 0xab, 0xf7, 0x65, 0xcf, 0x11, 0x8b, 0x4c, 0xa4, 0x43, 0xb2, 0x3b, 0x5a, 0xab, 0x26, 0x6f, 0x95, 0x23, 0x26, 0xac, 0x45, 0x81, 0x10, 0x06, 0x44, 0x32, 0x5f, 0x8b, 0x72, 0x1a, 0xcd, 0x5d, 0x04, 0xff, 0x14, 0xef, 0x3a }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 3: A 1026-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x02, 0xb5, 0x8f, 0xec, 0x03, 0x9a, 0x86, 0x07, 0x00, 0xa4, 0xd7, 0xb6, 0x46, 0x2f, 0x93, 0xe6, 0xcd, 0xd4, 0x91, 0x16, 0x1d, 0xdd, 0x74, 0xf4, 0xe8, 0x10, 0xb4, 0x0e, 0x3c, 0x16, 0x52, 0x00, 0x6a, 0x5c, 0x27, 0x7b, 0x27, 0x74, 0xc1, 0x13, 0x05, 0xa4, 0xcb, 0xab, 0x5a, 0x78, 0xef, 0xa5, 0x7e, 0x17, 0xa8, 0x6d, 0xf7, 0xa3, 0xfa, 0x36, 0xfc, 0x4b, 0x1d, 0x22, 0x49, 0xf2, 0x2e, 0xc7, 0xc2, 0xdd, 0x6a, 0x46, 0x32, 0x32, 0xac, 0xce, 0xa9, 0x06, 0xd6, 0x6e, 0xbe, 0x80, 0xb5, 0x70, 0x4b, 0x10, 0x72, 0x9d, 0xa6, 0xf8, 0x33, 0x23, 0x4a, 0xbb, 0x5e, 0xfd, 0xd4, 0xa2, 0x92, 0xcb, 0xfa, 0xd3, 0x3b, 0x4d, 0x33, 0xfa, 0x7a, 0x14, 0xb8, 0xc3, 0x97, 0xb5, 0x6e, 0x3a, 0xcd, 0x21, 0x20, 0x34, 0x28, 0xb7, 0x7c, 0xdf, 0xa3, 0x3a, 0x6d, 0xa7, 0x06, 0xb3, 0xd8, 0xb0, 0xfc, 0x43, 0xe9 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x15, 0xb4, 0x8a, 0x5b, 0x56, 0x83, 0xa9, 0x46, 0x70, 0xe2, 0x3b, 0x57, 0x18, 0xf8, 0x14, 0xfa, 0x0e, 0x13, 0xf8, 0x50, 0x38, 0xf5, 0x07, 0x11, 0x18, 0x2c, 0xba, 0x61, 0x51, 0x05, 0x81, 0xf3, 0xd2, 0x2c, 0x7e, 0x23, 0x2e, 0xf9, 0x37, 0xe2, 0x2e, 0x55, 0x1d, 0x68, 0xb8, 0x6e, 0x2f, 0x8c, 0xb1, 0xaa, 0xd8, 0xbe, 0x2e, 0x48, 0x8f, 0x5d, 0xf7, 0xef, 0xd2, 0x79, 0xe3, 0xf5, 0x68, 0xd4, 0xea, 0xf3, 0x6f, 0x80, 0xcf, 0x71, 0x41, 0xac, 0xe6, 0x0f, 0xcc, 0x91, 0x13, 0xfb, 0x6c, 0x4a, 0x84, 0x1f, 0xd5, 0x0b, 0xbc, 0x7c, 0x51, 0x2f, 0xfc, 0xbe, 0xff, 0x21, 0x48, 0x7a, 0xa8, 0x11, 0xeb, 0x3c, 0xa8, 0xc6, 0x20, 0x05, 0x34, 0x6a, 0x86, 0xde, 0x86, 0xbf, 0xa1, 0xd8, 0xa9, 0x48, 0xfd, 0x3f, 0x34, 0x8c, 0x22, 0xea, 0xad, 0xf3, 0x33, 0xc3, 0xce, 0x6c, 0xe1, 0x32, 0x08, 0xfd }
,
  /* Prime p */
  65,
  { 0x01, 0xbf, 0x01, 0xd2, 0x16, 0xd7, 0x35, 0x95, 0xcf, 0x02, 0x70, 0xc2, 0xbe, 0xb7, 0x8d, 0x40, 0xa0, 0xd8, 0x44, 0x7d, 0x31, 0xda, 0x91, 0x9a, 0x98, 0x3f, 0x7e, 0xea, 0x78, 0x1b, 0x77, 0xd8, 0x5f, 0xe3, 0x71, 0xb3, 0xe9, 0x37, 0x3e, 0x7b, 0x69, 0x21, 0x7d, 0x31, 0x50, 0xa0, 0x2d, 0x89, 0x58, 0xde, 0x7f, 0xad, 0x9d, 0x55, 0x51, 0x60, 0x95, 0x8b, 0x44, 0x54, 0x12, 0x7e, 0x0e, 0x7e, 0xaf }
,
  /* Prime q */
  65,
  { 0x01, 0x8d, 0x33, 0x99, 0x65, 0x81, 0x66, 0xdb, 0x38, 0x29, 0x81, 0x6d, 0x7b, 0x29, 0x54, 0x16, 0x75, 0x9e, 0x9c, 0x91, 0x98, 0x7f, 0x5b, 0x2d, 0x8a, 0xec, 0xd6, 0x3b, 0x04, 0xb4, 0x8b, 0xd7, 0xb2, 0xfc, 0xf2, 0x29, 0xbb, 0x7f, 0x8a, 0x6d, 0xc8, 0x8b, 0xa1, 0x3d, 0xd2, 0xe3, 0x9a, 0xd5, 0x5b, 0x6d, 0x1a, 0x06, 0x16, 0x07, 0x08, 0xf9, 0x70, 0x0b, 0xe8, 0x0b, 0x8f, 0xd3, 0x74, 0x4c, 0xe7 }
,
  /* p's CRT exponent dP */
  64,
  { 0x06, 0xc0, 0xa2, 0x49, 0xd2, 0x0a, 0x6f, 0x2e, 0xe7, 0x5c, 0x88, 0xb4, 0x94, 0xd5, 0x3f, 0x6a, 0xae, 0x99, 0xaa, 0x42, 0x7c, 0x88, 0xc2, 0x8b, 0x16, 0x3a, 0x76, 0x94, 0x45, 0xe5, 0xf3, 0x90, 0xcf, 0x40, 0xc2, 0x74, 0xfd, 0x6e, 0xa6, 0x32, 0x9a, 0x5c, 0xe7, 0xc7, 0xce, 0x03, 0xa2, 0x15, 0x83, 0x96, 0xee, 0x2a, 0x78, 0x45, 0x78, 0x6e, 0x09, 0xe2, 0x88, 0x5a, 0x97, 0x28, 0xe4, 0xe5 }
,
  /* q's CRT exponent dQ */
  64,
  { 0xd1, 0xd2, 0x7c, 0x29, 0xfe, 0xdd, 0x92, 0xd8, 0x6c, 0x34, 0x8e, 0xdd, 0x0c, 0xcb, 0xfa, 0xc1, 0x4f, 0x74, 0x6e, 0x05, 0x1c, 0xe1, 0xd1, 0x81, 0x1d, 0xf3, 0x5d, 0x61, 0xf2, 0xee, 0x1c, 0x97, 0xd4, 0xbf, 0x28, 0x04, 0x80, 0x2f, 0x64, 0x27, 0x18, 0x7b, 0xa8, 0xe9, 0x0a, 0x8a, 0xf4, 0x42, 0x43, 0xb4, 0x07, 0x9b, 0x03, 0x44, 0x5e, 0x60, 0x2e, 0x29, 0xfa, 0x51, 0x93, 0xe6, 0x4f, 0xe9 }
,
  /* CRT coefficient qInv */
  64,
  { 0x8c, 0xb2, 0xf7, 0x56, 0xbd, 0x89, 0x41, 0xb1, 0xd3, 0xb7, 0x70, 0xe5, 0xad, 0x31, 0xee, 0x37, 0x3b, 0x28, 0xac, 0xda, 0x69, 0xff, 0x9b, 0x6f, 0x40, 0xfe, 0x57, 0x8b, 0x9f, 0x1a, 0xfb, 0x85, 0x83, 0x6f, 0x96, 0x27, 0xd3, 0x7a, 0xcf, 0xf7, 0x3c, 0x27, 0x79, 0xe6, 0x34, 0xbb, 0x26, 0x01, 0x1c, 0x2c, 0x8f, 0x7f, 0x33, 0x61, 0xae, 0x2a, 0x9e, 0xa6, 0x5e, 0xd6, 0x89, 0xe3, 0x63, 0x9a }

}
,
{{
  "RSAES-OAEP Encryption Example 3.1",
  /* Message to be encrypted */
  8,
  { 0x08, 0x78, 0x20, 0xb5, 0x69, 0xe8, 0xfa, 0x8d }
,
  /* Seed */
  20,
  { 0x8c, 0xed, 0x6b, 0x19, 0x62, 0x90, 0x80, 0x57, 0x90, 0xe9, 0x09, 0x07, 0x40, 0x15, 0xe6, 0xa2, 0x0b, 0x0c, 0x48, 0x94 }
,
  /* Encryption */
  129,
  { 0x02, 0x6a, 0x04, 0x85, 0xd9, 0x6a, 0xeb, 0xd9, 0x6b, 0x43, 0x82, 0x08, 0x50, 0x99, 0xb9, 0x62, 0xe6, 0xa2, 0xbd, 0xec, 0x3d, 0x90, 0xc8, 0xdb, 0x62, 0x5e, 0x14, 0x37, 0x2d, 0xe8, 0x5e, 0x2d, 0x5b, 0x7b, 0xaa, 0xb6, 0x5c, 0x8f, 0xaf, 0x91, 0xbb, 0x55, 0x04, 0xfb, 0x49, 0x5a, 0xfc, 0xe5, 0xc9, 0x88, 0xb3, 0xf6, 0xa5, 0x2e, 0x20, 0xe1, 0xd6, 0xcb, 0xd3, 0x56, 0x6c, 0x5c, 0xd1, 0xf2, 0xb8, 0x31, 0x8b, 0xb5, 0x42, 0xcc, 0x0e, 0xa2, 0x5c, 0x4a, 0xab, 0x99, 0x32, 0xaf, 0xa2, 0x07, 0x60, 0xea, 0xdd, 0xec, 0x78, 0x43, 0x96, 0xa0, 0x7e, 0xa0, 0xef, 0x24, 0xd4, 0xe6, 0xf4, 0xd3, 0x7e, 0x50, 0x52, 0xa7, 0xa3, 0x1e, 0x14, 0x6a, 0xa4, 0x80, 0xa1, 0x11, 0xbb, 0xe9, 0x26, 0x40, 0x13, 0x07, 0xe0, 0x0f, 0x41, 0x00, 0x33, 0x84, 0x2b, 0x6d, 0x82, 0xfe, 0x5c, 0xe4, 0xdf, 0xae, 0x80 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 3.2",
  /* Message to be encrypted */
  28,
  { 0x46, 0x53, 0xac, 0xaf, 0x17, 0x19, 0x60, 0xb0, 0x1f, 0x52, 0xa7, 0xbe, 0x63, 0xa3, 0xab, 0x21, 0xdc, 0x36, 0x8e, 0xc4, 0x3b, 0x50, 0xd8, 0x2e, 0xc3, 0x78, 0x1e, 0x04 }
,
  /* Seed */
  20,
  { 0xb4, 0x29, 0x1d, 0x65, 0x67, 0x55, 0x08, 0x48, 0xcc, 0x15, 0x69, 0x67, 0xc8, 0x09, 0xba, 0xab, 0x6c, 0xa5, 0x07, 0xf0 }
,
  /* Encryption */
  129,
  { 0x02, 0x4d, 0xb8, 0x9c, 0x78, 0x02, 0x98, 0x9b, 0xe0, 0x78, 0x38, 0x47, 0x86, 0x30, 0x84, 0x94, 0x1b, 0xf2, 0x09, 0xd7, 0x61, 0x98, 0x7e, 0x38, 0xf9, 0x7c, 0xb5, 0xf6, 0xf1, 0xbc, 0x88, 0xda, 0x72, 0xa5, 0x0b, 0x73, 0xeb, 0xaf, 0x11, 0xc8, 0x79, 0xc4, 0xf9, 0x5d, 0xf3, 0x7b, 0x85, 0x0b, 0x8f, 0x65, 0xd7, 0x62, 0x2e, 0x25, 0xb1, 0xb8, 0x89, 0xe8, 0x0f, 0xe8, 0x0b, 0xac, 0xa2, 0x06, 0x9d, 0x6e, 0x0e, 0x1d, 0x82, 0x99, 0x53, 0xfc, 0x45, 0x90, 0x69, 0xde, 0x98, 0xea, 0x97, 0x98, 0xb4, 0x51, 0xe5, 0x57, 0xe9, 0x9a, 0xbf, 0x8f, 0xe3, 0xd9, 0xcc, 0xf9, 0x09, 0x6e, 0xbb, 0xf3, 0xe5, 0x25, 0x5d, 0x3b, 0x4e, 0x1c, 0x6d, 0x2e, 0xca, 0xdf, 0x06, 0x7a, 0x35, 0x9e, 0xea, 0x86, 0x40, 0x5a, 0xcd, 0x47, 0xd5, 0xe1, 0x65, 0x51, 0x7c, 0xca, 0xfd, 0x47, 0xd6, 0xdb, 0xee, 0x4b, 0xf5 }

}
,
{
  "RSAES-OAEP Encryption Example 3.3",
  /* Message to be encrypted */
  9,
  { 0xd9, 0x4c, 0xd0, 0xe0, 0x8f, 0xa4, 0x04, 0xed, 0x89 }
,
  /* Seed */
  20,
  { 0xce, 0x89, 0x28, 0xf6, 0x05, 0x95, 0x58, 0x25, 0x40, 0x08, 0xba, 0xdd, 0x97, 0x94, 0xfa, 0xdc, 0xd2, 0xfd, 0x1f, 0x65 }
,
  /* Encryption */
  129,
  { 0x02, 0x39, 0xbc, 0xe6, 0x81, 0x03, 0x24, 0x41, 0x52, 0x88, 0x77, 0xd6, 0xd1, 0xc8, 0xbb, 0x28, 0xaa, 0x3b, 0xc9, 0x7f, 0x1d, 0xf5, 0x84, 0x56, 0x36, 0x18, 0x99, 0x57, 0x97, 0x68, 0x38, 0x44, 0xca, 0x86, 0x66, 0x47, 0x32, 0xf4, 0xbe, 0xd7, 0xa0, 0xaa, 0xb0, 0x83, 0xaa, 0xab, 0xfb, 0x72, 0x38, 0xf5, 0x82, 0xe3, 0x09, 0x58, 0xc2, 0x02, 0x4e, 0x44, 0xe5, 0x70, 0x43, 0xb9, 0x79, 0x50, 0xfd, 0x54, 0x3d, 0xa9, 0x77, 0xc9, 0x0c, 0xdd, 0xe5, 0x33, 0x7d, 0x61, 0x84, 0x42, 0xf9, 0x9e, 0x60, 0xd7, 0x78, 0x3a, 0xb5, 0x9c, 0xe6, 0xdd, 0x9d, 0x69, 0xc4, 0x7a, 0xd1, 0xe9, 0x62, 0xbe, 0xc2, 0x2d, 0x05, 0x89, 0x5c, 0xff, 0x8d, 0x3f, 0x64, 0xed, 0x52, 0x61, 0xd9, 0x2b, 0x26, 0x78, 0x51, 0x03, 0x93, 0x48, 0x49, 0x90, 0xba, 0x3f, 0x7f, 0x06, 0x81, 0x8a, 0xe6, 0xff, 0xce, 0x8a, 0x3a }

}
,
{
  "RSAES-OAEP Encryption Example 3.4",
  /* Message to be encrypted */
  18,
  { 0x6c, 0xc6, 0x41, 0xb6, 0xb6, 0x1e, 0x6f, 0x96, 0x39, 0x74, 0xda, 0xd2, 0x3a, 0x90, 0x13, 0x28, 0x4e, 0xf1 }
,
  /* Seed */
  20,
  { 0x6e, 0x29, 0x79, 0xf5, 0x2d, 0x68, 0x14, 0xa5, 0x7d, 0x83, 0xb0, 0x90, 0x05, 0x48, 0x88, 0xf1, 0x19, 0xa5, 0xb9, 0xa3 }
,
  /* Encryption */
  129,
  { 0x02, 0x99, 0x4c, 0x62, 0xaf, 0xd7, 0x6f, 0x49, 0x8b, 0xa1, 0xfd, 0x2c, 0xf6, 0x42, 0x85, 0x7f, 0xca, 0x81, 0xf4, 0x37, 0x3c, 0xb0, 0x8f, 0x1c, 0xba, 0xee, 0x6f, 0x02, 0x5c, 0x3b, 0x51, 0x2b, 0x42, 0xc3, 0xe8, 0x77, 0x91, 0x13, 0x47, 0x66, 0x48, 0x03, 0x9d, 0xbe, 0x04, 0x93, 0xf9, 0x24, 0x62, 0x92, 0xfa, 0xc2, 0x89, 0x50, 0x60, 0x0e, 0x7c, 0x0f, 0x32, 0xed, 0xf9, 0xc8, 0x1b, 0x9d, 0xec, 0x45, 0xc3, 0xbd, 0xe0, 0xcc, 0x8d, 0x88, 0x47, 0x59, 0x01, 0x69, 0x90, 0x7b, 0x7d, 0xc5, 0x99, 0x1c, 0xeb, 0x29, 0xbb, 0x07, 0x14, 0xd6, 0x13, 0xd9, 0x6d, 0xf0, 0xf1, 0x2e, 0xc5, 0xd8, 0xd3, 0x50, 0x7c, 0x8e, 0xe7, 0xae, 0x78, 0xdd, 0x83, 0xf2, 0x16, 0xfa, 0x61, 0xde, 0x10, 0x03, 0x63, 0xac, 0xa4, 0x8a, 0x7e, 0x91, 0x4a, 0xe9, 0xf4, 0x2d, 0xdf, 0xbe, 0x94, 0x3b, 0x09, 0xd9, 0xa0 }

}
,
{
  "RSAES-OAEP Encryption Example 3.5",
  /* Message to be encrypted */
  46,
  { 0xdf, 0x51, 0x51, 0x83, 0x2b, 0x61, 0xf4, 0xf2, 0x58, 0x91, 0xfb, 0x41, 0x72, 0xf3, 0x28, 0xd2, 0xed, 0xdf, 0x83, 0x71, 0xff, 0xcf, 0xdb, 0xe9, 0x97, 0x93, 0x92, 0x95, 0xf3, 0x0e, 0xca, 0x69, 0x18, 0x01, 0x7c, 0xfd, 0xa1, 0x15, 0x3b, 0xf7, 0xa6, 0xaf, 0x87, 0x59, 0x32, 0x23 }
,
  /* Seed */
  20,
  { 0x2d, 0x76, 0x0b, 0xfe, 0x38, 0xc5, 0x9d, 0xe3, 0x4c, 0xdc, 0x8b, 0x8c, 0x78, 0xa3, 0x8e, 0x66, 0x28, 0x4a, 0x2d, 0x27 }
,
  /* Encryption */
  129,
  { 0x01, 0x62, 0x04, 0x2f, 0xf6, 0x96, 0x95, 0x92, 0xa6, 0x16, 0x70, 0x31, 0x81, 0x1a, 0x23, 0x98, 0x34, 0xce, 0x63, 0x8a, 0xbf, 0x54, 0xfe, 0xc8, 0xb9, 0x94, 0x78, 0x12, 0x2a, 0xfe, 0x2e, 0xe6, 0x7f, 0x8c, 0x5b, 0x18, 0xb0, 0x33, 0x98, 0x05, 0xbf, 0xdb, 0xc5, 0xa4, 0xe6, 0x72, 0x0b, 0x37, 0xc5, 0x9c, 0xfb, 0xa9, 0x42, 0x46, 0x4c, 0x59, 0x7f, 0xf5, 0x32, 0xa1, 0x19, 0x82, 0x15, 0x45, 0xfd, 0x2e, 0x59, 0xb1, 0x14, 0xe6, 0x1d, 0xaf, 0x71, 0x82, 0x05, 0x29, 0xf5, 0x02, 0x9c, 0xf5, 0x24, 0x95, 0x43, 0x27, 0xc3, 0x4e, 0xc5, 0xe6, 0xf5, 0xba, 0x7e, 0xfc, 0xc4, 0xde, 0x94, 0x3a, 0xb8, 0xad, 0x4e, 0xd7, 0x87, 0xb1, 0x45, 0x43, 0x29, 0xf7, 0x0d, 0xb7, 0x98, 0xa3, 0xa8, 0xf4, 0xd9, 0x2f, 0x82, 0x74, 0xe2, 0xb2, 0x94, 0x8a, 0xde, 0x62, 0x7c, 0xe8, 0xee, 0x33, 0xe4, 0x3c, 0x60 }

}
,
{
  "RSAES-OAEP Encryption Example 3.6",
  /* Message to be encrypted */
  56,
  { 0x3c, 0x3b, 0xad, 0x89, 0x3c, 0x54, 0x4a, 0x6d, 0x52, 0x0a, 0xb0, 0x22, 0x31, 0x91, 0x88, 0xc8, 0xd5, 0x04, 0xb7, 0xa7, 0x88, 0xb8, 0x50, 0x90, 0x3b, 0x85, 0x97, 0x2e, 0xaa, 0x18, 0x55, 0x2e, 0x11, 0x34, 0xa7, 0xad, 0x60, 0x98, 0x82, 0x62, 0x54, 0xff, 0x7a, 0xb6, 0x72, 0xb3, 0xd8, 0xeb, 0x31, 0x58, 0xfa, 0xc6, 0xd4, 0xcb, 0xae, 0xf1 }
,
  /* Seed */
  20,
  { 0xf1, 0x74, 0x77, 0x9c, 0x5f, 0xd3, 0xcf, 0xe0, 0x07, 0xba, 0xdc, 0xb7, 0xa3, 0x6c, 0x9b, 0x55, 0xbf, 0xcf, 0xbf, 0x0e }
,
  /* Encryption */
  129,
  { 0x00, 0x11, 0x20, 0x51, 0xe7, 0x5d, 0x06, 0x49, 0x43, 0xbc, 0x44, 0x78, 0x07, 0x5e, 0x43, 0x48, 0x2f, 0xd5, 0x9c, 0xee, 0x06, 0x79, 0xde, 0x68, 0x93, 0xee, 0xc3, 0xa9, 0x43, 0xda, 0xa4, 0x90, 0xb9, 0x69, 0x1c, 0x93, 0xdf, 0xc0, 0x46, 0x4b, 0x66, 0x23, 0xb9, 0xf3, 0xdb, 0xd3, 0xe7, 0x00, 0x83, 0x26, 0x4f, 0x03, 0x4b, 0x37, 0x4f, 0x74, 0x16, 0x4e, 0x1a, 0x00, 0x76, 0x37, 0x25, 0xe5, 0x74, 0x74, 0x4b, 0xa0, 0xb9, 0xdb, 0x83, 0x43, 0x4f, 0x31, 0xdf, 0x96, 0xf6, 0xe2, 0xa2, 0x6f, 0x6d, 0x8e, 0xba, 0x34, 0x8b, 0xd4, 0x68, 0x6c, 0x22, 0x38, 0xac, 0x07, 0xc3, 0x7a, 0xac, 0x37, 0x85, 0xd1, 0xc7, 0xee, 0xa2, 0xf8, 0x19, 0xfd, 0x91, 0x49, 0x17, 0x98, 0xed, 0x8e, 0x9c, 0xef, 0x5e, 0x43, 0xb7, 0x81, 0xb0, 0xe0, 0x27, 0x6e, 0x37, 0xc4, 0x3f, 0xf9, 0x49, 0x2d, 0x00, 0x57, 0x30 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 4: A 1027-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x05, 0x12, 0x40, 0xb6, 0xcc, 0x00, 0x04, 0xfa, 0x48, 0xd0, 0x13, 0x46, 0x71, 0xc0, 0x78, 0xc7, 0xc8, 0xde, 0xc3, 0xb3, 0xe2, 0xf2, 0x5b, 0xc2, 0x56, 0x44, 0x67, 0x33, 0x9d, 0xb3, 0x88, 0x53, 0xd0, 0x6b, 0x85, 0xee, 0xa5, 0xb2, 0xde, 0x35, 0x3b, 0xff, 0x42, 0xac, 0x2e, 0x46, 0xbc, 0x97, 0xfa, 0xe6, 0xac, 0x96, 0x18, 0xda, 0x95, 0x37, 0xa5, 0xc8, 0xf5, 0x53, 0xc1, 0xe3, 0x57, 0x62, 0x59, 0x91, 0xd6, 0x10, 0x8d, 0xcd, 0x78, 0x85, 0xfb, 0x3a, 0x25, 0x41, 0x3f, 0x53, 0xef, 0xca, 0xd9, 0x48, 0xcb, 0x35, 0xcd, 0x9b, 0x9a, 0xe9, 0xc1, 0xc6, 0x76, 0x26, 0xd1, 0x13, 0xd5, 0x7d, 0xde, 0x4c, 0x5b, 0xea, 0x76, 0xbb, 0x5b, 0xb7, 0xde, 0x96, 0xc0, 0x0d, 0x07, 0x37, 0x2e, 0x96, 0x85, 0xa6, 0xd7, 0x5c, 0xf9, 0xd2, 0x39, 0xfa, 0x14, 0x8d, 0x70, 0x93, 0x1b, 0x5f, 0x3f, 0xb0, 0x39 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x04, 0x11, 0xff, 0xca, 0x3b, 0x7c, 0xa5, 0xe9, 0xe9, 0xbe, 0x7f, 0xe3, 0x8a, 0x85, 0x10, 0x5e, 0x35, 0x38, 0x96, 0xdb, 0x05, 0xc5, 0x79, 0x6a, 0xec, 0xd2, 0xa7, 0x25, 0x16, 0x1e, 0xb3, 0x65, 0x1c, 0x86, 0x29, 0xa9, 0xb8, 0x62, 0xb9, 0x04, 0xd7, 0xb0, 0xc7, 0xb3, 0x7f, 0x8c, 0xb5, 0xa1, 0xc2, 0xb5, 0x40, 0x01, 0x01, 0x8a, 0x00, 0xa1, 0xeb, 0x2c, 0xaf, 0xe4, 0xee, 0x4e, 0x94, 0x92, 0xc3, 0x48, 0xbc, 0x2b, 0xed, 0xab, 0x4b, 0x9e, 0xbb, 0xf0, 0x64, 0xe8, 0xef, 0xf3, 0x22, 0xb9, 0x00, 0x9f, 0x8e, 0xec, 0x65, 0x39, 0x05, 0xf4, 0x0d, 0xf8, 0x8a, 0x3c, 0xdc, 0x49, 0xd4, 0x56, 0x7f, 0x75, 0x62, 0x7d, 0x41, 0xac, 0xa6, 0x24, 0x12, 0x9b, 0x46, 0xa0, 0xb7, 0xc6, 0x98, 0xe5, 0xe6, 0x5f, 0x2b, 0x7b, 0xa1, 0x02, 0xc7, 0x49, 0xa1, 0x01, 0x35, 0xb6, 0x54, 0x0d, 0x04, 0x01 }
,
  /* Prime p */
  65,
  { 0x02, 0x74, 0x58, 0xc1, 0x9e, 0xc1, 0x63, 0x69, 0x19, 0xe7, 0x36, 0xc9, 0xaf, 0x25, 0xd6, 0x09, 0xa5, 0x1b, 0x8f, 0x56, 0x1d, 0x19, 0xc6, 0xbf, 0x69, 0x43, 0xdd, 0x1e, 0xe1, 0xab, 0x8a, 0x4a, 0x3f, 0x23, 0x21, 0x00, 0xbd, 0x40, 0xb8, 0x8d, 0xec, 0xc6, 0xba, 0x23, 0x55, 0x48, 0xb6, 0xef, 0x79, 0x2a, 0x11, 0xc9, 0xde, 0x82, 0x3d, 0x0a, 0x79, 0x22, 0xc7, 0x09, 0x5b, 0x6e, 0xba, 0x57, 0x01 }
,
  /* Prime q */
  65,
  { 0x02, 0x10, 0xee, 0x9b, 0x33, 0xab, 0x61, 0x71, 0x6e, 0x27, 0xd2, 0x51, 0xbd, 0x46, 0x5f, 0x4b, 0x35, 0xa1, 0xa2, 0x32, 0xe2, 0xda, 0x00, 0x90, 0x1c, 0x29, 0x4b, 0xf2, 0x23, 0x50, 0xce, 0x49, 0x0d, 0x09, 0x9f, 0x64, 0x2b, 0x53, 0x75, 0x61, 0x2d, 0xb6, 0x3b, 0xa1, 0xf2, 0x03, 0x86, 0x49, 0x2b, 0xf0, 0x4d, 0x34, 0xb3, 0xc2, 0x2b, 0xce, 0xb9, 0x09, 0xd1, 0x34, 0x41, 0xb5, 0x3b, 0x51, 0x39 }
,
  /* p's CRT exponent dP */
  64,
  { 0x39, 0xfa, 0x02, 0x8b, 0x82, 0x6e, 0x88, 0xc1, 0x12, 0x1b, 0x75, 0x0a, 0x8b, 0x24, 0x2f, 0xa9, 0xa3, 0x5c, 0x5b, 0x66, 0xbd, 0xfd, 0x1f, 0xa6, 0x37, 0xd3, 0xcc, 0x48, 0xa8, 0x4a, 0x4f, 0x45, 0x7a, 0x19, 0x4e, 0x77, 0x27, 0xe4, 0x9f, 0x7b, 0xcc, 0x6e, 0x5a, 0x5a, 0x41, 0x26, 0x57, 0xfc, 0x47, 0x0c, 0x73, 0x22, 0xeb, 0xc3, 0x74, 0x16, 0xef, 0x45, 0x8c, 0x30, 0x7a, 0x8c, 0x09, 0x01 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x01, 0x5d, 0x99, 0xa8, 0x41, 0x95, 0x94, 0x39, 0x79, 0xfa, 0x9e, 0x1b, 0xe2, 0xc3, 0xc1, 0xb6, 0x9f, 0x43, 0x2f, 0x46, 0xfd, 0x03, 0xe4, 0x7d, 0x5b, 0xef, 0xbb, 0xbf, 0xd6, 0xb1, 0xd1, 0x37, 0x1d, 0x83, 0xef, 0xb3, 0x30, 0xa3, 0xe0, 0x20, 0x94, 0x2b, 0x2f, 0xed, 0x11, 0x5e, 0x5d, 0x02, 0xbe, 0x24, 0xfd, 0x92, 0xc9, 0x01, 0x9d, 0x1c, 0xec, 0xd6, 0xdd, 0x4c, 0xf1, 0xe5, 0x4c, 0xc8, 0x99 }
,
  /* CRT coefficient qInv */
  65,
  { 0x01, 0xf0, 0xb7, 0x01, 0x51, 0x70, 0xb3, 0xf5, 0xe4, 0x22, 0x23, 0xba, 0x30, 0x30, 0x1c, 0x41, 0xa6, 0xd8, 0x7c, 0xbb, 0x70, 0xe3, 0x0c, 0xb7, 0xd3, 0xc6, 0x7d, 0x25, 0x47, 0x3d, 0xb1, 0xf6, 0xcb, 0xf0, 0x3e, 0x3f, 0x91, 0x26, 0xe3, 0xe9, 0x79, 0x68, 0x27, 0x9a, 0x86, 0x5b, 0x2c, 0x2b, 0x42, 0x65, 0x24, 0xcf, 0xc5, 0x2a, 0x68, 0x3d, 0x31, 0xed, 0x30, 0xeb, 0x98, 0x4b, 0xe4, 0x12, 0xba }

}
,
{{
  "RSAES-OAEP Encryption Example 4.1",
  /* Message to be encrypted */
  56,
  { 0x4a, 0x86, 0x60, 0x95, 0x34, 0xee, 0x43, 0x4a, 0x6c, 0xbc, 0xa3, 0xf7, 0xe9, 0x62, 0xe7, 0x6d, 0x45, 0x5e, 0x32, 0x64, 0xc1, 0x9f, 0x60, 0x5f, 0x6e, 0x5f, 0xf6, 0x13, 0x7c, 0x65, 0xc5, 0x6d, 0x7f, 0xb3, 0x44, 0xcd, 0x52, 0xbc, 0x93, 0x37, 0x4f, 0x3d, 0x16, 0x6c, 0x9f, 0x0c, 0x6f, 0x9c, 0x50, 0x6b, 0xad, 0x19, 0x33, 0x09, 0x72, 0xd2 }
,
  /* Seed */
  20,
  { 0x1c, 0xac, 0x19, 0xce, 0x99, 0x3d, 0xef, 0x55, 0xf9, 0x82, 0x03, 0xf6, 0x85, 0x28, 0x96, 0xc9, 0x5c, 0xcc, 0xa1, 0xf3 }
,
  /* Encryption */
  129,
  { 0x04, 0xcc, 0xe1, 0x96, 0x14, 0x84, 0x5e, 0x09, 0x41, 0x52, 0xa3, 0xfe, 0x18, 0xe5, 0x4e, 0x33, 0x30, 0xc4, 0x4e, 0x5e, 0xfb, 0xc6, 0x4a, 0xe1, 0x68, 0x86, 0xcb, 0x18, 0x69, 0x01, 0x4c, 0xc5, 0x78, 0x1b, 0x1f, 0x8f, 0x9e, 0x04, 0x53, 0x84, 0xd0, 0x11, 0x2a, 0x13, 0x5c, 0xa0, 0xd1, 0x2e, 0x9c, 0x88, 0xa8, 0xe4, 0x06, 0x34, 0x16, 0xde, 0xaa, 0xe3, 0x84, 0x4f, 0x60, 0xd6, 0xe9, 0x6f, 0xe1, 0x55, 0x14, 0x5f, 0x45, 0x25, 0xb9, 0xa3, 0x44, 0x31, 0xca, 0x37, 0x66, 0x18, 0x0f, 0x70, 0xe1, 0x5a, 0x5e, 0x5d, 0x8e, 0x8b, 0x1a, 0x51, 0x6f, 0xf8, 0x70, 0x60, 0x9f, 0x13, 0xf8, 0x96, 0x93, 0x5c, 0xed, 0x18, 0x82, 0x79, 0xa5, 0x8e, 0xd1, 0x3d, 0x07, 0x11, 0x42, 0x77, 0xd7, 0x5c, 0x65, 0x68, 0x60, 0x7e, 0x0a, 0xb0, 0x92, 0xfd, 0x80, 0x3a, 0x22, 0x3e, 0x4a, 0x8e, 0xe0, 0xb1, 0xa8 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 4.2",
  /* Message to be encrypted */
  64,
  { 0xb0, 0xad, 0xc4, 0xf3, 0xfe, 0x11, 0xda, 0x59, 0xce, 0x99, 0x27, 0x73, 0xd9, 0x05, 0x99, 0x43, 0xc0, 0x30, 0x46, 0x49, 0x7e, 0xe9, 0xd9, 0xf9, 0xa0, 0x6d, 0xf1, 0x16, 0x6d, 0xb4, 0x6d, 0x98, 0xf5, 0x8d, 0x27, 0xec, 0x07, 0x4c, 0x02, 0xee, 0xe6, 0xcb, 0xe2, 0x44, 0x9c, 0x8b, 0x9f, 0xc5, 0x08, 0x0c, 0x5c, 0x3f, 0x44, 0x33, 0x09, 0x25, 0x12, 0xec, 0x46, 0xaa, 0x79, 0x37, 0x43, 0xc8 }
,
  /* Seed */
  20,
  { 0xf5, 0x45, 0xd5, 0x89, 0x75, 0x85, 0xe3, 0xdb, 0x71, 0xaa, 0x0c, 0xb8, 0xda, 0x76, 0xc5, 0x1d, 0x03, 0x2a, 0xe9, 0x63 }
,
  /* Encryption */
  129,
  { 0x00, 0x97, 0xb6, 0x98, 0xc6, 0x16, 0x56, 0x45, 0xb3, 0x03, 0x48, 0x6f, 0xbf, 0x5a, 0x2a, 0x44, 0x79, 0xc0, 0xee, 0x85, 0x88, 0x9b, 0x54, 0x1a, 0x6f, 0x0b, 0x85, 0x8d, 0x6b, 0x65, 0x97, 0xb1, 0x3b, 0x85, 0x4e, 0xb4, 0xf8, 0x39, 0xaf, 0x03, 0x39, 0x9a, 0x80, 0xd7, 0x9b, 0xda, 0x65, 0x78, 0xc8, 0x41, 0xf9, 0x0d, 0x64, 0x57, 0x15, 0xb2, 0x80, 0xd3, 0x71, 0x43, 0x99, 0x2d, 0xd1, 0x86, 0xc8, 0x0b, 0x94, 0x9b, 0x77, 0x5c, 0xae, 0x97, 0x37, 0x0e, 0x4e, 0xc9, 0x74, 0x43, 0x13, 0x6c, 0x6d, 0xa4, 0x84, 0xe9, 0x70, 0xff, 0xdb, 0x13, 0x23, 0xa2, 0x08, 0x47, 0x82, 0x1d, 0x3b, 0x18, 0x38, 0x1d, 0xe1, 0x3b, 0xb4, 0x9a, 0xae, 0xa6, 0x65, 0x30, 0xc4, 0xa4, 0xb8, 0x27, 0x1f, 0x3e, 0xae, 0x17, 0x2c, 0xd3, 0x66, 0xe0, 0x7e, 0x66, 0x36, 0xf1, 0x01, 0x9d, 0x2a, 0x28, 0xae, 0xd1, 0x5e }

}
,
{
  "RSAES-OAEP Encryption Example 4.3",
  /* Message to be encrypted */
  62,
  { 0xbf, 0x6d, 0x42, 0xe7, 0x01, 0x70, 0x7b, 0x1d, 0x02, 0x06, 0xb0, 0xc8, 0xb4, 0x5a, 0x1c, 0x72, 0x64, 0x1f, 0xf1, 0x28, 0x89, 0x21, 0x9a, 0x82, 0xbd, 0xea, 0x96, 0x5b, 0x5e, 0x79, 0xa9, 0x6b, 0x0d, 0x01, 0x63, 0xed, 0x9d, 0x57, 0x8e, 0xc9, 0xad, 0xa2, 0x0f, 0x2f, 0xbc, 0xf1, 0xea, 0x3c, 0x40, 0x89, 0xd8, 0x34, 0x19, 0xba, 0x81, 0xb0, 0xc6, 0x0f, 0x36, 0x06, 0xda, 0x99 }
,
  /* Seed */
  20,
  { 0xad, 0x99, 0x7f, 0xee, 0xf7, 0x30, 0xd6, 0xea, 0x7b, 0xe6, 0x0d, 0x0d, 0xc5, 0x2e, 0x72, 0xea, 0xcb, 0xfd, 0xd2, 0x75 }
,
  /* Encryption */
  129,
  { 0x03, 0x01, 0xf9, 0x35, 0xe9, 0xc4, 0x7a, 0xbc, 0xb4, 0x8a, 0xcb, 0xbe, 0x09, 0x89, 0x5d, 0x9f, 0x59, 0x71, 0xaf, 0x14, 0x83, 0x9d, 0xa4, 0xff, 0x95, 0x41, 0x7e, 0xe4, 0x53, 0xd1, 0xfd, 0x77, 0x31, 0x90, 0x72, 0xbb, 0x72, 0x97, 0xe1, 0xb5, 0x5d, 0x75, 0x61, 0xcd, 0x9d, 0x1b, 0xb2, 0x4c, 0x1a, 0x9a, 0x37, 0xc6, 0x19, 0x86, 0x43, 0x08, 0x24, 0x28, 0x04, 0x87, 0x9d, 0x86, 0xeb, 0xd0, 0x01, 0xdc, 0xe5, 0x18, 0x39, 0x75, 0xe1, 0x50, 0x69, 0x89, 0xb7, 0x0e, 0x5a, 0x83, 0x43, 0x41, 0x54, 0xd5, 0xcb, 0xfd, 0x6a, 0x24, 0x78, 0x7e, 0x60, 0xeb, 0x0c, 0x65, 0x8d, 0x2a, 0xc1, 0x93, 0x30, 0x2d, 0x11, 0x92, 0xc6, 0xe6, 0x22, 0xd4, 0xa1, 0x2a, 0xd4, 0xb5, 0x39, 0x23, 0xbc, 0xa2, 0x46, 0xdf, 0x31, 0xc6, 0x39, 0x5e, 0x37, 0x70, 0x2c, 0x6a, 0x78, 0xae, 0x08, 0x1f, 0xb9, 0xd0, 0x65 }

}
,
{
  "RSAES-OAEP Encryption Example 4.4",
  /* Message to be encrypted */
  22,
  { 0xfb, 0x2e, 0xf1, 0x12, 0xf5, 0xe7, 0x66, 0xeb, 0x94, 0x01, 0x92, 0x97, 0x93, 0x47, 0x94, 0xf7, 0xbe, 0x2f, 0x6f, 0xc1, 0xc5, 0x8e }
,
  /* Seed */
  20,
  { 0x13, 0x64, 0x54, 0xdf, 0x57, 0x30, 0xf7, 0x3c, 0x80, 0x7a, 0x7e, 0x40, 0xd8, 0xc1, 0xa3, 0x12, 0xac, 0x5b, 0x9d, 0xd3 }
,
  /* Encryption */
  129,
  { 0x02, 0xd1, 0x10, 0xad, 0x30, 0xaf, 0xb7, 0x27, 0xbe, 0xb6, 0x91, 0xdd, 0x0c, 0xf1, 0x7d, 0x0a, 0xf1, 0xa1, 0xe7, 0xfa, 0x0c, 0xc0, 0x40, 0xec, 0x1a, 0x4b, 0xa2, 0x6a, 0x42, 0xc5, 0x9d, 0x0a, 0x79, 0x6a, 0x2e, 0x22, 0xc8, 0xf3, 0x57, 0xcc, 0xc9, 0x8b, 0x65, 0x19, 0xac, 0xeb, 0x68, 0x2e, 0x94, 0x5e, 0x62, 0xcb, 0x73, 0x46, 0x14, 0xa5, 0x29, 0x40, 0x7c, 0xd4, 0x52, 0xbe, 0xe3, 0xe4, 0x4f, 0xec, 0xe8, 0x42, 0x3c, 0xc1, 0x9e, 0x55, 0x54, 0x8b, 0x8b, 0x99, 0x4b, 0x84, 0x9c, 0x7e, 0xcd, 0xe4, 0x93, 0x3e, 0x76, 0x03, 0x7e, 0x1d, 0x0c, 0xe4, 0x42, 0x75, 0xb0, 0x87, 0x10, 0xc6, 0x8e, 0x43, 0x01, 0x30, 0xb9, 0x29, 0x73, 0x0e, 0xd7, 0x7e, 0x09, 0xb0, 0x15, 0x64, 0x2c, 0x55, 0x93, 0xf0, 0x4e, 0x4f, 0xfb, 0x94, 0x10, 0x79, 0x81, 0x02, 0xa8, 0xe9, 0x6f, 0xfd, 0xfe, 0x11, 0xe4 }

}
,
{
  "RSAES-OAEP Encryption Example 4.5",
  /* Message to be encrypted */
  34,
  { 0x28, 0xcc, 0xd4, 0x47, 0xbb, 0x9e, 0x85, 0x16, 0x6d, 0xab, 0xb9, 0xe5, 0xb7, 0xd1, 0xad, 0xad, 0xc4, 0xb9, 0xd3, 0x9f, 0x20, 0x4e, 0x96, 0xd5, 0xe4, 0x40, 0xce, 0x9a, 0xd9, 0x28, 0xbc, 0x1c, 0x22, 0x84 }
,
  /* Seed */
  20,
  { 0xbc, 0xa8, 0x05, 0x7f, 0x82, 0x4b, 0x2e, 0xa2, 0x57, 0xf2, 0x86, 0x14, 0x07, 0xee, 0xf6, 0x3d, 0x33, 0x20, 0x86, 0x81 }
,
  /* Encryption */
  129,
  { 0x00, 0xdb, 0xb8, 0xa7, 0x43, 0x9d, 0x90, 0xef, 0xd9, 0x19, 0xa3, 0x77, 0xc5, 0x4f, 0xae, 0x8f, 0xe1, 0x1e, 0xc5, 0x8c, 0x3b, 0x85, 0x83, 0x62, 0xe2, 0x3a, 0xd1, 0xb8, 0xa4, 0x43, 0x10, 0x79, 0x90, 0x66, 0xb9, 0x93, 0x47, 0xaa, 0x52, 0x56, 0x91, 0xd2, 0xad, 0xc5, 0x8d, 0x9b, 0x06, 0xe3, 0x4f, 0x28, 0x8c, 0x17, 0x03, 0x90, 0xc5, 0xf0, 0xe1, 0x1c, 0x0a, 0xa3, 0x64, 0x59, 0x59, 0xf1, 0x8e, 0xe7, 0x9e, 0x8f, 0x2b, 0xe8, 0xd7, 0xac, 0x5c, 0x23, 0xd0, 0x61, 0xf1, 0x8d, 0xd7, 0x4b, 0x8c, 0x5f, 0x2a, 0x58, 0xfc, 0xb5, 0xeb, 0x0c, 0x54, 0xf9, 0x9f, 0x01, 0xa8, 0x32, 0x47, 0x56, 0x82, 0x92, 0x53, 0x65, 0x83, 0x34, 0x09, 0x48, 0xd7, 0xa8, 0xc9, 0x7c, 0x4a, 0xcd, 0x1e, 0x98, 0xd1, 0xe2, 0x9d, 0xc3, 0x20, 0xe9, 0x7a, 0x26, 0x05, 0x32, 0xa8, 0xaa, 0x7a, 0x75, 0x8a, 0x1e, 0xc2 }

}
,
{
  "RSAES-OAEP Encryption Example 4.6",
  /* Message to be encrypted */
  7,
  { 0xf2, 0x22, 0x42, 0x75, 0x1e, 0xc6, 0xb1 }
,
  /* Seed */
  20,
  { 0x2e, 0x7e, 0x1e, 0x17, 0xf6, 0x47, 0xb5, 0xdd, 0xd0, 0x33, 0xe1, 0x54, 0x72, 0xf9, 0x0f, 0x68, 0x12, 0xf3, 0xac, 0x4e }
,
  /* Encryption */
  129,
  { 0x00, 0xa5, 0xff, 0xa4, 0x76, 0x8c, 0x8b, 0xbe, 0xca, 0xee, 0x2d, 0xb7, 0x7e, 0x8f, 0x2e, 0xec, 0x99, 0x59, 0x59, 0x33, 0x54, 0x55, 0x20, 0x83, 0x5e, 0x5b, 0xa7, 0xdb, 0x94, 0x93, 0xd3, 0xe1, 0x7c, 0xdd, 0xef, 0xe6, 0xa5, 0xf5, 0x67, 0x62, 0x44, 0x71, 0x90, 0x8d, 0xb4, 0xe2, 0xd8, 0x3a, 0x0f, 0xbe, 0xe6, 0x06, 0x08, 0xfc, 0x84, 0x04, 0x95, 0x03, 0xb2, 0x23, 0x4a, 0x07, 0xdc, 0x83, 0xb2, 0x7b, 0x22, 0x84, 0x7a, 0xd8, 0x92, 0x0f, 0xf4, 0x2f, 0x67, 0x4e, 0xf7, 0x9b, 0x76, 0x28, 0x0b, 0x00, 0x23, 0x3d, 0x2b, 0x51, 0xb8, 0xcb, 0x27, 0x03, 0xa9, 0xd4, 0x2b, 0xfb, 0xc8, 0x25, 0x0c, 0x96, 0xec, 0x32, 0xc0, 0x51, 0xe5, 0x7f, 0x1b, 0x4b, 0xa5, 0x28, 0xdb, 0x89, 0xc3, 0x7e, 0x4c, 0x54, 0xe2, 0x7e, 0x6e, 0x64, 0xac, 0x69, 0x63, 0x5a, 0xe8, 0x87, 0xd9, 0x54, 0x16, 0x19, 0xa9 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 5: A 1028-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x0a, 0xad, 0xf3, 0xf9, 0xc1, 0x25, 0xe5, 0xd8, 0x91, 0xf3, 0x1a, 0xc4, 0x48, 0xe9, 0x93, 0xde, 0xfe, 0x58, 0x0f, 0x80, 0x2b, 0x45, 0xf9, 0xd7, 0xf2, 0x2b, 0xa5, 0x02, 0x1e, 0x9c, 0x47, 0x57, 0x6b, 0x5a, 0x1e, 0x68, 0x03, 0x1b, 0xa9, 0xdb, 0x4e, 0x6d, 0xab, 0xe4, 0xd9, 0x6a, 0x1d, 0x6f, 0x3d, 0x26, 0x72, 0x68, 0xcf, 0xf4, 0x08, 0x00, 0x5f, 0x11, 0x8e, 0xfc, 0xad, 0xb9, 0x98, 0x88, 0xd1, 0xc2, 0x34, 0x46, 0x71, 0x66, 0xb2, 0xa2, 0xb8, 0x49, 0xa0, 0x5a, 0x88, 0x9c, 0x06, 0x0a, 0xc0, 0xda, 0x0c, 0x5f, 0xae, 0x8b, 0x55, 0xf3, 0x09, 0xba, 0x62, 0xe7, 0x03, 0x74, 0x2f, 0xa0, 0x32, 0x6f, 0x2d, 0x10, 0xb0, 0x11, 0x02, 0x14, 0x89, 0xff, 0x49, 0x77, 0x70, 0x19, 0x0d, 0x89, 0x5f, 0xd3, 0x9f, 0x52, 0x29, 0x3c, 0x39, 0xef, 0xd7, 0x3a, 0x69, 0x8b, 0xda, 0xb9, 0xf1, 0x0e, 0xd9 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  129,
  { 0x02, 0x56, 0xeb, 0x4c, 0xba, 0x70, 0x67, 0xf2, 0xd2, 0xbe, 0x54, 0x0d, 0xcd, 0xff, 0x45, 0x82, 0xa3, 0x6b, 0x7d, 0x31, 0xd1, 0xc9, 0x09, 0x9b, 0xb2, 0x14, 0xb7, 0x98, 0x48, 0x46, 0x6a, 0x26, 0x8f, 0x80, 0xf5, 0x8a, 0x49, 0xac, 0x04, 0xc0, 0xe3, 0x64, 0x89, 0x34, 0xa0, 0x20, 0x6c, 0x04, 0x53, 0x7c, 0x19, 0xb2, 0x36, 0x64, 0x3a, 0x60, 0x82, 0x73, 0x21, 0x44, 0xdf, 0x75, 0xfa, 0x21, 0x75, 0x88, 0xf7, 0x94, 0x68, 0x2b, 0xe8, 0x91, 0x68, 0x27, 0x6d, 0xc7, 0x26, 0xc5, 0xc0, 0xcb, 0xdb, 0x84, 0xd3, 0x1b, 0xbf, 0x26, 0xd0, 0xa4, 0x3a, 0xf4, 0x95, 0x71, 0x7f, 0x7d, 0x52, 0x8a, 0xcf, 0xee, 0x34, 0x15, 0x61, 0xf6, 0xff, 0x3c, 0xae, 0x05, 0xc5, 0x78, 0xf8, 0x47, 0x0d, 0x96, 0x82, 0xf9, 0xc0, 0xd0, 0x72, 0xf9, 0xf6, 0x06, 0x8b, 0x56, 0xd5, 0x88, 0x0f, 0x68, 0x2b, 0xe2, 0xc5 }
,
  /* Prime p */
  65,
  { 0x03, 0xb0, 0xd3, 0x96, 0x2f, 0x6d, 0x17, 0x54, 0x9c, 0xbf, 0xca, 0x11, 0x29, 0x43, 0x48, 0xdc, 0xf0, 0xe7, 0xe3, 0x9f, 0x8c, 0x2b, 0xc6, 0x82, 0x4f, 0x21, 0x64, 0xb6, 0x06, 0xd6, 0x87, 0x86, 0x0d, 0xae, 0x1e, 0x63, 0x23, 0x93, 0xcf, 0xed, 0xf5, 0x13, 0x22, 0x82, 0x29, 0x06, 0x9e, 0x2f, 0x60, 0xe4, 0xac, 0xd7, 0xe6, 0x33, 0xa4, 0x36, 0x06, 0x3f, 0x82, 0x38, 0x5f, 0x48, 0x99, 0x37, 0x07 }
,
  /* Prime q */
  65,
  { 0x02, 0xe4, 0xc3, 0x2e, 0x2f, 0x51, 0x72, 0x69, 0xb7, 0x07, 0x23, 0x09, 0xf0, 0x0c, 0x0e, 0x31, 0x36, 0x5f, 0x7c, 0xe2, 0x8b, 0x23, 0x6b, 0x82, 0x91, 0x2d, 0xf2, 0x39, 0xab, 0xf3, 0x95, 0x72, 0xcf, 0x0e, 0xd6, 0x04, 0xb0, 0x29, 0x82, 0xe5, 0x35, 0x64, 0xc5, 0x2d, 0x6a, 0x05, 0x39, 0x7d, 0xe5, 0xc0, 0x52, 0xa2, 0xfd, 0xdc, 0x14, 0x1e, 0xf7, 0x18, 0x98, 0x36, 0x34, 0x6a, 0xeb, 0x33, 0x1f }
,
  /* p's CRT exponent dP */
  65,
  { 0x01, 0xe8, 0x4b, 0x11, 0x9d, 0x25, 0x16, 0x1f, 0xa6, 0x7b, 0x00, 0x25, 0x6a, 0x5b, 0xd9, 0xb6, 0x45, 0xd2, 0xb2, 0x32, 0xec, 0xb0, 0x5b, 0x01, 0x51, 0x80, 0x02, 0x9a, 0x88, 0x62, 0x2a, 0xdc, 0x3f, 0x09, 0xb3, 0xae, 0xac, 0xde, 0x61, 0x61, 0xab, 0x7c, 0xde, 0x22, 0xc2, 0xad, 0x26, 0xe7, 0x79, 0x7d, 0xf5, 0x4e, 0x07, 0x2c, 0xbd, 0x3b, 0x26, 0x73, 0x80, 0x0b, 0x3e, 0x43, 0x38, 0xdb, 0xd5 }
,
  /* q's CRT exponent dQ */
  64,
  { 0xeb, 0x90, 0xaa, 0x1a, 0x40, 0x13, 0x5b, 0x4c, 0xea, 0x07, 0x19, 0x7c, 0xed, 0xc8, 0x81, 0x9b, 0xe1, 0xe7, 0xcb, 0xff, 0x25, 0x47, 0x66, 0x21, 0x16, 0xf4, 0x65, 0xa4, 0xa9, 0xf4, 0x87, 0xab, 0x12, 0xf3, 0xba, 0x4f, 0xef, 0x13, 0x82, 0x22, 0x65, 0xa6, 0x52, 0x97, 0xd9, 0x8b, 0x7b, 0xde, 0xd9, 0x37, 0x2e, 0x3f, 0xfe, 0x81, 0xa3, 0x8b, 0x3e, 0x96, 0x00, 0xfe, 0xd0, 0x55, 0x75, 0x4f }
,
  /* CRT coefficient qInv */
  65,
  { 0x01, 0x2f, 0x7f, 0x81, 0x38, 0xf9, 0x40, 0x40, 0x62, 0xeb, 0x85, 0xa4, 0x29, 0x24, 0x52, 0x0b, 0x38, 0xf5, 0xbb, 0x88, 0x6a, 0x01, 0x96, 0xf4, 0x8b, 0xb8, 0xdc, 0xea, 0x60, 0xfd, 0x92, 0xcc, 0x02, 0x7f, 0x18, 0xe7, 0x81, 0x58, 0xa3, 0x4a, 0x5c, 0x5d, 0x5f, 0x86, 0x0a, 0x0f, 0x6c, 0x04, 0x07, 0x1a, 0x7d, 0x01, 0x31, 0x2c, 0x06, 0x50, 0x62, 0xf1, 0xeb, 0x48, 0xb7, 0x9d, 0x1c, 0x83, 0xcb }

}
,
{{
  "RSAES-OAEP Encryption Example 5.1",
  /* Message to be encrypted */
  31,
  { 0xaf, 0x71, 0xa9, 0x01, 0xe3, 0xa6, 0x1d, 0x31, 0x32, 0xf0, 0xfc, 0x1f, 0xdb, 0x47, 0x4f, 0x9e, 0xa6, 0x57, 0x92, 0x57, 0xff, 0xc2, 0x4d, 0x16, 0x41, 0x70, 0x14, 0x5b, 0x3d, 0xbd, 0xe8 }
,
  /* Seed */
  20,
  { 0x44, 0xc9, 0x2e, 0x28, 0x3f, 0x77, 0xb9, 0x49, 0x9c, 0x60, 0x3d, 0x96, 0x36, 0x60, 0xc8, 0x7d, 0x2f, 0x93, 0x94, 0x61 }
,
  /* Encryption */
  129,
  { 0x03, 0x60, 0x46, 0xa4, 0xa4, 0x7d, 0x9e, 0xd3, 0xba, 0x9a, 0x89, 0x13, 0x9c, 0x10, 0x50, 0x38, 0xeb, 0x74, 0x92, 0xb0, 0x5a, 0x5d, 0x68, 0xbf, 0xd5, 0x3a, 0xcc, 0xff, 0x45, 0x97, 0xf7, 0xa6, 0x86, 0x51, 0xb4, 0x7b, 0x4a, 0x46, 0x27, 0xd9, 0x27, 0xe4, 0x85, 0xee, 0xd7, 0xb4, 0x56, 0x64, 0x20, 0xe8, 0xb4, 0x09, 0x87, 0x9e, 0x5d, 0x60, 0x6e, 0xae, 0x25, 0x1d, 0x22, 0xa5, 0xdf, 0x79, 0x9f, 0x79, 0x20, 0xbf, 0xc1, 0x17, 0xb9, 0x92, 0x57, 0x2a, 0x53, 0xb1, 0x26, 0x31, 0x46, 0xbc, 0xea, 0x03, 0x38, 0x5c, 0xc5, 0xe8, 0x53, 0xc9, 0xa1, 0x01, 0xc8, 0xc3, 0xe1, 0xbd, 0xa3, 0x1a, 0x51, 0x98, 0x07, 0x49, 0x6c, 0x6c, 0xb5, 0xe5, 0xef, 0xb4, 0x08, 0x82, 0x3a, 0x35, 0x2b, 0x8f, 0xa0, 0x66, 0x1f, 0xb6, 0x64, 0xef, 0xad, 0xd5, 0x93, 0xde, 0xb9, 0x9f, 0xff, 0x5e, 0xd0, 0x00, 0xe5 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 5.2",
  /* Message to be encrypted */
  44,
  { 0xa3, 0xb8, 0x44, 0xa0, 0x82, 0x39, 0xa8, 0xac, 0x41, 0x60, 0x5a, 0xf1, 0x7a, 0x6c, 0xfd, 0xa4, 0xd3, 0x50, 0x13, 0x65, 0x85, 0x90, 0x3a, 0x41, 0x7a, 0x79, 0x26, 0x87, 0x60, 0x51, 0x9a, 0x4b, 0x4a, 0xc3, 0x30, 0x3e, 0xc7, 0x3f, 0x0f, 0x87, 0xcf, 0xb3, 0x23, 0x99 }
,
  /* Seed */
  20,
  { 0xcb, 0x28, 0xf5, 0x86, 0x06, 0x59, 0xfc, 0xee, 0xe4, 0x9c, 0x3e, 0xea, 0xfc, 0xe6, 0x25, 0xa7, 0x08, 0x03, 0xbd, 0x32 }
,
  /* Encryption */
  129,
  { 0x03, 0xd6, 0xeb, 0x65, 0x4e, 0xdc, 0xe6, 0x15, 0xbc, 0x59, 0xf4, 0x55, 0x26, 0x5e, 0xd4, 0xe5, 0xa1, 0x82, 0x23, 0xcb, 0xb9, 0xbe, 0x4e, 0x40, 0x69, 0xb4, 0x73, 0x80, 0x4d, 0x5d, 0xe9, 0x6f, 0x54, 0xdc, 0xaa, 0xa6, 0x03, 0xd0, 0x49, 0xc5, 0xd9, 0x4a, 0xa1, 0x47, 0x0d, 0xfc, 0xd2, 0x25, 0x40, 0x66, 0xb7, 0xc7, 0xb6, 0x1f, 0xf1, 0xf6, 0xf6, 0x77, 0x0e, 0x32, 0x15, 0xc5, 0x13, 0x99, 0xfd, 0x4e, 0x34, 0xec, 0x50, 0x82, 0xbc, 0x48, 0xf0, 0x89, 0x84, 0x0a, 0xd0, 0x43, 0x54, 0xae, 0x66, 0xdc, 0x0f, 0x1b, 0xd1, 0x8e, 0x46, 0x1a, 0x33, 0xcc, 0x12, 0x58, 0xb4, 0x43, 0xa2, 0x83, 0x7a, 0x6d, 0xf2, 0x67, 0x59, 0xaa, 0x23, 0x02, 0x33, 0x49, 0x86, 0xf8, 0x73, 0x80, 0xc9, 0xcc, 0x9d, 0x53, 0xbe, 0x9f, 0x99, 0x60, 0x5d, 0x2c, 0x9a, 0x97, 0xda, 0x7b, 0x09, 0x15, 0xa4, 0xa7, 0xad }

}
,
{
  "RSAES-OAEP Encryption Example 5.3",
  /* Message to be encrypted */
  63,
  { 0x30, 0x8b, 0x0e, 0xcb, 0xd2, 0xc7, 0x6c, 0xb7, 0x7f, 0xc6, 0xf7, 0x0c, 0x5e, 0xdd, 0x23, 0x3f, 0xd2, 0xf2, 0x09, 0x29, 0xd6, 0x29, 0xf0, 0x26, 0x95, 0x3b, 0xb6, 0x2a, 0x8f, 0x4a, 0x3a, 0x31, 0x4b, 0xde, 0x19, 0x5d, 0xe8, 0x5b, 0x5f, 0x81, 0x6d, 0xa2, 0xaa, 0xb0, 0x74, 0xd2, 0x6c, 0xb6, 0xac, 0xdd, 0xf3, 0x23, 0xae, 0x3b, 0x9c, 0x67, 0x8a, 0xc3, 0xcf, 0x12, 0xfb, 0xdd, 0xe7 }
,
  /* Seed */
  20,
  { 0x22, 0x85, 0xf4, 0x0d, 0x77, 0x04, 0x82, 0xf9, 0xa9, 0xef, 0xa2, 0xc7, 0x2c, 0xb3, 0xac, 0x55, 0x71, 0x6d, 0xc0, 0xca }
,
  /* Encryption */
  129,
  { 0x07, 0x70, 0x95, 0x21, 0x81, 0x64, 0x9f, 0x9f, 0x9f, 0x07, 0xff, 0x62, 0x6f, 0xf3, 0xa2, 0x2c, 0x35, 0xc4, 0x62, 0x44, 0x3d, 0x90, 0x5d, 0x45, 0x6a, 0x9f, 0xd0, 0xbf, 0xf4, 0x3c, 0xac, 0x2c, 0xa7, 0xa9, 0xf5, 0x54, 0xe9, 0x47, 0x8b, 0x9a, 0xcc, 0x3a, 0xc8, 0x38, 0xb0, 0x20, 0x40, 0xff, 0xd3, 0xe1, 0x84, 0x7d, 0xe2, 0xe4, 0x25, 0x39, 0x29, 0xf9, 0xdd, 0x9e, 0xe4, 0x04, 0x43, 0x25, 0xa9, 0xb0, 0x5c, 0xab, 0xb8, 0x08, 0xb2, 0xee, 0x84, 0x0d, 0x34, 0xe1, 0x5d, 0x10, 0x5a, 0x3f, 0x1f, 0x7b, 0x27, 0x69, 0x5a, 0x1a, 0x07, 0xa2, 0xd7, 0x3f, 0xe0, 0x8e, 0xca, 0xaa, 0x3c, 0x9c, 0x9d, 0x4d, 0x5a, 0x89, 0xff, 0x89, 0x0d, 0x54, 0x72, 0x7d, 0x7a, 0xe4, 0x0c, 0x0e, 0xc1, 0xa8, 0xdd, 0x86, 0x16, 0x5d, 0x8e, 0xe2, 0xc6, 0x36, 0x81, 0x41, 0x01, 0x6a, 0x48, 0xb5, 0x5b, 0x69, 0x67 }

}
,
{
  "RSAES-OAEP Encryption Example 5.4",
  /* Message to be encrypted */
  6,
  { 0x15, 0xc5, 0xb9, 0xee, 0x11, 0x85 }
,
  /* Seed */
  20,
  { 0x49, 0xfa, 0x45, 0xd3, 0xa7, 0x8d, 0xd1, 0x0d, 0xfd, 0x57, 0x73, 0x99, 0xd1, 0xeb, 0x00, 0xaf, 0x7e, 0xed, 0x55, 0x13 }
,
  /* Encryption */
  129,
  { 0x08, 0x12, 0xb7, 0x67, 0x68, 0xeb, 0xcb, 0x64, 0x2d, 0x04, 0x02, 0x58, 0xe5, 0xf4, 0x44, 0x1a, 0x01, 0x85, 0x21, 0xbd, 0x96, 0x68, 0x7e, 0x6c, 0x5e, 0x89, 0x9f, 0xcd, 0x6c, 0x17, 0x58, 0x8f, 0xf5, 0x9a, 0x82, 0xcc, 0x8a, 0xe0, 0x3a, 0x4b, 0x45, 0xb3, 0x12, 0x99, 0xaf, 0x17, 0x88, 0xc3, 0x29, 0xf7, 0xdc, 0xd2, 0x85, 0xf8, 0xcf, 0x4c, 0xed, 0x82, 0x60, 0x6b, 0x97, 0x61, 0x26, 0x71, 0xa4, 0x5b, 0xed, 0xca, 0x13, 0x34, 0x42, 0x14, 0x4d, 0x16, 0x17, 0xd1, 0x14, 0xf8, 0x02, 0x85, 0x7f, 0x0f, 0x9d, 0x73, 0x97, 0x51, 0xc5, 0x7a, 0x3f, 0x9e, 0xe4, 0x00, 0x91, 0x2c, 0x61, 0xe2, 0xe6, 0x99, 0x2b, 0xe0, 0x31, 0xa4, 0x3d, 0xd4, 0x8f, 0xa6, 0xba, 0x14, 0xee, 0xf7, 0xc4, 0x22, 0xb5, 0xed, 0xc4, 0xe7, 0xaf, 0xa0, 0x4f, 0xdd, 0x38, 0xf4, 0x02, 0xd1, 0xc8, 0xbb, 0x71, 0x9a, 0xbf }

}
,
{
  "RSAES-OAEP Encryption Example 5.5",
  /* Message to be encrypted */
  45,
  { 0x21, 0x02, 0x6e, 0x68, 0x00, 0xc7, 0xfa, 0x72, 0x8f, 0xca, 0xab, 0xa0, 0xd1, 0x96, 0xae, 0x28, 0xd7, 0xa2, 0xac, 0x4f, 0xfd, 0x8a, 0xbc, 0xe7, 0x94, 0xf0, 0x98, 0x5f, 0x60, 0xc8, 0xa6, 0x73, 0x72, 0x77, 0x36, 0x5d, 0x3f, 0xea, 0x11, 0xdb, 0x89, 0x23, 0xa2, 0x02, 0x9a }
,
  /* Seed */
  20,
  { 0xf0, 0x28, 0x74, 0x13, 0x23, 0x4c, 0xc5, 0x03, 0x47, 0x24, 0xa0, 0x94, 0xc4, 0x58, 0x6b, 0x87, 0xaf, 0xf1, 0x33, 0xfc }
,
  /* Encryption */
  129,
  { 0x07, 0xb6, 0x0e, 0x14, 0xec, 0x95, 0x4b, 0xfd, 0x29, 0xe6, 0x0d, 0x00, 0x47, 0xe7, 0x89, 0xf5, 0x1d, 0x57, 0x18, 0x6c, 0x63, 0x58, 0x99, 0x03, 0x30, 0x67, 0x93, 0xce, 0xd3, 0xf6, 0x82, 0x41, 0xc7, 0x43, 0x52, 0x9a, 0xba, 0x6a, 0x63, 0x74, 0xf9, 0x2e, 0x19, 0xe0, 0x16, 0x3e, 0xfa, 0x33, 0x69, 0x7e, 0x19, 0x6f, 0x76, 0x61, 0xdf, 0xaa, 0xa4, 0x7a, 0xac, 0x6b, 0xde, 0x5e, 0x51, 0xde, 0xb5, 0x07, 0xc7, 0x2c, 0x58, 0x9a, 0x2c, 0xa1, 0x69, 0x3d, 0x96, 0xb1, 0x46, 0x03, 0x81, 0x24, 0x9b, 0x2c, 0xdb, 0x9e, 0xac, 0x44, 0x76, 0x9f, 0x24, 0x89, 0xc5, 0xd3, 0xd2, 0xf9, 0x9f, 0x0e, 0xe3, 0xc7, 0xee, 0x5b, 0xf6, 0x4a, 0x5a, 0xc7, 0x9c, 0x42, 0xbd, 0x43, 0x3f, 0x14, 0x9b, 0xe8, 0xcb, 0x59, 0x54, 0x83, 0x61, 0x64, 0x05, 0x95, 0x51, 0x3c, 0x97, 0xaf, 0x7b, 0xc2, 0x50, 0x97, 0x23 }

}
,
{
  "RSAES-OAEP Encryption Example 5.6",
  /* Message to be encrypted */
  11,
  { 0x54, 0x1e, 0x37, 0xb6, 0x8b, 0x6c, 0x88, 0x72, 0xb8, 0x4c, 0x02 }
,
  /* Seed */
  20,
  { 0xd9, 0xfb, 0xa4, 0x5c, 0x96, 0xf2, 0x1e, 0x6e, 0x26, 0xd2, 0x9e, 0xb2, 0xcd, 0xcb, 0x65, 0x85, 0xbe, 0x9c, 0xb3, 0x41 }
,
  /* Encryption */
  129,
  { 0x08, 0xc3, 0x6d, 0x4d, 0xda, 0x33, 0x42, 0x3b, 0x2e, 0xd6, 0x83, 0x0d, 0x85, 0xf6, 0x41, 0x1b, 0xa1, 0xdc, 0xf4, 0x70, 0xa1, 0xfa, 0xe0, 0xeb, 0xef, 0xee, 0x7c, 0x08, 0x9f, 0x25, 0x6c, 0xef, 0x74, 0xcb, 0x96, 0xea, 0x69, 0xc3, 0x8f, 0x60, 0xf3, 0x9a, 0xbe, 0xe4, 0x41, 0x29, 0xbc, 0xb4, 0xc9, 0x2d, 0xe7, 0xf7, 0x97, 0x62, 0x3b, 0x20, 0x07, 0x4e, 0x3d, 0x9c, 0x28, 0x99, 0x70, 0x1e, 0xd9, 0x07, 0x1e, 0x1e, 0xfa, 0x0b, 0xdd, 0x84, 0xd4, 0xc3, 0xe5, 0x13, 0x03, 0x02, 0xd8, 0xf0, 0x24, 0x0b, 0xab, 0xa4, 0xb8, 0x4a, 0x71, 0xcc, 0x03, 0x2f, 0x22, 0x35, 0xa5, 0xff, 0x0f, 0xae, 0x27, 0x7c, 0x3e, 0x8f, 0x91, 0x12, 0xbe, 0xf4, 0x4c, 0x9a, 0xe2, 0x0d, 0x17, 0x5f, 0xc9, 0xa4, 0x05, 0x8b, 0xfc, 0x93, 0x0b, 0xa3, 0x1b, 0x02, 0xe2, 0xe4, 0xf4, 0x44, 0x48, 0x37, 0x10, 0xf2, 0x4a }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 6: A 1029-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x12, 0xb1, 0x7f, 0x6d, 0xad, 0x2e, 0xcd, 0x19, 0xff, 0x46, 0xdc, 0x13, 0xf7, 0x86, 0x0f, 0x09, 0xe0, 0xe0, 0xcf, 0xb6, 0x77, 0xb3, 0x8a, 0x52, 0x59, 0x23, 0x05, 0xce, 0xaf, 0x02, 0x2c, 0x16, 0x6d, 0xb9, 0x0d, 0x04, 0xac, 0x29, 0xe3, 0x3f, 0x7d, 0xd1, 0x2d, 0x9f, 0xaf, 0x66, 0xe0, 0x81, 0x6b, 0xb6, 0x3e, 0xad, 0x26, 0x7c, 0xc7, 0xd4, 0x6c, 0x17, 0xc3, 0x7b, 0xe2, 0x14, 0xbc, 0xa2, 0xa2, 0x2d, 0x72, 0x3a, 0x64, 0xe4, 0x44, 0x07, 0x43, 0x6b, 0x6f, 0xc9, 0x65, 0x72, 0x9a, 0xef, 0xc2, 0x55, 0x4f, 0x37, 0x6c, 0xd5, 0xdc, 0xea, 0x68, 0x29, 0x37, 0x80, 0xa6, 0x2b, 0xf3, 0x9d, 0x00, 0x29, 0x48, 0x5a, 0x16, 0x0b, 0xbb, 0x9e, 0x5d, 0xc0, 0x97, 0x2d, 0x21, 0xa5, 0x04, 0xf5, 0x2e, 0x5e, 0xe0, 0x28, 0xaa, 0x41, 0x63, 0x32, 0xf5, 0x10, 0xb2, 0xe9, 0xcf, 0xf5, 0xf7, 0x22, 0xaf }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  129,
  { 0x02, 0x95, 0xec, 0xa3, 0x56, 0x06, 0x18, 0x36, 0x95, 0x59, 0xce, 0xcd, 0x30, 0x3a, 0xa9, 0xcf, 0xda, 0xfc, 0x1d, 0x9f, 0x06, 0x95, 0x9d, 0xf7, 0x5f, 0xfe, 0xf9, 0x29, 0xaa, 0x89, 0x69, 0x61, 0xbc, 0xd1, 0x90, 0xdc, 0x69, 0x97, 0xed, 0xa7, 0xf5, 0x96, 0x3e, 0x72, 0x4d, 0x07, 0xb4, 0xdc, 0x11, 0xf3, 0x06, 0x5e, 0x5a, 0xe9, 0x7d, 0x96, 0x83, 0x51, 0x12, 0x28, 0x0b, 0x90, 0x84, 0xbb, 0x14, 0xf2, 0xa2, 0x1e, 0xbd, 0x4e, 0x88, 0x9d, 0x41, 0xb9, 0xc4, 0x13, 0x2e, 0xc1, 0x95, 0x6f, 0xca, 0xb8, 0xbb, 0x2f, 0xed, 0x05, 0x75, 0x88, 0x49, 0x36, 0x52, 0x2c, 0x5f, 0xf7, 0xd3, 0x32, 0x61, 0x90, 0x48, 0x24, 0xe7, 0xca, 0xde, 0xe4, 0xe0, 0xbb, 0x37, 0x2d, 0x24, 0x57, 0xcf, 0x78, 0xe2, 0xbd, 0x12, 0x86, 0x22, 0x8f, 0xf8, 0x3f, 0x10, 0x73, 0x1c, 0xe6, 0x3c, 0x90, 0xcf, 0xf3, 0xf9 }
,
  /* Prime p */
  65,
  { 0x04, 0xa6, 0xce, 0x8b, 0x73, 0x58, 0xdf, 0xa6, 0x9b, 0xdc, 0xf7, 0x42, 0x61, 0x70, 0x05, 0xaf, 0xb5, 0x38, 0x5f, 0x5f, 0x3a, 0x58, 0xa2, 0x4e, 0xf7, 0x4a, 0x22, 0xa8, 0xc0, 0x5c, 0xb7, 0xcc, 0x38, 0xeb, 0xd4, 0xcc, 0x9d, 0x9a, 0x9d, 0x78, 0x9a, 0x62, 0xcd, 0x0f, 0x60, 0xf0, 0xcb, 0x94, 0x1d, 0x34, 0x23, 0xc9, 0x69, 0x2e, 0xfa, 0x4f, 0xe3, 0xad, 0xff, 0x29, 0x0c, 0x47, 0x49, 0xa3, 0x8b }
,
  /* Prime q */
  65,
  { 0x04, 0x04, 0xc9, 0xa8, 0x03, 0x37, 0x1f, 0xed, 0xb4, 0xc5, 0xbe, 0x39, 0xf3, 0xc0, 0x0b, 0x00, 0x9e, 0x5e, 0x08, 0xa6, 0x3b, 0xe1, 0xe4, 0x00, 0x35, 0xcd, 0xac, 0xa5, 0x01, 0x1c, 0xc7, 0x01, 0xcf, 0x7e, 0xeb, 0xcb, 0x99, 0xf0, 0xff, 0xe1, 0x7c, 0xfd, 0x0a, 0x4b, 0xf7, 0xbe, 0xfd, 0x2d, 0xd5, 0x36, 0xac, 0x94, 0x6d, 0xb7, 0x97, 0xfd, 0xbc, 0x4a, 0xbe, 0x8f, 0x29, 0x34, 0x9b, 0x91, 0xed }
,
  /* p's CRT exponent dP */
  65,
  { 0x03, 0x96, 0x1c, 0x8f, 0x76, 0x0a, 0xa2, 0xbd, 0x51, 0x54, 0xc7, 0xaa, 0xfd, 0x77, 0x22, 0x5b, 0x3b, 0xac, 0xd0, 0x13, 0x9a, 0xe7, 0xb5, 0x94, 0x8e, 0xa3, 0x31, 0x1f, 0xcc, 0xd8, 0x6f, 0xb9, 0x5c, 0x75, 0xaf, 0xa7, 0x67, 0x28, 0x4b, 0x9b, 0x2d, 0xe5, 0x59, 0x57, 0x2f, 0x15, 0xd8, 0xd0, 0x44, 0xc7, 0xeb, 0x83, 0xa1, 0xbe, 0x5f, 0xad, 0xf2, 0xcc, 0x37, 0x7c, 0x0d, 0x84, 0x75, 0x29, 0x4b }
,
  /* q's CRT exponent dQ */
  65,
  { 0x02, 0x21, 0x97, 0xe0, 0x66, 0x74, 0x21, 0x96, 0xaa, 0xbc, 0x03, 0xfa, 0x2f, 0xee, 0xb4, 0xe7, 0x0b, 0x15, 0xcb, 0x78, 0x7d, 0x61, 0x7a, 0xcd, 0x31, 0xbb, 0x75, 0xc7, 0xbc, 0x23, 0x4a, 0xd7, 0x06, 0xf7, 0xc4, 0x8d, 0x21, 0x82, 0xd1, 0xf0, 0xff, 0x9c, 0x22, 0x8d, 0xcf, 0x41, 0x96, 0x7b, 0x6c, 0x0b, 0xa6, 0xd2, 0xc0, 0xad, 0x11, 0x0a, 0x1b, 0x85, 0x78, 0x31, 0xec, 0x24, 0x5e, 0x2c, 0xb1 }
,
  /* CRT coefficient qInv */
  65,
  { 0x04, 0x01, 0xc4, 0xc0, 0xc5, 0x3d, 0x45, 0xdb, 0xdb, 0x5e, 0x9d, 0x96, 0xd0, 0xfe, 0xcf, 0x42, 0x75, 0xdf, 0x09, 0x74, 0xbc, 0x4a, 0x07, 0x36, 0xb4, 0xa7, 0x4c, 0x32, 0x69, 0x05, 0x3e, 0xfb, 0x68, 0x6a, 0xce, 0x24, 0x06, 0xe2, 0x2c, 0x9e, 0x05, 0x8d, 0xdb, 0x4a, 0xe5, 0x40, 0x62, 0x7a, 0xe2, 0xfd, 0xb0, 0x82, 0x61, 0xe8, 0xe7, 0xe4, 0xbc, 0xbc, 0x99, 0x4d, 0xaa, 0xfa, 0x30, 0x5c, 0x45 }

}
,
{{
  "RSAES-OAEP Encryption Example 6.1",
  /* Message to be encrypted */
  22,
  { 0x40, 0x46, 0xca, 0x8b, 0xaa, 0x33, 0x47, 0xca, 0x27, 0xf4, 0x9e, 0x0d, 0x81, 0xf9, 0xcc, 0x1d, 0x71, 0xbe, 0x9b, 0xa5, 0x17, 0xd4 }
,
  /* Seed */
  20,
  { 0xdd, 0x0f, 0x6c, 0xfe, 0x41, 0x5e, 0x88, 0xe5, 0xa4, 0x69, 0xa5, 0x1f, 0xbb, 0xa6, 0xdf, 0xd4, 0x0a, 0xdb, 0x43, 0x84 }
,
  /* Encryption */
  129,
  { 0x06, 0x30, 0xee, 0xbc, 0xd2, 0x85, 0x6c, 0x24, 0xf7, 0x98, 0x80, 0x6e, 0x41, 0xf9, 0xe6, 0x73, 0x45, 0xed, 0xa9, 0xce, 0xda, 0x38, 0x6a, 0xcc, 0x9f, 0xac, 0xae, 0xa1, 0xee, 0xed, 0x06, 0xac, 0xe5, 0x83, 0x70, 0x97, 0x18, 0xd9, 0xd1, 0x69, 0xfa, 0xdf, 0x41, 0x4d, 0x5c, 0x76, 0xf9, 0x29, 0x96, 0x83, 0x3e, 0xf3, 0x05, 0xb7, 0x5b, 0x1e, 0x4b, 0x95, 0xf6, 0x62, 0xa2, 0x0f, 0xae, 0xdc, 0x3b, 0xae, 0x0c, 0x48, 0x27, 0xa8, 0xbf, 0x8a, 0x88, 0xed, 0xbd, 0x57, 0xec, 0x20, 0x3a, 0x27, 0xa8, 0x41, 0xf0, 0x2e, 0x43, 0xa6, 0x15, 0xba, 0xb1, 0xa8, 0xca, 0xc0, 0x70, 0x1d, 0xe3, 0x4d, 0xeb, 0xde, 0xf6, 0x2a, 0x08, 0x80, 0x89, 0xb5, 0x5e, 0xc3, 0x6e, 0xa7, 0x52, 0x2f, 0xd3, 0xec, 0x8d, 0x06, 0xb6, 0xa0, 0x73, 0xe6, 0xdf, 0x83, 0x31, 0x53, 0xbc, 0x0a, 0xef, 0xd9, 0x3b, 0xd1, 0xa3 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 6.2",
  /* Message to be encrypted */
  50,
  { 0x5c, 0xc7, 0x2c, 0x60, 0x23, 0x1d, 0xf0, 0x3b, 0x3d, 0x40, 0xf9, 0xb5, 0x79, 0x31, 0xbc, 0x31, 0x10, 0x9f, 0x97, 0x25, 0x27, 0xf2, 0x8b, 0x19, 0xe7, 0x48, 0x0c, 0x72, 0x88, 0xcb, 0x3c, 0x92, 0xb2, 0x25, 0x12, 0x21, 0x4e, 0x4b, 0xe6, 0xc9, 0x14, 0x79, 0x2d, 0xda, 0xbd, 0xf5, 0x7f, 0xaa, 0x8a, 0xa7 }
,
  /* Seed */
  20,
  { 0x8d, 0x14, 0xbd, 0x94, 0x6a, 0x13, 0x51, 0x14, 0x8f, 0x5c, 0xae, 0x2e, 0xd9, 0xa0, 0xc6, 0x53, 0xe8, 0x5e, 0xbd, 0x85 }
,
  /* Encryption */
  129,
  { 0x0e, 0xbc, 0x37, 0x37, 0x61, 0x73, 0xa4, 0xfd, 0x2f, 0x89, 0xcc, 0x55, 0xc2, 0xca, 0x62, 0xb2, 0x6b, 0x11, 0xd5, 0x1c, 0x3c, 0x7c, 0xe4, 0x9e, 0x88, 0x45, 0xf7, 0x4e, 0x76, 0x07, 0x31, 0x7c, 0x43, 0x6b, 0xc8, 0xd2, 0x3b, 0x96, 0x67, 0xdf, 0xeb, 0x9d, 0x08, 0x72, 0x34, 0xb4, 0x7b, 0xc6, 0x83, 0x71, 0x75, 0xae, 0x5c, 0x05, 0x59, 0xf6, 0xb8, 0x1d, 0x7d, 0x22, 0x41, 0x6d, 0x3e, 0x50, 0xf4, 0xac, 0x53, 0x3d, 0x8f, 0x08, 0x12, 0xf2, 0xdb, 0x9e, 0x79, 0x1f, 0xe9, 0xc7, 0x75, 0xac, 0x8b, 0x6a, 0xd0, 0xf5, 0x35, 0xad, 0x9c, 0xeb, 0x23, 0xa4, 0xa0, 0x20, 0x14, 0xc5, 0x8a, 0xb3, 0xf8, 0xd3, 0x16, 0x14, 0x99, 0xa2, 0x60, 0xf3, 0x93, 0x48, 0xe7, 0x14, 0xae, 0x2a, 0x1d, 0x34, 0x43, 0x20, 0x8f, 0xd8, 0xb7, 0x22, 0xcc, 0xfd, 0xfb, 0x39, 0x3e, 0x98, 0x01, 0x1f, 0x99, 0xe6, 0x3f }

}
,
{
  "RSAES-OAEP Encryption Example 6.3",
  /* Message to be encrypted */
  54,
  { 0xb2, 0x0e, 0x65, 0x13, 0x03, 0x09, 0x2f, 0x4b, 0xcc, 0xb4, 0x30, 0x70, 0xc0, 0xf8, 0x6d, 0x23, 0x04, 0x93, 0x62, 0xed, 0x96, 0x64, 0x2f, 0xc5, 0x63, 0x2c, 0x27, 0xdb, 0x4a, 0x52, 0xe3, 0xd8, 0x31, 0xf2, 0xab, 0x06, 0x8b, 0x23, 0xb1, 0x49, 0x87, 0x9c, 0x00, 0x2f, 0x6b, 0xf3, 0xfe, 0xee, 0x97, 0x59, 0x11, 0x12, 0x56, 0x2c }
,
  /* Seed */
  20,
  { 0x6c, 0x07, 0x5b, 0xc4, 0x55, 0x20, 0xf1, 0x65, 0xc0, 0xbf, 0x5e, 0xa4, 0xc5, 0xdf, 0x19, 0x1b, 0xc9, 0xef, 0x0e, 0x44 }
,
  /* Encryption */
  129,
  { 0x0a, 0x98, 0xbf, 0x10, 0x93, 0x61, 0x93, 0x94, 0x43, 0x6c, 0xf6, 0x8d, 0x8f, 0x38, 0xe2, 0xf1, 0x58, 0xfd, 0xe8, 0xea, 0x54, 0xf3, 0x43, 0x5f, 0x23, 0x9b, 0x8d, 0x06, 0xb8, 0x32, 0x18, 0x44, 0x20, 0x24, 0x76, 0xae, 0xed, 0x96, 0x00, 0x94, 0x92, 0x48, 0x0c, 0xe3, 0xa8, 0xd7, 0x05, 0x49, 0x8c, 0x4c, 0x8c, 0x68, 0xf0, 0x15, 0x01, 0xdc, 0x81, 0xdb, 0x60, 0x8f, 0x60, 0x08, 0x73, 0x50, 0xc8, 0xc3, 0xb0, 0xbd, 0x2e, 0x9e, 0xf6, 0xa8, 0x14, 0x58, 0xb7, 0xc8, 0x01, 0xb8, 0x9f, 0x2e, 0x4f, 0xe9, 0x9d, 0x49, 0x00, 0xba, 0x6a, 0x4b, 0x5e, 0x5a, 0x96, 0xd8, 0x65, 0xdc, 0x67, 0x6c, 0x77, 0x55, 0x92, 0x87, 0x94, 0x13, 0x0d, 0x62, 0x80, 0xa8, 0x16, 0x0a, 0x19, 0x0f, 0x2d, 0xf3, 0xea, 0x7c, 0xf9, 0xaa, 0x02, 0x71, 0xd8, 0x8e, 0x9e, 0x69, 0x05, 0xec, 0xf1, 0xc5, 0x15, 0x2d, 0x65 }

}
,
{
  "RSAES-OAEP Encryption Example 6.4",
  /* Message to be encrypted */
  8,
  { 0x68, 0x4e, 0x30, 0x38, 0xc5, 0xc0, 0x41, 0xf7 }
,
  /* Seed */
  20,
  { 0x3b, 0xbc, 0x3b, 0xd6, 0x63, 0x7d, 0xfe, 0x12, 0x84, 0x69, 0x01, 0x02, 0x9b, 0xf5, 0xb0, 0xc0, 0x71, 0x03, 0x43, 0x9c }
,
  /* Encryption */
  129,
  { 0x00, 0x8e, 0x7a, 0x67, 0xca, 0xcf, 0xb5, 0xc4, 0xe2, 0x4b, 0xec, 0x7d, 0xee, 0x14, 0x91, 0x17, 0xf1, 0x95, 0x98, 0xce, 0x8c, 0x45, 0x80, 0x8f, 0xef, 0x88, 0xc6, 0x08, 0xff, 0x9c, 0xd6, 0xe6, 0x95, 0x26, 0x3b, 0x9a, 0x3c, 0x0a, 0xd4, 0xb8, 0xba, 0x4c, 0x95, 0x23, 0x8e, 0x96, 0xa8, 0x42, 0x2b, 0x85, 0x35, 0x62, 0x9c, 0x8d, 0x53, 0x82, 0x37, 0x44, 0x79, 0xad, 0x13, 0xfa, 0x39, 0x97, 0x4b, 0x24, 0x2f, 0x9a, 0x75, 0x9e, 0xea, 0xf9, 0xc8, 0x3a, 0xd5, 0xa8, 0xca, 0x18, 0x94, 0x0a, 0x01, 0x62, 0xba, 0x75, 0x58, 0x76, 0xdf, 0x26, 0x3f, 0x4b, 0xd5, 0x0c, 0x65, 0x25, 0xc5, 0x60, 0x90, 0x26, 0x7c, 0x1f, 0x0e, 0x09, 0xce, 0x08, 0x99, 0xa0, 0xcf, 0x35, 0x9e, 0x88, 0x12, 0x0a, 0xbd, 0x9b, 0xf8, 0x93, 0x44, 0x5b, 0x3c, 0xae, 0x77, 0xd3, 0x60, 0x73, 0x59, 0xae, 0x9a, 0x52, 0xf8 }

}
,
{
  "RSAES-OAEP Encryption Example 6.5",
  /* Message to be encrypted */
  25,
  { 0x32, 0x48, 0x8c, 0xb2, 0x62, 0xd0, 0x41, 0xd6, 0xe4, 0xdd, 0x35, 0xf9, 0x87, 0xbf, 0x3c, 0xa6, 0x96, 0xdb, 0x1f, 0x06, 0xac, 0x29, 0xa4, 0x46, 0x93 }
,
  /* Seed */
  20,
  { 0xb4, 0x6b, 0x41, 0x89, 0x3e, 0x8b, 0xef, 0x32, 0x6f, 0x67, 0x59, 0x38, 0x3a, 0x83, 0x07, 0x1d, 0xae, 0x7f, 0xca, 0xbc }
,
  /* Encryption */
  129,
  { 0x00, 0x00, 0x34, 0x74, 0x41, 0x6c, 0x7b, 0x68, 0xbd, 0xf9, 0x61, 0xc3, 0x85, 0x73, 0x79, 0x44, 0xd7, 0xf1, 0xf4, 0x0c, 0xb3, 0x95, 0x34, 0x3c, 0x69, 0x3c, 0xc0, 0xb4, 0xfe, 0x63, 0xb3, 0x1f, 0xed, 0xf1, 0xea, 0xee, 0xac, 0x9c, 0xcc, 0x06, 0x78, 0xb3, 0x1d, 0xc3, 0x2e, 0x09, 0x77, 0x48, 0x95, 0x14, 0xc4, 0xf0, 0x90, 0x85, 0xf6, 0x29, 0x8a, 0x96, 0x53, 0xf0, 0x1a, 0xea, 0x40, 0x45, 0xff, 0x58, 0x2e, 0xe8, 0x87, 0xbe, 0x26, 0xae, 0x57, 0x5b, 0x73, 0xee, 0xf7, 0xf3, 0x77, 0x49, 0x21, 0xe3, 0x75, 0xa3, 0xd1, 0x9a, 0xdd, 0xa0, 0xca, 0x31, 0xaa, 0x18, 0x49, 0x88, 0x7c, 0x1f, 0x42, 0xca, 0xc9, 0x67, 0x7f, 0x7a, 0x2f, 0x4e, 0x92, 0x3f, 0x6e, 0x5a, 0x86, 0x8b, 0x38, 0xc0, 0x84, 0xef, 0x18, 0x75, 0x94, 0xdc, 0x9f, 0x7f, 0x04, 0x8f, 0xea, 0x2e, 0x02, 0x95, 0x53, 0x84, 0xab }

}
,
{
  "RSAES-OAEP Encryption Example 6.6",
  /* Message to be encrypted */
  12,
  { 0x50, 0xba, 0x14, 0xbe, 0x84, 0x62, 0x72, 0x02, 0x79, 0xc3, 0x06, 0xba }
,
  /* Seed */
  20,
  { 0x0a, 0x24, 0x03, 0x31, 0x2a, 0x41, 0xe3, 0xd5, 0x2f, 0x06, 0x0f, 0xbc, 0x13, 0xa6, 0x7d, 0xe5, 0xcf, 0x76, 0x09, 0xa7 }
,
  /* Encryption */
  129,
  { 0x0a, 0x02, 0x6d, 0xda, 0x5f, 0xc8, 0x78, 0x5f, 0x7b, 0xd9, 0xbf, 0x75, 0x32, 0x7b, 0x63, 0xe8, 0x5e, 0x2c, 0x0f, 0xde, 0xe5, 0xda, 0xdb, 0x65, 0xeb, 0xdc, 0xac, 0x9a, 0xe1, 0xde, 0x95, 0xc9, 0x2c, 0x67, 0x2a, 0xb4, 0x33, 0xaa, 0x7a, 0x8e, 0x69, 0xce, 0x6a, 0x6d, 0x88, 0x97, 0xfa, 0xc4, 0xac, 0x4a, 0x54, 0xde, 0x84, 0x1a, 0xe5, 0xe5, 0xbb, 0xce, 0x76, 0x87, 0x87, 0x9d, 0x79, 0x63, 0x4c, 0xea, 0x7a, 0x30, 0x68, 0x40, 0x65, 0xc7, 0x14, 0xd5, 0x24, 0x09, 0xb9, 0x28, 0x25, 0x6b, 0xbf, 0x53, 0xea, 0xbc, 0xd5, 0x23, 0x1e, 0xb7, 0x25, 0x95, 0x04, 0x53, 0x73, 0x99, 0xbd, 0x29, 0x16, 0x4b, 0x72, 0x6d, 0x33, 0xa4, 0x6d, 0xa7, 0x01, 0x36, 0x0a, 0x41, 0x68, 0xa0, 0x91, 0xcc, 0xab, 0x72, 0xd4, 0x4a, 0x62, 0xfe, 0xd2, 0x46, 0xc0, 0xff, 0xea, 0x5b, 0x13, 0x48, 0xab, 0x54, 0x70 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 7: A 1030-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x31, 0x11, 0x79, 0xf0, 0xbc, 0xfc, 0x9b, 0x9d, 0x3c, 0xa3, 0x15, 0xd0, 0x0e, 0xf3, 0x0d, 0x7b, 0xdd, 0x3a, 0x2c, 0xfa, 0xe9, 0x91, 0x1b, 0xfe, 0xdc, 0xb9, 0x48, 0xb3, 0xa4, 0x78, 0x2d, 0x07, 0x32, 0xb6, 0xab, 0x44, 0xaa, 0x4b, 0xf0, 0x37, 0x41, 0xa6, 0x44, 0xdc, 0x01, 0xbe, 0xc3, 0xe6, 0x9b, 0x01, 0xa0, 0x33, 0xe6, 0x75, 0xd8, 0xac, 0xd7, 0xc4, 0x92, 0x5c, 0x6b, 0x1a, 0xec, 0x31, 0x19, 0x05, 0x1d, 0xfd, 0x89, 0x76, 0x2d, 0x21, 0x5d, 0x45, 0x47, 0x5f, 0xfc, 0xb5, 0x9f, 0x90, 0x81, 0x48, 0x62, 0x3f, 0x37, 0x17, 0x71, 0x56, 0xf6, 0xae, 0x86, 0xdd, 0x7a, 0x7c, 0x5f, 0x43, 0xdc, 0x1e, 0x1f, 0x90, 0x82, 0x54, 0x05, 0x8a, 0x28, 0x4a, 0x5f, 0x06, 0xc0, 0x02, 0x17, 0x93, 0xa8, 0x7f, 0x1a, 0xc5, 0xfe, 0xff, 0x7d, 0xca, 0xee, 0x69, 0xc5, 0xe5, 0x1a, 0x37, 0x89, 0xe3, 0x73 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  129,
  { 0x07, 0x0c, 0xfc, 0xff, 0x2f, 0xeb, 0x82, 0x76, 0xe2, 0x74, 0x32, 0xc4, 0x5d, 0xfe, 0xe4, 0x8f, 0x49, 0xb7, 0x91, 0x7d, 0x65, 0x30, 0xe1, 0xf0, 0xca, 0x34, 0x60, 0xf3, 0x2e, 0x02, 0x76, 0x17, 0x44, 0x87, 0xc5, 0x6e, 0x22, 0xa4, 0x5d, 0x25, 0x00, 0xd7, 0x77, 0x54, 0x95, 0x21, 0x9d, 0x7d, 0x16, 0x5a, 0x9c, 0xf3, 0xbd, 0x92, 0xc3, 0x2a, 0xf9, 0xa9, 0x8d, 0x8d, 0xc9, 0xcc, 0x29, 0x68, 0x00, 0xad, 0xc9, 0x4a, 0x0a, 0x54, 0xfb, 0x40, 0xf3, 0x42, 0x91, 0xbf, 0x84, 0xee, 0x8e, 0xa1, 0x2b, 0x6f, 0x10, 0x93, 0x59, 0xc6, 0xd3, 0x54, 0x2a, 0x50, 0xf9, 0xc7, 0x67, 0xf5, 0xcf, 0xff, 0x05, 0xa6, 0x81, 0xc2, 0xe6, 0x56, 0xfb, 0x77, 0xca, 0xaa, 0xdb, 0x4b, 0xe9, 0x46, 0x8d, 0x8a, 0xbc, 0xd4, 0xdf, 0x98, 0xf5, 0x8e, 0x86, 0xd2, 0x05, 0x3f, 0xa1, 0x34, 0x9f, 0x74, 0x8e, 0x21, 0xb1 }
,
  /* Prime p */
  65,
  { 0x07, 0x49, 0x26, 0x2c, 0x11, 0x1c, 0xd4, 0x70, 0xec, 0x25, 0x66, 0xe6, 0xb3, 0x73, 0x2f, 0xc0, 0x93, 0x29, 0x46, 0x9a, 0xa1, 0x90, 0x71, 0xd3, 0xb9, 0xc0, 0x19, 0x06, 0x51, 0x4c, 0x6f, 0x1d, 0x26, 0xba, 0xa1, 0x4b, 0xea, 0xb0, 0x97, 0x1c, 0x8b, 0x7e, 0x61, 0x1a, 0x4f, 0x79, 0x00, 0x9d, 0x6f, 0xea, 0x77, 0x69, 0x28, 0xca, 0x25, 0x28, 0x5b, 0x0d, 0xe3, 0x64, 0x3d, 0x1a, 0x3f, 0x8c, 0x71 }
,
  /* Prime q */
  65,
  { 0x06, 0xbc, 0x1e, 0x50, 0xe9, 0x6c, 0x02, 0xbf, 0x63, 0x6e, 0x9e, 0xea, 0x8b, 0x89, 0x9b, 0xbe, 0xbf, 0x76, 0x51, 0xde, 0x77, 0xdd, 0x47, 0x4c, 0x3e, 0x9b, 0xc2, 0x3b, 0xad, 0x81, 0x82, 0xb6, 0x19, 0x04, 0xc7, 0xd9, 0x7d, 0xfb, 0xeb, 0xfb, 0x1e, 0x00, 0x10, 0x88, 0x78, 0xb6, 0xe6, 0x7e, 0x41, 0x53, 0x91, 0xd6, 0x79, 0x42, 0xc2, 0xb2, 0xbf, 0x9b, 0x44, 0x35, 0xf8, 0x8b, 0x0c, 0xb0, 0x23 }
,
  /* p's CRT exponent dP */
  65,
  { 0x03, 0xbc, 0x7e, 0xa7, 0xf0, 0xaa, 0xb1, 0x43, 0xab, 0xc6, 0xce, 0x8b, 0x97, 0x11, 0x86, 0x36, 0xa3, 0x01, 0x72, 0xe4, 0xcf, 0xe0, 0x2c, 0x8f, 0xa0, 0xdd, 0xa3, 0xb7, 0xba, 0xaf, 0x90, 0xf8, 0x09, 0x29, 0x82, 0x98, 0x55, 0x25, 0xf4, 0x88, 0xbd, 0xfc, 0xb4, 0xbd, 0x72, 0x6e, 0x22, 0x63, 0x9a, 0xc6, 0x4a, 0x30, 0x92, 0xab, 0x7f, 0xfc, 0xbf, 0x1d, 0x53, 0x34, 0xcf, 0xa5, 0x0b, 0x5b, 0xf1 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x02, 0x62, 0xa6, 0xaa, 0x29, 0xc2, 0xa3, 0xc6, 0x7d, 0xc5, 0x34, 0x6c, 0x06, 0x38, 0x1a, 0xfd, 0x98, 0x7a, 0xa3, 0xcc, 0x93, 0xcf, 0xbf, 0xec, 0xf5, 0x4f, 0xdd, 0x9f, 0x9d, 0x78, 0x7d, 0x7f, 0x59, 0xa5, 0x23, 0xd3, 0x98, 0x97, 0x9d, 0xa1, 0x37, 0xa2, 0xf6, 0x38, 0x1f, 0xe9, 0x48, 0x01, 0xf7, 0xc9, 0x4d, 0xa2, 0x15, 0x18, 0xdc, 0x34, 0xcb, 0x40, 0x87, 0x0c, 0x46, 0x97, 0x99, 0x4a, 0xd9 }
,
  /* CRT coefficient qInv */
  64,
  { 0x64, 0x9d, 0x4c, 0x17, 0xb6, 0xee, 0x17, 0x21, 0xe7, 0x72, 0xd0, 0x38, 0x9a, 0x55, 0x9c, 0x3d, 0x3c, 0xdf, 0x95, 0x50, 0xd4, 0x57, 0xc4, 0x6b, 0x03, 0x7b, 0x74, 0x64, 0x1b, 0x1d, 0x52, 0x16, 0x6a, 0xf8, 0xa2, 0x13, 0xc8, 0x39, 0x62, 0x06, 0xcd, 0xfb, 0xa4, 0x42, 0x2f, 0x18, 0xd6, 0xf6, 0x1d, 0xbc, 0xb5, 0xd2, 0x14, 0xc9, 0x71, 0xbf, 0x48, 0x2a, 0xeb, 0x97, 0x6a, 0x73, 0x70, 0xc2 }

}
,
{{
  "RSAES-OAEP Encryption Example 7.1",
  /* Message to be encrypted */
  4,
  { 0x47, 0xaa, 0xe9, 0x09 }
,
  /* Seed */
  20,
  { 0x43, 0xdd, 0x09, 0xa0, 0x7f, 0xf4, 0xca, 0xc7, 0x1c, 0xaa, 0x46, 0x32, 0xee, 0x5e, 0x1c, 0x1d, 0xae, 0xe4, 0xcd, 0x8f }
,
  /* Encryption */
  129,
  { 0x16, 0x88, 0xe4, 0xce, 0x77, 0x94, 0xbb, 0xa6, 0xcb, 0x70, 0x14, 0x16, 0x9e, 0xcd, 0x55, 0x9c, 0xed, 0xe2, 0xa3, 0x0b, 0x56, 0xa5, 0x2b, 0x68, 0xd9, 0xfe, 0x18, 0xcf, 0x19, 0x73, 0xef, 0x97, 0xb2, 0xa0, 0x31, 0x53, 0x95, 0x1c, 0x75, 0x5f, 0x62, 0x94, 0xaa, 0x49, 0xad, 0xbd, 0xb5, 0x58, 0x45, 0xab, 0x68, 0x75, 0xfb, 0x39, 0x86, 0xc9, 0x3e, 0xcf, 0x92, 0x79, 0x62, 0x84, 0x0d, 0x28, 0x2f, 0x9e, 0x54, 0xce, 0x8b, 0x69, 0x0f, 0x7c, 0x0c, 0xb8, 0xbb, 0xd7, 0x34, 0x40, 0xd9, 0x57, 0x1d, 0x1b, 0x16, 0xcd, 0x92, 0x60, 0xf9, 0xea, 0xb4, 0x78, 0x3c, 0xc4, 0x82, 0xe5, 0x22, 0x3d, 0xc6, 0x09, 0x73, 0x87, 0x17, 0x83, 0xec, 0x27, 0xb0, 0xae, 0x0f, 0xd4, 0x77, 0x32, 0xcb, 0xc2, 0x86, 0xa1, 0x73, 0xfc, 0x92, 0xb0, 0x0f, 0xb4, 0xba, 0x68, 0x24, 0x64, 0x7c, 0xd9, 0x3c, 0x85, 0xc1 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 7.2",
  /* Message to be encrypted */
  31,
  { 0x1d, 0x9b, 0x2e, 0x22, 0x23, 0xd9, 0xbc, 0x13, 0xbf, 0xb9, 0xf1, 0x62, 0xce, 0x73, 0x5d, 0xb4, 0x8b, 0xa7, 0xc6, 0x8f, 0x68, 0x22, 0xa0, 0xa1, 0xa7, 0xb6, 0xae, 0x16, 0x58, 0x34, 0xe7 }
,
  /* Seed */
  20,
  { 0x3a, 0x9c, 0x3c, 0xec, 0x7b, 0x84, 0xf9, 0xbd, 0x3a, 0xde, 0xcb, 0xc6, 0x73, 0xec, 0x99, 0xd5, 0x4b, 0x22, 0xbc, 0x9b }
,
  /* Encryption */
  129,
  { 0x10, 0x52, 0xed, 0x39, 0x7b, 0x2e, 0x01, 0xe1, 0xd0, 0xee, 0x1c, 0x50, 0xbf, 0x24, 0x36, 0x3f, 0x95, 0xe5, 0x04, 0xf4, 0xa0, 0x34, 0x34, 0xa0, 0x8f, 0xd8, 0x22, 0x57, 0x4e, 0xd6, 0xb9, 0x73, 0x6e, 0xdb, 0xb5, 0xf3, 0x90, 0xdb, 0x10, 0x32, 0x14, 0x79, 0xa8, 0xa1, 0x39, 0x35, 0x0e, 0x2b, 0xd4, 0x97, 0x7c, 0x37, 0x78, 0xef, 0x33, 0x1f, 0x3e, 0x78, 0xae, 0x11, 0x8b, 0x26, 0x84, 0x51, 0xf2, 0x0a, 0x2f, 0x01, 0xd4, 0x71, 0xf5, 0xd5, 0x3c, 0x56, 0x69, 0x37, 0x17, 0x1b, 0x2d, 0xbc, 0x2d, 0x4b, 0xde, 0x45, 0x9a, 0x57, 0x99, 0xf0, 0x37, 0x2d, 0x65, 0x74, 0x23, 0x9b, 0x23, 0x23, 0xd2, 0x45, 0xd0, 0xbb, 0x81, 0xc2, 0x86, 0xb6, 0x3c, 0x89, 0xa3, 0x61, 0x01, 0x73, 0x37, 0xe4, 0x90, 0x2f, 0x88, 0xa4, 0x67, 0xf4, 0xc7, 0xf2, 0x44, 0xbf, 0xd5, 0xab, 0x46, 0x43, 0x7f, 0xf3, 0xb6 }

}
,
{
  "RSAES-OAEP Encryption Example 7.3",
  /* Message to be encrypted */
  3,
  { 0xd9, 0x76, 0xfc }
,
  /* Seed */
  20,
  { 0x76, 0xa7, 0x5e, 0x5b, 0x61, 0x57, 0xa5, 0x56, 0xcf, 0x88, 0x84, 0xbb, 0x2e, 0x45, 0xc2, 0x93, 0xdd, 0x54, 0x5c, 0xf5 }
,
  /* Encryption */
  129,
  { 0x21, 0x55, 0xcd, 0x84, 0x3f, 0xf2, 0x4a, 0x4e, 0xe8, 0xba, 0xdb, 0x76, 0x94, 0x26, 0x00, 0x28, 0xa4, 0x90, 0x81, 0x3b, 0xa8, 0xb3, 0x69, 0xa4, 0xcb, 0xf1, 0x06, 0xec, 0x14, 0x8e, 0x52, 0x98, 0x70, 0x7f, 0x59, 0x65, 0xbe, 0x7d, 0x10, 0x1c, 0x10, 0x49, 0xea, 0x85, 0x84, 0xc2, 0x4c, 0xd6, 0x34, 0x55, 0xad, 0x9c, 0x10, 0x4d, 0x68, 0x62, 0x82, 0xd3, 0xfb, 0x80, 0x3a, 0x4c, 0x11, 0xc1, 0xc2, 0xe9, 0xb9, 0x1c, 0x71, 0x78, 0x80, 0x1d, 0x1b, 0x66, 0x40, 0xf0, 0x03, 0xf5, 0x72, 0x8d, 0xf0, 0x07, 0xb8, 0xa4, 0xcc, 0xc9, 0x2b, 0xce, 0x05, 0xe4, 0x1a, 0x27, 0x27, 0x8d, 0x7c, 0x85, 0x01, 0x8c, 0x52, 0x41, 0x43, 0x13, 0xa5, 0x07, 0x77, 0x89, 0x00, 0x1d, 0x4f, 0x01, 0x91, 0x0b, 0x72, 0xaa, 0xd0, 0x5d, 0x22, 0x0a, 0xa1, 0x4a, 0x58, 0x73, 0x3a, 0x74, 0x89, 0xbc, 0x54, 0x55, 0x6b }

}
,
{
  "RSAES-OAEP Encryption Example 7.4",
  /* Message to be encrypted */
  62,
  { 0xd4, 0x73, 0x86, 0x23, 0xdf, 0x22, 0x3a, 0xa4, 0x38, 0x43, 0xdf, 0x84, 0x67, 0x53, 0x4c, 0x41, 0xd0, 0x13, 0xe0, 0xc8, 0x03, 0xc6, 0x24, 0xe2, 0x63, 0x66, 0x6b, 0x23, 0x9b, 0xde, 0x40, 0xa5, 0xf2, 0x9a, 0xeb, 0x8d, 0xe7, 0x9e, 0x3d, 0xaa, 0x61, 0xdd, 0x03, 0x70, 0xf4, 0x9b, 0xd4, 0xb0, 0x13, 0x83, 0x4b, 0x98, 0x21, 0x2a, 0xef, 0x6b, 0x1c, 0x5e, 0xe3, 0x73, 0xb3, 0xcb }
,
  /* Seed */
  20,
  { 0x78, 0x66, 0x31, 0x4a, 0x6a, 0xd6, 0xf2, 0xb2, 0x50, 0xa3, 0x59, 0x41, 0xdb, 0x28, 0xf5, 0x86, 0x4b, 0x58, 0x58, 0x59 }
,
  /* Encryption */
  129,
  { 0x0a, 0xb1, 0x4c, 0x37, 0x3a, 0xeb, 0x7d, 0x43, 0x28, 0xd0, 0xaa, 0xad, 0x8c, 0x09, 0x4d, 0x88, 0xb9, 0xeb, 0x09, 0x8b, 0x95, 0xf2, 0x10, 0x54, 0xa2, 0x90, 0x82, 0x52, 0x2b, 0xe7, 0xc2, 0x7a, 0x31, 0x28, 0x78, 0xb6, 0x37, 0x91, 0x7e, 0x3d, 0x81, 0x9e, 0x6c, 0x3c, 0x56, 0x8d, 0xb5, 0xd8, 0x43, 0x80, 0x2b, 0x06, 0xd5, 0x1d, 0x9e, 0x98, 0xa2, 0xbe, 0x0b, 0xf4, 0x0c, 0x03, 0x14, 0x23, 0xb0, 0x0e, 0xdf, 0xbf, 0xf8, 0x32, 0x0e, 0xfb, 0x91, 0x71, 0xbd, 0x20, 0x44, 0x65, 0x3a, 0x4c, 0xb9, 0xc5, 0x12, 0x2f, 0x6c, 0x65, 0xe8, 0x3c, 0xda, 0x2e, 0xc3, 0xc1, 0x26, 0x02, 0x7a, 0x9c, 0x1a, 0x56, 0xba, 0x87, 0x4d, 0x0f, 0xea, 0x23, 0xf3, 0x80, 0xb8, 0x2c, 0xf2, 0x40, 0xb8, 0xcf, 0x54, 0x00, 0x04, 0x75, 0x8c, 0x4c, 0x77, 0xd9, 0x34, 0x15, 0x7a, 0x74, 0xf3, 0xfc, 0x12, 0xbf, 0xac }

}
,
{
  "RSAES-OAEP Encryption Example 7.5",
  /* Message to be encrypted */
  16,
  { 0xbb, 0x47, 0x23, 0x1c, 0xa5, 0xea, 0x1d, 0x3a, 0xd4, 0x6c, 0x99, 0x34, 0x5d, 0x9a, 0x8a, 0x61 }
,
  /* Seed */
  20,
  { 0xb2, 0x16, 0x6e, 0xd4, 0x72, 0xd5, 0x8d, 0xb1, 0x0c, 0xab, 0x2c, 0x6b, 0x00, 0x0c, 0xcc, 0xf1, 0x0a, 0x7d, 0xc5, 0x09 }
,
  /* Encryption */
  129,
  { 0x02, 0x83, 0x87, 0xa3, 0x18, 0x27, 0x74, 0x34, 0x79, 0x8b, 0x4d, 0x97, 0xf4, 0x60, 0x06, 0x8d, 0xf5, 0x29, 0x8f, 0xab, 0xa5, 0x04, 0x1b, 0xa1, 0x17, 0x61, 0xa1, 0xcb, 0x73, 0x16, 0xb2, 0x41, 0x84, 0x11, 0x4e, 0xc5, 0x00, 0x25, 0x7e, 0x25, 0x89, 0xed, 0x3b, 0x60, 0x7a, 0x1e, 0xbb, 0xe9, 0x7a, 0x6c, 0xc2, 0xe0, 0x2b, 0xf1, 0xb6, 0x81, 0xf4, 0x23, 0x12, 0xa3, 0x3b, 0x7a, 0x77, 0xd8, 0xe7, 0x85, 0x5c, 0x4a, 0x6d, 0xe0, 0x3e, 0x3c, 0x04, 0x64, 0x3f, 0x78, 0x6b, 0x91, 0xa2, 0x64, 0xa0, 0xd6, 0x80, 0x5e, 0x2c, 0xea, 0x91, 0xe6, 0x81, 0x77, 0xeb, 0x7a, 0x64, 0xd9, 0x25, 0x5e, 0x4f, 0x27, 0xe7, 0x13, 0xb7, 0xcc, 0xec, 0x00, 0xdc, 0x20, 0x0e, 0xbd, 0x21, 0xc2, 0xea, 0x2b, 0xb8, 0x90, 0xfe, 0xae, 0x49, 0x42, 0xdf, 0x94, 0x1d, 0xc3, 0xf9, 0x78, 0x90, 0xed, 0x34, 0x74, 0x78 }

}
,
{
  "RSAES-OAEP Encryption Example 7.6",
  /* Message to be encrypted */
  18,
  { 0x21, 0x84, 0x82, 0x70, 0x95, 0xd3, 0x5c, 0x3f, 0x86, 0xf6, 0x00, 0xe8, 0xe5, 0x97, 0x54, 0x01, 0x32, 0x96 }
,
  /* Seed */
  20,
  { 0x52, 0x67, 0x3b, 0xde, 0x2c, 0xa1, 0x66, 0xc2, 0xaa, 0x46, 0x13, 0x1a, 0xc1, 0xdc, 0x80, 0x8d, 0x67, 0xd7, 0xd3, 0xb1 }
,
  /* Encryption */
  129,
  { 0x14, 0xc6, 0x78, 0xa9, 0x4a, 0xd6, 0x05, 0x25, 0xef, 0x39, 0xe9, 0x59, 0xb2, 0xf3, 0xba, 0x5c, 0x09, 0x7a, 0x94, 0xff, 0x91, 0x2b, 0x67, 0xdb, 0xac, 0xe8, 0x05, 0x35, 0xc1, 0x87, 0xab, 0xd4, 0x7d, 0x07, 0x54, 0x20, 0xb1, 0x87, 0x21, 0x52, 0xbb, 0xa0, 0x8f, 0x7f, 0xc3, 0x1f, 0x31, 0x3b, 0xbf, 0x92, 0x73, 0xc9, 0x12, 0xfc, 0x4c, 0x01, 0x49, 0xa9, 0xb0, 0xcf, 0xb7, 0x98, 0x07, 0xe3, 0x46, 0xeb, 0x33, 0x20, 0x69, 0x61, 0x1b, 0xec, 0x0f, 0xf9, 0xbc, 0xd1, 0x68, 0xf1, 0xf7, 0xc3, 0x3e, 0x77, 0x31, 0x3c, 0xea, 0x45, 0x4b, 0x94, 0xe2, 0x54, 0x9e, 0xec, 0xf0, 0x02, 0xe2, 0xac, 0xf7, 0xf6, 0xf2, 0xd2, 0x84, 0x5d, 0x4f, 0xe0, 0xaa, 0xb2, 0xe5, 0xa9, 0x2d, 0xdf, 0x68, 0xc4, 0x80, 0xae, 0x11, 0x24, 0x79, 0x35, 0xd1, 0xf6, 0x25, 0x74, 0x84, 0x22, 0x16, 0xae, 0x67, 0x41, 0x15 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 8: A 1031-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x5b, 0xdf, 0x0e, 0x30, 0xd3, 0x21, 0xdd, 0xa5, 0x14, 0x7f, 0x88, 0x24, 0x08, 0xfa, 0x69, 0x19, 0x54, 0x80, 0xdf, 0x8f, 0x80, 0xd3, 0xf6, 0xe8, 0xbf, 0x58, 0x18, 0x50, 0x4f, 0x36, 0x42, 0x7c, 0xa9, 0xb1, 0xf5, 0x54, 0x0b, 0x9c, 0x65, 0xa8, 0xf6, 0x97, 0x4c, 0xf8, 0x44, 0x7a, 0x24, 0x4d, 0x92, 0x80, 0x20, 0x1b, 0xb4, 0x9f, 0xcb, 0xbe, 0x63, 0x78, 0xd1, 0x94, 0x4c, 0xd2, 0x27, 0xe2, 0x30, 0xf9, 0x6e, 0x3d, 0x10, 0xf8, 0x19, 0xdc, 0xef, 0x27, 0x6c, 0x64, 0xa0, 0x0b, 0x2a, 0x4b, 0x67, 0x01, 0xe7, 0xd0, 0x1d, 0xe5, 0xfa, 0xbd, 0xe3, 0xb1, 0xe9, 0xa0, 0xdf, 0x82, 0xf4, 0x63, 0x13, 0x59, 0xcd, 0x22, 0x66, 0x96, 0x47, 0xfb, 0xb1, 0x71, 0x72, 0x46, 0x13, 0x4e, 0xd7, 0xb4, 0x97, 0xcf, 0xff, 0xbd, 0xc4, 0x2b, 0x59, 0xc7, 0x3a, 0x96, 0xed, 0x90, 0x16, 0x62, 0x12, 0xdf, 0xf7 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  129,
  { 0x0f, 0x7d, 0x1e, 0x9e, 0x5a, 0xaa, 0x25, 0xfd, 0x13, 0xe4, 0xa0, 0x66, 0x3a, 0xe1, 0x44, 0xe0, 0xd1, 0x5f, 0x5c, 0xd1, 0x8b, 0xcd, 0xb0, 0x9d, 0xf2, 0xcc, 0x7e, 0x64, 0xe3, 0xc5, 0xe9, 0x15, 0xad, 0x62, 0x64, 0x53, 0x04, 0x16, 0x1d, 0x09, 0x8c, 0x71, 0x5b, 0xb7, 0xab, 0x8b, 0xd0, 0x1d, 0x07, 0xea, 0xf3, 0xfe, 0xd7, 0xc7, 0xed, 0x08, 0xaf, 0x2a, 0x8a, 0x62, 0xef, 0x44, 0xab, 0x16, 0xb3, 0x20, 0xe1, 0x4a, 0xf7, 0x2a, 0x48, 0xf9, 0x6a, 0xfe, 0x26, 0x2a, 0x0a, 0xe4, 0xcf, 0x65, 0xe6, 0x35, 0xe9, 0x10, 0x79, 0x0c, 0xd4, 0xee, 0x5c, 0xea, 0x76, 0x8a, 0x4b, 0x26, 0x39, 0xf7, 0xe6, 0xf6, 0x77, 0xb3, 0xf0, 0xbb, 0x6b, 0xe3, 0x2b, 0x75, 0x74, 0x7d, 0x89, 0x09, 0x03, 0x6f, 0x02, 0x64, 0xf5, 0x8d, 0x40, 0x1c, 0xdb, 0xa1, 0x31, 0x71, 0x61, 0x57, 0xa7, 0x5e, 0xcf, 0x63, 0x31 }
,
  /* Prime p */
  65,
  { 0x0a, 0x02, 0xef, 0x84, 0x48, 0xd9, 0xfa, 0xd8, 0xbb, 0xd0, 0xd0, 0x04, 0xc8, 0xc2, 0xaa, 0x97, 0x51, 0xef, 0x97, 0x21, 0xc1, 0xb0, 0xd0, 0x32, 0x36, 0xa5, 0x4b, 0x0d, 0xf9, 0x47, 0xcb, 0xae, 0xd5, 0xa2, 0x55, 0xee, 0x9e, 0x8e, 0x20, 0xd4, 0x91, 0xea, 0x17, 0x23, 0xfe, 0x09, 0x47, 0x04, 0xa9, 0x76, 0x2e, 0x88, 0xaf, 0xd1, 0x6e, 0xbb, 0x59, 0x94, 0x41, 0x2c, 0xa9, 0x66, 0xdc, 0x4f, 0x9f }
,
  /* Prime q */
  65,
  { 0x09, 0x2d, 0x36, 0x2e, 0x7e, 0xd3, 0xa0, 0xbf, 0xd9, 0xe9, 0xfd, 0x0e, 0x6c, 0x03, 0x01, 0xb6, 0xdf, 0x29, 0x15, 0x9c, 0xf5, 0x0c, 0xc8, 0x3b, 0x9b, 0x0c, 0xf4, 0xd6, 0xee, 0xa7, 0x1a, 0x61, 0xe0, 0x02, 0xb4, 0x6e, 0x0a, 0xe9, 0xf2, 0xde, 0x62, 0xd2, 0x5b, 0x5d, 0x74, 0x52, 0xd4, 0x98, 0xb8, 0x1c, 0x9a, 0xc6, 0xfc, 0x58, 0x59, 0x3d, 0x4c, 0x3f, 0xb4, 0xf5, 0xd7, 0x2d, 0xfb, 0xb0, 0xa9 }
,
  /* p's CRT exponent dP */
  65,
  { 0x07, 0xc7, 0x14, 0x10, 0xaf, 0x10, 0x39, 0x62, 0xdb, 0x36, 0x74, 0x04, 0xe3, 0x7a, 0xe8, 0x50, 0xba, 0xa4, 0xe9, 0xc2, 0x9d, 0xd9, 0x21, 0x45, 0x81, 0x52, 0x94, 0xa6, 0x7c, 0x7d, 0x1c, 0x6d, 0xed, 0x26, 0x3a, 0xa0, 0x30, 0xa9, 0xb6, 0x33, 0xae, 0x50, 0x30, 0x3e, 0x14, 0x03, 0x5d, 0x1a, 0xf0, 0x14, 0x12, 0x3e, 0xba, 0x68, 0x78, 0x20, 0x30, 0x8d, 0x8e, 0xbc, 0x85, 0xb6, 0x95, 0x7d, 0x7d }
,
  /* q's CRT exponent dQ */
  64,
  { 0xae, 0x2c, 0x75, 0x38, 0x0c, 0x02, 0xc0, 0x16, 0xad, 0x05, 0x89, 0x1b, 0x33, 0x01, 0xde, 0x88, 0x1f, 0x28, 0xae, 0x11, 0x71, 0x18, 0x2b, 0x6b, 0x2c, 0x83, 0xbe, 0xa7, 0xc5, 0x15, 0xec, 0xa9, 0xca, 0x29, 0x8c, 0x7b, 0x1c, 0xab, 0x58, 0x17, 0xa5, 0x97, 0x06, 0x8f, 0xc8, 0x50, 0x60, 0xde, 0x4d, 0xa8, 0xa0, 0x16, 0x37, 0x8a, 0xae, 0x43, 0xc7, 0xf9, 0x67, 0xbc, 0xc3, 0x79, 0x04, 0xb9 }
,
  /* CRT coefficient qInv */
  65,
  { 0x05, 0x98, 0xd1, 0x05, 0x9e, 0x3a, 0xda, 0x4f, 0x63, 0x20, 0x75, 0x2c, 0x09, 0xd8, 0x05, 0xff, 0x7d, 0x1f, 0x1a, 0xe0, 0xd0, 0x17, 0xae, 0xee, 0xe9, 0xce, 0xfa, 0x0d, 0x7d, 0xd7, 0xff, 0x77, 0x5e, 0x44, 0xb5, 0x78, 0x32, 0x2f, 0x64, 0x05, 0xd6, 0x21, 0x1d, 0xa1, 0x95, 0x19, 0x66, 0x6a, 0xa8, 0x7f, 0xdc, 0x4c, 0xd8, 0xc8, 0x8f, 0x6b, 0x6e, 0x3d, 0x67, 0xe9, 0x61, 0xdc, 0xbb, 0xa3, 0xd0 }

}
,
{{
  "RSAES-OAEP Encryption Example 8.1",
  /* Message to be encrypted */
  54,
  { 0x05, 0x0b, 0x75, 0x5e, 0x5e, 0x68, 0x80, 0xf7, 0xb9, 0xe9, 0xd6, 0x92, 0xa7, 0x4c, 0x37, 0xaa, 0xe4, 0x49, 0xb3, 0x1b, 0xfe, 0xa6, 0xde, 0xff, 0x83, 0x74, 0x7a, 0x89, 0x7f, 0x6c, 0x2c, 0x82, 0x5b, 0xb1, 0xad, 0xbf, 0x85, 0x0a, 0x3c, 0x96, 0x99, 0x4b, 0x5d, 0xe5, 0xb3, 0x3c, 0xbc, 0x7d, 0x4a, 0x17, 0x91, 0x3a, 0x79, 0x67 }
,
  /* Seed */
  20,
  { 0x77, 0x06, 0xff, 0xca, 0x1e, 0xcf, 0xb1, 0xeb, 0xee, 0x2a, 0x55, 0xe5, 0xc6, 0xe2, 0x4c, 0xd2, 0x79, 0x7a, 0x41, 0x25 }
,
  /* Encryption */
  129,
  { 0x09, 0xb3, 0x68, 0x3d, 0x8a, 0x2e, 0xb0, 0xfb, 0x29, 0x5b, 0x62, 0xed, 0x1f, 0xb9, 0x29, 0x0b, 0x71, 0x44, 0x57, 0xb7, 0x82, 0x53, 0x19, 0xf4, 0x64, 0x78, 0x72, 0xaf, 0x88, 0x9b, 0x30, 0x40, 0x94, 0x72, 0x02, 0x0a, 0xd1, 0x29, 0x12, 0xbf, 0x19, 0xb1, 0x1d, 0x48, 0x19, 0xf4, 0x96, 0x14, 0x82, 0x4f, 0xfd, 0x84, 0xd0, 0x9c, 0x0a, 0x17, 0xe7, 0xd1, 0x73, 0x09, 0xd1, 0x29, 0x19, 0x79, 0x04, 0x10, 0xaa, 0x29, 0x95, 0x69, 0x9f, 0x6a, 0x86, 0xdb, 0xe3, 0x24, 0x2b, 0x5a, 0xcc, 0x23, 0xaf, 0x45, 0x69, 0x10, 0x80, 0xd6, 0xb1, 0xae, 0x81, 0x0f, 0xb3, 0xe3, 0x05, 0x70, 0x87, 0xf0, 0x97, 0x00, 0x92, 0xce, 0x00, 0xbe, 0x95, 0x62, 0xff, 0x40, 0x53, 0xb6, 0x26, 0x2c, 0xe0, 0xca, 0xa9, 0x3e, 0x13, 0x72, 0x3d, 0x2e, 0x3a, 0x5b, 0xa0, 0x75, 0xd4, 0x5f, 0x0d, 0x61, 0xb5, 0x4b, 0x61 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 8.2",
  /* Message to be encrypted */
  63,
  { 0x4e, 0xb6, 0x8d, 0xcd, 0x93, 0xca, 0x9b, 0x19, 0xdf, 0x11, 0x1b, 0xd4, 0x36, 0x08, 0xf5, 0x57, 0x02, 0x6f, 0xe4, 0xaa, 0x1d, 0x5c, 0xfa, 0xc2, 0x27, 0xa3, 0xeb, 0x5a, 0xb9, 0x54, 0x8c, 0x18, 0xa0, 0x6d, 0xde, 0xd2, 0x3f, 0x81, 0x82, 0x59, 0x86, 0xb2, 0xfc, 0xd7, 0x11, 0x09, 0xec, 0xef, 0x7e, 0xff, 0x88, 0x87, 0x3f, 0x07, 0x5c, 0x2a, 0xa0, 0xc4, 0x69, 0xf6, 0x9c, 0x92, 0xbc }
,
  /* Seed */
  20,
  { 0xa3, 0x71, 0x7d, 0xa1, 0x43, 0xb4, 0xdc, 0xff, 0xbc, 0x74, 0x26, 0x65, 0xa8, 0xfa, 0x95, 0x05, 0x85, 0x54, 0x83, 0x43 }
,
  /* Encryption */
  129,
  { 0x2e, 0xcf, 0x15, 0xc9, 0x7c, 0x5a, 0x15, 0xb1, 0x47, 0x6a, 0xe9, 0x86, 0xb3, 0x71, 0xb5, 0x7a, 0x24, 0x28, 0x4f, 0x4a, 0x16, 0x2a, 0x8d, 0x0c, 0x81, 0x82, 0xe7, 0x90, 0x5e, 0x79, 0x22, 0x56, 0xf1, 0x81, 0x2b, 0xa5, 0xf8, 0x3f, 0x1f, 0x7a, 0x13, 0x0e, 0x42, 0xdc, 0xc0, 0x22, 0x32, 0x84, 0x4e, 0xdc, 0x14, 0xa3, 0x1a, 0x68, 0xee, 0x97, 0xae, 0x56, 0x4a, 0x38, 0x3a, 0x34, 0x11, 0x65, 0x64, 0x24, 0xc5, 0xf6, 0x2d, 0xdb, 0x64, 0x60, 0x93, 0xc3, 0x67, 0xbe, 0x1f, 0xcd, 0xa4, 0x26, 0xcf, 0x00, 0xa0, 0x6d, 0x8a, 0xcb, 0x7e, 0x57, 0x77, 0x6f, 0xbb, 0xd8, 0x55, 0xac, 0x3d, 0xf5, 0x06, 0xfc, 0x16, 0xb1, 0xd7, 0xc3, 0xf2, 0x11, 0x0f, 0x3d, 0x80, 0x68, 0xe9, 0x1e, 0x18, 0x63, 0x63, 0x83, 0x1c, 0x84, 0x09, 0x68, 0x0d, 0x8d, 0xa9, 0xec, 0xd8, 0xcf, 0x1f, 0xa2, 0x0e, 0xe3, 0x9d }

}
,
{
  "RSAES-OAEP Encryption Example 8.3",
  /* Message to be encrypted */
  12,
  { 0x86, 0x04, 0xac, 0x56, 0x32, 0x8c, 0x1a, 0xb5, 0xad, 0x91, 0x78, 0x61 }
,
  /* Seed */
  20,
  { 0xee, 0x06, 0x20, 0x90, 0x73, 0xcc, 0xa0, 0x26, 0xbb, 0x26, 0x4e, 0x51, 0x85, 0xbf, 0x8c, 0x68, 0xb7, 0x73, 0x9f, 0x86 }
,
  /* Encryption */
  129,
  { 0x4b, 0xc8, 0x91, 0x30, 0xa5, 0xb2, 0xda, 0xbb, 0x7c, 0x2f, 0xcf, 0x90, 0xeb, 0x5d, 0x0e, 0xaf, 0x9e, 0x68, 0x1b, 0x71, 0x46, 0xa3, 0x8f, 0x31, 0x73, 0xa3, 0xd9, 0xcf, 0xec, 0x52, 0xea, 0x9e, 0x0a, 0x41, 0x93, 0x2e, 0x64, 0x8a, 0x9d, 0x69, 0x34, 0x4c, 0x50, 0xda, 0x76, 0x3f, 0x51, 0xa0, 0x3c, 0x95, 0x76, 0x21, 0x31, 0xe8, 0x05, 0x22, 0x54, 0xdc, 0xd2, 0x24, 0x8c, 0xba, 0x40, 0xfd, 0x31, 0x66, 0x77, 0x86, 0xce, 0x05, 0xa2, 0xb7, 0xb5, 0x31, 0xac, 0x9d, 0xac, 0x9e, 0xd5, 0x84, 0xa5, 0x9b, 0x67, 0x7c, 0x1a, 0x8a, 0xed, 0x8c, 0x5d, 0x15, 0xd6, 0x8c, 0x05, 0x56, 0x9e, 0x2b, 0xe7, 0x80, 0xbf, 0x7d, 0xb6, 0x38, 0xfd, 0x2b, 0xfd, 0x2a, 0x85, 0xab, 0x27, 0x68, 0x60, 0xf3, 0x77, 0x73, 0x38, 0xfc, 0xa9, 0x89, 0xff, 0xd7, 0x43, 0xd1, 0x3e, 0xe0, 0x8e, 0x0c, 0xa9, 0x89, 0x3f }

}
,
{
  "RSAES-OAEP Encryption Example 8.4",
  /* Message to be encrypted */
  34,
  { 0xfd, 0xda, 0x5f, 0xbf, 0x6e, 0xc3, 0x61, 0xa9, 0xd9, 0xa4, 0xac, 0x68, 0xaf, 0x21, 0x6a, 0x06, 0x86, 0xf4, 0x38, 0xb1, 0xe0, 0xe5, 0xc3, 0x6b, 0x95, 0x5f, 0x74, 0xe1, 0x07, 0xf3, 0x9c, 0x0d, 0xdd, 0xcc }
,
  /* Seed */
  20,
  { 0x99, 0x0a, 0xd5, 0x73, 0xdc, 0x48, 0xa9, 0x73, 0x23, 0x5b, 0x6d, 0x82, 0x54, 0x36, 0x18, 0xf2, 0xe9, 0x55, 0x10, 0x5d }
,
  /* Encryption */
  129,
  { 0x2e, 0x45, 0x68, 0x47, 0xd8, 0xfc, 0x36, 0xff, 0x01, 0x47, 0xd6, 0x99, 0x35, 0x94, 0xb9, 0x39, 0x72, 0x27, 0xd5, 0x77, 0x75, 0x2c, 0x79, 0xd0, 0xf9, 0x04, 0xfc, 0xb0, 0x39, 0xd4, 0xd8, 0x12, 0xfe, 0xa6, 0x05, 0xa7, 0xb5, 0x74, 0xdd, 0x82, 0xca, 0x78, 0x6f, 0x93, 0x75, 0x23, 0x48, 0x43, 0x8e, 0xe9, 0xf5, 0xb5, 0x45, 0x49, 0x85, 0xd5, 0xf0, 0xe1, 0x69, 0x9e, 0x3e, 0x7a, 0xd1, 0x75, 0xa3, 0x2e, 0x15, 0xf0, 0x3d, 0xeb, 0x04, 0x2a, 0xb9, 0xfe, 0x1d, 0xd9, 0xdb, 0x1b, 0xb8, 0x6f, 0x8c, 0x08, 0x9c, 0xcb, 0x45, 0xe7, 0xef, 0x0c, 0x5e, 0xe7, 0xca, 0x9b, 0x72, 0x90, 0xca, 0x6b, 0x15, 0xbe, 0xd4, 0x70, 0x39, 0x78, 0x8a, 0x8a, 0x93, 0xff, 0x83, 0xe0, 0xe8, 0xd6, 0x24, 0x4c, 0x71, 0x00, 0x63, 0x62, 0xde, 0xef, 0x69, 0xb6, 0xf4, 0x16, 0xfb, 0x3c, 0x68, 0x43, 0x83, 0xfb, 0xd0 }

}
,
{
  "RSAES-OAEP Encryption Example 8.5",
  /* Message to be encrypted */
  13,
  { 0x4a, 0x5f, 0x49, 0x14, 0xbe, 0xe2, 0x5d, 0xe3, 0xc6, 0x93, 0x41, 0xde, 0x07 }
,
  /* Seed */
  20,
  { 0xec, 0xc6, 0x3b, 0x28, 0xf0, 0x75, 0x6f, 0x22, 0xf5, 0x2a, 0xc8, 0xe6, 0xec, 0x12, 0x51, 0xa6, 0xec, 0x30, 0x47, 0x18 }
,
  /* Encryption */
  129,
  { 0x1f, 0xb9, 0x35, 0x6f, 0xd5, 0xc4, 0xb1, 0x79, 0x6d, 0xb2, 0xeb, 0xf7, 0xd0, 0xd3, 0x93, 0xcc, 0x81, 0x0a, 0xdf, 0x61, 0x45, 0xde, 0xfc, 0x2f, 0xce, 0x71, 0x4f, 0x79, 0xd9, 0x38, 0x00, 0xd5, 0xe2, 0xac, 0x21, 0x1e, 0xa8, 0xbb, 0xec, 0xca, 0x4b, 0x65, 0x4b, 0x94, 0xc3, 0xb1, 0x8b, 0x30, 0xdd, 0x57, 0x6c, 0xe3, 0x4d, 0xc9, 0x54, 0x36, 0xef, 0x57, 0xa0, 0x94, 0x15, 0x64, 0x59, 0x23, 0x35, 0x9a, 0x5d, 0x7b, 0x41, 0x71, 0xef, 0x22, 0xc2, 0x46, 0x70, 0xf1, 0xb2, 0x29, 0xd3, 0x60, 0x3e, 0x91, 0xf7, 0x66, 0x71, 0xb7, 0xdf, 0x97, 0xe7, 0x31, 0x7c, 0x97, 0x73, 0x44, 0x76, 0xd5, 0xf3, 0xd1, 0x7d, 0x21, 0xcf, 0x82, 0xb5, 0xba, 0x9f, 0x83, 0xdf, 0x2e, 0x58, 0x8d, 0x36, 0x98, 0x4f, 0xd1, 0xb5, 0x84, 0x46, 0x8b, 0xd2, 0x3b, 0x2e, 0x87, 0x5f, 0x32, 0xf6, 0x89, 0x53, 0xf7, 0xb2 }

}
,
{
  "RSAES-OAEP Encryption Example 8.6",
  /* Message to be encrypted */
  25,
  { 0x8e, 0x07, 0xd6, 0x6f, 0x7b, 0x88, 0x0a, 0x72, 0x56, 0x3a, 0xbc, 0xd3, 0xf3, 0x50, 0x92, 0xbc, 0x33, 0x40, 0x9f, 0xb7, 0xf8, 0x8f, 0x24, 0x72, 0xbe }
,
  /* Seed */
  20,
  { 0x39, 0x25, 0xc7, 0x1b, 0x36, 0x2d, 0x40, 0xa0, 0xa6, 0xde, 0x42, 0x14, 0x55, 0x79, 0xba, 0x1e, 0x7d, 0xd4, 0x59, 0xfc }
,
  /* Encryption */
  129,
  { 0x3a, 0xfd, 0x9c, 0x66, 0x00, 0x14, 0x7b, 0x21, 0x79, 0x8d, 0x81, 0x8c, 0x65, 0x5a, 0x0f, 0x4c, 0x92, 0x12, 0xdb, 0x26, 0xd0, 0xb0, 0xdf, 0xdc, 0x2a, 0x75, 0x94, 0xcc, 0xb3, 0xd2, 0x2f, 0x5b, 0xf1, 0xd7, 0xc3, 0xe1, 0x12, 0xcd, 0x73, 0xfc, 0x7d, 0x50, 0x9c, 0x7a, 0x8b, 0xaf, 0xdd, 0x3c, 0x27, 0x4d, 0x13, 0x99, 0x00, 0x9f, 0x96, 0x09, 0xec, 0x4b, 0xe6, 0x47, 0x7e, 0x45, 0x3f, 0x07, 0x5a, 0xa3, 0x3d, 0xb3, 0x82, 0x87, 0x0c, 0x1c, 0x34, 0x09, 0xae, 0xf3, 0x92, 0xd7, 0x38, 0x6a, 0xe3, 0xa6, 0x96, 0xb9, 0x9a, 0x94, 0xb4, 0xda, 0x05, 0x89, 0x44, 0x7e, 0x95, 0x5d, 0x16, 0xc9, 0x8b, 0x17, 0x60, 0x2a, 0x59, 0xbd, 0x73, 0x62, 0x79, 0xfc, 0xd8, 0xfb, 0x28, 0x0c, 0x44, 0x62, 0xd5, 0x90, 0xbf, 0xa9, 0xbf, 0x13, 0xfe, 0xd5, 0x70, 0xea, 0xfd, 0xe9, 0x73, 0x30, 0xa2, 0xc2, 0x10 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 9: A 1536-bit RSA Key Pair",
{
  /* RSA modulus n */
  192,
  { 0xcf, 0x2c, 0xd4, 0x1e, 0x34, 0xca, 0x3a, 0x72, 0x8e, 0xa5, 0xcb, 0x8a, 0xff, 0x64, 0xc3, 0x6d, 0x27, 0xbd, 0xef, 0x53, 0x64, 0xe3, 0x36, 0xfd, 0x68, 0xd3, 0x12, 0x3c, 0x5a, 0x19, 0x6a, 0x8c, 0x28, 0x70, 0x13, 0xe8, 0x53, 0xd5, 0x15, 0x6d, 0x58, 0xd1, 0x51, 0x95, 0x45, 0x20, 0xfb, 0x4f, 0x6d, 0x7b, 0x17, 0xab, 0xb6, 0x81, 0x77, 0x65, 0x90, 0x9c, 0x57, 0x61, 0x19, 0x65, 0x9d, 0x90, 0x2b, 0x19, 0x06, 0xed, 0x8a, 0x2b, 0x10, 0xc1, 0x55, 0xc2, 0x4d, 0x12, 0x45, 0x28, 0xda, 0xb9, 0xee, 0xae, 0x37, 0x9b, 0xea, 0xc6, 0x6e, 0x4a, 0x41, 0x17, 0x86, 0xdc, 0xb8, 0xfd, 0x00, 0x62, 0xeb, 0xc0, 0x30, 0xde, 0x12, 0x19, 0xa0, 0x4c, 0x2a, 0x8c, 0x1b, 0x7d, 0xd3, 0x13, 0x1e, 0x4d, 0x6b, 0x6c, 0xae, 0xe2, 0xe3, 0x1a, 0x5e, 0xd4, 0x1a, 0xc1, 0x50, 0x9b, 0x2e, 0xf1, 0xee, 0x2a, 0xb1, 0x83, 0x64, 0xbe, 0x56, 0x8c, 0xa9, 0x41, 0xc2, 0x5e, 0xcc, 0x84, 0xff, 0x9d, 0x64, 0x3b, 0x5e, 0xc1, 0xaa, 0xae, 0x10, 0x2a, 0x20, 0xd7, 0x3f, 0x47, 0x9b, 0x78, 0x0f, 0xd6, 0xda, 0x91, 0x07, 0x52, 0x12, 0xd9, 0xea, 0xc0, 0x3a, 0x06, 0x74, 0xd8, 0x99, 0xeb, 0xa2, 0xe4, 0x31, 0xf4, 0xc4, 0x4b, 0x61, 0x5b, 0x6b, 0xa2, 0x23, 0x2b, 0xd4, 0xb3, 0x3b, 0xae, 0xd7, 0x3d, 0x62, 0x5d }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  192,
  { 0x19, 0x8c, 0x14, 0x1e, 0x23, 0x71, 0x5a, 0x92, 0xbc, 0xcf, 0x6a, 0x11, 0x9a, 0x5b, 0xc1, 0x13, 0x89, 0x46, 0x8d, 0x28, 0x11, 0xf5, 0x48, 0xd7, 0x27, 0xe1, 0x7b, 0x4a, 0xb0, 0xeb, 0x98, 0x6d, 0x6f, 0x21, 0x1e, 0xfb, 0x53, 0xb7, 0x1f, 0x7c, 0xcb, 0xea, 0x87, 0xee, 0x69, 0xc7, 0x5e, 0xe6, 0x15, 0x00, 0x8c, 0x53, 0x32, 0xde, 0xb5, 0x2b, 0xf3, 0x90, 0xab, 0xdf, 0xbf, 0xe3, 0x7d, 0x72, 0x05, 0x36, 0x81, 0x59, 0xb2, 0x63, 0x8c, 0x1d, 0xe3, 0x26, 0xe2, 0x1d, 0x22, 0x25, 0x1f, 0x0f, 0xb5, 0x84, 0x8b, 0x3b, 0xf1, 0x50, 0x05, 0xd2, 0xa7, 0x43, 0x30, 0xf0, 0xaf, 0xe9, 0x16, 0xee, 0x62, 0xcc, 0xc1, 0x34, 0x4d, 0x1d, 0x83, 0xa7, 0x09, 0xe6, 0x06, 0x76, 0x27, 0x38, 0x40, 0xf7, 0xf3, 0x77, 0x42, 0x4a, 0x5e, 0x0a, 0x4d, 0xa7, 0x5f, 0x01, 0xb3, 0x1f, 0xf7, 0x68, 0x19, 0xcf, 0x9c, 0xbf, 0xdd, 0x21, 0x52, 0x43, 0xc3, 0x91, 0x7c, 0x03, 0xef, 0x38, 0x19, 0x93, 0x12, 0xe5, 0x67, 0xb3, 0xbf, 0x7a, 0xed, 0x3a, 0xb4, 0x57, 0xf3, 0x71, 0xef, 0x8a, 0x14, 0x23, 0xf4, 0x5b, 0x68, 0xc6, 0xe2, 0x82, 0xec, 0x11, 0x1b, 0xba, 0x28, 0x33, 0xb9, 0x87, 0xfd, 0x69, 0xfa, 0xd8, 0x3b, 0xc1, 0xb8, 0xc6, 0x13, 0xc5, 0xe1, 0xea, 0x16, 0xc1, 0x1e, 0xd1, 0x25, 0xea, 0x7e, 0xc1 }
,
  /* Prime p */
  96,
  { 0xfc, 0x8d, 0x6c, 0x04, 0xbe, 0xc4, 0xeb, 0x9a, 0x81, 0x92, 0xca, 0x79, 0x00, 0xcb, 0xe5, 0x36, 0xe2, 0xe8, 0xb5, 0x19, 0xde, 0xcf, 0x33, 0xb2, 0x45, 0x97, 0x98, 0xc6, 0x90, 0x9d, 0xf4, 0xf1, 0x76, 0xdb, 0x7d, 0x23, 0x19, 0x0f, 0xc7, 0x2b, 0x88, 0x65, 0xa7, 0x18, 0xaf, 0x89, 0x5f, 0x1b, 0xcd, 0x91, 0x45, 0x29, 0x80, 0x27, 0x42, 0x3b, 0x60, 0x5e, 0x70, 0xa4, 0x7c, 0xf5, 0x83, 0x90, 0xa8, 0xc3, 0xe8, 0x8f, 0xc8, 0xc4, 0x8e, 0x8b, 0x32, 0xe3, 0xda, 0x21, 0x0d, 0xfb, 0xe3, 0xe8, 0x81, 0xea, 0x56, 0x74, 0xb6, 0xa3, 0x48, 0xc2, 0x1e, 0x93, 0xf9, 0xe5, 0x5e, 0xa6, 0x5e, 0xfd }
,
  /* Prime q */
  96,
  { 0xd2, 0x00, 0xd4, 0x5e, 0x78, 0x8a, 0xac, 0xea, 0x60, 0x6a, 0x40, 0x1d, 0x04, 0x60, 0xf8, 0x7d, 0xd5, 0xc1, 0x02, 0x7e, 0x12, 0xdc, 0x1a, 0x0d, 0x75, 0x86, 0xe8, 0x93, 0x9d, 0x9c, 0xf7, 0x89, 0xb4, 0x0f, 0x51, 0xac, 0x04, 0x42, 0x96, 0x1d, 0xe7, 0xd2, 0x1c, 0xc2, 0x1e, 0x05, 0xc8, 0x31, 0x55, 0xc1, 0xf2, 0xaa, 0x91, 0x93, 0x38, 0x7c, 0xfd, 0xf9, 0x56, 0xcb, 0x48, 0xd1, 0x53, 0xba, 0x27, 0x04, 0x06, 0xf9, 0xbb, 0xba, 0x53, 0x7d, 0x49, 0x87, 0xd9, 0xe2, 0xf9, 0x94, 0x2d, 0x7a, 0x14, 0xcb, 0xff, 0xfe, 0xa7, 0x4f, 0xec, 0xdd, 0xa9, 0x28, 0xd2, 0x3e, 0x25, 0x9f, 0x5e, 0xe1 }
,
  /* p's CRT exponent dP */
  96,
  { 0xdb, 0x16, 0x80, 0x2f, 0x79, 0xa2, 0xf0, 0xd4, 0x5f, 0x35, 0x8d, 0x69, 0xfd, 0x33, 0xe4, 0x4b, 0x81, 0xfa, 0xe8, 0x28, 0x62, 0x2e, 0x93, 0xa5, 0x42, 0x53, 0xe9, 0x97, 0xd0, 0x1b, 0x07, 0x43, 0x75, 0x9d, 0xa0, 0xe8, 0x12, 0xb4, 0xaa, 0x4e, 0x6c, 0x8b, 0xea, 0xb2, 0x32, 0x8d, 0x54, 0x31, 0x95, 0x5a, 0x41, 0x8a, 0x67, 0xff, 0x26, 0xa8, 0xc5, 0xc8, 0x07, 0xa5, 0xda, 0x35, 0x4e, 0x05, 0xef, 0x31, 0xcc, 0x8c, 0xf7, 0x58, 0xf4, 0x63, 0x73, 0x29, 0x50, 0xb0, 0x3e, 0x26, 0x57, 0x26, 0xfb, 0x94, 0xe3, 0x9d, 0x6a, 0x57, 0x2a, 0x26, 0x24, 0x4a, 0xb0, 0x8d, 0xb7, 0x57, 0x52, 0xad }
,
  /* q's CRT exponent dQ */
  96,
  { 0xa0, 0xa3, 0x17, 0xcf, 0xe7, 0xdf, 0x14, 0x23, 0xf8, 0x7a, 0x6d, 0xee, 0x84, 0x51, 0xf4, 0xe2, 0xb4, 0xa6, 0x7e, 0x54, 0x97, 0xf2, 0x9b, 0x4f, 0x1e, 0x4e, 0x83, 0x0b, 0x9f, 0xad, 0xd9, 0x40, 0x11, 0x67, 0x02, 0x6f, 0x55, 0x96, 0xe5, 0xa3, 0x9c, 0x97, 0x81, 0x7e, 0x0f, 0x5f, 0x16, 0xe2, 0x7e, 0x19, 0xec, 0x99, 0x02, 0xe0, 0x1d, 0x7e, 0xa6, 0xfb, 0x9a, 0xa3, 0xc7, 0x60, 0xaf, 0xee, 0x1e, 0x38, 0x1b, 0x69, 0xde, 0x6a, 0xc9, 0xc0, 0x75, 0x85, 0xa0, 0x6a, 0xd9, 0xc4, 0xba, 0x00, 0xbf, 0x75, 0xc8, 0xad, 0x2f, 0xa8, 0x98, 0xa4, 0x79, 0xe8, 0x0a, 0xe2, 0x94, 0xfe, 0xd2, 0xa1 }
,
  /* CRT coefficient qInv */
  96,
  { 0x0b, 0x21, 0xf3, 0x35, 0xc3, 0x53, 0x34, 0x2e, 0xb4, 0x4c, 0x3a, 0xa2, 0x44, 0x45, 0x78, 0x0c, 0x2d, 0x65, 0x5b, 0x94, 0x01, 0x74, 0xca, 0xe3, 0x8c, 0x7c, 0x8a, 0x4e, 0x64, 0x93, 0xc0, 0xba, 0x9f, 0xd3, 0x03, 0x74, 0x82, 0x67, 0xb0, 0x83, 0xb9, 0xa7, 0xa6, 0xcb, 0x61, 0xe4, 0x2d, 0xb3, 0x62, 0xb8, 0xc9, 0x89, 0x6d, 0xb7, 0x06, 0x4e, 0x02, 0xad, 0x5a, 0xe6, 0x15, 0x87, 0xda, 0x15, 0xb4, 0x64, 0x9c, 0x90, 0x59, 0x49, 0x09, 0xfe, 0xb3, 0x7d, 0xbc, 0xb6, 0x54, 0xbe, 0xb7, 0x26, 0x8e, 0xc8, 0x01, 0xe5, 0xa8, 0xb4, 0xaa, 0x39, 0x11, 0xbe, 0xbd, 0x88, 0x54, 0x2f, 0x05, 0xbe }

}
,
{{
  "RSAES-OAEP Encryption Example 9.1",
  /* Message to be encrypted */
  61,
  { 0xf7, 0x35, 0xfd, 0x55, 0xba, 0x92, 0x59, 0x2c, 0x3b, 0x52, 0xb8, 0xf9, 0xc4, 0xf6, 0x9a, 0xaa, 0x1c, 0xbe, 0xf8, 0xfe, 0x88, 0xad, 0xd0, 0x95, 0x59, 0x54, 0x12, 0x46, 0x7f, 0x9c, 0xf4, 0xec, 0x0b, 0x89, 0x6c, 0x59, 0xed, 0xa1, 0x62, 0x10, 0xe7, 0x54, 0x9c, 0x8a, 0xbb, 0x10, 0xcd, 0xbc, 0x21, 0xa1, 0x2e, 0xc9, 0xb6, 0xb5, 0xb8, 0xfd, 0x2f, 0x10, 0x39, 0x9e, 0xb6 }
,
  /* Seed */
  20,
  { 0x8e, 0xc9, 0x65, 0xf1, 0x34, 0xa3, 0xec, 0x99, 0x31, 0xe9, 0x2a, 0x1c, 0xa0, 0xdc, 0x81, 0x69, 0xd5, 0xea, 0x70, 0x5c }
,
  /* Encryption */
  192,
  { 0x26, 0x7b, 0xcd, 0x11, 0x8a, 0xca, 0xb1, 0xfc, 0x8b, 0xa8, 0x1c, 0x85, 0xd7, 0x30, 0x03, 0xcb, 0x86, 0x10, 0xfa, 0x55, 0xc1, 0xd9, 0x7d, 0xa8, 0xd4, 0x8a, 0x7c, 0x7f, 0x06, 0x89, 0x6a, 0x4d, 0xb7, 0x51, 0xaa, 0x28, 0x42, 0x55, 0xb9, 0xd3, 0x6a, 0xd6, 0x5f, 0x37, 0x65, 0x3d, 0x82, 0x9f, 0x1b, 0x37, 0xf9, 0x7b, 0x80, 0x01, 0x94, 0x25, 0x45, 0xb2, 0xfc, 0x2c, 0x55, 0xa7, 0x37, 0x6c, 0xa7, 0xa1, 0xbe, 0x4b, 0x17, 0x60, 0xc8, 0xe0, 0x5a, 0x33, 0xe5, 0xaa, 0x25, 0x26, 0xb8, 0xd9, 0x8e, 0x31, 0x70, 0x88, 0xe7, 0x83, 0x4c, 0x75, 0x5b, 0x2a, 0x59, 0xb1, 0x26, 0x31, 0xa1, 0x82, 0xc0, 0x5d, 0x5d, 0x43, 0xab, 0x17, 0x79, 0x26, 0x4f, 0x84, 0x56, 0xf5, 0x15, 0xce, 0x57, 0xdf, 0xdf, 0x51, 0x2d, 0x54, 0x93, 0xda, 0xb7, 0xb7, 0x33, 0x8d, 0xc4, 0xb7, 0xd7, 0x8d, 0xb9, 0xc0, 0x91, 0xac, 0x3b, 0xaf, 0x53, 0x7a, 0x69, 0xfc, 0x7f, 0x54, 0x9d, 0x97, 0x9f, 0x0e, 0xff, 0x9a, 0x94, 0xfd, 0xa4, 0x16, 0x9b, 0xd4, 0xd1, 0xd1, 0x9a, 0x69, 0xc9, 0x9e, 0x33, 0xc3, 0xb5, 0x54, 0x90, 0xd5, 0x01, 0xb3, 0x9b, 0x1e, 0xda, 0xe1, 0x18, 0xff, 0x67, 0x93, 0xa1, 0x53, 0x26, 0x15, 0x84, 0xd3, 0xa5, 0xf3, 0x9f, 0x6e, 0x68, 0x2e, 0x3d, 0x17, 0xc8, 0xcd, 0x12, 0x61, 0xfa, 0x72 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 9.2",
  /* Message to be encrypted */
  39,
  { 0x81, 0xb9, 0x06, 0x60, 0x50, 0x15, 0xa6, 0x3a, 0xab, 0xe4, 0x2d, 0xdf, 0x11, 0xe1, 0x97, 0x89, 0x12, 0xf5, 0x40, 0x4c, 0x74, 0x74, 0xb2, 0x6d, 0xce, 0x3e, 0xd4, 0x82, 0xbf, 0x96, 0x1e, 0xcc, 0x81, 0x8b, 0xf4, 0x20, 0xc5, 0x46, 0x59 }
,
  /* Seed */
  20,
  { 0xec, 0xb1, 0xb8, 0xb2, 0x5f, 0xa5, 0x0c, 0xda, 0xb0, 0x8e, 0x56, 0x04, 0x28, 0x67, 0xf4, 0xaf, 0x58, 0x26, 0xd1, 0x6c }
,
  /* Encryption */
  192,
  { 0x93, 0xac, 0x9f, 0x06, 0x71, 0xec, 0x29, 0xac, 0xbb, 0x44, 0x4e, 0xff, 0xc1, 0xa5, 0x74, 0x13, 0x51, 0xd6, 0x0f, 0xdb, 0x0e, 0x39, 0x3f, 0xbf, 0x75, 0x4a, 0xcf, 0x0d, 0xe4, 0x97, 0x61, 0xa1, 0x48, 0x41, 0xdf, 0x77, 0x72, 0xe9, 0xbc, 0x82, 0x77, 0x39, 0x66, 0xa1, 0x58, 0x4c, 0x4d, 0x72, 0xba, 0xea, 0x00, 0x11, 0x8f, 0x83, 0xf3, 0x5c, 0xca, 0x6e, 0x53, 0x7c, 0xbd, 0x4d, 0x81, 0x1f, 0x55, 0x83, 0xb2, 0x97, 0x83, 0xd8, 0xa6, 0xd9, 0x4c, 0xd3, 0x1b, 0xe7, 0x0d, 0x6f, 0x52, 0x6c, 0x10, 0xff, 0x09, 0xc6, 0xfa, 0x7c, 0xe0, 0x69, 0x79, 0x5a, 0x3f, 0xcd, 0x05, 0x11, 0xfd, 0x5f, 0xcb, 0x56, 0x4b, 0xcc, 0x80, 0xea, 0x9c, 0x78, 0xf3, 0x8b, 0x80, 0x01, 0x25, 0x39, 0xd8, 0xa4, 0xdd, 0xf6, 0xfe, 0x81, 0xe9, 0xcd, 0xdb, 0x7f, 0x50, 0xdb, 0xbb, 0xbc, 0xc7, 0xe5, 0xd8, 0x60, 0x97, 0xcc, 0xf4, 0xec, 0x49, 0x18, 0x9f, 0xb8, 0xbf, 0x31, 0x8b, 0xe6, 0xd5, 0xa0, 0x71, 0x5d, 0x51, 0x6b, 0x49, 0xaf, 0x19, 0x12, 0x58, 0xcd, 0x32, 0xdc, 0x83, 0x3c, 0xe6, 0xeb, 0x46, 0x73, 0xc0, 0x3a, 0x19, 0xbb, 0xac, 0xe8, 0x8c, 0xc5, 0x48, 0x95, 0xf6, 0x36, 0xcc, 0x0c, 0x1e, 0xc8, 0x90, 0x96, 0xd1, 0x1c, 0xe2, 0x35, 0xa2, 0x65, 0xca, 0x17, 0x64, 0x23, 0x2a, 0x68, 0x9a, 0xe8 }

}
,
{
  "RSAES-OAEP Encryption Example 9.3",
  /* Message to be encrypted */
  17,
  { 0xfd, 0x32, 0x64, 0x29, 0xdf, 0x9b, 0x89, 0x0e, 0x09, 0xb5, 0x4b, 0x18, 0xb8, 0xf3, 0x4f, 0x1e, 0x24 }
,
  /* Seed */
  20,
  { 0xe8, 0x9b, 0xb0, 0x32, 0xc6, 0xce, 0x62, 0x2c, 0xbd, 0xb5, 0x3b, 0xc9, 0x46, 0x60, 0x14, 0xea, 0x77, 0xf7, 0x77, 0xc0 }
,
  /* Encryption */
  192,
  { 0x81, 0xeb, 0xdd, 0x95, 0x05, 0x4b, 0x0c, 0x82, 0x2e, 0xf9, 0xad, 0x76, 0x93, 0xf5, 0xa8, 0x7a, 0xdf, 0xb4, 0xb4, 0xc4, 0xce, 0x70, 0xdf, 0x2d, 0xf8, 0x4e, 0xd4, 0x9c, 0x04, 0xda, 0x58, 0xba, 0x5f, 0xc2, 0x0a, 0x19, 0xe1, 0xa6, 0xe8, 0xb7, 0xa3, 0x90, 0x0b, 0x22, 0x79, 0x6d, 0xc4, 0xe8, 0x69, 0xee, 0x6b, 0x42, 0x79, 0x2d, 0x15, 0xa8, 0xec, 0xeb, 0x56, 0xc0, 0x9c, 0x69, 0x91, 0x4e, 0x81, 0x3c, 0xea, 0x8f, 0x69, 0x31, 0xe4, 0xb8, 0xed, 0x6f, 0x42, 0x1a, 0xf2, 0x98, 0xd5, 0x95, 0xc9, 0x7f, 0x47, 0x89, 0xc7, 0xca, 0xa6, 0x12, 0xc7, 0xef, 0x36, 0x09, 0x84, 0xc2, 0x1b, 0x93, 0xed, 0xc5, 0x40, 0x10, 0x68, 0xb5, 0xaf, 0x4c, 0x78, 0xa8, 0x77, 0x1b, 0x98, 0x4d, 0x53, 0xb8, 0xea, 0x8a, 0xdf, 0x2f, 0x6a, 0x7d, 0x4a, 0x0b, 0xa7, 0x6c, 0x75, 0xe1, 0xdd, 0x9f, 0x65, 0x8f, 0x20, 0xde, 0xd4, 0xa4, 0x60, 0x71, 0xd4, 0x6d, 0x77, 0x91, 0xb5, 0x68, 0x03, 0xd8, 0xfe, 0xa7, 0xf0, 0xb0, 0xf8, 0xe4, 0x1a, 0xe3, 0xf0, 0x93, 0x83, 0xa6, 0xf9, 0x58, 0x5f, 0xe7, 0x75, 0x3e, 0xaa, 0xff, 0xd2, 0xbf, 0x94, 0x56, 0x31, 0x08, 0xbe, 0xec, 0xc2, 0x07, 0xbb, 0xb5, 0x35, 0xf5, 0xfc, 0xc7, 0x05, 0xf0, 0xdd, 0xe9, 0xf7, 0x08, 0xc6, 0x2f, 0x49, 0xa9, 0xc9, 0x03, 0x71, 0xd3 }

}
,
{
  "RSAES-OAEP Encryption Example 9.4",
  /* Message to be encrypted */
  62,
  { 0xf1, 0x45, 0x9b, 0x5f, 0x0c, 0x92, 0xf0, 0x1a, 0x0f, 0x72, 0x3a, 0x2e, 0x56, 0x62, 0x48, 0x4d, 0x8f, 0x8c, 0x0a, 0x20, 0xfc, 0x29, 0xda, 0xd6, 0xac, 0xd4, 0x3b, 0xb5, 0xf3, 0xef, 0xfd, 0xf4, 0xe1, 0xb6, 0x3e, 0x07, 0xfd, 0xfe, 0x66, 0x28, 0xd0, 0xd7, 0x4c, 0xa1, 0x9b, 0xf2, 0xd6, 0x9e, 0x4a, 0x0a, 0xbf, 0x86, 0xd2, 0x93, 0x92, 0x5a, 0x79, 0x67, 0x72, 0xf8, 0x08, 0x8e }
,
  /* Seed */
  20,
  { 0x60, 0x6f, 0x3b, 0x99, 0xc0, 0xb9, 0xcc, 0xd7, 0x71, 0xea, 0xa2, 0x9e, 0xa0, 0xe4, 0xc8, 0x84, 0xf3, 0x18, 0x9c, 0xcc }
,
  /* Encryption */
  192,
  { 0xbc, 0xc3, 0x5f, 0x94, 0xcd, 0xe6, 0x6c, 0xb1, 0x13, 0x66, 0x25, 0xd6, 0x25, 0xb9, 0x44, 0x32, 0xa3, 0x5b, 0x22, 0xf3, 0xd2, 0xfa, 0x11, 0xa6, 0x13, 0xff, 0x0f, 0xca, 0x5b, 0xd5, 0x7f, 0x87, 0xb9, 0x02, 0xcc, 0xdc, 0x1c, 0xd0, 0xae, 0xbc, 0xb0, 0x71, 0x5e, 0xe8, 0x69, 0xd1, 0xd1, 0xfe, 0x39, 0x5f, 0x67, 0x93, 0x00, 0x3f, 0x5e, 0xca, 0x46, 0x50, 0x59, 0xc8, 0x86, 0x60, 0xd4, 0x46, 0xff, 0x5f, 0x08, 0x18, 0x55, 0x20, 0x22, 0x55, 0x7e, 0x38, 0xc0, 0x8a, 0x67, 0xea, 0xd9, 0x91, 0x26, 0x22, 0x54, 0xf1, 0x06, 0x82, 0x97, 0x5e, 0xc5, 0x63, 0x97, 0x76, 0x85, 0x37, 0xf4, 0x97, 0x7a, 0xf6, 0xd5, 0xf6, 0xaa, 0xce, 0xb7, 0xfb, 0x25, 0xde, 0xc5, 0x93, 0x72, 0x30, 0x23, 0x1f, 0xd8, 0x97, 0x8a, 0xf4, 0x91, 0x19, 0xa2, 0x9f, 0x29, 0xe4, 0x24, 0xab, 0x82, 0x72, 0xb4, 0x75, 0x62, 0x79, 0x2d, 0x5c, 0x94, 0xf7, 0x74, 0xb8, 0x82, 0x9d, 0x0b, 0x0d, 0x9f, 0x1a, 0x8c, 0x9e, 0xdd, 0xf3, 0x75, 0x74, 0xd5, 0xfa, 0x24, 0x8e, 0xef, 0xa9, 0xc5, 0x27, 0x1f, 0xc5, 0xec, 0x25, 0x79, 0xc8, 0x1b, 0xdd, 0x61, 0xb4, 0x10, 0xfa, 0x61, 0xfe, 0x36, 0xe4, 0x24, 0x22, 0x1c, 0x11, 0x3a, 0xdd, 0xb2, 0x75, 0x66, 0x4c, 0x80, 0x1d, 0x34, 0xca, 0x8c, 0x63, 0x51, 0xe4, 0xa8, 0x58 }

}
,
{
  "RSAES-OAEP Encryption Example 9.5",
  /* Message to be encrypted */
  53,
  { 0x53, 0xe6, 0xe8, 0xc7, 0x29, 0xd6, 0xf9, 0xc3, 0x19, 0xdd, 0x31, 0x7e, 0x74, 0xb0, 0xdb, 0x8e, 0x4c, 0xcc, 0xa2, 0x5f, 0x3c, 0x83, 0x05, 0x74, 0x6e, 0x13, 0x7a, 0xc6, 0x3a, 0x63, 0xef, 0x37, 0x39, 0xe7, 0xb5, 0x95, 0xab, 0xb9, 0x6e, 0x8d, 0x55, 0xe5, 0x4f, 0x7b, 0xd4, 0x1a, 0xb4, 0x33, 0x37, 0x8f, 0xfb, 0x91, 0x1d }
,
  /* Seed */
  20,
  { 0xfc, 0xbc, 0x42, 0x14, 0x02, 0xe9, 0xec, 0xab, 0xc6, 0x08, 0x2a, 0xfa, 0x40, 0xba, 0x5f, 0x26, 0x52, 0x2c, 0x84, 0x0e }
,
  /* Encryption */
  192,
  { 0x23, 0x2a, 0xfb, 0xc9, 0x27, 0xfa, 0x08, 0xc2, 0xf6, 0xa2, 0x7b, 0x87, 0xd4, 0xa5, 0xcb, 0x09, 0xc0, 0x7d, 0xc2, 0x6f, 0xae, 0x73, 0xd7, 0x3a, 0x90, 0x55, 0x88, 0x39, 0xf4, 0xfd, 0x66, 0xd2, 0x81, 0xb8, 0x7e, 0xc7, 0x34, 0xbc, 0xe2, 0x37, 0xba, 0x16, 0x66, 0x98, 0xed, 0x82, 0x91, 0x06, 0xa7, 0xde, 0x69, 0x42, 0xcd, 0x6c, 0xdc, 0xe7, 0x8f, 0xed, 0x8d, 0x2e, 0x4d, 0x81, 0x42, 0x8e, 0x66, 0x49, 0x0d, 0x03, 0x62, 0x64, 0xce, 0xf9, 0x2a, 0xf9, 0x41, 0xd3, 0xe3, 0x50, 0x55, 0xfe, 0x39, 0x81, 0xe1, 0x4d, 0x29, 0xcb, 0xb9, 0xa4, 0xf6, 0x74, 0x73, 0x06, 0x3b, 0xae, 0xc7, 0x9a, 0x11, 0x79, 0xf5, 0xa1, 0x7c, 0x9c, 0x18, 0x32, 0xf2, 0x83, 0x8f, 0xd7, 0xd5, 0xe5, 0x9b, 0xb9, 0x65, 0x9d, 0x56, 0xdc, 0xe8, 0xa0, 0x19, 0xed, 0xef, 0x1b, 0xb3, 0xac, 0xcc, 0x69, 0x7c, 0xc6, 0xcc, 0x7a, 0x77, 0x8f, 0x60, 0xa0, 0x64, 0xc7, 0xf6, 0xf5, 0xd5, 0x29, 0xc6, 0x21, 0x02, 0x62, 0xe0, 0x03, 0xde, 0x58, 0x3e, 0x81, 0xe3, 0x16, 0x7b, 0x89, 0x97, 0x1f, 0xb8, 0xc0, 0xe1, 0x5d, 0x44, 0xff, 0xfe, 0xf8, 0x9b, 0x53, 0xd8, 0xd6, 0x4d, 0xd7, 0x97, 0xd1, 0x59, 0xb5, 0x6d, 0x2b, 0x08, 0xea, 0x53, 0x07, 0xea, 0x12, 0xc2, 0x41, 0xbd, 0x58, 0xd4, 0xee, 0x27, 0x8a, 0x1f, 0x2e }

}
,
{
  "RSAES-OAEP Encryption Example 9.6",
  /* Message to be encrypted */
  11,
  { 0xb6, 0xb2, 0x8e, 0xa2, 0x19, 0x8d, 0x0c, 0x10, 0x08, 0xbc, 0x64 }
,
  /* Seed */
  20,
  { 0x23, 0xaa, 0xde, 0x0e, 0x1e, 0x08, 0xbb, 0x9b, 0x9a, 0x78, 0xd2, 0x30, 0x2a, 0x52, 0xf9, 0xc2, 0x1b, 0x2e, 0x1b, 0xa2 }
,
  /* Encryption */
  192,
  { 0x43, 0x8c, 0xc7, 0xdc, 0x08, 0xa6, 0x8d, 0xa2, 0x49, 0xe4, 0x25, 0x05, 0xf8, 0x57, 0x3b, 0xa6, 0x0e, 0x2c, 0x27, 0x73, 0xd5, 0xb2, 0x90, 0xf4, 0xcf, 0x9d, 0xff, 0x71, 0x8e, 0x84, 0x20, 0x81, 0xc3, 0x83, 0xe6, 0x70, 0x24, 0xa0, 0xf2, 0x95, 0x94, 0xea, 0x98, 0x7b, 0x9d, 0x25, 0xe4, 0xb7, 0x38, 0xf2, 0x85, 0x97, 0x0d, 0x19, 0x5a, 0xbb, 0x3a, 0x8c, 0x80, 0x54, 0xe3, 0xd7, 0x9d, 0x6b, 0x9c, 0x9a, 0x83, 0x27, 0xba, 0x59, 0x6f, 0x12, 0x59, 0xe2, 0x71, 0x26, 0x67, 0x47, 0x66, 0x90, 0x7d, 0x8d, 0x58, 0x2f, 0xf3, 0xa8, 0x47, 0x61, 0x54, 0x92, 0x9a, 0xdb, 0x1e, 0x6d, 0x12, 0x35, 0xb2, 0xcc, 0xb4, 0xec, 0x8f, 0x66, 0x3b, 0xa9, 0xcc, 0x67, 0x0a, 0x92, 0xbe, 0xbd, 0x85, 0x3c, 0x8d, 0xbf, 0x69, 0xc6, 0x43, 0x6d, 0x01, 0x6f, 0x61, 0xad, 0xd8, 0x36, 0xe9, 0x47, 0x32, 0x45, 0x04, 0x34, 0x20, 0x7f, 0x9f, 0xd4, 0xc4, 0x3d, 0xec, 0x2a, 0x12, 0xa9, 0x58, 0xef, 0xa0, 0x1e, 0xfe, 0x26, 0x69, 0x89, 0x9b, 0x5e, 0x60, 0x4c, 0x25, 0x5c, 0x55, 0xfb, 0x71, 0x66, 0xde, 0x55, 0x89, 0xe3, 0x69, 0x59, 0x7b, 0xb0, 0x91, 0x68, 0xc0, 0x6d, 0xd5, 0xdb, 0x17, 0x7e, 0x06, 0xa1, 0x74, 0x0e, 0xb2, 0xd5, 0xc8, 0x2f, 0xae, 0xca, 0x6d, 0x92, 0xfc, 0xee, 0x99, 0x31, 0xba, 0x9f }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 10: A 2048-bit RSA Key Pair",
{
  /* RSA modulus n */
  256,
  { 0xae, 0x45, 0xed, 0x56, 0x01, 0xce, 0xc6, 0xb8, 0xcc, 0x05, 0xf8, 0x03, 0x93, 0x5c, 0x67, 0x4d, 0xdb, 0xe0, 0xd7, 0x5c, 0x4c, 0x09, 0xfd, 0x79, 0x51, 0xfc, 0x6b, 0x0c, 0xae, 0xc3, 0x13, 0xa8, 0xdf, 0x39, 0x97, 0x0c, 0x51, 0x8b, 0xff, 0xba, 0x5e, 0xd6, 0x8f, 0x3f, 0x0d, 0x7f, 0x22, 0xa4, 0x02, 0x9d, 0x41, 0x3f, 0x1a, 0xe0, 0x7e, 0x4e, 0xbe, 0x9e, 0x41, 0x77, 0xce, 0x23, 0xe7, 0xf5, 0x40, 0x4b, 0x56, 0x9e, 0x4e, 0xe1, 0xbd, 0xcf, 0x3c, 0x1f, 0xb0, 0x3e, 0xf1, 0x13, 0x80, 0x2d, 0x4f, 0x85, 0x5e, 0xb9, 0xb5, 0x13, 0x4b, 0x5a, 0x7c, 0x80, 0x85, 0xad, 0xca, 0xe6, 0xfa, 0x2f, 0xa1, 0x41, 0x7e, 0xc3, 0x76, 0x3b, 0xe1, 0x71, 0xb0, 0xc6, 0x2b, 0x76, 0x0e, 0xde, 0x23, 0xc1, 0x2a, 0xd9, 0x2b, 0x98, 0x08, 0x84, 0xc6, 0x41, 0xf5, 0xa8, 0xfa, 0xc2, 0x6b, 0xda, 0xd4, 0xa0, 0x33, 0x81, 0xa2, 0x2f, 0xe1, 0xb7, 0x54, 0x88, 0x50, 0x94, 0xc8, 0x25, 0x06, 0xd4, 0x01, 0x9a, 0x53, 0x5a, 0x28, 0x6a, 0xfe, 0xb2, 0x71, 0xbb, 0x9b, 0xa5, 0x92, 0xde, 0x18, 0xdc, 0xf6, 0x00, 0xc2, 0xae, 0xea, 0xe5, 0x6e, 0x02, 0xf7, 0xcf, 0x79, 0xfc, 0x14, 0xcf, 0x3b, 0xdc, 0x7c, 0xd8, 0x4f, 0xeb, 0xbb, 0xf9, 0x50, 0xca, 0x90, 0x30, 0x4b, 0x22, 0x19, 0xa7, 0xaa, 0x06, 0x3a, 0xef, 0xa2, 0xc3, 0xc1, 0x98, 0x0e, 0x56, 0x0c, 0xd6, 0x4a, 0xfe, 0x77, 0x95, 0x85, 0xb6, 0x10, 0x76, 0x57, 0xb9, 0x57, 0x85, 0x7e, 0xfd, 0xe6, 0x01, 0x09, 0x88, 0xab, 0x7d, 0xe4, 0x17, 0xfc, 0x88, 0xd8, 0xf3, 0x84, 0xc4, 0xe6, 0xe7, 0x2c, 0x3f, 0x94, 0x3e, 0x0c, 0x31, 0xc0, 0xc4, 0xa5, 0xcc, 0x36, 0xf8, 0x79, 0xd8, 0xa3, 0xac, 0x9d, 0x7d, 0x59, 0x86, 0x0e, 0xaa, 0xda, 0x6b, 0x83, 0xbb }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  256,
  { 0x05, 0x6b, 0x04, 0x21, 0x6f, 0xe5, 0xf3, 0x54, 0xac, 0x77, 0x25, 0x0a, 0x4b, 0x6b, 0x0c, 0x85, 0x25, 0xa8, 0x5c, 0x59, 0xb0, 0xbd, 0x80, 0xc5, 0x64, 0x50, 0xa2, 0x2d, 0x5f, 0x43, 0x8e, 0x59, 0x6a, 0x33, 0x3a, 0xa8, 0x75, 0xe2, 0x91, 0xdd, 0x43, 0xf4, 0x8c, 0xb8, 0x8b, 0x9d, 0x5f, 0xc0, 0xd4, 0x99, 0xf9, 0xfc, 0xd1, 0xc3, 0x97, 0xf9, 0xaf, 0xc0, 0x70, 0xcd, 0x9e, 0x39, 0x8c, 0x8d, 0x19, 0xe6, 0x1d, 0xb7, 0xc7, 0x41, 0x0a, 0x6b, 0x26, 0x75, 0xdf, 0xbf, 0x5d, 0x34, 0x5b, 0x80, 0x4d, 0x20, 0x1a, 0xdd, 0x50, 0x2d, 0x5c, 0xe2, 0xdf, 0xcb, 0x09, 0x1c, 0xe9, 0x99, 0x7b, 0xbe, 0xbe, 0x57, 0x30, 0x6f, 0x38, 0x3e, 0x4d, 0x58, 0x81, 0x03, 0xf0, 0x36, 0xf7, 0xe8, 0x5d, 0x19, 0x34, 0xd1, 0x52, 0xa3, 0x23, 0xe4, 0xa8, 0xdb, 0x45, 0x1d, 0x6f, 0x4a, 0x5b, 0x1b, 0x0f, 0x10, 0x2c, 0xc1, 0x50, 0xe0, 0x2f, 0xee, 0xe2, 0xb8, 0x8d, 0xea, 0x4a, 0xd4, 0xc1, 0xba, 0xcc, 0xb2, 0x4d, 0x84, 0x07, 0x2d, 0x14, 0xe1, 0xd2, 0x4a, 0x67, 0x71, 0xf7, 0x40, 0x8e, 0xe3, 0x05, 0x64, 0xfb, 0x86, 0xd4, 0x39, 0x3a, 0x34, 0xbc, 0xf0, 0xb7, 0x88, 0x50, 0x1d, 0x19, 0x33, 0x03, 0xf1, 0x3a, 0x22, 0x84, 0xb0, 0x01, 0xf0, 0xf6, 0x49, 0xea, 0xf7, 0x93, 0x28, 0xd4, 0xac, 0x5c, 0x43, 0x0a, 0xb4, 0x41, 0x49, 0x20, 0xa9, 0x46, 0x0e, 0xd1, 0xb7, 0xbc, 0x40, 0xec, 0x65, 0x3e, 0x87, 0x6d, 0x09, 0xab, 0xc5, 0x09, 0xae, 0x45, 0xb5, 0x25, 0x19, 0x01, 0x16, 0xa0, 0xc2, 0x61, 0x01, 0x84, 0x82, 0x98, 0x50, 0x9c, 0x1c, 0x3b, 0xf3, 0xa4, 0x83, 0xe7, 0x27, 0x40, 0x54, 0xe1, 0x5e, 0x97, 0x07, 0x50, 0x36, 0xe9, 0x89, 0xf6, 0x09, 0x32, 0x80, 0x7b, 0x52, 0x57, 0x75, 0x1e, 0x79 }
,
  /* Prime p */
  128,
  { 0xec, 0xf5, 0xae, 0xcd, 0x1e, 0x55, 0x15, 0xff, 0xfa, 0xcb, 0xd7, 0x5a, 0x28, 0x16, 0xc6, 0xeb, 0xf4, 0x90, 0x18, 0xcd, 0xfb, 0x46, 0x38, 0xe1, 0x85, 0xd6, 0x6a, 0x73, 0x96, 0xb6, 0xf8, 0x09, 0x0f, 0x80, 0x18, 0xc7, 0xfd, 0x95, 0xcc, 0x34, 0xb8, 0x57, 0xdc, 0x17, 0xf0, 0xcc, 0x65, 0x16, 0xbb, 0x13, 0x46, 0xab, 0x4d, 0x58, 0x2c, 0xad, 0xad, 0x7b, 0x41, 0x03, 0x35, 0x23, 0x87, 0xb7, 0x03, 0x38, 0xd0, 0x84, 0x04, 0x7c, 0x9d, 0x95, 0x39, 0xb6, 0x49, 0x62, 0x04, 0xb3, 0xdd, 0x6e, 0xa4, 0x42, 0x49, 0x92, 0x07, 0xbe, 0xc0, 0x1f, 0x96, 0x42, 0x87, 0xff, 0x63, 0x36, 0xc3, 0x98, 0x46, 0x58, 0x33, 0x68, 0x46, 0xf5, 0x6e, 0x46, 0x86, 0x18, 0x81, 0xc1, 0x02, 0x33, 0xd2, 0x17, 0x6b, 0xf1, 0x5a, 0x5e, 0x96, 0xdd, 0xc7, 0x80, 0xbc, 0x86, 0x8a, 0xa7, 0x7d, 0x3c, 0xe7, 0x69 }
,
  /* Prime q */
  128,
  { 0xbc, 0x46, 0xc4, 0x64, 0xfc, 0x6a, 0xc4, 0xca, 0x78, 0x3b, 0x0e, 0xb0, 0x8a, 0x3c, 0x84, 0x1b, 0x77, 0x2f, 0x7e, 0x9b, 0x2f, 0x28, 0xba, 0xbd, 0x58, 0x8a, 0xe8, 0x85, 0xe1, 0xa0, 0xc6, 0x1e, 0x48, 0x58, 0xa0, 0xfb, 0x25, 0xac, 0x29, 0x99, 0x90, 0xf3, 0x5b, 0xe8, 0x51, 0x64, 0xc2, 0x59, 0xba, 0x11, 0x75, 0xcd, 0xd7, 0x19, 0x27, 0x07, 0x13, 0x51, 0x84, 0x99, 0x2b, 0x6c, 0x29, 0xb7, 0x46, 0xdd, 0x0d, 0x2c, 0xab, 0xe1, 0x42, 0x83, 0x5f, 0x7d, 0x14, 0x8c, 0xc1, 0x61, 0x52, 0x4b, 0x4a, 0x09, 0x94, 0x6d, 0x48, 0xb8, 0x28, 0x47, 0x3f, 0x1c, 0xe7, 0x6b, 0x6c, 0xb6, 0x88, 0x6c, 0x34, 0x5c, 0x03, 0xe0, 0x5f, 0x41, 0xd5, 0x1b, 0x5c, 0x3a, 0x90, 0xa3, 0xf2, 0x40, 0x73, 0xc7, 0xd7, 0x4a, 0x4f, 0xe2, 0x5d, 0x9c, 0xf2, 0x1c, 0x75, 0x96, 0x0f, 0x3f, 0xc3, 0x86, 0x31, 0x83 }
,
  /* p's CRT exponent dP */
  128,
  { 0xc7, 0x35, 0x64, 0x57, 0x1d, 0x00, 0xfb, 0x15, 0xd0, 0x8a, 0x3d, 0xe9, 0x95, 0x7a, 0x50, 0x91, 0x5d, 0x71, 0x26, 0xe9, 0x44, 0x2d, 0xac, 0xf4, 0x2b, 0xc8, 0x2e, 0x86, 0x2e, 0x56, 0x73, 0xff, 0x6a, 0x00, 0x8e, 0xd4, 0xd2, 0xe3, 0x74, 0x61, 0x7d, 0xf8, 0x9f, 0x17, 0xa1, 0x60, 0xb4, 0x3b, 0x7f, 0xda, 0x9c, 0xb6, 0xb6, 0xb7, 0x42, 0x18, 0x60, 0x98, 0x15, 0xf7, 0xd4, 0x5c, 0xa2, 0x63, 0xc1, 0x59, 0xaa, 0x32, 0xd2, 0x72, 0xd1, 0x27, 0xfa, 0xf4, 0xbc, 0x8c, 0xa2, 0xd7, 0x73, 0x78, 0xe8, 0xae, 0xb1, 0x9b, 0x0a, 0xd7, 0xda, 0x3c, 0xb3, 0xde, 0x0a, 0xe7, 0x31, 0x49, 0x80, 0xf6, 0x2b, 0x6d, 0x4b, 0x0a, 0x87, 0x5d, 0x1d, 0xf0, 0x3c, 0x1b, 0xae, 0x39, 0xcc, 0xd8, 0x33, 0xef, 0x6c, 0xd7, 0xe2, 0xd9, 0x52, 0x8b, 0xf0, 0x84, 0xd1, 0xf9, 0x69, 0xe7, 0x94, 0xe9, 0xf6, 0xc1 }
,
  /* q's CRT exponent dQ */
  128,
  { 0x26, 0x58, 0xb3, 0x7f, 0x6d, 0xf9, 0xc1, 0x03, 0x0b, 0xe1, 0xdb, 0x68, 0x11, 0x7f, 0xa9, 0xd8, 0x7e, 0x39, 0xea, 0x2b, 0x69, 0x3b, 0x7e, 0x6d, 0x3a, 0x2f, 0x70, 0x94, 0x74, 0x13, 0xee, 0xc6, 0x14, 0x2e, 0x18, 0xfb, 0x8d, 0xfc, 0xb6, 0xac, 0x54, 0x5d, 0x7c, 0x86, 0xa0, 0xad, 0x48, 0xf8, 0x45, 0x71, 0x70, 0xf0, 0xef, 0xb2, 0x6b, 0xc4, 0x81, 0x26, 0xc5, 0x3e, 0xfd, 0x1d, 0x16, 0x92, 0x01, 0x98, 0xdc, 0x2a, 0x11, 0x07, 0xdc, 0x28, 0x2d, 0xb6, 0xa8, 0x0c, 0xd3, 0x06, 0x23, 0x60, 0xba, 0x3f, 0xa1, 0x3f, 0x70, 0xe4, 0x31, 0x2f, 0xf1, 0xa6, 0xcd, 0x6b, 0x8f, 0xc4, 0xcd, 0x9c, 0x5c, 0x3d, 0xb1, 0x7c, 0x6d, 0x6a, 0x57, 0x21, 0x2f, 0x73, 0xae, 0x29, 0xf6, 0x19, 0x32, 0x7b, 0xad, 0x59, 0xb1, 0x53, 0x85, 0x85, 0x85, 0xba, 0x4e, 0x28, 0xb6, 0x0a, 0x62, 0xa4, 0x5e, 0x49 }
,
  /* CRT coefficient qInv */
  128,
  { 0x6f, 0x38, 0x52, 0x6b, 0x39, 0x25, 0x08, 0x55, 0x34, 0xef, 0x3e, 0x41, 0x5a, 0x83, 0x6e, 0xde, 0x8b, 0x86, 0x15, 0x8a, 0x2c, 0x7c, 0xbf, 0xec, 0xcb, 0x0b, 0xd8, 0x34, 0x30, 0x4f, 0xec, 0x68, 0x3b, 0xa8, 0xd4, 0xf4, 0x79, 0xc4, 0x33, 0xd4, 0x34, 0x16, 0xe6, 0x32, 0x69, 0x62, 0x3c, 0xea, 0x10, 0x07, 0x76, 0xd8, 0x5a, 0xff, 0x40, 0x1d, 0x3f, 0xff, 0x61, 0x0e, 0xe6, 0x54, 0x11, 0xce, 0x3b, 0x13, 0x63, 0xd6, 0x3a, 0x97, 0x09, 0xee, 0xde, 0x42, 0x64, 0x7c, 0xea, 0x56, 0x14, 0x93, 0xd5, 0x45, 0x70, 0xa8, 0x79, 0xc1, 0x86, 0x82, 0xcd, 0x97, 0x71, 0x0b, 0x96, 0x20, 0x5e, 0xc3, 0x11, 0x17, 0xd7, 0x3b, 0x5f, 0x36, 0x22, 0x3f, 0xad, 0xd6, 0xe8, 0xba, 0x90, 0xdd, 0x7c, 0x0e, 0xe6, 0x1d, 0x44, 0xe1, 0x63, 0x25, 0x1e, 0x20, 0xc7, 0xf6, 0x6e, 0xb3, 0x05, 0x11, 0x7c, 0xb8 }

}
,
{{
  "RSAES-OAEP Encryption Example 10.1",
  /* Message to be encrypted */
  28,
  { 0x8b, 0xba, 0x6b, 0xf8, 0x2a, 0x6c, 0x0f, 0x86, 0xd5, 0xf1, 0x75, 0x6e, 0x97, 0x95, 0x68, 0x70, 0xb0, 0x89, 0x53, 0xb0, 0x6b, 0x4e, 0xb2, 0x05, 0xbc, 0x16, 0x94, 0xee }
,
  /* Seed */
  20,
  { 0x47, 0xe1, 0xab, 0x71, 0x19, 0xfe, 0xe5, 0x6c, 0x95, 0xee, 0x5e, 0xaa, 0xd8, 0x6f, 0x40, 0xd0, 0xaa, 0x63, 0xbd, 0x33 }
,
  /* Encryption */
  256,
  { 0x53, 0xea, 0x5d, 0xc0, 0x8c, 0xd2, 0x60, 0xfb, 0x3b, 0x85, 0x85, 0x67, 0x28, 0x7f, 0xa9, 0x15, 0x52, 0xc3, 0x0b, 0x2f, 0xeb, 0xfb, 0xa2, 0x13, 0xf0, 0xae, 0x87, 0x70, 0x2d, 0x06, 0x8d, 0x19, 0xba, 0xb0, 0x7f, 0xe5, 0x74, 0x52, 0x3d, 0xfb, 0x42, 0x13, 0x9d, 0x68, 0xc3, 0xc5, 0xaf, 0xee, 0xe0, 0xbf, 0xe4, 0xcb, 0x79, 0x69, 0xcb, 0xf3, 0x82, 0xb8, 0x04, 0xd6, 0xe6, 0x13, 0x96, 0x14, 0x4e, 0x2d, 0x0e, 0x60, 0x74, 0x1f, 0x89, 0x93, 0xc3, 0x01, 0x4b, 0x58, 0xb9, 0xb1, 0x95, 0x7a, 0x8b, 0xab, 0xcd, 0x23, 0xaf, 0x85, 0x4f, 0x4c, 0x35, 0x6f, 0xb1, 0x66, 0x2a, 0xa7, 0x2b, 0xfc, 0xc7, 0xe5, 0x86, 0x55, 0x9d, 0xc4, 0x28, 0x0d, 0x16, 0x0c, 0x12, 0x67, 0x85, 0xa7, 0x23, 0xeb, 0xee, 0xbe, 0xff, 0x71, 0xf1, 0x15, 0x94, 0x44, 0x0a, 0xae, 0xf8, 0x7d, 0x10, 0x79, 0x3a, 0x87, 0x74, 0xa2, 0x39, 0xd4, 0xa0, 0x4c, 0x87, 0xfe, 0x14, 0x67, 0xb9, 0xda, 0xf8, 0x52, 0x08, 0xec, 0x6c, 0x72, 0x55, 0x79, 0x4a, 0x96, 0xcc, 0x29, 0x14, 0x2f, 0x9a, 0x8b, 0xd4, 0x18, 0xe3, 0xc1, 0xfd, 0x67, 0x34, 0x4b, 0x0c, 0xd0, 0x82, 0x9d, 0xf3, 0xb2, 0xbe, 0xc6, 0x02, 0x53, 0x19, 0x62, 0x93, 0xc6, 0xb3, 0x4d, 0x3f, 0x75, 0xd3, 0x2f, 0x21, 0x3d, 0xd4, 0x5c, 0x62, 0x73, 0xd5, 0x05, 0xad, 0xf4, 0xcc, 0xed, 0x10, 0x57, 0xcb, 0x75, 0x8f, 0xc2, 0x6a, 0xee, 0xfa, 0x44, 0x12, 0x55, 0xed, 0x4e, 0x64, 0xc1, 0x99, 0xee, 0x07, 0x5e, 0x7f, 0x16, 0x64, 0x61, 0x82, 0xfd, 0xb4, 0x64, 0x73, 0x9b, 0x68, 0xab, 0x5d, 0xaf, 0xf0, 0xe6, 0x3e, 0x95, 0x52, 0x01, 0x68, 0x24, 0xf0, 0x54, 0xbf, 0x4d, 0x3c, 0x8c, 0x90, 0xa9, 0x7b, 0xb6, 0xb6, 0x55, 0x32, 0x84, 0xeb, 0x42, 0x9f, 0xcc }

}
,
#ifdef LTC_TEST_EXT
{
  "RSAES-OAEP Encryption Example 10.2",
  /* Message to be encrypted */
  16,
  { 0xe6, 0xad, 0x18, 0x1f, 0x05, 0x3b, 0x58, 0xa9, 0x04, 0xf2, 0x45, 0x75, 0x10, 0x37, 0x3e, 0x57 }
,
  /* Seed */
  20,
  { 0x6d, 0x17, 0xf5, 0xb4, 0xc1, 0xff, 0xac, 0x35, 0x1d, 0x19, 0x5b, 0xf7, 0xb0, 0x9d, 0x09, 0xf0, 0x9a, 0x40, 0x79, 0xcf }
,
  /* Encryption */
  256,
  { 0xa2, 0xb1, 0xa4, 0x30, 0xa9, 0xd6, 0x57, 0xe2, 0xfa, 0x1c, 0x2b, 0xb5, 0xed, 0x43, 0xff, 0xb2, 0x5c, 0x05, 0xa3, 0x08, 0xfe, 0x90, 0x93, 0xc0, 0x10, 0x31, 0x79, 0x5f, 0x58, 0x74, 0x40, 0x01, 0x10, 0x82, 0x8a, 0xe5, 0x8f, 0xb9, 0xb5, 0x81, 0xce, 0x9d, 0xdd, 0xd3, 0xe5, 0x49, 0xae, 0x04, 0xa0, 0x98, 0x54, 0x59, 0xbd, 0xe6, 0xc6, 0x26, 0x59, 0x4e, 0x7b, 0x05, 0xdc, 0x42, 0x78, 0xb2, 0xa1, 0x46, 0x5c, 0x13, 0x68, 0x40, 0x88, 0x23, 0xc8, 0x5e, 0x96, 0xdc, 0x66, 0xc3, 0xa3, 0x09, 0x83, 0xc6, 0x39, 0x66, 0x4f, 0xc4, 0x56, 0x9a, 0x37, 0xfe, 0x21, 0xe5, 0xa1, 0x95, 0xb5, 0x77, 0x6e, 0xed, 0x2d, 0xf8, 0xd8, 0xd3, 0x61, 0xaf, 0x68, 0x6e, 0x75, 0x02, 0x29, 0xbb, 0xd6, 0x63, 0xf1, 0x61, 0x86, 0x8a, 0x50, 0x61, 0x5e, 0x0c, 0x33, 0x7b, 0xec, 0x0c, 0xa3, 0x5f, 0xec, 0x0b, 0xb1, 0x9c, 0x36, 0xeb, 0x2e, 0x0b, 0xbc, 0xc0, 0x58, 0x2f, 0xa1, 0xd9, 0x3a, 0xac, 0xdb, 0x06, 0x10, 0x63, 0xf5, 0x9f, 0x2c, 0xe1, 0xee, 0x43, 0x60, 0x5e, 0x5d, 0x89, 0xec, 0xa1, 0x83, 0xd2, 0xac, 0xdf, 0xe9, 0xf8, 0x10, 0x11, 0x02, 0x2a, 0xd3, 0xb4, 0x3a, 0x3d, 0xd4, 0x17, 0xda, 0xc9, 0x4b, 0x4e, 0x11, 0xea, 0x81, 0xb1, 0x92, 0x96, 0x6e, 0x96, 0x6b, 0x18, 0x20, 0x82, 0xe7, 0x19, 0x64, 0x60, 0x7b, 0x4f, 0x80, 0x02, 0xf3, 0x62, 0x99, 0x84, 0x4a, 0x11, 0xf2, 0xae, 0x0f, 0xae, 0xac, 0x2e, 0xae, 0x70, 0xf8, 0xf4, 0xf9, 0x80, 0x88, 0xac, 0xdc, 0xd0, 0xac, 0x55, 0x6e, 0x9f, 0xcc, 0xc5, 0x11, 0x52, 0x19, 0x08, 0xfa, 0xd2, 0x6f, 0x04, 0xc6, 0x42, 0x01, 0x45, 0x03, 0x05, 0x77, 0x87, 0x58, 0xb0, 0x53, 0x8b, 0xf8, 0xb5, 0xbb, 0x14, 0x4a, 0x82, 0x8e, 0x62, 0x97, 0x95 }

}
,
{
  "RSAES-OAEP Encryption Example 10.3",
  /* Message to be encrypted */
  26,
  { 0x51, 0x0a, 0x2c, 0xf6, 0x0e, 0x86, 0x6f, 0xa2, 0x34, 0x05, 0x53, 0xc9, 0x4e, 0xa3, 0x9f, 0xbc, 0x25, 0x63, 0x11, 0xe8, 0x3e, 0x94, 0x45, 0x4b, 0x41, 0x24 }
,
  /* Seed */
  20,
  { 0x38, 0x53, 0x87, 0x51, 0x4d, 0xec, 0xcc, 0x7c, 0x74, 0x0d, 0xd8, 0xcd, 0xf9, 0xda, 0xee, 0x49, 0xa1, 0xcb, 0xfd, 0x54 }
,
  /* Encryption */
  256,
  { 0x98, 0x86, 0xc3, 0xe6, 0x76, 0x4a, 0x8b, 0x9a, 0x84, 0xe8, 0x41, 0x48, 0xeb, 0xd8, 0xc3, 0xb1, 0xaa, 0x80, 0x50, 0x38, 0x1a, 0x78, 0xf6, 0x68, 0x71, 0x4c, 0x16, 0xd9, 0xcf, 0xd2, 0xa6, 0xed, 0xc5, 0x69, 0x79, 0xc5, 0x35, 0xd9, 0xde, 0xe3, 0xb4, 0x4b, 0x85, 0xc1, 0x8b, 0xe8, 0x92, 0x89, 0x92, 0x37, 0x17, 0x11, 0x47, 0x22, 0x16, 0xd9, 0x5d, 0xda, 0x98, 0xd2, 0xee, 0x83, 0x47, 0xc9, 0xb1, 0x4d, 0xff, 0xdf, 0xf8, 0x4a, 0xa4, 0x8d, 0x25, 0xac, 0x06, 0xf7, 0xd7, 0xe6, 0x53, 0x98, 0xac, 0x96, 0x7b, 0x1c, 0xe9, 0x09, 0x25, 0xf6, 0x7d, 0xce, 0x04, 0x9b, 0x7f, 0x81, 0x2d, 0xb0, 0x74, 0x29, 0x97, 0xa7, 0x4d, 0x44, 0xfe, 0x81, 0xdb, 0xe0, 0xe7, 0xa3, 0xfe, 0xaf, 0x2e, 0x5c, 0x40, 0xaf, 0x88, 0x8d, 0x55, 0x0d, 0xdb, 0xbe, 0x3b, 0xc2, 0x06, 0x57, 0xa2, 0x95, 0x43, 0xf8, 0xfc, 0x29, 0x13, 0xb9, 0xbd, 0x1a, 0x61, 0xb2, 0xab, 0x22, 0x56, 0xec, 0x40, 0x9b, 0xbd, 0x7d, 0xc0, 0xd1, 0x77, 0x17, 0xea, 0x25, 0xc4, 0x3f, 0x42, 0xed, 0x27, 0xdf, 0x87, 0x38, 0xbf, 0x4a, 0xfc, 0x67, 0x66, 0xff, 0x7a, 0xff, 0x08, 0x59, 0x55, 0x5e, 0xe2, 0x83, 0x92, 0x0f, 0x4c, 0x8a, 0x63, 0xc4, 0xa7, 0x34, 0x0c, 0xba, 0xfd, 0xdc, 0x33, 0x9e, 0xcd, 0xb4, 0xb0, 0x51, 0x50, 0x02, 0xf9, 0x6c, 0x93, 0x2b, 0x5b, 0x79, 0x16, 0x7a, 0xf6, 0x99, 0xc0, 0xad, 0x3f, 0xcc, 0xfd, 0xf0, 0xf4, 0x4e, 0x85, 0xa7, 0x02, 0x62, 0xbf, 0x2e, 0x18, 0xfe, 0x34, 0xb8, 0x50, 0x58, 0x99, 0x75, 0xe8, 0x67, 0xff, 0x96, 0x9d, 0x48, 0xea, 0xbf, 0x21, 0x22, 0x71, 0x54, 0x6c, 0xdc, 0x05, 0xa6, 0x9e, 0xcb, 0x52, 0x6e, 0x52, 0x87, 0x0c, 0x83, 0x6f, 0x30, 0x7b, 0xd7, 0x98, 0x78, 0x0e, 0xde }

}
,
{
  "RSAES-OAEP Encryption Example 10.4",
  /* Message to be encrypted */
  36,
  { 0xbc, 0xdd, 0x19, 0x0d, 0xa3, 0xb7, 0xd3, 0x00, 0xdf, 0x9a, 0x06, 0xe2, 0x2c, 0xaa, 0xe2, 0xa7, 0x5f, 0x10, 0xc9, 0x1f, 0xf6, 0x67, 0xb7, 0xc1, 0x6b, 0xde, 0x8b, 0x53, 0x06, 0x4a, 0x26, 0x49, 0xa9, 0x40, 0x45, 0xc9 }
,
  /* Seed */
  20,
  { 0x5c, 0xac, 0xa6, 0xa0, 0xf7, 0x64, 0x16, 0x1a, 0x96, 0x84, 0xf8, 0x5d, 0x92, 0xb6, 0xe0, 0xef, 0x37, 0xca, 0x8b, 0x65 }
,
  /* Encryption */
  256,
  { 0x63, 0x18, 0xe9, 0xfb, 0x5c, 0x0d, 0x05, 0xe5, 0x30, 0x7e, 0x16, 0x83, 0x43, 0x6e, 0x90, 0x32, 0x93, 0xac, 0x46, 0x42, 0x35, 0x8a, 0xaa, 0x22, 0x3d, 0x71, 0x63, 0x01, 0x3a, 0xba, 0x87, 0xe2, 0xdf, 0xda, 0x8e, 0x60, 0xc6, 0x86, 0x0e, 0x29, 0xa1, 0xe9, 0x26, 0x86, 0x16, 0x3e, 0xa0, 0xb9, 0x17, 0x5f, 0x32, 0x9c, 0xa3, 0xb1, 0x31, 0xa1, 0xed, 0xd3, 0xa7, 0x77, 0x59, 0xa8, 0xb9, 0x7b, 0xad, 0x6a, 0x4f, 0x8f, 0x43, 0x96, 0xf2, 0x8c, 0xf6, 0xf3, 0x9c, 0xa5, 0x81, 0x12, 0xe4, 0x81, 0x60, 0xd6, 0xe2, 0x03, 0xda, 0xa5, 0x85, 0x6f, 0x3a, 0xca, 0x5f, 0xfe, 0xd5, 0x77, 0xaf, 0x49, 0x94, 0x08, 0xe3, 0xdf, 0xd2, 0x33, 0xe3, 0xe6, 0x04, 0xdb, 0xe3, 0x4a, 0x9c, 0x4c, 0x90, 0x82, 0xde, 0x65, 0x52, 0x7c, 0xac, 0x63, 0x31, 0xd2, 0x9d, 0xc8, 0x0e, 0x05, 0x08, 0xa0, 0xfa, 0x71, 0x22, 0xe7, 0xf3, 0x29, 0xf6, 0xcc, 0xa5, 0xcf, 0xa3, 0x4d, 0x4d, 0x1d, 0xa4, 0x17, 0x80, 0x54, 0x57, 0xe0, 0x08, 0xbe, 0xc5, 0x49, 0xe4, 0x78, 0xff, 0x9e, 0x12, 0xa7, 0x63, 0xc4, 0x77, 0xd1, 0x5b, 0xbb, 0x78, 0xf5, 0xb6, 0x9b, 0xd5, 0x78, 0x30, 0xfc, 0x2c, 0x4e, 0xd6, 0x86, 0xd7, 0x9b, 0xc7, 0x2a, 0x95, 0xd8, 0x5f, 0x88, 0x13, 0x4c, 0x6b, 0x0a, 0xfe, 0x56, 0xa8, 0xcc, 0xfb, 0xc8, 0x55, 0x82, 0x8b, 0xb3, 0x39, 0xbd, 0x17, 0x90, 0x9c, 0xf1, 0xd7, 0x0d, 0xe3, 0x33, 0x5a, 0xe0, 0x70, 0x39, 0x09, 0x3e, 0x60, 0x6d, 0x65, 0x53, 0x65, 0xde, 0x65, 0x50, 0xb8, 0x72, 0xcd, 0x6d, 0xe1, 0xd4, 0x40, 0xee, 0x03, 0x1b, 0x61, 0x94, 0x5f, 0x62, 0x9a, 0xd8, 0xa3, 0x53, 0xb0, 0xd4, 0x09, 0x39, 0xe9, 0x6a, 0x3c, 0x45, 0x0d, 0x2a, 0x8d, 0x5e, 0xee, 0x9f, 0x67, 0x80, 0x93, 0xc8 }

}
,
{
  "RSAES-OAEP Encryption Example 10.5",
  /* Message to be encrypted */
  23,
  { 0xa7, 0xdd, 0x6c, 0x7d, 0xc2, 0x4b, 0x46, 0xf9, 0xdd, 0x5f, 0x1e, 0x91, 0xad, 0xa4, 0xc3, 0xb3, 0xdf, 0x94, 0x7e, 0x87, 0x72, 0x32, 0xa9 }
,
  /* Seed */
  20,
  { 0x95, 0xbc, 0xa9, 0xe3, 0x85, 0x98, 0x94, 0xb3, 0xdd, 0x86, 0x9f, 0xa7, 0xec, 0xd5, 0xbb, 0xc6, 0x40, 0x1b, 0xf3, 0xe4 }
,
  /* Encryption */
  256,
  { 0x75, 0x29, 0x08, 0x72, 0xcc, 0xfd, 0x4a, 0x45, 0x05, 0x66, 0x0d, 0x65, 0x1f, 0x56, 0xda, 0x6d, 0xaa, 0x09, 0xca, 0x13, 0x01, 0xd8, 0x90, 0x63, 0x2f, 0x6a, 0x99, 0x2f, 0x3d, 0x56, 0x5c, 0xee, 0x46, 0x4a, 0xfd, 0xed, 0x40, 0xed, 0x3b, 0x5b, 0xe9, 0x35, 0x67, 0x14, 0xea, 0x5a, 0xa7, 0x65, 0x5f, 0x4a, 0x13, 0x66, 0xc2, 0xf1, 0x7c, 0x72, 0x8f, 0x6f, 0x2c, 0x5a, 0x5d, 0x1f, 0x8e, 0x28, 0x42, 0x9b, 0xc4, 0xe6, 0xf8, 0xf2, 0xcf, 0xf8, 0xda, 0x8d, 0xc0, 0xe0, 0xa9, 0x80, 0x8e, 0x45, 0xfd, 0x09, 0xea, 0x2f, 0xa4, 0x0c, 0xb2, 0xb6, 0xce, 0x6f, 0xff, 0xf5, 0xc0, 0xe1, 0x59, 0xd1, 0x1b, 0x68, 0xd9, 0x0a, 0x85, 0xf7, 0xb8, 0x4e, 0x10, 0x3b, 0x09, 0xe6, 0x82, 0x66, 0x64, 0x80, 0xc6, 0x57, 0x50, 0x5c, 0x09, 0x29, 0x25, 0x94, 0x68, 0xa3, 0x14, 0x78, 0x6d, 0x74, 0xea, 0xb1, 0x31, 0x57, 0x3c, 0xf2, 0x34, 0xbf, 0x57, 0xdb, 0x7d, 0x9e, 0x66, 0xcc, 0x67, 0x48, 0x19, 0x2e, 0x00, 0x2d, 0xc0, 0xde, 0xea, 0x93, 0x05, 0x85, 0xf0, 0x83, 0x1f, 0xdc, 0xd9, 0xbc, 0x33, 0xd5, 0x1f, 0x79, 0xed, 0x2f, 0xfc, 0x16, 0xbc, 0xf4, 0xd5, 0x98, 0x12, 0xfc, 0xeb, 0xca, 0xa3, 0xf9, 0x06, 0x9b, 0x0e, 0x44, 0x56, 0x86, 0xd6, 0x44, 0xc2, 0x5c, 0xcf, 0x63, 0xb4, 0x56, 0xee, 0x5f, 0xa6, 0xff, 0xe9, 0x6f, 0x19, 0xcd, 0xf7, 0x51, 0xfe, 0xd9, 0xea, 0xf3, 0x59, 0x57, 0x75, 0x4d, 0xbf, 0x4b, 0xfe, 0xa5, 0x21, 0x6a, 0xa1, 0x84, 0x4d, 0xc5, 0x07, 0xcb, 0x2d, 0x08, 0x0e, 0x72, 0x2e, 0xba, 0x15, 0x03, 0x08, 0xc2, 0xb5, 0xff, 0x11, 0x93, 0x62, 0x0f, 0x17, 0x66, 0xec, 0xf4, 0x48, 0x1b, 0xaf, 0xb9, 0x43, 0xbd, 0x29, 0x28, 0x77, 0xf2, 0x13, 0x6c, 0xa4, 0x94, 0xab, 0xa0 }

}
,
{
  "RSAES-OAEP Encryption Example 10.6",
  /* Message to be encrypted */
  45,
  { 0xea, 0xf1, 0xa7, 0x3a, 0x1b, 0x0c, 0x46, 0x09, 0x53, 0x7d, 0xe6, 0x9c, 0xd9, 0x22, 0x8b, 0xbc, 0xfb, 0x9a, 0x8c, 0xa8, 0xc6, 0xc3, 0xef, 0xaf, 0x05, 0x6f, 0xe4, 0xa7, 0xf4, 0x63, 0x4e, 0xd0, 0x0b, 0x7c, 0x39, 0xec, 0x69, 0x22, 0xd7, 0xb8, 0xea, 0x2c, 0x04, 0xeb, 0xac }
,
  /* Seed */
  20,
  { 0x9f, 0x47, 0xdd, 0xf4, 0x2e, 0x97, 0xee, 0xa8, 0x56, 0xa9, 0xbd, 0xbc, 0x71, 0x4e, 0xb3, 0xac, 0x22, 0xf6, 0xeb, 0x32 }
,
  /* Encryption */
  256,
  { 0x2d, 0x20, 0x7a, 0x73, 0x43, 0x2a, 0x8f, 0xb4, 0xc0, 0x30, 0x51, 0xb3, 0xf7, 0x3b, 0x28, 0xa6, 0x17, 0x64, 0x09, 0x8d, 0xfa, 0x34, 0xc4, 0x7a, 0x20, 0x99, 0x5f, 0x81, 0x15, 0xaa, 0x68, 0x16, 0x67, 0x9b, 0x55, 0x7e, 0x82, 0xdb, 0xee, 0x58, 0x49, 0x08, 0xc6, 0xe6, 0x97, 0x82, 0xd7, 0xde, 0xb3, 0x4d, 0xbd, 0x65, 0xaf, 0x06, 0x3d, 0x57, 0xfc, 0xa7, 0x6a, 0x5f, 0xd0, 0x69, 0x49, 0x2f, 0xd6, 0x06, 0x8d, 0x99, 0x84, 0xd2, 0x09, 0x35, 0x05, 0x65, 0xa6, 0x2e, 0x5c, 0x77, 0xf2, 0x30, 0x38, 0xc1, 0x2c, 0xb1, 0x0c, 0x66, 0x34, 0x70, 0x9b, 0x54, 0x7c, 0x46, 0xf6, 0xb4, 0xa7, 0x09, 0xbd, 0x85, 0xca, 0x12, 0x2d, 0x74, 0x46, 0x5e, 0xf9, 0x77, 0x62, 0xc2, 0x97, 0x63, 0xe0, 0x6d, 0xbc, 0x7a, 0x9e, 0x73, 0x8c, 0x78, 0xbf, 0xca, 0x01, 0x02, 0xdc, 0x5e, 0x79, 0xd6, 0x5b, 0x97, 0x3f, 0x28, 0x24, 0x0c, 0xaa, 0xb2, 0xe1, 0x61, 0xa7, 0x8b, 0x57, 0xd2, 0x62, 0x45, 0x7e, 0xd8, 0x19, 0x5d, 0x53, 0xe3, 0xc7, 0xae, 0x9d, 0xa0, 0x21, 0x88, 0x3c, 0x6d, 0xb7, 0xc2, 0x4a, 0xfd, 0xd2, 0x32, 0x2e, 0xac, 0x97, 0x2a, 0xd3, 0xc3, 0x54, 0xc5, 0xfc, 0xef, 0x1e, 0x14, 0x6c, 0x3a, 0x02, 0x90, 0xfb, 0x67, 0xad, 0xf0, 0x07, 0x06, 0x6e, 0x00, 0x42, 0x8d, 0x2c, 0xec, 0x18, 0xce, 0x58, 0xf9, 0x32, 0x86, 0x98, 0xde, 0xfe, 0xf4, 0xb2, 0xeb, 0x5e, 0xc7, 0x69, 0x18, 0xfd, 0xe1, 0xc1, 0x98, 0xcb, 0xb3, 0x8b, 0x7a, 0xfc, 0x67, 0x62, 0x6a, 0x9a, 0xef, 0xec, 0x43, 0x22, 0xbf, 0xd9, 0x0d, 0x25, 0x63, 0x48, 0x1c, 0x9a, 0x22, 0x1f, 0x78, 0xc8, 0x27, 0x2c, 0x82, 0xd1, 0xb6, 0x2a, 0xb9, 0x14, 0xe1, 0xc6, 0x9f, 0x6a, 0xf6, 0xef, 0x30, 0xca, 0x52, 0x60, 0xdb, 0x4a, 0x46 }

}
,
#endif /* LTC_TEST_EXT */
}
},
};

