# Copyright (C) 2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Test Windowname

The purpose of this test is to try the application.getwindowname() method
"""

from mago import TestCase
import unittest
import ldtp

class TestGetWindowName(TestCase):
    """The minimal test that can be written with mago
    """
    launcher = 'gedit'
    window_name = 'frm*gedit*'

    def test_01getwindowname_nodiscover(self):
        """Get the window name using the getwindowname method from the
        application class in non discovery mode

        """
        wname = self.application.get_windowname()
        print "***" , wname
        self.assertEqual(self.window_name, wname)
        ldtp.wait(2)


    def test_02getwindowname_discover(self):
        """Get the window name using the getwindowname method from the
        application class with forced discovery

        """
        wname = self.application.get_windowname( discover = True)
        print "***" , wname
        self.assertEqual('frmCalculator', wname)
        ldtp.wait(2)

if __name__ == "__main__":
    unittest.main()
