/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.tok;

import com.jclark.xml.tok.ASCIIEncoding;
import com.jclark.xml.tok.ContentToken;
import com.jclark.xml.tok.EmptyTokenException;
import com.jclark.xml.tok.EndOfPrologException;
import com.jclark.xml.tok.ExtensibleTokenException;
import com.jclark.xml.tok.ISO8859_1Encoding;
import com.jclark.xml.tok.InternalEncoding;
import com.jclark.xml.tok.InvalidTokenException;
import com.jclark.xml.tok.PartialCharException;
import com.jclark.xml.tok.PartialTokenException;
import com.jclark.xml.tok.Position;
import com.jclark.xml.tok.SingleByteEncoding;
import com.jclark.xml.tok.Token;
import com.jclark.xml.tok.UTF16BigEndianEncoding;
import com.jclark.xml.tok.UTF16LittleEndianEncoding;
import com.jclark.xml.tok.UTF8Encoding;

public abstract class Encoding {
    public static final int TOK_DATA_CHARS = 0;
    public static final int TOK_DATA_NEWLINE = 1;
    public static final int TOK_START_TAG_NO_ATTS = 2;
    public static final int TOK_START_TAG_WITH_ATTS = 3;
    public static final int TOK_EMPTY_ELEMENT_NO_ATTS = 4;
    public static final int TOK_EMPTY_ELEMENT_WITH_ATTS = 5;
    public static final int TOK_END_TAG = 6;
    public static final int TOK_CDATA_SECT_OPEN = 7;
    public static final int TOK_CDATA_SECT_CLOSE = 8;
    public static final int TOK_ENTITY_REF = 9;
    public static final int TOK_MAGIC_ENTITY_REF = 10;
    public static final int TOK_CHAR_REF = 11;
    public static final int TOK_CHAR_PAIR_REF = 12;
    public static final int TOK_PI = 13;
    public static final int TOK_XML_DECL = 14;
    public static final int TOK_COMMENT = 15;
    public static final int TOK_ATTRIBUTE_VALUE_S = 16;
    public static final int TOK_PARAM_ENTITY_REF = 17;
    public static final int TOK_PROLOG_S = 18;
    public static final int TOK_DECL_OPEN = 19;
    public static final int TOK_DECL_CLOSE = 20;
    public static final int TOK_NAME = 21;
    public static final int TOK_NMTOKEN = 22;
    public static final int TOK_POUND_NAME = 23;
    public static final int TOK_OR = 24;
    public static final int TOK_PERCENT = 25;
    public static final int TOK_OPEN_PAREN = 26;
    public static final int TOK_CLOSE_PAREN = 27;
    public static final int TOK_OPEN_BRACKET = 28;
    public static final int TOK_CLOSE_BRACKET = 29;
    public static final int TOK_LITERAL = 30;
    public static final int TOK_NAME_QUESTION = 31;
    public static final int TOK_NAME_ASTERISK = 32;
    public static final int TOK_NAME_PLUS = 33;
    public static final int TOK_COND_SECT_OPEN = 34;
    public static final int TOK_COND_SECT_CLOSE = 35;
    public static final int TOK_CLOSE_PAREN_QUESTION = 36;
    public static final int TOK_CLOSE_PAREN_ASTERISK = 37;
    public static final int TOK_CLOSE_PAREN_PLUS = 38;
    public static final int TOK_COMMA = 39;
    private static Encoding utf8Encoding;
    private static Encoding utf16LittleEndianEncoding;
    private static Encoding utf16BigEndianEncoding;
    private static Encoding internalEncoding;
    private static Encoding iso8859_1Encoding;
    private static Encoding asciiEncoding;
    private static final byte UTF8_ENCODING = 0;
    private static final byte UTF16_LITTLE_ENDIAN_ENCODING = 1;
    private static final byte UTF16_BIG_ENDIAN_ENCODING = 2;
    private static final byte INTERNAL_ENCODING = 3;
    private static final byte ISO8859_1_ENCODING = 4;
    private static final byte ASCII_ENCODING = 5;
    static final int BT_LEAD2 = -2;
    static final int BT_LEAD3 = -3;
    static final int BT_LEAD4 = -4;
    static final int BT_NONXML = -5;
    static final int BT_MALFORM = -6;
    static final int BT_LT = -7;
    static final int BT_AMP = -8;
    static final int BT_RSQB = -9;
    static final int BT_CR = -10;
    static final int BT_LF = -11;
    static final int BT_GT = 0;
    static final int BT_QUOT = 1;
    static final int BT_APOS = 2;
    static final int BT_EQUALS = 3;
    static final int BT_QUEST = 4;
    static final int BT_EXCL = 5;
    static final int BT_SOL = 6;
    static final int BT_SEMI = 7;
    static final int BT_NUM = 8;
    static final int BT_LSQB = 9;
    static final int BT_S = 10;
    static final int BT_NMSTRT = 11;
    static final int BT_NAME = 12;
    static final int BT_MINUS = 13;
    static final int BT_OTHER = 14;
    static final int BT_PERCNT = 15;
    static final int BT_LPAR = 16;
    static final int BT_RPAR = 17;
    static final int BT_AST = 18;
    static final int BT_PLUS = 19;
    static final int BT_COMMA = 20;
    static final int BT_VERBAR = 21;
    static final byte[] asciiTypeTable;
    private int minBPC;
    private static final String CDATA = "CDATA[";
    private static final String nameStartSingles = ":_\u0386\u038c\u03da\u03dc\u03de\u03e0\u0559\u06d5\u093d\u09b2\u0a5e\u0a8d\u0abd\u0ae0\u0b3d\u0b9c\u0cde\u0e30\u0e84\u0e8a\u0e8d\u0ea5\u0ea7\u0eb0\u0ebd\u1100\u1109\u113c\u113e\u1140\u114c\u114e\u1150\u1159\u1163\u1165\u1167\u1169\u1175\u119e\u11a8\u11ab\u11ba\u11eb\u11f0\u11f9\u1f59\u1f5b\u1f5d\u1fbe\u2126\u212e\u3007";
    private static final String nameStartRanges = "AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u00ff\u0100\u0131\u0134\u013e\u0141\u0148\u014a\u017e\u0180\u01c3\u01cd\u01f0\u01f4\u01f5\u01fa\u0217\u0250\u02a8\u02bb\u02c1\u0388\u038a\u038e\u03a1\u03a3\u03ce\u03d0\u03d6\u03e2\u03f3\u0401\u040c\u040e\u044f\u0451\u045c\u045e\u0481\u0490\u04c4\u04c7\u04c8\u04cb\u04cc\u04d0\u04eb\u04ee\u04f5\u04f8\u04f9\u0531\u0556\u0561\u0586\u05d0\u05ea\u05f0\u05f2\u0621\u063a\u0641\u064a\u0671\u06b7\u06ba\u06be\u06c0\u06ce\u06d0\u06d3\u06e5\u06e6\u0905\u0939\u0958\u0961\u0985\u098c\u098f\u0990\u0993\u09a8\u09aa\u09b0\u09b6\u09b9\u09dc\u09dd\u09df\u09e1\u09f0\u09f1\u0a05\u0a0a\u0a0f\u0a10\u0a13\u0a28\u0a2a\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59\u0a5c\u0a72\u0a74\u0a85\u0a8b\u0a8f\u0a91\u0a93\u0aa8\u0aaa\u0ab0\u0ab2\u0ab3\u0ab5\u0ab9\u0b05\u0b0c\u0b0f\u0b10\u0b13\u0b28\u0b2a\u0b30\u0b32\u0b33\u0b36\u0b39\u0b5c\u0b5d\u0b5f\u0b61\u0b85\u0b8a\u0b8e\u0b90\u0b92\u0b95\u0b99\u0b9a\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8\u0baa\u0bae\u0bb5\u0bb7\u0bb9\u0c05\u0c0c\u0c0e\u0c10\u0c12\u0c28\u0c2a\u0c33\u0c35\u0c39\u0c60\u0c61\u0c85\u0c8c\u0c8e\u0c90\u0c92\u0ca8\u0caa\u0cb3\u0cb5\u0cb9\u0ce0\u0ce1\u0d05\u0d0c\u0d0e\u0d10\u0d12\u0d28\u0d2a\u0d39\u0d60\u0d61\u0e01\u0e2e\u0e32\u0e33\u0e40\u0e45\u0e81\u0e82\u0e87\u0e88\u0e94\u0e97\u0e99\u0e9f\u0ea1\u0ea3\u0eaa\u0eab\u0ead\u0eae\u0eb2\u0eb3\u0ec0\u0ec4\u0f40\u0f47\u0f49\u0f69\u10a0\u10c5\u10d0\u10f6\u1102\u1103\u1105\u1107\u110b\u110c\u110e\u1112\u1154\u1155\u115f\u1161\u116d\u116e\u1172\u1173\u11ae\u11af\u11b7\u11b8\u11bc\u11c2\u1e00\u1e9b\u1ea0\u1ef9\u1f00\u1f15\u1f18\u1f1d\u1f20\u1f45\u1f48\u1f4d\u1f50\u1f57\u1f5f\u1f7d\u1f80\u1fb4\u1fb6\u1fbc\u1fc2\u1fc4\u1fc6\u1fcc\u1fd0\u1fd3\u1fd6\u1fdb\u1fe0\u1fec\u1ff2\u1ff4\u1ff6\u1ffc\u212a\u212b\u2180\u2182\u3041\u3094\u30a1\u30fa\u3105\u312c\uac00\ud7a3\u4e00\u9fa5\u3021\u3029";
    private static final String nameSingles = "-.\u05bf\u05c4\u0670\u093c\u094d\u09bc\u09be\u09bf\u09d7\u0a02\u0a3c\u0a3e\u0a3f\u0abc\u0b3c\u0bd7\u0d57\u0e31\u0eb1\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f97\u0fb9\u20e1\u3099\u309a\u00b7\u02d0\u02d1\u0387\u0640\u0e46\u0ec6\u3005";
    private static final String nameRanges = "\u0300\u0345\u0360\u0361\u0483\u0486\u0591\u05a1\u05a3\u05b9\u05bb\u05bd\u05c1\u05c2\u064b\u0652\u06d6\u06dc\u06dd\u06df\u06e0\u06e4\u06e7\u06e8\u06ea\u06ed\u0901\u0903\u093e\u094c\u0951\u0954\u0962\u0963\u0981\u0983\u09c0\u09c4\u09c7\u09c8\u09cb\u09cd\u09e2\u09e3\u0a40\u0a42\u0a47\u0a48\u0a4b\u0a4d\u0a70\u0a71\u0a81\u0a83\u0abe\u0ac5\u0ac7\u0ac9\u0acb\u0acd\u0b01\u0b03\u0b3e\u0b43\u0b47\u0b48\u0b4b\u0b4d\u0b56\u0b57\u0b82\u0b83\u0bbe\u0bc2\u0bc6\u0bc8\u0bca\u0bcd\u0c01\u0c03\u0c3e\u0c44\u0c46\u0c48\u0c4a\u0c4d\u0c55\u0c56\u0c82\u0c83\u0cbe\u0cc4\u0cc6\u0cc8\u0cca\u0ccd\u0cd5\u0cd6\u0d02\u0d03\u0d3e\u0d43\u0d46\u0d48\u0d4a\u0d4d\u0e34\u0e3a\u0e47\u0e4e\u0eb4\u0eb9\u0ebb\u0ebc\u0ec8\u0ecd\u0f18\u0f19\u0f71\u0f84\u0f86\u0f8b\u0f90\u0f95\u0f99\u0fad\u0fb1\u0fb7\u20d0\u20dc\u302a\u302f09\u0660\u0669\u06f0\u06f9\u0966\u096f\u09e6\u09ef\u0a66\u0a6f\u0ae6\u0aef\u0b66\u0b6f\u0be7\u0bef\u0c66\u0c6f\u0ce6\u0cef\u0d66\u0d6f\u0e50\u0e59\u0ed0\u0ed9\u0f20\u0f29\u3031\u3035\u309d\u309e\u30fc\u30fe";
    static byte[][] charTypeTable;

    /*
     * Unable to fully structure code
     */
    private final int scanPoundName(byte[] var1_1, int var2_2, int var3_3, Token var4_4) throws PartialTokenException, InvalidTokenException, ExtensibleTokenException {
        if (var2_2 == var3_3) {
            throw new PartialTokenException();
        }
        switch (this.byteType(var1_1, var2_2)) {
            case 11: {
                var2_2 += this.minBPC;
                ** GOTO lbl61
            }
            case -2: {
                if (var3_3 - var2_2 < 2) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType2(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 2;
                ** GOTO lbl61
            }
            case -3: {
                if (var3_3 - var2_2 < 3) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType3(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 3;
                ** GOTO lbl61
            }
            case -4: {
                if (var3_3 - var2_2 < 4) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType4(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 4;
                if (true) ** GOTO lbl61
            }
            default: {
                throw new InvalidTokenException(var2_2);
            }
        }
        do {
            switch (this.byteType(var1_1, var2_2)) {
                case 11: 
                case 12: 
                case 13: {
                    var2_2 += this.minBPC;
                    break;
                }
                case -2: {
                    if (var3_3 - var2_2 < 2) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar2(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 2;
                    break;
                }
                case -3: {
                    if (var3_3 - var2_2 < 3) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar3(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 3;
                    break;
                }
                case -4: {
                    if (var3_3 - var2_2 < 4) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar4(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 4;
                    break;
                }
                case -11: 
                case -10: 
                case 0: 
                case 10: 
                case 15: 
                case 17: 
                case 21: {
                    var4_4.tokenEnd = var2_2;
                    return 23;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
lbl61:
            // 8 sources

        } while (var2_2 != var3_3);
        throw new ExtensibleTokenException(23);
    }

    public final int skipIgnoreSect(byte[] byArray, int n, int n2) throws PartialTokenException, InvalidTokenException {
        if (this.minBPC > 1) {
            n2 = this.adjustEnd(n, n2);
        }
        int n3 = 0;
        block8: while (n != n2) {
            switch (this.byteType(byArray, n)) {
                case -2: {
                    if (n2 - n < 2) {
                        throw new PartialCharException(n);
                    }
                    this.check2(byArray, n);
                    n += 2;
                    break;
                }
                case -3: {
                    if (n2 - n < 3) {
                        throw new PartialCharException(n);
                    }
                    this.check3(byArray, n);
                    n += 3;
                    break;
                }
                case -4: {
                    if (n2 - n < 4) {
                        throw new PartialCharException(n);
                    }
                    this.check4(byArray, n);
                    n += 4;
                    break;
                }
                case -6: 
                case -5: {
                    throw new InvalidTokenException(n);
                }
                case -7: {
                    if ((n += this.minBPC) == n2) break block8;
                    if (!this.charMatches(byArray, n, '!')) continue block8;
                    if ((n += this.minBPC) == n2) break block8;
                    if (!this.charMatches(byArray, n, '[')) continue block8;
                    ++n3;
                    n += this.minBPC;
                    break;
                }
                case -9: {
                    if ((n += this.minBPC) == n2) break block8;
                    if (!this.charMatches(byArray, n, ']')) continue block8;
                    if ((n += this.minBPC) == n2) break block8;
                    if (this.charMatches(byArray, n, '>')) {
                        if (n3 == 0) {
                            return n + this.minBPC;
                        }
                        --n3;
                    } else if (this.charMatches(byArray, n, ']')) continue block8;
                    n += this.minBPC;
                    break;
                }
                default: {
                    n += this.minBPC;
                }
            }
        }
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    private final int scanDecl(byte[] var1_1, int var2_2, int var3_3, Token var4_4) throws InvalidTokenException, PartialTokenException {
        if (var2_2 == var3_3) {
            throw new PartialTokenException();
        }
        switch (this.byteType(var1_1, var2_2)) {
            case 13: {
                return this.scanComment(var1_1, var2_2 + this.minBPC, var3_3, var4_4);
            }
            case 9: {
                var4_4.tokenEnd = var2_2 + this.minBPC;
                return 34;
            }
            case 11: {
                var2_2 += this.minBPC;
                if (true) ** GOTO lbl30
            }
            default: {
                throw new InvalidTokenException(var2_2);
            }
        }
        do {
            switch (this.byteType(var1_1, var2_2)) {
                case 15: {
                    if (var2_2 + this.minBPC == var3_3) {
                        throw new PartialTokenException();
                    }
                    switch (this.byteType(var1_1, var2_2 + this.minBPC)) {
                        case -11: 
                        case -10: 
                        case 10: 
                        case 15: {
                            throw new InvalidTokenException(var2_2);
                        }
                    }
                }
                case -11: 
                case -10: 
                case 10: {
                    var4_4.tokenEnd = var2_2;
                    return 19;
                }
                case 11: {
                    var2_2 += this.minBPC;
                    break;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
lbl30:
            // 2 sources

        } while (var2_2 != var3_3);
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    public final int tokenizeProlog(byte[] var1_1, int var2_2, int var3_3, Token var4_4) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException, EndOfPrologException {
        if (this.minBPC > 1) {
            var3_3 = this.adjustEnd(var2_2, var3_3);
        }
        if (var2_2 == var3_3) {
            throw new EmptyTokenException();
        }
        switch (this.byteType(var1_1, var2_2)) {
            case 1: {
                return this.scanLit(1, var1_1, var2_2 + this.minBPC, var3_3, var4_4);
            }
            case 2: {
                return this.scanLit(2, var1_1, var2_2 + this.minBPC, var3_3, var4_4);
            }
            case -7: {
                if ((var2_2 += this.minBPC) == var3_3) {
                    throw new PartialTokenException();
                }
                switch (this.byteType(var1_1, var2_2)) {
                    case 5: {
                        return this.scanDecl(var1_1, var2_2 + this.minBPC, var3_3, var4_4);
                    }
                    case 4: {
                        return this.scanPi(var1_1, var2_2 + this.minBPC, var3_3, var4_4);
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 11: {
                        var4_4.tokenEnd = var2_2 - this.minBPC;
                        throw new EndOfPrologException();
                    }
                }
                throw new InvalidTokenException(var2_2);
            }
            case -10: {
                if (var2_2 + this.minBPC == var3_3) {
                    throw new ExtensibleTokenException(18);
                }
            }
            case -11: 
            case 10: {
                block58: while ((var2_2 += this.minBPC) != var3_3) {
                    switch (this.byteType(var1_1, var2_2)) {
                        case -11: 
                        case 10: {
                            continue block58;
                        }
                        case -10: {
                            if (var2_2 + this.minBPC != var3_3) ** break;
                        }
                    }
                    var4_4.tokenEnd = var2_2;
                    return 18;
                }
                var4_4.tokenEnd = var2_2;
                return 18;
            }
            case 15: {
                return this.scanPercent(var1_1, var2_2 + this.minBPC, var3_3, var4_4);
            }
            case 20: {
                var4_4.tokenEnd = var2_2 + this.minBPC;
                return 39;
            }
            case 9: {
                var4_4.tokenEnd = var2_2 + this.minBPC;
                return 28;
            }
            case -9: {
                if ((var2_2 += this.minBPC) == var3_3) {
                    throw new ExtensibleTokenException(29);
                }
                if (this.charMatches(var1_1, var2_2, ']')) {
                    if (var2_2 + this.minBPC == var3_3) {
                        throw new PartialTokenException();
                    }
                    if (this.charMatches(var1_1, var2_2 + this.minBPC, '>')) {
                        var4_4.tokenEnd = var2_2 + 2 * this.minBPC;
                        return 35;
                    }
                }
                var4_4.tokenEnd = var2_2;
                return 29;
            }
            case 16: {
                var4_4.tokenEnd = var2_2 + this.minBPC;
                return 26;
            }
            case 17: {
                if ((var2_2 += this.minBPC) == var3_3) {
                    throw new ExtensibleTokenException(27);
                }
                switch (this.byteType(var1_1, var2_2)) {
                    case 18: {
                        var4_4.tokenEnd = var2_2 + this.minBPC;
                        return 37;
                    }
                    case 4: {
                        var4_4.tokenEnd = var2_2 + this.minBPC;
                        return 36;
                    }
                    case 19: {
                        var4_4.tokenEnd = var2_2 + this.minBPC;
                        return 38;
                    }
                    case -11: 
                    case -10: 
                    case 0: 
                    case 10: 
                    case 17: 
                    case 20: 
                    case 21: {
                        var4_4.tokenEnd = var2_2;
                        return 27;
                    }
                }
                throw new InvalidTokenException(var2_2);
            }
            case 21: {
                var4_4.tokenEnd = var2_2 + this.minBPC;
                return 24;
            }
            case 0: {
                var4_4.tokenEnd = var2_2 + this.minBPC;
                return 20;
            }
            case 8: {
                return this.scanPoundName(var1_1, var2_2 + this.minBPC, var3_3, var4_4);
            }
            case -2: {
                if (var3_3 - var2_2 < 2) {
                    throw new PartialCharException(var2_2);
                }
                switch (this.byteType2(var1_1, var2_2)) {
                    case 11: {
                        var2_2 += 2;
                        var5_5 = 21;
                        ** GOTO lbl181
                    }
                    case 12: {
                        var2_2 += 2;
                        var5_5 = 22;
                        ** GOTO lbl181
                    }
                    default: {
                        throw new InvalidTokenException(var2_2);
                    }
                }
            }
            case -3: {
                if (var3_3 - var2_2 < 3) {
                    throw new PartialCharException(var2_2);
                }
                switch (this.byteType3(var1_1, var2_2)) {
                    case 11: {
                        var2_2 += 3;
                        var5_5 = 21;
                        ** GOTO lbl181
                    }
                    case 12: {
                        var2_2 += 3;
                        var5_5 = 22;
                        ** GOTO lbl181
                    }
                    default: {
                        throw new InvalidTokenException(var2_2);
                    }
                }
            }
            case -4: {
                if (var3_3 - var2_2 < 4) {
                    throw new PartialCharException(var2_2);
                }
                switch (this.byteType4(var1_1, var2_2)) {
                    case 11: {
                        var2_2 += 4;
                        var5_5 = 21;
                        ** GOTO lbl181
                    }
                    case 12: {
                        var2_2 += 4;
                        var5_5 = 22;
                        ** GOTO lbl181
                    }
                    default: {
                        throw new InvalidTokenException(var2_2);
                    }
                }
            }
            case 11: {
                var5_5 = 21;
                var2_2 += this.minBPC;
                ** GOTO lbl181
            }
            case 12: 
            case 13: {
                var5_5 = 22;
                var2_2 += this.minBPC;
                if (true) ** GOTO lbl181
            }
            default: {
                throw new InvalidTokenException(var2_2);
            }
        }
        do {
            switch (this.byteType(var1_1, var2_2)) {
                case 11: 
                case 12: 
                case 13: {
                    var2_2 += this.minBPC;
                    break;
                }
                case -2: {
                    if (var3_3 - var2_2 < 2) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar2(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 2;
                    break;
                }
                case -3: {
                    if (var3_3 - var2_2 < 3) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar3(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 3;
                    break;
                }
                case -4: {
                    if (var3_3 - var2_2 < 4) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar4(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 4;
                    break;
                }
                case -11: 
                case -10: 
                case 0: 
                case 9: 
                case 10: 
                case 15: 
                case 17: 
                case 20: 
                case 21: {
                    var4_4.tokenEnd = var2_2;
                    return var5_5;
                }
                case 19: {
                    if (var5_5 != 21) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var4_4.tokenEnd = var2_2 + this.minBPC;
                    return 33;
                }
                case 18: {
                    if (var5_5 != 21) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var4_4.tokenEnd = var2_2 + this.minBPC;
                    return 32;
                }
                case 4: {
                    if (var5_5 != 21) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var4_4.tokenEnd = var2_2 + this.minBPC;
                    return 31;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
lbl181:
            // 12 sources

        } while (var2_2 != var3_3);
        throw new ExtensibleTokenException(var5_5);
    }

    abstract int byteToAscii(byte[] var1, int var2);

    void check2(byte[] byArray, int n) throws InvalidTokenException {
    }

    private final int scanHexCharRef(byte[] byArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException {
        if (n != n2) {
            int n3;
            int n4 = this.byteToAscii(byArray, n);
            switch (n4) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n3 = n4 - 48;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n3 = n4 - 55;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    n3 = n4 - 87;
                    break;
                }
                default: {
                    throw new InvalidTokenException(n);
                }
            }
            n += this.minBPC;
            while (n != n2) {
                n4 = this.byteToAscii(byArray, n);
                switch (n4) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        n3 = (n3 << 4) + n4 - 48;
                        break;
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        n3 = (n3 << 4) + n4 - 55;
                        break;
                    }
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        n3 = (n3 << 4) + n4 - 87;
                        break;
                    }
                    case 59: {
                        token.tokenEnd = n + this.minBPC;
                        return this.setRefChar(n3, token);
                    }
                    default: {
                        throw new InvalidTokenException(n);
                    }
                }
                if (n3 >= 0x110000) {
                    throw new InvalidTokenException(n);
                }
                n += this.minBPC;
            }
        }
        throw new PartialTokenException();
    }

    private final boolean isNameChar3(byte[] byArray, int n) {
        int n2 = this.byteType3(byArray, n);
        return n2 == 12 || n2 == 11;
    }

    public final String getPublicId(byte[] byArray, int n, int n2) throws InvalidTokenException {
        StringBuffer stringBuffer = new StringBuffer();
        n += this.minBPC;
        n2 -= this.minBPC;
        while (n != n2) {
            char c = (char)this.byteToAscii(byArray, n);
            switch (this.byteType(byArray, n)) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    stringBuffer.append(c);
                    break;
                }
                case 10: {
                    if (this.charMatches(byArray, n, '\t')) {
                        throw new InvalidTokenException(n);
                    }
                }
                case -11: 
                case -10: {
                    if (stringBuffer.length() <= 0 || stringBuffer.charAt(stringBuffer.length() - 1) == ' ') break;
                    stringBuffer.append(' ');
                    break;
                }
                case 11: 
                case 12: {
                    if ((c & 0xFFFFFF80) == 0) {
                        stringBuffer.append(c);
                        break;
                    }
                }
                default: {
                    switch (c) {
                        default: {
                            throw new InvalidTokenException(n);
                        }
                        case '$': 
                        case '@': 
                    }
                }
            }
            n += this.minBPC;
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    abstract boolean charMatches(byte[] var1, int var2, char var3);

    abstract int byteType(byte[] var1, int var2);

    /*
     * Unable to fully structure code
     */
    private final int scanPi(byte[] var1_1, int var2_2, int var3_3, Token var4_4) throws PartialTokenException, InvalidTokenException {
        var5_5 = var2_2;
        if (var2_2 == var3_3) {
            throw new PartialTokenException();
        }
        switch (this.byteType(var1_1, var2_2)) {
            case 11: {
                var2_2 += this.minBPC;
                ** GOTO lbl106
            }
            case -2: {
                if (var3_3 - var2_2 < 2) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType2(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 2;
                ** GOTO lbl106
            }
            case -3: {
                if (var3_3 - var2_2 < 3) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType3(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 3;
                ** GOTO lbl106
            }
            case -4: {
                if (var3_3 - var2_2 < 4) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType4(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 4;
                if (true) ** GOTO lbl106
            }
            default: {
                throw new InvalidTokenException(var2_2);
            }
        }
        do {
            switch (this.byteType(var1_1, var2_2)) {
                case 11: 
                case 12: 
                case 13: {
                    var2_2 += this.minBPC;
                    break;
                }
                case -2: {
                    if (var3_3 - var2_2 < 2) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar2(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 2;
                    break;
                }
                case -3: {
                    if (var3_3 - var2_2 < 3) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar3(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 3;
                    break;
                }
                case -4: {
                    if (var3_3 - var2_2 < 4) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar4(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 4;
                    break;
                }
                case -11: 
                case -10: 
                case 10: {
                    var6_6 = this.targetIsXml(var1_1, var5_5, var2_2);
                    var4_4.nameEnd = var2_2;
                    var2_2 += this.minBPC;
                    block22: while (var2_2 != var3_3) {
                        switch (this.byteType(var1_1, var2_2)) {
                            case -2: {
                                if (var3_3 - var2_2 < 2) {
                                    throw new PartialCharException(var2_2);
                                }
                                this.check2(var1_1, var2_2);
                                var2_2 += 2;
                                break;
                            }
                            case -3: {
                                if (var3_3 - var2_2 < 3) {
                                    throw new PartialCharException(var2_2);
                                }
                                this.check3(var1_1, var2_2);
                                var2_2 += 3;
                                break;
                            }
                            case -4: {
                                if (var3_3 - var2_2 < 4) {
                                    throw new PartialCharException(var2_2);
                                }
                                this.check4(var1_1, var2_2);
                                var2_2 += 4;
                                break;
                            }
                            case -6: 
                            case -5: {
                                throw new InvalidTokenException(var2_2);
                            }
                            case 4: {
                                if ((var2_2 += this.minBPC) == var3_3) {
                                    throw new PartialTokenException();
                                }
                                if (!this.charMatches(var1_1, var2_2, '>')) continue block22;
                                var4_4.tokenEnd = var2_2 + this.minBPC;
                                if (var6_6) {
                                    return 14;
                                }
                                return 13;
                            }
                            default: {
                                var2_2 += this.minBPC;
                            }
                        }
                    }
                    throw new PartialTokenException();
                }
                case 4: {
                    var4_4.nameEnd = var2_2;
                    if ((var2_2 += this.minBPC) == var3_3) {
                        throw new PartialTokenException();
                    }
                    this.checkCharMatches(var1_1, var2_2, '>');
                    var4_4.tokenEnd = var2_2 + this.minBPC;
                    if (this.targetIsXml(var1_1, var5_5, var4_4.nameEnd)) {
                        return 14;
                    }
                    return 13;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
lbl106:
            // 8 sources

        } while (var2_2 != var3_3);
        throw new PartialTokenException();
    }

    private final int scanCdataSection(byte[] byArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException {
        if (n2 - n < 6 * this.minBPC) {
            throw new PartialTokenException();
        }
        int n3 = 0;
        while (n3 < CDATA.length()) {
            this.checkCharMatches(byArray, n, CDATA.charAt(n3));
            ++n3;
            n += this.minBPC;
        }
        token.tokenEnd = n;
        return 7;
    }

    public final int tokenizeCdataSection(byte[] byArray, int n, int n2, Token token) throws EmptyTokenException, PartialTokenException, InvalidTokenException, ExtensibleTokenException {
        if (this.minBPC > 1) {
            n2 = this.adjustEnd(n, n2);
        }
        if (n == n2) {
            throw new EmptyTokenException();
        }
        switch (this.byteType(byArray, n)) {
            case -9: {
                if ((n += this.minBPC) == n2) {
                    throw new PartialTokenException();
                }
                if (!this.charMatches(byArray, n, ']')) break;
                if ((n += this.minBPC) == n2) {
                    throw new PartialTokenException();
                }
                if (!this.charMatches(byArray, n, '>')) {
                    n -= this.minBPC;
                    break;
                }
                token.tokenEnd = n + this.minBPC;
                return 8;
            }
            case -10: {
                if ((n += this.minBPC) == n2) {
                    throw new ExtensibleTokenException(1);
                }
                if (this.byteType(byArray, n) == -11) {
                    n += this.minBPC;
                }
                token.tokenEnd = n;
                return 1;
            }
            case -11: {
                token.tokenEnd = n + this.minBPC;
                return 1;
            }
            case -6: 
            case -5: {
                throw new InvalidTokenException(n);
            }
            case -2: {
                if (n2 - n < 2) {
                    throw new PartialCharException(n);
                }
                this.check2(byArray, n);
                n += 2;
                break;
            }
            case -3: {
                if (n2 - n < 3) {
                    throw new PartialCharException(n);
                }
                this.check3(byArray, n);
                n += 3;
                break;
            }
            case -4: {
                if (n2 - n < 4) {
                    throw new PartialCharException(n);
                }
                this.check4(byArray, n);
                n += 4;
                break;
            }
            default: {
                n += this.minBPC;
            }
        }
        token.tokenEnd = this.extendCdata(byArray, n, n2);
        return 0;
    }

    private final boolean isNameChar4(byte[] byArray, int n) {
        int n2 = this.byteType4(byArray, n);
        return n2 == 12 || n2 == 11;
    }

    public final int tokenizeAttributeValue(byte[] byArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException {
        if (this.minBPC > 1) {
            n2 = this.adjustEnd(n, n2);
        }
        if (n == n2) {
            throw new EmptyTokenException();
        }
        int n3 = n;
        while (n != n2) {
            switch (this.byteType(byArray, n)) {
                case -2: {
                    if (n2 - n < 2) {
                        throw new PartialCharException(n);
                    }
                    n += 2;
                    break;
                }
                case -3: {
                    if (n2 - n < 3) {
                        throw new PartialCharException(n);
                    }
                    n += 3;
                    break;
                }
                case -4: {
                    if (n2 - n < 4) {
                        throw new PartialCharException(n);
                    }
                    n += 4;
                    break;
                }
                case -8: {
                    if (n == n3) {
                        return this.scanRef(byArray, n + this.minBPC, n2, token);
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -7: {
                    throw new InvalidTokenException(n);
                }
                case 10: {
                    if (n == n3) {
                        token.tokenEnd = n + this.minBPC;
                        return 16;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -11: {
                    if (n == n3) {
                        token.tokenEnd = n + this.minBPC;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -10: {
                    if (n == n3) {
                        if ((n += this.minBPC) == n2) {
                            throw new ExtensibleTokenException(1);
                        }
                        if (this.byteType(byArray, n) == -11) {
                            n += this.minBPC;
                        }
                        token.tokenEnd = n;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                default: {
                    n += this.minBPC;
                }
            }
        }
        token.tokenEnd = n;
        return 0;
    }

    int byteType2(byte[] byArray, int n) {
        return 14;
    }

    public abstract int getFixedBytesPerChar();

    private final boolean targetIsXml(byte[] byArray, int n, int n2) throws InvalidTokenException {
        boolean bl = false;
        if (n2 - n != this.minBPC * 3) {
            return false;
        }
        switch (this.byteToAscii(byArray, n)) {
            case 88: {
                bl = true;
                break;
            }
            default: {
                return false;
            }
            case 120: 
        }
        switch (this.byteToAscii(byArray, n += this.minBPC)) {
            case 77: {
                bl = true;
                break;
            }
            default: {
                return false;
            }
            case 109: 
        }
        switch (this.byteToAscii(byArray, n += this.minBPC)) {
            case 76: {
                bl = true;
                break;
            }
            default: {
                return false;
            }
            case 108: 
        }
        if (bl) {
            throw new InvalidTokenException(n, 1);
        }
        return true;
    }

    void check3(byte[] byArray, int n) throws InvalidTokenException {
    }

    private static void setCharType(char c, int n) {
        if (c < '\u0080') {
            return;
        }
        int n2 = c >> 8;
        if (charTypeTable[n2] == null) {
            Encoding.charTypeTable[n2] = new byte[256];
            int n3 = 0;
            do {
                Encoding.charTypeTable[n2][n3] = 14;
            } while (++n3 < 256);
        }
        Encoding.charTypeTable[n2][c & 0xFF] = (byte)n;
    }

    private static void setCharType(char c, char c2, int n) {
        char c3;
        byte[] byArray = null;
        do {
            if ((c & 0xFF) == 0) {
                while (c + 255 <= c2) {
                    if (byArray == null) {
                        byArray = new byte[256];
                        int n2 = 0;
                        do {
                            byArray[n2] = (byte)n;
                        } while (++n2 < 256);
                    }
                    Encoding.charTypeTable[c >> 8] = byArray;
                    if (c + 255 == c2) {
                        return;
                    }
                    c = (char)(c + 256);
                }
            }
            Encoding.setCharType(c, n);
            c3 = c;
            c = (char)(c3 + '\u0001');
        } while (c3 != c2);
    }

    /*
     * Unable to fully structure code
     */
    private final int scanAtts(int var1_1, byte[] var2_2, int var3_3, int var4_4, ContentToken var5_5) throws PartialTokenException, InvalidTokenException {
        var6_6 = -1;
        while (var3_3 != var4_4) {
            switch (this.byteType(var2_2, var3_3)) {
                case 11: 
                case 12: 
                case 13: {
                    var3_3 += this.minBPC;
                    break;
                }
                case -2: {
                    if (var4_4 - var3_3 < 2) {
                        throw new PartialCharException(var3_3);
                    }
                    if (!this.isNameChar2(var2_2, var3_3)) {
                        throw new InvalidTokenException(var3_3);
                    }
                    var3_3 += 2;
                    break;
                }
                case -3: {
                    if (var4_4 - var3_3 < 3) {
                        throw new PartialCharException(var3_3);
                    }
                    if (!this.isNameChar3(var2_2, var3_3)) {
                        throw new InvalidTokenException(var3_3);
                    }
                    var3_3 += 3;
                    break;
                }
                case -4: {
                    if (var4_4 - var3_3 < 4) {
                        throw new PartialCharException(var3_3);
                    }
                    if (!this.isNameChar4(var2_2, var3_3)) {
                        throw new InvalidTokenException(var3_3);
                    }
                    var3_3 += 4;
                    break;
                }
                case -11: 
                case -10: 
                case 10: {
                    var6_6 = var3_3;
                    block39: while (true) {
                        if ((var3_3 += this.minBPC) == var4_4) {
                            throw new PartialTokenException();
                        }
                        switch (this.byteType(var2_2, var3_3)) {
                            case -11: 
                            case -10: 
                            case 10: {
                                continue block39;
                            }
                            default: {
                                throw new InvalidTokenException(var3_3);
                            }
                            case 3: 
                        }
                        break;
                    }
                }
                case 3: {
                    if (var6_6 < 0) {
                        var6_6 = var3_3;
                    }
                    block40: while (true) {
                        if ((var3_3 += this.minBPC) == var4_4) {
                            throw new PartialTokenException();
                        }
                        var7_7 = this.byteType(var2_2, var3_3);
                        if (var7_7 == 1 || var7_7 == 2) ** GOTO lbl51
                        switch (var7_7) {
                            case -11: 
                            case -10: 
                            case 10: {
                                continue block40;
                            }
                        }
                        break;
                    }
                    throw new InvalidTokenException(var3_3);
lbl51:
                    // 1 sources

                    var8_8 = var3_3 += this.minBPC;
                    var9_9 = true;
                    block41: while (true) {
                        if (var3_3 == var4_4) {
                            throw new PartialTokenException();
                        }
                        var10_10 = this.byteType(var2_2, var3_3);
                        if (var10_10 == var7_7) break;
                        switch (var10_10) {
                            case -6: 
                            case -5: {
                                throw new InvalidTokenException(var3_3);
                            }
                            case -2: {
                                if (var4_4 - var3_3 < 2) {
                                    throw new PartialCharException(var3_3);
                                }
                                this.check2(var2_2, var3_3);
                                var3_3 += 2;
                                continue block41;
                            }
                            case -3: {
                                if (var4_4 - var3_3 < 3) {
                                    throw new PartialCharException(var3_3);
                                }
                                this.check3(var2_2, var3_3);
                                var3_3 += 3;
                                continue block41;
                            }
                            case -4: {
                                if (var4_4 - var3_3 < 4) {
                                    throw new PartialCharException(var3_3);
                                }
                                this.check4(var2_2, var3_3);
                                var3_3 += 4;
                                continue block41;
                            }
                            case -8: {
                                var9_9 = false;
                                var11_11 = var5_5.nameEnd;
                                this.scanRef(var2_2, var3_3 + this.minBPC, var4_4, var5_5);
                                var5_5.nameEnd = var11_11;
                                var3_3 = var5_5.tokenEnd;
                                continue block41;
                            }
                            case 10: {
                                if (var9_9 && (var3_3 == var8_8 || this.byteToAscii(var2_2, var3_3) != 32 || var3_3 + this.minBPC != var4_4 && (this.byteToAscii(var2_2, var3_3 + this.minBPC) == 32 || this.byteType(var2_2, var3_3 + this.minBPC) == var7_7))) {
                                    var9_9 = false;
                                }
                                var3_3 += this.minBPC;
                                continue block41;
                            }
                            case -7: {
                                throw new InvalidTokenException(var3_3);
                            }
                            case -11: 
                            case -10: {
                                var9_9 = false;
                            }
                        }
                        var3_3 += this.minBPC;
                    }
                    var5_5.appendAttribute(var1_1, var6_6, var8_8, var3_3, var9_9);
                    if ((var3_3 += this.minBPC) == var4_4) {
                        throw new PartialTokenException();
                    }
                    var10_10 = this.byteType(var2_2, var3_3);
                    switch (var10_10) {
                        case -11: 
                        case -10: 
                        case 10: {
                            if ((var3_3 += this.minBPC) == var4_4) {
                                throw new PartialTokenException();
                            }
                            var10_10 = this.byteType(var2_2, var3_3);
                            break;
                        }
                        default: {
                            throw new InvalidTokenException(var3_3);
                        }
                        case 0: 
                        case 6: 
                    }
                    block42: while (true) {
                        switch (var10_10) {
                            case 11: {
                                var1_1 = var3_3;
                                var3_3 += this.minBPC;
                                break block42;
                            }
                            case -2: {
                                if (var4_4 - var3_3 < 2) {
                                    throw new PartialCharException(var3_3);
                                }
                                if (this.byteType2(var2_2, var3_3) != 11) {
                                    throw new InvalidTokenException(var3_3);
                                }
                                var1_1 = var3_3;
                                var3_3 += 2;
                                break block42;
                            }
                            case -3: {
                                if (var4_4 - var3_3 < 3) {
                                    throw new PartialCharException(var3_3);
                                }
                                if (this.byteType3(var2_2, var3_3) != 11) {
                                    throw new InvalidTokenException(var3_3);
                                }
                                var1_1 = var3_3;
                                var3_3 += 3;
                                break block42;
                            }
                            case -4: {
                                if (var4_4 - var3_3 < 4) {
                                    throw new PartialCharException(var3_3);
                                }
                                if (this.byteType4(var2_2, var3_3) != 11) {
                                    throw new InvalidTokenException(var3_3);
                                }
                                var1_1 = var3_3;
                                var3_3 += 4;
                                break block42;
                            }
                            case 0: {
                                var5_5.checkAttributeUniqueness(var2_2);
                                var5_5.tokenEnd = var3_3 + this.minBPC;
                                return 3;
                            }
                            case 6: {
                                if ((var3_3 += this.minBPC) == var4_4) {
                                    throw new PartialTokenException();
                                }
                                this.checkCharMatches(var2_2, var3_3, '>');
                                var5_5.checkAttributeUniqueness(var2_2);
                                var5_5.tokenEnd = var3_3 + this.minBPC;
                                return 5;
                            }
                            default: {
                                throw new InvalidTokenException(var3_3);
                            }
                            case -11: 
                            case -10: 
                            case 10: {
                                if ((var3_3 += this.minBPC) == var4_4) {
                                    throw new PartialTokenException();
                                }
                                var10_10 = this.byteType(var2_2, var3_3);
                                continue block42;
                            }
                        }
                        break;
                    }
                    var6_6 = -1;
                    break;
                }
                default: {
                    throw new InvalidTokenException(var3_3);
                }
            }
        }
        throw new PartialTokenException();
    }

    private final int scanCharRef(byte[] byArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException {
        if (n != n2) {
            int n3 = this.byteToAscii(byArray, n);
            switch (n3) {
                case 120: {
                    return this.scanHexCharRef(byArray, n + this.minBPC, n2, token);
                }
                default: {
                    throw new InvalidTokenException(n);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            int n4 = n3 - 48;
            n += this.minBPC;
            while (n != n2) {
                n3 = this.byteToAscii(byArray, n);
                switch (n3) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        n4 = n4 * 10 + (n3 - 48);
                        if (n4 < 0x110000) break;
                    }
                    default: {
                        throw new InvalidTokenException(n);
                    }
                    case 59: {
                        token.tokenEnd = n + this.minBPC;
                        return this.setRefChar(n4, token);
                    }
                }
                n += this.minBPC;
            }
        }
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    private final int scanRef(byte[] var1_1, int var2_2, int var3_3, Token var4_4) throws PartialTokenException, InvalidTokenException {
        if (var2_2 == var3_3) {
            throw new PartialTokenException();
        }
        if (this.isMagicEntityRef(var1_1, var2_2, var3_3, var4_4)) {
            return 10;
        }
        switch (this.byteType(var1_1, var2_2)) {
            case 11: {
                var2_2 += this.minBPC;
                ** GOTO lbl66
            }
            case -2: {
                if (var3_3 - var2_2 < 2) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType2(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 2;
                ** GOTO lbl66
            }
            case -3: {
                if (var3_3 - var2_2 < 3) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType3(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 3;
                ** GOTO lbl66
            }
            case -4: {
                if (var3_3 - var2_2 < 4) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType4(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 4;
                if (true) ** GOTO lbl66
            }
            case 8: {
                return this.scanCharRef(var1_1, var2_2 + this.minBPC, var3_3, var4_4);
            }
            default: {
                throw new InvalidTokenException(var2_2);
            }
        }
        do {
            switch (this.byteType(var1_1, var2_2)) {
                case 11: 
                case 12: 
                case 13: {
                    var2_2 += this.minBPC;
                    break;
                }
                case -2: {
                    if (var3_3 - var2_2 < 2) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar2(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 2;
                    break;
                }
                case -3: {
                    if (var3_3 - var2_2 < 3) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar3(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 3;
                    break;
                }
                case -4: {
                    if (var3_3 - var2_2 < 4) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar4(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 4;
                    break;
                }
                case 7: {
                    var4_4.nameEnd = var2_2;
                    var4_4.tokenEnd = var2_2 + this.minBPC;
                    return 9;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
lbl66:
            // 8 sources

        } while (var2_2 != var3_3);
        throw new PartialTokenException();
    }

    public static final Encoding getInternalEncoding() {
        return Encoding.getEncoding((byte)3);
    }

    void check4(byte[] byArray, int n) throws InvalidTokenException {
    }

    public final int skipS(byte[] byArray, int n, int n2) {
        block3: while (n < n2) {
            switch (this.byteType(byArray, n)) {
                case -11: 
                case -10: 
                case 10: {
                    n += this.minBPC;
                    continue block3;
                }
            }
        }
        return n;
    }

    int byteType3(byte[] byArray, int n) {
        return 14;
    }

    private final int scanLt(byte[] byArray, int n, int n2, ContentToken contentToken) throws PartialTokenException, InvalidTokenException {
        if (n == n2) {
            throw new PartialTokenException();
        }
        switch (this.byteType(byArray, n)) {
            case 11: {
                n += this.minBPC;
                break;
            }
            case -2: {
                if (n2 - n < 2) {
                    throw new PartialCharException(n);
                }
                if (this.byteType2(byArray, n) != 11) {
                    throw new InvalidTokenException(n);
                }
                n += 2;
                break;
            }
            case -3: {
                if (n2 - n < 3) {
                    throw new PartialCharException(n);
                }
                if (this.byteType3(byArray, n) != 11) {
                    throw new InvalidTokenException(n);
                }
                n += 3;
                break;
            }
            case -4: {
                if (n2 - n < 4) {
                    throw new PartialCharException(n);
                }
                if (this.byteType4(byArray, n) != 11) {
                    throw new InvalidTokenException(n);
                }
                n += 4;
                break;
            }
            case 5: {
                if ((n += this.minBPC) == n2) {
                    throw new PartialTokenException();
                }
                switch (this.byteType(byArray, n)) {
                    case 13: {
                        return this.scanComment(byArray, n + this.minBPC, n2, contentToken);
                    }
                    case 9: {
                        return this.scanCdataSection(byArray, n + this.minBPC, n2, contentToken);
                    }
                }
                throw new InvalidTokenException(n);
            }
            case 4: {
                return this.scanPi(byArray, n + this.minBPC, n2, contentToken);
            }
            case 6: {
                return this.scanEndTag(byArray, n + this.minBPC, n2, contentToken);
            }
            default: {
                throw new InvalidTokenException(n);
            }
        }
        contentToken.nameEnd = -1;
        contentToken.clearAttributes();
        block30: while (n != n2) {
            block31: while (true) {
                switch (this.byteType(byArray, n)) {
                    case 11: 
                    case 12: 
                    case 13: {
                        n += this.minBPC;
                        continue block30;
                    }
                    case -2: {
                        if (n2 - n < 2) {
                            throw new PartialCharException(n);
                        }
                        if (!this.isNameChar2(byArray, n)) {
                            throw new InvalidTokenException(n);
                        }
                        n += 2;
                        continue block30;
                    }
                    case -3: {
                        if (n2 - n < 3) {
                            throw new PartialCharException(n);
                        }
                        if (!this.isNameChar3(byArray, n)) {
                            throw new InvalidTokenException(n);
                        }
                        n += 3;
                        continue block30;
                    }
                    case -4: {
                        if (n2 - n < 4) {
                            throw new PartialCharException(n);
                        }
                        if (!this.isNameChar4(byArray, n)) {
                            throw new InvalidTokenException(n);
                        }
                        n += 4;
                        continue block30;
                    }
                    case -11: 
                    case -10: 
                    case 10: {
                        contentToken.nameEnd = n;
                        n += this.minBPC;
                        block32: while (true) {
                            if (n == n2) {
                                throw new PartialTokenException();
                            }
                            switch (this.byteType(byArray, n)) {
                                case 11: {
                                    return this.scanAtts(n, byArray, n + this.minBPC, n2, contentToken);
                                }
                                case -2: {
                                    if (n2 - n < 2) {
                                        throw new PartialCharException(n);
                                    }
                                    if (this.byteType2(byArray, n) != 11) {
                                        throw new InvalidTokenException(n);
                                    }
                                    return this.scanAtts(n, byArray, n + 2, n2, contentToken);
                                }
                                case -3: {
                                    if (n2 - n < 3) {
                                        throw new PartialCharException(n);
                                    }
                                    if (this.byteType3(byArray, n) != 11) {
                                        throw new InvalidTokenException(n);
                                    }
                                    return this.scanAtts(n, byArray, n + 3, n2, contentToken);
                                }
                                case -4: {
                                    if (n2 - n < 4) {
                                        throw new PartialCharException(n);
                                    }
                                    if (this.byteType4(byArray, n) != 11) {
                                        throw new InvalidTokenException(n);
                                    }
                                    return this.scanAtts(n, byArray, n + 4, n2, contentToken);
                                }
                                case -11: 
                                case -10: 
                                case 10: {
                                    n += this.minBPC;
                                    continue block32;
                                }
                                default: {
                                    throw new InvalidTokenException(n);
                                }
                                case 0: 
                                case 6: {
                                    if (n != n2) continue block31;
                                }
                            }
                            break;
                        }
                    }
                    case 0: {
                        if (contentToken.nameEnd < 0) {
                            contentToken.nameEnd = n;
                        }
                        contentToken.tokenEnd = n + this.minBPC;
                        return 2;
                    }
                    case 6: {
                        if (contentToken.nameEnd < 0) {
                            contentToken.nameEnd = n;
                        }
                        if ((n += this.minBPC) == n2) {
                            throw new PartialTokenException();
                        }
                        this.checkCharMatches(byArray, n, '>');
                        contentToken.tokenEnd = n + this.minBPC;
                        return 4;
                    }
                    default: {
                        throw new InvalidTokenException(n);
                    }
                }
                break;
            }
        }
        throw new PartialTokenException();
    }

    public final int tokenizeEntityValue(byte[] byArray, int n, int n2, Token token) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException {
        if (this.minBPC > 1) {
            n2 = this.adjustEnd(n, n2);
        }
        if (n == n2) {
            throw new EmptyTokenException();
        }
        int n3 = n;
        while (n != n2) {
            switch (this.byteType(byArray, n)) {
                case -2: {
                    if (n2 - n < 2) {
                        throw new PartialCharException(n);
                    }
                    n += 2;
                    break;
                }
                case -3: {
                    if (n2 - n < 3) {
                        throw new PartialCharException(n);
                    }
                    n += 3;
                    break;
                }
                case -4: {
                    if (n2 - n < 4) {
                        throw new PartialCharException(n);
                    }
                    n += 4;
                    break;
                }
                case -8: {
                    if (n == n3) {
                        return this.scanRef(byArray, n + this.minBPC, n2, token);
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case 15: {
                    if (n == n3) {
                        return this.scanPercent(byArray, n + this.minBPC, n2, token);
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -11: {
                    if (n == n3) {
                        token.tokenEnd = n + this.minBPC;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                case -10: {
                    if (n == n3) {
                        if ((n += this.minBPC) == n2) {
                            throw new ExtensibleTokenException(1);
                        }
                        if (this.byteType(byArray, n) == -11) {
                            n += this.minBPC;
                        }
                        token.tokenEnd = n;
                        return 1;
                    }
                    token.tokenEnd = n;
                    return 0;
                }
                default: {
                    n += this.minBPC;
                }
            }
        }
        token.tokenEnd = n;
        return 0;
    }

    private static synchronized Encoding getEncoding(byte by) {
        switch (by) {
            case 0: {
                if (utf8Encoding == null) {
                    utf8Encoding = new UTF8Encoding();
                }
                return utf8Encoding;
            }
            case 1: {
                if (utf16LittleEndianEncoding == null) {
                    utf16LittleEndianEncoding = new UTF16LittleEndianEncoding();
                }
                return utf16LittleEndianEncoding;
            }
            case 2: {
                if (utf16BigEndianEncoding == null) {
                    utf16BigEndianEncoding = new UTF16BigEndianEncoding();
                }
                return utf16BigEndianEncoding;
            }
            case 3: {
                if (internalEncoding == null) {
                    internalEncoding = new InternalEncoding();
                }
                return internalEncoding;
            }
            case 4: {
                if (iso8859_1Encoding == null) {
                    iso8859_1Encoding = new ISO8859_1Encoding();
                }
                return iso8859_1Encoding;
            }
            case 5: {
                if (asciiEncoding == null) {
                    asciiEncoding = new ASCIIEncoding();
                }
                return asciiEncoding;
            }
        }
        return null;
    }

    Encoding(int n) {
        this.minBPC = n;
    }

    public final int tokenizeContent(byte[] byArray, int n, int n2, ContentToken contentToken) throws PartialTokenException, InvalidTokenException, EmptyTokenException, ExtensibleTokenException {
        if (this.minBPC > 1) {
            n2 = this.adjustEnd(n, n2);
        }
        if (n == n2) {
            throw new EmptyTokenException();
        }
        switch (this.byteType(byArray, n)) {
            case -7: {
                return this.scanLt(byArray, n + this.minBPC, n2, contentToken);
            }
            case -8: {
                return this.scanRef(byArray, n + this.minBPC, n2, contentToken);
            }
            case -10: {
                if ((n += this.minBPC) == n2) {
                    throw new ExtensibleTokenException(1);
                }
                if (this.byteType(byArray, n) == -11) {
                    n += this.minBPC;
                }
                contentToken.tokenEnd = n;
                return 1;
            }
            case -11: {
                contentToken.tokenEnd = n + this.minBPC;
                return 1;
            }
            case -9: {
                if ((n += this.minBPC) == n2) {
                    throw new ExtensibleTokenException(0);
                }
                if (!this.charMatches(byArray, n, ']')) break;
                if ((n += this.minBPC) == n2) {
                    throw new ExtensibleTokenException(0);
                }
                if (!this.charMatches(byArray, n, '>')) {
                    n -= this.minBPC;
                    break;
                }
                throw new InvalidTokenException(n);
            }
            case -6: 
            case -5: {
                throw new InvalidTokenException(n);
            }
            case -2: {
                if (n2 - n < 2) {
                    throw new PartialCharException(n);
                }
                this.check2(byArray, n);
                n += 2;
                break;
            }
            case -3: {
                if (n2 - n < 3) {
                    throw new PartialCharException(n);
                }
                this.check3(byArray, n);
                n += 3;
                break;
            }
            case -4: {
                if (n2 - n < 4) {
                    throw new PartialCharException(n);
                }
                this.check4(byArray, n);
                n += 4;
                break;
            }
            default: {
                n += this.minBPC;
            }
        }
        contentToken.tokenEnd = this.extendData(byArray, n, n2);
        return 0;
    }

    public final Encoding getEncoding(String string) {
        if (string == null) {
            return this;
        }
        if (string.equalsIgnoreCase("UTF-8")) {
            return Encoding.getEncoding((byte)0);
        }
        if (string.equalsIgnoreCase("UTF-16")) {
            return this.getUTF16Encoding();
        }
        if (string.equalsIgnoreCase("ISO-8859-1")) {
            return Encoding.getEncoding((byte)4);
        }
        if (string.equalsIgnoreCase("US-ASCII")) {
            return Encoding.getEncoding((byte)5);
        }
        return null;
    }

    int byteType4(byte[] byArray, int n) {
        return 14;
    }

    public final boolean matchesXMLString(byte[] byArray, int n, int n2, String string) {
        int n3 = string.length();
        if (n3 * this.minBPC != n2 - n) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!this.charMatches(byArray, n, string.charAt(n4))) {
                return false;
            }
            n += this.minBPC;
            ++n4;
        }
        return true;
    }

    public abstract int convert(byte[] var1, int var2, int var3, char[] var4, int var5);

    private final int setRefChar(int n, Token token) throws InvalidTokenException {
        if (n < 65536) {
            switch (charTypeTable[n >> 8][n & 0xFF]) {
                case -6: 
                case -5: 
                case -4: {
                    throw new InvalidTokenException(token.tokenEnd - this.minBPC);
                }
            }
            token.refChar1 = (char)n;
            return 11;
        }
        token.refChar1 = (char)(((n -= 65536) >> 10) + 55296);
        token.refChar2 = (char)((n & 0x3FF) + 56320);
        return 12;
    }

    public final int getMinBytesPerChar() {
        return this.minBPC;
    }

    int extendCdata(byte[] byArray, int n, int n2) throws InvalidTokenException {
        while (n != n2) {
            switch (this.byteType(byArray, n)) {
                case -2: {
                    if (n2 - n < 2) {
                        return n;
                    }
                    this.check2(byArray, n);
                    n += 2;
                    break;
                }
                case -3: {
                    if (n2 - n < 3) {
                        return n;
                    }
                    this.check3(byArray, n);
                    n += 3;
                    break;
                }
                case -4: {
                    if (n2 - n < 4) {
                        return n;
                    }
                    this.check4(byArray, n);
                    n += 4;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -6: 
                case -5: {
                    return n;
                }
                default: {
                    n += this.minBPC;
                }
            }
        }
        return n;
    }

    int extendData(byte[] byArray, int n, int n2) throws InvalidTokenException {
        while (n != n2) {
            switch (this.byteType(byArray, n)) {
                case -2: {
                    if (n2 - n < 2) {
                        return n;
                    }
                    this.check2(byArray, n);
                    n += 2;
                    break;
                }
                case -3: {
                    if (n2 - n < 3) {
                        return n;
                    }
                    this.check3(byArray, n);
                    n += 3;
                    break;
                }
                case -4: {
                    if (n2 - n < 4) {
                        return n;
                    }
                    this.check4(byArray, n);
                    n += 4;
                    break;
                }
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    return n;
                }
                default: {
                    n += this.minBPC;
                }
            }
        }
        return n;
    }

    private final int scanLit(int n, byte[] byArray, int n2, int n3, Token token) throws PartialTokenException, InvalidTokenException, ExtensibleTokenException {
        block10: while (n2 != n3) {
            int n4 = this.byteType(byArray, n2);
            switch (n4) {
                case -2: {
                    if (n3 - n2 < 2) {
                        throw new PartialTokenException();
                    }
                    this.check2(byArray, n2);
                    n2 += 2;
                    break;
                }
                case -3: {
                    if (n3 - n2 < 3) {
                        throw new PartialTokenException();
                    }
                    this.check3(byArray, n2);
                    n2 += 3;
                    break;
                }
                case -4: {
                    if (n3 - n2 < 4) {
                        throw new PartialTokenException();
                    }
                    this.check4(byArray, n2);
                    n2 += 4;
                    break;
                }
                case -6: 
                case -5: {
                    throw new InvalidTokenException(n2);
                }
                case 1: 
                case 2: {
                    n2 += this.minBPC;
                    if (n4 != n) continue block10;
                    if (n2 == n3) {
                        throw new ExtensibleTokenException(30);
                    }
                    switch (this.byteType(byArray, n2)) {
                        case -11: 
                        case -10: 
                        case 0: 
                        case 9: 
                        case 10: 
                        case 15: {
                            token.tokenEnd = n2;
                            return 30;
                        }
                    }
                    throw new InvalidTokenException(n2);
                }
                default: {
                    n2 += this.minBPC;
                }
            }
        }
        throw new PartialTokenException();
    }

    private final int adjustEnd(int n, int n2) throws PartialCharException {
        int n3 = n2 - n;
        if ((n3 & this.minBPC - 1) != 0) {
            if ((n3 &= ~(this.minBPC - 1)) == 0) {
                throw new PartialCharException(n);
            }
            return n + n3;
        }
        return n2;
    }

    Encoding getUTF16Encoding() {
        return Encoding.getEncoding((byte)2);
    }

    public static final Encoding getInitialEncoding(byte[] byArray, int n, int n2, Token token) {
        token.tokenEnd = n;
        switch (n2 - n) {
            case 1: {
                if (byArray[n] >= 0) break;
                return null;
            }
            default: {
                int n3 = byArray[n] & 0xFF;
                int n4 = byArray[n + 1] & 0xFF;
                switch (n3 << 8 | n4) {
                    case 65279: {
                        token.tokenEnd = n + 2;
                    }
                    case 60: {
                        return Encoding.getEncoding((byte)2);
                    }
                    case 65534: {
                        token.tokenEnd = n + 2;
                    }
                    case 15360: {
                        return Encoding.getEncoding((byte)1);
                    }
                }
            }
            case 0: 
        }
        return Encoding.getEncoding((byte)0);
    }

    public final Encoding getSingleByteEncoding(String string) {
        return new SingleByteEncoding(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMagicEntityRef(byte[] byArray, int n, int n2, Token token) {
        switch (this.byteToAscii(byArray, n)) {
            case 97: {
                if (n2 - n < this.minBPC * 4) return false;
                switch (this.byteToAscii(byArray, n + this.minBPC)) {
                    case 109: {
                        if (!this.charMatches(byArray, n + this.minBPC * 2, 'p') || !this.charMatches(byArray, n + this.minBPC * 3, ';')) return false;
                        token.tokenEnd = n + this.minBPC * 4;
                        token.refChar1 = (char)38;
                        return true;
                    }
                    case 112: {
                        if (n2 - n < this.minBPC * 5 || !this.charMatches(byArray, n + this.minBPC * 2, 'o') || !this.charMatches(byArray, n + this.minBPC * 3, 's') || !this.charMatches(byArray, n + this.minBPC * 4, ';')) return false;
                        token.tokenEnd = n + this.minBPC * 5;
                        token.refChar1 = (char)39;
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 108: {
                if (n2 - n < this.minBPC * 3 || !this.charMatches(byArray, n + this.minBPC, 't') || !this.charMatches(byArray, n + this.minBPC * 2, ';')) return false;
                token.tokenEnd = n + this.minBPC * 3;
                token.refChar1 = (char)60;
                return true;
            }
            case 103: {
                if (n2 - n < this.minBPC * 3 || !this.charMatches(byArray, n + this.minBPC, 't') || !this.charMatches(byArray, n + this.minBPC * 2, ';')) return false;
                token.tokenEnd = n + this.minBPC * 3;
                token.refChar1 = (char)62;
                return true;
            }
            case 113: {
                if (n2 - n < this.minBPC * 5 || !this.charMatches(byArray, n + this.minBPC, 'u') || !this.charMatches(byArray, n + this.minBPC * 2, 'o') || !this.charMatches(byArray, n + this.minBPC * 3, 't') || !this.charMatches(byArray, n + this.minBPC * 4, ';')) return false;
                token.tokenEnd = n + this.minBPC * 5;
                token.refChar1 = (char)34;
                return true;
            }
        }
        return false;
    }

    static {
        asciiTypeTable = new byte[]{-5, -5, -5, -5, -5, -5, -5, -5, -5, 10, -11, -5, -5, -10, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 10, 5, 1, 8, 14, 15, -8, 2, 16, 17, 18, 19, 20, 13, 12, 6, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 11, 7, -7, 3, 0, 4, 14, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 9, 14, -9, 14, 11, 14, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 14, 21, 14, 14, 14};
        charTypeTable = new byte[256][];
        int n = 0;
        while (n < nameSingles.length()) {
            Encoding.setCharType(nameSingles.charAt(n), 12);
            ++n;
        }
        n = 0;
        while (n < nameRanges.length()) {
            Encoding.setCharType(nameRanges.charAt(n), nameRanges.charAt(n + 1), 12);
            n += 2;
        }
        n = 0;
        while (n < nameStartSingles.length()) {
            Encoding.setCharType(nameStartSingles.charAt(n), 11);
            ++n;
        }
        n = 0;
        while (n < nameStartRanges.length()) {
            Encoding.setCharType(nameStartRanges.charAt(n), nameStartRanges.charAt(n + 1), 11);
            n += 2;
        }
        Encoding.setCharType('\ud800', '\udbff', -4);
        Encoding.setCharType('\udc00', '\udfff', -6);
        Encoding.setCharType('\ufffe', '\uffff', -5);
        byte[] byArray = new byte[256];
        int n2 = 0;
        do {
            byArray[n2] = 14;
        } while (++n2 < 256);
        n2 = 0;
        do {
            if (charTypeTable[n2] != null) continue;
            Encoding.charTypeTable[n2] = byArray;
        } while (++n2 < 256);
        System.arraycopy(asciiTypeTable, 0, charTypeTable[0], 0, 128);
    }

    private final boolean isNameChar2(byte[] byArray, int n) {
        int n2 = this.byteType2(byArray, n);
        return n2 == 12 || n2 == 11;
    }

    private final void checkCharMatches(byte[] byArray, int n, char c) throws InvalidTokenException {
        if (!this.charMatches(byArray, n, c)) {
            throw new InvalidTokenException(n);
        }
    }

    private final int scanComment(byte[] byArray, int n, int n2, Token token) throws InvalidTokenException, PartialTokenException {
        if (n != n2) {
            this.checkCharMatches(byArray, n, '-');
            n += this.minBPC;
            block7: while (n != n2) {
                switch (this.byteType(byArray, n)) {
                    case -2: {
                        if (n2 - n < 2) {
                            throw new PartialCharException(n);
                        }
                        this.check2(byArray, n);
                        n += 2;
                        break;
                    }
                    case -3: {
                        if (n2 - n < 3) {
                            throw new PartialCharException(n);
                        }
                        this.check3(byArray, n);
                        n += 3;
                        break;
                    }
                    case -4: {
                        if (n2 - n < 4) {
                            throw new PartialCharException(n);
                        }
                        this.check4(byArray, n);
                        n += 4;
                        break;
                    }
                    case -6: 
                    case -5: {
                        throw new InvalidTokenException(n);
                    }
                    case 13: {
                        if ((n += this.minBPC) == n2) {
                            throw new PartialTokenException();
                        }
                        if (!this.charMatches(byArray, n, '-')) continue block7;
                        if ((n += this.minBPC) == n2) {
                            throw new PartialTokenException();
                        }
                        this.checkCharMatches(byArray, n, '>');
                        token.tokenEnd = n + this.minBPC;
                        return 15;
                    }
                    default: {
                        n += this.minBPC;
                    }
                }
            }
        }
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    private final int scanPercent(byte[] var1_1, int var2_2, int var3_3, Token var4_4) throws PartialTokenException, InvalidTokenException {
        if (var2_2 == var3_3) {
            throw new PartialTokenException();
        }
        switch (this.byteType(var1_1, var2_2)) {
            case 11: {
                var2_2 += this.minBPC;
                ** GOTO lbl65
            }
            case -2: {
                if (var3_3 - var2_2 < 2) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType2(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 2;
                ** GOTO lbl65
            }
            case -3: {
                if (var3_3 - var2_2 < 3) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType3(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 3;
                ** GOTO lbl65
            }
            case -4: {
                if (var3_3 - var2_2 < 4) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType4(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 4;
                if (true) ** GOTO lbl65
            }
            case -11: 
            case -10: 
            case 10: 
            case 15: {
                var4_4.tokenEnd = var2_2;
                return 25;
            }
            default: {
                throw new InvalidTokenException(var2_2);
            }
        }
        do {
            switch (this.byteType(var1_1, var2_2)) {
                case 11: 
                case 12: 
                case 13: {
                    var2_2 += this.minBPC;
                    break;
                }
                case -2: {
                    if (var3_3 - var2_2 < 2) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar2(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 2;
                    break;
                }
                case -3: {
                    if (var3_3 - var2_2 < 3) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar3(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 3;
                    break;
                }
                case -4: {
                    if (var3_3 - var2_2 < 4) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar4(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 4;
                    break;
                }
                case 7: {
                    var4_4.nameEnd = var2_2;
                    var4_4.tokenEnd = var2_2 + this.minBPC;
                    return 17;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
lbl65:
            // 8 sources

        } while (var2_2 != var3_3);
        throw new PartialTokenException();
    }

    /*
     * Unable to fully structure code
     */
    private final int scanEndTag(byte[] var1_1, int var2_2, int var3_3, Token var4_4) throws PartialTokenException, InvalidTokenException {
        if (var2_2 == var3_3) {
            throw new PartialTokenException();
        }
        switch (this.byteType(var1_1, var2_2)) {
            case 11: {
                var2_2 += this.minBPC;
                ** GOTO lbl76
            }
            case -2: {
                if (var3_3 - var2_2 < 2) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType2(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 2;
                ** GOTO lbl76
            }
            case -3: {
                if (var3_3 - var2_2 < 3) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType3(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 3;
                ** GOTO lbl76
            }
            case -4: {
                if (var3_3 - var2_2 < 4) {
                    throw new PartialCharException(var2_2);
                }
                if (this.byteType4(var1_1, var2_2) != 11) {
                    throw new InvalidTokenException(var2_2);
                }
                var2_2 += 4;
                if (true) ** GOTO lbl76
            }
            default: {
                throw new InvalidTokenException(var2_2);
            }
        }
        do {
            switch (this.byteType(var1_1, var2_2)) {
                case 11: 
                case 12: 
                case 13: {
                    var2_2 += this.minBPC;
                    break;
                }
                case -2: {
                    if (var3_3 - var2_2 < 2) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar2(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 2;
                    break;
                }
                case -3: {
                    if (var3_3 - var2_2 < 3) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar3(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 3;
                    break;
                }
                case -4: {
                    if (var3_3 - var2_2 < 4) {
                        throw new PartialCharException(var2_2);
                    }
                    if (!this.isNameChar4(var1_1, var2_2)) {
                        throw new InvalidTokenException(var2_2);
                    }
                    var2_2 += 4;
                    break;
                }
                case -11: 
                case -10: 
                case 10: {
                    var4_4.nameEnd = var2_2;
                    var2_2 += this.minBPC;
                    while (var2_2 != var3_3) {
                        switch (this.byteType(var1_1, var2_2)) {
                            case 0: {
                                var4_4.tokenEnd = var2_2 + this.minBPC;
                                return 6;
                            }
                            default: {
                                throw new InvalidTokenException(var2_2);
                            }
                            case -11: 
                            case -10: 
                            case 10: 
                        }
                        var2_2 += this.minBPC;
                    }
                    throw new PartialTokenException();
                }
                case 0: {
                    var4_4.nameEnd = var2_2;
                    var4_4.tokenEnd = var2_2 + this.minBPC;
                    return 6;
                }
                default: {
                    throw new InvalidTokenException(var2_2);
                }
            }
lbl76:
            // 8 sources

        } while (var2_2 != var3_3);
        throw new PartialTokenException();
    }

    public abstract void movePosition(byte[] var1, int var2, int var3, Position var4);
}

