# ----------------------------------------------------------------------------
#  Loads the current version number:
# ----------------------------------------------------------------------------
FILE(STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/version_prefix.txt" CMAKE_MRPT_VERSION_NUMBER LIMIT_COUNT 1) # Read only the first line

# For example: "0.5.1"
STRING(REGEX MATCHALL "[0-9]+" CMAKE_MRPT_VERSION_PARTS "${CMAKE_MRPT_VERSION_NUMBER}")

LIST(GET CMAKE_MRPT_VERSION_PARTS 0 CMAKE_MRPT_VERSION_NUMBER_MAJOR)
LIST(GET CMAKE_MRPT_VERSION_PARTS 1 CMAKE_MRPT_VERSION_NUMBER_MINOR)
LIST(GET CMAKE_MRPT_VERSION_PARTS 2 CMAKE_MRPT_VERSION_NUMBER_PATCH)
SET(CMAKE_MRPT_FULL_VERSION "${CMAKE_MRPT_VERSION_NUMBER_MAJOR}.${CMAKE_MRPT_VERSION_NUMBER_MINOR}.${CMAKE_MRPT_VERSION_NUMBER_PATCH}")

IF(WIN32)
	SET(MRPT_DLL_VERSION_POSTFIX "${CMAKE_MRPT_VERSION_NUMBER_MAJOR}${CMAKE_MRPT_VERSION_NUMBER_MINOR}${CMAKE_MRPT_VERSION_NUMBER_PATCH}")
ELSE(WIN32)
	SET(MRPT_DLL_VERSION_POSTFIX "")
ENDIF(WIN32)
