/* Extern's for names and abbreviations of all the commands.

	Copyright (C) 1993-1998 Sebastiano Vigna 
	Copyright (C) 1999-2015 Todd M. Lewis and Sebastiano Vigna

	This file is part of ne, the nice editor.

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or (at your
	option) any later version.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
	or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
	for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, see <http://www.gnu.org/licenses/>.  */

#include "ne.h"
#include "strings.h"

struct e2s {
	const char * ext;
	const char * syn;
};

/* A list of mappings extension -> syntax. MUST be sorted on the first field. */

static struct e2s const e2s[] = {
	{ "1", "troff" },
	{ "adb", "ada" },
	{ "ads", "ada" },
	{ "bash", "sh" },
	{ "bash_login", "sh" },
	{ "bash_logout", "sh" },
	{ "bash_profile", "sh" },
	{ "bashrc", "sh" },
	{ "c++", "c" },
	{ "cbl", "cobol" },
	{ "cc", "c" },
	{ "cob", "cobol" },
	{ "cpp", "c" },
	{ "dtx", "tex" },
	{ "el", "lisp" },
	{ "eps", "ps" },
	{ "f", "fortran" },
	{ "for", "fortran" },
	{ "h", "c" },
	{ "h++", "c" },
	{ "hpp", "c" },
	{ "htm", "html" },
	{ "il", "skill" },
	{ "js", "java" },
	{ "ksh", "sh" },
	{ "l", "c" },
	{ "latex", "tex" },
	{ "lex", "c" },
	{ "lsp", "lisp" },
	{ "mas", "mason" },
	{ "ml", "ocaml" },
	{ "mli", "ocaml" },
	{ "p", "pascal" },
	{ "pas", "pascal" },
	{ "patch", "diff" },
	{ "pl", "perl" },
	{ "pm", "perl" },
	{ "pp", "puppet" },
	{ "profile", "sh" },
	{ "py", "python" },
	{ "rb", "ruby" },
	{ "rc", "sh" },
	{ "rex", "rexx" },
	{ "s", "asm" },
	{ "sage", "python" },
	{ "sty", "tex" },
	{ "tcsh", "csh" },
	{ "texi", "texinfo" },
	{ "txi", "texinfo" },
	{ "v", "verilog" },
	{ "vh", "verilog" },
	{ "vhd", "verilog" },
	{ "xsd", "xml" },
	{ "y", "c" },
	{ "yacc", "c" }

};

static int extcmp(struct e2s const *a, struct e2s const *b) {
	return strcasecmp(a->ext, b->ext);
}

/* Searches for a mapping matching the given extension in e2s; if found, returns the
   resulting syntax. Otherwise, returns ext. */

const char *ext2syntax(const char * const ext) {
	struct e2s key, *t;
	key.ext = ext;
	key.syn = NULL;
	t = bsearch(&key, e2s, sizeof e2s / sizeof *e2s, sizeof *e2s, (int (*)(const void *, const void *))extcmp);
	return t ? t->syn : ext;
}
