/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectUtils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.loaders.TemplateWizard;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.netbeans.modules.web.api.webmodule.WebModule;

/** A single panel descriptor for a wizard.
 * You probably want to make a wizard iterator to hold it.
 *
 * @author  Milan Kuchtiak
 */
public class ListenerPanel implements WizardDescriptor.Panel {
    
    /** The visual component that displays this panel.
     * If you need to access the component from this class,
     * just use getComponent().
     */
    private ListenerVisualPanel component;
    private transient TemplateWizard wizard;

    private static final String SERVLET_CONTEXT_LISTENER = "javax.servlet.ServletContextListener";    //NOI18N
    private static final String SERVLET_CONTEXT_ATTRIBUTE_LISTENER = "javax.servlet.ServletContextAttributeListener";    //NOI18N
    private static final String HTTP_SESSION_LISTENER = "javax.servlet.http.HttpSessionListener";    //NOI18N
    private static final String HTTP_SESSION_ATTRIBUTE_LISTENER = "javax.servlet.http.HttpSessionAttributeListener";    //NOI18N
    private static final String SERVLET_REQUEST_LISTENER = "javax.servlet.ServletRequestListener";    //NOI18N
    private static final String SERVLET_REQUEST_ATTRIBUTE_LISTENER = "javax.servlet.ServletRequestAttributeListener";    //NOI18N

    /** Create the wizard panel descriptor. */
    public ListenerPanel(TemplateWizard wizard) {
        this.wizard=wizard;
    }
    
    // Get the visual component for the panel. In this template, the component
    // is kept separate. This can be more efficient: if the wizard is created
    // but never displayed, or not all panels are displayed, it is better to
    // create only those which really need to be visible.
    public Component getComponent() {
        if (component == null) {
            Project project = Templates.getProject( wizard );
            Sources sources = ProjectUtils.getSources(project);
            SourceGroup[] groups = sources.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
            WebModule wm=null;
            Profile j2eeVersion = Profile.J2EE_14;
            if (groups!=null && groups.length>0) {
                wm = WebModule.getWebModule(groups[0].getRootFolder());
            }
            if (wm!=null) {
                j2eeVersion=wm.getJ2eeProfile();
            }
            component = new ListenerVisualPanel(this,j2eeVersion);
        }
        return component;
    }
    
    public HelpCtx getHelp() {
        //return new HelpCtx(ListenerPanel.class);
        return HelpCtx.DEFAULT_HELP;
    }
    
    public boolean isValid() {
	if(!isListenerSelected()) {
            wizard.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, //NOI18N
                org.openide.util.NbBundle.getMessage(ListenerPanel.class,"MSG_noListenerSelected"));
            return false;
	}
        Project project = Templates.getProject(wizard);
        Sources sources = ProjectUtils.getSources(project);
        SourceGroup[] groups = sources.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
        ClassPath cp = null;
        String resource = null;
        if (groups !=null && groups.length!=0) {
            cp = ClassPath.getClassPath(groups[0].getRootFolder(), ClassPath.COMPILE);
            if (isContextListener()) {
                resource = SERVLET_CONTEXT_LISTENER;
            } else if(isContextAttrListener()) {
                resource = SERVLET_CONTEXT_ATTRIBUTE_LISTENER;
            } else if (isSessionListener()) {
                resource = HTTP_SESSION_LISTENER;
            } else if (isSessionAttrListener()) {
                resource = HTTP_SESSION_ATTRIBUTE_LISTENER;
            } else if (isRequestListener()) {
                resource = SERVLET_REQUEST_LISTENER;
            } else if (isRequestAttrListener()) {
                resource = SERVLET_REQUEST_ATTRIBUTE_LISTENER;
            }
        }
        if (cp != null && resource != null && cp.findResource(resource.replace('.', '/')+".class")==null) {  //NOI18N
            wizard.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE,org.openide.util.NbBundle.getMessage(ListenerPanel.class, "MSG_noResourceInClassPath", resource));
            return false;
        }
        wizard.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, ""); //NOI18N
        return true;
    } 
    
    // FIXME: use org.openide.util.ChangeSupport for ChangeListeners
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    
    public final void addChangeListener (ChangeListener l) {
        synchronized (listeners) {
            listeners.add (l);
        }
    }
    public final void removeChangeListener (ChangeListener l) {
        synchronized (listeners) {
            listeners.remove (l);
        }
    }
    protected final void fireChangeEvent () {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
            it = new HashSet<ChangeListener>(listeners).iterator ();
        }
        ChangeEvent ev = new ChangeEvent (this);
        while (it.hasNext ()) {
            it.next().stateChanged(ev);
        }
    }

    
    // You can use a settings object to keep track of state.
    // Normally the settings object will be the WizardDescriptor,
    // so you can use WizardDescriptor.getProperty & putProperty
    // to store information entered by the user.
    public void readSettings(Object settings) {
    }
    public void storeSettings(Object settings) {
    }
    boolean createElementInDD (){
        return component.createElementInDD();
    }
    
    boolean isContextListener() {return component.isContextListener();}
    
    boolean isContextAttrListener() {return component.isContextAttrListener();}
    
    boolean isSessionListener() {return component.isSessionListener();}
    
    boolean isSessionAttrListener() {return component.isSessionAttrListener();}
    
    boolean isRequestListener() {return component.isRequestListener();}
    
    boolean isRequestAttrListener() {return component.isRequestAttrListener();}
    
    boolean isListenerSelected() {
        return isContextListener() || isContextAttrListener() ||
            isSessionListener() || isSessionAttrListener() || 
            isRequestListener() || isRequestAttrListener();
    }
}
