/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */
package org.netbeans.modules.bugzilla.util;

import java.util.List;
import javax.swing.DefaultListModel;

/**
 *
 * @author Tomas Stupka, Jan Stola
 */
public class KeywordsPanel extends javax.swing.JPanel {

    public KeywordsPanel(String label, List<String> knownKeywords, String[] toSelect) {
        initComponents();
        this.messageLabel.setText(label);
        
        DefaultListModel model = new DefaultListModel();
        for (String keyword : knownKeywords) {
            model.addElement(keyword);
        }
        keywordsList.setModel(model);
        int[] selection = new int[toSelect.length];
        for (int i = 0; i < toSelect.length; i++) {
            String keyword = toSelect[i];
            keyword = keyword.trim();
            int idx = model.indexOf(keyword);
            if(idx == -1 ) {
                idx = model.indexOf(keyword.toUpperCase());
            }
            if(idx == -1 ) {
                idx = model.indexOf(keyword.toLowerCase());
            }
            selection[i] = idx;
        }

        keywordsList.setSelectedIndices(selection);
        int idx = selection.length > 0 ? selection[0] : -1;
        if(idx > -1) keywordsList.scrollRectToVisible(keywordsList.getCellBounds(idx, idx));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        keywordsList = new javax.swing.JList();
        messageLabel = new javax.swing.JLabel();
        keywordsLabel = new javax.swing.JLabel();

        scrollPane.setViewportView(keywordsList);
        keywordsList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(KeywordsPanel.class, "KeywordsPanel.keywordsList.AccessibleContext.accessibleDescription")); // NOI18N

        keywordsLabel.setLabelFor(keywordsList);
        org.openide.awt.Mnemonics.setLocalizedText(keywordsLabel, org.openide.util.NbBundle.getMessage(KeywordsPanel.class, "KeywordsPanel.keywordsLabel.text")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(messageLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(keywordsLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(scrollPane)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(messageLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(scrollPane)
                    .add(keywordsLabel)))
        );

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(KeywordsPanel.class, "KeywordsPanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    public String[] getSelectedKeywords() {
        Object[] values = keywordsList.getSelectedValues();
        String[] keywords = new String[values.length];
        for (int i=0; i<values.length; i++) {
            keywords[i] = values[i].toString();
        }
        return keywords;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel keywordsLabel;
    private javax.swing.JList keywordsList;
    private javax.swing.JLabel messageLabel;
    private javax.swing.JScrollPane scrollPane;
    // End of variables declaration//GEN-END:variables

}
