/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.value.AtomicValue;

public class CollatingAtomicComparer
implements AtomicComparer {
    private StringCollator collator;
    private String collationURI;
    private boolean canReturnCollationKeys;

    public CollatingAtomicComparer(StringCollator collator, Platform platform) {
        if (collator == null) {
            this.collator = CodepointCollator.getInstance();
            this.collationURI = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        } else {
            this.collator = collator;
            this.collationURI = collator instanceof NamedCollation ? ((NamedCollation)collator).getUri() : "*unknown*";
        }
        this.canReturnCollationKeys = platform.canReturnCollationKeys(this.collator);
    }

    public AtomicComparer provideContext(XPathContext context) {
        return this;
    }

    public String getCollationURI() {
        return this.collationURI;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return this.collator.compareStrings(a.getStringValue(), b.getStringValue());
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) {
        return this.compareAtomicValues(a, b) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue a) {
        if (this.canReturnCollationKeys) {
            return new ComparisonKey(513, this.collator.getCollationKey(a.getStringValue()));
        }
        return new ComparisonKey(513, a.getStringValue());
    }
}

