# {%= name %} {%= badge("fury") %} {%= badge("travis") %}

> {%= description %}

The purpose of this lib is to do the fastest comparison possible of two objects when the values will predictably be primitives. 

- only compares objects.
- only compares the first level of each object
- values must be primitives. If a value is not a primitive, even if the values are the same, `false` is returned.

{%= include("install-npm", {save: true}) %}


## Usage

```js
var equals = require('{%= name %}');
equals(object_a, object_b);
```

**Examples**

```js
equals({a: true, b: true}, {a: true, b: true});
//=> 'true'

equals({a: true, b: false}, {c: false, b: false});
//=> 'false'

equals({a: true, b: false}, {a: false, b: false});
//=> 'false'
```

Strict comparison for equality:

```js
equals({a: true, b: true}, {a: true, b: 'true'});
//=> 'false'
```

When values are not primitives, `false` is always returned:

```js
equals({ b: {}}, { b: {}});
//=> 'false'

equals({ b: []}, { b: []});
//=> 'false'
```

## Related projects
{%= verbiage.related.description %}  
{%= related(verbiage.related.list) %}  

## Running tests
{%= include("tests") %}

## Contributing
{%= include("contributing") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
