## Usage

```js
var size = require('{%= name %}');
```

## CLI

```sh
$ window-size
# height: 40
# width : 145
```

## API

### windowSize

The main export is either an object with `width` and `height` properties, or `undefined` if unable to get width and height.

```js
var size = require('{%= name %}');
console.log(size); 
//=> {width: 80, height: 25}
```

### .get

Calls the main function to get the up-to-date window size. 

```js
console.log(size.get());
//=> {width: 80, height: 25}
```

**Example**

See [example.js](example.js) for the code used in the below gif. 

```js
process.stdout.on('resize', function() {
  console.log(size.get());
});
```

![resize event example]({%= contentLink("resize.gif") %})

**HEADS UP!**

Note that some platforms only provide the initial terminal size, not the actual size after it has been resized by the user.

### .env

Get `process.env.COLUMNS` and `process.env.ROWS`, if defined. Called by the main function if for some reason size was not available from `process.stdout` and `process.stderr`.

```js
console.log(size.env());
```

### .tty

Attempts to get the size from `tty`. Called by the main function if for some reason size was not available from `process.stdout`, `process.stderr` or `process.env`.

```js
console.log(size.tty());
```

### .win

Get the terminal size in Windows 10+.

```js
console.log(size.win());
```

Note that this method calls [execSync][] to get the size, and must be called directly, as it **is not** called by the main function. 


### .tput

Get the terminal size by calling the unix `$ tput` command. 

```js
console.log(size.tput());
```

Note that this method calls [execSync][] to get the size, and must be called directly, as it **is not** called by the main function. 

### utils

In some environments the main export may not be able to find a window size using the default methods. In this case, `size` will be `undefined` and the functions will not be exported.

Because of this, the functions have been exported in a separate file and can be required directly.

```js
var utils = require('window-size/utils');
console.log(utils.win());
```

[execSync]: https://nodejs.org/api/child_process.html#child_process_child_process_execsync_command_options
