/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security;

import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.GroupSet;
import org.apache.turbine.util.security.PasswordMismatchException;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.TurbineSecurityException;
import org.apache.turbine.util.security.UnknownEntityException;

public abstract class TurbineSecurity {
    public static SecurityService getService() {
        return (SecurityService)TurbineServices.getInstance().getService("SecurityService");
    }

    public static String encryptPassword(String password) {
        return TurbineSecurity.getService().encryptPassword(password);
    }

    public static Class getUserClass() throws UnknownEntityException {
        return TurbineSecurity.getService().getUserClass();
    }

    public static User getUserInstance() throws UnknownEntityException {
        return TurbineSecurity.getService().getUserInstance();
    }

    public static boolean accountExists(User user) throws DataBackendException {
        return TurbineSecurity.getService().accountExists(user);
    }

    public static boolean accountExists(String username) throws DataBackendException {
        return TurbineSecurity.getService().accountExists(username);
    }

    public static User getAuthenticatedUser(String username, String password) throws DataBackendException, UnknownEntityException, PasswordMismatchException {
        return TurbineSecurity.getService().getAuthenticatedUser(username, password);
    }

    public static User getUser(String username) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getUser(username);
    }

    public static User[] getUsers(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getUsers(criteria);
    }

    public static User getAnonymousUser() throws UnknownEntityException {
        return TurbineSecurity.getService().getAnonymousUser();
    }

    public static void saveUser(User user) throws UnknownEntityException, DataBackendException {
        TurbineSecurity.getService().saveUser(user);
    }

    public static void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        TurbineSecurity.getService().changePassword(user, oldPassword, newPassword);
    }

    public static void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        TurbineSecurity.getService().forcePassword(user, password);
    }

    public static AccessControlList getACL(User user) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getACL(user);
    }

    public static void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().grant(user, group, role);
    }

    public static void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revoke(user, group, role);
    }

    public static void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revokeAll(user);
    }

    public static void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().grant(role, permission);
    }

    public static void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revoke(role, permission);
    }

    public static void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().revokeAll(role);
    }

    public static void addUser(User user, String password) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addUser(user, password);
    }

    public static void removeUser(User user) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removeUser(user);
    }

    public static Group getGlobalGroup() {
        return TurbineSecurity.getService().getGlobalGroup();
    }

    public static Group createGroup(String name) throws TurbineSecurityException {
        return TurbineSecurity.getService().addGroup(TurbineSecurity.getNewGroup(name));
    }

    public static Permission createPermission(String name) throws TurbineSecurityException {
        return TurbineSecurity.getService().addPermission(TurbineSecurity.getNewPermission(name));
    }

    public static Group getGroup(String groupName) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getGroup(groupName);
    }

    public static Group getNewGroup(String groupName) throws DataBackendException {
        return TurbineSecurity.getService().getNewGroup(groupName);
    }

    public static Role getNewRole(String roleName) throws TurbineSecurityException {
        return TurbineSecurity.getService().getNewRole(roleName);
    }

    public static Permission getNewPermission(String permissionName) throws DataBackendException {
        return TurbineSecurity.getService().getNewPermission(permissionName);
    }

    public static Role getRole(String roleName) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getRole(roleName);
    }

    public static Permission getPermission(String permissionName) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getPermission(permissionName);
    }

    public static GroupSet getGroups(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getGroups(criteria);
    }

    public static RoleSet getRoles(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getRoles(criteria);
    }

    public static PermissionSet getPermissions(Criteria criteria) throws DataBackendException {
        return TurbineSecurity.getService().getPermissions(criteria);
    }

    public static GroupSet getAllGroups() throws DataBackendException {
        return TurbineSecurity.getService().getAllGroups();
    }

    public static RoleSet getAllRoles() throws DataBackendException {
        return TurbineSecurity.getService().getAllRoles();
    }

    public static PermissionSet getAllPermissions() throws DataBackendException {
        return TurbineSecurity.getService().getAllPermissions();
    }

    public static PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        return TurbineSecurity.getService().getPermissions(role);
    }

    public static void saveGroup(Group group) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().saveGroup(group);
    }

    public static void saveRole(Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().saveRole(role);
    }

    public static void savePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().savePermission(permission);
    }

    public static void addGroup(Group group) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addGroup(group);
    }

    public static void addRole(Role role) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addRole(role);
    }

    public static void addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        TurbineSecurity.getService().addPermission(permission);
    }

    public static void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removeGroup(group);
    }

    public static void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removeRole(role);
    }

    public static void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().removePermission(permission);
    }

    public static void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().renameGroup(group, name);
    }

    public static void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().renameRole(role, name);
    }

    public static void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        TurbineSecurity.getService().renamePermission(permission, name);
    }
}

