SET(DBUS_FOUND "NO")

SET(DBUS_PREFIX "/usr/local/dbus/" CACHE STRING
	"DBUS is installed in this prefix (if non-standard)")

SET(DBUS_SEARCH_PATHS
	${DBUS_PREFIX}/
	/sw/
	/usr/
	/usr/local/
)

FIND_PATH(DBUS_INCLUDE_DIR1
	NAMES dbus/dbus.h
	PATH_SUFFIXES /include/ /include/dbus-1.0/
	PATHS ${DBUS_SEARCH_PATHS}
)

FIND_PATH(DBUS_INCLUDE_DIR2
	NAMES dbus/dbus-arch-deps.h
	PATH_SUFFIXES /include/ /include/dbus-1.0/ /lib/dbus-1.0/include/
	PATHS ${DBUS_SEARCH_PATHS}
)

SET(DBUS_INCLUDE_DIR ${DBUS_INCLUDE_DIR1} ${DBUS_INCLUDE_DIR2})

FIND_LIBRARY(DBUS_LIBRARY
	NAMES dbus dbus-1
	PATH_SUFFIXES /lib/ /lib/dbus-1.0/
	PATHS ${DBUS_SEARCH_PATHS}
)


IF(DBUS_LIBRARY AND DBUS_INCLUDE_DIR)
  SET(DBUS_FOUND "YES")
ENDIF(DBUS_LIBRARY AND DBUS_INCLUDE_DIR)

IF(DBUS_FOUND)
  IF(NOT DBUS_FIND_QUIETLY)
    MESSAGE(STATUS "Found DBUS: ${DBUS_LIBRARY},${DBUS_LIBRARY}")
  ENDIF(NOT DBUS_FIND_QUIETLY)
ELSE(DBUS_FOUND)
  IF(DBUS_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find DBUS Library")
  ENDIF(DBUS_FIND_REQUIRED)
ENDIF(DBUS_FOUND)

