/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_RegisteredSensorsProfile.h"
#include "OpenDRIM_RegisteredSensorsProfileAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define Sensors_OpenDRIM_RegisteredSensorsProfileProviderSetInstance Sensors_OpenDRIM_RegisteredSensorsProfileProviderModifyInstance
#endif

int Sensors_OpenDRIM_RegisteredSensorsProfile_init(const CMPIBroker* broker);

int Sensors_OpenDRIM_RegisteredSensorsProfile_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_RegisteredSensorsProfile> instances;
	string errorMessage;
	
	int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = Sensors_OpenDRIM_RegisteredSensorsProfile_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_RegisteredSensorsProfile> instances;
	string errorMessage;
	
	int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = Sensors_OpenDRIM_RegisteredSensorsProfile_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredSensorsProfile instance;
	Sensors_OpenDRIM_RegisteredSensorsProfile_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = Sensors_OpenDRIM_RegisteredSensorsProfile_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredSensorsProfile newInstance, oldInstance;
	Sensors_OpenDRIM_RegisteredSensorsProfile_toCPP(_broker, ci, newInstance);
	Sensors_OpenDRIM_RegisteredSensorsProfile_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredSensorsProfile instance;
	Sensors_OpenDRIM_RegisteredSensorsProfile_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = Sensors_OpenDRIM_RegisteredSensorsProfile_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_RegisteredSensorsProfile instance;
	Sensors_OpenDRIM_RegisteredSensorsProfile_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Sensors_OpenDRIM_RegisteredSensorsProfileProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int Sensors_OpenDRIM_RegisteredSensorsProfile_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "Sensors_OpenDRIM_RegisteredSensorsProfile_init FAILED: " + (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_RegisteredSensorsProfile_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = Sensors_OpenDRIM_RegisteredSensorsProfile_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "Sensors_OpenDRIM_RegisteredSensorsProfile_unload FAILED: " + (string) OpenDRIM_RegisteredSensorsProfile_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define Sensors_OpenDRIM_RegisteredSensorsProfile_INIT if (Sensors_OpenDRIM_RegisteredSensorsProfile_init(_broker) < 0) return NULL

CMInstanceMIStub(Sensors_OpenDRIM_RegisteredSensorsProfileProvider, Sensors_OpenDRIM_RegisteredSensorsProfileProvider, _broker, Sensors_OpenDRIM_RegisteredSensorsProfile_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
